﻿'use strict';

var app = angular.module('DevicesApp', []);

// SignalR server URL: app.value('devicesServer', 'http://myserver.com:19999/');
app.value('devicesServer', '');

app.run(function ($rootScope) {

    $rootScope.imagesUrl = ["expand.png", "collapse.png"];
    $rootScope.imageIndex = [];
    $rootScope.image = [];
    $rootScope.categoryIndicator = [];
    $rootScope.categoryIndicatorAsString = [];
    $rootScope.allDevices = [];
	
    // Start hub and call .NET method of this hub.
    $.connection.hub.start()
        .done(function () {
            $.connection.devicesHub.server.init();
        });
});

var devicesServer = app.factory('devicesHubProxy', ['$rootScope', 'devicesServer', function ($rootScope, devicesServer) {
    function devicesHubProxyFactory(serverUrl, hubName, startOptions) {
        var connection = $.hubConnection(devicesServer);
        var proxy = connection.createHubProxy(hubName);
        connection.start(startOptions).done(function () { });

        return {
            on: function (eventName, callback) {
                proxy.on(eventName, function (result) {
                    $rootScope.$apply(function () {
                        if (callback) {
                            callback(result);
                        }
                    });
                });
            },
            off: function (eventName, callback) {
                proxy.off(eventName, function (result) {
                    $rootScope.$apply(function () {
                        if (callback) {
                            callback(result);
                        }
                    });
                });
            },
            invoke: function (methodName, callback) {
                proxy.invoke(methodName)
                    .done(function (result) {
                        $rootScope.$apply(function () {
                            if (callback) {
                                callback(result);
                            }
                        });
                    });
            },
            connection: connection
        };
    };

    return devicesHubProxyFactory;
}]);

devicesServer.controller('DevicesController', function ($rootScope, $scope, devicesHubProxy) {
    var devicesHub = devicesHubProxy(devicesHubProxy.defaultServer, 'devicesHub');

    $scope.getServerTime = function () {
        devicesHub.invoke('getServerTime', function (data) {
            $scope.currentServerTime = data;
        });
    };
	
	devicesHub.on('all', function (lst) {
				
	    $rootScope.allCategoriesInfo = lst[0];

		if ($rootScope.allCategoriesInfo != null)
			for (var i = 0; i < $rootScope.allCategoriesInfo.length; i++) {
				$rootScope.imageIndex.push(0);
				$rootScope.image.push($rootScope.imagesUrl[0]);
				$rootScope.categoryIndicator.push(0);
				$rootScope.categoryIndicatorAsString.push('NoData');
			}
			
		$rootScope.allDevicesInfo = lst[1];	
					
		$scope.allDevicesFunc(lst[2]);
	});
	
	devicesHub.on('allDevices', function (devices) {	
	    $scope.allDevicesFunc(devices);
	});

	devicesHub.on('serverTime', function (timeAsString) {
	    $scope.currentServerTime = timeAsString;
	});
			
	$scope.init = function() {
		    $scope.devicesHub.invoke('init', function (data) {
        });
	};
   
    if ($rootScope.image.length > 0)
        $scope.image = $rootScope.image;

    $scope.categoryIndicator = $rootScope.categoryIndicator;
    $scope.categoryIndicatorAsString = $rootScope.categoryIndicatorAsString;
	
    $scope.allDevicesFunc = function (devices) {
	
        $rootScope.allDevices = devices;
			
		if ($rootScope.allDevicesInfo != null && $rootScope.allDevices != null && $rootScope.allCategoriesInfo != null && 
			$rootScope.allDevicesInfo.length == $rootScope.allDevices.length && $rootScope.allDevices.length > 0) {
			
			// Overall category indicator
			for (var i = 0; i < $rootScope.allCategoriesInfo.length; i++) {
				$rootScope.categoryIndicator[i] = 0;

				for (var j = 0; j < $rootScope.allDevices.length; j++) {

					if ($rootScope.allCategoriesInfo[i].Id == $rootScope.allDevicesInfo[j].CategoryId &&
						$rootScope.allDevices[j].Status >= $rootScope.categoryIndicator[i]) {
						
						$rootScope.categoryIndicator[i] = $rootScope.allDevices[j].Status;
						$rootScope.categoryIndicatorAsString[i] = $rootScope.allDevices[j].StatusAsString;
					}
				}
			}
		}
	};
	
    $scope.toggleImage = function (categoryIndex) {
        $rootScope.imageIndex[categoryIndex] = ($rootScope.imageIndex[categoryIndex] + 1) % 2;
        $rootScope.image[categoryIndex] = $rootScope.imagesUrl[$rootScope.imageIndex[categoryIndex]];
    };
});





