﻿using System.Linq;
using Microsoft.AspNet.SignalR;
using DeviceModel;
using DashboardApp.DataProviders;

namespace DashboardApp.Hubs
{
    public class ConnectivityHub : Hub
    {
        public void RegisterDeviceWithDashboard(DeviceInfo di) 
        {
            if (di == null)
                return;

            DeviceDataProvider.Instance.AddDevicesInfo(di);

            DeviceDataProvider.Instance.Update<DevicesHub>();
        }

        public void SetDeviceStatus(int deviceId, int status) 
        {
            DeviceDataProvider.Instance[deviceId] = (DeviceStatus)status;
        }
    }
}