﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web.Http;

namespace DashboardApp
{
    public static class WebApiConfig
    {
        public static void Register(HttpConfiguration config)
        {
            // Web API configuration and services

            // Web API routes
            config.MapHttpAttributeRoutes();

            config.Routes.MapHttpRoute(
                name: "DefaultApi",
                routeTemplate: "api/{controller}/{id}",
                defaults: new { id = RouteParameter.Optional }
            );

            config.Routes.MapHttpRoute(
                name: "1",
                routeTemplate: "api/{controller}/{action}",
                defaults: new { action = "get" }
            );

            config.Routes.MapHttpRoute(
                name: "2",
                routeTemplate: "api/{controller}/{data}",
                defaults: new { action = "get", data = RouteParameter.Optional }
            );

            config.Routes.MapHttpRoute(
                name: "3",
                routeTemplate: "api/{controller}/{action}/{data}",
                defaults: new { data = RouteParameter.Optional }
            );
        }
    }
}
