﻿using System;
using System.Text;
using System.Web;
using System.Web.Mvc;

namespace DownloadProgress.Controllers
{
    public class HomeController : Controller
    {
        public ActionResult Index()
        {
            return View();
        }

        [HttpPost]
        public FileResult Download(string cookieValue)
        {
            // wait 10 seconds to simulate a long running operation
            System.Threading.Thread.Sleep(10000);

            // create a dummy text file to download
            StringBuilder sb = new StringBuilder();
            sb.AppendLine("This is a demo file that has been generated on the server.");
            sb.AppendLine();
            for (int i = 1; i <= 1000; i++)
            {
                sb.AppendLine("Line " + i.ToString() + "  " + DateTime.Now.ToString());
            }

            // add a cookie with the name 'dlc' and the value from the postback
            ControllerContext.HttpContext.Response.Cookies.Add(new HttpCookie("dlc", cookieValue));

            return File(Encoding.ASCII.GetBytes(sb.ToString()), "text/plain", "data.txt");
        }
    }
}