﻿// <reference path="../angular.js" />  
/// <reference path="../angular.min.js" />   
/// <reference path="../angular-animate.js" />   
/// <reference path="../angular-animate.min.js" />   
var app;
(function () {
    app = angular.module("AngularJs_Module", ['ngAnimate']);
})();


app.controller("AngularJs_Controller", function ($scope, $timeout, $rootScope, $window, $http, FileUploadService) {
    $scope.date = new Date();
    $scope.MyName = "shanu";
    $scope.sImage = "";
   

    $scope.showKidsAdd = true;
    $scope.addEditKids = false;
    $scope.KidsList = true;
    $scope.showItem = true;
    $scope.userRoleName = $("#txtuserRoleName").val();
    //This variable will be used for Insert/Edit/Delete Kids Learn Question details.  
    $scope.kidsIdentitys = 0;
    $scope.UImage = "";
    $scope.Answer = "";
    $scope.Question = "";
   


    // This method is to get all the kids Learn Details to display for CRUD. 
    selectKidsLearnDetails($scope.sImage);   
    

    function selectKidsLearnDetails(IMAGENAME) {
        $http.get('/api/KidsLearnAPI/getKIDSLEARNSelectALL/', { params: { IMAGENAME: IMAGENAME } }).success(function (data) {
            $scope.KidsLearnData = data;
            $scope.showKidsAdd = true;
            $scope.addEditKids = false;
            $scope.KidsList = true;
            $scope.showItem = true;

            if ($scope.KidsLearnData.length > 0) {
            }
        })
   .error(function () {
       $scope.error = "An Error has occured while loading posts!";
   });
    }

    //Search
    $scope.searchKidsLearnDetails = function () {
        selectKidsLearnDetails($scope.sImage);
    }


    // New Kids Details Add Details
    $scope.showKidsAddDetails = function () {
        cleardetails();
        $scope.showKidsAdd = true;
        $scope.addEditKids = true;
        $scope.KidsList = true;
        $scope.showItem = true;
    }

    //clear all the control values after insert and edit.
    function cleardetails() {
        $scope.kidsIdentitys = 0;
        $scope.UImage = "";
        $scope.Answer = "";
        $scope.Question = "";
        $scope.IsFormSubmitted = false;
        //////angular.forEach(angular.element("input[type='file']"), function (inputElem) {
        //////    angular.element(inputElem).val(null);
        //});
    }


    //Edit Kids  Details
    $scope.KidsEdit = function KidsEdit(kidsIdentity,  IMAGENAME,  ANSWER,  HINTQUESTION) {
        cleardetails();
        $scope.kidsIdentitys = kidsIdentity;
        $scope.UImage = IMAGENAME;
        $scope.Answer = ANSWER;
        $scope.Question = HINTQUESTION;


        $scope.showKidsAdd = true;
        $scope.addEditKids = true;
        $scope.KidsList = true;
        $scope.showItem = true;
    }

    //Delete Menu Detail
    $scope.KidsDelete = function KidsDelete(kidsIdentity) {
        cleardetails();
        $scope.kidsIdentitys = kidsIdentity;
        var delConfirm = confirm("Are you sure you want to delete the Kids Lear Detail ?");
        if (delConfirm == true) {

            $http.get('/api/KidsLearnAPI/deleteKIDSLEARN/', { params: { kidsIdentity: $scope.kidsIdentitys } }).success(function (data) {
                alert("Kids Detail Deleted Successfully!!");
                cleardetails();
                selectKidsLearnDetails('');
            })
      .error(function () {
          $scope.error = "An Error has occured while loading posts!";
      });

        }
    }

    //Declarationa and Function for Image Upload and Save Data
    //--------------------------------------------
    // Variables
    $scope.Message = "";
    $scope.FileInvalidMessage = "";
    $scope.SelectedFileForUpload = null;
    $scope.FileDescription_TR = "";
    $scope.IsFormSubmitted = false;
    $scope.IsFileValid = false;
    $scope.IsFormValid = false;

    //Form Validation
    $scope.$watch("f1.$valid", function (isValid) {
        $scope.IsFormValid = isValid;
    });


    // THIS IS REQUIRED AS File Control is not supported 2 way binding features of Angular
    // ------------------------------------------------------------------------------------
    //File Validation
    $scope.ChechFileValid = function (file) {
        var isValid = false;
        if ($scope.SelectedFileForUpload != null) {
            if ((file.type == 'image/png' || file.type == 'image/jpeg' || file.type == 'image/gif') && file.size <= (800 * 800)) {
                $scope.FileInvalidMessage = "";
                isValid = true;
            }
            else {
                $scope.FileInvalidMessage = "Only JPEG/PNG/Gif Image can be upload )";
            }
        }
        else {
            $scope.FileInvalidMessage = "Image required!";
        }
        $scope.IsFileValid = isValid;
    };

    //File Select event 
    $scope.selectFileforUpload = function (file) {

        var files = file[0];
        $scope.Imagename = files.name;
    //    alert($scope.Imagename);
        $scope.SelectedFileForUpload = file[0];

    }
    //----------------------------------------------------------------------------------------

    //Save File
    $scope.saveDetails = function () {
     
        $scope.IsFormSubmitted = true;
     
        $scope.Message = "";
        $scope.ChechFileValid($scope.SelectedFileForUpload);
     
        if ($scope.IsFormValid && $scope.IsFileValid) {
            FileUploadService.UploadFile($scope.SelectedFileForUpload).then(function (d) {

                //if the MenuIdentity ID=0 means its new Menu insert here i will call the Web api insert method
                if ($scope.kidsIdentitys == 0) {

                    $http.get('/api/KidsLearnAPI/insertKIDSLEARN/', { params: { IMAGENAME: $scope.Imagename, ANSWER: $scope.Answer, HINTQUESTION: $scope.Question } }).success(function (data) {

                        $scope.menuInserted = data;
                        alert($scope.menuInserted);


                        cleardetails();
                        selectKidsLearnDetails('');
                    })
             .error(function () {
                 $scope.error = "An Error has occured while loading posts!";
             });
                }


                else {  // to update to the Menu details
                    $http.get('/api/KidsLearnAPI/updateKIDSLEARN/', { params: { kidsIdentity: $scope.kidsIdentitys, IMAGENAME: $scope.Imagename, ANSWER: $scope.Answer, HINTQUESTION: $scope.Question } }).success(function (data) {
                        $scope.menuUpdated = data;
                        alert($scope.menuUpdated);

                        cleardetails();
                        selectKidsLearnDetails('');
                    })
            .error(function () {
                $scope.error = "An Error has occured while loading posts!";
            });
                }

            }, function (e) {
                alert(e);
            });
        }
        else {
            $scope.Message = "All the fields are required.";
        }

    };

})

.factory('FileUploadService', function ($http, $q) {
  
    var fac = {};
    fac.UploadFile = function (file) {
        var formData = new FormData();
        formData.append("file", file);

        var defer = $q.defer();
        $http.post("/KidslearnAdmin/UploadFile", formData,
            {
                withCredentials: true,
                headers: { 'Content-Type': undefined },
                transformRequest: angular.identity
            })
        .success(function (d) {
            defer.resolve(d);
        })
        .error(function () {
            defer.reject("File Upload Failed!");
        });

        return defer.promise;

    }
    return fac;

    //---------------------------------------------
    //End of Image Upload and Insert record



});