﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Net.Http;
using System.Web.Http;

namespace shanuEasyKidsLearnerMVCAngularJS.Controllers
{
    public class KidsLearnAPIController : ApiController
    {
		KidsLearnerDBEntitiesN objapi = new KidsLearnerDBEntitiesN();

		// to Search all Kids learn Details
		[HttpGet]
		public IEnumerable<USP_KIDSLEARN_SelectALL_Result> getKIDSLEARNSelectALL(string IMAGENAME)
		{
			if (IMAGENAME == null)
				IMAGENAME = "";

			return objapi.USP_KIDSLEARN_SelectALL(IMAGENAME).AsEnumerable();
		}

		// To select top 10 random results
		[HttpGet]
		public IEnumerable<USP_KIDSLEARN_Select_Result> getKIDSLEARNSelect(string IMAGENAME)
		{
			if (IMAGENAME == null)
				IMAGENAME = "";
			return objapi.USP_KIDSLEARN_Select(IMAGENAME).AsEnumerable();
		}


		// To insertKIDSLEARN
		[HttpGet]
		public IEnumerable<string> insertKIDSLEARN(string IMAGENAME, string ANSWER, string HINTQUESTION)
		{
			return objapi.USP_KIDSLEARN_Insert(IMAGENAME, ANSWER, HINTQUESTION).AsEnumerable();
		}

		//to Update updateKIDSLEARN
		[HttpGet]
		public IEnumerable<string> updateKIDSLEARN(string kidsIdentity, string IMAGENAME, string ANSWER, string HINTQUESTION)
		{
			return objapi.USP_KIDSLEARN_Update(kidsIdentity, IMAGENAME, ANSWER, HINTQUESTION).AsEnumerable();
		}


		//to Update deleteKIDSLEARN
		[HttpGet]
		public string deleteKIDSLEARN(string kidsIdentity)
		{
			objapi.USP_KIDSLEARN_Delete(kidsIdentity);
			objapi.SaveChanges();
			return "deleted";
		}
	}
}
