﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

using CSE.Partial.WebApp.Models;
using CSE.Partial.Service;

namespace CSE.Partial.WebApp.Controllers
{
    public class TestController : Controller
    {
        [HttpGet]
        public ActionResult Index()
        {
            ITestService srv = new ServiceContext();

            // load the test data
            TestViewModel model = new TestViewModel
            {
                Test = srv.SelectTest(42)
            };

            return View(model);
        }


        [HttpPost]
        public ActionResult Index(TestViewModel model)
        {
            if (ModelState.IsValid)
            {
                // save the test data
                ITestService srv = new ServiceContext();

                srv.UpdateTest(model.Test);
            }

            return View(model);
        }
    }
}