﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

using CSE.Partial.Service;
using CSE.Partial.WebApp.Models;

namespace CSE.Partial.WebApp.Controllers
{
    public class NestedPartialController : Controller
    {
        [HttpGet]
        public ActionResult Partial()
        {
            IPartialService srv = new ServiceContext();

            PartialViewModel model = new PartialViewModel
            {
                Partial = srv.SelectPartial(21)
            };

            LoadNonPersistentData(model);
            return View(model);
        }

        [HttpPost]
        public ActionResult Partial(PartialViewModel model)
        {
            if (ModelState.IsValid)
            {
                IPartialService srv = new ServiceContext();

                srv.UpdatePartial(model.Partial);
            }

            LoadNonPersistentData(model);
            return View(model);
        }


        private void LoadNonPersistentData(PartialViewModel model)
        {
            IPartialService srv = new ServiceContext();

            this.ViewBag.AvailableItems = srv.SelectAvailableItems();
        }
    }
}