﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

using CSE.Partial.Service;
using CSE.Partial.WebApp.Models;

namespace CSE.Partial.WebApp.Controllers
{
    public class HomeController : Controller
    {
        public ActionResult Index()
        {
            return View();
        }

        public ActionResult About()
        {
            ViewBag.Message = "Your application description page.";

            return View();
        }


        [HttpGet]
        public ActionResult Partial()
        {
            IHomeService srv = new ServiceContext();

            SalesAddressViewModel model = new SalesAddressViewModel
            {
                SalesAddress = srv.SelectSalesAddress(69)
            };

            return View(model);
        }

        [HttpPost]
        public ActionResult Partial(SalesAddressViewModel model)
        {
            if (ModelState.IsValid)
            {
                IHomeService srv = new ServiceContext();

                srv.UpdateSalesAddress(model.SalesAddress);
            }

            return View(model);
        }
    }
}