﻿
using CSE.Partial.Service.Models;

namespace CSE.Partial.Service
{
    public interface ITestService
    {
        TestModel SelectTest(int id);

        int UpdateTest(TestModel model);
    }

    public partial class ServiceContext : ITestService
    {
        TestModel ITestService.SelectTest(int id)
        {
            // test data
            return new TestModel
            { 
                Name = "Test data",
                Partial = new TestPartialModel
                {
                    Name = "Partial data"
                }
            };
        }

        int ITestService.UpdateTest(TestModel model)
        {
            // nothing to do for test

            return 42;  // test id
        }
    }
}
