﻿using System.Collections.Generic;
using System.Web.Mvc;

using CSE.Partial.Service.Models;

namespace CSE.Partial.Service
{
    public interface IPartialService
    {
        PartialModel SelectPartial(int id);

        int UpdatePartial(PartialModel model);

        List<SelectListItem> SelectAvailableItems();
    }

    public partial class ServiceContext : IPartialService
    {
        PartialModel IPartialService.SelectPartial(int id)
        {
            return new PartialModel
            {
                Id = 0,
                Name = "Base",
                First = new FirstPartialModel
                {
                    Id1 = 1,
                    Name1 = "First",
                    Second = new SecondPartialModel
                    {
                        Id2 = 2,
                        Name2 = "Second",
                    }
                }
            };
        }

        int IPartialService.UpdatePartial(PartialModel model)
        {
            // nothing to do for test

            return 21;  // test id
        }


        List<SelectListItem> IPartialService.SelectAvailableItems()
        {
            return new List<SelectListItem>
            {
                new SelectListItem { Text = "Bhuna", Value = "1"},
                new SelectListItem { Text = "Ceylon", Value = "2"},
                new SelectListItem { Text = "Korma", Value = "3"},
                new SelectListItem { Text = "Madras", Value = "4"},
                new SelectListItem { Text = "Patia", Value = "5"},
                new SelectListItem { Text = "Rogan Josh", Value = "6"},
                new SelectListItem { Text = "Vindaloo", Value = "7"}
            };
        }
    }
}
