﻿using CSE.Partial.Service.Models;

namespace CSE.Partial.Service
{
    public interface IHomeService
    {
        SalesAddressModel SelectSalesAddress(int id);

        int UpdateSalesAddress(SalesAddressModel model);
    }

    public partial class ServiceContext : IHomeService
    {
        SalesAddressModel IHomeService.SelectSalesAddress(int id)
        {
            return new SalesAddressModel
            {
                Id = -1,
                Name = "Cambridge Software Engineering",
                Telephone = "01223 968 100",
                Email = "sales@cambseng.com",
                Address = new AddressModel
                {
                    Id = -1,
                    AddressLine1 = "Sumpter House",
                    AddressLine2 = "8 Station Road",
                    Town = "Histon",
                    County = "Cambridge",
                    Country = "UK",
                    Postcode = "CB24 9LQ"
                }
            };
        }

        int IHomeService.UpdateSalesAddress(SalesAddressModel model)
        {
            // nothing to do for test

            return 69;  // test id
        }
    }
}
