﻿using System.ComponentModel.DataAnnotations;

using CSE.Library;

namespace CSE.Partial.Service.Models
{
    public class SalesAddressModel
    {
        public int Id { get; set; }

        [Display(Name = "Name:")]
        [Required(ErrorMessage = "Please supply a name")]
        [MaxLength(50)]
        public string Name { get; set; }

        [Display(Name = "Telephone:")]
        [Required(ErrorMessage = "Please supply an email address")]
        [RegularExpression(Constants.REGEX_UK_PHONE_NUMBER, ErrorMessage = "Invalid uk phone number")]
        [MaxLength(20)]
        public string Telephone { get; set; }

        [Display(Name = "Email:")]
        [Required(ErrorMessage = "Please supply an email address")]
        [DataType(DataType.EmailAddress)]
        [RegularExpression(Constants.REGEX_EMAIL_ADDRESS, ErrorMessage = "Invalid email address")]
        [MaxLength(100)]
        public string Email { get; set; }


        // common postal address
        public AddressModel Address { get; set; }
    }
}