﻿using System.ComponentModel.DataAnnotations;

namespace CSE.Partial.Service.Models
{
    public class AddressModel
    {
        public int Id { get; set; }

        [Display(Name = "Line 1:")]
        [Required(ErrorMessage = "Please supply line 1")]
        [MaxLength(30)]
        public string AddressLine1 { get; set; }

        [Display(Name = "Line 2:")]
        [MaxLength(30)]
        public string AddressLine2 { get; set; }

        [Display(Name = "Line 3:")]
        [MaxLength(30)]
        public string AddressLine3 { get; set; }

        [Display(Name = "Town:")]
        [Required(ErrorMessage = "Please supply a town")]
        [MaxLength(30)]
        public string Town { get; set; }

        [Display(Name = "County:")]
        [Required(ErrorMessage = "Please supply a county")]
        [MaxLength(30)]
        public string County { get; set; }

        [Display(Name = "Country:")]
        [Required(ErrorMessage = "Please supply a country")]
        [MaxLength(30)]
        public string Country { get; set; }

        [Display(Name = "Postcode:")]
        [Required(ErrorMessage = "Please supply a postcode")]
        [MaxLength(8)]
        public string Postcode { get; set; }
    }
}