﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace CSE.Library
{
    public static class Constants
    {
        public const string DATE_FORMAT = "dd MMM yyyy";
        public const string DATE_FORMAT_BRACED = "{0:dd MMM yyyy}";
        public const string TIME_FORMAT = "HH:mm";
        public const string DATE_TIME_FORMAT = "dd MMM yyyy HH:mm";
        public const string JS_DATE_FORMAT = "dd M yy";
        public const string JS_TIME_FORMAT = "HH:mm";
        public const string APPLICATION_NAME = "Bootstrap Application";
        public const string PLEASE_SELECT = "Please Select...";


        // Regular Expressions

        public const string REGEX_PASSWORD = @"^.*(?=.*[a-z])(?=.*[A-Z])(?=.*\d.*\d).*$";

        //  ^               start
        //  .               Matches any single character except a newline character.
        //  *               Matches the preceding character zero or more times.
        //  ?=              A positive lookahead
        //  (?=.*[a-z])     Must have one or more a-z
        //  (?=.*[A-Z])     Must have one or more A-Z
        //  (?=.*\d.*\d)    Must have 2 or more digits
        //  .               Any other characters are valid
        //  $               finish


        // http://msdn.microsoft.com/en-us/library/01escwtf.aspx
        public const string REGEX_EMAIL_ADDRESS = @"^(?("")(""[^""]+?""@)|(([0-9a-zA-Z]((\.(?!\.))|[-!#\$%&'\*\+/=\?\^`\{\}\|~\w])*)(?<=[0-9a-zA-Z])@)"
            + @")(?(\[)(\[(\d{1,3}\.){3}\d{1,3}\])|(([0-9a-zA-Z][-\w]*[0-9a-zA-Z]*\.)+[a-zA-Z0-9]{2,17}))$";

        public const string REGEX_PIN = @"^\d\d\d\d$";

        // This will check for 10 or 11 digit numbers, starting with a zero, with formatting spaces between any of the digits, and optionally a set of brackets for the area code.
        public const string REGEX_UK_PHONE_NUMBER = @"^\(?0( *\d\)?){9,10}$";
    }
}