var timeago = require('../../');

module.exports = function(t) {
  var tm = timeago('2016-06-20 12:30:00', 'bg');
  tm.register('bg', require('../../locales/bg'));

  // test second
  t.equal(tm.format('2016-06-20 12:30:00'), 'току що');
  t.equal(tm.format('2016-06-20 12:29:50'), 'преди 10 секунди');
  t.equal(tm.format('2016-06-20 12:29:39'), 'преди 21 секунди');
  t.equal(tm.format('2016-06-20 12:29:38'), 'преди 22 секунди');
  t.equal(tm.format('2016-06-20 12:30:01'), 'съвсем скоро');
  t.equal(tm.format('2016-06-20 12:30:10'), 'след 10 секунди');
  t.equal(tm.format('2016-06-20 12:30:21'), 'след 21 секунди');
  t.equal(tm.format('2016-06-20 12:30:22'), 'след 22 секунди');

  // test minute
  t.equal(tm.format('2016-06-20 12:29:00'), 'преди 1 минута');
  t.equal(tm.format('2016-06-20 12:28:00'), 'преди 2 минути');
  t.equal(tm.format('2016-06-20 12:25:00'), 'преди 5 минути');
  t.equal(tm.format('2016-06-20 12:9:00'), 'преди 21 минути');
  t.equal(tm.format('2016-06-20 12:31:00'), 'след 1 минута');
  t.equal(tm.format('2016-06-20 12:32:00'), 'след 2 минути');
  t.equal(tm.format('2016-06-20 12:35:00'), 'след 5 минути');
  t.equal(tm.format('2016-06-20 12:51:00'), 'след 21 минути');

  // test hour
  t.equal(tm.format('2016-06-20 11:30:00'), 'преди 1 час');
  t.equal(tm.format('2016-06-20 10:30:00'), 'преди 2 часа');
  t.equal(tm.format('2016-06-20 7:30:00'), 'преди 5 часа');
  t.equal(tm.format('2016-06-19 15:30:00'), 'преди 21 часа');
  t.equal(tm.format('2016-06-20 13:30:00'), 'след 1 час');
  t.equal(tm.format('2016-06-20 14:30:00'), 'след 2 часа');
  t.equal(tm.format('2016-06-20 17:30:00'), 'след 5 часа');
  t.equal(tm.format('2016-06-21 9:30:00'), 'след 21 часа');

  // test day
  t.equal(tm.format('2016-06-19 12:30:00'), 'преди 1 ден');
  t.equal(tm.format('2016-06-18 12:30:00'), 'преди 2 дни');
  t.equal(tm.format('2016-06-15 12:30:00'), 'преди 5 дни');
  t.equal(tm.format('2016-06-21 12:30:00'), 'след 1 ден');
  t.equal(tm.format('2016-06-22 12:30:00'), 'след 2 дни');
  t.equal(tm.format('2016-06-25 12:30:00'), 'след 5 дни');

  // test week
  t.equal(tm.format('2016-06-13 12:30:00'), 'преди 1 седмица');
  t.equal(tm.format('2016-06-06 12:30:00'), 'преди 2 седмици');
  t.equal(tm.format('2016-06-27 12:30:00'), 'след 1 седмица');
  t.equal(tm.format('2016-07-04 12:30:00'), 'след 2 седмици');

  // test month
  t.equal(tm.format('2016-05-20 12:30:00'), 'преди 1 месец');
  t.equal(tm.format('2016-04-20 12:30:00'), 'преди 2 месеца');
  t.equal(tm.format('2016-01-19 12:30:00'), 'преди 5 месеца');
  t.equal(tm.format('2016-07-21 12:30:00'), 'след 1 месец');
  t.equal(tm.format('2016-08-20 12:30:00'), 'след 2 месеца');
  t.equal(tm.format('2016-11-20 12:30:00'), 'след 5 месеца');

  // test year
  t.equal(tm.format('2015-06-20 12:30:00'), 'преди 1 година');
  t.equal(tm.format('2014-06-20 12:30:00'), 'преди 2 години');
  t.equal(tm.format('2011-06-20 12:30:00'), 'преди 5 години');
  t.equal(tm.format('1995-06-20 12:30:00'), 'преди 21 години');
  t.equal(tm.format('2017-06-20 12:30:00'), 'след 1 година');
  t.equal(tm.format('2018-06-20 12:30:00'), 'след 2 години');
  t.equal(tm.format('2021-06-20 12:30:00'), 'след 5 години');
  t.equal(tm.format('2037-06-20 12:30:00'), 'след 21 години');
};
