/**
 * @file ZingTouch.js
 * Main object containing API methods and Gesture constructors
 */

import Region from './core/classes/Region.js';
import Gesture from './gestures/Gesture.js';
import Expand from './gestures/Expand.js';
import Pan from './gestures/Pan.js';
import Pinch from './gestures/Pinch.js';
import Rotate from './gestures/Rotate.js';
import Swipe from './gestures/Swipe.js';
import Tap from './gestures/Tap.js';

/**
 * The global API interface for ZingTouch. Contains a constructor for the Region Object,
 * and constructors for each predefined Gesture.
 * @type {Object}
 * @namespace ZingTouch
 */
var ZingTouch = {
  _regions: [],

  //Constructors
  Gesture: Gesture,
  Expand: Expand,
  Pan: Pan,
  Pinch: Pinch,
  Rotate: Rotate,
  Swipe: Swipe,
  Tap: Tap,
  Region: function (element, capture, preventDefault) {
    var id = ZingTouch._regions.length;
    var region = new Region(element, capture, preventDefault, id);
    ZingTouch._regions.push(region);
    return region;
  }
};

export default ZingTouch;
