﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using DataAccess.Interface;
using EntityModel.DomainModel;

namespace UI.Controllers
{
    public class CompanyController : Controller
    {
        private ICompanyRepository _repo;
        public CompanyController(ICompanyRepository repo)
        {
            _repo = repo;
        }

        [HttpGet]
        public ActionResult GetCompanies()
        {
            try
            {
                return View("GetCompanies", _repo.GetCompanies());
            }
            catch (Exception exception)
            {
                Console.WriteLine(exception.Message);
            }
            return null;
        }

        [HttpGet]
        [ActionName("CompanyDetails")]
        public ActionResult GetCompanyById(int id)
        {
            Company company = GetCompanyDetails(id);
            return View("CompanyDetails", company);
        }

        public Company GetCompanyDetails(int id)
        {
            return _repo.GetCompanyById(id);
        }

        [HttpGet]
        [ActionName("InsertCompany")]
        public ActionResult InsertCompany()
        {
            return View();
        }

        [HttpPost]
        [ActionName("InsertCompany")]
        public ActionResult InsertCompany(Company newCompany)
        {
            if (!ModelState.IsValid) return View("InsertCompany", newCompany);
            var companyId = _repo.InsertCompany(newCompany);
            if (companyId > 0)
                return RedirectToAction("GetCompanies", "Company");
            return View("InsertCompany", newCompany);
        }

        [HttpGet]
        [ActionName("UpdateCompany")]
        public ActionResult UpdateCompany(int id)
        {
            Company company = GetCompanyDetails(id);
            return View(company);
        }

        [HttpPost]
        [ActionName("UpdateCompany")]
        public ActionResult UpdateCompany(Company exCompany)
        {
            if (!ModelState.IsValid) return View("UpdateCompany", exCompany);
            var companyId = _repo.UpdateCompany(exCompany);
            if (companyId > 0)
                return RedirectToAction("GetCompanies", "Company");
            return View("UpdateCompany", exCompany);
        }

        [HttpGet]
        [ActionName("DeleteCompany")]
        public ActionResult DeleteCompany(int id)
        {
            var companyId = _repo.DeleteCompany(id);
            return RedirectToAction("GetCompanies", "Company");
        }
    }
}