﻿using System;
using System.Collections.Generic;
using System.Data.Entity;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using DataAccess.Abstract;
using DataAccess.Interface;
using EntityModel.DomainModel;

namespace DataAccess.Repository.EF
{
    public class CompanyEfRepository : EfRepositoryBase<Company>, ICompanyRepository
    {
        public CompanyEfRepository(DiContext dbCtx) : base(dbCtx)
        {
        }

        public List<Company> GetCompanies()
        {
            List<Company> companies = Context.Company.ToList();
            return companies;
        }

        public Company GetCompanyById(int id)
        {
            return Context.Company.FirstOrDefault(c => c.Id == id);
        }

        public int InsertCompany(Company company)
        {
            Context.Company.Add(company);
            return Context.SaveChanges();
        }

        public int UpdateCompany(Company company)
        {
            Context.Entry(company).State = EntityState.Modified;
            return Context.SaveChanges();
        }

        public bool DeleteCompany(int id)
        {
            Company itemToDelete = Context.Company.SingleOrDefault(c => c.Id == id);
            Context.Entry(itemToDelete).State = EntityState.Deleted;
            return (Context.SaveChanges() > 0);
        }
    }
}