﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Dapper;
using DataAccess.Abstract;
using DataAccess.Interface;
using EntityModel.DomainModel;

namespace DataAccess.Repository.Dapper.MSSQL
{
    public class CompanySqlRepository : DapperRepositoryBase, ICompanyRepository
    {
        public CompanySqlRepository(IDbConnection conn, string conString)
        {
            _connection = conn;
            _connection.ConnectionString = conString;
        }

        public List<Company> GetCompanies()
        {
            return Query<Company>("usp_GetAllCompanies").ToList();
        }

        public Company GetCompanyById(int id)
        {
            return Query<Company>("usp_GetCompanyById", new { CompanyId = id }).FirstOrDefault();
        }

        public int InsertCompany(Company company)
        {
            var parameters = new DynamicParameters();
            parameters.Add("Name", company.Name, DbType.String, ParameterDirection.Input);
            parameters.Add("Description", company.Description, DbType.String, ParameterDirection.Input);
            parameters.Add("CreatedBy", company.CreatedBy, DbType.Int32, ParameterDirection.Input);
            parameters.Add("CreatedDate", company.CreatedDate, DbType.DateTime, ParameterDirection.Input);
            parameters.Add("UpdatedDate", company.UpdatedDate, DbType.DateTime, ParameterDirection.Input);
            parameters.Add("Status", company.Status, DbType.Int32, ParameterDirection.Input);
            parameters.Add("ReturnValue", null, DbType.Int32, ParameterDirection.Output);
            parameters.Add("ErrorCode", null, DbType.Int32, ParameterDirection.Output);

            Execute("usp_Insert_Company", parameters);
            return parameters.Get<int>("ReturnValue");
        }

        public int UpdateCompany(Company company)
        {
            var parameters = new DynamicParameters();
            parameters.Add("Id", company.Id, DbType.Int32);
            parameters.Add("Name", company.Name, DbType.String, ParameterDirection.Input);
            parameters.Add("Description", company.Description, DbType.String, ParameterDirection.Input);
            parameters.Add("CreatedBy", company.CreatedBy, DbType.Int32, ParameterDirection.Input);
            parameters.Add("CreatedDate", company.CreatedDate, DbType.DateTime, ParameterDirection.Input);
            parameters.Add("UpdatedDate", company.UpdatedDate, DbType.DateTime, ParameterDirection.Input);
            parameters.Add("Status", company.Status, DbType.Int32, ParameterDirection.Input);
            parameters.Add("ReturnValue", null, DbType.Int32, ParameterDirection.Output);
            parameters.Add("ErrorCode", null, DbType.Int32, ParameterDirection.Output);

            Execute("usp_Update_Company", parameters);;
            return parameters.Get<int>("ReturnValue");
        }

        public bool DeleteCompany(int id)
        {
            var parameters = new DynamicParameters();
            parameters.Add("Id", id, DbType.Int32);
            parameters.Add("ErrorCode", null, DbType.Int32, ParameterDirection.Output);

            Execute("usp_Delete_Company", parameters);
            var errorCode = parameters.Get<int>("ErrorCode");
            return errorCode == 0;
        }
    }
}