// bwip-js // Barcode Writer in Pure JavaScript
// https://github.com/metafloor/bwip-js
//
// This code was automatically generated from:
// Barcode Writer in Pure PostScript - Version 2016-06-03
//
// Copyright (c) 2011-2016 Mark Warren
// Copyright (c) 2004-2014 Terry Burton
//
// Licensed MIT. See the LICENSE file in the bwip-js root directory.
function BWIPP() {
	// bwip-js/barcode-hdr.js
	//
	// This code is injected above the cross-compiled barcode.ps.

	// The BWIPJS object (graphics interface)
	var $$ = null;

	// The global dictionary.  Each renderer and encoder declare a
	// $1 local dict.
	var $0 = {
		$error: {} // the postscript error object
	};

	var $j = 0; // stack pointer
	var $k = []; // operand stack

	// Array ctor
	//	$a()	: Build a new array up to the Infinity-marker on the stack.
	//	$a(arr)	: Convert native array to a "view" of the array.
	//	$a(len)	: Create a new array of length `len`
	function $a(a) {
		if (!arguments.length) {
			for (var i = $j - 1; i >= 0 && $k[i] !== Infinity; i--);
			if (i < 0) {
				throw 'array-marker-not-found';
			}
			a = $k.splice(i + 1, $j - 1 - i);
			$j = i;
		} else if (!(a instanceof Array)) {
			a = new Array(+arguments[0]);
			for (var i = 0, l = a.length; i < l; i++) {
				a[i] = null;
			}
		}
		a.b = a; // base array
		a.o = 0; // offset into base
		return a;
	}

	// dict ctor
	//	$d() : look for the Infinity marker on the stack
	function $d() {
		var d = {};
		for (var i = $j - 1; i >= 0 && $k[i] !== Infinity; i -= 2) {
			if ($k[i - 1] === Infinity) {
				throw 'dict-malformed-stack';
			}
			// Unlike javascript, postscript dict keys differentiate between
			// numbers and the string representation of a number.
			var k = $k[i - 1]; // "key" into the dict entry
			var t = typeof k;
			if (t === 'number') {
				d['\uffff' + k] = $k[i];
			} else if (t === 'string') {
				d[k] = $k[i];
			} else if (k instanceof Uint8Array) {
				d[$z(k)] = $k[i];
			} else {
				throw 'dict-not-a-valid-key(' + k + ')';
			}
		}
		if (i < 0) {
			throw 'dict-marker-not-found';
		}
		$j = i;
		return d;
	}

	// string ctor
	//	s(number)	: create zero-filled string of number-length
	//	s(string)	: make a copy of the string
	//	s(uint8[])	: make a copy of the string
	//
	// Returns a Uint8Array-string.
	function $s(v) {
		var t = typeof v;
		if (t === 'number') {
			return new Uint8Array(v);
		}
		if (t !== 'string') {
			v = '' + v;
		}
		var s = new Uint8Array(v.length);
		for (var i = 0; i < v.length; i++) {
			s[i] = v.charCodeAt(i);
		}
		return s;
	}

	// Primarily designed to convert uint8-string to string, but will call the
	// the toString() method on any value.
	function $z(s) {
		if (s instanceof Uint8Array) {
			// Postscript treats nul-char as end of string, even if string is
			// longer.
			for (var i = 0, l = s.length; i < l && s[i]; i++);
			if (i < l) {
				return String.fromCharCode.apply(null, s.subarray(0, i));
			}
			return String.fromCharCode.apply(null, s)
		}
		return '' + s;
	}

	// Copies source to dest and returns a view of just the copied characters
	function $strcpy(dst, src) {
		if (typeof dst === 'string') {
			dst = $s(dst);
		}
		if (src instanceof Uint8Array) {
			for (var i = 0, l = src.length; i < l; i++) {
				dst[i] = src[i];
			}
		} else {
			for (var i = 0, l = src.length; i < l; i++) {
				dst[i] = src.charCodeAt(i);
			}
		}
		return src.length < dst.length ? dst.subarray(0, src.length) : dst;
	}

	// cvs operator - convert a value to its string representation
	//	s : string to store into
	//	v : any value
	function $cvs(s, v) {
		var t = typeof v;
		if (t == 'number' || t == 'boolean' || v === null) {
			v = '' + v;
		} else if (t !== 'string') {
			v = '--nostringval--';
		}
		for (var i = 0, l = v.length; i < l; i++) {
			s[i] = v.charCodeAt(i);
		}
		$k[$j++] = i < s.length ? s.subarray(0, i) : s;
	}
	// cvrs operator - convert a number to a radix string
	//	s : string to store into
	//	n : number
	//	r : radix
	function $cvrs(s, n, r) {
		return $strcpy(s, (~~n).toString(r).toUpperCase());
	}

	// get operator
	//	s : source
	//	k : key
	function $get(s, k) {
		if (s instanceof Uint8Array) {
			return s[k];
		}
		if (typeof s === 'string') {
			return s.charCodeAt(k);
		}
		if (s instanceof Array) {
			return s.b[s.o + k];
		}
		// Must be a dict object : with postscript dict objects, a number key
		// is differerent than its string representation.  postscript uses
		// 8-bit strings, so \uffff can never be in a key value.
		if (typeof k === 'number') {
			return s['\uffff' + k];
		}
		if (k instanceof Uint8Array) {
			return s[$z(k)];
		}
		return s[k];
	}

	// put operator
	//	d : dest
	//	k : key
	//	v : value
	function $put(d, k, v) {
		if (d instanceof Uint8Array) {
			d[k] = v;
		} else if (d instanceof Array) {
			d.b[d.o + k] = v;
		} else if (typeof d == 'object') {
			if (k instanceof Uint8Array) {
				d[$z(k)] = v;
			} else {
				d[typeof k == 'number' ? '\uffff' + k : k] = v;
			}
		} else {
			throw 'put-not-writable-' + (typeof d);
		}
	}

	// getinterval operator
	//	s : src
	//	o : offset
	//	l : length
	function $geti(s, o, l) {
		if (s instanceof Uint8Array) {
			return s.subarray(o, o + l);
		}
		if (s instanceof Array) {
			var a = new Array(l);
			a.b = s.b; // base array
			a.o = s.o + o; // offset into base
			return a;
		}
		// Must be a string
		return s.substr(o, l);
	}

	// putinterval operator
	//	d : dst
	//	o : offset
	//	s : src
	function $puti(d, o, s) {
		if (d instanceof Uint8Array) {
			if (typeof s == 'string') {
				for (var i = 0, l = s.length; i < l; i++) {
					d[o + i] = s.charCodeAt(i);
				}
			} else {
				// When both d and s are the same, we want to copy
				// backwards, which works for the general case as well.
				for (var i = s.length - 1; i >= 0; i--) {
					d[o + i] = s[i];
				}
			}
		} else if (d instanceof Array) {
			// Operate on the base arrays
			var darr = d.b;
			var doff = o + d.o;
			var sarr = s.b;
			var soff = s.o;

			for (var i = 0, l = s.length; i < l; i++) {
				darr[doff + i] = sarr[soff + i];
			}
		} else {
			throw 'putinterval-not-writable-' + (typeof d);
		}
	}

	// type operator
	function $type(v) {
		// null can be mis-typed - get it out of the way
		if (v === null || v === undefined) {
			return 'nulltype';
		}
		var t = typeof v;
		if (t == 'number') {
			return v % 1 ? 'realtype' : 'integertype';
		}
		if (t == 'boolean') {
			return 'booleantype';
		}
		if (t == 'string' || v instanceof Uint8Array) {
			return 'stringtype';
		}
		if (t == 'function') {
			return 'operatortype';
		}
		if (v instanceof Array) {
			return 'arraytype';
		}
		return 'dicttype';
		// filetype
		// fonttype
		// gstatetype
		// marktype	(v === Infinity)
		// nametype
		// savetype
	}

	// search operator
	//		string seek search suffix match prefix true %if-found
	//						   string false				%if-not-found
	function $search(str, seek) {
		if (!(str instanceof Uint8Array)) {
			str = $s(str);
		}
		var ls = str.length;

		// Virtually all uses of search in BWIPP are for single-characters.
		// Optimize for that case.
		if (seek.length == 1) {
			var cd = seek instanceof Uint8Array ? seek[0] : seek.charCodeAt(0);
			for (var i = 0; i < ls && str[i] != cd; i++);
			if (i < ls) {
				$k[$j++] = str.subarray(i + 1);
				$k[$j++] = str.subarray(i, i + 1);
				$k[$j++] = str.subarray(0, i);
				$k[$j++] = true;
			} else {
				$k[$j++] = str;
				$k[$j++] = false;
			}
			return;
		}

		// Slow path, 
		if (!(seek instanceof Uint8Array)) {
			seek = $(seek);
		}
		var lk = seek.length;
		var cd = seek[0];
		for (var i = 0; i < ls && str[i] != cd; i++);
		while (i < ls) {
			for (var j = 1; j < lk && str[i + j] === seek[j]; j++);
			if (j === lk) {
				$k[$j++] = str.subarray(i + lk);
				$k[$j++] = str.subarray(i, i + lk);
				$k[$j++] = str.subarray(0, i);
				$k[$j++] = true;
				return;
			}
			for (i++; i < ls && str[i] != cd; i++);
		}
		$k[$j++] = str;
		$k[$j++] = false;
	}

	// The callback is omitted when forall is being used just to push onto the
	// stack.
	function $forall(o, cb) {
		if (o instanceof Uint8Array) {
			for (var i = 0, l = o.length; i < l; i++) {
				$k[$j++] = o[i];
				cb && cb();
			}
		} else if (o instanceof Array) {
			// The array may be a view.
			for (var a = o.b, i = o.o, l = o.o + o.length; i < l; i++) {
				$k[$j++] = a[i];
				cb && cb();
			}
		} else if (typeof o === 'string') {
			for (var i = 0, l = o.length; i < l; i++) {
				$k[$j++] = o.charCodeAt(i);
				cb && cb();
			}
		} else {
			for (var id in o) {
				$k[$j++] = id;
				$k[$j++] = o[id];
				cb && cb();
			}
		}
	}

	function $cleartomark() {
		while ($j > 0 && $k[--$j] !== Infinity);
	}

	function $counttomark() {
		for (var i = $j - 1; i >= 0 && $k[i] !== Infinity; i--);
		return $j - i - 1;
	}

	function $aload(a) {
		for (var i = 0, l = a.length, b = a.b, o = a.o; i < l; i++) {
			$k[$j++] = b[o + i];
		}
		// This push has been optimized out.  See $.aload() in psc.js.
		//$k[$j++] = a;
	}

	function $astore(a) {
		for (var i = 0, l = a.length, b = a.b, o = a.o + l - 1; i < l; i++) {
			b[o - i] = $k[--$j];
		}
		$k[$j++] = a;
	}

	function $eq(a, b) {
		if (typeof a === 'string' && typeof b === 'string') {
			return a == b;
		}
		if (a instanceof Uint8Array && b instanceof Uint8Array) {
			if (a.length != b.length) {
				return false;
			}
			for (var i = 0, l = a.length; i < l; i++) {
				if (a[i] != b[i]) {
					return false;
				}
			}
			return true;
		}
		if (a instanceof Uint8Array && typeof b === 'string' ||
			b instanceof Uint8Array && typeof a === 'string') {
			if (a instanceof Uint8Array) {
				a = $z(a);
			} else {
				b = $z(b);
			}
			return a == b;
		}
		return a == b;
	}

	function $ne(a, b) {
		return !$eq(a, b);
	}

	function $lt(a, b) {
		if (a instanceof Uint8Array) {
			a = $z(a);
		}
		if (b instanceof Uint8Array) {
			b = $z(b);
		}
		return a < b;
	}

	function $le(a, b) {
		if (a instanceof Uint8Array) {
			a = $z(a);
		}
		if (b instanceof Uint8Array) {
			b = $z(b);
		}
		return a <= b;
	}

	function $gt(a, b) {
		if (a instanceof Uint8Array) {
			a = $z(a);
		}
		if (b instanceof Uint8Array) {
			b = $z(b);
		}
		return a > b;
	}

	function $ge(a, b) {
		if (a instanceof Uint8Array) {
			a = $z(a);
		}
		if (b instanceof Uint8Array) {
			b = $z(b);
		}
		return a >= b;
	}

	function $an(a, b) { // and
		return (typeof a === 'boolean') ? a && b : a & b;
	}

	function $or(a, b) { // or
		return (typeof a === 'boolean') ? a || b : a | b;
	}

	function $xo(a, b) { // xor
		return (typeof a === 'boolean') ? !a && b || a && !b : a ^ b;
	}

	// DEBUG-BEGIN
	function $stack() {
		console.log('[[[');
		for (var i = $j - 1; i >= 0; i--) {
			console.log(tostring($k[i]));
		}
		console.log(']]]');

		function tostring(v) {
			// null can be mis-typed - get it out of the way
			if (v === null) {
				return 'null';
			} else if (v === undefined) {
				return '<undefined>';
			} else if (v instanceof Array) {
				var s = '<array,' + v.o + ',' + v.length + '>[';
				for (var j = v.o, a = v.b, l = v.length + v.o; j < l; j++) {
					s += (j == v.o ? '' : ',') + tostring(a[j]);
				}
				return s + ']';
			} else if (v instanceof Uint8Array) {
				return '(' + $z[v] + ')';
			} else if (typeof v === 'object') {
				var s = '<<';
				for (var id in v) {
					s += (s.length == 7 ? '' : ',') + id + ':' + tostring(v[id]);
				}
				return s + '>>';
			} else if (typeof v === 'string') {
				return '"' + v + '"';
			} else {
				return '' + v;
			}
		}
	}
	// DEBUG-END
	$0.raiseerror = function() {
		$0.$error.errorinfo = $k[--$j]; /*55*/
		$0.$error.errorname = $k[--$j]; /*56*/
		$0.$error.command = null; /*57*/
		$0.$error.newerror = true; /*58*/
		throw new Error($0.$error.errorname + ": " + $0.$error.errorinfo); /*59*/
	};
	$0.ean5 = function() {
		var $1 = {}; /*489*/
		$1.options = $k[--$j]; /*491*/
		$1.barcode = $k[--$j]; /*492*/
		$1.dontdraw = false; /*494*/
		$1.includetext = false; /*495*/
		$1.textfont = "Helvetica"; /*496*/
		$1.textsize = 12; /*497*/
		$1.textxoffset = 0; /*498*/
		$1.textyoffset = "unset"; /*499*/
		$1.height = 0.7; /*500*/
		$forall($1.options, function() { /*511*/
			var _3 = $k[--$j]; /*511*/
			$1[$k[--$j]] = _3; /*511*/
		}) /*511*/
		$1.textfont = "" + $1.textfont; /*513*/
		$1.textsize = +$1.textsize; /*514*/
		$1.height = +$1.height; /*515*/
		$1.textxoffset = +$1.textxoffset; /*516*/
		if ($eq($1.textyoffset, "unset")) { /*520*/
			$1.textyoffset = ($1.height * 72) + 1; /*518*/
		} else { /*520*/
			$1.textyoffset = +$1.textyoffset; /*520*/
		} /*520*/
		if ($1.barcode.length != 5) { /*526*/
			$k[$j++] = "bwipp.ean5badLength"; /*525*/
			$k[$j++] = "EAN-5 add-on must be 5 digits"; /*525*/
			$0.raiseerror(); /*525*/
		} /*525*/
		$forall($1.barcode, function() { /*531*/
			var _E = $k[--$j]; /*528*/
			if ((_E < 48) || (_E > 57)) { /*530*/
				$k[$j++] = "bwipp.ean5badCharacter"; /*529*/
				$k[$j++] = "EAN-5 add-on must contain only digits"; /*529*/
				$0.raiseerror(); /*529*/
			} /*529*/
		}) /*529*/
		$1.encs = $a(["3211", "2221", "2122", "1411", "1132", "1231", "1114", "1312", "1213", "3112", "112", "11"]); /*538*/
		$1.barchars = "0123456789"; /*541*/
		$1.mirrormaps = $a(["11000", "10100", "10010", "10001", "01100", "00110", "00011", "01010", "01001", "00101"]); /*547*/
		$1.checksum = 0; /*548*/
		for (var _H = 0; _H <= 4; _H += 1) { /*557*/
			$1.i = _H; /*550*/
			$1.barchar = $get($1.barcode, $1.i) - 48; /*551*/
			if (($1.i % 2) == 0) { /*555*/
				$1.checksum = ($1.barchar * 3) + $1.checksum; /*553*/
			} else { /*555*/
				$1.checksum = ($1.barchar * 9) + $1.checksum; /*555*/
			} /*555*/
		} /*555*/
		$1.checksum = $1.checksum % 10; /*558*/
		$1.mirrormap = $get($1.mirrormaps, $1.checksum); /*559*/
		$1.sbs = $s(31); /*561*/
		$1.txt = $a(5); /*562*/
		for (var _W = 0; _W <= 4; _W += 1) { /*592*/
			$1.i = _W; /*565*/
			if ($1.i == 0) { /*571*/
				$puti($1.sbs, 0, $get($1.encs, 10)); /*569*/
			} else { /*571*/
				$puti($1.sbs, (($1.i - 1) * 6) + 7, $get($1.encs, 11)); /*571*/
			} /*571*/
			$search($1.barchars, $geti($1.barcode, $1.i, 1)); /*575*/
			$j--; /*576*/
			$1.indx = $k[--$j].length; /*577*/
			$j -= 2; /*578*/
			$1.enc = $get($1.encs, $1.indx); /*579*/
			if ($get($1.mirrormap, $1.i) == 49) { /*589*/
				$1.enclen = $1.enc.length; /*581*/
				$1.revenc = $s($1.enclen); /*582*/
				for (var _v = 0, _u = $1.enclen - 1; _v <= _u; _v += 1) { /*587*/
					$1.j = _v; /*584*/
					$1.char = $get($1.enc, $1.j); /*585*/
					$put($1.revenc, ($1.enclen - $1.j) - 1, $1.char); /*586*/
				} /*586*/
				$1.enc = $1.revenc; /*588*/
			} /*588*/
			$puti($1.sbs, ($1.i * 6) + 3, $1.enc); /*590*/
			$put($1.txt, $1.i, $a([$geti($1.barcode, $1.i, 1), ((($1.i - 1) * 9) + 13) + $1.textxoffset, $1.textyoffset, $1.textfont, $1.textsize])); /*591*/
		} /*591*/
		$k[$j++] = Infinity; /*606*/
		$k[$j++] = "ren"; /*597*/
		$k[$j++] = $0.renlinear; /*597*/
		$k[$j++] = "sbs"; /*597*/
		$k[$j++] = Infinity; /*597*/
		var _1I = $1.sbs; /*597*/
		for (var _1J = 0, _1K = _1I.length; _1J < _1K; _1J++) { /*597*/
			$k[$j++] = $get(_1I, _1J) - 48; /*597*/
		} /*597*/
		var _1M = $a(); /*597*/
		$k[$j++] = _1M; /*598*/
		$k[$j++] = "bhs"; /*598*/
		$k[$j++] = Infinity; /*598*/
		for (var _1N = 0, _1O = 16; _1N < _1O; _1N++) { /*598*/
			$k[$j++] = $1.height; /*598*/
		} /*598*/
		var _1Q = $a(); /*598*/
		$k[$j++] = _1Q; /*599*/
		$k[$j++] = "bbs"; /*599*/
		$k[$j++] = Infinity; /*599*/
		for (var _1R = 0, _1S = 16; _1R < _1S; _1R++) { /*599*/
			$k[$j++] = 0; /*599*/
		} /*599*/
		var _1T = $a(); /*599*/
		$k[$j++] = _1T; /*602*/
		if ($1.includetext) { /*602*/
			$k[$j++] = "txt"; /*601*/
			$k[$j++] = $1.txt; /*601*/
		} /*601*/
		$k[$j++] = "opt"; /*606*/
		$k[$j++] = $1.options; /*606*/
		$k[$j++] = "guardrightpos"; /*606*/
		$k[$j++] = 10; /*606*/
		$k[$j++] = "guardrightypos"; /*606*/
		$k[$j++] = $1.textyoffset + 4; /*606*/
		$k[$j++] = "bordertop"; /*606*/
		$k[$j++] = 10; /*606*/
		var _1Y = $d(); /*606*/
		$k[$j++] = _1Y; /*609*/
		if (!$1.dontdraw) { /*609*/
			$0.renlinear(); /*609*/
		} /*609*/
	};
	$0.ean2 = function() {
		var $1 = {}; /*636*/
		$1.options = $k[--$j]; /*638*/
		$1.barcode = $k[--$j]; /*639*/
		$1.dontdraw = false; /*641*/
		$1.includetext = false; /*642*/
		$1.textfont = "Helvetica"; /*643*/
		$1.textsize = 12; /*644*/
		$1.textxoffset = 0; /*645*/
		$1.textyoffset = "unset"; /*646*/
		$1.height = 0.7; /*647*/
		$forall($1.options, function() { /*658*/
			var _3 = $k[--$j]; /*658*/
			$1[$k[--$j]] = _3; /*658*/
		}) /*658*/
		$1.textfont = "" + $1.textfont; /*660*/
		$1.textsize = +$1.textsize; /*661*/
		$1.height = +$1.height; /*662*/
		$1.textxoffset = +$1.textxoffset; /*663*/
		if ($eq($1.textyoffset, "unset")) { /*667*/
			$1.textyoffset = ($1.height * 72) + 1; /*665*/
		} else { /*667*/
			$1.textyoffset = +$1.textyoffset; /*667*/
		} /*667*/
		if ($1.barcode.length != 2) { /*673*/
			$k[$j++] = "bwipp.ean2badLength"; /*672*/
			$k[$j++] = "EAN-2 add-on must be 2 digits"; /*672*/
			$0.raiseerror(); /*672*/
		} /*672*/
		$forall($1.barcode, function() { /*678*/
			var _E = $k[--$j]; /*675*/
			if ((_E < 48) || (_E > 57)) { /*677*/
				$k[$j++] = "bwipp.ean2badCharacter"; /*676*/
				$k[$j++] = "EAN-2 add-on must contain only digits"; /*676*/
				$0.raiseerror(); /*676*/
			} /*676*/
		}) /*676*/
		$1.encs = $a(["3211", "2221", "2122", "1411", "1132", "1231", "1114", "1312", "1213", "3112", "112", "11"]); /*685*/
		$1.barchars = "0123456789"; /*688*/
		$1.mirrormap = $get($a(["00", "01", "10", "11"]), (~~$z($geti($1.barcode, 0, 2))) % 4); /*691*/
		$1.sbs = $s(13); /*693*/
		$1.txt = $a(2); /*694*/
		for (var _M = 0; _M <= 1; _M += 1) { /*724*/
			$1.i = _M; /*697*/
			if ($1.i == 0) { /*703*/
				$puti($1.sbs, 0, $get($1.encs, 10)); /*701*/
			} else { /*703*/
				$puti($1.sbs, (($1.i - 1) * 6) + 7, $get($1.encs, 11)); /*703*/
			} /*703*/
			$search($1.barchars, $geti($1.barcode, $1.i, 1)); /*707*/
			$j--; /*708*/
			$1.indx = $k[--$j].length; /*709*/
			$j -= 2; /*710*/
			$1.enc = $get($1.encs, $1.indx); /*711*/
			if ($get($1.mirrormap, $1.i) == 49) { /*721*/
				$1.enclen = $1.enc.length; /*713*/
				$1.revenc = $s($1.enclen); /*714*/
				for (var _l = 0, _k = $1.enclen - 1; _l <= _k; _l += 1) { /*719*/
					$1.j = _l; /*716*/
					$1.char = $get($1.enc, $1.j); /*717*/
					$put($1.revenc, ($1.enclen - $1.j) - 1, $1.char); /*718*/
				} /*718*/
				$1.enc = $1.revenc; /*720*/
			} /*720*/
			$puti($1.sbs, ($1.i * 6) + 3, $1.enc); /*722*/
			$put($1.txt, $1.i, $a([$geti($1.barcode, $1.i, 1), ((($1.i - 1) * 9) + 13) + $1.textxoffset, $1.textyoffset, $1.textfont, $1.textsize])); /*723*/
		} /*723*/
		$k[$j++] = Infinity; /*738*/
		$k[$j++] = "ren"; /*729*/
		$k[$j++] = $0.renlinear; /*729*/
		$k[$j++] = "sbs"; /*729*/
		$k[$j++] = Infinity; /*729*/
		var _18 = $1.sbs; /*729*/
		for (var _19 = 0, _1A = _18.length; _19 < _1A; _19++) { /*729*/
			$k[$j++] = $get(_18, _19) - 48; /*729*/
		} /*729*/
		var _1C = $a(); /*729*/
		$k[$j++] = _1C; /*730*/
		$k[$j++] = "bhs"; /*730*/
		$k[$j++] = Infinity; /*730*/
		for (var _1D = 0, _1E = 12; _1D < _1E; _1D++) { /*730*/
			$k[$j++] = $1.height; /*730*/
		} /*730*/
		var _1G = $a(); /*730*/
		$k[$j++] = _1G; /*731*/
		$k[$j++] = "bbs"; /*731*/
		$k[$j++] = Infinity; /*731*/
		for (var _1H = 0, _1I = 12; _1H < _1I; _1H++) { /*731*/
			$k[$j++] = 0; /*731*/
		} /*731*/
		var _1J = $a(); /*731*/
		$k[$j++] = _1J; /*734*/
		if ($1.includetext) { /*734*/
			$k[$j++] = "txt"; /*733*/
			$k[$j++] = $1.txt; /*733*/
		} /*733*/
		$k[$j++] = "opt"; /*738*/
		$k[$j++] = $1.options; /*738*/
		$k[$j++] = "guardrightpos"; /*738*/
		$k[$j++] = 10; /*738*/
		$k[$j++] = "guardrightypos"; /*738*/
		$k[$j++] = $1.textyoffset + 4; /*738*/
		$k[$j++] = "bordertop"; /*738*/
		$k[$j++] = 10; /*738*/
		var _1O = $d(); /*738*/
		$k[$j++] = _1O; /*741*/
		if (!$1.dontdraw) { /*741*/
			$0.renlinear(); /*741*/
		} /*741*/
	};
	$0.ean13 = function() {
		var $1 = {}; /*770*/
		$1.options = $k[--$j]; /*772*/
		$1.barcode = $k[--$j]; /*773*/
		$1.dontdraw = false; /*775*/
		$1.includetext = false; /*776*/
		$1.textfont = "Helvetica"; /*777*/
		$1.textsize = 12; /*778*/
		$1.textxoffset = -10; /*779*/
		$1.textyoffset = -4.5; /*780*/
		$1.height = 1; /*781*/
		$1.addongap = 12; /*782*/
		$1.addontextfont = "unset"; /*783*/
		$1.addontextsize = "unset"; /*784*/
		$1.addontextxoffset = "unset"; /*785*/
		$1.addontextyoffset = "unset"; /*786*/
		$forall($1.options, function() { /*797*/
			var _3 = $k[--$j]; /*797*/
			$1[$k[--$j]] = _3; /*797*/
		}) /*797*/
		$1.textfont = "" + $1.textfont; /*799*/
		$1.textsize = +$1.textsize; /*800*/
		$1.textxoffset = +$1.textxoffset; /*801*/
		$1.textyoffset = +$1.textyoffset; /*802*/
		$1.height = +$1.height; /*803*/
		$1.addongap = +$1.addongap; /*804*/
		if ($ne($1.addontextfont, "unset")) { /*805*/
			$1.addontextfont = "" + $1.addontextfont; /*805*/
		} /*805*/
		if ($ne($1.addontextsize, "unset")) { /*806*/
			$1.addontextsize = +$1.addontextsize; /*806*/
		} /*806*/
		if ($ne($1.addontextxoffset, "unset")) { /*807*/
			$1.addontextxoffset = +$1.addontextxoffset; /*807*/
		} /*807*/
		if ($ne($1.addontextyoffset, "unset")) { /*808*/
			$1.addontextyoffset = +$1.addontextyoffset; /*808*/
		} /*808*/
		$search($1.barcode, " "); /*811*/
		if ($k[--$j]) { /*817*/
			$1.barcode = $k[--$j]; /*812*/
			$j--; /*813*/
			$1.addon = $k[--$j]; /*814*/
		} else { /*817*/
			$j--; /*816*/
			$1.addon = ""; /*817*/
		} /*817*/
		if (($1.barcode.length != 12) && ($1.barcode.length != 13)) { /*823*/
			$k[$j++] = "bwipp.ean13badLength"; /*822*/
			$k[$j++] = "EAN-13 must be 12 or 13 digits"; /*822*/
			$0.raiseerror(); /*822*/
		} /*822*/
		$forall($1.barcode, function() { /*828*/
			var _Q = $k[--$j]; /*825*/
			if ((_Q < 48) || (_Q > 57)) { /*827*/
				$k[$j++] = "bwipp.ean13badCharacter"; /*826*/
				$k[$j++] = "EAN-13 must contain only digits"; /*826*/
				$0.raiseerror(); /*826*/
			} /*826*/
		}) /*826*/
		if ((($1.addon.length != 0) && ($1.addon.length != 2)) && ($1.addon.length != 5)) { /*831*/
			$k[$j++] = "bwipp.ean13badAddOnLength"; /*830*/
			$k[$j++] = "Add-on for EAN-13 must be 2 or 5 digits"; /*830*/
			$0.raiseerror(); /*830*/
		} /*830*/
		$1.pad = $s(13); /*834*/
		$1.checksum = 0; /*835*/
		for (var _V = 0; _V <= 11; _V += 1) { /*844*/
			$1.i = _V; /*837*/
			$1.barchar = $get($1.barcode, $1.i) - 48; /*838*/
			if (($1.i % 2) == 0) { /*842*/
				$1.checksum = $1.barchar + $1.checksum; /*840*/
			} else { /*842*/
				$1.checksum = ($1.barchar * 3) + $1.checksum; /*842*/
			} /*842*/
		} /*842*/
		$1.checksum = (10 - ($1.checksum % 10)) % 10; /*845*/
		if ($1.barcode.length == 13) { /*850*/
			if ($get($1.barcode, 12) != ($1.checksum + 48)) { /*849*/
				$k[$j++] = "bwipp.ean13badCheckDigit"; /*848*/
				$k[$j++] = "Incorrect EAN-13 check digit provided"; /*848*/
				$0.raiseerror(); /*848*/
			} /*848*/
		} /*848*/
		$puti($1.pad, 0, $1.barcode); /*851*/
		$put($1.pad, 12, $1.checksum + 48); /*852*/
		$1.barcode = $1.pad; /*853*/
		$1.encs = $a(["3211", "2221", "2122", "1411", "1132", "1231", "1114", "1312", "1213", "3112", "111", "11111", "111"]); /*860*/
		$1.barchars = "0123456789"; /*863*/
		$1.mirrormaps = $a(["000000", "001011", "001101", "001110", "010011", "011001", "011100", "010101", "010110", "011010"]); /*869*/
		$1.sbs = $s(59); /*871*/
		$1.txt = $a(13); /*872*/
		$puti($1.sbs, 0, $get($1.encs, 10)); /*875*/
		$1.mirrormap = $get($1.mirrormaps, $get($1.barcode, 0) - 48); /*878*/
		$put($1.txt, 0, $a([$geti($1.barcode, 0, 1), $1.textxoffset, $1.textyoffset, $1.textfont, $1.textsize])); /*879*/
		for (var _17 = 1; _17 <= 6; _17 += 1) { /*902*/
			$1.i = _17; /*884*/
			$search($1.barchars, $geti($1.barcode, $1.i, 1)); /*885*/
			$j--; /*886*/
			$1.indx = $k[--$j].length; /*887*/
			$j -= 2; /*888*/
			$1.enc = $get($1.encs, $1.indx); /*889*/
			if ($get($1.mirrormap, $1.i - 1) == 49) { /*899*/
				$1.enclen = $1.enc.length; /*891*/
				$1.revenc = $s($1.enclen); /*892*/
				for (var _1O = 0, _1N = $1.enclen - 1; _1O <= _1N; _1O += 1) { /*897*/
					$1.j = _1O; /*894*/
					$1.char = $get($1.enc, $1.j); /*895*/
					$put($1.revenc, ($1.enclen - $1.j) - 1, $1.char); /*896*/
				} /*896*/
				$1.enc = $1.revenc; /*898*/
			} /*898*/
			$puti($1.sbs, (($1.i - 1) * 4) + 3, $1.enc); /*900*/
			$put($1.txt, $1.i, $a([$geti($1.barcode, $1.i, 1), ((($1.i - 1) * 7) + 14) + $1.textxoffset, $1.textyoffset, $1.textfont, $1.textsize])); /*901*/
		} /*901*/
		$puti($1.sbs, ((7 - 1) * 4) + 3, $get($1.encs, 11)); /*905*/
		for (var _1o = 7; _1o <= 12; _1o += 1) { /*918*/
			$1.i = _1o; /*910*/
			$search($1.barchars, $geti($1.barcode, $1.i, 1)); /*911*/
			$j--; /*912*/
			$1.indx = $k[--$j].length; /*913*/
			$j -= 2; /*914*/
			$1.enc = $get($1.encs, $1.indx); /*915*/
			$puti($1.sbs, (($1.i - 1) * 4) + 8, $1.enc); /*916*/
			$put($1.txt, $1.i, $a([$geti($1.barcode, $1.i, 1), ((($1.i - 1) * 7) + 18) + $1.textxoffset, $1.textyoffset, $1.textfont, $1.textsize])); /*917*/
		} /*917*/
		$puti($1.sbs, 56, $get($1.encs, 12)); /*921*/
		$k[$j++] = "sbs"; /*923*/
		$k[$j++] = Infinity; /*923*/
		var _2E = $1.sbs; /*923*/
		for (var _2F = 0, _2G = _2E.length; _2F < _2G; _2F++) { /*923*/
			$k[$j++] = $get(_2E, _2F) - 48; /*923*/
		} /*923*/
		var _2I = $a(); /*923*/
		$1[$k[--$j]] = _2I; /*923*/
		if ($1.includetext) { /*930*/
			$k[$j++] = "bhs"; /*925*/
			$k[$j++] = Infinity; /*925*/
			$k[$j++] = $1.height; /*925*/
			$k[$j++] = $1.height; /*925*/
			for (var _2N = 0, _2O = 12; _2N < _2O; _2N++) { /*925*/
				$k[$j++] = $1.height - 0.075; /*925*/
			} /*925*/
			$k[$j++] = $1.height; /*925*/
			$k[$j++] = $1.height; /*925*/
			for (var _2S = 0, _2T = 12; _2S < _2T; _2S++) { /*925*/
				$k[$j++] = $1.height - 0.075; /*925*/
			} /*925*/
			$k[$j++] = $1.height; /*925*/
			$k[$j++] = $1.height; /*925*/
			var _2X = $a(); /*925*/
			$1[$k[--$j]] = _2X; /*925*/
			$k[$j++] = "bbs"; /*926*/
			$k[$j++] = Infinity; /*926*/
			$k[$j++] = 0; /*926*/
			$k[$j++] = 0; /*926*/
			for (var _2Z = 0, _2a = 12; _2Z < _2a; _2Z++) { /*926*/
				$k[$j++] = 0.075; /*926*/
			} /*926*/
			$k[$j++] = 0; /*926*/
			$k[$j++] = 0; /*926*/
			for (var _2b = 0, _2c = 12; _2b < _2c; _2b++) { /*926*/
				$k[$j++] = 0.075; /*926*/
			} /*926*/
			$k[$j++] = 0; /*926*/
			$k[$j++] = 0; /*926*/
			var _2d = $a(); /*926*/
			$1[$k[--$j]] = _2d; /*926*/
		} else { /*930*/
			$k[$j++] = "bhs"; /*928*/
			$k[$j++] = Infinity; /*928*/
			for (var _2f = 0, _2g = 30; _2f < _2g; _2f++) { /*928*/
				$k[$j++] = $1.height; /*928*/
			} /*928*/
			var _2i = $a(); /*928*/
			$1[$k[--$j]] = _2i; /*928*/
			$k[$j++] = "bbs"; /*929*/
			$k[$j++] = Infinity; /*929*/
			for (var _2k = 0, _2l = 30; _2k < _2l; _2k++) { /*929*/
				$k[$j++] = 0; /*929*/
			} /*929*/
			var _2m = $a(); /*929*/
			$1[$k[--$j]] = _2m; /*929*/
			$1.txt = $a([]); /*930*/
		} /*930*/
		$1.guardrightypos = 0; /*932*/
		if ($ne($1.addon, "")) { /*953*/
			$k[$j++] = "addopts"; /*943*/
			$k[$j++] = Infinity; /*943*/
			$k[$j++] = "dontdraw"; /*940*/
			$k[$j++] = true; /*940*/
			$k[$j++] = "includetext"; /*940*/
			$k[$j++] = true; /*940*/
			$k[$j++] = "height"; /*940*/
			$k[$j++] = $1.height - 0.15; /*940*/
			$k[$j++] = "textxoffset"; /*940*/
			if ($1.addontextxoffset != "unset") { /*940*/
				$k[$j++] = $1.addontextxoffset; /*940*/
			} else { /*940*/
				$k[$j++] = 95 + $1.addongap; /*940*/
			} /*940*/
			if ($1.addontextyoffset != "unset") { /*941*/
				$k[$j++] = "textyoffset"; /*941*/
				$k[$j++] = $1.addontextyoffset; /*941*/
			} /*941*/
			$k[$j++] = "textsize"; /*942*/
			if ($1.addontextsize != "unset") { /*942*/
				$k[$j++] = $1.addontextsize; /*942*/
			} else { /*942*/
				$k[$j++] = $1.textsize; /*942*/
			} /*942*/
			$k[$j++] = "textfont"; /*943*/
			if ($ne($1.addontextfont, "unset")) { /*943*/
				$k[$j++] = $1.addontextfont; /*943*/
			} else { /*943*/
				$k[$j++] = $1.textfont; /*943*/
			} /*943*/
			var _32 = $d(); /*943*/
			$1[$k[--$j]] = _32; /*944*/
			if ($1.addon.length == 2) { /*945*/
				$k[$j++] = $1.addon; /*945*/
				$k[$j++] = $1.addopts; /*945*/
				$0.ean2(); /*945*/
			} /*945*/
			if ($1.addon.length == 5) { /*946*/
				$k[$j++] = $1.addon; /*946*/
				$k[$j++] = $1.addopts; /*946*/
				$0.ean5(); /*946*/
			} /*946*/
			$1.addcode = $k[--$j]; /*947*/
			$k[$j++] = "sbs"; /*948*/
			$k[$j++] = Infinity; /*948*/
			$aload($1.sbs); /*948*/
			$k[$j++] = $1.addongap; /*948*/
			$aload($1.addcode.sbs); /*948*/
			var _3F = $a(); /*948*/
			$1[$k[--$j]] = _3F; /*948*/
			$k[$j++] = "bhs"; /*949*/
			$k[$j++] = Infinity; /*949*/
			$aload($1.bhs); /*949*/
			$forall($1.addcode.bhs, function() { /*949*/
				var _3K = $k[--$j]; /*949*/
				$k[$j++] = _3K - 0.075; /*949*/
			}) /*949*/
			var _3L = $a(); /*949*/
			$1[$k[--$j]] = _3L; /*949*/
			$k[$j++] = "bbs"; /*950*/
			$k[$j++] = Infinity; /*950*/
			$aload($1.bbs); /*950*/
			$forall($1.addcode.bbs, function() { /*950*/
				var _3Q = $k[--$j]; /*950*/
				$k[$j++] = _3Q + 0.075; /*950*/
			}) /*950*/
			var _3R = $a(); /*950*/
			$1[$k[--$j]] = _3R; /*950*/
			$k[$j++] = "txt"; /*951*/
			$k[$j++] = Infinity; /*951*/
			$aload($1.txt); /*951*/
			$aload($1.addcode.txt); /*951*/
			var _3W = $a(); /*951*/
			$1[$k[--$j]] = _3W; /*951*/
			$1.guardrightypos = ($1.height * 72) - 6; /*952*/
		} /*952*/
		var _3f = {
			ren: $0.renlinear,
			sbs: $1.sbs,
			bhs: $1.bhs,
			bbs: $1.bbs,
			txt: $1.txt,
			opt: $1.options,
			guardrightpos: 10,
			guardrightypos: $1.guardrightypos,
			borderbottom: 5
		}; /*965*/
		$k[$j++] = _3f; /*968*/
		if (!$1.dontdraw) { /*968*/
			$0.renlinear(); /*968*/
		} /*968*/
	};
	$0.ean8 = function() {
		var $1 = {}; /*997*/
		$1.options = $k[--$j]; /*999*/
		$1.barcode = $k[--$j]; /*1000*/
		$1.dontdraw = false; /*1002*/
		$1.includetext = false; /*1003*/
		$1.textfont = "Helvetica"; /*1004*/
		$1.textsize = 12; /*1005*/
		$1.textxoffset = 4; /*1006*/
		$1.textyoffset = -4.5; /*1007*/
		$1.height = 1; /*1008*/
		$1.addongap = 12; /*1009*/
		$1.addontextfont = "unset"; /*1010*/
		$1.addontextsize = "unset"; /*1011*/
		$1.addontextxoffset = "unset"; /*1012*/
		$1.addontextyoffset = "unset"; /*1013*/
		$forall($1.options, function() { /*1024*/
			var _3 = $k[--$j]; /*1024*/
			$1[$k[--$j]] = _3; /*1024*/
		}) /*1024*/
		$1.textfont = "" + $1.textfont; /*1026*/
		$1.textsize = +$1.textsize; /*1027*/
		$1.textxoffset = +$1.textxoffset; /*1028*/
		$1.textyoffset = +$1.textyoffset; /*1029*/
		$1.height = +$1.height; /*1030*/
		$1.addongap = +$1.addongap; /*1031*/
		if ($ne($1.addontextfont, "unset")) { /*1032*/
			$1.addontextfont = "" + $1.addontextfont; /*1032*/
		} /*1032*/
		if ($ne($1.addontextsize, "unset")) { /*1033*/
			$1.addontextsize = +$1.addontextsize; /*1033*/
		} /*1033*/
		if ($ne($1.addontextxoffset, "unset")) { /*1034*/
			$1.addontextxoffset = +$1.addontextxoffset; /*1034*/
		} /*1034*/
		if ($ne($1.addontextyoffset, "unset")) { /*1035*/
			$1.addontextyoffset = +$1.addontextyoffset; /*1035*/
		} /*1035*/
		$search($1.barcode, " "); /*1038*/
		if ($k[--$j]) { /*1044*/
			$1.barcode = $k[--$j]; /*1039*/
			$j--; /*1040*/
			$1.addon = $k[--$j]; /*1041*/
		} else { /*1044*/
			$j--; /*1043*/
			$1.addon = ""; /*1044*/
		} /*1044*/
		if (($1.barcode.length != 7) && ($1.barcode.length != 8)) { /*1050*/
			$k[$j++] = "bwipp.ean8badLength"; /*1049*/
			$k[$j++] = "EAN-8 must be 7 or 8 digits"; /*1049*/
			$0.raiseerror(); /*1049*/
		} /*1049*/
		$forall($1.barcode, function() { /*1055*/
			var _Q = $k[--$j]; /*1052*/
			if ((_Q < 48) || (_Q > 57)) { /*1054*/
				$k[$j++] = "bwipp.ean8badCharacter"; /*1053*/
				$k[$j++] = "EAN-8 must contain only digits"; /*1053*/
				$0.raiseerror(); /*1053*/
			} /*1053*/
		}) /*1053*/
		if ((($1.addon.length != 0) && ($1.addon.length != 2)) && ($1.addon.length != 5)) { /*1058*/
			$k[$j++] = "bwipp.ean8badAddOnLength"; /*1057*/
			$k[$j++] = "Add-on for EAN-8 must be 2 or 5 digits"; /*1057*/
			$0.raiseerror(); /*1057*/
		} /*1057*/
		$1.pad = $s(8); /*1061*/
		$1.checksum = 0; /*1062*/
		for (var _V = 0; _V <= 6; _V += 1) { /*1071*/
			$1.i = _V; /*1064*/
			$1.barchar = $get($1.barcode, $1.i) - 48; /*1065*/
			if (($1.i % 2) != 0) { /*1069*/
				$1.checksum = $1.barchar + $1.checksum; /*1067*/
			} else { /*1069*/
				$1.checksum = ($1.barchar * 3) + $1.checksum; /*1069*/
			} /*1069*/
		} /*1069*/
		$1.checksum = (10 - ($1.checksum % 10)) % 10; /*1072*/
		if ($1.barcode.length == 8) { /*1077*/
			if ($get($1.barcode, 7) != ($1.checksum + 48)) { /*1076*/
				$k[$j++] = "bwipp.ean8badCheckDigit"; /*1075*/
				$k[$j++] = "Incorrect EAN-8 check digit provided"; /*1075*/
				$0.raiseerror(); /*1075*/
			} /*1075*/
		} /*1075*/
		$puti($1.pad, 0, $1.barcode); /*1078*/
		$put($1.pad, 7, $1.checksum + 48); /*1079*/
		$1.barcode = $1.pad; /*1080*/
		$1.encs = $a(["3211", "2221", "2122", "1411", "1132", "1231", "1114", "1312", "1213", "3112", "111", "11111", "111"]); /*1087*/
		$1.barchars = "0123456789"; /*1090*/
		$1.sbs = $s(43); /*1092*/
		$1.txt = $a(8); /*1093*/
		$puti($1.sbs, 0, $get($1.encs, 10)); /*1096*/
		for (var _u = 0; _u <= 3; _u += 1) { /*1109*/
			$1.i = _u; /*1101*/
			$search($1.barchars, $geti($1.barcode, $1.i, 1)); /*1102*/
			$j--; /*1103*/
			$1.indx = $k[--$j].length; /*1104*/
			$j -= 2; /*1105*/
			$1.enc = $get($1.encs, $1.indx); /*1106*/
			$puti($1.sbs, ($1.i * 4) + 3, $1.enc); /*1107*/
			$put($1.txt, $1.i, $a([$geti($1.barcode, $1.i, 1), ($1.i * 7) + $1.textxoffset, $1.textyoffset, $1.textfont, $1.textsize])); /*1108*/
		} /*1108*/
		$puti($1.sbs, (4 * 4) + 3, $get($1.encs, 11)); /*1112*/
		for (var _1K = 4; _1K <= 7; _1K += 1) { /*1125*/
			$1.i = _1K; /*1117*/
			$search($1.barchars, $geti($1.barcode, $1.i, 1)); /*1118*/
			$j--; /*1119*/
			$1.indx = $k[--$j].length; /*1120*/
			$j -= 2; /*1121*/
			$1.enc = $get($1.encs, $1.indx); /*1122*/
			$puti($1.sbs, ($1.i * 4) + 8, $1.enc); /*1123*/
			$put($1.txt, $1.i, $a([$geti($1.barcode, $1.i, 1), (($1.i * 7) + $1.textxoffset) + 4, $1.textyoffset, $1.textfont, $1.textsize])); /*1124*/
		} /*1124*/
		$puti($1.sbs, 40, $get($1.encs, 12)); /*1128*/
		$k[$j++] = "sbs"; /*1130*/
		$k[$j++] = Infinity; /*1130*/
		var _1k = $1.sbs; /*1130*/
		for (var _1l = 0, _1m = _1k.length; _1l < _1m; _1l++) { /*1130*/
			$k[$j++] = $get(_1k, _1l) - 48; /*1130*/
		} /*1130*/
		var _1o = $a(); /*1130*/
		$1[$k[--$j]] = _1o; /*1130*/
		if ($1.includetext) { /*1137*/
			$k[$j++] = "bhs"; /*1132*/
			$k[$j++] = Infinity; /*1132*/
			$k[$j++] = $1.height; /*1132*/
			$k[$j++] = $1.height; /*1132*/
			for (var _1t = 0, _1u = 8; _1t < _1u; _1t++) { /*1132*/
				$k[$j++] = $1.height - 0.075; /*1132*/
			} /*1132*/
			$k[$j++] = $1.height; /*1132*/
			$k[$j++] = $1.height; /*1132*/
			for (var _1y = 0, _1z = 8; _1y < _1z; _1y++) { /*1132*/
				$k[$j++] = $1.height - 0.075; /*1132*/
			} /*1132*/
			$k[$j++] = $1.height; /*1132*/
			$k[$j++] = $1.height; /*1132*/
			var _23 = $a(); /*1132*/
			$1[$k[--$j]] = _23; /*1132*/
			$k[$j++] = "bbs"; /*1133*/
			$k[$j++] = Infinity; /*1133*/
			$k[$j++] = 0; /*1133*/
			$k[$j++] = 0; /*1133*/
			for (var _25 = 0, _26 = 8; _25 < _26; _25++) { /*1133*/
				$k[$j++] = 0.075; /*1133*/
			} /*1133*/
			$k[$j++] = 0; /*1133*/
			$k[$j++] = 0; /*1133*/
			for (var _27 = 0, _28 = 8; _27 < _28; _27++) { /*1133*/
				$k[$j++] = 0.075; /*1133*/
			} /*1133*/
			$k[$j++] = 0; /*1133*/
			$k[$j++] = 0; /*1133*/
			var _29 = $a(); /*1133*/
			$1[$k[--$j]] = _29; /*1133*/
		} else { /*1137*/
			$k[$j++] = "bhs"; /*1135*/
			$k[$j++] = Infinity; /*1135*/
			for (var _2B = 0, _2C = 22; _2B < _2C; _2B++) { /*1135*/
				$k[$j++] = $1.height; /*1135*/
			} /*1135*/
			var _2E = $a(); /*1135*/
			$1[$k[--$j]] = _2E; /*1135*/
			$k[$j++] = "bbs"; /*1136*/
			$k[$j++] = Infinity; /*1136*/
			for (var _2G = 0, _2H = 22; _2G < _2H; _2G++) { /*1136*/
				$k[$j++] = 0; /*1136*/
			} /*1136*/
			var _2I = $a(); /*1136*/
			$1[$k[--$j]] = _2I; /*1136*/
			$1.txt = $a([]); /*1137*/
		} /*1137*/
		$1.guardrightypos = 0; /*1139*/
		if ($ne($1.addon, "")) { /*1160*/
			$k[$j++] = "addopts"; /*1150*/
			$k[$j++] = Infinity; /*1150*/
			$k[$j++] = "dontdraw"; /*1147*/
			$k[$j++] = true; /*1147*/
			$k[$j++] = "includetext"; /*1147*/
			$k[$j++] = true; /*1147*/
			$k[$j++] = "height"; /*1147*/
			$k[$j++] = $1.height - 0.15; /*1147*/
			$k[$j++] = "textxoffset"; /*1147*/
			if ($1.addontextxoffset != "unset") { /*1147*/
				$k[$j++] = $1.addontextxoffset; /*1147*/
			} else { /*1147*/
				$k[$j++] = 67 + $1.addongap; /*1147*/
			} /*1147*/
			if ($1.addontextyoffset != "unset") { /*1148*/
				$k[$j++] = "textyoffset"; /*1148*/
				$k[$j++] = $1.addontextyoffset; /*1148*/
			} /*1148*/
			$k[$j++] = "textsize"; /*1149*/
			if ($1.addontextsize != "unset") { /*1149*/
				$k[$j++] = $1.addontextsize; /*1149*/
			} else { /*1149*/
				$k[$j++] = $1.textsize; /*1149*/
			} /*1149*/
			$k[$j++] = "textfont"; /*1150*/
			if ($ne($1.addontextfont, "unset")) { /*1150*/
				$k[$j++] = $1.addontextfont; /*1150*/
			} else { /*1150*/
				$k[$j++] = $1.textfont; /*1150*/
			} /*1150*/
			var _2Y = $d(); /*1150*/
			$1[$k[--$j]] = _2Y; /*1151*/
			if ($1.addon.length == 2) { /*1152*/
				$k[$j++] = $1.addon; /*1152*/
				$k[$j++] = $1.addopts; /*1152*/
				$0.ean2(); /*1152*/
			} /*1152*/
			if ($1.addon.length == 5) { /*1153*/
				$k[$j++] = $1.addon; /*1153*/
				$k[$j++] = $1.addopts; /*1153*/
				$0.ean5(); /*1153*/
			} /*1153*/
			$1.addcode = $k[--$j]; /*1154*/
			$k[$j++] = "sbs"; /*1155*/
			$k[$j++] = Infinity; /*1155*/
			$aload($1.sbs); /*1155*/
			$k[$j++] = $1.addongap; /*1155*/
			$aload($1.addcode.sbs); /*1155*/
			var _2l = $a(); /*1155*/
			$1[$k[--$j]] = _2l; /*1155*/
			$k[$j++] = "bhs"; /*1156*/
			$k[$j++] = Infinity; /*1156*/
			$aload($1.bhs); /*1156*/
			$forall($1.addcode.bhs, function() { /*1156*/
				var _2q = $k[--$j]; /*1156*/
				$k[$j++] = _2q - 0.075; /*1156*/
			}) /*1156*/
			var _2r = $a(); /*1156*/
			$1[$k[--$j]] = _2r; /*1156*/
			$k[$j++] = "bbs"; /*1157*/
			$k[$j++] = Infinity; /*1157*/
			$aload($1.bbs); /*1157*/
			$forall($1.addcode.bbs, function() { /*1157*/
				var _2w = $k[--$j]; /*1157*/
				$k[$j++] = _2w + 0.075; /*1157*/
			}) /*1157*/
			var _2x = $a(); /*1157*/
			$1[$k[--$j]] = _2x; /*1157*/
			$k[$j++] = "txt"; /*1158*/
			$k[$j++] = Infinity; /*1158*/
			$aload($1.txt); /*1158*/
			$aload($1.addcode.txt); /*1158*/
			var _32 = $a(); /*1158*/
			$1[$k[--$j]] = _32; /*1158*/
			$1.guardrightypos = ($1.height * 72) - 6; /*1159*/
		} /*1159*/
		var _3B = {
			ren: $0.renlinear,
			sbs: $1.sbs,
			bhs: $1.bhs,
			bbs: $1.bbs,
			txt: $1.txt,
			opt: $1.options,
			guardleftpos: 10,
			guardrightpos: 10,
			guardrightypos: $1.guardrightypos,
			borderbottom: 5
		}; /*1173*/
		$k[$j++] = _3B; /*1176*/
		if (!$1.dontdraw) { /*1176*/
			$0.renlinear(); /*1176*/
		} /*1176*/
	};
	$0.upca = function() {
		var $1 = {}; /*1205*/
		$1.options = $k[--$j]; /*1207*/
		$1.barcode = $k[--$j]; /*1208*/
		$1.dontdraw = false; /*1210*/
		$1.includetext = false; /*1211*/
		$1.textfont = "Helvetica"; /*1212*/
		$1.textsize = 12; /*1213*/
		$1.textxoffset = -7; /*1214*/
		$1.textyoffset = -4.5; /*1215*/
		$1.height = 1; /*1216*/
		$1.addongap = 12; /*1217*/
		$1.addontextfont = "unset"; /*1218*/
		$1.addontextsize = "unset"; /*1219*/
		$1.addontextxoffset = "unset"; /*1220*/
		$1.addontextyoffset = "unset"; /*1221*/
		$forall($1.options, function() { /*1232*/
			var _3 = $k[--$j]; /*1232*/
			$1[$k[--$j]] = _3; /*1232*/
		}) /*1232*/
		$1.textfont = "" + $1.textfont; /*1234*/
		$1.textsize = +$1.textsize; /*1235*/
		$1.textxoffset = +$1.textxoffset; /*1236*/
		$1.textyoffset = +$1.textyoffset; /*1237*/
		$1.height = +$1.height; /*1238*/
		$1.addongap = +$1.addongap; /*1239*/
		if ($ne($1.addontextfont, "unset")) { /*1240*/
			$1.addontextfont = "" + $1.addontextfont; /*1240*/
		} /*1240*/
		if ($ne($1.addontextsize, "unset")) { /*1241*/
			$1.addontextsize = +$1.addontextsize; /*1241*/
		} /*1241*/
		if ($ne($1.addontextxoffset, "unset")) { /*1242*/
			$1.addontextxoffset = +$1.addontextxoffset; /*1242*/
		} /*1242*/
		if ($ne($1.addontextyoffset, "unset")) { /*1243*/
			$1.addontextyoffset = +$1.addontextyoffset; /*1243*/
		} /*1243*/
		$search($1.barcode, " "); /*1246*/
		if ($k[--$j]) { /*1252*/
			$1.barcode = $k[--$j]; /*1247*/
			$j--; /*1248*/
			$1.addon = $k[--$j]; /*1249*/
		} else { /*1252*/
			$j--; /*1251*/
			$1.addon = ""; /*1252*/
		} /*1252*/
		if (($1.barcode.length == 7) || ($1.barcode.length == 8)) { /*1298*/
			$forall($1.barcode, function() { /*1262*/
				var _Q = $k[--$j]; /*1259*/
				if ((_Q < 48) || (_Q > 57)) { /*1261*/
					$k[$j++] = "bwipp.upcAupcEbadCharacter"; /*1260*/
					$k[$j++] = "UPC-E must contain only digits"; /*1260*/
					$0.raiseerror(); /*1260*/
				} /*1260*/
			}) /*1260*/
			var _S = $get($1.barcode, 0); /*1263*/
			if ((_S != 48) && (_S != 49)) { /*1265*/
				$k[$j++] = "bwipp.upcAupcEbadNumberSystem"; /*1264*/
				$k[$j++] = "UPC-E must have number system 0 or 1"; /*1264*/
				$0.raiseerror(); /*1264*/
			} /*1264*/
			for (var _T = 0, _U = 1; _T < _U; _T++) { /*1293*/
				var _W = ($1.barcode.length == 8) ? 12 : 11; /*1267*/
				$1.upcacode = $s(_W); /*1267*/
				if (($get($1.barcode, 6) - 48) <= 2) { /*1274*/
					$puti($1.upcacode, 0, $geti($1.barcode, 0, 3)); /*1269*/
					$puti($1.upcacode, 3, $geti($1.barcode, 6, 1)); /*1270*/
					$puti($1.upcacode, 4, "0000"); /*1271*/
					$puti($1.upcacode, 8, $geti($1.barcode, 3, 3)); /*1272*/
					break; /*1273*/
				} /*1273*/
				if (($get($1.barcode, 6) - 48) == 3) { /*1280*/
					$puti($1.upcacode, 0, $geti($1.barcode, 0, 4)); /*1276*/
					$puti($1.upcacode, 4, "00000"); /*1277*/
					$puti($1.upcacode, 9, $geti($1.barcode, 4, 2)); /*1278*/
					break; /*1279*/
				} /*1279*/
				if (($get($1.barcode, 6) - 48) == 4) { /*1286*/
					$puti($1.upcacode, 0, $geti($1.barcode, 0, 5)); /*1282*/
					$puti($1.upcacode, 5, "00000"); /*1283*/
					$puti($1.upcacode, 10, $geti($1.barcode, 5, 1)); /*1284*/
					break; /*1285*/
				} /*1285*/
				if (($get($1.barcode, 6) - 48) >= 5) { /*1292*/
					$puti($1.upcacode, 0, $geti($1.barcode, 0, 6)); /*1288*/
					$puti($1.upcacode, 6, "0000"); /*1289*/
					$puti($1.upcacode, 10, $geti($1.barcode, 6, 1)); /*1290*/
					break; /*1291*/
				} /*1291*/
			} /*1291*/
			if ($1.barcode.length == 8) { /*1296*/
				$puti($1.upcacode, 11, $geti($1.barcode, 7, 1)); /*1295*/
			} /*1295*/
			$1.barcode = $1.upcacode; /*1297*/
		} /*1297*/
		if (($1.barcode.length != 11) && ($1.barcode.length != 12)) { /*1303*/
			$k[$j++] = "bwipp.upcAbadLength"; /*1302*/
			$k[$j++] = "UPC-A must be 11 or 12 digits"; /*1302*/
			$0.raiseerror(); /*1302*/
		} /*1302*/
		var _1I = $1.barcode; /*1304*/
		for (var _1J = 0, _1K = _1I.length; _1J < _1K; _1J++) { /*1308*/
			var _1L = $get(_1I, _1J); /*1308*/
			if ((_1L < 48) || (_1L > 57)) { /*1307*/
				$k[$j++] = "bwipp.upcAbadCharacter"; /*1306*/
				$k[$j++] = "UPC-A must contain only digits"; /*1306*/
				$0.raiseerror(); /*1306*/
			} /*1306*/
		} /*1306*/
		if ((($1.addon.length != 0) && ($1.addon.length != 2)) && ($1.addon.length != 5)) { /*1311*/
			$k[$j++] = "bwipp.upcAbadAddOnLength"; /*1310*/
			$k[$j++] = "Add-on for UPC-A must be 2 or 5 digits"; /*1310*/
			$0.raiseerror(); /*1310*/
		} /*1310*/
		$1.pad = $s(12); /*1314*/
		$1.checksum = 0; /*1315*/
		for (var _1Q = 0; _1Q <= 10; _1Q += 1) { /*1324*/
			$1.i = _1Q; /*1317*/
			$1.barchar = $get($1.barcode, $1.i) - 48; /*1318*/
			if (($1.i % 2) != 0) { /*1322*/
				$1.checksum = $1.checksum + $1.barchar; /*1320*/
			} else { /*1322*/
				$1.checksum = $1.checksum + ($1.barchar * 3); /*1322*/
			} /*1322*/
		} /*1322*/
		$1.checksum = (10 - ($1.checksum % 10)) % 10; /*1325*/
		if ($1.barcode.length == 12) { /*1330*/
			if ($get($1.barcode, 11) != ($1.checksum + 48)) { /*1329*/
				$k[$j++] = "bwipp.upcAbadCheckDigit"; /*1328*/
				$k[$j++] = "Incorrect UPC check digit provided"; /*1328*/
				$0.raiseerror(); /*1328*/
			} /*1328*/
		} /*1328*/
		$puti($1.pad, 0, $1.barcode); /*1331*/
		$put($1.pad, 11, $1.checksum + 48); /*1332*/
		$1.barcode = $1.pad; /*1333*/
		$1.encs = $a(["3211", "2221", "2122", "1411", "1132", "1231", "1114", "1312", "1213", "3112", "111", "11111", "111"]); /*1340*/
		$1.barchars = "0123456789"; /*1343*/
		$1.sbs = $s(59); /*1345*/
		$1.txt = $a(12); /*1346*/
		$puti($1.sbs, 0, $get($1.encs, 10)); /*1349*/
		for (var _1p = 0; _1p <= 5; _1p += 1) { /*1366*/
			$1.i = _1p; /*1354*/
			$search($1.barchars, $geti($1.barcode, $1.i, 1)); /*1355*/
			$j--; /*1356*/
			$1.indx = $k[--$j].length; /*1357*/
			$j -= 2; /*1358*/
			$1.enc = $get($1.encs, $1.indx); /*1359*/
			$puti($1.sbs, ($1.i * 4) + 3, $1.enc); /*1360*/
			if ($1.i == 0) { /*1364*/
				$put($1.txt, 0, $a([$geti($1.barcode, 0, 1), $1.textxoffset, $1.textyoffset, $1.textfont, $1.textsize - 2])); /*1362*/
			} else { /*1364*/
				$put($1.txt, $1.i, $a([$geti($1.barcode, $1.i, 1), (($1.i * 7) + 11) + $1.textxoffset, $1.textyoffset, $1.textfont, $1.textsize])); /*1364*/
			} /*1364*/
		} /*1364*/
		$puti($1.sbs, (6 * 4) + 3, $get($1.encs, 11)); /*1369*/
		for (var _2O = 6; _2O <= 11; _2O += 1) { /*1386*/
			$1.i = _2O; /*1374*/
			$search($1.barchars, $geti($1.barcode, $1.i, 1)); /*1375*/
			$j--; /*1376*/
			$1.indx = $k[--$j].length; /*1377*/
			$j -= 2; /*1378*/
			$1.enc = $get($1.encs, $1.indx); /*1379*/
			$puti($1.sbs, ($1.i * 4) + 8, $1.enc); /*1380*/
			if ($1.i == 11) { /*1384*/
				$put($1.txt, 11, $a([$geti($1.barcode, 11, 1), $1.textxoffset + 103, $1.textyoffset, $1.textfont, $1.textsize - 2])); /*1382*/
			} else { /*1384*/
				$put($1.txt, $1.i, $a([$geti($1.barcode, $1.i, 1), (($1.i * 7) + $1.textxoffset) + 15, $1.textyoffset, $1.textfont, $1.textsize])); /*1384*/
			} /*1384*/
		} /*1384*/
		$puti($1.sbs, 56, $get($1.encs, 12)); /*1389*/
		$k[$j++] = "sbs"; /*1391*/
		$k[$j++] = Infinity; /*1391*/
		var _2x = $1.sbs; /*1391*/
		for (var _2y = 0, _2z = _2x.length; _2y < _2z; _2y++) { /*1391*/
			$k[$j++] = $get(_2x, _2y) - 48; /*1391*/
		} /*1391*/
		var _31 = $a(); /*1391*/
		$1[$k[--$j]] = _31; /*1391*/
		if ($1.includetext) { /*1398*/
			$k[$j++] = "bhs"; /*1393*/
			$k[$j++] = Infinity; /*1393*/
			for (var _34 = 0, _35 = 4; _34 < _35; _34++) { /*1393*/
				$k[$j++] = $1.height; /*1393*/
			} /*1393*/
			for (var _37 = 0, _38 = 10; _37 < _38; _37++) { /*1393*/
				$k[$j++] = $1.height - 0.075; /*1393*/
			} /*1393*/
			$k[$j++] = $1.height; /*1393*/
			$k[$j++] = $1.height; /*1393*/
			for (var _3C = 0, _3D = 10; _3C < _3D; _3C++) { /*1393*/
				$k[$j++] = $1.height - 0.075; /*1393*/
			} /*1393*/
			for (var _3F = 0, _3G = 4; _3F < _3G; _3F++) { /*1393*/
				$k[$j++] = $1.height; /*1393*/
			} /*1393*/
			var _3I = $a(); /*1393*/
			$1[$k[--$j]] = _3I; /*1393*/
			$k[$j++] = "bbs"; /*1394*/
			$k[$j++] = Infinity; /*1394*/
			$k[$j++] = 0; /*1394*/
			$k[$j++] = 0; /*1394*/
			$k[$j++] = 0; /*1394*/
			$k[$j++] = 0; /*1394*/
			for (var _3K = 0, _3L = 10; _3K < _3L; _3K++) { /*1394*/
				$k[$j++] = 0.075; /*1394*/
			} /*1394*/
			$k[$j++] = 0; /*1394*/
			$k[$j++] = 0; /*1394*/
			for (var _3M = 0, _3N = 10; _3M < _3N; _3M++) { /*1394*/
				$k[$j++] = 0.075; /*1394*/
			} /*1394*/
			$k[$j++] = 0; /*1394*/
			$k[$j++] = 0; /*1394*/
			$k[$j++] = 0; /*1394*/
			$k[$j++] = 0; /*1394*/
			var _3O = $a(); /*1394*/
			$1[$k[--$j]] = _3O; /*1394*/
		} else { /*1398*/
			$k[$j++] = "bhs"; /*1396*/
			$k[$j++] = Infinity; /*1396*/
			for (var _3Q = 0, _3R = 30; _3Q < _3R; _3Q++) { /*1396*/
				$k[$j++] = $1.height; /*1396*/
			} /*1396*/
			var _3T = $a(); /*1396*/
			$1[$k[--$j]] = _3T; /*1396*/
			$k[$j++] = "bbs"; /*1397*/
			$k[$j++] = Infinity; /*1397*/
			for (var _3V = 0, _3W = 30; _3V < _3W; _3V++) { /*1397*/
				$k[$j++] = 0; /*1397*/
			} /*1397*/
			var _3X = $a(); /*1397*/
			$1[$k[--$j]] = _3X; /*1397*/
			$1.txt = $a([]); /*1398*/
		} /*1398*/
		$1.guardrightypos = 0; /*1400*/
		if ($ne($1.addon, "")) { /*1421*/
			$k[$j++] = "addopts"; /*1411*/
			$k[$j++] = Infinity; /*1411*/
			$k[$j++] = "dontdraw"; /*1408*/
			$k[$j++] = true; /*1408*/
			$k[$j++] = "includetext"; /*1408*/
			$k[$j++] = true; /*1408*/
			$k[$j++] = "height"; /*1408*/
			$k[$j++] = $1.height - 0.15; /*1408*/
			$k[$j++] = "textxoffset"; /*1408*/
			if ($1.addontextxoffset != "unset") { /*1408*/
				$k[$j++] = $1.addontextxoffset; /*1408*/
			} else { /*1408*/
				$k[$j++] = 95 + $1.addongap; /*1408*/
			} /*1408*/
			if ($1.addontextyoffset != "unset") { /*1409*/
				$k[$j++] = "textyoffset"; /*1409*/
				$k[$j++] = $1.addontextyoffset; /*1409*/
			} /*1409*/
			$k[$j++] = "textsize"; /*1410*/
			if ($1.addontextsize != "unset") { /*1410*/
				$k[$j++] = $1.addontextsize; /*1410*/
			} else { /*1410*/
				$k[$j++] = $1.textsize; /*1410*/
			} /*1410*/
			$k[$j++] = "textfont"; /*1411*/
			if ($ne($1.addontextfont, "unset")) { /*1411*/
				$k[$j++] = $1.addontextfont; /*1411*/
			} else { /*1411*/
				$k[$j++] = $1.textfont; /*1411*/
			} /*1411*/
			var _3n = $d(); /*1411*/
			$1[$k[--$j]] = _3n; /*1412*/
			if ($1.addon.length == 2) { /*1413*/
				$k[$j++] = $1.addon; /*1413*/
				$k[$j++] = $1.addopts; /*1413*/
				$0.ean2(); /*1413*/
			} /*1413*/
			if ($1.addon.length == 5) { /*1414*/
				$k[$j++] = $1.addon; /*1414*/
				$k[$j++] = $1.addopts; /*1414*/
				$0.ean5(); /*1414*/
			} /*1414*/
			$1.addcode = $k[--$j]; /*1415*/
			$k[$j++] = "sbs"; /*1416*/
			$k[$j++] = Infinity; /*1416*/
			$aload($1.sbs); /*1416*/
			$k[$j++] = $1.addongap; /*1416*/
			$aload($1.addcode.sbs); /*1416*/
			var _40 = $a(); /*1416*/
			$1[$k[--$j]] = _40; /*1416*/
			$k[$j++] = "bhs"; /*1417*/
			$k[$j++] = Infinity; /*1417*/
			$aload($1.bhs); /*1417*/
			$forall($1.addcode.bhs, function() { /*1417*/
				var _45 = $k[--$j]; /*1417*/
				$k[$j++] = _45 - 0.075; /*1417*/
			}) /*1417*/
			var _46 = $a(); /*1417*/
			$1[$k[--$j]] = _46; /*1417*/
			$k[$j++] = "bbs"; /*1418*/
			$k[$j++] = Infinity; /*1418*/
			$aload($1.bbs); /*1418*/
			$forall($1.addcode.bbs, function() { /*1418*/
				var _4B = $k[--$j]; /*1418*/
				$k[$j++] = _4B + 0.075; /*1418*/
			}) /*1418*/
			var _4C = $a(); /*1418*/
			$1[$k[--$j]] = _4C; /*1418*/
			$k[$j++] = "txt"; /*1419*/
			$k[$j++] = Infinity; /*1419*/
			$aload($1.txt); /*1419*/
			$aload($1.addcode.txt); /*1419*/
			var _4H = $a(); /*1419*/
			$1[$k[--$j]] = _4H; /*1419*/
			$1.guardrightypos = ($1.height * 72) - 6; /*1420*/
		} /*1420*/
		var _4Q = {
			ren: $0.renlinear,
			sbs: $1.sbs,
			bhs: $1.bhs,
			bbs: $1.bbs,
			txt: $1.txt,
			opt: $1.options,
			guardrightpos: 10,
			guardrightypos: $1.guardrightypos,
			borderbottom: 5
		}; /*1433*/
		$k[$j++] = _4Q; /*1436*/
		if (!$1.dontdraw) { /*1436*/
			$0.renlinear(); /*1436*/
		} /*1436*/
	};
	$0.upce = function() {
		var $1 = {}; /*1465*/
		$1.options = $k[--$j]; /*1467*/
		$1.barcode = $k[--$j]; /*1468*/
		$1.dontdraw = false; /*1470*/
		$1.includetext = false; /*1471*/
		$1.textfont = "Helvetica"; /*1472*/
		$1.textsize = 12; /*1473*/
		$1.textxoffset = -7; /*1474*/
		$1.textyoffset = -4.5; /*1475*/
		$1.height = 1; /*1476*/
		$1.addongap = 12; /*1477*/
		$1.addontextfont = "unset"; /*1478*/
		$1.addontextsize = "unset"; /*1479*/
		$1.addontextxoffset = "unset"; /*1480*/
		$1.addontextyoffset = "unset"; /*1481*/
		$forall($1.options, function() { /*1492*/
			var _3 = $k[--$j]; /*1492*/
			$1[$k[--$j]] = _3; /*1492*/
		}) /*1492*/
		$1.textfont = "" + $1.textfont; /*1494*/
		$1.textsize = +$1.textsize; /*1495*/
		$1.textxoffset = +$1.textxoffset; /*1496*/
		$1.textyoffset = +$1.textyoffset; /*1497*/
		$1.height = +$1.height; /*1498*/
		$1.addongap = +$1.addongap; /*1499*/
		if ($ne($1.addontextfont, "unset")) { /*1500*/
			$1.addontextfont = "" + $1.addontextfont; /*1500*/
		} /*1500*/
		if ($ne($1.addontextsize, "unset")) { /*1501*/
			$1.addontextsize = +$1.addontextsize; /*1501*/
		} /*1501*/
		if ($ne($1.addontextxoffset, "unset")) { /*1502*/
			$1.addontextxoffset = +$1.addontextxoffset; /*1502*/
		} /*1502*/
		if ($ne($1.addontextyoffset, "unset")) { /*1503*/
			$1.addontextyoffset = +$1.addontextyoffset; /*1503*/
		} /*1503*/
		$search($1.barcode, " "); /*1506*/
		if ($k[--$j]) { /*1512*/
			$1.barcode = $k[--$j]; /*1507*/
			$j--; /*1508*/
			$1.addon = $k[--$j]; /*1509*/
		} else { /*1512*/
			$j--; /*1511*/
			$1.addon = ""; /*1512*/
		} /*1512*/
		if (($1.barcode.length == 11) || ($1.barcode.length == 12)) { /*1554*/
			$forall($1.barcode, function() { /*1522*/
				var _Q = $k[--$j]; /*1519*/
				if ((_Q < 48) || (_Q > 57)) { /*1521*/
					$k[$j++] = "bwipp.upcEupcAbadCharacter"; /*1520*/
					$k[$j++] = "UPC-A must contain only digits"; /*1520*/
					$0.raiseerror(); /*1520*/
				} /*1520*/
			}) /*1520*/
			for (var _R = 0, _S = 1; _R < _S; _R++) { /*1549*/
				var _U = ($1.barcode.length == 12) ? 8 : 7; /*1524*/
				$1.upcecode = $s(_U); /*1524*/
				if ((($get($1.barcode, 3) - 48) <= 2) && $eq($geti($1.barcode, 4, 4), "0000")) { /*1530*/
					$puti($1.upcecode, 0, $geti($1.barcode, 0, 3)); /*1526*/
					$puti($1.upcecode, 3, $geti($1.barcode, 8, 3)); /*1527*/
					$puti($1.upcecode, 6, $geti($1.barcode, 3, 1)); /*1528*/
					break; /*1529*/
				} /*1529*/
				if ($eq($geti($1.barcode, 4, 5), "00000")) { /*1536*/
					$puti($1.upcecode, 0, $geti($1.barcode, 0, 4)); /*1532*/
					$puti($1.upcecode, 4, $geti($1.barcode, 9, 2)); /*1533*/
					$puti($1.upcecode, 6, "3"); /*1534*/
					break; /*1535*/
				} /*1535*/
				if ($eq($geti($1.barcode, 5, 5), "00000")) { /*1542*/
					$puti($1.upcecode, 0, $geti($1.barcode, 0, 5)); /*1538*/
					$puti($1.upcecode, 5, $geti($1.barcode, 10, 1)); /*1539*/
					$puti($1.upcecode, 6, "4"); /*1540*/
					break; /*1541*/
				} /*1541*/
				if ((($get($1.barcode, 10) - 48) >= 5) && $eq($geti($1.barcode, 6, 4), "0000")) { /*1547*/
					$puti($1.upcecode, 0, $geti($1.barcode, 0, 6)); /*1544*/
					$puti($1.upcecode, 6, $geti($1.barcode, 10, 1)); /*1545*/
					break; /*1546*/
				} /*1546*/
				$k[$j++] = "bwipp.upcEupcAnotCompressible"; /*1548*/
				$k[$j++] = "UPC-A cannot be converted to a UPC-E"; /*1548*/
				$0.raiseerror(); /*1548*/
			} /*1548*/
			if ($1.barcode.length == 12) { /*1552*/
				$puti($1.upcecode, 7, $geti($1.barcode, 11, 1)); /*1551*/
			} /*1551*/
			$1.barcode = $1.upcecode; /*1553*/
		} /*1553*/
		if (($1.barcode.length != 7) && ($1.barcode.length != 8)) { /*1559*/
			$k[$j++] = "bwipp.upcEbadLength"; /*1558*/
			$k[$j++] = "UPC-E must be 7 or 8 digits"; /*1558*/
			$0.raiseerror(); /*1558*/
		} /*1558*/
		var _1I = $1.barcode; /*1560*/
		for (var _1J = 0, _1K = _1I.length; _1J < _1K; _1J++) { /*1564*/
			var _1L = $get(_1I, _1J); /*1564*/
			if ((_1L < 48) || (_1L > 57)) { /*1563*/
				$k[$j++] = "bwipp.upcEbadCharacter"; /*1562*/
				$k[$j++] = "UPC-E must contain only digits"; /*1562*/
				$0.raiseerror(); /*1562*/
			} /*1562*/
		} /*1562*/
		if ((($1.addon.length != 0) && ($1.addon.length != 2)) && ($1.addon.length != 5)) { /*1567*/
			$k[$j++] = "bwipp.upcEbadAddOnLength"; /*1566*/
			$k[$j++] = "Add-on for UPC-E must be 2 or 5 digits"; /*1566*/
			$0.raiseerror(); /*1566*/
		} /*1566*/
		var _1Q = $get($1.barcode, 0); /*1570*/
		if ((_1Q != 48) && (_1Q != 49)) { /*1572*/
			$k[$j++] = "bwipp.upcEbadNumberSystem"; /*1571*/
			$k[$j++] = "UPC-E must have number system 0 or 1"; /*1571*/
			$0.raiseerror(); /*1571*/
		} /*1571*/
		$1.encs = $a(["3211", "2221", "2122", "1411", "1132", "1231", "1114", "1312", "1213", "3112", "111", "111111"]); /*1579*/
		$1.barchars = "0123456789"; /*1582*/
		$1.mirrormaps = $a(["000111", "001011", "001101", "001110", "010011", "011001", "011100", "010101", "010110", "011010"]); /*1587*/
		for (var _1T = 0, _1U = 1; _1T < _1U; _1T++) { /*1617*/
			$1.upcacode = $s(11); /*1591*/
			if (($get($1.barcode, 6) - 48) <= 2) { /*1598*/
				$puti($1.upcacode, 0, $geti($1.barcode, 0, 3)); /*1593*/
				$puti($1.upcacode, 3, $geti($1.barcode, 6, 1)); /*1594*/
				$puti($1.upcacode, 4, "0000"); /*1595*/
				$puti($1.upcacode, 8, $geti($1.barcode, 3, 3)); /*1596*/
				break; /*1597*/
			} /*1597*/
			if (($get($1.barcode, 6) - 48) == 3) { /*1604*/
				$puti($1.upcacode, 0, $geti($1.barcode, 0, 4)); /*1600*/
				$puti($1.upcacode, 4, "00000"); /*1601*/
				$puti($1.upcacode, 9, $geti($1.barcode, 4, 2)); /*1602*/
				break; /*1603*/
			} /*1603*/
			if (($get($1.barcode, 6) - 48) == 4) { /*1610*/
				$puti($1.upcacode, 0, $geti($1.barcode, 0, 5)); /*1606*/
				$puti($1.upcacode, 5, "00000"); /*1607*/
				$puti($1.upcacode, 10, $geti($1.barcode, 5, 1)); /*1608*/
				break; /*1609*/
			} /*1609*/
			if (($get($1.barcode, 6) - 48) >= 5) { /*1616*/
				$puti($1.upcacode, 0, $geti($1.barcode, 0, 6)); /*1612*/
				$puti($1.upcacode, 6, "0000"); /*1613*/
				$puti($1.upcacode, 10, $geti($1.barcode, 6, 1)); /*1614*/
				break; /*1615*/
			} /*1615*/
		} /*1615*/
		$1.checksum = 0; /*1618*/
		for (var _29 = 0; _29 <= 10; _29 += 1) { /*1627*/
			$1.i = _29; /*1620*/
			$1.barchar = $get($1.upcacode, $1.i) - 48; /*1621*/
			if (($1.i % 2) != 0) { /*1625*/
				$1.checksum = $1.checksum + $1.barchar; /*1623*/
			} else { /*1625*/
				$1.checksum = $1.checksum + ($1.barchar * 3); /*1625*/
			} /*1625*/
		} /*1625*/
		$1.checksum = (10 - ($1.checksum % 10)) % 10; /*1628*/
		if ($1.barcode.length == 8) { /*1633*/
			if ($get($1.barcode, 7) != ($1.checksum + 48)) { /*1632*/
				$k[$j++] = "bwipp.upcEbadCheckDigit"; /*1631*/
				$k[$j++] = "Incorrect UPC check digit provided"; /*1631*/
				$0.raiseerror(); /*1631*/
			} /*1631*/
		} /*1631*/
		$1.pad = $s(8); /*1634*/
		$puti($1.pad, 0, $1.barcode); /*1635*/
		$put($1.pad, 7, $1.checksum + 48); /*1636*/
		$1.barcode = $1.pad; /*1637*/
		$1.txt = $a(8); /*1638*/
		$put($1.txt, 0, $a([$geti($1.barcode, 0, 1), $1.textxoffset, $1.textyoffset, $1.textfont, $1.textsize - 2])); /*1639*/
		$1.mirrormap = $get($1.mirrormaps, $1.checksum); /*1642*/
		if ($get($1.barcode, 0) == 48) { /*1656*/
			$1.invt = $s($1.mirrormap.length); /*1646*/
			for (var _2l = 0, _2k = $1.mirrormap.length - 1; _2l <= _2k; _2l += 1) { /*1654*/
				$1.i = _2l; /*1648*/
				if ($get($1.mirrormap, $1.i) == 48) { /*1652*/
					$put($1.invt, $1.i, 49); /*1650*/
				} else { /*1652*/
					$put($1.invt, $1.i, 48); /*1652*/
				} /*1652*/
			} /*1652*/
			$1.mirrormap = $1.invt; /*1655*/
		} /*1655*/
		$1.sbs = $s(33); /*1658*/
		$puti($1.sbs, 0, $get($1.encs, 10)); /*1661*/
		for (var _2y = 1; _2y <= 6; _2y += 1) { /*1683*/
			$1.i = _2y; /*1664*/
			$search($1.barchars, $geti($1.barcode, $1.i, 1)); /*1666*/
			$j--; /*1667*/
			$1.indx = $k[--$j].length; /*1668*/
			$j -= 2; /*1669*/
			$1.enc = $get($1.encs, $1.indx); /*1670*/
			if ($get($1.mirrormap, $1.i - 1) == 49) { /*1680*/
				$1.enclen = $1.enc.length; /*1672*/
				$1.revenc = $s($1.enclen); /*1673*/
				for (var _3F = 0, _3E = $1.enclen - 1; _3F <= _3E; _3F += 1) { /*1678*/
					$1.j = _3F; /*1675*/
					$1.char = $get($1.enc, $1.j); /*1676*/
					$put($1.revenc, ($1.enclen - $1.j) - 1, $1.char); /*1677*/
				} /*1677*/
				$1.enc = $1.revenc; /*1679*/
			} /*1679*/
			$puti($1.sbs, (($1.i - 1) * 4) + 3, $1.enc); /*1681*/
			$put($1.txt, $1.i, $a([$geti($1.barcode, $1.i, 1), ((($1.i - 1) * 7) + 11) + $1.textxoffset, $1.textyoffset, $1.textfont, $1.textsize])); /*1682*/
		} /*1682*/
		$put($1.txt, 7, $a([$geti($1.barcode, 7, 1), ((6 * 7) + 18) + $1.textxoffset, $1.textyoffset, $1.textfont, $1.textsize - 2])); /*1685*/
		$puti($1.sbs, 27, $get($1.encs, 11)); /*1688*/
		$k[$j++] = "sbs"; /*1690*/
		$k[$j++] = Infinity; /*1690*/
		var _3n = $1.sbs; /*1690*/
		for (var _3o = 0, _3p = _3n.length; _3o < _3p; _3o++) { /*1690*/
			$k[$j++] = $get(_3n, _3o) - 48; /*1690*/
		} /*1690*/
		var _3r = $a(); /*1690*/
		$1[$k[--$j]] = _3r; /*1690*/
		if ($1.includetext) { /*1697*/
			$k[$j++] = "bhs"; /*1692*/
			$k[$j++] = Infinity; /*1692*/
			$k[$j++] = $1.height; /*1692*/
			$k[$j++] = $1.height; /*1692*/
			for (var _3w = 0, _3x = 12; _3w < _3x; _3w++) { /*1692*/
				$k[$j++] = $1.height - 0.075; /*1692*/
			} /*1692*/
			$k[$j++] = $1.height; /*1692*/
			$k[$j++] = $1.height; /*1692*/
			$k[$j++] = $1.height; /*1692*/
			var _42 = $a(); /*1692*/
			$1[$k[--$j]] = _42; /*1692*/
			$k[$j++] = "bbs"; /*1693*/
			$k[$j++] = Infinity; /*1693*/
			$k[$j++] = 0; /*1693*/
			$k[$j++] = 0; /*1693*/
			for (var _44 = 0, _45 = 12; _44 < _45; _44++) { /*1693*/
				$k[$j++] = 0.075; /*1693*/
			} /*1693*/
			$k[$j++] = 0; /*1693*/
			$k[$j++] = 0; /*1693*/
			$k[$j++] = 0; /*1693*/
			var _46 = $a(); /*1693*/
			$1[$k[--$j]] = _46; /*1693*/
		} else { /*1697*/
			$k[$j++] = "bhs"; /*1695*/
			$k[$j++] = Infinity; /*1695*/
			for (var _48 = 0, _49 = 17; _48 < _49; _48++) { /*1695*/
				$k[$j++] = $1.height; /*1695*/
			} /*1695*/
			var _4B = $a(); /*1695*/
			$1[$k[--$j]] = _4B; /*1695*/
			$k[$j++] = "bbs"; /*1696*/
			$k[$j++] = Infinity; /*1696*/
			for (var _4D = 0, _4E = 17; _4D < _4E; _4D++) { /*1696*/
				$k[$j++] = 0; /*1696*/
			} /*1696*/
			var _4F = $a(); /*1696*/
			$1[$k[--$j]] = _4F; /*1696*/
			$1.txt = $a([]); /*1697*/
		} /*1697*/
		$1.guardrightypos = 0; /*1699*/
		if ($ne($1.addon, "")) { /*1720*/
			$k[$j++] = "addopts"; /*1710*/
			$k[$j++] = Infinity; /*1710*/
			$k[$j++] = "dontdraw"; /*1707*/
			$k[$j++] = true; /*1707*/
			$k[$j++] = "includetext"; /*1707*/
			$k[$j++] = true; /*1707*/
			$k[$j++] = "height"; /*1707*/
			$k[$j++] = $1.height - 0.15; /*1707*/
			$k[$j++] = "textxoffset"; /*1707*/
			if ($1.addontextxoffset != "unset") { /*1707*/
				$k[$j++] = $1.addontextxoffset; /*1707*/
			} else { /*1707*/
				$k[$j++] = 51 + $1.addongap; /*1707*/
			} /*1707*/
			if ($1.addontextyoffset != "unset") { /*1708*/
				$k[$j++] = "textyoffset"; /*1708*/
				$k[$j++] = $1.addontextyoffset; /*1708*/
			} /*1708*/
			$k[$j++] = "textsize"; /*1709*/
			if ($1.addontextsize != "unset") { /*1709*/
				$k[$j++] = $1.addontextsize; /*1709*/
			} else { /*1709*/
				$k[$j++] = $1.textsize; /*1709*/
			} /*1709*/
			$k[$j++] = "textfont"; /*1710*/
			if ($ne($1.addontextfont, "unset")) { /*1710*/
				$k[$j++] = $1.addontextfont; /*1710*/
			} else { /*1710*/
				$k[$j++] = $1.textfont; /*1710*/
			} /*1710*/
			var _4V = $d(); /*1710*/
			$1[$k[--$j]] = _4V; /*1711*/
			if ($1.addon.length == 2) { /*1712*/
				$k[$j++] = $1.addon; /*1712*/
				$k[$j++] = $1.addopts; /*1712*/
				$0.ean2(); /*1712*/
			} /*1712*/
			if ($1.addon.length == 5) { /*1713*/
				$k[$j++] = $1.addon; /*1713*/
				$k[$j++] = $1.addopts; /*1713*/
				$0.ean5(); /*1713*/
			} /*1713*/
			$1.addcode = $k[--$j]; /*1714*/
			$k[$j++] = "sbs"; /*1715*/
			$k[$j++] = Infinity; /*1715*/
			$aload($1.sbs); /*1715*/
			$k[$j++] = $1.addongap; /*1715*/
			$aload($1.addcode.sbs); /*1715*/
			var _4i = $a(); /*1715*/
			$1[$k[--$j]] = _4i; /*1715*/
			$k[$j++] = "bhs"; /*1716*/
			$k[$j++] = Infinity; /*1716*/
			$aload($1.bhs); /*1716*/
			$forall($1.addcode.bhs, function() { /*1716*/
				var _4n = $k[--$j]; /*1716*/
				$k[$j++] = _4n - 0.075; /*1716*/
			}) /*1716*/
			var _4o = $a(); /*1716*/
			$1[$k[--$j]] = _4o; /*1716*/
			$k[$j++] = "bbs"; /*1717*/
			$k[$j++] = Infinity; /*1717*/
			$aload($1.bbs); /*1717*/
			$forall($1.addcode.bbs, function() { /*1717*/
				var _4t = $k[--$j]; /*1717*/
				$k[$j++] = _4t + 0.075; /*1717*/
			}) /*1717*/
			var _4u = $a(); /*1717*/
			$1[$k[--$j]] = _4u; /*1717*/
			$k[$j++] = "txt"; /*1718*/
			$k[$j++] = Infinity; /*1718*/
			$aload($1.txt); /*1718*/
			$aload($1.addcode.txt); /*1718*/
			var _4z = $a(); /*1718*/
			$1[$k[--$j]] = _4z; /*1718*/
			$1.guardrightypos = ($1.height * 72) - 6; /*1719*/
		} /*1719*/
		var _58 = {
			ren: $0.renlinear,
			sbs: $1.sbs,
			bhs: $1.bhs,
			bbs: $1.bbs,
			txt: $1.txt,
			opt: $1.options,
			guardrightpos: 10,
			guardrightypos: $1.guardrightypos,
			borderbottom: 5
		}; /*1732*/
		$k[$j++] = _58; /*1735*/
		if (!$1.dontdraw) { /*1735*/
			$0.renlinear(); /*1735*/
		} /*1735*/
	};
	$0.isbn = function() {
		var $1 = {}; /*1763*/
		$1.options = $k[--$j]; /*1765*/
		$1.barcode = $k[--$j]; /*1766*/
		$1.dontdraw = false; /*1768*/
		$1.includetext = false; /*1769*/
		$1.isbntextfont = "OCR-A"; /*1770*/
		$1.isbntextsize = 8.5; /*1771*/
		$1.isbntextxoffset = "unset"; /*1772*/
		$1.isbntextyoffset = "unset"; /*1773*/
		$1.height = 1; /*1774*/
		$1.addongap = 12; /*1775*/
		$1.legacy = false; /*1776*/
		$forall($1.options, function() { /*1787*/
			var _3 = $k[--$j]; /*1787*/
			$1[$k[--$j]] = _3; /*1787*/
		}) /*1787*/
		$1.isbntextfont = "" + $1.isbntextfont; /*1789*/
		$1.isbntextsize = +$1.isbntextsize; /*1790*/
		if ($ne($1.isbntextxoffset, "unset")) { /*1791*/
			$1.isbntextxoffset = +$1.isbntextxoffset; /*1791*/
		} /*1791*/
		if ($ne($1.isbntextyoffset, "unset")) { /*1792*/
			$1.isbntextyoffset = +$1.isbntextyoffset; /*1792*/
		} /*1792*/
		$1.height = +$1.height; /*1793*/
		$1.addongap = +$1.addongap; /*1794*/
		$search($1.barcode, " "); /*1797*/
		if ($k[--$j]) { /*1803*/
			$1.barcode = $k[--$j]; /*1798*/
			$j--; /*1799*/
			$1.addon = $k[--$j]; /*1800*/
		} else { /*1803*/
			$j--; /*1802*/
			$1.addon = ""; /*1803*/
		} /*1803*/
		if ((($1.barcode.length != 15) && ($1.barcode.length != 17)) && (($1.barcode.length != 11) && ($1.barcode.length != 13))) { /*1810*/
			$k[$j++] = "bwipp.isbnBadLength"; /*1809*/
			$k[$j++] = "ISBN-13 must be 15 or 17 characters including dashes. ISBN-10 must be 11 or 13 characters including dashes"; /*1809*/
			$0.raiseerror(); /*1809*/
		} /*1809*/
		if ((($1.addon.length != 0) && ($1.addon.length != 2)) && ($1.addon.length != 5)) { /*1813*/
			$k[$j++] = "bwipp.isbnBadAddOnLength"; /*1812*/
			$k[$j++] = "Add-on for ISBN must be 2 or 5 digits"; /*1812*/
			$0.raiseerror(); /*1812*/
		} /*1812*/
		if ($1.barcode.length >= 15) { /*1877*/
			var _Q = $geti($1.barcode, 0, 4); /*1815*/
			if ($ne(_Q, "978-") && $ne(_Q, "979-")) { /*1817*/
				$k[$j++] = "bwipp.isbn13badPrefix"; /*1816*/
				$k[$j++] = "ISBN-13 prefix must be 978- or 979-"; /*1816*/
				$0.raiseerror(); /*1816*/
			} /*1816*/
			$1.wasdash = false; /*1818*/
			$1.numdash = 0; /*1818*/
			$1.numdigit = 0; /*1818*/
			$forall($geti($1.barcode, 5, 9), function() { /*1832*/
				var _T = $k[--$j]; /*1820*/
				$k[$j++] = _T; /*1827*/
				if (_T == 45) { /*1827*/
					if ($1.wasdash) { /*1824*/
						$k[$j++] = "bwipp.isbn13adjacentDashes"; /*1823*/
						$k[$j++] = "ISBN-13 does not permit adjacent dashes"; /*1823*/
						$0.raiseerror(); /*1823*/
					} /*1823*/
					$1.wasdash = true; /*1825*/
					$1.numdash = $1.numdash + 1; /*1826*/
				} /*1826*/
				var _W = $k[--$j]; /*1828*/
				if ((_W >= 48) && (_W <= 57)) { /*1831*/
					$1.wasdash = false; /*1829*/
					$1.numdigit = $1.numdigit + 1; /*1830*/
				} /*1830*/
			}) /*1830*/
			if (($1.numdash != 2) || ($1.numdigit != 7)) { /*1835*/
				$k[$j++] = "bwipp.isbn13numDashesDigits"; /*1834*/
				$k[$j++] = "Incorrect number of dashes and digits for ISBN-13"; /*1834*/
				$0.raiseerror(); /*1834*/
			} /*1834*/
			var _b = $get($1.barcode, 14); /*1836*/
			if ((_b < 48) || (_b > 57)) { /*1838*/
				$k[$j++] = "bwipp.isbn13character15"; /*1837*/
				$k[$j++] = "ISBN-13 character 15 must be a digit"; /*1837*/
				$0.raiseerror(); /*1837*/
			} /*1837*/
			if ($1.barcode.length == 17) { /*1846*/
				if ($ne($geti($1.barcode, 15, 1), "-")) { /*1842*/
					$k[$j++] = "bwipp.isbn13character16"; /*1841*/
					$k[$j++] = "ISBN-13 penultimate character must be a dash"; /*1841*/
					$0.raiseerror(); /*1841*/
				} /*1841*/
				var _g = $get($1.barcode, 16); /*1843*/
				if ((_g < 48) || (_g > 57)) { /*1845*/
					$k[$j++] = "bwipp.isbn13character17"; /*1844*/
					$k[$j++] = "ISBN-13 final character must be a digit"; /*1844*/
					$0.raiseerror(); /*1844*/
				} /*1844*/
			} /*1844*/
		} else { /*1877*/
			var _i = $get($1.barcode, 0); /*1848*/
			if ((_i < 48) || (_i > 57)) { /*1850*/
				$k[$j++] = "bwipp.isbn10FirstDigit"; /*1849*/
				$k[$j++] = "ISBN-10 first character must be a digit"; /*1849*/
				$0.raiseerror(); /*1849*/
			} /*1849*/
			$1.wasdash = false; /*1851*/
			$1.numdash = 0; /*1851*/
			$1.numdigit = 0; /*1851*/
			$forall($geti($1.barcode, 1, 9), function() { /*1865*/
				var _l = $k[--$j]; /*1853*/
				$k[$j++] = _l; /*1860*/
				if (_l == 45) { /*1860*/
					if ($1.wasdash) { /*1857*/
						$k[$j++] = "bwipp.isbn10adjacentDashes"; /*1856*/
						$k[$j++] = "ISBN-10 does not permit adjacent dashes"; /*1856*/
						$0.raiseerror(); /*1856*/
					} /*1856*/
					$1.wasdash = true; /*1858*/
					$1.numdash = $1.numdash + 1; /*1859*/
				} /*1859*/
				var _o = $k[--$j]; /*1861*/
				if ((_o >= 48) && (_o <= 57)) { /*1864*/
					$1.wasdash = false; /*1862*/
					$1.numdigit = $1.numdigit + 1; /*1863*/
				} /*1863*/
			}) /*1863*/
			if (($1.numdash != 2) || ($1.numdigit != 7)) { /*1868*/
				$k[$j++] = "bwipp.isbn10numDashesDigits"; /*1867*/
				$k[$j++] = "Incorrect number of dashes and digits for ISBN-10"; /*1867*/
				$0.raiseerror(); /*1867*/
			} /*1867*/
			var _t = $get($1.barcode, 10); /*1869*/
			if ((_t < 48) || (_t > 57)) { /*1871*/
				$k[$j++] = "bwipp.isbn10character11"; /*1870*/
				$k[$j++] = "ISBN-10 character 11 must be a digit"; /*1870*/
				$0.raiseerror(); /*1870*/
			} /*1870*/
			if ($1.barcode.length == 13) { /*1879*/
				if ($ne($geti($1.barcode, 11, 1), "-")) { /*1875*/
					$k[$j++] = "bwipp.isbn10character12"; /*1874*/
					$k[$j++] = "ISBN-10 penultimate character must be a dash"; /*1874*/
					$0.raiseerror(); /*1874*/
				} /*1874*/
				var _y = $get($1.barcode, 12); /*1876*/
				if (((_y < 48) || (_y > 57)) && (_y != 88)) { /*1878*/
					$k[$j++] = "bwipp.isbn10character13"; /*1877*/
					$k[$j++] = "ISBN-10 final character must be a digit or X"; /*1877*/
					$0.raiseerror(); /*1877*/
				} /*1877*/
			} /*1877*/
		} /*1877*/
		$1.isbntxt = $1.barcode; /*1882*/
		if ($1.isbntxt.length <= 13) { /*1908*/
			$1.isbn = $s(10); /*1886*/
			$1.checksum = 0; /*1887*/
			$1.i = 0; /*1888*/
			$1.n = 0; /*1888*/
			for (;;) { /*1900*/
				$1.isbnchar = $get($1.isbntxt, $1.i) - 48; /*1890*/
				if ($1.isbnchar != -3) { /*1897*/
					$put($1.isbn, $1.n, $1.isbnchar + 48); /*1892*/
					if ($1.n < 9) { /*1895*/
						$1.checksum = $1.checksum + ((10 - $1.n) * $1.isbnchar); /*1894*/
					} /*1894*/
					$1.n = $1.n + 1; /*1896*/
				} /*1896*/
				$1.i = $1.i + 1; /*1898*/
				if ($1.i == $1.isbntxt.length) { /*1899*/
					break; /*1899*/
				} /*1899*/
			} /*1899*/
			var _1I = (11 - ($1.checksum % 11)) % 11; /*1901*/
			$k[$j++] = "checksum"; /*1901*/
			$k[$j++] = _1I; /*1901*/
			if (_1I == 10) { /*1901*/
				$j--; /*1901*/
				$k[$j++] = 40; /*1901*/
			} /*1901*/
			var _1J = $k[--$j]; /*1901*/
			$1[$k[--$j]] = _1J + 48; /*1901*/
			$1.isbn = $geti($1.isbn, 0, 9); /*1902*/
			if ($1.isbntxt.length == 13) { /*1907*/
				if ($get($1.isbntxt, 12) != $1.checksum) { /*1906*/
					$k[$j++] = "bwipp.isbn10badCheckDigit"; /*1905*/
					$k[$j++] = "Incorrect ISBN-10 check digit provided"; /*1905*/
					$0.raiseerror(); /*1905*/
				} /*1905*/
			} /*1905*/
		} /*1905*/
		if ((!$1.legacy) || ($1.isbntxt.length >= 15)) { /*1944*/
			if ($1.isbntxt.length <= 13) { /*1918*/
				$1.pad = $s(15); /*1914*/
				$puti($1.pad, 0, "978-"); /*1915*/
				$puti($1.pad, 4, $geti($1.isbntxt, 0, 11)); /*1916*/
				$1.isbntxt = $1.pad; /*1917*/
			} /*1917*/
			$1.isbn = $s(13); /*1921*/
			$1.checksum = 0; /*1922*/
			$1.i = 0; /*1923*/
			$1.n = 0; /*1923*/
			for (;;) { /*1935*/
				$1.isbnchar = $get($1.isbntxt, $1.i) - 48; /*1925*/
				if ($1.isbnchar != -3) { /*1932*/
					$put($1.isbn, $1.n, $1.isbnchar + 48); /*1927*/
					if ($1.n < 12) { /*1930*/
						$k[$j++] = "checksum"; /*1929*/
						$k[$j++] = $1.isbnchar; /*1929*/
						if (($1.n % 2) != 0) { /*1929*/
							var _1l = $k[--$j]; /*1929*/
							$k[$j++] = _1l * 3; /*1929*/
						} /*1929*/
						var _1n = $k[--$j]; /*1929*/
						$1[$k[--$j]] = _1n + $1.checksum; /*1929*/
					} /*1929*/
					$1.n = $1.n + 1; /*1931*/
				} /*1931*/
				$1.i = $1.i + 1; /*1933*/
				if ($1.i == $1.isbntxt.length) { /*1934*/
					break; /*1934*/
				} /*1934*/
			} /*1934*/
			$1.checksum = ((10 - ($1.checksum % 10)) % 10) + 48; /*1936*/
			$1.isbn = $geti($1.isbn, 0, 12); /*1937*/
			if ($1.isbntxt.length == 17) { /*1942*/
				if ($get($1.isbntxt, 16) != $1.checksum) { /*1941*/
					$k[$j++] = "bwipp.isbn13badCheckDigit"; /*1940*/
					$k[$j++] = "Incorrect ISBN-13 check digit provided"; /*1940*/
					$0.raiseerror(); /*1940*/
				} /*1940*/
			} /*1940*/
		} /*1940*/
		var _21 = ($1.isbn.length == 12) ? 22 : 18; /*1947*/
		$1.pad = $s(_21); /*1947*/
		$puti($1.pad, 0, "ISBN "); /*1948*/
		$puti($1.pad, 5, $1.isbntxt); /*1949*/
		$put($1.pad, $1.pad.length - 2, 45); /*1950*/
		$put($1.pad, $1.pad.length - 1, $1.checksum); /*1951*/
		$1.isbntxt = $1.pad; /*1952*/
		$1.barcode = $s(12); /*1955*/
		if ($1.isbn.length == 9) { /*1960*/
			$puti($1.barcode, 0, "978"); /*1957*/
			$puti($1.barcode, 3, $1.isbn); /*1958*/
		} else { /*1960*/
			$puti($1.barcode, 0, $1.isbn); /*1960*/
		} /*1960*/
		if ($ne($1.addon, "")) { /*1970*/
			var _2L = $s((12 + $1.addon.length) + 1); /*1965*/
			$puti(_2L, 0, $1.barcode); /*1966*/
			$puti(_2L, 12, " "); /*1967*/
			$puti(_2L, 13, $1.addon); /*1968*/
			$1.barcode = _2L; /*1969*/
		} /*1969*/
		$1.options.dontdraw = true; /*1973*/
		$1.options.addongap = $1.addongap; /*1974*/
		$k[$j++] = "args"; /*1975*/
		$k[$j++] = $1.barcode; /*1975*/
		$k[$j++] = $1.options; /*1975*/
		$0.ean13(); /*1975*/
		var _2T = $k[--$j]; /*1975*/
		$1[$k[--$j]] = _2T; /*1975*/
		if ($1.includetext) { /*1994*/
			if ($1.isbntextxoffset == "unset") { /*1981*/
				$k[$j++] = "isbntextxoffset"; /*1980*/
				if ($1.isbn.length == 9) { /*1980*/
					$k[$j++] = -1; /*1980*/
				} else { /*1980*/
					$k[$j++] = -12; /*1980*/
				} /*1980*/
				var _2Y = $k[--$j]; /*1980*/
				$1[$k[--$j]] = _2Y; /*1980*/
			} /*1980*/
			if ($1.isbntextyoffset == "unset") { /*1984*/
				$1.isbntextyoffset = ($1.height * 72) + 3; /*1983*/
			} /*1983*/
			var _2d = $1.args.txt !== undefined; /*1985*/
			if (_2d) { /*1992*/
				$1.txt = $1.args.txt; /*1986*/
				$1.newtxt = $a($1.txt.length + 1); /*1987*/
				$puti($1.newtxt, 0, $1.txt); /*1988*/
				$put($1.newtxt, $1.newtxt.length - 1, $a([$1.isbntxt, $1.isbntextxoffset, $1.isbntextyoffset, $1.isbntextfont, $1.isbntextsize])); /*1989*/
				$1.args.txt = $1.newtxt; /*1990*/
			} else { /*1992*/
				$1.args.txt = $a([$a([$1.isbntxt, $1.isbntextxoffset, $1.isbntextyoffset, $1.isbntextfont, $1.isbntextsize])]); /*1992*/
			} /*1992*/
		} /*1992*/
		$1.args.opt = $1.options; /*1996*/
		$k[$j++] = $1.args; /*1999*/
		if (!$1.dontdraw) { /*1999*/
			$0.renlinear(); /*1999*/
		} /*1999*/
	};
	$0.ismn = function() {
		var $1 = {}; /*2027*/
		$1.options = $k[--$j]; /*2029*/
		$1.barcode = $k[--$j]; /*2030*/
		$1.dontdraw = false; /*2032*/
		$1.includetext = false; /*2033*/
		$1.ismntextfont = "OCR-A"; /*2034*/
		$1.ismntextsize = 8.5; /*2035*/
		$1.ismntextxoffset = "unset"; /*2036*/
		$1.ismntextyoffset = "unset"; /*2037*/
		$1.height = 1; /*2038*/
		$1.addongap = 12; /*2039*/
		$1.legacy = false; /*2040*/
		$forall($1.options, function() { /*2051*/
			var _3 = $k[--$j]; /*2051*/
			$1[$k[--$j]] = _3; /*2051*/
		}) /*2051*/
		$1.ismntextfont = "" + $1.ismntextfont; /*2053*/
		$1.ismntextsize = +$1.ismntextsize; /*2054*/
		if ($ne($1.ismntextxoffset, "unset")) { /*2055*/
			$1.ismntextxoffset = +$1.ismntextxoffset; /*2055*/
		} /*2055*/
		if ($ne($1.ismntextyoffset, "unset")) { /*2056*/
			$1.ismntextyoffset = +$1.ismntextyoffset; /*2056*/
		} /*2056*/
		$1.height = +$1.height; /*2057*/
		$1.addongap = +$1.addongap; /*2058*/
		$search($1.barcode, " "); /*2061*/
		if ($k[--$j]) { /*2067*/
			$1.barcode = $k[--$j]; /*2062*/
			$j--; /*2063*/
			$1.addon = $k[--$j]; /*2064*/
		} else { /*2067*/
			$j--; /*2066*/
			$1.addon = ""; /*2067*/
		} /*2067*/
		if ((($1.barcode.length != 15) && ($1.barcode.length != 17)) && (($1.barcode.length != 11) && ($1.barcode.length != 13))) { /*2074*/
			$k[$j++] = "bwipp.ismnBadLength"; /*2073*/
			$k[$j++] = "ISMN-13 must be 15 or 17 characters including dashes. ISMN-10 must be 11 or 13 characters including dashes"; /*2073*/
			$0.raiseerror(); /*2073*/
		} /*2073*/
		if ((($1.addon.length != 0) && ($1.addon.length != 2)) && ($1.addon.length != 5)) { /*2077*/
			$k[$j++] = "bwipp.ismnBadAddOnLength"; /*2076*/
			$k[$j++] = "Add-on for ISMN must be 2 or 5 digits"; /*2076*/
			$0.raiseerror(); /*2076*/
		} /*2076*/
		if ($1.barcode.length >= 15) { /*2144*/
			if ($ne($geti($1.barcode, 0, 4), "979-")) { /*2081*/
				$k[$j++] = "bwipp.ismn13badPrefix"; /*2080*/
				$k[$j++] = "ISMN-13 prefix must be 979-"; /*2080*/
				$0.raiseerror(); /*2080*/
			} /*2080*/
			$1.wasdash = false; /*2082*/
			$1.numdash = 0; /*2082*/
			$1.numdigit = 0; /*2082*/
			$forall($geti($1.barcode, 5, 9), function() { /*2096*/
				var _T = $k[--$j]; /*2084*/
				$k[$j++] = _T; /*2091*/
				if (_T == 45) { /*2091*/
					if ($1.wasdash) { /*2088*/
						$k[$j++] = "bwipp.ismn13adjacentDashes"; /*2087*/
						$k[$j++] = "ISMN-13 does not permit adjacent dashes"; /*2087*/
						$0.raiseerror(); /*2087*/
					} /*2087*/
					$1.wasdash = true; /*2089*/
					$1.numdash = $1.numdash + 1; /*2090*/
				} /*2090*/
				var _W = $k[--$j]; /*2092*/
				if ((_W >= 48) && (_W <= 57)) { /*2095*/
					$1.wasdash = false; /*2093*/
					$1.numdigit = $1.numdigit + 1; /*2094*/
				} /*2094*/
			}) /*2094*/
			if (($1.numdash != 2) || ($1.numdigit != 7)) { /*2099*/
				$k[$j++] = "bwipp.ismn13numDashesDigits"; /*2098*/
				$k[$j++] = "Incorrect number of dashes and digits for ISMN-13"; /*2098*/
				$0.raiseerror(); /*2098*/
			} /*2098*/
			var _b = $get($1.barcode, 14); /*2100*/
			if ((_b < 48) || (_b > 57)) { /*2102*/
				$k[$j++] = "bwipp.ismn13character15"; /*2101*/
				$k[$j++] = "ISMN-13 character 15 must be a digit"; /*2101*/
				$0.raiseerror(); /*2101*/
			} /*2101*/
			if ($1.barcode.length == 17) { /*2110*/
				if ($ne($geti($1.barcode, 15, 1), "-")) { /*2106*/
					$k[$j++] = "bwipp.ismn13character16"; /*2105*/
					$k[$j++] = "ISMN-13 penultimate character must be a dash"; /*2105*/
					$0.raiseerror(); /*2105*/
				} /*2105*/
				var _g = $get($1.barcode, 16); /*2107*/
				if ((_g < 48) || (_g > 57)) { /*2109*/
					$k[$j++] = "bwipp.ismn13character17"; /*2108*/
					$k[$j++] = "ISMN-13 final character must be a digit"; /*2108*/
					$0.raiseerror(); /*2108*/
				} /*2108*/
			} /*2108*/
		} else { /*2144*/
			if ($ne($geti($1.barcode, 0, 2), "M-")) { /*2114*/
				$k[$j++] = "bwipp.ismn10badPrefix"; /*2113*/
				$k[$j++] = "ISMN-10 prefix must be M-"; /*2113*/
				$0.raiseerror(); /*2113*/
			} /*2113*/
			var _k = $get($1.barcode, 2); /*2115*/
			if ((_k < 48) || (_k > 57)) { /*2117*/
				$k[$j++] = "bwipp.ismn10character3"; /*2116*/
				$k[$j++] = "ISMN-10 character 3 must be a digit"; /*2116*/
				$0.raiseerror(); /*2116*/
			} /*2116*/
			$1.wasdash = false; /*2118*/
			$1.numdash = 0; /*2118*/
			$1.numdigit = 0; /*2118*/
			$forall($geti($1.barcode, 3, 7), function() { /*2132*/
				var _n = $k[--$j]; /*2120*/
				$k[$j++] = _n; /*2127*/
				if (_n == 45) { /*2127*/
					if ($1.wasdash) { /*2124*/
						$k[$j++] = "bwipp.ismn10adjacentDashes"; /*2123*/
						$k[$j++] = "ISMN-10 does not permit adjacent dashes"; /*2123*/
						$0.raiseerror(); /*2123*/
					} /*2123*/
					$1.wasdash = true; /*2125*/
					$1.numdash = $1.numdash + 1; /*2126*/
				} /*2126*/
				var _q = $k[--$j]; /*2128*/
				if ((_q >= 48) && (_q <= 57)) { /*2131*/
					$1.wasdash = false; /*2129*/
					$1.numdigit = $1.numdigit + 1; /*2130*/
				} /*2130*/
			}) /*2130*/
			if (($1.numdash != 1) || ($1.numdigit != 6)) { /*2135*/
				$k[$j++] = "bwipp.ismn10numDashesDigits"; /*2134*/
				$k[$j++] = "Incorrect number of dashes and digits for ISMN-10"; /*2134*/
				$0.raiseerror(); /*2134*/
			} /*2134*/
			var _v = $get($1.barcode, 10); /*2136*/
			if ((_v < 48) || (_v > 57)) { /*2138*/
				$k[$j++] = "bwipp.ismn10character11"; /*2137*/
				$k[$j++] = "ISMN-10 character 11 must be a digit"; /*2137*/
				$0.raiseerror(); /*2137*/
			} /*2137*/
			if ($1.barcode.length == 13) { /*2146*/
				if ($ne($geti($1.barcode, 11, 1), "-")) { /*2142*/
					$k[$j++] = "bwipp.ismn10character12"; /*2141*/
					$k[$j++] = "ISMN-10 penultimate character must be a dash"; /*2141*/
					$0.raiseerror(); /*2141*/
				} /*2141*/
				var _10 = $get($1.barcode, 12); /*2143*/
				if (((_10 < 48) || (_10 > 57)) && (_10 != 88)) { /*2145*/
					$k[$j++] = "bwipp.ismn10character13"; /*2144*/
					$k[$j++] = "ISMN-10 final character must be a digit or X"; /*2144*/
					$0.raiseerror(); /*2144*/
				} /*2144*/
			} /*2144*/
		} /*2144*/
		$1.ismntxt = $1.barcode; /*2149*/
		$1.legacytxt = ""; /*2152*/
		if ($1.ismntxt.length <= 13) { /*2159*/
			$1.legacytxt = $1.ismntxt; /*2154*/
			$1.pad = $s($1.ismntxt.length + 4); /*2155*/
			$puti($1.pad, 0, "979-0-"); /*2156*/
			$puti($1.pad, 6, $geti($1.ismntxt, 2, $1.ismntxt.length - 2)); /*2157*/
			$1.ismntxt = $1.pad; /*2158*/
		} /*2158*/
		$1.ismn = $s(13); /*2162*/
		$1.checksum = 0; /*2163*/
		$1.i = 0; /*2164*/
		$1.n = 0; /*2164*/
		for (;;) { /*2180*/
			$1.ismnchar = $get($1.ismntxt, $1.i) - 48; /*2166*/
			if ($1.ismnchar != -3) { /*2177*/
				$put($1.ismn, $1.n, $1.ismnchar + 48); /*2168*/
				if ($1.n < 12) { /*2175*/
					if (($1.n % 2) == 0) { /*2173*/
						$1.checksum = $1.ismnchar + $1.checksum; /*2171*/
					} else { /*2173*/
						$1.checksum = ($1.ismnchar * 3) + $1.checksum; /*2173*/
					} /*2173*/
				} /*2173*/
				$1.n = $1.n + 1; /*2176*/
			} /*2176*/
			$1.i = $1.i + 1; /*2178*/
			if ($1.i == $1.ismntxt.length) { /*2179*/
				break; /*2179*/
			} /*2179*/
		} /*2179*/
		$1.checksum = ((10 - ($1.checksum % 10)) % 10) + 48; /*2181*/
		if (($1.barcode.length == 13) || ($1.barcode.length == 17)) { /*2188*/
			var _1X = $1.barcode; /*2185*/
			if ($get(_1X, _1X.length - 1) != $1.checksum) { /*2187*/
				$k[$j++] = "bwipp.ismnBadCheckDigit"; /*2186*/
				$k[$j++] = "Incorrect ISMN check digit provided"; /*2186*/
				$0.raiseerror(); /*2186*/
			} /*2186*/
		} /*2186*/
		if ($1.legacy && $ne($1.legacytxt, "")) { /*2195*/
			$1.ismntxt = $1.legacytxt; /*2192*/
			$1.pad = $s(18); /*2193*/
		} else { /*2195*/
			$1.pad = $s(22); /*2195*/
		} /*2195*/
		$puti($1.pad, 0, "ISMN "); /*2197*/
		$puti($1.pad, 5, $1.ismntxt); /*2198*/
		$put($1.pad, $1.pad.length - 2, 45); /*2199*/
		$put($1.pad, $1.pad.length - 1, $1.checksum); /*2200*/
		$1.ismntxt = $1.pad; /*2201*/
		$1.barcode = $geti($1.ismn, 0, 12); /*2204*/
		if ($ne($1.addon, "")) { /*2213*/
			var _1s = $s((12 + $1.addon.length) + 1); /*2208*/
			$puti(_1s, 0, $1.barcode); /*2209*/
			$puti(_1s, 12, " "); /*2210*/
			$puti(_1s, 13, $1.addon); /*2211*/
			$1.barcode = _1s; /*2212*/
		} /*2212*/
		$1.options.dontdraw = true; /*2216*/
		$1.options.addongap = $1.addongap; /*2217*/
		$k[$j++] = "args"; /*2218*/
		$k[$j++] = $1.barcode; /*2218*/
		$k[$j++] = $1.options; /*2218*/
		$0.ean13(); /*2218*/
		var _20 = $k[--$j]; /*2218*/
		$1[$k[--$j]] = _20; /*2218*/
		if ($1.includetext) { /*2237*/
			if ($1.ismntextxoffset == "unset") { /*2224*/
				$k[$j++] = "ismntextxoffset"; /*2223*/
				if ($1.ismntxt.length == 18) { /*2223*/
					$k[$j++] = -1; /*2223*/
				} else { /*2223*/
					$k[$j++] = -12; /*2223*/
				} /*2223*/
				var _25 = $k[--$j]; /*2223*/
				$1[$k[--$j]] = _25; /*2223*/
			} /*2223*/
			if ($1.ismntextyoffset == "unset") { /*2227*/
				$1.ismntextyoffset = ($1.height * 72) + 3; /*2226*/
			} /*2226*/
			var _2A = $1.args.txt !== undefined; /*2228*/
			if (_2A) { /*2235*/
				$1.txt = $1.args.txt; /*2229*/
				$1.newtxt = $a($1.txt.length + 1); /*2230*/
				$puti($1.newtxt, 0, $1.txt); /*2231*/
				$put($1.newtxt, $1.newtxt.length - 1, $a([$1.ismntxt, $1.ismntextxoffset, $1.ismntextyoffset, $1.ismntextfont, $1.ismntextsize])); /*2232*/
				$1.args.txt = $1.newtxt; /*2233*/
			} else { /*2235*/
				$1.args.txt = $a([$a([$1.ismntxt, $1.ismntextxoffset, $1.ismntextyoffset, $1.ismntextfont, $1.ismntextsize])]); /*2235*/
			} /*2235*/
		} /*2235*/
		$1.args.opt = $1.options; /*2239*/
		$k[$j++] = $1.args; /*2242*/
		if (!$1.dontdraw) { /*2242*/
			$0.renlinear(); /*2242*/
		} /*2242*/
	};
	$0.issn = function() {
		var $1 = {}; /*2270*/
		$1.options = $k[--$j]; /*2272*/
		$1.issntxt = $k[--$j]; /*2273*/
		$1.dontdraw = false; /*2275*/
		$1.includetext = false; /*2276*/
		$1.issntextfont = "OCR-A"; /*2277*/
		$1.issntextsize = 8.5; /*2278*/
		$1.issntextxoffset = "unset"; /*2279*/
		$1.issntextyoffset = "unset"; /*2280*/
		$1.height = 1; /*2281*/
		$1.addongap = 12; /*2282*/
		$forall($1.options, function() { /*2293*/
			var _3 = $k[--$j]; /*2293*/
			$1[$k[--$j]] = _3; /*2293*/
		}) /*2293*/
		$1.issntextfont = "" + $1.issntextfont; /*2295*/
		$1.issntextsize = +$1.issntextsize; /*2296*/
		if ($ne($1.issntextxoffset, "unset")) { /*2297*/
			$1.issntextxoffset = +$1.issntextxoffset; /*2297*/
		} /*2297*/
		if ($ne($1.issntextyoffset, "unset")) { /*2298*/
			$1.issntextyoffset = +$1.issntextyoffset; /*2298*/
		} /*2298*/
		$1.height = +$1.height; /*2299*/
		$1.addongap = +$1.addongap; /*2300*/
		$search($1.issntxt, " "); /*2303*/
		if ($k[--$j]) { /*2309*/
			$1.issntxt = $k[--$j]; /*2304*/
			$j--; /*2305*/
			$1.seqvar = $k[--$j]; /*2306*/
		} else { /*2309*/
			$j--; /*2308*/
			$1.seqvar = ""; /*2309*/
		} /*2309*/
		$search($1.seqvar, " "); /*2313*/
		if ($k[--$j]) { /*2320*/
			$1.seqvar = $k[--$j]; /*2314*/
			$j--; /*2315*/
			$1.addon = $k[--$j]; /*2316*/
		} else { /*2320*/
			$j--; /*2318*/
			$1.addon = $1.seqvar; /*2319*/
			$1.seqvar = "00"; /*2320*/
		} /*2320*/
		if (($1.issntxt.length != 8) && ($1.issntxt.length != 9)) { /*2326*/
			$k[$j++] = "bwipp.issnBadLength"; /*2325*/
			$k[$j++] = "ISSN must be 8 or 9 characters including dash"; /*2325*/
			$0.raiseerror(); /*2325*/
		} /*2325*/
		$forall($geti($1.issntxt, 0, 4), function() { /*2331*/
			var _Q = $k[--$j]; /*2328*/
			if ((_Q < 48) || (_Q > 57)) { /*2330*/
				$k[$j++] = "bwipp.issnBadFormat"; /*2329*/
				$k[$j++] = "ISSN must have the format XXXX-XXXX"; /*2329*/
				$0.raiseerror(); /*2329*/
			} /*2329*/
		}) /*2329*/
		if ($ne($geti($1.issntxt, 4, 1), "-")) { /*2334*/
			$k[$j++] = "bwipp.issnBadFormat"; /*2333*/
			$k[$j++] = "ISSN must have the format XXXX-XXXX"; /*2333*/
			$0.raiseerror(); /*2333*/
		} /*2333*/
		$forall($geti($1.issntxt, 5, 3), function() { /*2339*/
			var _V = $k[--$j]; /*2336*/
			if ((_V < 48) || (_V > 57)) { /*2338*/
				$k[$j++] = "bwipp.issnBadFormat"; /*2337*/
				$k[$j++] = "ISSN must have the format XXXX-XXXX"; /*2337*/
				$0.raiseerror(); /*2337*/
			} /*2337*/
		}) /*2337*/
		if ($1.issntxt.length == 9) { /*2344*/
			var _Y = $get($1.issntxt, 8); /*2341*/
			if (((_Y < 48) || (_Y > 57)) && (_Y != 88)) { /*2343*/
				$k[$j++] = "bwipp.issnBadFormat"; /*2342*/
				$k[$j++] = "ISSN must have the format XXXX-XXXX"; /*2342*/
				$0.raiseerror(); /*2342*/
			} /*2342*/
		} /*2342*/
		if ($1.seqvar.length != 2) { /*2347*/
			$k[$j++] = "bwipp.issnBadSequenceVariantLength"; /*2346*/
			$k[$j++] = "Sequence variant for ISSN must be 2 digits"; /*2346*/
			$0.raiseerror(); /*2346*/
		} /*2346*/
		var _a = $1.seqvar; /*2348*/
		for (var _b = 0, _c = _a.length; _b < _c; _b++) { /*2352*/
			var _d = $get(_a, _b); /*2352*/
			if ((_d < 48) || (_d > 57)) { /*2351*/
				$k[$j++] = "bwipp.issnSequenceVariantBadCharacter"; /*2350*/
				$k[$j++] = "Sequence variant for ISSN must contain only digits"; /*2350*/
				$0.raiseerror(); /*2350*/
			} /*2350*/
		} /*2350*/
		if ((($1.addon.length != 0) && ($1.addon.length != 2)) && ($1.addon.length != 5)) { /*2355*/
			$k[$j++] = "bwipp.issnBadAddOnLength"; /*2354*/
			$k[$j++] = "Add-on for ISSN must be 2 or 5 digits"; /*2354*/
			$0.raiseerror(); /*2354*/
		} /*2354*/
		$1.issn = $s(8); /*2358*/
		$1.checksum = 0; /*2359*/
		$1.i = 0; /*2360*/
		$1.n = 0; /*2360*/
		for (;;) { /*2372*/
			$1.issnchar = $get($1.issntxt, $1.i) - 48; /*2362*/
			if ($1.issnchar != -3) { /*2369*/
				$put($1.issn, $1.n, $1.issnchar + 48); /*2364*/
				if ($1.n < 7) { /*2367*/
					$1.checksum = $1.checksum + ($1.issnchar * (8 - $1.n)); /*2366*/
				} /*2366*/
				$1.n = $1.n + 1; /*2368*/
			} /*2368*/
			$1.i = $1.i + 1; /*2370*/
			if ($1.i == $1.issntxt.length) { /*2371*/
				break; /*2371*/
			} /*2371*/
		} /*2371*/
		$1.checksum = (11 - ($1.checksum % 11)) % 11; /*2373*/
		var _z = $1.checksum + 48; /*2374*/
		$k[$j++] = "checksum"; /*2374*/
		$k[$j++] = _z; /*2374*/
		if (_z == 58) { /*2374*/
			$j--; /*2374*/
			$k[$j++] = 88; /*2374*/
		} /*2374*/
		var _10 = $k[--$j]; /*2374*/
		$1[$k[--$j]] = _10; /*2374*/
		if ($1.issntxt.length == 9) { /*2379*/
			if ($get($1.issntxt, 8) != $1.checksum) { /*2378*/
				$k[$j++] = "bwipp.issnBadCheckDigit"; /*2377*/
				$k[$j++] = "Incorrect ISSN check digit provided"; /*2377*/
				$0.raiseerror(); /*2377*/
			} /*2377*/
		} /*2377*/
		$1.pad = $s(14); /*2382*/
		$puti($1.pad, 0, "ISSN "); /*2383*/
		$puti($1.pad, 5, $1.issntxt); /*2384*/
		$put($1.pad, 13, $1.checksum); /*2385*/
		$1.issntxt = $1.pad; /*2386*/
		$1.barcode = $geti($1.issn, 0, 7); /*2389*/
		$1.barcode = $s(12); /*2392*/
		$puti($1.barcode, 0, "977"); /*2393*/
		$puti($1.barcode, 3, $1.issn); /*2394*/
		$puti($1.barcode, 10, $1.seqvar); /*2395*/
		if ($ne($1.addon, "")) { /*2404*/
			var _1N = $s((12 + $1.addon.length) + 1); /*2399*/
			$puti(_1N, 0, $1.barcode); /*2400*/
			$puti(_1N, 12, " "); /*2401*/
			$puti(_1N, 13, $1.addon); /*2402*/
			$1.barcode = _1N; /*2403*/
		} /*2403*/
		$1.options.dontdraw = true; /*2407*/
		$1.options.addongap = $1.addongap; /*2408*/
		$k[$j++] = "args"; /*2409*/
		$k[$j++] = $1.barcode; /*2409*/
		$k[$j++] = $1.options; /*2409*/
		$0.ean13(); /*2409*/
		var _1V = $k[--$j]; /*2409*/
		$1[$k[--$j]] = _1V; /*2409*/
		if ($1.includetext) { /*2426*/
			if ($1.issntextxoffset == "unset") { /*2413*/
				$1.issntextxoffset = 10; /*2413*/
			} /*2413*/
			if ($1.issntextyoffset == "unset") { /*2416*/
				$1.issntextyoffset = ($1.height * 72) + 3; /*2415*/
			} /*2415*/
			var _1c = $1.args.txt !== undefined; /*2417*/
			if (_1c) { /*2424*/
				$1.txt = $1.args.txt; /*2418*/
				$1.newtxt = $a($1.txt.length + 1); /*2419*/
				$puti($1.newtxt, 0, $1.txt); /*2420*/
				$put($1.newtxt, $1.newtxt.length - 1, $a([$1.issntxt, $1.issntextxoffset, $1.issntextyoffset, $1.issntextfont, $1.issntextsize])); /*2421*/
				$1.args.txt = $1.newtxt; /*2422*/
			} else { /*2424*/
				$1.args.txt = $a([$a([$1.issntxt, $1.issntextxoffset, $1.issntextyoffset, $1.issntextfont, $1.issntextsize])]); /*2424*/
			} /*2424*/
		} /*2424*/
		$1.args.opt = $1.options; /*2428*/
		$k[$j++] = $1.args; /*2431*/
		if (!$1.dontdraw) { /*2431*/
			$0.renlinear(); /*2431*/
		} /*2431*/
	};
	$0.code128 = function() {
		var $1 = {}; /*2458*/
		$1.options = $k[--$j]; /*2460*/
		$1.barcode = $k[--$j]; /*2461*/
		$1.dontdraw = false; /*2463*/
		$1.includetext = false; /*2464*/
		$1.textfont = "Courier"; /*2465*/
		$1.textsize = 10; /*2466*/
		$1.textxoffset = 0; /*2467*/
		$1.textyoffset = -8.5; /*2468*/
		$1.height = 1; /*2469*/
		$1.encoding = "auto"; /*2470*/
		$1.raw = false; /*2471*/
		$1.parse = false; /*2472*/
		$1.parsefnc = false; /*2473*/
		$forall($1.options, function() { /*2484*/
			var _3 = $k[--$j]; /*2484*/
			$1[$k[--$j]] = _3; /*2484*/
		}) /*2484*/
		$1.textfont = "" + $1.textfont; /*2486*/
		$1.textsize = +$1.textsize; /*2487*/
		$1.textxoffset = +$1.textxoffset; /*2488*/
		$1.textyoffset = +$1.textyoffset; /*2489*/
		$1.height = +$1.height; /*2490*/
		$1.barlen = $1.barcode.length; /*2513*/
		$1.sta = -1; /*2516*/
		$1.stb = -2; /*2516*/
		$1.stc = -3; /*2516*/
		$1.swa = -4; /*2517*/
		$1.swb = -5; /*2517*/
		$1.swc = -6; /*2517*/
		$1.fn1 = -7; /*2518*/
		$1.fn2 = -8; /*2518*/
		$1.fn3 = -9; /*2518*/
		$1.fn4 = -10; /*2519*/
		$1.sft = -11; /*2519*/
		$1.stp = -12; /*2519*/
		$1.lka = -13; /*2520*/
		$1.lkc = -14; /*2520*/
		$1.charmaps = $a([$a([32, 32, "00"]), $a(["!", "!", "01"]), $a(["\"", "\"", "02"]), $a(["#", "#", "03"]), $a(["$", "$", "04"]), $a(["%", "%", "05"]), $a(["&", "&", "06"]), $a(["'", "'", "07"]), $a([40, 40, "08"]), $a([41, 41, "09"]), $a(["*", "*", "10"]), $a(["+", "+", "11"]), $a([",", ",", "12"]), $a(["-", "-", "13"]), $a([".", ".", "14"]), $a(["/", "/", "15"]), $a(["0", "0", "16"]), $a(["1", "1", "17"]), $a(["2", "2", "18"]), $a(["3", "3", "19"]), $a(["4", "4", "20"]), $a(["5", "5", "21"]), $a(["6", "6", "22"]), $a(["7", "7", "23"]), $a(["8", "8", "24"]), $a(["9", "9", "25"]), $a([":", ":", "26"]), $a([";", ";", "27"]), $a(["<", "<", "28"]), $a(["=", "=", "29"]), $a([">", ">", "30"]), $a(["?", "?", "31"]), $a(["@", "@", "32"]), $a(["A", "A", "33"]), $a(["B", "B", "34"]), $a(["C", "C", "35"]), $a(["D", "D", "36"]), $a(["E", "E", "37"]), $a(["F", "F", "38"]), $a(["G", "G", "39"]), $a(["H", "H", "40"]), $a(["I", "I", "41"]), $a(["J", "J", "42"]), $a(["K", "K", "43"]), $a(["L", "L", "44"]), $a(["M", "M", "45"]), $a(["N", "N", "46"]), $a(["O", "O", "47"]), $a(["P", "P", "48"]), $a(["Q", "Q", "49"]), $a(["R", "R", "50"]), $a(["S", "S", "51"]), $a(["T", "T", "52"]), $a(["U", "U", "53"]), $a(["V", "V", "54"]), $a(["W", "W", "55"]), $a(["X", "X", "56"]), $a(["Y", "Y", "57"]), $a(["Z", "Z", "58"]), $a(["[", "[", "59"]), $a([92, 92, "60"]), $a(["]", "]", "61"]), $a(["^", "^", "62"]), $a(["_", "_", "63"]), $a([0, "`", "64"]), $a([1, "a", "65"]), $a([2, "b", "66"]), $a([3, "c", "67"]), $a([4, "d", "68"]), $a([5, "e", "69"]), $a([6, "f", "70"]), $a([7, "g", "71"]), $a([8, "h", "72"]), $a([9, "i", "73"]), $a([10, "j", "74"]), $a([11, "k", "75"]), $a([12, "l", "76"]), $a([13, "m", "77"]), $a([14, "n", "78"]), $a([15, "o", "79"]), $a([16, "p", "80"]), $a([17, "q", "81"]), $a([18, "r", "82"]), $a([19, "s", "83"]), $a([20, "t", "84"]), $a([21, "u", "85"]), $a([22, "v", "86"]), $a([23, "w", "87"]), $a([24, "x", "88"]), $a([25, "y", "89"]), $a([26, "z", "90"]), $a([27, "{", "91"]), $a([28, "|", "92"]), $a([29, "}", "93"]), $a([30, "~", "94"]), $a([31, 127, "95"]), $a([$1.fn3, $1.fn3, "96"]), $a([$1.fn2, $1.fn2, "97"]), $a([$1.sft, $1.sft, "98"]), $a([$1.swc, $1.swc, "99"]), $a([$1.swb, $1.fn4, $1.swb]), $a([$1.fn4, $1.swa, $1.swa]), $a([$1.fn1, $1.fn1, $1.fn1]), $a([$1.sta, $1.sta, $1.sta]), $a([$1.stb, $1.stb, $1.stb]), $a([$1.stc, $1.stc, $1.stc]), $a([$1.stp, $1.stp, $1.stp])]); /*2561*/
		$1.charvals = $a([{}, {}, {}]); /*2564*/
		for (var _2R = 0, _2Q = $1.charmaps.length - 1; _2R <= _2Q; _2R += 1) { /*2573*/
			$1.i = _2R; /*2566*/
			$1.encs = $get($1.charmaps, $1.i); /*2567*/
			for (var _2V = 0; _2V <= 2; _2V += 1) { /*2572*/
				$1.j = _2V; /*2569*/
				var _2Y = $get($1.encs, $1.j); /*2570*/
				$k[$j++] = _2Y; /*2570*/
				if ($eq($type(_2Y), "stringtype")) { /*2570*/
					var _2b = $get($k[--$j], 0); /*2570*/
					$k[$j++] = _2b; /*2570*/
				} /*2570*/
				$put($get($1.charvals, $1.j), $k[--$j], $1.i); /*2571*/
			} /*2571*/
		} /*2571*/
		$1.seta = $get($1.charvals, 0); /*2574*/
		$1.setb = $get($1.charvals, 1); /*2575*/
		$1.setc = $get($1.charvals, 2); /*2576*/
		$put($1.seta, $1.lka, $get($1.seta, $1.swb)); /*2579*/
		$put($1.seta, $1.lkc, $get($1.seta, $1.swc)); /*2579*/
		$put($1.setb, $1.lka, $get($1.setb, $1.swc)); /*2580*/
		$put($1.setb, $1.lkc, $get($1.setb, $1.swa)); /*2580*/
		$put($1.setc, $1.lka, $get($1.setc, $1.swa)); /*2581*/
		$put($1.setc, $1.lkc, $get($1.setc, $1.swb)); /*2581*/
		if ($1.raw) { /*2583*/
			$1.encoding = "raw"; /*2583*/
		} /*2583*/
		if ($eq($1.encoding, "raw")) { /*2597*/
			$1.cws = $a($1.barlen); /*2586*/
			$1.i = 0; /*2587*/
			$1.j = 0; /*2587*/
			for (;;) { /*2594*/
				if ($1.i == $1.barlen) { /*2589*/
					break; /*2589*/
				} /*2589*/
				$1.cw = ~~$z($geti($1.barcode, $1.i + 1, 3)); /*2590*/
				$put($1.cws, $1.j, $1.cw); /*2591*/
				$1.i = $1.i + 4; /*2592*/
				$1.j = $1.j + 1; /*2593*/
			} /*2593*/
			$1.cws = $geti($1.cws, 0, $1.j); /*2595*/
			$1.text = ""; /*2596*/
		} /*2596*/
		if ($eq($1.encoding, "auto")) { /*2847*/
			var _3e = {
				FNC1: $1.fn1,
				FNC2: $1.fn2,
				FNC3: $1.fn3,
				LNKA: $1.lka,
				LNKC: $1.lkc
			}; /*2607*/
			$1.fncvals = _3e; /*2608*/
			$1.msg = $a($1.barlen); /*2611*/
			$1.text = $s($1.barlen); /*2612*/
			$1.i = 0; /*2613*/
			$1.j = 0; /*2613*/
			for (;;) { /*2629*/
				if ($1.i == $1.barlen) { /*2614*/
					break; /*2614*/
				} /*2614*/
				$1.char = $get($1.barcode, $1.i); /*2615*/
				$put($1.text, $1.j, $1.char); /*2616*/
				if (($1.parsefnc && ($1.char == 94)) && ($1.i < ($1.barlen - 4))) { /*2625*/
					if ($get($1.barcode, $1.i + 1) != 94) { /*2623*/
						$1.char = $get($1.fncvals, $geti($1.barcode, $1.i + 1, 4)); /*2619*/
						$puti($1.text, $1.j, " "); /*2620*/
						$1.i = $1.i + 4; /*2621*/
					} else { /*2623*/
						$1.i = $1.i + 1; /*2623*/
					} /*2623*/
				} /*2623*/
				$put($1.msg, $1.j, $1.char); /*2626*/
				$1.i = $1.i + 1; /*2627*/
				$1.j = $1.j + 1; /*2628*/
			} /*2628*/
			$1.msg = $geti($1.msg, 0, $1.j); /*2630*/
			$1.msglen = $1.msg.length; /*2631*/
			$1.text = $geti($1.text, 0, $1.j); /*2632*/
			$k[$j++] = "numSA"; /*2635*/
			$k[$j++] = Infinity; /*2635*/
			for (var _4K = 0, _4L = $1.msglen; _4K < _4L; _4K++) { /*2635*/
				$k[$j++] = 0; /*2635*/
			} /*2635*/
			$k[$j++] = 0; /*2635*/
			var _4M = $a(); /*2635*/
			$1[$k[--$j]] = _4M; /*2635*/
			$k[$j++] = "numEA"; /*2636*/
			$k[$j++] = Infinity; /*2636*/
			for (var _4P = 0, _4Q = $1.msglen; _4P < _4Q; _4P++) { /*2636*/
				$k[$j++] = 0; /*2636*/
			} /*2636*/
			$k[$j++] = 0; /*2636*/
			var _4R = $a(); /*2636*/
			$1[$k[--$j]] = _4R; /*2636*/
			for (var _4U = $1.msglen - 1; _4U >= 0; _4U -= 1) { /*2646*/
				$1.i = _4U; /*2638*/
				if ($get($1.msg, $1.i) >= 0) { /*2645*/
					if ($get($1.msg, $1.i) >= 128) { /*2643*/
						$put($1.numEA, $1.i, $get($1.numEA, $1.i + 1) + 1); /*2641*/
					} else { /*2643*/
						$put($1.numSA, $1.i, $get($1.numSA, $1.i + 1) + 1); /*2643*/
					} /*2643*/
				} /*2643*/
			} /*2643*/
			$1.ea = false; /*2649*/
			$1.msgtmp = $a([]); /*2649*/
			for (var _4o = 0, _4n = $1.msglen - 1; _4o <= _4n; _4o += 1) { /*2664*/
				$1.i = _4o; /*2651*/
				$1.c = $get($1.msg, $1.i); /*2652*/
				if ((!$xo($1.ea, $1.c < 128)) && ($1.c >= 0)) { /*2662*/
					if ($1.ea) { /*2654*/
						$k[$j++] = $1.numSA; /*2654*/
					} else { /*2654*/
						$k[$j++] = $1.numEA; /*2654*/
					} /*2654*/
					var _50 = $get($k[--$j], $1.i); /*2654*/
					var _53 = ((_50 + $1.i) == $1.msglen) ? 3 : 5; /*2655*/
					if (_50 < _53) { /*2660*/
						$k[$j++] = "msgtmp"; /*2657*/
						$k[$j++] = Infinity; /*2657*/
						$aload($1.msgtmp); /*2657*/
						$k[$j++] = $1.fn4; /*2657*/
						var _56 = $a(); /*2657*/
						$1[$k[--$j]] = _56; /*2657*/
					} else { /*2660*/
						$k[$j++] = "msgtmp"; /*2659*/
						$k[$j++] = Infinity; /*2659*/
						$aload($1.msgtmp); /*2659*/
						$k[$j++] = $1.fn4; /*2659*/
						$k[$j++] = $1.fn4; /*2659*/
						var _5B = $a(); /*2659*/
						$1[$k[--$j]] = _5B; /*2659*/
						$1.ea = !$1.ea; /*2660*/
					} /*2660*/
				} /*2660*/
				$k[$j++] = "msgtmp"; /*2663*/
				$k[$j++] = Infinity; /*2663*/
				$aload($1.msgtmp); /*2663*/
				if ($1.c >= 0) { /*2663*/
					$k[$j++] = $1.c & 127; /*2663*/
				} else { /*2663*/
					$k[$j++] = $1.c; /*2663*/
				} /*2663*/
				var _5I = $a(); /*2663*/
				$1[$k[--$j]] = _5I; /*2663*/
			} /*2663*/
			$1.msg = $1.msgtmp; /*2665*/
			$1.msglen = $1.msg.length; /*2666*/
			$1.numsscr = function() {
				$1.n = 0; /*2670*/
				$1.s = 0; /*2670*/
				$1.p = $k[--$j]; /*2671*/
				for (;;) { /*2682*/
					if ($1.p >= $1.msglen) { /*2672*/
						break; /*2672*/
					} /*2672*/
					var _5R = $get($1.msg, $1.p); /*2673*/
					var _5T = $get($1.setc, _5R) !== undefined; /*2674*/
					$k[$j++] = _5R; /*2674*/
					if (!_5T) { /*2674*/
						$j--; /*2674*/
						break; /*2674*/
					} /*2674*/
					if ($k[--$j] == $1.fn1) { /*2678*/
						if (($1.s % 2) == 0) { /*2677*/
							$1.s = $1.s + 1; /*2677*/
						} else { /*2677*/
							break; /*2677*/
						} /*2677*/
					} /*2677*/
					$1.n = $1.n + 1; /*2679*/
					$1.s = $1.s + 1; /*2680*/
					$1.p = $1.p + 1; /*2681*/
				} /*2681*/
				$k[$j++] = $1.n; /*2683*/
				$k[$j++] = $1.s; /*2683*/
			}; /*2684*/
			$1.enca = function() {
				$put($1.cws, $1.j, $get($1.seta, $k[--$j])); /*2688*/
				$1.j = $1.j + 1; /*2689*/
			}; /*2690*/
			$1.encb = function() {
				$put($1.cws, $1.j, $get($1.setb, $k[--$j])); /*2692*/
				$1.j = $1.j + 1; /*2693*/
			}; /*2694*/
			$1.encc = function() {
				var _5p = $k[--$j]; /*2696*/
				$k[$j++] = _5p; /*2700*/
				if ($ne($type(_5p), "arraytype")) { /*2699*/
					var _5t = $get($1.setc, $k[--$j]); /*2697*/
					$k[$j++] = _5t; /*2697*/
				} else { /*2699*/
					$aload($k[--$j]); /*2699*/
					var _5v = $k[--$j]; /*2699*/
					var _5w = $k[--$j]; /*2699*/
					$k[$j++] = (_5v - 48) + ((_5w - 48) * 10); /*2699*/
				} /*2699*/
				$put($1.cws, $1.j, $k[--$j]); /*2701*/
				$1.j = $1.j + 1; /*2702*/
			}; /*2703*/
			$1.anotb = function() {
				var _61 = $k[--$j]; /*2706*/
				var _63 = $get($1.seta, _61) !== undefined; /*2706*/
				var _65 = $get($1.setb, _61) !== undefined; /*2706*/
				$k[$j++] = _63 && (!_65); /*2706*/
			}; /*2706*/
			$1.bnota = function() {
				var _66 = $k[--$j]; /*2707*/
				var _68 = $get($1.setb, _66) !== undefined; /*2707*/
				var _6A = $get($1.seta, _66) !== undefined; /*2707*/
				$k[$j++] = _68 && (!_6A); /*2707*/
			}; /*2707*/
			$k[$j++] = "nextanotb"; /*2710*/
			$k[$j++] = Infinity; /*2710*/
			for (var _6C = 0, _6D = $1.msg.length; _6C < _6D; _6C++) { /*2710*/
				$k[$j++] = 0; /*2710*/
			} /*2710*/
			$k[$j++] = 9999; /*2710*/
			var _6E = $a(); /*2710*/
			$1[$k[--$j]] = _6E; /*2710*/
			$k[$j++] = "nextbnota"; /*2711*/
			$k[$j++] = Infinity; /*2711*/
			for (var _6H = 0, _6I = $1.msg.length; _6H < _6I; _6H++) { /*2711*/
				$k[$j++] = 0; /*2711*/
			} /*2711*/
			$k[$j++] = 9999; /*2711*/
			var _6J = $a(); /*2711*/
			$1[$k[--$j]] = _6J; /*2711*/
			for (var _6M = $1.msg.length - 1; _6M >= 0; _6M -= 1) { /*2724*/
				$1.i = _6M; /*2713*/
				$k[$j++] = $get($1.msg, $1.i); /*2714*/
				$1.anotb(); /*2714*/
				if ($k[--$j]) { /*2717*/
					$put($1.nextanotb, $1.i, 0); /*2715*/
				} else { /*2717*/
					$put($1.nextanotb, $1.i, $get($1.nextanotb, $1.i + 1) + 1); /*2717*/
				} /*2717*/
				$k[$j++] = $get($1.msg, $1.i); /*2719*/
				$1.bnota(); /*2719*/
				if ($k[--$j]) { /*2722*/
					$put($1.nextbnota, $1.i, 0); /*2720*/
				} else { /*2722*/
					$put($1.nextbnota, $1.i, $get($1.nextbnota, $1.i + 1) + 1); /*2722*/
				} /*2722*/
			} /*2722*/
			$1.abeforeb = function() {
				var _6j = $k[--$j]; /*2727*/
				$k[$j++] = $lt($get($1.nextanotb, _6j), $get($1.nextbnota, _6j)); /*2727*/
			}; /*2727*/
			$1.bbeforea = function() {
				var _6o = $k[--$j]; /*2728*/
				$k[$j++] = $lt($get($1.nextbnota, _6o), $get($1.nextanotb, _6o)); /*2728*/
			}; /*2728*/
			$1.cws = $a(($1.barcode.length * 2) + 3); /*2730*/
			$1.j = 0; /*2733*/
			if ($1.msglen > 0) { /*2734*/
				$k[$j++] = 0; /*2734*/
				$1.numsscr(); /*2734*/
			} else { /*2734*/
				$k[$j++] = -1; /*2734*/
				$k[$j++] = -1; /*2734*/
			} /*2734*/
			$1.nums = $k[--$j]; /*2734*/
			$1.nchars = $k[--$j]; /*2734*/
			for (;;) { /*2759*/
				if ($1.msglen == 0) { /*2740*/
					$k[$j++] = $1.stb; /*2737*/
					$1.enca(); /*2737*/
					$1.cset = "setb"; /*2738*/
					break; /*2739*/
				} /*2739*/
				if (($1.msglen == 2) && ($1.nums == 2)) { /*2745*/
					$k[$j++] = $1.stc; /*2742*/
					$1.enca(); /*2742*/
					$1.cset = "setc"; /*2743*/
					break; /*2744*/
				} /*2744*/
				if ($1.nums >= 4) { /*2750*/
					$k[$j++] = $1.stc; /*2747*/
					$1.enca(); /*2747*/
					$1.cset = "setc"; /*2748*/
					break; /*2749*/
				} /*2749*/
				$k[$j++] = 0; /*2751*/
				$1.abeforeb(); /*2751*/
				if ($k[--$j]) { /*2755*/
					$k[$j++] = $1.sta; /*2752*/
					$1.enca(); /*2752*/
					$1.cset = "seta"; /*2753*/
					break; /*2754*/
				} /*2754*/
				$k[$j++] = $1.stb; /*2756*/
				$1.enca(); /*2756*/
				$1.cset = "setb"; /*2757*/
				break; /*2758*/
			} /*2758*/
			$1.i = 0; /*2762*/
			for (;;) { /*2845*/
				if ($1.i == $1.msglen) { /*2763*/
					break; /*2763*/
				} /*2763*/
				$k[$j++] = $1.i; /*2765*/
				$1.numsscr(); /*2765*/
				$1.nums = $k[--$j]; /*2765*/
				$1.nchars = $k[--$j]; /*2765*/
				for (;;) { /*2843*/
					if ((($eq($1.cset, "seta") || $eq($1.cset, "setb")) && ($1.nums >= 4)) && ($get($1.msg, $1.i) != $1.fn1)) { /*2782*/
						if (($1.nums % 2) == 0) { /*2780*/
							$k[$j++] = $1.swc; /*2772*/
							if ($eq($1.cset, "seta")) { /*2772*/
								$1.enca(); /*2772*/
							} else { /*2772*/
								$1.encb(); /*2772*/
							} /*2772*/
							$1.cset = "setc"; /*2773*/
							break; /*2774*/
						} else { /*2780*/
							$k[$j++] = $get($1.msg, $1.i); /*2776*/
							if ($eq($1.cset, "seta")) { /*2776*/
								$1.enca(); /*2776*/
							} else { /*2776*/
								$1.encb(); /*2776*/
							} /*2776*/
							$1.i = $1.i + 1; /*2777*/
							$k[$j++] = $1.swc; /*2778*/
							if ($eq($1.cset, "seta")) { /*2778*/
								$1.enca(); /*2778*/
							} else { /*2778*/
								$1.encb(); /*2778*/
							} /*2778*/
							$1.cset = "setc"; /*2779*/
							break; /*2780*/
						} /*2780*/
					} /*2780*/
					$k[$j++] = $eq($1.cset, "setb"); /*2783*/
					$k[$j++] = $get($1.msg, $1.i); /*2783*/
					$1.anotb(); /*2783*/
					var _7Y = $k[--$j]; /*2783*/
					if (($k[--$j] && _7Y)) { /*2795*/
						if ($1.i < ($1.msglen - 1)) { /*2791*/
							$k[$j++] = $1.i + 1; /*2785*/
							$1.bbeforea(); /*2785*/
							if ($k[--$j]) { /*2790*/
								$k[$j++] = $1.sft; /*2786*/
								$1.encb(); /*2786*/
								$k[$j++] = $get($1.msg, $1.i); /*2787*/
								$1.enca(); /*2787*/
								$1.i = $1.i + 1; /*2788*/
								break; /*2789*/
							} /*2789*/
						} /*2789*/
						$k[$j++] = $1.swa; /*2792*/
						$1.encb(); /*2792*/
						$1.cset = "seta"; /*2793*/
						break; /*2794*/
					} /*2794*/
					$k[$j++] = $eq($1.cset, "seta"); /*2796*/
					$k[$j++] = $get($1.msg, $1.i); /*2796*/
					$1.bnota(); /*2796*/
					var _7o = $k[--$j]; /*2796*/
					if (($k[--$j] && _7o)) { /*2808*/
						if ($1.i < ($1.msglen - 1)) { /*2804*/
							$k[$j++] = $1.i + 1; /*2798*/
							$1.abeforeb(); /*2798*/
							if ($k[--$j]) { /*2803*/
								$k[$j++] = $1.sft; /*2799*/
								$1.enca(); /*2799*/
								$k[$j++] = $get($1.msg, $1.i); /*2800*/
								$1.encb(); /*2800*/
								$1.i = $1.i + 1; /*2801*/
								break; /*2802*/
							} /*2802*/
						} /*2802*/
						$k[$j++] = $1.swb; /*2805*/
						$1.enca(); /*2805*/
						$1.cset = "setb"; /*2806*/
						break; /*2807*/
					} /*2807*/
					if ($eq($1.cset, "setc") && ($1.nums < 2)) { /*2818*/
						$k[$j++] = $1.i; /*2810*/
						$1.abeforeb(); /*2810*/
						if ($k[--$j]) { /*2814*/
							$k[$j++] = $1.swa; /*2811*/
							$1.encc(); /*2811*/
							$1.cset = "seta"; /*2812*/
							break; /*2813*/
						} /*2813*/
						$k[$j++] = $1.swb; /*2815*/
						$1.encc(); /*2815*/
						$1.cset = "setb"; /*2816*/
						break; /*2817*/
					} /*2817*/
					if ($eq($1.cset, "seta")) { /*2825*/
						$k[$j++] = $get($1.msg, $1.i); /*2822*/
						$1.enca(); /*2822*/
						$1.i = $1.i + 1; /*2823*/
						break; /*2824*/
					} /*2824*/
					if ($eq($1.cset, "setb")) { /*2830*/
						$k[$j++] = $get($1.msg, $1.i); /*2827*/
						$1.encb(); /*2827*/
						$1.i = $1.i + 1; /*2828*/
						break; /*2829*/
					} /*2829*/
					if ($eq($1.cset, "setc")) { /*2840*/
						if ($get($1.msg, $1.i) == $1.fn1) { /*2837*/
							$k[$j++] = $1.fn1; /*2833*/
							$1.encc(); /*2833*/
							$1.i = $1.i + 1; /*2834*/
						} else { /*2837*/
							$k[$j++] = $geti($1.msg, $1.i, 2); /*2836*/
							$1.encc(); /*2836*/
							$1.i = $1.i + 2; /*2837*/
						} /*2837*/
						break; /*2839*/
					} /*2839*/
					break; /*2842*/
				} /*2842*/
			} /*2842*/
			$1.cws = $geti($1.cws, 0, $1.j); /*2846*/
		} /*2846*/
		var _8V = $a($1.j + 2); /*2850*/
		$puti(_8V, 0, $1.cws); /*2850*/
		$1.cws = _8V; /*2850*/
		$1.csum = $get($1.cws, 0); /*2851*/
		for (var _8b = 1, _8a = $1.j - 1; _8b <= _8a; _8b += 1) { /*2855*/
			$1.i = _8b; /*2853*/
			$1.csum = $1.csum + ($get($1.cws, $1.i) * $1.i); /*2854*/
		} /*2854*/
		$1.csum = $1.csum % 103; /*2856*/
		$put($1.cws, $1.j, $1.csum); /*2857*/
		$put($1.cws, $1.j + 1, $get($1.seta, $1.stp)); /*2858*/
		$1.encs = $a(["212222", "222122", "222221", "121223", "121322", "131222", "122213", "122312", "132212", "221213", "221312", "231212", "112232", "122132", "122231", "113222", "123122", "123221", "223211", "221132", "221231", "213212", "223112", "312131", "311222", "321122", "321221", "312212", "322112", "322211", "212123", "212321", "232121", "111323", "131123", "131321", "112313", "132113", "132311", "211313", "231113", "231311", "112133", "112331", "132131", "113123", "113321", "133121", "313121", "211331", "231131", "213113", "213311", "213131", "311123", "311321", "331121", "312113", "312311", "332111", "314111", "221411", "431111", "111224", "111422", "121124", "121421", "141122", "141221", "112214", "112412", "122114", "122411", "142112", "142211", "241211", "221114", "413111", "241112", "134111", "111242", "121142", "121241", "114212", "124112", "124211", "411212", "421112", "421211", "212141", "214121", "412121", "111143", "111341", "131141", "114113", "114311", "411113", "411311", "113141", "114131", "311141", "411131", "211412", "211214", "211232", "2331112"]); /*2878*/
		$1.sbs = $s(($1.cws.length * 6) + 1); /*2881*/
		for (var _8v = 0, _8u = $1.cws.length - 1; _8v <= _8u; _8v += 1) { /*2885*/
			$1.i = _8v; /*2883*/
			$puti($1.sbs, $1.i * 6, $get($1.encs, $get($1.cws, $1.i))); /*2884*/
		} /*2884*/
		$k[$j++] = Infinity; /*2895*/
		$k[$j++] = "ren"; /*2890*/
		$k[$j++] = $0.renlinear; /*2890*/
		$k[$j++] = "sbs"; /*2890*/
		$k[$j++] = Infinity; /*2890*/
		var _93 = $1.sbs; /*2890*/
		for (var _94 = 0, _95 = _93.length; _94 < _95; _94++) { /*2890*/
			$k[$j++] = $get(_93, _94) - 48; /*2890*/
		} /*2890*/
		var _97 = $a(); /*2890*/
		$k[$j++] = _97; /*2891*/
		$k[$j++] = "bhs"; /*2891*/
		$k[$j++] = Infinity; /*2891*/
		for (var _99 = 0, _9A = ~~(($1.sbs.length + 1) / 2); _99 < _9A; _99++) { /*2891*/
			$k[$j++] = $1.height; /*2891*/
		} /*2891*/
		var _9C = $a(); /*2891*/
		$k[$j++] = _9C; /*2892*/
		$k[$j++] = "bbs"; /*2892*/
		$k[$j++] = Infinity; /*2892*/
		for (var _9E = 0, _9F = ~~(($1.sbs.length + 1) / 2); _9E < _9F; _9E++) { /*2892*/
			$k[$j++] = 0; /*2892*/
		} /*2892*/
		var _9G = $a(); /*2892*/
		$k[$j++] = _9G; /*2895*/
		$k[$j++] = "txt"; /*2895*/
		$k[$j++] = $a([$a([$1.text, $1.textxoffset, $1.textyoffset, $1.textfont, $1.textsize])]); /*2895*/
		$k[$j++] = "textxalign"; /*2895*/
		$k[$j++] = "center"; /*2895*/
		$k[$j++] = "opt"; /*2895*/
		$k[$j++] = $1.options; /*2895*/
		var _9P = $d(); /*2895*/
		$k[$j++] = _9P; /*2898*/
		if (!$1.dontdraw) { /*2898*/
			$0.renlinear(); /*2898*/
		} /*2898*/
	};
	$0["gs1-128"] = function() {
		var $1 = {}; /*2926*/
		$1.options = $k[--$j]; /*2928*/
		$1.barcode = $k[--$j]; /*2929*/
		$1.dontdraw = false; /*2931*/
		$1.includetext = false; /*2932*/
		$1.textfont = "Courier"; /*2933*/
		$1.textsize = 10; /*2934*/
		$1.textxoffset = 0; /*2935*/
		$1.textyoffset = -8.5; /*2936*/
		$1.height = 0.5; /*2937*/
		$1.linkagea = false; /*2938*/
		$1.linkagec = false; /*2939*/
		$forall($1.options, function() { /*2950*/
			var _3 = $k[--$j]; /*2950*/
			$1[$k[--$j]] = _3; /*2950*/
		}) /*2950*/
		$1.textfont = "" + $1.textfont; /*2952*/
		$1.textsize = +$1.textsize; /*2953*/
		$1.textxoffset = +$1.textxoffset; /*2954*/
		$1.textyoffset = +$1.textyoffset; /*2955*/
		$1.height = +$1.height; /*2956*/
		$1.text = $1.barcode; /*2958*/
		$1.expand = function() {
			$1.in = $k[--$j]; /*2962*/
			$1.out = $s($1.in.length); /*2963*/
			$1.j = 0; /*2964*/
			$k[$j++] = $1.in; /*2978*/
			for (;;) { /*2978*/
				$search($k[--$j], "^"); /*2967*/
				if ($k[--$j]) { /*2976*/
					var _H = $k[--$j]; /*2968*/
					$puti($1.out, $1.j, _H); /*2968*/
					$1.j = (_H.length + $1.j) + 1; /*2969*/
					$j--; /*2970*/
					var _L = $k[--$j]; /*2971*/
					$put($1.out, $1.j - 1, ~~$z($geti(_L, 0, 3))); /*2971*/
					$k[$j++] = $geti(_L, 3, _L.length - 3); /*2972*/
				} else { /*2976*/
					var _Q = $k[--$j]; /*2974*/
					$puti($1.out, $1.j, _Q); /*2974*/
					$1.j = _Q.length + $1.j; /*2975*/
					$k[$j++] = $geti($1.out, 0, $1.j); /*2976*/
					break; /*2976*/
				} /*2976*/
			} /*2976*/
		}; /*2979*/
		$1.ais = $a([]); /*2982*/
		$1.aival = {}; /*2983*/
		var _Y = $1.barcode; /*2984*/
		$k[$j++] = $geti(_Y, 1, _Y.length - 1); /*2996*/
		for (;;) { /*2996*/
			var _a = $k[--$j]; /*2986*/
			$k[$j++] = _a; /*2986*/
			if ($eq(_a, "")) { /*2986*/
				break; /*2986*/
			} /*2986*/
			$search($k[--$j], ")"); /*2987*/
			$j--; /*2987*/
			var _c = $k[--$j]; /*2988*/
			var _d = $k[--$j]; /*2988*/
			var _e = $k[--$j]; /*2989*/
			$k[$j++] = _c; /*2989*/
			$search(_e, "("); /*2989*/
			if ($k[--$j]) { /*2992*/
				var _g = $k[--$j]; /*2990*/
				var _h = $k[--$j]; /*2990*/
				var _i = $k[--$j]; /*2990*/
				var _j = $k[--$j]; /*2990*/
				$k[$j++] = _i; /*2990*/
				$k[$j++] = _j; /*2990*/
				$k[$j++] = _g; /*2990*/
			} else { /*2992*/
				var _k = $k[--$j]; /*2992*/
				var _l = $k[--$j]; /*2992*/
				$k[$j++] = ""; /*2992*/
				$k[$j++] = _l; /*2992*/
				$k[$j++] = _k; /*2992*/
			} /*2992*/
			$k[$j++] = Infinity; /*2994*/
			$aload($1.ais); /*2994*/
			var _o = $k[$j - 1 - ($counttomark() + 2)]; /*2994*/
			$k[$j++] = _o; /*2994*/
			$1.ais = $a(); /*2994*/
			var _r = $k[--$j]; /*2995*/
			var _s = $k[--$j]; /*2995*/
			$k[$j++] = $1.aival; /*2995*/
			$k[$j++] = _s; /*2995*/
			$k[$j++] = _r; /*2995*/
			$1.expand(); /*2995*/
			var _t = $k[--$j]; /*2995*/
			var _u = $k[--$j]; /*2995*/
			$put($k[--$j], _u, _t); /*2995*/
		} /*2995*/
		$j--; /*2997*/
		$1.aifixed = {}; /*3002*/
		$k[$j++] = Infinity; /*3004*/
		for (var _w = 0; _w <= 4; _w += 1) { /*3004*/
			$k[$j++] = _w; /*3004*/
		} /*3004*/
		var _x = $a(); /*3004*/
		for (var _y = 0, _z = _x.length; _y < _z; _y++) { /*3007*/
			var _12 = $strcpy($s(2), "00"); /*3006*/
			$put(_12, 1, $get(_x, _y) + 48); /*3006*/
			$put($1.aifixed, _12, _12); /*3006*/
		} /*3006*/
		$k[$j++] = Infinity; /*3012*/
		for (var _14 = 11; _14 <= 20; _14 += 1) { /*3009*/
			$k[$j++] = _14; /*3009*/
		} /*3009*/
		$k[$j++] = 23; /*3011*/
		for (var _15 = 31; _15 <= 36; _15 += 1) { /*3011*/
			$k[$j++] = _15; /*3011*/
		} /*3011*/
		$k[$j++] = 41; /*3012*/
		var _16 = $a(); /*3012*/
		for (var _17 = 0, _18 = _16.length; _17 < _18; _17++) { /*3015*/
			var _1B = $cvrs($s(2), $get(_16, _17), 10); /*3014*/
			$put($1.aifixed, _1B, _1B); /*3014*/
		} /*3014*/
		$1.fnc1 = -1; /*3018*/
		$1.c128 = $a([$1.fnc1]); /*3019*/
		for (var _1H = 0, _1G = $1.ais.length - 1; _1H <= _1G; _1H += 1) { /*3035*/
			$1.i = _1H; /*3021*/
			$1.ai = $get($1.ais, $1.i); /*3022*/
			$1.val = $get($1.aival, $1.ai); /*3023*/
			var _1R = $a(($1.c128.length + $1.ai.length) + $1.val.length); /*3024*/
			$puti(_1R, 0, $1.c128); /*3025*/
			$k[$j++] = _1R; /*3026*/
			$k[$j++] = _1R; /*3026*/
			$k[$j++] = $1.c128.length; /*3026*/
			$k[$j++] = $1.ai; /*3026*/
			$k[$j++] = Infinity; /*3026*/
			var _1V = $k[--$j]; /*3026*/
			var _1W = $k[--$j]; /*3026*/
			$k[$j++] = _1V; /*3026*/
			$forall(_1W); /*3026*/
			var _1X = $a(); /*3026*/
			var _1Y = $k[--$j]; /*3026*/
			$puti($k[--$j], _1Y, _1X); /*3026*/
			var _1a = $k[--$j]; /*3027*/
			$k[$j++] = _1a; /*3027*/
			$k[$j++] = _1a; /*3027*/
			$k[$j++] = $1.c128.length + $1.ai.length; /*3027*/
			$k[$j++] = $1.val; /*3027*/
			$k[$j++] = Infinity; /*3027*/
			var _1e = $k[--$j]; /*3027*/
			var _1f = $k[--$j]; /*3027*/
			$k[$j++] = _1e; /*3027*/
			$forall(_1f); /*3027*/
			var _1g = $a(); /*3027*/
			var _1h = $k[--$j]; /*3027*/
			$puti($k[--$j], _1h, _1g); /*3027*/
			$1.c128 = $k[--$j]; /*3028*/
			var _1p = $get($1.aifixed, $geti($1.ai, 0, 2)) !== undefined; /*3029*/
			if (($1.i != ($1.ais.length - 1)) && (!_1p)) { /*3034*/
				var _1r = $a($1.c128.length + 1); /*3030*/
				$puti(_1r, 0, $1.c128); /*3031*/
				$put(_1r, $1.c128.length, $1.fnc1); /*3032*/
				$1.c128 = _1r; /*3033*/
			} /*3033*/
		} /*3033*/
		$1.barcode = $s(($1.c128.length + 1) * 5); /*3038*/
		$1.i = 0; /*3039*/
		$1.j = 0; /*3039*/
		for (;;) { /*3049*/
			if ($1.i == $1.c128.length) { /*3040*/
				break; /*3040*/
			} /*3040*/
			var _21 = $get($1.c128, $1.i); /*3041*/
			$k[$j++] = _21; /*3046*/
			if (_21 == $1.fnc1) { /*3045*/
				$j--; /*3042*/
				$puti($1.barcode, $1.j, "^FNC1"); /*3042*/
				$1.j = $1.j + 4; /*3043*/
			} else { /*3045*/
				$put($1.barcode, $1.j, $k[--$j]); /*3045*/
			} /*3045*/
			$1.i = $1.i + 1; /*3047*/
			$1.j = $1.j + 1; /*3048*/
		} /*3048*/
		if ($1.linkagea || $1.linkagec) { /*3053*/
			$k[$j++] = $1.barcode; /*3051*/
			$k[$j++] = $1.j; /*3051*/
			if ($1.linkagea) { /*3051*/
				$k[$j++] = "^LNKA"; /*3051*/
			} else { /*3051*/
				$k[$j++] = "^LNKC"; /*3051*/
			} /*3051*/
			var _2G = $k[--$j]; /*3051*/
			var _2H = $k[--$j]; /*3051*/
			$puti($k[--$j], _2H, _2G); /*3051*/
			$1.j = $1.j + 5; /*3052*/
		} /*3052*/
		$1.barcode = $geti($1.barcode, 0, $1.j); /*3054*/
		$1.options.height = $1.height; /*3057*/
		$1.options.dontdraw = true; /*3058*/
		$1.options.parsefnc = true; /*3059*/
		$k[$j++] = "args"; /*3060*/
		$k[$j++] = $1.barcode; /*3060*/
		$k[$j++] = $1.options; /*3060*/
		$0.code128(); /*3060*/
		var _2T = $k[--$j]; /*3060*/
		$1[$k[--$j]] = _2T; /*3060*/
		$1.args.txt = $a([$a([$1.text, $1.textxoffset, $1.textyoffset, $1.textfont, $1.textsize])]); /*3062*/
		$1.args.textxalign = "center"; /*3063*/
		$1.args.opt = $1.options; /*3064*/
		$k[$j++] = $1.args; /*3067*/
		if (!$1.dontdraw) { /*3067*/
			$0.renlinear(); /*3067*/
		} /*3067*/
	};
	$0.ean14 = function() {
		var $1 = {}; /*3095*/
		$1.options = $k[--$j]; /*3097*/
		$1.barcode = $k[--$j]; /*3098*/
		$1.dontdraw = false; /*3100*/
		$1.includetext = false; /*3101*/
		$1.textfont = "Courier"; /*3102*/
		$1.textsize = 10; /*3103*/
		$1.textxoffset = 0; /*3104*/
		$1.textyoffset = -8.5; /*3105*/
		$1.height = 1; /*3106*/
		$forall($1.options, function() { /*3117*/
			var _3 = $k[--$j]; /*3117*/
			$1[$k[--$j]] = _3; /*3117*/
		}) /*3117*/
		$1.textfont = "" + $1.textfont; /*3119*/
		$1.textsize = +$1.textsize; /*3120*/
		$1.textxoffset = +$1.textxoffset; /*3121*/
		$1.textyoffset = +$1.textyoffset; /*3122*/
		$1.height = +$1.height; /*3123*/
		$1.text = $1.barcode; /*3126*/
		var _B = $1.barcode; /*3127*/
		$k[$j++] = $s(_B.length); /*3128*/
		$k[$j++] = 0; /*3128*/
		$forall(_B, function() { /*3128*/
			var _D = $k[--$j]; /*3128*/
			$k[$j++] = _D; /*3128*/
			if (_D != 32) { /*3128*/
				var _E = $k[--$j]; /*3128*/
				var _F = $k[--$j]; /*3128*/
				var _G = $k[--$j]; /*3128*/
				$put(_G, _F, _E); /*3128*/
				$k[$j++] = _G; /*3128*/
				$k[$j++] = _F + 1; /*3128*/
			} else { /*3128*/
				$j--; /*3128*/
			} /*3128*/
		}) /*3128*/
		var _H = $k[--$j]; /*3129*/
		$1.barcode = $geti($k[--$j], 0, _H); /*3129*/
		$1.hasspace = $1.text.length != $1.barcode.length; /*3130*/
		if ($ne($geti($1.barcode, 0, 4), "(01)")) { /*3135*/
			$k[$j++] = "bwipp.ean14badAI"; /*3134*/
			$k[$j++] = "GS1-14 must begin with (01) application identifier"; /*3134*/
			$0.raiseerror(); /*3134*/
		} /*3134*/
		if (($1.barcode.length != 17) && ($1.barcode.length != 18)) { /*3138*/
			$k[$j++] = "bwipp.ean14badLength"; /*3137*/
			$k[$j++] = "GS1-14 must be 13 or 14 digits"; /*3137*/
			$0.raiseerror(); /*3137*/
		} /*3137*/
		$forall($geti($1.barcode, 4, $1.barcode.length - 4), function() { /*3143*/
			var _T = $k[--$j]; /*3140*/
			if ((_T < 48) || (_T > 57)) { /*3142*/
				$k[$j++] = "bwipp.ean14badCharacter"; /*3141*/
				$k[$j++] = "GS1-14 must contain only digits"; /*3141*/
				$0.raiseerror(); /*3141*/
			} /*3141*/
		}) /*3141*/
		$1.checksum = 0; /*3146*/
		for (var _U = 0; _U <= 12; _U += 1) { /*3150*/
			$1.i = _U; /*3148*/
			$k[$j++] = "checksum"; /*3149*/
			$k[$j++] = $1.checksum; /*3149*/
			$k[$j++] = $get($1.barcode, $1.i + 4) - 48; /*3149*/
			if (($1.i % 2) == 0) { /*3149*/
				var _a = $k[--$j]; /*3149*/
				$k[$j++] = _a * 3; /*3149*/
			} /*3149*/
			var _b = $k[--$j]; /*3149*/
			var _c = $k[--$j]; /*3149*/
			$1[$k[--$j]] = _c + _b; /*3149*/
		} /*3149*/
		$1.checksum = (10 - ($1.checksum % 10)) % 10; /*3151*/
		if ($1.barcode.length == 18) { /*3165*/
			if ($get($1.barcode, 17) != ($1.checksum + 48)) { /*3155*/
				$k[$j++] = "bwipp.ean14badCheckDigit"; /*3154*/
				$k[$j++] = "Incorrect GS1-14 check digit provided"; /*3154*/
				$0.raiseerror(); /*3154*/
			} /*3154*/
		} else { /*3165*/
			var _j = $s(18); /*3157*/
			$puti(_j, 0, $1.barcode); /*3158*/
			$put(_j, 17, $1.checksum + 48); /*3159*/
			$1.barcode = _j; /*3160*/
			var _o = $1.hasspace ? 2 : 1; /*3161*/
			var _p = $s($1.text.length + _o); /*3161*/
			$puti(_p, _p.length - 2, " "); /*3162*/
			$put(_p, _p.length - 1, $1.checksum + 48); /*3163*/
			$puti(_p, 0, $1.text); /*3164*/
			$1.text = _p; /*3165*/
		} /*3165*/
		$1.gtin = $geti($1.barcode, 4, 14); /*3167*/
		$1.barcode = $s(21); /*3170*/
		$puti($1.barcode, 0, "^FNC101"); /*3171*/
		$puti($1.barcode, 7, $1.gtin); /*3172*/
		$1.options.dontdraw = true; /*3175*/
		$1.options.parsefnc = true; /*3176*/
		$k[$j++] = "args"; /*3177*/
		$k[$j++] = $1.barcode; /*3177*/
		$k[$j++] = $1.options; /*3177*/
		$0.code128(); /*3177*/
		var _12 = $k[--$j]; /*3177*/
		$1[$k[--$j]] = _12; /*3177*/
		$1.args.txt = $a([$a([$1.text, $1.textxoffset, $1.textyoffset, $1.textfont, $1.textsize])]); /*3179*/
		$1.args.textxalign = "center"; /*3180*/
		$1.args.opt = $1.options; /*3181*/
		$k[$j++] = $1.args; /*3184*/
		if (!$1.dontdraw) { /*3184*/
			$0.renlinear(); /*3184*/
		} /*3184*/
	};
	$0.sscc18 = function() {
		var $1 = {}; /*3212*/
		$1.options = $k[--$j]; /*3214*/
		$1.barcode = $k[--$j]; /*3215*/
		$1.dontdraw = false; /*3217*/
		$1.includetext = false; /*3218*/
		$1.textfont = "Courier"; /*3219*/
		$1.textsize = 10; /*3220*/
		$1.textxoffset = 0; /*3221*/
		$1.textyoffset = -8.5; /*3222*/
		$1.height = 1; /*3223*/
		$forall($1.options, function() { /*3234*/
			var _3 = $k[--$j]; /*3234*/
			$1[$k[--$j]] = _3; /*3234*/
		}) /*3234*/
		$1.textfont = "" + $1.textfont; /*3236*/
		$1.textsize = +$1.textsize; /*3237*/
		$1.textxoffset = +$1.textxoffset; /*3238*/
		$1.textyoffset = +$1.textyoffset; /*3239*/
		$1.height = +$1.height; /*3240*/
		$1.text = $1.barcode; /*3243*/
		var _B = $1.barcode; /*3244*/
		$k[$j++] = $s(_B.length); /*3245*/
		$k[$j++] = 0; /*3245*/
		$forall(_B, function() { /*3245*/
			var _D = $k[--$j]; /*3245*/
			$k[$j++] = _D; /*3245*/
			if (_D != 32) { /*3245*/
				var _E = $k[--$j]; /*3245*/
				var _F = $k[--$j]; /*3245*/
				var _G = $k[--$j]; /*3245*/
				$put(_G, _F, _E); /*3245*/
				$k[$j++] = _G; /*3245*/
				$k[$j++] = _F + 1; /*3245*/
			} else { /*3245*/
				$j--; /*3245*/
			} /*3245*/
		}) /*3245*/
		var _H = $k[--$j]; /*3246*/
		$1.barcode = $geti($k[--$j], 0, _H); /*3246*/
		$1.hasspace = $1.text.length != $1.barcode.length; /*3247*/
		if ($ne($geti($1.barcode, 0, 4), "(00)")) { /*3252*/
			$k[$j++] = "bwipp.sscc18badAI"; /*3251*/
			$k[$j++] = "SSCC-18 must begin with (00) application identifier"; /*3251*/
			$0.raiseerror(); /*3251*/
		} /*3251*/
		if (($1.barcode.length != 21) && ($1.barcode.length != 22)) { /*3255*/
			$k[$j++] = "bwipp.sscc18badLength"; /*3254*/
			$k[$j++] = "SSCC-18 must be 17 or 18 digits"; /*3254*/
			$0.raiseerror(); /*3254*/
		} /*3254*/
		$forall($geti($1.barcode, 4, $1.barcode.length - 4), function() { /*3260*/
			var _T = $k[--$j]; /*3257*/
			if ((_T < 48) || (_T > 57)) { /*3259*/
				$k[$j++] = "bwipp.sscc18badCharacter"; /*3258*/
				$k[$j++] = "SSCC-18 must contain only digits"; /*3258*/
				$0.raiseerror(); /*3258*/
			} /*3258*/
		}) /*3258*/
		$1.checksum = 0; /*3263*/
		for (var _U = 0; _U <= 16; _U += 1) { /*3267*/
			$1.i = _U; /*3265*/
			$k[$j++] = "checksum"; /*3266*/
			$k[$j++] = $1.checksum; /*3266*/
			$k[$j++] = $get($1.barcode, $1.i + 4) - 48; /*3266*/
			if (($1.i % 2) == 0) { /*3266*/
				var _a = $k[--$j]; /*3266*/
				$k[$j++] = _a * 3; /*3266*/
			} /*3266*/
			var _b = $k[--$j]; /*3266*/
			var _c = $k[--$j]; /*3266*/
			$1[$k[--$j]] = _c + _b; /*3266*/
		} /*3266*/
		$1.checksum = (10 - ($1.checksum % 10)) % 10; /*3268*/
		if ($1.barcode.length == 22) { /*3282*/
			if ($get($1.barcode, 21) != ($1.checksum + 48)) { /*3272*/
				$k[$j++] = "bwipp.sscc18badCheckDigit"; /*3271*/
				$k[$j++] = "Incorrect SSCC-18 check digit provided"; /*3271*/
				$0.raiseerror(); /*3271*/
			} /*3271*/
		} else { /*3282*/
			var _j = $s(22); /*3274*/
			$puti(_j, 0, $1.barcode); /*3275*/
			$put(_j, 21, $1.checksum + 48); /*3276*/
			$1.barcode = _j; /*3277*/
			var _o = $1.hasspace ? 2 : 1; /*3278*/
			var _p = $s($1.text.length + _o); /*3278*/
			$puti(_p, _p.length - 2, " "); /*3279*/
			$put(_p, _p.length - 1, $1.checksum + 48); /*3280*/
			$puti(_p, 0, $1.text); /*3281*/
			$1.text = _p; /*3282*/
		} /*3282*/
		$1.sscc = $geti($1.barcode, 4, 18); /*3284*/
		$1.barcode = $s(25); /*3287*/
		$puti($1.barcode, 0, "^FNC100"); /*3288*/
		$puti($1.barcode, 7, $1.sscc); /*3289*/
		$1.options.dontdraw = true; /*3292*/
		$1.options.parsefnc = true; /*3293*/
		$k[$j++] = "args"; /*3294*/
		$k[$j++] = $1.barcode; /*3294*/
		$k[$j++] = $1.options; /*3294*/
		$0.code128(); /*3294*/
		var _12 = $k[--$j]; /*3294*/
		$1[$k[--$j]] = _12; /*3294*/
		$1.args.txt = $a([$a([$1.text, $1.textxoffset, $1.textyoffset, $1.textfont, $1.textsize])]); /*3296*/
		$1.args.textxalign = "center"; /*3297*/
		$1.args.opt = $1.options; /*3298*/
		$k[$j++] = $1.args; /*3301*/
		if (!$1.dontdraw) { /*3301*/
			$0.renlinear(); /*3301*/
		} /*3301*/
	};
	$0.code39 = function() {
		var $1 = {}; /*3328*/
		$1.options = $k[--$j]; /*3330*/
		$1.barcode = $k[--$j]; /*3331*/
		$1.dontdraw = false; /*3333*/
		$1.includecheck = false; /*3334*/
		$1.validatecheck = false; /*3335*/
		$1.includetext = false; /*3336*/
		$1.includecheckintext = false; /*3337*/
		$1.hidestars = false; /*3338*/
		$1.textfont = "Courier"; /*3339*/
		$1.textsize = 10; /*3340*/
		$1.textyoffset = -8.5; /*3341*/
		$1.height = 1; /*3342*/
		$forall($1.options, function() { /*3353*/
			var _3 = $k[--$j]; /*3353*/
			$1[$k[--$j]] = _3; /*3353*/
		}) /*3353*/
		$1.textfont = "" + $1.textfont; /*3355*/
		$1.textsize = +$1.textsize; /*3356*/
		$1.textyoffset = +$1.textyoffset; /*3357*/
		$1.height = +$1.height; /*3358*/
		$1.barchars = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%"; /*3361*/
		$1.charvals = {}; /*3362*/
		for (var _9 = 0; _9 <= 42; _9 += 1) { /*3363*/
			$put($1.charvals, $geti($1.barchars, _9, 1), _9); /*3363*/
		} /*3363*/
		for (var _F = 0, _E = $1.barcode.length - 1; _F <= _E; _F += 1) { /*3370*/
			var _J = $get($1.charvals, $geti($1.barcode, _F, 1)) !== undefined; /*3367*/
			if (!_J) { /*3369*/
				$k[$j++] = "bwipp.code39badCharacter"; /*3368*/
				$k[$j++] = "Code 39 must contain only digits, capital letters, spaces and the symbols -.$/+%"; /*3368*/
				$0.raiseerror(); /*3368*/
			} /*3368*/
		} /*3368*/
		$k[$j++] = "barlen"; /*3372*/
		$k[$j++] = $1.barcode.length; /*3372*/
		if ($1.validatecheck) { /*3372*/
			var _M = $k[--$j]; /*3372*/
			$k[$j++] = _M - 1; /*3372*/
		} /*3372*/
		var _N = $k[--$j]; /*3372*/
		$1[$k[--$j]] = _N; /*3372*/
		$1.checksum = 0; /*3374*/
		for (var _R = 0, _Q = $1.barlen - 1; _R <= _Q; _R += 1) { /*3378*/
			$1.checksum = $get($1.charvals, $geti($1.barcode, _R, 1)) + $1.checksum; /*3377*/
		} /*3377*/
		$1.checksum = $1.checksum % 43; /*3379*/
		if ($1.validatecheck) { /*3386*/
			if ($get($1.barcode, $1.barlen) != $get($1.barchars, $1.checksum)) { /*3383*/
				$k[$j++] = "bwipp.code39badCheckDigit"; /*3382*/
				$k[$j++] = "Incorrect Code 39 check digit provided"; /*3382*/
				$0.raiseerror(); /*3382*/
			} /*3382*/
			$1.barcode = $geti($1.barcode, 0, $1.barlen); /*3384*/
			$1.includecheck = true; /*3385*/
		} /*3385*/
		$1.encs = $a(["1113313111", "3113111131", "1133111131", "3133111111", "1113311131", "3113311111", "1133311111", "1113113131", "3113113111", "1133113111", "3111131131", "1131131131", "3131131111", "1111331131", "3111331111", "1131331111", "1111133131", "3111133111", "1131133111", "1111333111", "3111111331", "1131111331", "3131111311", "1111311331", "3111311311", "1131311311", "1111113331", "3111113311", "1131113311", "1111313311", "3311111131", "1331111131", "3331111111", "1311311131", "3311311111", "1331311111", "1311113131", "3311113111", "1331113111", "1313131111", "1313111311", "1311131311", "1113131311", "1311313111"]); /*3399*/
		var _l = $1.includecheck ? 3 : 2; /*3401*/
		$1.sbs = $s(($1.barlen + _l) * 10); /*3401*/
		var _p = $1.includecheck ? 3 : 2; /*3402*/
		$1.txt = $a($1.barlen + _p); /*3402*/
		$puti($1.sbs, 0, $get($1.encs, 43)); /*3405*/
		if (!$1.hidestars) { /*3409*/
			$put($1.txt, 0, $a(["*", 0, $1.textyoffset, $1.textfont, $1.textsize])); /*3407*/
		} else { /*3409*/
			$put($1.txt, 0, $a(["", 0, $1.textyoffset, $1.textfont, $1.textsize])); /*3409*/
		} /*3409*/
		for (var _17 = 0, _16 = $1.barlen - 1; _17 <= _16; _17 += 1) { /*3417*/
			$1.i = _17; /*3413*/
			$1.indx = $get($1.charvals, $geti($1.barcode, $1.i, 1)); /*3414*/
			$puti($1.sbs, ($1.i * 10) + 10, $get($1.encs, $1.indx)); /*3415*/
			$put($1.txt, $1.i + 1, $a([$geti($1.barcode, $1.i, 1), ($1.i + 1) * 16, $1.textyoffset, $1.textfont, $1.textsize])); /*3416*/
		} /*3416*/
		if ($1.includecheck) { /*3438*/
			$puti($1.sbs, ($1.barlen * 10) + 10, $get($1.encs, $1.checksum)); /*3421*/
			if ($1.includecheckintext) { /*3425*/
				$put($1.txt, $1.barlen + 1, $a([$geti($1.barchars, $1.checksum, 1), ($1.barlen + 1) * 16, $1.textyoffset, $1.textfont, $1.textsize])); /*3423*/
			} else { /*3425*/
				$put($1.txt, $1.barlen + 1, $a(["", ($1.barlen + 1) * 16, $1.textyoffset, $1.textfont, $1.textsize])); /*3425*/
			} /*3425*/
			$puti($1.sbs, ($1.barlen * 10) + 20, $get($1.encs, 43)); /*3427*/
			if (!$1.hidestars) { /*3431*/
				$put($1.txt, $1.barlen + 2, $a(["*", ($1.barlen + 2) * 16, $1.textyoffset, $1.textfont, $1.textsize])); /*3429*/
			} else { /*3431*/
				$put($1.txt, $1.barlen + 2, $a(["", ($1.barlen + 2) * 16, $1.textyoffset, $1.textfont, $1.textsize])); /*3431*/
			} /*3431*/
		} else { /*3438*/
			$puti($1.sbs, ($1.barlen * 10) + 10, $get($1.encs, 43)); /*3434*/
			if (!$1.hidestars) { /*3438*/
				$put($1.txt, $1.barlen + 1, $a(["*", ($1.barlen + 1) * 16, $1.textyoffset, $1.textfont, $1.textsize])); /*3436*/
			} else { /*3438*/
				$put($1.txt, $1.barlen + 1, $a(["", ($1.barlen + 1) * 16, $1.textyoffset, $1.textfont, $1.textsize])); /*3438*/
			} /*3438*/
		} /*3438*/
		$k[$j++] = Infinity; /*3451*/
		$k[$j++] = "ren"; /*3445*/
		$k[$j++] = $0.renlinear; /*3445*/
		$k[$j++] = "sbs"; /*3445*/
		$k[$j++] = Infinity; /*3445*/
		var _2S = $1.sbs; /*3445*/
		for (var _2T = 0, _2U = _2S.length; _2T < _2U; _2T++) { /*3445*/
			$k[$j++] = $get(_2S, _2T) - 48; /*3445*/
		} /*3445*/
		var _2W = $a(); /*3445*/
		$k[$j++] = _2W; /*3446*/
		$k[$j++] = "bhs"; /*3446*/
		$k[$j++] = Infinity; /*3446*/
		for (var _2Y = 0, _2Z = ~~(($1.sbs.length + 1) / 2); _2Y < _2Z; _2Y++) { /*3446*/
			$k[$j++] = $1.height; /*3446*/
		} /*3446*/
		var _2b = $a(); /*3446*/
		$k[$j++] = _2b; /*3447*/
		$k[$j++] = "bbs"; /*3447*/
		$k[$j++] = Infinity; /*3447*/
		for (var _2d = 0, _2e = ~~(($1.sbs.length + 1) / 2); _2d < _2e; _2d++) { /*3447*/
			$k[$j++] = 0; /*3447*/
		} /*3447*/
		var _2f = $a(); /*3447*/
		$k[$j++] = _2f; /*3450*/
		if ($1.includetext) { /*3450*/
			$k[$j++] = "txt"; /*3449*/
			$k[$j++] = $1.txt; /*3449*/
		} /*3449*/
		$k[$j++] = "opt"; /*3451*/
		$k[$j++] = $1.options; /*3451*/
		var _2j = $d(); /*3451*/
		$k[$j++] = _2j; /*3454*/
		if (!$1.dontdraw) { /*3454*/
			$0.renlinear(); /*3454*/
		} /*3454*/
	};
	$0.code39ext = function() {
		var $1 = {}; /*3482*/
		$1.options = $k[--$j]; /*3484*/
		$1.barcode = $k[--$j]; /*3485*/
		$1.dontdraw = false; /*3487*/
		$1.includetext = false; /*3488*/
		$1.parse = false; /*3489*/
		$forall($1.options, function() { /*3500*/
			var _3 = $k[--$j]; /*3500*/
			$1[$k[--$j]] = _3; /*3500*/
		}) /*3500*/
		$forall($1.barcode, function() { /*3528*/
			if ($k[--$j] >= 128) { /*3527*/
				$k[$j++] = "bwipp.code39extBadCharacter"; /*3526*/
				$k[$j++] = "Code 39 Extended must contain only ASCII characters"; /*3526*/
				$0.raiseerror(); /*3526*/
			} /*3526*/
		}) /*3526*/
		$1.barlen = $1.barcode.length; /*3530*/
		$1.extencs = $a(["%U", "$A", "$B", "$C", "$D", "$E", "$F", "$G", "$H", "$I", "$J", "$K", "$L", "$M", "$N", "$O", "$P", "$Q", "$R", "$S", "$T", "$U", "$V", "$W", "$X", "$Y", "$Z", "%A", "%B", "%C", "%D", "%E", " ", "/A", "/B", "/C", "/D", "/E", "/F", "/G", "/H", "/I", "/J", "/K", "/L", "-", ".", "/O", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "/Z", "%F", "%G", "%H", "%I", "%J", "%V", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "%K", "%L", "%M", "%N", "%O", "%W", "+A", "+B", "+C", "+D", "+E", "+F", "+G", "+H", "+I", "+J", "+K", "+L", "+M", "+N", "+O", "+P", "+Q", "+R", "+S", "+T", "+U", "+V", "+W", "+X", "+Y", "+Z", "%P", "%Q", "%R", "%S", "%T"]); /*3542*/
		$1.newcode = $s($1.barlen * 2); /*3544*/
		$1.newtext = $s($1.barlen * 2); /*3545*/
		$1.j = 0; /*3546*/
		for (var _F = 0, _E = $1.barlen - 1; _F <= _E; _F += 1) { /*3554*/
			$1.i = _F; /*3548*/
			$1.extchar = $get($1.extencs, $get($1.barcode, $1.i)); /*3549*/
			$puti($1.newcode, $1.j, $1.extchar); /*3550*/
			$put($1.newtext, $1.j, $get($1.barcode, $1.i)); /*3551*/
			if ($1.extchar.length != 1) { /*3552*/
				$puti($1.newtext, $1.j + 1, " "); /*3552*/
			} /*3552*/
			$1.j = $1.j + $1.extchar.length; /*3553*/
		} /*3553*/
		$1.newcode = $geti($1.newcode, 0, $1.j); /*3555*/
		$1.newtext = $geti($1.newtext, 0, $1.j); /*3556*/
		$1.options.dontdraw = true; /*3559*/
		$k[$j++] = "args"; /*3560*/
		$k[$j++] = $1.newcode; /*3560*/
		$k[$j++] = $1.options; /*3560*/
		$0.code39(); /*3560*/
		var _h = $k[--$j]; /*3560*/
		$1[$k[--$j]] = _h; /*3560*/
		if ($1.includetext) { /*3572*/
			$1.txt = $1.args.txt; /*3564*/
			for (var _o = 0, _n = $1.newtext.length - 1; _o <= _n; _o += 1) { /*3570*/
				$1.i = _o; /*3566*/
				$1.txtentry = $get($1.txt, $1.i + 1); /*3567*/
				$put($1.txtentry, 0, $geti($1.newtext, $1.i, 1)); /*3568*/
				$put($1.txt, $1.i + 1, $1.txtentry); /*3569*/
			} /*3569*/
			$1.args.txt = $1.txt; /*3571*/
		} /*3571*/
		$1.args.opt = $1.options; /*3573*/
		$k[$j++] = $1.args; /*3576*/
		if (!$1.dontdraw) { /*3576*/
			$0.renlinear(); /*3576*/
		} /*3576*/
	};
	$0.code32 = function() {
		var $1 = {}; /*3604*/
		$1.options = $k[--$j]; /*3606*/
		$1.barcode = $k[--$j]; /*3607*/
		$1.dontdraw = false; /*3609*/
		$1.includetext = false; /*3610*/
		$1.textfont = "Courier"; /*3611*/
		$1.textsize = 10; /*3612*/
		$1.textyoffset = -8.5; /*3613*/
		$1.textxoffset = 0; /*3614*/
		$1.height = 1; /*3615*/
		$forall($1.options, function() { /*3626*/
			var _3 = $k[--$j]; /*3626*/
			$1[$k[--$j]] = _3; /*3626*/
		}) /*3626*/
		$1.textfont = "" + $1.textfont; /*3628*/
		$1.textsize = +$1.textsize; /*3629*/
		$1.textyoffset = +$1.textyoffset; /*3630*/
		$1.height = +$1.height; /*3631*/
		if (($1.barcode.length != 8) && ($1.barcode.length != 9)) { /*3636*/
			$k[$j++] = "bwipp.code32badLength"; /*3635*/
			$k[$j++] = "Italian Pharmacode must be 8 or 9 digits"; /*3635*/
			$0.raiseerror(); /*3635*/
		} /*3635*/
		$forall($1.barcode, function() { /*3641*/
			var _C = $k[--$j]; /*3638*/
			if ((_C < 48) || (_C > 57)) { /*3640*/
				$k[$j++] = "bwipp.code32badCharacter"; /*3639*/
				$k[$j++] = "Italian Pharmacode must contain only digits"; /*3639*/
				$0.raiseerror(); /*3639*/
			} /*3639*/
		}) /*3639*/
		$1.checksum = 0; /*3644*/
		for (var _D = 0; _D <= 7; _D += 1) { /*3649*/
			$1.i = _D; /*3646*/
			$k[$j++] = $get($1.barcode, $1.i) - 48; /*3647*/
			if (($1.i % 2) != 0) { /*3647*/
				var _I = $k[--$j]; /*3647*/
				$k[$j++] = _I * 2; /*3647*/
			} /*3647*/
			var _J = $k[--$j]; /*3647*/
			$k[$j++] = _J; /*3647*/
			if (_J > 9) { /*3647*/
				var _K = $k[--$j]; /*3647*/
				$k[$j++] = _K - 9; /*3647*/
			} /*3647*/
			$1.checksum = $k[--$j] + $1.checksum; /*3648*/
		} /*3648*/
		$1.checksum = $1.checksum % 10; /*3650*/
		if ($1.barcode.length == 9) { /*3655*/
			if ($get($1.barcode, 8) != ($1.checksum + 48)) { /*3654*/
				$k[$j++] = "bwipp.code32badCheckDigit"; /*3653*/
				$k[$j++] = "Incorrect Italian Pharmacode check digit provided"; /*3653*/
				$0.raiseerror(); /*3653*/
			} /*3653*/
		} /*3653*/
		var _S = $s(10); /*3656*/
		$puti(_S, 0, $1.barcode); /*3657*/
		$put(_S, 8, $1.checksum + 48); /*3658*/
		$1.text = _S; /*3659*/
		$1.val = $cvrs($1.barcode, ~~$z($1.text), 32); /*3662*/
		$1.barcode = $s(6); /*3663*/
		for (var _Z = 0; _Z <= 5; _Z += 1) { /*3664*/
			$put($1.barcode, _Z, 48); /*3664*/
		} /*3664*/
		$puti($1.barcode, 6 - $1.val.length, $1.val); /*3665*/
		for (var _e = 0; _e <= 5; _e += 1) { /*3672*/
			var _g = $get($1.barcode, _e); /*3669*/
			$k[$j++] = _e; /*3670*/
			$k[$j++] = _g; /*3670*/
			$k[$j++] = _g; /*3670*/
			for (var _h = 0, _i = "AEIO".length; _h < _i; _h++) { /*3670*/
				if ($k[--$j] >= $get("AEIO", _h)) { /*3670*/
					var _l = $k[--$j]; /*3670*/
					$k[$j++] = _l + 1; /*3670*/
				} /*3670*/
				var _m = $k[--$j]; /*3670*/
				$k[$j++] = _m; /*3670*/
				$k[$j++] = _m; /*3670*/
			} /*3670*/
			$j--; /*3670*/
			var _o = $k[--$j]; /*3671*/
			$put($1.barcode, $k[--$j], _o); /*3671*/
		} /*3671*/
		$puti($1.text, 1, $geti($1.text, 0, 9)); /*3675*/
		$put($1.text, 0, 65); /*3676*/
		$1.options.dontdraw = true; /*3679*/
		$k[$j++] = "args"; /*3680*/
		$k[$j++] = $1.barcode; /*3680*/
		$k[$j++] = $1.options; /*3680*/
		$0.code39(); /*3680*/
		var _x = $k[--$j]; /*3680*/
		$1[$k[--$j]] = _x; /*3680*/
		$1.args.txt = $a([$a([$1.text, $1.textxoffset, $1.textyoffset, $1.textfont, $1.textsize])]); /*3682*/
		$1.args.textxalign = "center"; /*3683*/
		$1.args.opt = $1.options; /*3684*/
		$k[$j++] = $1.args; /*3687*/
		if (!$1.dontdraw) { /*3687*/
			$0.renlinear(); /*3687*/
		} /*3687*/
	};
	$0.pzn = function() {
		var $1 = {}; /*3715*/
		$1.options = $k[--$j]; /*3717*/
		$1.barcode = $k[--$j]; /*3718*/
		$1.dontdraw = false; /*3720*/
		$1.includetext = false; /*3721*/
		$1.textfont = "Courier"; /*3722*/
		$1.textsize = 10; /*3723*/
		$1.textyoffset = -8.5; /*3724*/
		$1.textxoffset = 0; /*3725*/
		$1.height = 1; /*3726*/
		$1.pzn8 = false; /*3727*/
		$forall($1.options, function() { /*3738*/
			var _3 = $k[--$j]; /*3738*/
			$1[$k[--$j]] = _3; /*3738*/
		}) /*3738*/
		$1.textfont = "" + $1.textfont; /*3740*/
		$1.textsize = +$1.textsize; /*3741*/
		$1.textyoffset = +$1.textyoffset; /*3742*/
		$1.textxoffset = +$1.textxoffset; /*3743*/
		$1.height = +$1.height; /*3744*/
		if ($1.pzn8) { /*3753*/
			if (($1.barcode.length != 7) && ($1.barcode.length != 8)) { /*3750*/
				$k[$j++] = "bwipp.pzn8badLength"; /*3749*/
				$k[$j++] = "PZN8 must be 7 or 8 digits"; /*3749*/
				$0.raiseerror(); /*3749*/
			} /*3749*/
		} else { /*3753*/
			if (($1.barcode.length != 6) && ($1.barcode.length != 7)) { /*3754*/
				$k[$j++] = "bwipp.pzn7badLength"; /*3753*/
				$k[$j++] = "PZN7 must be 6 or 7 digits"; /*3753*/
				$0.raiseerror(); /*3753*/
			} /*3753*/
		} /*3753*/
		$forall($1.barcode, function() { /*3760*/
			var _G = $k[--$j]; /*3757*/
			if ((_G < 48) || (_G > 57)) { /*3759*/
				$k[$j++] = "bwipp.pznBadCharacter"; /*3758*/
				$k[$j++] = "PZN must contain only digits"; /*3758*/
				$0.raiseerror(); /*3758*/
			} /*3758*/
		}) /*3758*/
		var _I = $1.pzn8 ? 9 : 8; /*3763*/
		$1.msglen = _I; /*3763*/
		$1.checksum = 0; /*3764*/
		for (var _L = 0, _K = $1.msglen - 3; _L <= _K; _L += 1) { /*3769*/
			$1.i = _L; /*3766*/
			var _R = $1.pzn8 ? 1 : 2; /*3767*/
			$1.checksum = (($get($1.barcode, $1.i) - 48) * ($1.i + _R)) + $1.checksum; /*3768*/
		} /*3768*/
		$1.checksum = $1.checksum % 11; /*3770*/
		if ($1.checksum == 10) { /*3773*/
			$k[$j++] = "bwipp.pznBadInputSequence"; /*3772*/
			$k[$j++] = "Incorrect PZN input sequence provided"; /*3772*/
			$0.raiseerror(); /*3772*/
		} /*3772*/
		if ($1.barcode.length == ($1.msglen - 1)) { /*3778*/
			if ($get($1.barcode, $1.msglen - 2) != ($1.checksum + 48)) { /*3777*/
				$k[$j++] = "bwipp.pznBadCheckDigit"; /*3776*/
				$k[$j++] = "Incorrect PZN check digit provided"; /*3776*/
				$0.raiseerror(); /*3776*/
			} /*3776*/
		} /*3776*/
		var _c = $s($1.msglen); /*3779*/
		$put(_c, 0, 45); /*3780*/
		$puti(_c, 1, $1.barcode); /*3781*/
		$put(_c, $1.msglen - 1, $1.checksum + 48); /*3782*/
		$1.msg = _c; /*3783*/
		$1.options.dontdraw = true; /*3786*/
		$k[$j++] = "args"; /*3787*/
		$k[$j++] = $1.msg; /*3787*/
		$k[$j++] = $1.options; /*3787*/
		$0.code39(); /*3787*/
		var _j = $k[--$j]; /*3787*/
		$1[$k[--$j]] = _j; /*3787*/
		$1.text = $s($1.msglen + 5); /*3790*/
		$puti($1.text, 0, "PZN - "); /*3791*/
		$puti($1.text, 6, $geti($1.msg, 1, $1.msglen - 1)); /*3792*/
		$1.args.txt = $a([$a([$1.text, $1.textxoffset, $1.textyoffset, $1.textfont, $1.textsize])]); /*3794*/
		$1.args.textxalign = "center"; /*3795*/
		$1.args.opt = $1.options; /*3796*/
		$k[$j++] = $1.args; /*3799*/
		if (!$1.dontdraw) { /*3799*/
			$0.renlinear(); /*3799*/
		} /*3799*/
	};
	$0.code93 = function() {
		var $1 = {}; /*3826*/
		$1.options = $k[--$j]; /*3828*/
		$1.barcode = $k[--$j]; /*3829*/
		$1.dontdraw = false; /*3831*/
		$1.includecheck = false; /*3832*/
		$1.includetext = false; /*3833*/
		$1.textfont = "Courier"; /*3834*/
		$1.textsize = 10; /*3835*/
		$1.textyoffset = -8.5; /*3836*/
		$1.height = 1; /*3837*/
		$1.parsefnc = false; /*3838*/
		$forall($1.options, function() { /*3849*/
			var _3 = $k[--$j]; /*3849*/
			$1[$k[--$j]] = _3; /*3849*/
		}) /*3849*/
		$1.textfont = "" + $1.textfont; /*3851*/
		$1.textsize = +$1.textsize; /*3852*/
		$1.textyoffset = +$1.textyoffset; /*3853*/
		$1.height = +$1.height; /*3854*/
		$1.encs = $a(["131112", "111213", "111312", "111411", "121113", "121212", "121311", "111114", "131211", "141111", "211113", "211212", "211311", "221112", "221211", "231111", "112113", "112212", "112311", "122112", "132111", "111123", "111222", "111321", "121122", "131121", "212112", "212211", "211122", "211221", "221121", "222111", "112122", "112221", "122121", "123111", "121131", "311112", "311211", "321111", "112131", "113121", "211131", "121221", "312111", "311121", "122211", "111141", "1111411"]); /*3867*/
		$1.barchars = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%"; /*3870*/
		$1.barlen = $1.barcode.length; /*3872*/
		$1.sft1 = -1; /*3875*/
		$1.sft2 = -2; /*3875*/
		$1.sft3 = -3; /*3875*/
		$1.sft4 = -4; /*3875*/
		var _F = {
			"SFT$": $1.sft1,
			"SFT%": $1.sft2,
			"SFT/": $1.sft3,
			"SFT+": $1.sft4
		}; /*3880*/
		$1.fncvals = _F; /*3881*/
		$1.msg = $a($1.barlen); /*3884*/
		$1.i = 0; /*3885*/
		$1.j = 0; /*3885*/
		for (;;) { /*3899*/
			if ($1.i == $1.barlen) { /*3886*/
				break; /*3886*/
			} /*3886*/
			$1.char = $get($1.barcode, $1.i); /*3887*/
			if (($1.parsefnc && ($1.char == 94)) && ($1.i < ($1.barlen - 4))) { /*3895*/
				if ($get($1.barcode, $1.i + 1) != 94) { /*3893*/
					$1.char = $get($1.fncvals, $geti($1.barcode, $1.i + 1, 4)); /*3890*/
					$1.i = $1.i + 4; /*3891*/
				} else { /*3893*/
					$1.i = $1.i + 1; /*3893*/
				} /*3893*/
			} /*3893*/
			$put($1.msg, $1.j, $1.char); /*3896*/
			$1.i = $1.i + 1; /*3897*/
			$1.j = $1.j + 1; /*3898*/
		} /*3898*/
		$1.msg = $geti($1.msg, 0, $1.j); /*3900*/
		$1.msglen = $1.msg.length; /*3901*/
		if ($1.includecheck) { /*3906*/
			$1.sbs = $s(($1.msglen * 6) + 25); /*3904*/
		} else { /*3906*/
			$1.sbs = $s(($1.msglen * 6) + 13); /*3906*/
		} /*3906*/
		$1.txt = $a($1.msglen); /*3908*/
		$puti($1.sbs, 0, $get($1.encs, 47)); /*3911*/
		$1.checksum1 = 0; /*3913*/
		$1.checksum2 = 0; /*3913*/
		for (var _w = 0, _v = $1.msglen - 1; _w <= _v; _w += 1) { /*3932*/
			$1.i = _w; /*3915*/
			var _z = $get($1.msg, $1.i); /*3917*/
			$k[$j++] = _z; /*3926*/
			if (_z < 0) { /*3925*/
				$1.indx = 42 - $k[--$j]; /*3918*/
				$1.char = " "; /*3919*/
			} else { /*3925*/
				var _11 = $s(1); /*3921*/
				$put(_11, 0, $k[--$j]); /*3921*/
				$1.char = _11; /*3921*/
				$search($1.barchars, $1.char); /*3922*/
				$j--; /*3923*/
				$1.indx = $k[--$j].length; /*3924*/
				$j -= 2; /*3925*/
			} /*3925*/
			$1.enc = $get($1.encs, $1.indx); /*3927*/
			$puti($1.sbs, ($1.i * 6) + 6, $1.enc); /*3928*/
			$put($1.txt, $1.i, $a([$1.char, ($1.i * 9) + 9, $1.textyoffset, $1.textfont, $1.textsize])); /*3929*/
			$1.checksum1 = $1.checksum1 + ((((($1.msglen - $1.i) - 1) % 20) + 1) * $1.indx); /*3930*/
			$1.checksum2 = $1.checksum2 + (((($1.msglen - $1.i) % 15) + 1) * $1.indx); /*3931*/
		} /*3931*/
		if ($1.includecheck) { /*3944*/
			$1.checksum1 = $1.checksum1 % 47; /*3936*/
			$1.checksum2 = ($1.checksum2 + $1.checksum1) % 47; /*3937*/
			$puti($1.sbs, ($1.msglen * 6) + 6, $get($1.encs, $1.checksum1)); /*3938*/
			$puti($1.sbs, ($1.msglen * 6) + 12, $get($1.encs, $1.checksum2)); /*3939*/
			$puti($1.sbs, ($1.msglen * 6) + 18, $get($1.encs, 48)); /*3941*/
		} else { /*3944*/
			$puti($1.sbs, ($1.msglen * 6) + 6, $get($1.encs, 48)); /*3944*/
		} /*3944*/
		$k[$j++] = Infinity; /*3956*/
		$k[$j++] = "ren"; /*3950*/
		$k[$j++] = $0.renlinear; /*3950*/
		$k[$j++] = "sbs"; /*3950*/
		$k[$j++] = Infinity; /*3950*/
		var _1o = $1.sbs; /*3950*/
		for (var _1p = 0, _1q = _1o.length; _1p < _1q; _1p++) { /*3950*/
			$k[$j++] = $get(_1o, _1p) - 48; /*3950*/
		} /*3950*/
		var _1s = $a(); /*3950*/
		$k[$j++] = _1s; /*3951*/
		$k[$j++] = "bhs"; /*3951*/
		$k[$j++] = Infinity; /*3951*/
		for (var _1u = 0, _1v = ~~(($1.sbs.length + 1) / 2); _1u < _1v; _1u++) { /*3951*/
			$k[$j++] = $1.height; /*3951*/
		} /*3951*/
		var _1x = $a(); /*3951*/
		$k[$j++] = _1x; /*3952*/
		$k[$j++] = "bbs"; /*3952*/
		$k[$j++] = Infinity; /*3952*/
		for (var _1z = 0, _20 = ~~(($1.sbs.length + 1) / 2); _1z < _20; _1z++) { /*3952*/
			$k[$j++] = 0; /*3952*/
		} /*3952*/
		var _21 = $a(); /*3952*/
		$k[$j++] = _21; /*3955*/
		if ($1.includetext) { /*3955*/
			$k[$j++] = "txt"; /*3954*/
			$k[$j++] = $1.txt; /*3954*/
		} /*3954*/
		$k[$j++] = "opt"; /*3956*/
		$k[$j++] = $1.options; /*3956*/
		var _25 = $d(); /*3956*/
		$k[$j++] = _25; /*3959*/
		if (!$1.dontdraw) { /*3959*/
			$0.renlinear(); /*3959*/
		} /*3959*/
	};
	$0.code93ext = function() {
		var $1 = {}; /*3987*/
		$1.options = $k[--$j]; /*3989*/
		$1.barcode = $k[--$j]; /*3990*/
		$1.dontdraw = false; /*3992*/
		$1.includetext = false; /*3993*/
		$1.parse = false; /*3994*/
		$forall($1.options, function() { /*4005*/
			var _3 = $k[--$j]; /*4005*/
			$1[$k[--$j]] = _3; /*4005*/
		}) /*4005*/
		$1.barlen = $1.barcode.length; /*4028*/
		$1.extencs = $a(["^SFT%U", "^SFT$A", "^SFT$B", "^SFT$C", "^SFT$D", "^SFT$E", "^SFT$F", "^SFT$G", "^SFT$H", "^SFT$I", "^SFT$J", "^SFT$K", "^SFT$L", "^SFT$M", "^SFT$N", "^SFT$O", "^SFT$P", "^SFT$Q", "^SFT$R", "^SFT$S", "^SFT$T", "^SFT$U", "^SFT$V", "^SFT$W", "^SFT$X", "^SFT$Y", "^SFT$Z", "^SFT%A", "^SFT%B", "^SFT%C", "^SFT%D", "^SFT%E", " ", "^SFT/A", "^SFT/B", "^SFT/C", "^SFT/D", "^SFT/E", "^SFT/F", "^SFT/G", "^SFT/H", "^SFT/I", "^SFT/J", "^SFT/K", "^SFT/L", "-", ".", "^SFT/O", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "^SFT/Z", "^SFT%F", "^SFT%G", "^SFT%H", "^SFT%I", "^SFT%J", "^SFT%V", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "^SFT%K", "^SFT%L", "^SFT%M", "^SFT%N", "^SFT%O", "^SFT%W", "^SFT+A", "^SFT+B", "^SFT+C", "^SFT+D", "^SFT+E", "^SFT+F", "^SFT+G", "^SFT+H", "^SFT+I", "^SFT+J", "^SFT+K", "^SFT+L", "^SFT+M", "^SFT+N", "^SFT+O", "^SFT+P", "^SFT+Q", "^SFT+R", "^SFT+S", "^SFT+T", "^SFT+U", "^SFT+V", "^SFT+W", "^SFT+X", "^SFT+Y", "^SFT+Z", "^SFT%P", "^SFT%Q", "^SFT%R", "^SFT%S", "^SFT%T"]); /*4048*/
		$1.newcode = $s($1.barlen * 6); /*4050*/
		$1.newtext = $s($1.barlen * 6); /*4051*/
		$1.j = 0; /*4052*/
		$1.k = 0; /*4052*/
		for (var _D = 0, _C = $1.barlen - 1; _D <= _C; _D += 1) { /*4062*/
			$1.i = _D; /*4054*/
			$1.extchar = $get($1.extencs, $get($1.barcode, $1.i)); /*4055*/
			$1.extlen = $1.extchar.length; /*4056*/
			$puti($1.newcode, $1.j, $1.extchar); /*4057*/
			$put($1.newtext, $1.k, $get($1.barcode, $1.i)); /*4058*/
			if ($1.extlen != 1) { /*4059*/
				$puti($1.newtext, $1.k + 1, " "); /*4059*/
			} /*4059*/
			$1.j = $1.j + $1.extlen; /*4060*/
			var _Z = ($1.extlen == 1) ? 1 : 2; /*4061*/
			$1.k = $1.k + _Z; /*4061*/
		} /*4061*/
		$1.newcode = $geti($1.newcode, 0, $1.j); /*4063*/
		$1.newtext = $geti($1.newtext, 0, $1.k); /*4064*/
		$1.options.dontdraw = true; /*4067*/
		$1.options.parsefnc = true; /*4068*/
		$k[$j++] = "args"; /*4069*/
		$k[$j++] = $1.newcode; /*4069*/
		$k[$j++] = $1.options; /*4069*/
		$0.code93(); /*4069*/
		var _k = $k[--$j]; /*4069*/
		$1[$k[--$j]] = _k; /*4069*/
		if ($1.includetext) { /*4081*/
			$1.txt = $1.args.txt; /*4073*/
			for (var _r = 0, _q = $1.newtext.length - 1; _r <= _q; _r += 1) { /*4079*/
				$1.i = _r; /*4075*/
				$1.txtentry = $get($1.txt, $1.i); /*4076*/
				$put($1.txtentry, 0, $geti($1.newtext, $1.i, 1)); /*4077*/
				$put($1.txt, $1.i, $1.txtentry); /*4078*/
			} /*4078*/
			$1.args.txt = $1.txt; /*4080*/
		} /*4080*/
		$1.args.opt = $1.options; /*4082*/
		$k[$j++] = $1.args; /*4085*/
		if (!$1.dontdraw) { /*4085*/
			$0.renlinear(); /*4085*/
		} /*4085*/
	};
	$0.interleaved2of5 = function() {
		var $1 = {}; /*4112*/
		$1.options = $k[--$j]; /*4114*/
		$1.barcode = $k[--$j]; /*4115*/
		$1.dontdraw = false; /*4117*/
		$1.includecheck = false; /*4118*/
		$1.includetext = false; /*4119*/
		$1.includecheckintext = false; /*4120*/
		$1.textfont = "Courier"; /*4121*/
		$1.textsize = 10; /*4122*/
		$1.textyoffset = -8.5; /*4123*/
		$1.height = 1; /*4124*/
		$forall($1.options, function() { /*4135*/
			var _3 = $k[--$j]; /*4135*/
			$1[$k[--$j]] = _3; /*4135*/
		}) /*4135*/
		$1.textfont = "" + $1.textfont; /*4137*/
		$1.textsize = +$1.textsize; /*4138*/
		$1.textyoffset = +$1.textyoffset; /*4139*/
		$1.height = +$1.height; /*4140*/
		$forall($1.barcode, function() { /*4147*/
			var _A = $k[--$j]; /*4144*/
			if ((_A < 48) || (_A > 57)) { /*4146*/
				$k[$j++] = "bwipp.interleaved2of5badCharacter"; /*4145*/
				$k[$j++] = "Interleaved 2 of 5 must contain only digits"; /*4145*/
				$0.raiseerror(); /*4145*/
			} /*4145*/
		}) /*4145*/
		$1.barlen = $1.barcode.length; /*4149*/
		if (((($1.barlen % 2) == 0) && $1.includecheck) || ((($1.barlen % 2) != 0) && (!$1.includecheck))) { /*4160*/
			$1.pad = $s($1.barlen + 1); /*4155*/
			$put($1.pad, 0, 48); /*4156*/
			$puti($1.pad, 1, $1.barcode); /*4157*/
			$1.barcode = $1.pad; /*4158*/
			$1.barlen = $1.barlen + 1; /*4159*/
		} /*4159*/
		if ($1.includecheck) { /*4179*/
			$1.checksum = 0; /*4164*/
			for (var _Q = 0, _P = $1.barlen - 1; _Q <= _P; _Q += 1) { /*4172*/
				$1.i = _Q; /*4166*/
				if (($1.i % 2) == 0) { /*4170*/
					$1.checksum = $1.checksum + (($get($1.barcode, $1.i) - 48) * 3); /*4168*/
				} else { /*4170*/
					$1.checksum = $1.checksum + ($get($1.barcode, $1.i) - 48); /*4170*/
				} /*4170*/
			} /*4170*/
			$1.checksum = (10 - ($1.checksum % 10)) % 10; /*4173*/
			$1.pad = $s($1.barlen + 1); /*4174*/
			$puti($1.pad, 0, $1.barcode); /*4175*/
			$put($1.pad, $1.barlen, $1.checksum + 48); /*4176*/
			$1.barcode = $1.pad; /*4177*/
			$1.barlen = $1.barlen + 1; /*4178*/
		} /*4178*/
		$1.encs = $a(["11221", "21112", "12112", "22111", "11212", "21211", "12211", "11122", "21121", "12121", "1111", "2111"]); /*4186*/
		$1.barchars = "0123456789"; /*4189*/
		$1.sbs = $s(($1.barlen * 5) + 8); /*4190*/
		$1.txt = $a($1.barlen); /*4191*/
		$puti($1.sbs, 0, $get($1.encs, 10)); /*4194*/
		for (var _u = 0, _t = $1.barlen - 1; _u <= _t; _u += 2) { /*4228*/
			$1.i = _u; /*4197*/
			$search($1.barchars, $geti($1.barcode, $1.i, 1)); /*4199*/
			$j--; /*4200*/
			$1.indx = $k[--$j].length; /*4201*/
			$j -= 2; /*4202*/
			$1.enca = $get($1.encs, $1.indx); /*4203*/
			$search($1.barchars, $geti($1.barcode, $1.i + 1, 1)); /*4205*/
			$j--; /*4206*/
			$1.indx = $k[--$j].length; /*4207*/
			$j -= 2; /*4208*/
			$1.encb = $get($1.encs, $1.indx); /*4209*/
			$1.intl = $s($1.enca.length * 2); /*4212*/
			for (var _1F = 0, _1E = $1.enca.length - 1; _1F <= _1E; _1F += 1) { /*4219*/
				$1.j = _1F; /*4214*/
				$1.achar = $get($1.enca, $1.j); /*4215*/
				$1.bchar = $get($1.encb, $1.j); /*4216*/
				$put($1.intl, $1.j * 2, $1.achar); /*4217*/
				$put($1.intl, ($1.j * 2) + 1, $1.bchar); /*4218*/
			} /*4218*/
			$puti($1.sbs, ($1.i * 5) + 4, $1.intl); /*4221*/
			$put($1.txt, $1.i, $a([$geti($1.barcode, $1.i, 1), ($1.i * 9) + 4, $1.textyoffset, $1.textfont, $1.textsize])); /*4222*/
			if (($1.includecheck && (!$1.includecheckintext)) && (($1.barlen - 2) == $1.i)) { /*4226*/
				$put($1.txt, $1.i + 1, $a([" ", (($1.i + 1) * 9) + 4, $1.textyoffset, $1.textfont, $1.textsize])); /*4224*/
			} else { /*4226*/
				$put($1.txt, $1.i + 1, $a([$geti($1.barcode, $1.i + 1, 1), (($1.i + 1) * 9) + 4, $1.textyoffset, $1.textfont, $1.textsize])); /*4226*/
			} /*4226*/
		} /*4226*/
		$puti($1.sbs, ($1.barlen * 5) + 4, $get($1.encs, 11)); /*4231*/
		$k[$j++] = Infinity; /*4244*/
		$k[$j++] = "ren"; /*4236*/
		$k[$j++] = $0.renlinear; /*4236*/
		$k[$j++] = "sbs"; /*4236*/
		$k[$j++] = Infinity; /*4236*/
		var _24 = $1.sbs; /*4236*/
		for (var _25 = 0, _26 = _24.length; _25 < _26; _25++) { /*4236*/
			$k[$j++] = $get(_24, _25) - 48; /*4236*/
		} /*4236*/
		var _28 = $a(); /*4236*/
		$k[$j++] = _28; /*4237*/
		$k[$j++] = "bhs"; /*4237*/
		$k[$j++] = Infinity; /*4237*/
		for (var _2A = 0, _2B = ~~(($1.sbs.length + 1) / 2); _2A < _2B; _2A++) { /*4237*/
			$k[$j++] = $1.height; /*4237*/
		} /*4237*/
		var _2D = $a(); /*4237*/
		$k[$j++] = _2D; /*4238*/
		$k[$j++] = "bbs"; /*4238*/
		$k[$j++] = Infinity; /*4238*/
		for (var _2F = 0, _2G = ~~(($1.sbs.length + 1) / 2); _2F < _2G; _2F++) { /*4238*/
			$k[$j++] = 0; /*4238*/
		} /*4238*/
		var _2H = $a(); /*4238*/
		$k[$j++] = _2H; /*4241*/
		if ($1.includetext) { /*4241*/
			$k[$j++] = "txt"; /*4240*/
			$k[$j++] = $1.txt; /*4240*/
		} /*4240*/
		$k[$j++] = "barratio"; /*4244*/
		$k[$j++] = 2; /*4244*/
		$k[$j++] = "spaceratio"; /*4244*/
		$k[$j++] = 2; /*4244*/
		$k[$j++] = "opt"; /*4244*/
		$k[$j++] = $1.options; /*4244*/
		var _2L = $d(); /*4244*/
		$k[$j++] = _2L; /*4247*/
		if (!$1.dontdraw) { /*4247*/
			$0.renlinear(); /*4247*/
		} /*4247*/
	};
	$0.itf14 = function() {
		var $1 = {}; /*4275*/
		$1.options = $k[--$j]; /*4277*/
		$1.barcode = $k[--$j]; /*4278*/
		$1.dontdraw = false; /*4280*/
		$1.includetext = false; /*4281*/
		$1.includecheckintext = true; /*4282*/
		$1.textfont = "Courier"; /*4283*/
		$1.textsize = 10; /*4284*/
		$1.textxoffset = 0; /*4285*/
		$1.textyoffset = 3; /*4286*/
		$1.height = 0.5; /*4287*/
		$1.showborder = true; /*4288*/
		$1.borderwidth = 4; /*4289*/
		$1.borderleft = 15; /*4290*/
		$1.borderright = 15; /*4291*/
		$forall($1.options, function() { /*4302*/
			var _3 = $k[--$j]; /*4302*/
			$1[$k[--$j]] = _3; /*4302*/
		}) /*4302*/
		$1.textfont = "" + $1.textfont; /*4304*/
		$1.textsize = +$1.textsize; /*4305*/
		$1.textxoffset = +$1.textxoffset; /*4306*/
		$1.textyoffset = +$1.textyoffset; /*4307*/
		$1.height = +$1.height; /*4308*/
		$1.borderwidth = +$1.borderwidth; /*4309*/
		$1.borderleft = +$1.borderleft; /*4310*/
		$1.borderright = +$1.borderright; /*4311*/
		$1.text = $1.barcode; /*4314*/
		var _E = $1.barcode; /*4315*/
		$k[$j++] = $s(_E.length); /*4316*/
		$k[$j++] = 0; /*4316*/
		$forall(_E, function() { /*4316*/
			var _G = $k[--$j]; /*4316*/
			$k[$j++] = _G; /*4316*/
			if (_G != 32) { /*4316*/
				var _H = $k[--$j]; /*4316*/
				var _I = $k[--$j]; /*4316*/
				var _J = $k[--$j]; /*4316*/
				$put(_J, _I, _H); /*4316*/
				$k[$j++] = _J; /*4316*/
				$k[$j++] = _I + 1; /*4316*/
			} else { /*4316*/
				$j--; /*4316*/
			} /*4316*/
		}) /*4316*/
		var _K = $k[--$j]; /*4317*/
		$1.barcode = $geti($k[--$j], 0, _K); /*4317*/
		$1.hasspace = $1.text.length != $1.barcode.length; /*4318*/
		if (($1.barcode.length != 13) && ($1.barcode.length != 14)) { /*4323*/
			$k[$j++] = "bwipp.itf14badLength"; /*4322*/
			$k[$j++] = "ITF-14 must be 13 or 14 digits"; /*4322*/
			$0.raiseerror(); /*4322*/
		} /*4322*/
		$forall($1.barcode, function() { /*4328*/
			var _S = $k[--$j]; /*4325*/
			if ((_S < 48) || (_S > 57)) { /*4327*/
				$k[$j++] = "bwipp.itf14badCharacter"; /*4326*/
				$k[$j++] = "ITF-14 must contain only digits"; /*4326*/
				$0.raiseerror(); /*4326*/
			} /*4326*/
		}) /*4326*/
		$1.checksum = 0; /*4331*/
		for (var _T = 0; _T <= 12; _T += 1) { /*4335*/
			$1.i = _T; /*4333*/
			$k[$j++] = "checksum"; /*4334*/
			$k[$j++] = $1.checksum; /*4334*/
			$k[$j++] = $get($1.barcode, $1.i) - 48; /*4334*/
			if (($1.i % 2) == 0) { /*4334*/
				var _Z = $k[--$j]; /*4334*/
				$k[$j++] = _Z * 3; /*4334*/
			} /*4334*/
			var _a = $k[--$j]; /*4334*/
			var _b = $k[--$j]; /*4334*/
			$1[$k[--$j]] = _b + _a; /*4334*/
		} /*4334*/
		$1.checksum = (10 - ($1.checksum % 10)) % 10; /*4336*/
		if ($1.barcode.length == 14) { /*4350*/
			if ($get($1.barcode, 13) != ($1.checksum + 48)) { /*4340*/
				$k[$j++] = "bwipp.itf14badCheckDigit"; /*4339*/
				$k[$j++] = "Incorrect ITF-14 check digit provided"; /*4339*/
				$0.raiseerror(); /*4339*/
			} /*4339*/
		} else { /*4350*/
			var _i = $s(14); /*4342*/
			$puti(_i, 0, $1.barcode); /*4343*/
			$put(_i, 13, $1.checksum + 48); /*4344*/
			$1.barcode = _i; /*4345*/
			var _n = $1.hasspace ? 2 : 1; /*4346*/
			var _o = $s($1.text.length + _n); /*4346*/
			$puti(_o, _o.length - 2, " "); /*4347*/
			$put(_o, _o.length - 1, $1.checksum + 48); /*4348*/
			$puti(_o, 0, $1.text); /*4349*/
			$1.text = _o; /*4350*/
		} /*4350*/
		$1.options.dontdraw = true; /*4354*/
		$1.options.showborder = $1.showborder; /*4355*/
		$1.options.borderwidth = $1.borderwidth; /*4356*/
		$1.options.borderleft = $1.borderleft; /*4357*/
		$1.options.borderright = $1.borderright; /*4358*/
		$1.options.height = $1.height; /*4359*/
		$1.options.textyoffset = $1.textyoffset; /*4360*/
		$k[$j++] = "args"; /*4361*/
		$k[$j++] = $1.barcode; /*4361*/
		$k[$j++] = $1.options; /*4361*/
		$0.interleaved2of5(); /*4361*/
		var _16 = $k[--$j]; /*4361*/
		$1[$k[--$j]] = _16; /*4361*/
		$1.args.txt = $a([$a([$1.text, $1.textxoffset, $1.textyoffset, $1.textfont, $1.textsize])]); /*4363*/
		$1.args.textxalign = "center"; /*4364*/
		$1.args.opt = $1.options; /*4365*/
		$k[$j++] = $1.args; /*4368*/
		if (!$1.dontdraw) { /*4368*/
			$0.renlinear(); /*4368*/
		} /*4368*/
	};
	$0.identcode = function() {
		var $1 = {}; /*4396*/
		$1.options = $k[--$j]; /*4398*/
		$1.barcode = $k[--$j]; /*4399*/
		$1.dontdraw = false; /*4401*/
		$1.includetext = false; /*4402*/
		$1.textfont = "Courier"; /*4403*/
		$1.textsize = 10; /*4404*/
		$1.textxoffset = 0; /*4405*/
		$1.textyoffset = -8.5; /*4406*/
		$1.height = 1; /*4407*/
		$forall($1.options, function() { /*4418*/
			var _3 = $k[--$j]; /*4418*/
			$1[$k[--$j]] = _3; /*4418*/
		}) /*4418*/
		$1.textfont = "" + $1.textfont; /*4420*/
		$1.textsize = +$1.textsize; /*4421*/
		$1.textxoffset = +$1.textxoffset; /*4422*/
		$1.textyoffset = +$1.textyoffset; /*4423*/
		$1.height = +$1.height; /*4424*/
		if (($1.barcode.length != 11) && ($1.barcode.length != 12)) { /*4429*/
			$k[$j++] = "bwipp.identcodeBadLength"; /*4428*/
			$k[$j++] = "Deutsche Post Identcode must be 11 or 12 digits"; /*4428*/
			$0.raiseerror(); /*4428*/
		} /*4428*/
		$forall($1.barcode, function() { /*4434*/
			var _D = $k[--$j]; /*4431*/
			if ((_D < 48) || (_D > 57)) { /*4433*/
				$k[$j++] = "bwipp.identcodeBadCharacter"; /*4432*/
				$k[$j++] = "Deutsche Post Identcode must contain only digits"; /*4432*/
				$0.raiseerror(); /*4432*/
			} /*4432*/
		}) /*4432*/
		$1.checksum = 0; /*4437*/
		for (var _E = 0; _E <= 10; _E += 1) { /*4441*/
			$1.i = _E; /*4439*/
			$k[$j++] = "checksum"; /*4440*/
			$k[$j++] = $1.checksum; /*4440*/
			$k[$j++] = $get($1.barcode, $1.i) - 48; /*4440*/
			if (($1.i % 2) == 0) { /*4440*/
				var _K = $k[--$j]; /*4440*/
				$k[$j++] = _K * 4; /*4440*/
			} else { /*4440*/
				var _L = $k[--$j]; /*4440*/
				$k[$j++] = _L * 9; /*4440*/
			} /*4440*/
			var _M = $k[--$j]; /*4440*/
			var _N = $k[--$j]; /*4440*/
			$1[$k[--$j]] = _N + _M; /*4440*/
		} /*4440*/
		$1.checksum = (10 - ($1.checksum % 10)) % 10; /*4442*/
		if ($1.barcode.length == 12) { /*4447*/
			if ($get($1.barcode, 11) != ($1.checksum + 48)) { /*4446*/
				$k[$j++] = "bwipp.identcodeBadCheckDigit"; /*4445*/
				$k[$j++] = "Incorrect Deutsche Post Identcode check digit provided"; /*4445*/
				$0.raiseerror(); /*4445*/
			} /*4445*/
		} /*4445*/
		var _U = $s(12); /*4448*/
		$puti(_U, 0, $1.barcode); /*4449*/
		$put(_U, 11, $1.checksum + 48); /*4450*/
		$1.barcode = _U; /*4451*/
		$1.text = $strcpy($s(16), "  .       .     "); /*4454*/
		$puti($1.text, 0, $geti($1.barcode, 0, 2)); /*4455*/
		$puti($1.text, 3, $geti($1.barcode, 2, 3)); /*4456*/
		$puti($1.text, 7, $geti($1.barcode, 5, 3)); /*4457*/
		$puti($1.text, 11, $geti($1.barcode, 8, 3)); /*4458*/
		$puti($1.text, 15, $geti($1.barcode, 11, 1)); /*4459*/
		$1.options.dontdraw = true; /*4462*/
		$1.options.includecheck = false; /*4463*/
		$k[$j++] = "args"; /*4464*/
		$k[$j++] = $1.barcode; /*4464*/
		$k[$j++] = $1.options; /*4464*/
		$0.interleaved2of5(); /*4464*/
		var _s = $k[--$j]; /*4464*/
		$1[$k[--$j]] = _s; /*4464*/
		$1.args.txt = $a([$a([$1.text, $1.textxoffset, $1.textyoffset, $1.textfont, $1.textsize])]); /*4466*/
		$1.args.textxalign = "center"; /*4467*/
		$1.args.opt = $1.options; /*4468*/
		$k[$j++] = $1.args; /*4471*/
		if (!$1.dontdraw) { /*4471*/
			$0.renlinear(); /*4471*/
		} /*4471*/
	};
	$0.leitcode = function() {
		var $1 = {}; /*4499*/
		$1.options = $k[--$j]; /*4501*/
		$1.barcode = $k[--$j]; /*4502*/
		$1.dontdraw = false; /*4504*/
		$1.includetext = false; /*4505*/
		$1.textfont = "Courier"; /*4506*/
		$1.textsize = 10; /*4507*/
		$1.textxoffset = 0; /*4508*/
		$1.textyoffset = -8.5; /*4509*/
		$1.height = 1; /*4510*/
		$forall($1.options, function() { /*4521*/
			var _3 = $k[--$j]; /*4521*/
			$1[$k[--$j]] = _3; /*4521*/
		}) /*4521*/
		$1.textfont = "" + $1.textfont; /*4523*/
		$1.textsize = +$1.textsize; /*4524*/
		$1.textxoffset = +$1.textxoffset; /*4525*/
		$1.textyoffset = +$1.textyoffset; /*4526*/
		$1.height = +$1.height; /*4527*/
		if (($1.barcode.length != 13) && ($1.barcode.length != 14)) { /*4532*/
			$k[$j++] = "bwipp.leitcodeBadLength"; /*4531*/
			$k[$j++] = "Deutsche Post Leitcode must be 13 or 14 digits"; /*4531*/
			$0.raiseerror(); /*4531*/
		} /*4531*/
		$forall($1.barcode, function() { /*4537*/
			var _D = $k[--$j]; /*4534*/
			if ((_D < 48) || (_D > 57)) { /*4536*/
				$k[$j++] = "bwipp.leitcodeBadCharacter"; /*4535*/
				$k[$j++] = "Deutsche Post Leitcode must contain only digits"; /*4535*/
				$0.raiseerror(); /*4535*/
			} /*4535*/
		}) /*4535*/
		$1.checksum = 0; /*4540*/
		for (var _E = 0; _E <= 12; _E += 1) { /*4544*/
			$1.i = _E; /*4542*/
			$k[$j++] = "checksum"; /*4543*/
			$k[$j++] = $1.checksum; /*4543*/
			$k[$j++] = $get($1.barcode, $1.i) - 48; /*4543*/
			if (($1.i % 2) == 0) { /*4543*/
				var _K = $k[--$j]; /*4543*/
				$k[$j++] = _K * 4; /*4543*/
			} else { /*4543*/
				var _L = $k[--$j]; /*4543*/
				$k[$j++] = _L * 9; /*4543*/
			} /*4543*/
			var _M = $k[--$j]; /*4543*/
			var _N = $k[--$j]; /*4543*/
			$1[$k[--$j]] = _N + _M; /*4543*/
		} /*4543*/
		$1.checksum = (10 - ($1.checksum % 10)) % 10; /*4545*/
		if ($1.barcode.length == 14) { /*4550*/
			if ($get($1.barcode, 13) != ($1.checksum + 48)) { /*4549*/
				$k[$j++] = "bwipp.leitcodeBadCheckDigit"; /*4548*/
				$k[$j++] = "Incorrect Deutsche Post Leitcode check digit provided"; /*4548*/
				$0.raiseerror(); /*4548*/
			} /*4548*/
		} /*4548*/
		var _U = $s(14); /*4551*/
		$puti(_U, 0, $1.barcode); /*4552*/
		$put(_U, 13, $1.checksum + 48); /*4553*/
		$1.barcode = _U; /*4554*/
		$1.text = $strcpy($s(18), "     .   .   .    "); /*4557*/
		$puti($1.text, 0, $geti($1.barcode, 0, 5)); /*4558*/
		$puti($1.text, 6, $geti($1.barcode, 5, 3)); /*4559*/
		$puti($1.text, 10, $geti($1.barcode, 8, 3)); /*4560*/
		$puti($1.text, 14, $geti($1.barcode, 11, 2)); /*4561*/
		$puti($1.text, 17, $geti($1.barcode, 13, 1)); /*4562*/
		$1.options.dontdraw = true; /*4565*/
		$1.options.includecheck = false; /*4566*/
		$k[$j++] = "args"; /*4567*/
		$k[$j++] = $1.barcode; /*4567*/
		$k[$j++] = $1.options; /*4567*/
		$0.interleaved2of5(); /*4567*/
		var _s = $k[--$j]; /*4567*/
		$1[$k[--$j]] = _s; /*4567*/
		$1.args.txt = $a([$a([$1.text, $1.textxoffset, $1.textyoffset, $1.textfont, $1.textsize])]); /*4569*/
		$1.args.textxalign = "center"; /*4570*/
		$1.args.opt = $1.options; /*4571*/
		$k[$j++] = $1.args; /*4574*/
		if (!$1.dontdraw) { /*4574*/
			$0.renlinear(); /*4574*/
		} /*4574*/
	};
	$0.databaromni = function() {
		var $1 = {}; /*4602*/
		$1.options = $k[--$j]; /*4604*/
		$1.barcode = $k[--$j]; /*4605*/
		$1.dontdraw = false; /*4607*/
		$1.height = 33 / 72; /*4608*/
		$1.linkage = false; /*4609*/
		$1.format = "omni"; /*4610*/
		$forall($1.options, function() { /*4621*/
			var _3 = $k[--$j]; /*4621*/
			$1[$k[--$j]] = _3; /*4621*/
		}) /*4621*/
		if ($eq($1.format, "truncated")) { /*4623*/
			$1.height = 13 / 72; /*4623*/
		} /*4623*/
		$1.height = +$1.height; /*4624*/
		if ($ne($geti($1.barcode, 0, 4), "(01)")) { /*4629*/
			$k[$j++] = "bwipp.databaromniBadAI"; /*4628*/
			$k[$j++] = "GS1 DataBar Omnidirectional must begin with (01) application identifier"; /*4628*/
			$0.raiseerror(); /*4628*/
		} /*4628*/
		if (($1.barcode.length != 17) && ($1.barcode.length != 18)) { /*4632*/
			$k[$j++] = "bwipp.databaromniBadLength"; /*4631*/
			$k[$j++] = "GS1 DataBar Omnidirectional must be 13 or 14 digits"; /*4631*/
			$0.raiseerror(); /*4631*/
		} /*4631*/
		$forall($geti($1.barcode, 4, $1.barcode.length - 4), function() { /*4637*/
			var _E = $k[--$j]; /*4634*/
			if ((_E < 48) || (_E > 57)) { /*4636*/
				$k[$j++] = "bwipp.databaromniBadCharacter"; /*4635*/
				$k[$j++] = "GS1 DataBar Omnidirectional must contain only digits"; /*4635*/
				$0.raiseerror(); /*4635*/
			} /*4635*/
		}) /*4635*/
		$1.checksum = 0; /*4640*/
		for (var _F = 0; _F <= 12; _F += 1) { /*4644*/
			$1.i = _F; /*4642*/
			$k[$j++] = "checksum"; /*4643*/
			$k[$j++] = $1.checksum; /*4643*/
			$k[$j++] = $get($1.barcode, $1.i + 4) - 48; /*4643*/
			if (($1.i % 2) == 0) { /*4643*/
				var _L = $k[--$j]; /*4643*/
				$k[$j++] = _L * 3; /*4643*/
			} /*4643*/
			var _M = $k[--$j]; /*4643*/
			var _N = $k[--$j]; /*4643*/
			$1[$k[--$j]] = _N + _M; /*4643*/
		} /*4643*/
		$1.checksum = (10 - ($1.checksum % 10)) % 10; /*4645*/
		if ($1.barcode.length == 18) { /*4650*/
			if ($get($1.barcode, 17) != ($1.checksum + 48)) { /*4649*/
				$k[$j++] = "bwipp.databaromniBadCheckDigit"; /*4648*/
				$k[$j++] = "Incorrect GS1 DataBar Omnidirectional check digit provided"; /*4648*/
				$0.raiseerror(); /*4648*/
			} /*4648*/
		} /*4648*/
		var _U = $s(18); /*4651*/
		$puti(_U, 0, $1.barcode); /*4652*/
		$put(_U, 17, $1.checksum + 48); /*4653*/
		$1.barcode = _U; /*4654*/
		$1.txt = $a($1.barcode.length); /*4657*/
		for (var _b = 0, _a = $1.barcode.length - 1; _b <= _a; _b += 1) { /*4661*/
			$1.i = _b; /*4659*/
			$put($1.txt, $1.i, $a([$geti($1.barcode, $1.i, 1), 0, 0, "", 0])); /*4660*/
		} /*4660*/
		$1.ncr = function() {
			var _i = $k[--$j]; /*4664*/
			var _j = $k[--$j]; /*4664*/
			var _k = _j - _i; /*4664*/
			if (_i < (_j - _i)) { /*4664*/
				var _ = _k; /*4664*/
				_k = _i; /*4664*/
				_i = _; /*4664*/
			} /*4664*/
			$k[$j++] = _k; /*4671*/
			$k[$j++] = 1; /*4671*/
			$k[$j++] = 1; /*4671*/
			for (var _m = _j, _l = _i + 1; _m >= _l; _m -= 1) { /*4671*/
				var _n = $k[--$j]; /*4667*/
				var _o = $k[--$j]; /*4668*/
				var _p = $k[--$j]; /*4668*/
				$k[$j++] = _p; /*4670*/
				$k[$j++] = _o; /*4670*/
				$k[$j++] = _n * _m; /*4670*/
				if ($le(_o, _p)) { /*4670*/
					var _q = $k[--$j]; /*4669*/
					var _r = $k[--$j]; /*4669*/
					$k[$j++] = _r + 1; /*4669*/
					$k[$j++] = ~~(_q / _r); /*4669*/
				} /*4669*/
			} /*4669*/
			for (;;) { /*4675*/
				var _s = $k[--$j]; /*4673*/
				var _t = $k[--$j]; /*4673*/
				var _u = $k[--$j]; /*4673*/
				$k[$j++] = _u; /*4673*/
				$k[$j++] = _t; /*4673*/
				$k[$j++] = _s; /*4673*/
				if ($gt(_t, _u)) { /*4673*/
					break; /*4673*/
				} /*4673*/
				var _v = $k[--$j]; /*4674*/
				var _w = $k[--$j]; /*4674*/
				$k[$j++] = _w + 1; /*4674*/
				$k[$j++] = ~~(_v / _w); /*4674*/
			} /*4674*/
			var _x = $k[--$j]; /*4676*/
			var _y = $k[--$j]; /*4676*/
			var _z = $k[--$j]; /*4676*/
			$k[$j++] = _x; /*4676*/
		}; /*4677*/
		$1.getRSSwidths = function() {
			$1.oe = $k[--$j]; /*4680*/
			$1.el = $k[--$j]; /*4681*/
			$1.mw = $k[--$j]; /*4682*/
			$1.nm = $k[--$j]; /*4683*/
			$1.val = $k[--$j]; /*4684*/
			$1.out = $a($1.el); /*4685*/
			$1.mask = 0; /*4686*/
			for (var _19 = 0, _18 = $1.el - 2; _19 <= _18; _19 += 1) { /*4713*/
				$1.bar = _19; /*4688*/
				$1.ew = 1; /*4689*/
				var _1B = $1.bar; /*4690*/
				$1.mask = $1.mask | ((_1B < 0 ? 1 >>> -_1B : 1 << _1B)); /*4690*/
				for (;;) { /*4709*/
					$k[$j++] = "sval"; /*4691*/
					$k[$j++] = ($1.nm - $1.ew) - 1; /*4691*/
					$k[$j++] = ($1.el - $1.bar) - 2; /*4691*/
					$1.ncr(); /*4691*/
					var _1G = $k[--$j]; /*4691*/
					$1[$k[--$j]] = _1G; /*4691*/
					if (($1.oe && ($1.mask == 0)) && (((($1.nm - $1.ew) - ($1.el * 2)) + ($1.bar * 2)) >= -2)) { /*4694*/
						$k[$j++] = "sval"; /*4693*/
						$k[$j++] = $1.sval; /*4693*/
						$k[$j++] = (($1.nm - $1.ew) - $1.el) + $1.bar; /*4693*/
						$k[$j++] = ($1.el - $1.bar) - 2; /*4693*/
						$1.ncr(); /*4693*/
						var _1V = $k[--$j]; /*4693*/
						var _1W = $k[--$j]; /*4693*/
						$1[$k[--$j]] = _1W - _1V; /*4693*/
					} /*4693*/
					if (($1.el - $1.bar) > 2) { /*4703*/
						$1.lval = 0; /*4696*/
						for (var _1g = ((($1.nm - $1.ew) - $1.el) + $1.bar) + 2, _1f = $1.mw + 1; _1g >= _1f; _1g -= 1) { /*4700*/
							$k[$j++] = (($1.nm - _1g) - $1.ew) - 1; /*4698*/
							$k[$j++] = ($1.el - $1.bar) - 3; /*4698*/
							$1.ncr(); /*4698*/
							$1.lval = $k[--$j] + $1.lval; /*4699*/
						} /*4699*/
						$1.sval = $1.sval - ($1.lval * (($1.el - $1.bar) - 1)); /*4701*/
					} else { /*4703*/
						if (($1.nm - $1.ew) > $1.mw) { /*4703*/
							$1.sval = $1.sval - 1; /*4703*/
						} /*4703*/
					} /*4703*/
					$1.val = $1.val - $1.sval; /*4705*/
					if ($1.val < 0) { /*4706*/
						break; /*4706*/
					} /*4706*/
					$1.ew = $1.ew + 1; /*4707*/
					var _20 = $1.bar; /*4708*/
					$1.mask = $1.mask & (~((_20 < 0 ? 1 >>> -_20 : 1 << _20))); /*4708*/
				} /*4708*/
				$1.val = $1.val + $1.sval; /*4710*/
				$1.nm = $1.nm - $1.ew; /*4711*/
				$put($1.out, $1.bar, $1.ew); /*4712*/
			} /*4712*/
			$put($1.out, $1.el - 1, $1.nm); /*4714*/
			$k[$j++] = $1.out; /*4715*/
		}; /*4716*/
		$k[$j++] = "binval"; /*4720*/
		$k[$j++] = Infinity; /*4720*/
		var _2D = $1.linkage ? 1 : 0; /*4719*/
		$k[$j++] = _2D; /*4720*/
		$forall($geti($1.barcode, 4, 13), function() { /*4720*/
			var _2G = $k[--$j]; /*4720*/
			$k[$j++] = _2G - 48; /*4720*/
		}) /*4720*/
		var _2H = $a(); /*4720*/
		$1[$k[--$j]] = _2H; /*4721*/
		for (var _2J = 0; _2J <= 12; _2J += 1) { /*4727*/
			$1.i = _2J; /*4724*/
			var _2K = $1.binval; /*4725*/
			var _2L = $1.i; /*4725*/
			$put(_2K, _2L + 1, $get(_2K, _2L + 1) + (($get($1.binval, $1.i) % 4537077) * 10)); /*4725*/
			$put($1.binval, $1.i, ~~($get($1.binval, $1.i) / 4537077)); /*4726*/
		} /*4726*/
		$1.right = $get($1.binval, 13) % 4537077; /*4728*/
		var _2X = $1.binval; /*4729*/
		$put(_2X, 13, ~~($get(_2X, 13) / 4537077)); /*4729*/
		$1.left = 0; /*4731*/
		$1.i = true; /*4732*/
		for (var _2Z = 0; _2Z <= 13; _2Z += 1) { /*4742*/
			$1.j = _2Z; /*4734*/
			var _2c = $get($1.binval, $1.j); /*4735*/
			$k[$j++] = _2c; /*4741*/
			if ((_2c == 0) && $1.i) { /*4740*/
				$j--; /*4737*/
			} else { /*4740*/
				$1.i = false; /*4739*/
				$1.left = $1.left + ($k[--$j] * (~~Math.pow(10, 13 - $1.j))); /*4740*/
			} /*4740*/
		} /*4740*/
		$1.d1 = ~~($1.left / 1597); /*4744*/
		$1.d2 = $1.left % 1597; /*4745*/
		$1.d3 = ~~($1.right / 1597); /*4746*/
		$1.d4 = $1.right % 1597; /*4747*/
		$1.tab164 = $a([160, 0, 12, 4, 8, 1, 161, 1, 960, 161, 10, 6, 6, 3, 80, 10, 2014, 961, 8, 8, 4, 5, 31, 34, 2714, 2015, 6, 10, 3, 6, 10, 70, 2840, 2715, 4, 12, 1, 8, 1, 126]); /*4755*/
		$1.tab154 = $a([335, 0, 5, 10, 2, 7, 4, 84, 1035, 336, 7, 8, 4, 5, 20, 35, 1515, 1036, 9, 6, 6, 3, 48, 10, 1596, 1516, 11, 4, 8, 1, 81, 1]); /*4762*/
		$1.i = 0; /*4764*/
		for (;;) { /*4774*/
			if ($1.d1 <= $get($1.tab164, $1.i)) { /*4772*/
				$forall($geti($1.tab164, $1.i + 1, 7)); /*4766*/
				$1.d1te = $k[--$j]; /*4767*/
				$1.d1to = $k[--$j]; /*4767*/
				$1.d1mwe = $k[--$j]; /*4768*/
				$1.d1mwo = $k[--$j]; /*4768*/
				$1.d1ele = $k[--$j]; /*4769*/
				$1.d1elo = $k[--$j]; /*4769*/
				$1.d1gs = $k[--$j]; /*4770*/
				break; /*4771*/
			} /*4771*/
			$1.i = $1.i + 8; /*4773*/
		} /*4773*/
		$1.i = 0; /*4776*/
		for (;;) { /*4786*/
			if ($1.d2 <= $get($1.tab154, $1.i)) { /*4784*/
				$forall($geti($1.tab154, $1.i + 1, 7)); /*4778*/
				$1.d2te = $k[--$j]; /*4779*/
				$1.d2to = $k[--$j]; /*4779*/
				$1.d2mwe = $k[--$j]; /*4780*/
				$1.d2mwo = $k[--$j]; /*4780*/
				$1.d2ele = $k[--$j]; /*4781*/
				$1.d2elo = $k[--$j]; /*4781*/
				$1.d2gs = $k[--$j]; /*4782*/
				break; /*4783*/
			} /*4783*/
			$1.i = $1.i + 8; /*4785*/
		} /*4785*/
		$1.i = 0; /*4788*/
		for (;;) { /*4798*/
			if ($1.d3 <= $get($1.tab164, $1.i)) { /*4796*/
				$forall($geti($1.tab164, $1.i + 1, 7)); /*4790*/
				$1.d3te = $k[--$j]; /*4791*/
				$1.d3to = $k[--$j]; /*4791*/
				$1.d3mwe = $k[--$j]; /*4792*/
				$1.d3mwo = $k[--$j]; /*4792*/
				$1.d3ele = $k[--$j]; /*4793*/
				$1.d3elo = $k[--$j]; /*4793*/
				$1.d3gs = $k[--$j]; /*4794*/
				break; /*4795*/
			} /*4795*/
			$1.i = $1.i + 8; /*4797*/
		} /*4797*/
		$1.i = 0; /*4800*/
		for (;;) { /*4810*/
			if ($1.d4 <= $get($1.tab154, $1.i)) { /*4808*/
				$forall($geti($1.tab154, $1.i + 1, 7)); /*4802*/
				$1.d4te = $k[--$j]; /*4803*/
				$1.d4to = $k[--$j]; /*4803*/
				$1.d4mwe = $k[--$j]; /*4804*/
				$1.d4mwo = $k[--$j]; /*4804*/
				$1.d4ele = $k[--$j]; /*4805*/
				$1.d4elo = $k[--$j]; /*4805*/
				$1.d4gs = $k[--$j]; /*4806*/
				break; /*4807*/
			} /*4807*/
			$1.i = $1.i + 8; /*4809*/
		} /*4809*/
		$k[$j++] = "d1wo"; /*4812*/
		$k[$j++] = ~~(($1.d1 - $1.d1gs) / $1.d1te); /*4812*/
		$k[$j++] = $1.d1elo; /*4812*/
		$k[$j++] = $1.d1mwo; /*4812*/
		$k[$j++] = 4; /*4812*/
		$k[$j++] = false; /*4812*/
		$1.getRSSwidths(); /*4812*/
		var _3q = $k[--$j]; /*4812*/
		$1[$k[--$j]] = _3q; /*4812*/
		$k[$j++] = "d1we"; /*4813*/
		$k[$j++] = ($1.d1 - $1.d1gs) % $1.d1te; /*4813*/
		$k[$j++] = $1.d1ele; /*4813*/
		$k[$j++] = $1.d1mwe; /*4813*/
		$k[$j++] = 4; /*4813*/
		$k[$j++] = true; /*4813*/
		$1.getRSSwidths(); /*4813*/
		var _3x = $k[--$j]; /*4813*/
		$1[$k[--$j]] = _3x; /*4813*/
		$k[$j++] = "d2wo"; /*4814*/
		$k[$j++] = ($1.d2 - $1.d2gs) % $1.d2to; /*4814*/
		$k[$j++] = $1.d2elo; /*4814*/
		$k[$j++] = $1.d2mwo; /*4814*/
		$k[$j++] = 4; /*4814*/
		$k[$j++] = true; /*4814*/
		$1.getRSSwidths(); /*4814*/
		var _44 = $k[--$j]; /*4814*/
		$1[$k[--$j]] = _44; /*4814*/
		$k[$j++] = "d2we"; /*4815*/
		$k[$j++] = ~~(($1.d2 - $1.d2gs) / $1.d2to); /*4815*/
		$k[$j++] = $1.d2ele; /*4815*/
		$k[$j++] = $1.d2mwe; /*4815*/
		$k[$j++] = 4; /*4815*/
		$k[$j++] = false; /*4815*/
		$1.getRSSwidths(); /*4815*/
		var _4B = $k[--$j]; /*4815*/
		$1[$k[--$j]] = _4B; /*4815*/
		$k[$j++] = "d3wo"; /*4816*/
		$k[$j++] = ~~(($1.d3 - $1.d3gs) / $1.d3te); /*4816*/
		$k[$j++] = $1.d3elo; /*4816*/
		$k[$j++] = $1.d3mwo; /*4816*/
		$k[$j++] = 4; /*4816*/
		$k[$j++] = false; /*4816*/
		$1.getRSSwidths(); /*4816*/
		var _4I = $k[--$j]; /*4816*/
		$1[$k[--$j]] = _4I; /*4816*/
		$k[$j++] = "d3we"; /*4817*/
		$k[$j++] = ($1.d3 - $1.d3gs) % $1.d3te; /*4817*/
		$k[$j++] = $1.d3ele; /*4817*/
		$k[$j++] = $1.d3mwe; /*4817*/
		$k[$j++] = 4; /*4817*/
		$k[$j++] = true; /*4817*/
		$1.getRSSwidths(); /*4817*/
		var _4P = $k[--$j]; /*4817*/
		$1[$k[--$j]] = _4P; /*4817*/
		$k[$j++] = "d4wo"; /*4818*/
		$k[$j++] = ($1.d4 - $1.d4gs) % $1.d4to; /*4818*/
		$k[$j++] = $1.d4elo; /*4818*/
		$k[$j++] = $1.d4mwo; /*4818*/
		$k[$j++] = 4; /*4818*/
		$k[$j++] = true; /*4818*/
		$1.getRSSwidths(); /*4818*/
		var _4W = $k[--$j]; /*4818*/
		$1[$k[--$j]] = _4W; /*4818*/
		$k[$j++] = "d4we"; /*4819*/
		$k[$j++] = ~~(($1.d4 - $1.d4gs) / $1.d4to); /*4819*/
		$k[$j++] = $1.d4ele; /*4819*/
		$k[$j++] = $1.d4mwe; /*4819*/
		$k[$j++] = 4; /*4819*/
		$k[$j++] = false; /*4819*/
		$1.getRSSwidths(); /*4819*/
		var _4d = $k[--$j]; /*4819*/
		$1[$k[--$j]] = _4d; /*4819*/
		$1.d1w = $a(8); /*4821*/
		for (var _4g = 0; _4g <= 3; _4g += 1) { /*4826*/
			$1.i = _4g; /*4823*/
			$put($1.d1w, $1.i * 2, $get($1.d1wo, $1.i)); /*4824*/
			$put($1.d1w, ($1.i * 2) + 1, $get($1.d1we, $1.i)); /*4825*/
		} /*4825*/
		$1.d2w = $a(8); /*4828*/
		for (var _4s = 0; _4s <= 3; _4s += 1) { /*4833*/
			$1.i = _4s; /*4830*/
			$put($1.d2w, 7 - ($1.i * 2), $get($1.d2wo, $1.i)); /*4831*/
			$put($1.d2w, 6 - ($1.i * 2), $get($1.d2we, $1.i)); /*4832*/
		} /*4832*/
		$1.d3w = $a(8); /*4835*/
		for (var _54 = 0; _54 <= 3; _54 += 1) { /*4840*/
			$1.i = _54; /*4837*/
			$put($1.d3w, 7 - ($1.i * 2), $get($1.d3wo, $1.i)); /*4838*/
			$put($1.d3w, 6 - ($1.i * 2), $get($1.d3we, $1.i)); /*4839*/
		} /*4839*/
		$1.d4w = $a(8); /*4842*/
		for (var _5G = 0; _5G <= 3; _5G += 1) { /*4847*/
			$1.i = _5G; /*4844*/
			$put($1.d4w, $1.i * 2, $get($1.d4wo, $1.i)); /*4845*/
			$put($1.d4w, ($1.i * 2) + 1, $get($1.d4we, $1.i)); /*4846*/
		} /*4846*/
		$k[$j++] = "widths"; /*4853*/
		$k[$j++] = Infinity; /*4853*/
		var _5R = $1.d1w; /*4850*/
		for (var _5S = 0, _5T = _5R.length; _5S < _5T; _5S++) { /*4850*/
			$k[$j++] = $get(_5R, _5S); /*4850*/
		} /*4850*/
		var _5V = $1.d2w; /*4851*/
		for (var _5W = 0, _5X = _5V.length; _5W < _5X; _5W++) { /*4851*/
			$k[$j++] = $get(_5V, _5W); /*4851*/
		} /*4851*/
		var _5Z = $1.d3w; /*4852*/
		for (var _5a = 0, _5b = _5Z.length; _5a < _5b; _5a++) { /*4852*/
			$k[$j++] = $get(_5Z, _5a); /*4852*/
		} /*4852*/
		var _5d = $1.d4w; /*4853*/
		for (var _5e = 0, _5f = _5d.length; _5e < _5f; _5e++) { /*4853*/
			$k[$j++] = $get(_5d, _5e); /*4853*/
		} /*4853*/
		var _5h = $a(); /*4853*/
		$1[$k[--$j]] = _5h; /*4854*/
		$1.checkweights = $a([1, 3, 9, 27, 2, 6, 18, 54, 58, 72, 24, 8, 29, 36, 12, 4, 74, 51, 17, 32, 37, 65, 48, 16, 64, 34, 23, 69, 49, 68, 46, 59]); /*4861*/
		$1.checkwidths = $a([3, 8, 2, 1, 1, 3, 5, 5, 1, 1, 3, 3, 7, 1, 1, 3, 1, 9, 1, 1, 2, 7, 4, 1, 1, 2, 5, 6, 1, 1, 2, 3, 8, 1, 1, 1, 5, 7, 1, 1, 1, 3, 9, 1, 1]); /*4867*/
		$1.checksum = 0; /*4869*/
		for (var _5l = 0; _5l <= 31; _5l += 1) { /*4873*/
			$1.i = _5l; /*4871*/
			$1.checksum = $1.checksum + ($get($1.widths, $1.i) * $get($1.checkweights, $1.i)); /*4872*/
		} /*4872*/
		$1.checksum = $1.checksum % 79; /*4874*/
		if ($1.checksum >= 8) { /*4875*/
			$1.checksum = $1.checksum + 1; /*4875*/
		} /*4875*/
		if ($1.checksum >= 72) { /*4876*/
			$1.checksum = $1.checksum + 1; /*4876*/
		} /*4876*/
		$1.checklt = $geti($1.checkwidths, (~~($1.checksum / 9)) * 5, 5); /*4877*/
		$1.checkrtrev = $geti($1.checkwidths, ($1.checksum % 9) * 5, 5); /*4878*/
		$1.checkrt = $a(5); /*4879*/
		for (var _65 = 0; _65 <= 4; _65 += 1) { /*4883*/
			$1.i = _65; /*4881*/
			$put($1.checkrt, $1.i, $get($1.checkrtrev, 4 - $1.i)); /*4882*/
		} /*4882*/
		if ($eq($1.format, "omni") || $eq($1.format, "truncated")) { /*5002*/
			$k[$j++] = "sbs"; /*4890*/
			$k[$j++] = Infinity; /*4890*/
			var _6D = $1.d1w; /*4889*/
			$k[$j++] = 1; /*4889*/
			for (var _6E = 0, _6F = _6D.length; _6E < _6F; _6E++) { /*4889*/
				$k[$j++] = $get(_6D, _6E); /*4889*/
			} /*4889*/
			$forall($1.checklt); /*4889*/
			var _6I = $1.d2w; /*4889*/
			for (var _6J = 0, _6K = _6I.length; _6J < _6K; _6J++) { /*4889*/
				$k[$j++] = $get(_6I, _6J); /*4889*/
			} /*4889*/
			var _6M = $1.d4w; /*4890*/
			for (var _6N = 0, _6O = _6M.length; _6N < _6O; _6N++) { /*4890*/
				$k[$j++] = $get(_6M, _6N); /*4890*/
			} /*4890*/
			var _6Q = $1.checkrt; /*4890*/
			for (var _6R = 0, _6S = _6Q.length; _6R < _6S; _6R++) { /*4890*/
				$k[$j++] = $get(_6Q, _6R); /*4890*/
			} /*4890*/
			var _6U = $1.d3w; /*4890*/
			for (var _6V = 0, _6W = _6U.length; _6V < _6W; _6V++) { /*4890*/
				$k[$j++] = $get(_6U, _6V); /*4890*/
			} /*4890*/
			$k[$j++] = 1; /*4890*/
			$k[$j++] = 1; /*4890*/
			var _6Y = $a(); /*4890*/
			$1[$k[--$j]] = _6Y; /*4891*/
			$k[$j++] = Infinity; /*4900*/
			$k[$j++] = "ren"; /*4896*/
			$k[$j++] = $0.renlinear; /*4896*/
			$k[$j++] = "sbs"; /*4896*/
			$k[$j++] = $1.sbs; /*4896*/
			$k[$j++] = "bhs"; /*4896*/
			$k[$j++] = Infinity; /*4896*/
			for (var _6c = 0, _6d = ~~(($1.sbs.length + 1) / 2); _6c < _6d; _6c++) { /*4896*/
				$k[$j++] = $1.height; /*4896*/
			} /*4896*/
			var _6f = $a(); /*4896*/
			$k[$j++] = _6f; /*4897*/
			$k[$j++] = "bbs"; /*4897*/
			$k[$j++] = Infinity; /*4897*/
			for (var _6h = 0, _6i = ~~(($1.sbs.length + 1) / 2); _6h < _6i; _6h++) { /*4897*/
				$k[$j++] = 0; /*4897*/
			} /*4897*/
			var _6j = $a(); /*4897*/
			$k[$j++] = _6j; /*4900*/
			$k[$j++] = "txt"; /*4900*/
			$k[$j++] = $1.txt; /*4900*/
			$k[$j++] = "textxalign"; /*4900*/
			$k[$j++] = "center"; /*4900*/
			$k[$j++] = "opt"; /*4900*/
			$k[$j++] = $1.options; /*4900*/
			var _6m = $d(); /*4900*/
			$k[$j++] = _6m; /*4903*/
			if (!$1.dontdraw) { /*4903*/
				$0.renlinear(); /*4903*/
			} /*4903*/
		} else { /*5002*/
			$k[$j++] = "top"; /*4907*/
			$k[$j++] = Infinity; /*4907*/
			var _6o = $1.d1w; /*4907*/
			$k[$j++] = 1; /*4907*/
			$k[$j++] = 1; /*4907*/
			for (var _6p = 0, _6q = _6o.length; _6p < _6q; _6p++) { /*4907*/
				$k[$j++] = $get(_6o, _6p); /*4907*/
			} /*4907*/
			$forall($1.checklt); /*4907*/
			var _6t = $1.d2w; /*4907*/
			for (var _6u = 0, _6v = _6t.length; _6u < _6v; _6u++) { /*4907*/
				$k[$j++] = $get(_6t, _6u); /*4907*/
			} /*4907*/
			$k[$j++] = 1; /*4907*/
			$k[$j++] = 1; /*4907*/
			$k[$j++] = 0; /*4907*/
			var _6x = $a(); /*4907*/
			$1[$k[--$j]] = _6x; /*4907*/
			$k[$j++] = "bot"; /*4908*/
			$k[$j++] = Infinity; /*4908*/
			var _6z = $1.d4w; /*4908*/
			$k[$j++] = 1; /*4908*/
			$k[$j++] = 1; /*4908*/
			for (var _70 = 0, _71 = _6z.length; _70 < _71; _70++) { /*4908*/
				$k[$j++] = $get(_6z, _70); /*4908*/
			} /*4908*/
			var _73 = $1.checkrt; /*4908*/
			for (var _74 = 0, _75 = _73.length; _74 < _75; _74++) { /*4908*/
				$k[$j++] = $get(_73, _74); /*4908*/
			} /*4908*/
			var _77 = $1.d3w; /*4908*/
			for (var _78 = 0, _79 = _77.length; _78 < _79; _78++) { /*4908*/
				$k[$j++] = $get(_77, _78); /*4908*/
			} /*4908*/
			$k[$j++] = 1; /*4908*/
			$k[$j++] = 1; /*4908*/
			$k[$j++] = 0; /*4908*/
			var _7B = $a(); /*4908*/
			$1[$k[--$j]] = _7B; /*4908*/
			for (var _7D = 0; _7D <= 24; _7D += 2) { /*4913*/
				$1.i = _7D; /*4910*/
				for (var _7H = 0, _7I = $get($1.top, $1.i); _7H < _7I; _7H++) { /*4911*/
					$k[$j++] = 0; /*4911*/
				} /*4911*/
				for (var _7M = 0, _7N = $get($1.top, $1.i + 1); _7M < _7N; _7M++) { /*4912*/
					$k[$j++] = 1; /*4912*/
				} /*4912*/
			} /*4912*/
			$astore($a(50)); /*4914*/
			$1.top = $k[--$j]; /*4914*/
			for (var _7Q = 0; _7Q <= 24; _7Q += 2) { /*4919*/
				$1.i = _7Q; /*4916*/
				for (var _7U = 0, _7V = $get($1.bot, $1.i); _7U < _7V; _7U++) { /*4917*/
					$k[$j++] = 1; /*4917*/
				} /*4917*/
				for (var _7Z = 0, _7a = $get($1.bot, $1.i + 1); _7Z < _7a; _7Z++) { /*4918*/
					$k[$j++] = 0; /*4918*/
				} /*4918*/
			} /*4918*/
			$astore($a(50)); /*4920*/
			$1.bot = $k[--$j]; /*4920*/
			if ($eq($1.format, "stacked")) { /*4939*/
				$k[$j++] = "sep"; /*4924*/
				$k[$j++] = Infinity; /*4924*/
				for (var _7e = 0, _7f = 50; _7e < _7f; _7e++) { /*4924*/
					$k[$j++] = 0; /*4924*/
				} /*4924*/
				var _7g = $a(); /*4924*/
				$1[$k[--$j]] = _7g; /*4924*/
				for (var _7i = 4; _7i <= 45; _7i += 1) { /*4932*/
					$1.i = _7i; /*4926*/
					if ($eq($get($1.top, $1.i), $get($1.bot, $1.i))) { /*4930*/
						$put($1.sep, $1.i, 1 - $get($1.top, $1.i)); /*4928*/
					} else { /*4930*/
						$put($1.sep, $1.i, 1 - $get($1.sep, $1.i - 1)); /*4930*/
					} /*4930*/
				} /*4930*/
				$k[$j++] = "pixs"; /*4936*/
				$k[$j++] = Infinity; /*4936*/
				for (var _7z = 0, _80 = 5; _7z < _80; _7z++) { /*4934*/
					$aload($1.top); /*4934*/
				} /*4934*/
				$aload($1.sep); /*4935*/
				for (var _83 = 0, _84 = 7; _83 < _84; _83++) { /*4936*/
					$aload($1.bot); /*4936*/
				} /*4936*/
				var _86 = $a(); /*4936*/
				$1[$k[--$j]] = _86; /*4937*/
				$1.pixy = ~~($1.pixs.length / 50); /*4938*/
			} /*4938*/
			if ($eq($1.format, "stackedomni")) { /*4989*/
				$k[$j++] = "sep1"; /*4943*/
				$k[$j++] = Infinity; /*4943*/
				$forall($1.top, function() { /*4943*/
					var _8B = $k[--$j]; /*4943*/
					$k[$j++] = 1 - _8B; /*4943*/
				}) /*4943*/
				var _8C = $a(); /*4943*/
				$1[$k[--$j]] = _8C; /*4943*/
				$puti($1.sep1, 0, $a([0, 0, 0, 0])); /*4944*/
				$puti($1.sep1, 46, $a([0, 0, 0, 0])); /*4945*/
				for (var _8I = 18; _8I <= 30; _8I += 1) { /*4958*/
					$1.i = _8I; /*4947*/
					if ($get($1.top, $1.i) == 0) { /*4955*/
						if ($get($1.top, $1.i - 1) == 1) { /*4952*/
							$k[$j++] = 1; /*4950*/
						} else { /*4952*/
							var _8S = ($get($1.sep1, $1.i - 1) == 0) ? 1 : 0; /*4952*/
							$k[$j++] = _8S; /*4952*/
						} /*4952*/
					} else { /*4955*/
						$k[$j++] = 0; /*4955*/
					} /*4955*/
					$put($1.sep1, $1.i, $k[--$j]); /*4957*/
				} /*4957*/
				$k[$j++] = "sep2"; /*4959*/
				$k[$j++] = Infinity; /*4959*/
				$k[$j++] = 0; /*4959*/
				$k[$j++] = 0; /*4959*/
				$k[$j++] = 0; /*4959*/
				$k[$j++] = 0; /*4959*/
				for (var _8W = 0, _8X = 21; _8W < _8X; _8W++) { /*4959*/
					$k[$j++] = 0; /*4959*/
					$k[$j++] = 1; /*4959*/
				} /*4959*/
				$k[$j++] = 0; /*4959*/
				$k[$j++] = 0; /*4959*/
				$k[$j++] = 0; /*4959*/
				$k[$j++] = 0; /*4959*/
				var _8Y = $a(); /*4959*/
				$1[$k[--$j]] = _8Y; /*4959*/
				$k[$j++] = "sep3"; /*4960*/
				$k[$j++] = Infinity; /*4960*/
				$forall($1.bot, function() { /*4960*/
					var _8b = $k[--$j]; /*4960*/
					$k[$j++] = 1 - _8b; /*4960*/
				}) /*4960*/
				var _8c = $a(); /*4960*/
				$1[$k[--$j]] = _8c; /*4960*/
				$puti($1.sep3, 0, $a([0, 0, 0, 0])); /*4961*/
				$puti($1.sep3, 46, $a([0, 0, 0, 0])); /*4962*/
				for (var _8i = 19; _8i <= 31; _8i += 1) { /*4975*/
					$1.i = _8i; /*4964*/
					if ($get($1.bot, $1.i) == 0) { /*4972*/
						if ($get($1.bot, $1.i - 1) == 1) { /*4969*/
							$k[$j++] = 1; /*4967*/
						} else { /*4969*/
							var _8s = ($get($1.sep3, $1.i - 1) == 0) ? 1 : 0; /*4969*/
							$k[$j++] = _8s; /*4969*/
						} /*4969*/
					} else { /*4972*/
						$k[$j++] = 0; /*4972*/
					} /*4972*/
					$put($1.sep3, $1.i, $k[--$j]); /*4974*/
				} /*4974*/
				$1.f3 = $a([1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1]); /*4976*/
				$k[$j++] = true; /*4977*/
				for (var _8x = 0; _8x <= 12; _8x += 1) { /*4977*/
					var _92 = $k[--$j]; /*4977*/
					$k[$j++] = _92 && $eq($get($1.bot, _8x + 19), $get($1.f3, _8x)); /*4977*/
				} /*4977*/
				if ($k[--$j]) { /*4980*/
					$puti($1.sep3, 19, $a([0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0])); /*4979*/
				} /*4979*/
				$k[$j++] = "pixs"; /*4986*/
				$k[$j++] = Infinity; /*4986*/
				for (var _96 = 0, _97 = 33; _96 < _97; _96++) { /*4982*/
					$aload($1.top); /*4982*/
				} /*4982*/
				$aload($1.sep1); /*4983*/
				$aload($1.sep2); /*4984*/
				$aload($1.sep3); /*4985*/
				for (var _9C = 0, _9D = 33; _9C < _9D; _9C++) { /*4986*/
					$aload($1.bot); /*4986*/
				} /*4986*/
				var _9F = $a(); /*4986*/
				$1[$k[--$j]] = _9F; /*4987*/
				$1.pixy = ~~($1.pixs.length / 50); /*4988*/
			} /*4988*/
			var _9M = {
				ren: $0.renmatrix,
				pixs: $1.pixs,
				pixx: 50,
				pixy: $1.pixy,
				height: $1.pixy / 72,
				width: 50 / 72,
				opt: $1.options
			}; /*4999*/
			$k[$j++] = _9M; /*5002*/
			if (!$1.dontdraw) { /*5002*/
				$0.renmatrix(); /*5002*/
			} /*5002*/
		} /*5002*/
	};
	$0.databarstacked = function() {
		var $1 = {}; /*5032*/
		$1.options = $k[--$j]; /*5034*/
		$1.barcode = $k[--$j]; /*5035*/
		$1.dontdraw = false; /*5037*/
		$forall($1.options, function() { /*5048*/
			var _3 = $k[--$j]; /*5048*/
			$1[$k[--$j]] = _3; /*5048*/
		}) /*5048*/
		if ($ne($geti($1.barcode, 0, 4), "(01)")) { /*5053*/
			$k[$j++] = "bwipp.databarstackedBadAI"; /*5052*/
			$k[$j++] = "GS1 DataBar Stacked must begin with (01) application identifier"; /*5052*/
			$0.raiseerror(); /*5052*/
		} /*5052*/
		if (($1.barcode.length != 17) && ($1.barcode.length != 18)) { /*5056*/
			$k[$j++] = "bwipp.databarstackedBadLength"; /*5055*/
			$k[$j++] = "GS1 DataBar Stacked must be 13 or 14 digits"; /*5055*/
			$0.raiseerror(); /*5055*/
		} /*5055*/
		$forall($geti($1.barcode, 4, $1.barcode.length - 4), function() { /*5061*/
			var _C = $k[--$j]; /*5058*/
			if ((_C < 48) || (_C > 57)) { /*5060*/
				$k[$j++] = "bwipp.databarstackedBadCharacter"; /*5059*/
				$k[$j++] = "GS1 DataBar Stacked must contain only digits"; /*5059*/
				$0.raiseerror(); /*5059*/
			} /*5059*/
		}) /*5059*/
		$1.checksum = 0; /*5064*/
		for (var _D = 0; _D <= 12; _D += 1) { /*5068*/
			$1.i = _D; /*5066*/
			$k[$j++] = "checksum"; /*5067*/
			$k[$j++] = $1.checksum; /*5067*/
			$k[$j++] = $get($1.barcode, $1.i + 4) - 48; /*5067*/
			if (($1.i % 2) == 0) { /*5067*/
				var _J = $k[--$j]; /*5067*/
				$k[$j++] = _J * 3; /*5067*/
			} /*5067*/
			var _K = $k[--$j]; /*5067*/
			var _L = $k[--$j]; /*5067*/
			$1[$k[--$j]] = _L + _K; /*5067*/
		} /*5067*/
		$1.checksum = (10 - ($1.checksum % 10)) % 10; /*5069*/
		if ($1.barcode.length == 18) { /*5074*/
			if ($get($1.barcode, 17) != ($1.checksum + 48)) { /*5073*/
				$k[$j++] = "bwipp.databarstackedBadCheckDigit"; /*5072*/
				$k[$j++] = "Incorrect GS1 DataBar Stacked check digit provided"; /*5072*/
				$0.raiseerror(); /*5072*/
			} /*5072*/
		} /*5072*/
		var _S = $s(18); /*5075*/
		$puti(_S, 0, $1.barcode); /*5076*/
		$put(_S, 17, $1.checksum + 48); /*5077*/
		$1.barcode = _S; /*5078*/
		$1.options.dontdraw = true; /*5081*/
		$1.options.format = "stacked"; /*5082*/
		$k[$j++] = "args"; /*5084*/
		$k[$j++] = $1.barcode; /*5084*/
		$k[$j++] = $1.options; /*5084*/
		$0.databaromni(); /*5084*/
		var _Z = $k[--$j]; /*5084*/
		$1[$k[--$j]] = _Z; /*5084*/
		$1.args.opt = $1.options; /*5086*/
		$k[$j++] = $1.args; /*5089*/
		if (!$1.dontdraw) { /*5089*/
			$0.renmatrix(); /*5089*/
		} /*5089*/
	};
	$0.databarstackedomni = function() {
		var $1 = {}; /*5117*/
		$1.options = $k[--$j]; /*5119*/
		$1.barcode = $k[--$j]; /*5120*/
		$1.dontdraw = false; /*5122*/
		$forall($1.options, function() { /*5133*/
			var _3 = $k[--$j]; /*5133*/
			$1[$k[--$j]] = _3; /*5133*/
		}) /*5133*/
		if ($ne($geti($1.barcode, 0, 4), "(01)")) { /*5138*/
			$k[$j++] = "bwipp.databarstackedomniBadAI"; /*5137*/
			$k[$j++] = "GS1 DataBar Stacked Omnidirectional must begin with (01) application identifier"; /*5137*/
			$0.raiseerror(); /*5137*/
		} /*5137*/
		if (($1.barcode.length != 17) && ($1.barcode.length != 18)) { /*5141*/
			$k[$j++] = "bwipp.databarstackedomniBadLength"; /*5140*/
			$k[$j++] = "GS1 DataBar Stacked Omnidirectional must be 13 or 14 digits"; /*5140*/
			$0.raiseerror(); /*5140*/
		} /*5140*/
		$forall($geti($1.barcode, 4, $1.barcode.length - 4), function() { /*5146*/
			var _C = $k[--$j]; /*5143*/
			if ((_C < 48) || (_C > 57)) { /*5145*/
				$k[$j++] = "bwipp.databarstackedomniBadCharacter"; /*5144*/
				$k[$j++] = "GS1 DataBar Stacked Omnidirectional must contain only digits"; /*5144*/
				$0.raiseerror(); /*5144*/
			} /*5144*/
		}) /*5144*/
		$1.checksum = 0; /*5149*/
		for (var _D = 0; _D <= 12; _D += 1) { /*5153*/
			$1.i = _D; /*5151*/
			$k[$j++] = "checksum"; /*5152*/
			$k[$j++] = $1.checksum; /*5152*/
			$k[$j++] = $get($1.barcode, $1.i + 4) - 48; /*5152*/
			if (($1.i % 2) == 0) { /*5152*/
				var _J = $k[--$j]; /*5152*/
				$k[$j++] = _J * 3; /*5152*/
			} /*5152*/
			var _K = $k[--$j]; /*5152*/
			var _L = $k[--$j]; /*5152*/
			$1[$k[--$j]] = _L + _K; /*5152*/
		} /*5152*/
		$1.checksum = (10 - ($1.checksum % 10)) % 10; /*5154*/
		if ($1.barcode.length == 18) { /*5159*/
			if ($get($1.barcode, 17) != ($1.checksum + 48)) { /*5158*/
				$k[$j++] = "bwipp.databarstackedomniBadCheckDigit"; /*5157*/
				$k[$j++] = "Incorrect GS1 DataBar Stacked Omnidirectional check digit provided"; /*5157*/
				$0.raiseerror(); /*5157*/
			} /*5157*/
		} /*5157*/
		var _S = $s(18); /*5160*/
		$puti(_S, 0, $1.barcode); /*5161*/
		$put(_S, 17, $1.checksum + 48); /*5162*/
		$1.barcode = _S; /*5163*/
		$1.options.dontdraw = true; /*5166*/
		$1.options.format = "stackedomni"; /*5167*/
		$k[$j++] = "args"; /*5169*/
		$k[$j++] = $1.barcode; /*5169*/
		$k[$j++] = $1.options; /*5169*/
		$0.databaromni(); /*5169*/
		var _Z = $k[--$j]; /*5169*/
		$1[$k[--$j]] = _Z; /*5169*/
		$1.args.opt = $1.options; /*5171*/
		$k[$j++] = $1.args; /*5174*/
		if (!$1.dontdraw) { /*5174*/
			$0.renmatrix(); /*5174*/
		} /*5174*/
	};
	$0.databartruncated = function() {
		var $1 = {}; /*5202*/
		$1.options = $k[--$j]; /*5204*/
		$1.barcode = $k[--$j]; /*5205*/
		$1.dontdraw = false; /*5207*/
		$forall($1.options, function() { /*5218*/
			var _3 = $k[--$j]; /*5218*/
			$1[$k[--$j]] = _3; /*5218*/
		}) /*5218*/
		if ($ne($geti($1.barcode, 0, 4), "(01)")) { /*5223*/
			$k[$j++] = "bwipp.databartruncatedBadAI"; /*5222*/
			$k[$j++] = "GS1 DataBar Truncated must begin with (01) application identifier"; /*5222*/
			$0.raiseerror(); /*5222*/
		} /*5222*/
		if (($1.barcode.length != 17) && ($1.barcode.length != 18)) { /*5226*/
			$k[$j++] = "bwipp.databartruncatedBadLength"; /*5225*/
			$k[$j++] = "GS1 DataBar Truncated must be 13 or 14 digits"; /*5225*/
			$0.raiseerror(); /*5225*/
		} /*5225*/
		$forall($geti($1.barcode, 4, $1.barcode.length - 4), function() { /*5231*/
			var _C = $k[--$j]; /*5228*/
			if ((_C < 48) || (_C > 57)) { /*5230*/
				$k[$j++] = "bwipp.databartruncatedBadCharacter"; /*5229*/
				$k[$j++] = "GS1 DataBar Truncated must contain only digits"; /*5229*/
				$0.raiseerror(); /*5229*/
			} /*5229*/
		}) /*5229*/
		$1.checksum = 0; /*5234*/
		for (var _D = 0; _D <= 12; _D += 1) { /*5238*/
			$1.i = _D; /*5236*/
			$k[$j++] = "checksum"; /*5237*/
			$k[$j++] = $1.checksum; /*5237*/
			$k[$j++] = $get($1.barcode, $1.i + 4) - 48; /*5237*/
			if (($1.i % 2) == 0) { /*5237*/
				var _J = $k[--$j]; /*5237*/
				$k[$j++] = _J * 3; /*5237*/
			} /*5237*/
			var _K = $k[--$j]; /*5237*/
			var _L = $k[--$j]; /*5237*/
			$1[$k[--$j]] = _L + _K; /*5237*/
		} /*5237*/
		$1.checksum = (10 - ($1.checksum % 10)) % 10; /*5239*/
		if ($1.barcode.length == 18) { /*5244*/
			if ($get($1.barcode, 17) != ($1.checksum + 48)) { /*5243*/
				$k[$j++] = "bwipp.databartruncatedBadCheckDigit"; /*5242*/
				$k[$j++] = "Incorrect GS1 DataBar Truncated check digit provided"; /*5242*/
				$0.raiseerror(); /*5242*/
			} /*5242*/
		} /*5242*/
		var _S = $s(18); /*5245*/
		$puti(_S, 0, $1.barcode); /*5246*/
		$put(_S, 17, $1.checksum + 48); /*5247*/
		$1.barcode = _S; /*5248*/
		$1.options.dontdraw = true; /*5251*/
		$1.options.format = "truncated"; /*5252*/
		$k[$j++] = "args"; /*5254*/
		$k[$j++] = $1.barcode; /*5254*/
		$k[$j++] = $1.options; /*5254*/
		$0.databaromni(); /*5254*/
		var _Z = $k[--$j]; /*5254*/
		$1[$k[--$j]] = _Z; /*5254*/
		$1.args.opt = $1.options; /*5256*/
		$k[$j++] = $1.args; /*5259*/
		if (!$1.dontdraw) { /*5259*/
			$0.renlinear(); /*5259*/
		} /*5259*/
	};
	$0.databarlimited = function() {
		var $1 = {}; /*5286*/
		$1.options = $k[--$j]; /*5288*/
		$1.barcode = $k[--$j]; /*5289*/
		$1.dontdraw = false; /*5291*/
		$1.height = 10 / 72; /*5292*/
		$1.linkage = false; /*5293*/
		$forall($1.options, function() { /*5304*/
			var _3 = $k[--$j]; /*5304*/
			$1[$k[--$j]] = _3; /*5304*/
		}) /*5304*/
		$1.height = +$1.height; /*5306*/
		if ($ne($geti($1.barcode, 0, 4), "(01)")) { /*5311*/
			$k[$j++] = "bwipp.databarlimitedBadAI"; /*5310*/
			$k[$j++] = "GS1 DataBar Limited must begin with (01) application identifier"; /*5310*/
			$0.raiseerror(); /*5310*/
		} /*5310*/
		if (($1.barcode.length != 17) && ($1.barcode.length != 18)) { /*5314*/
			$k[$j++] = "bwipp.databarlimitedBadLength"; /*5313*/
			$k[$j++] = "GS1 DataBar Limited must be 13 or 14 digits"; /*5313*/
			$0.raiseerror(); /*5313*/
		} /*5313*/
		var _B = $get($1.barcode, 4); /*5315*/
		if ((_B < 48) || (_B > 49)) { /*5317*/
			$k[$j++] = "bwipp.databarlimitedBadStartDigit"; /*5316*/
			$k[$j++] = "GS1 DataBar Limited must begin with 0 or 1"; /*5316*/
			$0.raiseerror(); /*5316*/
		} /*5316*/
		$forall($geti($1.barcode, 5, $1.barcode.length - 5), function() { /*5322*/
			var _F = $k[--$j]; /*5319*/
			if ((_F < 48) || (_F > 57)) { /*5321*/
				$k[$j++] = "bwipp.databarlimitedBadCharacter"; /*5320*/
				$k[$j++] = "GS1 DataBar Limited must contain only digits"; /*5320*/
				$0.raiseerror(); /*5320*/
			} /*5320*/
		}) /*5320*/
		$1.checksum = 0; /*5325*/
		for (var _G = 0; _G <= 12; _G += 1) { /*5329*/
			$1.i = _G; /*5327*/
			$k[$j++] = "checksum"; /*5328*/
			$k[$j++] = $1.checksum; /*5328*/
			$k[$j++] = $get($1.barcode, $1.i + 4) - 48; /*5328*/
			if (($1.i % 2) == 0) { /*5328*/
				var _M = $k[--$j]; /*5328*/
				$k[$j++] = _M * 3; /*5328*/
			} /*5328*/
			var _N = $k[--$j]; /*5328*/
			var _O = $k[--$j]; /*5328*/
			$1[$k[--$j]] = _O + _N; /*5328*/
		} /*5328*/
		$1.checksum = (10 - ($1.checksum % 10)) % 10; /*5330*/
		if ($1.barcode.length == 18) { /*5335*/
			if ($get($1.barcode, 17) != ($1.checksum + 48)) { /*5334*/
				$k[$j++] = "bwipp.databaromniBadCheckDigit"; /*5333*/
				$k[$j++] = "Incorrect GS1 DataBar Limited check digit provided"; /*5333*/
				$0.raiseerror(); /*5333*/
			} /*5333*/
		} /*5333*/
		var _V = $s(18); /*5336*/
		$puti(_V, 0, $1.barcode); /*5337*/
		$put(_V, 17, $1.checksum + 48); /*5338*/
		$1.barcode = _V; /*5339*/
		$k[$j++] = "binval"; /*5343*/
		$k[$j++] = Infinity; /*5343*/
		$forall($geti($1.barcode, 4, 13), function() { /*5343*/
			var _a = $k[--$j]; /*5343*/
			$k[$j++] = _a - 48; /*5343*/
		}) /*5343*/
		var _b = $a(); /*5343*/
		$1[$k[--$j]] = _b; /*5344*/
		if ($1.linkage) { /*5351*/
			$1.linkval = $a([2, 0, 1, 5, 1, 3, 3, 5, 3, 1, 0, 9, 6]); /*5346*/
			for (var _h = 0, _g = $1.binval.length - 1; _h <= _g; _h += 1) { /*5350*/
				$1.i = _h; /*5348*/
				$put($1.binval, $1.i, $get($1.binval, $1.i) + $get($1.linkval, $1.i)); /*5349*/
			} /*5349*/
		} /*5349*/
		$1.txt = $a($1.barcode.length); /*5354*/
		for (var _u = 0, _t = $1.barcode.length - 1; _u <= _t; _u += 1) { /*5358*/
			$1.i = _u; /*5356*/
			$put($1.txt, $1.i, $a([$geti($1.barcode, $1.i, 1), 0, 0, "", 0])); /*5357*/
		} /*5357*/
		$1.ncr = function() {
			var _11 = $k[--$j]; /*5361*/
			var _12 = $k[--$j]; /*5361*/
			var _13 = _12 - _11; /*5361*/
			if (_11 < (_12 - _11)) { /*5361*/
				var _ = _13; /*5361*/
				_13 = _11; /*5361*/
				_11 = _; /*5361*/
			} /*5361*/
			$k[$j++] = _13; /*5368*/
			$k[$j++] = 1; /*5368*/
			$k[$j++] = 1; /*5368*/
			for (var _15 = _12, _14 = _11 + 1; _15 >= _14; _15 -= 1) { /*5368*/
				var _16 = $k[--$j]; /*5364*/
				var _17 = $k[--$j]; /*5365*/
				var _18 = $k[--$j]; /*5365*/
				$k[$j++] = _18; /*5367*/
				$k[$j++] = _17; /*5367*/
				$k[$j++] = _16 * _15; /*5367*/
				if ($le(_17, _18)) { /*5367*/
					var _19 = $k[--$j]; /*5366*/
					var _1A = $k[--$j]; /*5366*/
					$k[$j++] = _1A + 1; /*5366*/
					$k[$j++] = ~~(_19 / _1A); /*5366*/
				} /*5366*/
			} /*5366*/
			for (;;) { /*5372*/
				var _1B = $k[--$j]; /*5370*/
				var _1C = $k[--$j]; /*5370*/
				var _1D = $k[--$j]; /*5370*/
				$k[$j++] = _1D; /*5370*/
				$k[$j++] = _1C; /*5370*/
				$k[$j++] = _1B; /*5370*/
				if ($gt(_1C, _1D)) { /*5370*/
					break; /*5370*/
				} /*5370*/
				var _1E = $k[--$j]; /*5371*/
				var _1F = $k[--$j]; /*5371*/
				$k[$j++] = _1F + 1; /*5371*/
				$k[$j++] = ~~(_1E / _1F); /*5371*/
			} /*5371*/
			var _1G = $k[--$j]; /*5373*/
			var _1H = $k[--$j]; /*5373*/
			var _1I = $k[--$j]; /*5373*/
			$k[$j++] = _1G; /*5373*/
		}; /*5374*/
		$1.getRSSwidths = function() {
			$1.oe = $k[--$j]; /*5377*/
			$1.el = $k[--$j]; /*5378*/
			$1.mw = $k[--$j]; /*5379*/
			$1.nm = $k[--$j]; /*5380*/
			$1.val = $k[--$j]; /*5381*/
			$1.out = $a($1.el); /*5382*/
			$1.mask = 0; /*5383*/
			for (var _1S = 0, _1R = $1.el - 2; _1S <= _1R; _1S += 1) { /*5410*/
				$1.bar = _1S; /*5385*/
				$1.ew = 1; /*5386*/
				var _1U = $1.bar; /*5387*/
				$1.mask = $1.mask | ((_1U < 0 ? 1 >>> -_1U : 1 << _1U)); /*5387*/
				for (;;) { /*5406*/
					$k[$j++] = "sval"; /*5388*/
					$k[$j++] = ($1.nm - $1.ew) - 1; /*5388*/
					$k[$j++] = ($1.el - $1.bar) - 2; /*5388*/
					$1.ncr(); /*5388*/
					var _1Z = $k[--$j]; /*5388*/
					$1[$k[--$j]] = _1Z; /*5388*/
					if (($1.oe && ($1.mask == 0)) && (((($1.nm - $1.ew) - ($1.el * 2)) + ($1.bar * 2)) >= -2)) { /*5391*/
						$k[$j++] = "sval"; /*5390*/
						$k[$j++] = $1.sval; /*5390*/
						$k[$j++] = (($1.nm - $1.ew) - $1.el) + $1.bar; /*5390*/
						$k[$j++] = ($1.el - $1.bar) - 2; /*5390*/
						$1.ncr(); /*5390*/
						var _1o = $k[--$j]; /*5390*/
						var _1p = $k[--$j]; /*5390*/
						$1[$k[--$j]] = _1p - _1o; /*5390*/
					} /*5390*/
					if (($1.el - $1.bar) > 2) { /*5400*/
						$1.lval = 0; /*5393*/
						for (var _1z = ((($1.nm - $1.ew) - $1.el) + $1.bar) + 2, _1y = $1.mw + 1; _1z >= _1y; _1z -= 1) { /*5397*/
							$k[$j++] = (($1.nm - _1z) - $1.ew) - 1; /*5395*/
							$k[$j++] = ($1.el - $1.bar) - 3; /*5395*/
							$1.ncr(); /*5395*/
							$1.lval = $k[--$j] + $1.lval; /*5396*/
						} /*5396*/
						$1.sval = $1.sval - ($1.lval * (($1.el - $1.bar) - 1)); /*5398*/
					} else { /*5400*/
						if (($1.nm - $1.ew) > $1.mw) { /*5400*/
							$1.sval = $1.sval - 1; /*5400*/
						} /*5400*/
					} /*5400*/
					$1.val = $1.val - $1.sval; /*5402*/
					if ($1.val < 0) { /*5403*/
						break; /*5403*/
					} /*5403*/
					$1.ew = $1.ew + 1; /*5404*/
					var _2J = $1.bar; /*5405*/
					$1.mask = $1.mask & (~((_2J < 0 ? 1 >>> -_2J : 1 << _2J))); /*5405*/
				} /*5405*/
				$1.val = $1.val + $1.sval; /*5407*/
				$1.nm = $1.nm - $1.ew; /*5408*/
				$put($1.out, $1.bar, $1.ew); /*5409*/
			} /*5409*/
			$put($1.out, $1.el - 1, $1.nm); /*5411*/
			$k[$j++] = $1.out; /*5412*/
		}; /*5413*/
		for (var _2V = 0; _2V <= 11; _2V += 1) { /*5419*/
			$1.i = _2V; /*5416*/
			var _2W = $1.binval; /*5417*/
			var _2X = $1.i; /*5417*/
			$put(_2W, _2X + 1, $get(_2W, _2X + 1) + (($get($1.binval, $1.i) % 2013571) * 10)); /*5417*/
			$put($1.binval, $1.i, ~~($get($1.binval, $1.i) / 2013571)); /*5418*/
		} /*5418*/
		$1.d2 = $get($1.binval, 12) % 2013571; /*5420*/
		var _2j = $1.binval; /*5421*/
		$put(_2j, 12, ~~($get(_2j, 12) / 2013571)); /*5421*/
		$1.d1 = 0; /*5423*/
		$1.i = true; /*5424*/
		for (var _2l = 0; _2l <= 12; _2l += 1) { /*5434*/
			$1.j = _2l; /*5426*/
			var _2o = $get($1.binval, $1.j); /*5427*/
			$k[$j++] = _2o; /*5433*/
			if ((_2o == 0) && $1.i) { /*5432*/
				$j--; /*5429*/
			} else { /*5432*/
				$1.i = false; /*5431*/
				$1.d1 = $1.d1 + ($k[--$j] * (~~Math.pow(10, 12 - $1.j))); /*5432*/
			} /*5432*/
		} /*5432*/
		$1.tab267 = $a([183063, 0, 17, 9, 6, 3, 6538, 28, 820063, 183064, 13, 13, 5, 4, 875, 728, 1000775, 820064, 9, 17, 3, 6, 28, 6454, 1491020, 1000776, 15, 11, 5, 4, 2415, 203, 1979844, 1491021, 11, 15, 4, 5, 203, 2408, 1996938, 1979845, 19, 7, 8, 1, 17094, 1, 2013570, 1996939, 7, 19, 1, 8, 1, 16632]); /*5444*/
		$1.i = 0; /*5446*/
		for (;;) { /*5456*/
			if ($1.d1 <= $get($1.tab267, $1.i)) { /*5454*/
				$forall($geti($1.tab267, $1.i + 1, 7)); /*5448*/
				$1.d1te = $k[--$j]; /*5449*/
				$1.d1to = $k[--$j]; /*5449*/
				$1.d1mwe = $k[--$j]; /*5450*/
				$1.d1mwo = $k[--$j]; /*5450*/
				$1.d1ele = $k[--$j]; /*5451*/
				$1.d1elo = $k[--$j]; /*5451*/
				$1.d1gs = $k[--$j]; /*5452*/
				break; /*5453*/
			} /*5453*/
			$1.i = $1.i + 8; /*5455*/
		} /*5455*/
		$1.i = 0; /*5458*/
		for (;;) { /*5468*/
			if ($1.d2 <= $get($1.tab267, $1.i)) { /*5466*/
				$forall($geti($1.tab267, $1.i + 1, 7)); /*5460*/
				$1.d2te = $k[--$j]; /*5461*/
				$1.d2to = $k[--$j]; /*5461*/
				$1.d2mwe = $k[--$j]; /*5462*/
				$1.d2mwo = $k[--$j]; /*5462*/
				$1.d2ele = $k[--$j]; /*5463*/
				$1.d2elo = $k[--$j]; /*5463*/
				$1.d2gs = $k[--$j]; /*5464*/
				break; /*5465*/
			} /*5465*/
			$1.i = $1.i + 8; /*5467*/
		} /*5467*/
		$k[$j++] = "d1wo"; /*5470*/
		$k[$j++] = ~~(($1.d1 - $1.d1gs) / $1.d1te); /*5470*/
		$k[$j++] = $1.d1elo; /*5470*/
		$k[$j++] = $1.d1mwo; /*5470*/
		$k[$j++] = 7; /*5470*/
		$k[$j++] = false; /*5470*/
		$1.getRSSwidths(); /*5470*/
		var _3T = $k[--$j]; /*5470*/
		$1[$k[--$j]] = _3T; /*5470*/
		$k[$j++] = "d1we"; /*5471*/
		$k[$j++] = ($1.d1 - $1.d1gs) % $1.d1te; /*5471*/
		$k[$j++] = $1.d1ele; /*5471*/
		$k[$j++] = $1.d1mwe; /*5471*/
		$k[$j++] = 7; /*5471*/
		$k[$j++] = true; /*5471*/
		$1.getRSSwidths(); /*5471*/
		var _3a = $k[--$j]; /*5471*/
		$1[$k[--$j]] = _3a; /*5471*/
		$k[$j++] = "d2wo"; /*5472*/
		$k[$j++] = ~~(($1.d2 - $1.d2gs) / $1.d2te); /*5472*/
		$k[$j++] = $1.d2elo; /*5472*/
		$k[$j++] = $1.d2mwo; /*5472*/
		$k[$j++] = 7; /*5472*/
		$k[$j++] = false; /*5472*/
		$1.getRSSwidths(); /*5472*/
		var _3h = $k[--$j]; /*5472*/
		$1[$k[--$j]] = _3h; /*5472*/
		$k[$j++] = "d2we"; /*5473*/
		$k[$j++] = ($1.d2 - $1.d2gs) % $1.d2te; /*5473*/
		$k[$j++] = $1.d2ele; /*5473*/
		$k[$j++] = $1.d2mwe; /*5473*/
		$k[$j++] = 7; /*5473*/
		$k[$j++] = true; /*5473*/
		$1.getRSSwidths(); /*5473*/
		var _3o = $k[--$j]; /*5473*/
		$1[$k[--$j]] = _3o; /*5473*/
		$1.d1w = $a(14); /*5475*/
		for (var _3r = 0; _3r <= 6; _3r += 1) { /*5480*/
			$1.i = _3r; /*5477*/
			$put($1.d1w, $1.i * 2, $get($1.d1wo, $1.i)); /*5478*/
			$put($1.d1w, ($1.i * 2) + 1, $get($1.d1we, $1.i)); /*5479*/
		} /*5479*/
		$1.d2w = $a(14); /*5482*/
		for (var _43 = 0; _43 <= 6; _43 += 1) { /*5487*/
			$1.i = _43; /*5484*/
			$put($1.d2w, $1.i * 2, $get($1.d2wo, $1.i)); /*5485*/
			$put($1.d2w, ($1.i * 2) + 1, $get($1.d2we, $1.i)); /*5486*/
		} /*5486*/
		$k[$j++] = "widths"; /*5491*/
		$k[$j++] = Infinity; /*5491*/
		var _4E = $1.d1w; /*5490*/
		for (var _4F = 0, _4G = _4E.length; _4F < _4G; _4F++) { /*5490*/
			$k[$j++] = $get(_4E, _4F); /*5490*/
		} /*5490*/
		var _4I = $1.d2w; /*5491*/
		for (var _4J = 0, _4K = _4I.length; _4J < _4K; _4J++) { /*5491*/
			$k[$j++] = $get(_4I, _4J); /*5491*/
		} /*5491*/
		var _4M = $a(); /*5491*/
		$1[$k[--$j]] = _4M; /*5492*/
		$1.checkweights = $a([1, 3, 9, 27, 81, 65, 17, 51, 64, 14, 42, 37, 22, 66, 20, 60, 2, 6, 18, 54, 73, 41, 34, 13, 39, 28, 84, 74]); /*5497*/
		$k[$j++] = "checkseq"; /*5512*/
		$k[$j++] = Infinity; /*5512*/
		for (var _4P = 0; _4P <= 43; _4P += 1) { /*5500*/
			$k[$j++] = _4P; /*5500*/
		} /*5500*/
		$k[$j++] = 45; /*5502*/
		$k[$j++] = 52; /*5502*/
		$k[$j++] = 57; /*5502*/
		for (var _4Q = 63; _4Q <= 66; _4Q += 1) { /*5502*/
			$k[$j++] = _4Q; /*5502*/
		} /*5502*/
		for (var _4R = 73; _4R <= 79; _4R += 1) { /*5503*/
			$k[$j++] = _4R; /*5503*/
		} /*5503*/
		$k[$j++] = 82; /*5505*/
		for (var _4S = 126; _4S <= 130; _4S += 1) { /*5505*/
			$k[$j++] = _4S; /*5505*/
		} /*5505*/
		$k[$j++] = 132; /*5507*/
		for (var _4T = 141; _4T <= 146; _4T += 1) { /*5507*/
			$k[$j++] = _4T; /*5507*/
		} /*5507*/
		for (var _4U = 210; _4U <= 217; _4U += 1) { /*5508*/
			$k[$j++] = _4U; /*5508*/
		} /*5508*/
		$k[$j++] = 220; /*5510*/
		for (var _4V = 316; _4V <= 320; _4V += 1) { /*5510*/
			$k[$j++] = _4V; /*5510*/
		} /*5510*/
		$k[$j++] = 322; /*5512*/
		$k[$j++] = 323; /*5512*/
		$k[$j++] = 326; /*5512*/
		$k[$j++] = 337; /*5512*/
		var _4W = $a(); /*5512*/
		$1[$k[--$j]] = _4W; /*5513*/
		$1.checksum = 0; /*5515*/
		for (var _4Y = 0; _4Y <= 27; _4Y += 1) { /*5519*/
			$1.i = _4Y; /*5517*/
			$1.checksum = $1.checksum + ($get($1.widths, $1.i) * $get($1.checkweights, $1.i)); /*5518*/
		} /*5518*/
		$1.checksum = $1.checksum % 89; /*5520*/
		$1.seq = $get($1.checkseq, $1.checksum); /*5521*/
		$k[$j++] = "swidths"; /*5522*/
		$k[$j++] = ~~($1.seq / 21); /*5522*/
		$k[$j++] = 8; /*5522*/
		$k[$j++] = 3; /*5522*/
		$k[$j++] = 6; /*5522*/
		$k[$j++] = false; /*5522*/
		$1.getRSSwidths(); /*5522*/
		var _4l = $k[--$j]; /*5522*/
		$1[$k[--$j]] = _4l; /*5522*/
		$k[$j++] = "bwidths"; /*5523*/
		$k[$j++] = $1.seq % 21; /*5523*/
		$k[$j++] = 8; /*5523*/
		$k[$j++] = 3; /*5523*/
		$k[$j++] = 6; /*5523*/
		$k[$j++] = false; /*5523*/
		$1.getRSSwidths(); /*5523*/
		var _4o = $k[--$j]; /*5523*/
		$1[$k[--$j]] = _4o; /*5523*/
		$1.checkwidths = $a([0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1]); /*5525*/
		for (var _4r = 0; _4r <= 5; _4r += 1) { /*5530*/
			$1.i = _4r; /*5527*/
			$put($1.checkwidths, $1.i * 2, $get($1.swidths, $1.i)); /*5528*/
			$put($1.checkwidths, ($1.i * 2) + 1, $get($1.bwidths, $1.i)); /*5529*/
		} /*5529*/
		$k[$j++] = "sbs"; /*5533*/
		$k[$j++] = Infinity; /*5533*/
		var _52 = $1.d1w; /*5533*/
		$k[$j++] = 1; /*5533*/
		for (var _53 = 0, _54 = _52.length; _53 < _54; _53++) { /*5533*/
			$k[$j++] = $get(_52, _53); /*5533*/
		} /*5533*/
		var _56 = $1.checkwidths; /*5533*/
		for (var _57 = 0, _58 = _56.length; _57 < _58; _57++) { /*5533*/
			$k[$j++] = $get(_56, _57); /*5533*/
		} /*5533*/
		var _5A = $1.d2w; /*5533*/
		for (var _5B = 0, _5C = _5A.length; _5B < _5C; _5B++) { /*5533*/
			$k[$j++] = $get(_5A, _5B); /*5533*/
		} /*5533*/
		$k[$j++] = 1; /*5533*/
		$k[$j++] = 1; /*5533*/
		var _5E = $a(); /*5533*/
		$1[$k[--$j]] = _5E; /*5534*/
		$k[$j++] = Infinity; /*5544*/
		$k[$j++] = "ren"; /*5540*/
		$k[$j++] = $0.renlinear; /*5540*/
		$k[$j++] = "sbs"; /*5540*/
		$k[$j++] = $1.sbs; /*5540*/
		$k[$j++] = "bhs"; /*5540*/
		$k[$j++] = Infinity; /*5540*/
		for (var _5I = 0, _5J = ~~(($1.sbs.length + 1) / 2); _5I < _5J; _5I++) { /*5540*/
			$k[$j++] = $1.height; /*5540*/
		} /*5540*/
		var _5L = $a(); /*5540*/
		$k[$j++] = _5L; /*5541*/
		$k[$j++] = "bbs"; /*5541*/
		$k[$j++] = Infinity; /*5541*/
		for (var _5N = 0, _5O = ~~(($1.sbs.length + 1) / 2); _5N < _5O; _5N++) { /*5541*/
			$k[$j++] = 0; /*5541*/
		} /*5541*/
		var _5P = $a(); /*5541*/
		$k[$j++] = _5P; /*5544*/
		$k[$j++] = "txt"; /*5544*/
		$k[$j++] = $1.txt; /*5544*/
		$k[$j++] = "textxalign"; /*5544*/
		$k[$j++] = "center"; /*5544*/
		$k[$j++] = "opt"; /*5544*/
		$k[$j++] = $1.options; /*5544*/
		var _5S = $d(); /*5544*/
		$k[$j++] = _5S; /*5547*/
		if (!$1.dontdraw) { /*5547*/
			$0.renlinear(); /*5547*/
		} /*5547*/
	};
	$0.databarexpanded = function() {
		var $1 = {}; /*5575*/
		$1.options = $k[--$j]; /*5577*/
		$1.barcode = $k[--$j]; /*5578*/
		$1.dontdraw = false; /*5580*/
		$1.height = 34 / 72; /*5581*/
		$1.format = "expanded"; /*5582*/
		$1.segments = -1; /*5583*/
		$1.linkage = false; /*5584*/
		$forall($1.options, function() { /*5595*/
			var _3 = $k[--$j]; /*5595*/
			$1[$k[--$j]] = _3; /*5595*/
		}) /*5595*/
		$1.height = +$1.height; /*5597*/
		$1.segments = ~~$1.segments; /*5598*/
		if ($1.segments == -1) { /*5602*/
			var _9 = $eq($1.format, "expandedstacked") ? 4 : 22; /*5601*/
			$1.segments = _9; /*5601*/
		} /*5601*/
		$1.expand = function() {
			$1.in = $k[--$j]; /*5606*/
			$1.out = $s($1.in.length); /*5607*/
			$1.j = 0; /*5608*/
			$k[$j++] = $1.in; /*5622*/
			for (;;) { /*5622*/
				$search($k[--$j], "^"); /*5611*/
				if ($k[--$j]) { /*5620*/
					var _G = $k[--$j]; /*5612*/
					$puti($1.out, $1.j, _G); /*5612*/
					$1.j = (_G.length + $1.j) + 1; /*5613*/
					$j--; /*5614*/
					var _K = $k[--$j]; /*5615*/
					$put($1.out, $1.j - 1, ~~$z($geti(_K, 0, 3))); /*5615*/
					$k[$j++] = $geti(_K, 3, _K.length - 3); /*5616*/
				} else { /*5620*/
					var _P = $k[--$j]; /*5618*/
					$puti($1.out, $1.j, _P); /*5618*/
					$1.j = _P.length + $1.j; /*5619*/
					$k[$j++] = $geti($1.out, 0, $1.j); /*5620*/
					break; /*5620*/
				} /*5620*/
			} /*5620*/
		}; /*5623*/
		$1.ais = $a([]); /*5626*/
		$1.aival = {}; /*5627*/
		var _X = $1.barcode; /*5628*/
		$k[$j++] = $geti(_X, 1, _X.length - 1); /*5640*/
		for (;;) { /*5640*/
			var _Z = $k[--$j]; /*5630*/
			$k[$j++] = _Z; /*5630*/
			if ($eq(_Z, "")) { /*5630*/
				break; /*5630*/
			} /*5630*/
			$search($k[--$j], ")"); /*5631*/
			$j--; /*5631*/
			var _b = $k[--$j]; /*5632*/
			var _c = $k[--$j]; /*5632*/
			var _d = $k[--$j]; /*5633*/
			$k[$j++] = _b; /*5633*/
			$search(_d, "("); /*5633*/
			if ($k[--$j]) { /*5636*/
				var _f = $k[--$j]; /*5634*/
				var _g = $k[--$j]; /*5634*/
				var _h = $k[--$j]; /*5634*/
				var _i = $k[--$j]; /*5634*/
				$k[$j++] = _h; /*5634*/
				$k[$j++] = _i; /*5634*/
				$k[$j++] = _f; /*5634*/
			} else { /*5636*/
				var _j = $k[--$j]; /*5636*/
				var _k = $k[--$j]; /*5636*/
				$k[$j++] = ""; /*5636*/
				$k[$j++] = _k; /*5636*/
				$k[$j++] = _j; /*5636*/
			} /*5636*/
			$k[$j++] = Infinity; /*5638*/
			$aload($1.ais); /*5638*/
			var _n = $k[$j - 1 - ($counttomark() + 2)]; /*5638*/
			$k[$j++] = _n; /*5638*/
			$1.ais = $a(); /*5638*/
			var _q = $k[--$j]; /*5639*/
			var _r = $k[--$j]; /*5639*/
			$k[$j++] = $1.aival; /*5639*/
			$k[$j++] = _r; /*5639*/
			$k[$j++] = _q; /*5639*/
			$1.expand(); /*5639*/
			var _s = $k[--$j]; /*5639*/
			var _t = $k[--$j]; /*5639*/
			$put($k[--$j], _t, _s); /*5639*/
		} /*5639*/
		$j--; /*5641*/
		for (;;) { /*5728*/
			if ($1.ais.length == 2) { /*5653*/
				if ($eq($get($1.ais, 0), "01") && $eq($get($1.ais, 1), "3103")) { /*5652*/
					if ($eq($geti($1.aival["01"], 0, 1), "9") && ((~~$z($1.aival["3103"])) <= 32767)) { /*5651*/
						$k[$j++] = "0100"; /*5650*/
						$k[$j++] = false; /*5650*/
						break; /*5650*/
					} /*5650*/
				} /*5650*/
			} /*5650*/
			if ($1.ais.length == 2) { /*5662*/
				if ($eq($get($1.ais, 0), "01") && $eq($get($1.ais, 1), "3202")) { /*5661*/
					if ($eq($geti($1.aival["01"], 0, 1), "9") && ((~~$z($1.aival["3202"])) <= 9999)) { /*5660*/
						$k[$j++] = "0101"; /*5659*/
						$k[$j++] = false; /*5659*/
						break; /*5659*/
					} /*5659*/
				} /*5659*/
			} /*5659*/
			if ($1.ais.length == 2) { /*5671*/
				if ($eq($get($1.ais, 0), "01") && $eq($get($1.ais, 1), "3203")) { /*5670*/
					if ($eq($geti($1.aival["01"], 0, 1), "9") && ((~~$z($1.aival["3203"])) <= 22767)) { /*5669*/
						$k[$j++] = "0101"; /*5668*/
						$k[$j++] = false; /*5668*/
						break; /*5668*/
					} /*5668*/
				} /*5668*/
			} /*5668*/
			var _1Q = $1.ais.length; /*5674*/
			if ((_1Q == 2) || (_1Q == 3)) { /*5704*/
				$k[$j++] = "ai310x"; /*5675*/
				$k[$j++] = false; /*5675*/
				for (var _1R = 3100; _1R <= 3109; _1R += 1) { /*5675*/
					var _1W = $k[--$j]; /*5675*/
					$k[$j++] = _1W || $eq($cvrs($s(4), _1R, 10), $get($1.ais, 1)); /*5675*/
				} /*5675*/
				var _1X = $k[--$j]; /*5675*/
				$1[$k[--$j]] = _1X; /*5675*/
				$k[$j++] = "ai320x"; /*5676*/
				$k[$j++] = false; /*5676*/
				for (var _1Z = 3200; _1Z <= 3209; _1Z += 1) { /*5676*/
					var _1e = $k[--$j]; /*5676*/
					$k[$j++] = _1e || $eq($cvrs($s(4), _1Z, 10), $get($1.ais, 1)); /*5676*/
				} /*5676*/
				var _1f = $k[--$j]; /*5676*/
				$1[$k[--$j]] = _1f; /*5676*/
				if ($1.ais.length == 3) { /*5680*/
					var _1i = $a(["11", "13", "15", "17"]); /*5678*/
					$k[$j++] = "aibad"; /*5678*/
					$k[$j++] = true; /*5678*/
					for (var _1j = 0, _1k = _1i.length; _1j < _1k; _1j++) { /*5678*/
						var _1o = $k[--$j]; /*5678*/
						$k[$j++] = _1o && $ne($get(_1i, _1j), $get($1.ais, 2)); /*5678*/
					} /*5678*/
					var _1p = $k[--$j]; /*5678*/
					$1[$k[--$j]] = _1p; /*5678*/
				} else { /*5680*/
					$1.aibad = false; /*5680*/
				} /*5680*/
				if (($eq($get($1.ais, 0), "01") && ($1.ai310x || $1.ai320x)) && (!$1.aibad)) { /*5703*/
					if ($1.ais.length == 3) { /*5700*/
						if (($eq($geti($1.aival["01"], 0, 1), "9") && ((~~$z($get($1.aival, $get($1.ais, 1)))) <= 99999)) && ((~~$z($get($1.aival, $get($1.ais, 2)))) <= 999999)) { /*5695*/
							if ($1.ai310x && $eq($get($1.ais, 2), "11")) { /*5687*/
								$k[$j++] = "0111000"; /*5687*/
								$k[$j++] = false; /*5687*/
								break; /*5687*/
							} /*5687*/
							if ($1.ai320x && $eq($get($1.ais, 2), "11")) { /*5688*/
								$k[$j++] = "0111001"; /*5688*/
								$k[$j++] = false; /*5688*/
								break; /*5688*/
							} /*5688*/
							if ($1.ai310x && $eq($get($1.ais, 2), "13")) { /*5689*/
								$k[$j++] = "0111010"; /*5689*/
								$k[$j++] = false; /*5689*/
								break; /*5689*/
							} /*5689*/
							if ($1.ai320x && $eq($get($1.ais, 2), "13")) { /*5690*/
								$k[$j++] = "0111011"; /*5690*/
								$k[$j++] = false; /*5690*/
								break; /*5690*/
							} /*5690*/
							if ($1.ai310x && $eq($get($1.ais, 2), "15")) { /*5691*/
								$k[$j++] = "0111100"; /*5691*/
								$k[$j++] = false; /*5691*/
								break; /*5691*/
							} /*5691*/
							if ($1.ai320x && $eq($get($1.ais, 2), "15")) { /*5692*/
								$k[$j++] = "0111101"; /*5692*/
								$k[$j++] = false; /*5692*/
								break; /*5692*/
							} /*5692*/
							if ($1.ai310x && $eq($get($1.ais, 2), "17")) { /*5693*/
								$k[$j++] = "0111110"; /*5693*/
								$k[$j++] = false; /*5693*/
								break; /*5693*/
							} /*5693*/
							if ($1.ai320x && $eq($get($1.ais, 2), "17")) { /*5694*/
								$k[$j++] = "0111111"; /*5694*/
								$k[$j++] = false; /*5694*/
								break; /*5694*/
							} /*5694*/
						} /*5694*/
					} else { /*5700*/
						if ($eq($geti($1.aival["01"], 0, 1), "9") && ((~~$z($get($1.aival, $get($1.ais, 1)))) <= 99999)) { /*5701*/
							if ($1.ai310x) { /*5699*/
								$k[$j++] = "0111000"; /*5699*/
								$k[$j++] = false; /*5699*/
								break; /*5699*/
							} /*5699*/
							if ($1.ai320x) { /*5700*/
								$k[$j++] = "0111001"; /*5700*/
								$k[$j++] = false; /*5700*/
								break; /*5700*/
							} /*5700*/
						} /*5700*/
					} /*5700*/
				} /*5700*/
			} /*5700*/
			if ($1.ais.length >= 2) { /*5712*/
				$k[$j++] = "ai392x"; /*5708*/
				$k[$j++] = false; /*5708*/
				for (var _2g = 3920; _2g <= 3923; _2g += 1) { /*5708*/
					var _2l = $k[--$j]; /*5708*/
					$k[$j++] = _2l || $eq($cvrs($s(4), _2g, 10), $get($1.ais, 1)); /*5708*/
				} /*5708*/
				var _2m = $k[--$j]; /*5708*/
				$1[$k[--$j]] = _2m; /*5708*/
				if ($eq($get($1.ais, 0), "01") && $1.ai392x) { /*5711*/
					if ($eq($geti($1.aival["01"], 0, 1), "9")) { /*5710*/
						$k[$j++] = "01100"; /*5710*/
						$k[$j++] = true; /*5710*/
						break; /*5710*/
					} /*5710*/
				} /*5710*/
			} /*5710*/
			if ($1.ais.length >= 2) { /*5720*/
				$k[$j++] = "ai393x"; /*5716*/
				$k[$j++] = false; /*5716*/
				for (var _2v = 3930; _2v <= 3933; _2v += 1) { /*5716*/
					var _30 = $k[--$j]; /*5716*/
					$k[$j++] = _30 || $eq($cvrs($s(4), _2v, 10), $get($1.ais, 1)); /*5716*/
				} /*5716*/
				var _31 = $k[--$j]; /*5716*/
				$1[$k[--$j]] = _31; /*5716*/
				if ($eq($get($1.ais, 0), "01") && $1.ai393x) { /*5719*/
					if ($eq($geti($1.aival["01"], 0, 1), "9")) { /*5718*/
						$k[$j++] = "01101"; /*5718*/
						$k[$j++] = true; /*5718*/
						break; /*5718*/
					} /*5718*/
				} /*5718*/
			} /*5718*/
			if ($eq($get($1.ais, 0), "01")) { /*5723*/
				$k[$j++] = "1"; /*5723*/
				$k[$j++] = true; /*5723*/
				break; /*5723*/
			} /*5723*/
			$k[$j++] = "00"; /*5726*/
			$k[$j++] = true; /*5726*/
			break; /*5726*/
		} /*5726*/
		$1.gpfallow = $k[--$j]; /*5729*/
		$1.method = $k[--$j]; /*5730*/
		$1.conv12to40 = function() {
			var _3E = $strcpy($s(40), "0000000000000000000000000000000000000000"); /*5733*/
			var _3F = $k[--$j]; /*5734*/
			var _3J = $cvrs($s(10), ~~$z($geti(_3F, 0, 3)), 2); /*5734*/
			$puti($geti(_3E, 0, 10), 10 - _3J.length, _3J); /*5734*/
			var _3N = $cvrs($s(10), ~~$z($geti(_3F, 3, 3)), 2); /*5735*/
			$puti($geti(_3E, 10, 10), 10 - _3N.length, _3N); /*5735*/
			var _3R = $cvrs($s(10), ~~$z($geti(_3F, 6, 3)), 2); /*5736*/
			$puti($geti(_3E, 20, 10), 10 - _3R.length, _3R); /*5736*/
			var _3V = $cvrs($s(10), ~~$z($geti(_3F, 9, 3)), 2); /*5737*/
			$puti($geti(_3E, 30, 10), 10 - _3V.length, _3V); /*5737*/
			$k[$j++] = _3E; /*5738*/
		}; /*5739*/
		$1.conv13to44 = function() {
			var _3X = $strcpy($s(44), "00000000000000000000000000000000000000000000"); /*5742*/
			var _3Y = $k[--$j]; /*5743*/
			var _3c = $cvrs($s(4), ~~$z($geti(_3Y, 0, 1)), 2); /*5743*/
			$puti($geti(_3X, 0, 4), 4 - _3c.length, _3c); /*5743*/
			$k[$j++] = _3X; /*5744*/
			$k[$j++] = _3X; /*5744*/
			$k[$j++] = $geti(_3Y, 1, 12); /*5744*/
			$1.conv12to40(); /*5744*/
			var _3e = $k[--$j]; /*5744*/
			$puti($k[--$j], 4, _3e); /*5744*/
		}; /*5745*/
		$1.tobin = function() {
			var _3h = $s($k[--$j]); /*5748*/
			$k[$j++] = _3h; /*5748*/
			for (var _3j = 0, _3i = _3h.length - 1; _3j <= _3i; _3j += 1) { /*5748*/
				var _3k = $k[--$j]; /*5748*/
				$put(_3k, _3j, 48); /*5748*/
				$k[$j++] = _3k; /*5748*/
			} /*5748*/
			var _3l = $k[--$j]; /*5749*/
			var _3o = $cvrs($s(_3l.length), $k[--$j], 2); /*5749*/
			$puti(_3l, _3l.length - _3o.length, _3o); /*5749*/
			$k[$j++] = _3l; /*5749*/
		}; /*5750*/
		if ($eq($1.method, "00")) { /*5755*/
			$1.cdf = $a([]); /*5753*/
			$1.gpf = $a([]); /*5754*/
		} /*5754*/
		if ($eq($1.method, "1")) { /*5762*/
			$k[$j++] = "cdf"; /*5758*/
			$k[$j++] = $geti($1.aival["01"], 0, 13); /*5758*/
			$1.conv13to44(); /*5758*/
			var _3w = $k[--$j]; /*5758*/
			$1[$k[--$j]] = _3w; /*5758*/
			$k[$j++] = "cdf"; /*5759*/
			$k[$j++] = Infinity; /*5759*/
			var _3y = $1.cdf; /*5759*/
			for (var _3z = 0, _40 = _3y.length; _3z < _40; _3z++) { /*5759*/
				$k[$j++] = $get(_3y, _3z) - 48; /*5759*/
			} /*5759*/
			var _42 = $a(); /*5759*/
			$1[$k[--$j]] = _42; /*5759*/
			$1.gpf = $a([]); /*5760*/
			$1.ais = $geti($1.ais, 1, $1.ais.length - 1); /*5761*/
		} /*5761*/
		if ($eq($1.method, "0100")) { /*5771*/
			$1.cdf = $s(55); /*5765*/
			$k[$j++] = $1.cdf; /*5766*/
			$k[$j++] = 0; /*5766*/
			$k[$j++] = $geti($1.aival["01"], 1, 12); /*5766*/
			$1.conv12to40(); /*5766*/
			var _4E = $k[--$j]; /*5766*/
			var _4F = $k[--$j]; /*5766*/
			$puti($k[--$j], _4F, _4E); /*5766*/
			$k[$j++] = $1.cdf; /*5767*/
			$k[$j++] = 40; /*5767*/
			$k[$j++] = ~~$z($1.aival["3103"]); /*5767*/
			$k[$j++] = 15; /*5767*/
			$1.tobin(); /*5767*/
			var _4K = $k[--$j]; /*5767*/
			var _4L = $k[--$j]; /*5767*/
			$puti($k[--$j], _4L, _4K); /*5767*/
			$k[$j++] = "cdf"; /*5768*/
			$k[$j++] = Infinity; /*5768*/
			var _4N = $1.cdf; /*5768*/
			for (var _4O = 0, _4P = _4N.length; _4O < _4P; _4O++) { /*5768*/
				$k[$j++] = $get(_4N, _4O) - 48; /*5768*/
			} /*5768*/
			var _4R = $a(); /*5768*/
			$1[$k[--$j]] = _4R; /*5768*/
			$1.gpf = $a([]); /*5769*/
			$1.ais = $a([]); /*5770*/
		} /*5770*/
		if ($eq($1.method, "0101")) { /*5785*/
			$1.cdf = $s(55); /*5774*/
			$k[$j++] = $1.cdf; /*5775*/
			$k[$j++] = 0; /*5775*/
			$k[$j++] = $geti($1.aival["01"], 1, 12); /*5775*/
			$1.conv12to40(); /*5775*/
			var _4b = $k[--$j]; /*5775*/
			var _4c = $k[--$j]; /*5775*/
			$puti($k[--$j], _4c, _4b); /*5775*/
			if ($eq($get($1.ais, 1), "3202")) { /*5779*/
				$k[$j++] = ~~$z($1.aival["3202"]); /*5777*/
				$k[$j++] = 15; /*5777*/
				$1.tobin(); /*5777*/
			} else { /*5779*/
				$k[$j++] = (~~$z($1.aival["3203"])) + 10000; /*5779*/
				$k[$j++] = 15; /*5779*/
				$1.tobin(); /*5779*/
			} /*5779*/
			$puti($1.cdf, 40, $k[--$j]); /*5781*/
			$k[$j++] = "cdf"; /*5782*/
			$k[$j++] = Infinity; /*5782*/
			var _4m = $1.cdf; /*5782*/
			for (var _4n = 0, _4o = _4m.length; _4n < _4o; _4n++) { /*5782*/
				$k[$j++] = $get(_4m, _4n) - 48; /*5782*/
			} /*5782*/
			var _4q = $a(); /*5782*/
			$1[$k[--$j]] = _4q; /*5782*/
			$1.gpf = $a([]); /*5783*/
			$1.ais = $a([]); /*5784*/
		} /*5784*/
		if ($1.method.length == 7) { /*5805*/
			$1.cdf = $s(76); /*5788*/
			$k[$j++] = $1.cdf; /*5789*/
			$k[$j++] = 0; /*5789*/
			$k[$j++] = $geti($1.aival["01"], 1, 12); /*5789*/
			$1.conv12to40(); /*5789*/
			var _50 = $k[--$j]; /*5789*/
			var _51 = $k[--$j]; /*5789*/
			$puti($k[--$j], _51, _50); /*5789*/
			var _53 = $s(6); /*5790*/
			$puti(_53, 0, $geti($get($1.ais, 1), 3, 1)); /*5790*/
			$puti(_53, 1, $geti($get($1.aival, $get($1.ais, 1)), 1, 5)); /*5791*/
			$k[$j++] = ~~$z(_53); /*5791*/
			$k[$j++] = 20; /*5791*/
			$1.tobin(); /*5791*/
			$puti($1.cdf, 40, $k[--$j]); /*5792*/
			if ($1.ais.length == 3) { /*5799*/
				var _5I = $get($1.aival, $get($1.ais, 2)); /*5794*/
				$k[$j++] = ((~~$z($geti(_5I, 0, 2))) * 384) + ((((~~$z($geti(_5I, 2, 2))) - 1) * 32) + (~~$z($geti(_5I, 4, 2)))); /*5797*/
			} else { /*5799*/
				$k[$j++] = 38400; /*5799*/
			} /*5799*/
			$k[$j++] = 16; /*5801*/
			$1.tobin(); /*5801*/
			$puti($1.cdf, 60, $k[--$j]); /*5801*/
			$k[$j++] = "cdf"; /*5802*/
			$k[$j++] = Infinity; /*5802*/
			var _5O = $1.cdf; /*5802*/
			for (var _5P = 0, _5Q = _5O.length; _5P < _5Q; _5P++) { /*5802*/
				$k[$j++] = $get(_5O, _5P) - 48; /*5802*/
			} /*5802*/
			var _5S = $a(); /*5802*/
			$1[$k[--$j]] = _5S; /*5802*/
			$1.gpf = $a([]); /*5803*/
			$1.ais = $a([]); /*5804*/
		} /*5804*/
		if ($eq($1.method, "01100")) { /*5814*/
			$1.cdf = $s(42); /*5808*/
			$k[$j++] = $1.cdf; /*5809*/
			$k[$j++] = 0; /*5809*/
			$k[$j++] = $geti($1.aival["01"], 1, 12); /*5809*/
			$1.conv12to40(); /*5809*/
			var _5c = $k[--$j]; /*5809*/
			var _5d = $k[--$j]; /*5809*/
			$puti($k[--$j], _5d, _5c); /*5809*/
			$k[$j++] = $1.cdf; /*5810*/
			$k[$j++] = 40; /*5810*/
			$k[$j++] = ~~$z($geti($get($1.ais, 1), 3, 1)); /*5810*/
			$k[$j++] = 2; /*5810*/
			$1.tobin(); /*5810*/
			var _5j = $k[--$j]; /*5810*/
			var _5k = $k[--$j]; /*5810*/
			$puti($k[--$j], _5k, _5j); /*5810*/
			$k[$j++] = "cdf"; /*5811*/
			$k[$j++] = Infinity; /*5811*/
			var _5m = $1.cdf; /*5811*/
			for (var _5n = 0, _5o = _5m.length; _5n < _5o; _5n++) { /*5811*/
				$k[$j++] = $get(_5m, _5n) - 48; /*5811*/
			} /*5811*/
			var _5q = $a(); /*5811*/
			$1[$k[--$j]] = _5q; /*5811*/
			$k[$j++] = "gpf"; /*5812*/
			$k[$j++] = Infinity; /*5812*/
			$forall($get($1.aival, $get($1.ais, 1))); /*5812*/
			var _5w = $a(); /*5812*/
			$1[$k[--$j]] = _5w; /*5812*/
			$1.ais = $geti($1.ais, 2, $1.ais.length - 2); /*5813*/
		} /*5813*/
		if ($eq($1.method, "01101")) { /*5824*/
			$1.cdf = $s(52); /*5817*/
			$k[$j++] = $1.cdf; /*5818*/
			$k[$j++] = 0; /*5818*/
			$k[$j++] = $geti($1.aival["01"], 1, 12); /*5818*/
			$1.conv12to40(); /*5818*/
			var _67 = $k[--$j]; /*5818*/
			var _68 = $k[--$j]; /*5818*/
			$puti($k[--$j], _68, _67); /*5818*/
			$k[$j++] = $1.cdf; /*5819*/
			$k[$j++] = 40; /*5819*/
			$k[$j++] = ~~$z($geti($get($1.ais, 1), 3, 1)); /*5819*/
			$k[$j++] = 2; /*5819*/
			$1.tobin(); /*5819*/
			var _6E = $k[--$j]; /*5819*/
			var _6F = $k[--$j]; /*5819*/
			$puti($k[--$j], _6F, _6E); /*5819*/
			$k[$j++] = $1.cdf; /*5820*/
			$k[$j++] = 42; /*5820*/
			$k[$j++] = ~~$z($geti($get($1.aival, $get($1.ais, 1)), 0, 3)); /*5820*/
			$k[$j++] = 10; /*5820*/
			$1.tobin(); /*5820*/
			var _6N = $k[--$j]; /*5820*/
			var _6O = $k[--$j]; /*5820*/
			$puti($k[--$j], _6O, _6N); /*5820*/
			$k[$j++] = "cdf"; /*5821*/
			$k[$j++] = Infinity; /*5821*/
			var _6Q = $1.cdf; /*5821*/
			for (var _6R = 0, _6S = _6Q.length; _6R < _6S; _6R++) { /*5821*/
				$k[$j++] = $get(_6Q, _6R) - 48; /*5821*/
			} /*5821*/
			var _6U = $a(); /*5821*/
			$1[$k[--$j]] = _6U; /*5821*/
			$k[$j++] = "gpf"; /*5822*/
			$k[$j++] = Infinity; /*5822*/
			var _6Z = $get($1.aival, $get($1.ais, 1)); /*5822*/
			$forall($geti(_6Z, 3, _6Z.length - 3)); /*5822*/
			var _6b = $a(); /*5822*/
			$1[$k[--$j]] = _6b; /*5822*/
			$1.ais = $geti($1.ais, 2, $1.ais.length - 2); /*5823*/
		} /*5823*/
		if ($1.gpfallow) { /*5830*/
			$1.vlf = $a(2); /*5828*/
		} else { /*5830*/
			$1.vlf = $a([]); /*5830*/
		} /*5830*/
		$1.aifixed = {}; /*5836*/
		$k[$j++] = Infinity; /*5838*/
		for (var _6j = 0; _6j <= 4; _6j += 1) { /*5838*/
			$k[$j++] = _6j; /*5838*/
		} /*5838*/
		var _6k = $a(); /*5838*/
		for (var _6l = 0, _6m = _6k.length; _6l < _6m; _6l++) { /*5841*/
			var _6p = $strcpy($s(2), "00"); /*5840*/
			$put(_6p, 1, $get(_6k, _6l) + 48); /*5840*/
			$put($1.aifixed, _6p, _6p); /*5840*/
		} /*5840*/
		$k[$j++] = Infinity; /*5846*/
		for (var _6r = 11; _6r <= 20; _6r += 1) { /*5843*/
			$k[$j++] = _6r; /*5843*/
		} /*5843*/
		$k[$j++] = 23; /*5845*/
		for (var _6s = 31; _6s <= 36; _6s += 1) { /*5845*/
			$k[$j++] = _6s; /*5845*/
		} /*5845*/
		$k[$j++] = 41; /*5846*/
		var _6t = $a(); /*5846*/
		for (var _6u = 0, _6v = _6t.length; _6u < _6v; _6u++) { /*5849*/
			var _6y = $cvrs($s(2), $get(_6t, _6u), 10); /*5848*/
			$put($1.aifixed, _6y, _6y); /*5848*/
		} /*5848*/
		$1.fnc1 = -1; /*5851*/
		$1.lnumeric = -2; /*5851*/
		$1.lalphanumeric = -3; /*5851*/
		$1.liso646 = -4; /*5851*/
		$k[$j++] = "numeric"; /*5863*/
		$k[$j++] = Infinity; /*5863*/
		for (var _70 = 0; _70 <= 119; _70 += 1) { /*5862*/
			var _72 = $strcpy($s(2), "00"); /*5855*/
			var _74 = $cvrs($s(2), _70, 11); /*5855*/
			$puti(_72, 2 - _74.length, _74); /*5856*/
			$k[$j++] = _70; /*5857*/
			$k[$j++] = _72; /*5857*/
			if ($get(_72, 0) == 65) { /*5857*/
				var _76 = $k[--$j]; /*5857*/
				$put(_76, 0, 94); /*5857*/
				$k[$j++] = _76; /*5857*/
			} /*5857*/
			var _77 = $k[--$j]; /*5858*/
			$k[$j++] = _77; /*5858*/
			if ($get(_77, 1) == 65) { /*5858*/
				var _79 = $k[--$j]; /*5858*/
				$put(_79, 1, 94); /*5858*/
				$k[$j++] = _79; /*5858*/
			} /*5858*/
			var _7A = $k[--$j]; /*5859*/
			var _7D = $strcpy($s(7), "0000000"); /*5860*/
			var _7F = $cvrs($s(7), $k[--$j] + 8, 2); /*5860*/
			$puti(_7D, 7 - _7F.length, _7F); /*5861*/
			$k[$j++] = _7A; /*5861*/
			$k[$j++] = _7D; /*5861*/
		} /*5861*/
		$k[$j++] = $1.lalphanumeric; /*5863*/
		$k[$j++] = "0000"; /*5863*/
		var _7H = $d(); /*5863*/
		$1[$k[--$j]] = _7H; /*5864*/
		$k[$j++] = "alphanumeric"; /*5873*/
		$k[$j++] = Infinity; /*5873*/
		for (var _7J = 48; _7J <= 57; _7J += 1) { /*5867*/
			$k[$j++] = _7J; /*5867*/
			$k[$j++] = _7J - 43; /*5867*/
			$k[$j++] = 5; /*5867*/
			$1.tobin(); /*5867*/
		} /*5867*/
		$k[$j++] = $1.fnc1; /*5869*/
		$k[$j++] = "01111"; /*5869*/
		for (var _7L = 65; _7L <= 90; _7L += 1) { /*5869*/
			$k[$j++] = _7L; /*5869*/
			$k[$j++] = _7L - 33; /*5869*/
			$k[$j++] = 6; /*5869*/
			$1.tobin(); /*5869*/
		} /*5869*/
		$k[$j++] = 42; /*5871*/
		$k[$j++] = "111010"; /*5871*/
		for (var _7M = 44; _7M <= 47; _7M += 1) { /*5871*/
			$k[$j++] = _7M; /*5871*/
			$k[$j++] = _7M + 15; /*5871*/
			$k[$j++] = 6; /*5871*/
			$1.tobin(); /*5871*/
		} /*5871*/
		$k[$j++] = $1.lnumeric; /*5873*/
		$k[$j++] = "000"; /*5873*/
		$k[$j++] = $1.liso646; /*5873*/
		$k[$j++] = "00100"; /*5873*/
		var _7P = $d(); /*5873*/
		$1[$k[--$j]] = _7P; /*5874*/
		$k[$j++] = "iso646"; /*5888*/
		$k[$j++] = Infinity; /*5888*/
		for (var _7R = 48; _7R <= 57; _7R += 1) { /*5877*/
			$k[$j++] = _7R; /*5877*/
			$k[$j++] = _7R - 43; /*5877*/
			$k[$j++] = 5; /*5877*/
			$1.tobin(); /*5877*/
		} /*5877*/
		$k[$j++] = $1.fnc1; /*5879*/
		$k[$j++] = "01111"; /*5879*/
		for (var _7T = 65; _7T <= 90; _7T += 1) { /*5879*/
			$k[$j++] = _7T; /*5879*/
			$k[$j++] = _7T - 1; /*5879*/
			$k[$j++] = 7; /*5879*/
			$1.tobin(); /*5879*/
		} /*5879*/
		for (var _7U = 97; _7U <= 122; _7U += 1) { /*5880*/
			$k[$j++] = _7U; /*5880*/
			$k[$j++] = _7U - 7; /*5880*/
			$k[$j++] = 7; /*5880*/
			$1.tobin(); /*5880*/
		} /*5880*/
		$k[$j++] = 33; /*5883*/
		$k[$j++] = "11101000"; /*5883*/
		$k[$j++] = 34; /*5883*/
		$k[$j++] = "11101001"; /*5883*/
		for (var _7V = 37; _7V <= 47; _7V += 1) { /*5883*/
			$k[$j++] = _7V; /*5883*/
			$k[$j++] = _7V + 197; /*5883*/
			$k[$j++] = 8; /*5883*/
			$1.tobin(); /*5883*/
		} /*5883*/
		for (var _7W = 58; _7W <= 63; _7W += 1) { /*5884*/
			$k[$j++] = _7W; /*5884*/
			$k[$j++] = _7W + 187; /*5884*/
			$k[$j++] = 8; /*5884*/
			$1.tobin(); /*5884*/
		} /*5884*/
		$k[$j++] = 95; /*5888*/
		$k[$j++] = "11111011"; /*5888*/
		$k[$j++] = 32; /*5888*/
		$k[$j++] = "11111100"; /*5888*/
		$k[$j++] = $1.lnumeric; /*5888*/
		$k[$j++] = "000"; /*5888*/
		$k[$j++] = $1.lalphanumeric; /*5888*/
		$k[$j++] = "00100"; /*5888*/
		var _7Z = $d(); /*5888*/
		$1[$k[--$j]] = _7Z; /*5889*/
		for (var _7d = 0, _7c = $1.ais.length - 1; _7d <= _7c; _7d += 1) { /*5907*/
			$1.i = _7d; /*5893*/
			$1.ai = $get($1.ais, $1.i); /*5894*/
			$1.val = $get($1.aival, $1.ai); /*5895*/
			var _7n = $a(($1.gpf.length + $1.ai.length) + $1.val.length); /*5896*/
			$puti(_7n, 0, $1.gpf); /*5897*/
			$k[$j++] = _7n; /*5898*/
			$k[$j++] = _7n; /*5898*/
			$k[$j++] = $1.gpf.length; /*5898*/
			$k[$j++] = $1.ai; /*5898*/
			$k[$j++] = Infinity; /*5898*/
			var _7r = $k[--$j]; /*5898*/
			var _7s = $k[--$j]; /*5898*/
			$k[$j++] = _7r; /*5898*/
			$forall(_7s); /*5898*/
			var _7t = $a(); /*5898*/
			var _7u = $k[--$j]; /*5898*/
			$puti($k[--$j], _7u, _7t); /*5898*/
			var _7w = $k[--$j]; /*5899*/
			$k[$j++] = _7w; /*5899*/
			$k[$j++] = _7w; /*5899*/
			$k[$j++] = $1.gpf.length + $1.ai.length; /*5899*/
			$k[$j++] = $1.val; /*5899*/
			$k[$j++] = Infinity; /*5899*/
			var _80 = $k[--$j]; /*5899*/
			var _81 = $k[--$j]; /*5899*/
			$k[$j++] = _80; /*5899*/
			$forall(_81); /*5899*/
			var _82 = $a(); /*5899*/
			var _83 = $k[--$j]; /*5899*/
			$puti($k[--$j], _83, _82); /*5899*/
			$1.gpf = $k[--$j]; /*5900*/
			var _8B = $get($1.aifixed, $geti($1.ai, 0, 2)) !== undefined; /*5901*/
			if (($1.i != ($1.ais.length - 1)) && (!_8B)) { /*5906*/
				var _8D = $a($1.gpf.length + 1); /*5902*/
				$puti(_8D, 0, $1.gpf); /*5903*/
				$put(_8D, $1.gpf.length, $1.fnc1); /*5904*/
				$1.gpf = _8D; /*5905*/
			} /*5905*/
		} /*5905*/
		$1.rembits = function() {
			var _8H = $k[--$j]; /*5911*/
			var _8I = 48; /*5913*/
			var _8J = (~~Math.ceil(_8H / 12)) * 12; /*5913*/
			if (((~~Math.ceil(_8H / 12)) * 12) < 48) { /*5913*/
				var _ = _8I; /*5913*/
				_8I = _8J; /*5913*/
				_8J = _; /*5913*/
			} /*5913*/
			var _8K = ~~(_8J / 12); /*5914*/
			$k[$j++] = _8H; /*5918*/
			$k[$j++] = _8J; /*5918*/
			$k[$j++] = _8K; /*5918*/
			if ((_8K % $1.segments) == 1) { /*5917*/
				var _8M = $k[--$j]; /*5915*/
				var _8N = $k[--$j]; /*5915*/
				$k[$j++] = (_8M + 1) * 12; /*5915*/
			} else { /*5917*/
				$j--; /*5917*/
			} /*5917*/
			var _8O = $k[--$j]; /*5919*/
			var _8P = $k[--$j]; /*5919*/
			$k[$j++] = _8O - _8P; /*5919*/
		}; /*5920*/
		$1.encode = function() {
			var _8Q = $k[--$j]; /*5923*/
			$k[$j++] = _8Q; /*5923*/
			if ($ne(_8Q, "raw")) { /*5923*/
				var _8R = $k[--$j]; /*5923*/
				var _8T = $get(_8R, $k[--$j]); /*5923*/
				$k[$j++] = _8T; /*5923*/
			} else { /*5923*/
				$j--; /*5923*/
			} /*5923*/
			$k[$j++] = Infinity; /*5924*/
			var _8U = $k[--$j]; /*5924*/
			var _8V = $k[--$j]; /*5924*/
			$k[$j++] = _8U; /*5924*/
			$forall(_8V, function() { /*5924*/
				var _8W = $k[--$j]; /*5924*/
				$k[$j++] = _8W - 48; /*5924*/
			}) /*5924*/
			var _8X = $a(); /*5924*/
			$puti($1.gpfenc, $1.j, _8X); /*5926*/
			$1.j = _8X.length + $1.j; /*5927*/
		}; /*5928*/
		$k[$j++] = "numericruns"; /*5931*/
		$k[$j++] = Infinity; /*5931*/
		for (var _8c = 0, _8d = $1.gpf.length; _8c < _8d; _8c++) { /*5931*/
			$k[$j++] = 0; /*5931*/
		} /*5931*/
		$k[$j++] = 0; /*5931*/
		$k[$j++] = -1; /*5931*/
		var _8e = $a(); /*5931*/
		$1[$k[--$j]] = _8e; /*5931*/
		$k[$j++] = "alphanumericruns"; /*5932*/
		$k[$j++] = Infinity; /*5932*/
		for (var _8h = 0, _8i = $1.gpf.length; _8h < _8i; _8h++) { /*5932*/
			$k[$j++] = 0; /*5932*/
		} /*5932*/
		$k[$j++] = 0; /*5932*/
		var _8j = $a(); /*5932*/
		$1[$k[--$j]] = _8j; /*5932*/
		$k[$j++] = "nextiso646only"; /*5933*/
		$k[$j++] = Infinity; /*5933*/
		for (var _8m = 0, _8n = $1.gpf.length; _8m < _8n; _8m++) { /*5933*/
			$k[$j++] = 0; /*5933*/
		} /*5933*/
		$k[$j++] = 9999; /*5933*/
		var _8o = $a(); /*5933*/
		$1[$k[--$j]] = _8o; /*5933*/
		for (var _8r = $1.gpf.length - 1; _8r >= 0; _8r -= 1) { /*5955*/
			$1.i = _8r; /*5935*/
			var _8w = $strcpy($s(2), "00"); /*5937*/
			var _8z = $get($1.gpf, $1.i); /*5938*/
			$k[$j++] = $get($1.gpf, $1.i); /*5938*/
			$k[$j++] = _8w; /*5938*/
			$k[$j++] = _8w; /*5938*/
			$k[$j++] = 0; /*5938*/
			$k[$j++] = _8z; /*5938*/
			if (_8z == $1.fnc1) { /*5938*/
				$j--; /*5938*/
				$k[$j++] = 94; /*5938*/
			} /*5938*/
			var _91 = $k[--$j]; /*5938*/
			var _92 = $k[--$j]; /*5938*/
			$put($k[--$j], _92, _91); /*5938*/
			if ($1.i < ($1.gpf.length - 1)) { /*5939*/
				var _96 = $k[--$j]; /*5939*/
				var _99 = $get($1.gpf, $1.i + 1); /*5939*/
				$k[$j++] = _96; /*5939*/
				$k[$j++] = _96; /*5939*/
				$k[$j++] = 1; /*5939*/
				$k[$j++] = _99; /*5939*/
				if (_99 == $1.fnc1) { /*5939*/
					$j--; /*5939*/
					$k[$j++] = 94; /*5939*/
				} /*5939*/
				var _9B = $k[--$j]; /*5939*/
				var _9C = $k[--$j]; /*5939*/
				$put($k[--$j], _9C, _9B); /*5939*/
			} /*5939*/
			var _9G = $get($1.numeric, $k[--$j]) !== undefined; /*5940*/
			if (_9G) { /*5943*/
				$put($1.numericruns, $1.i, $get($1.numericruns, $1.i + 2) + 2); /*5941*/
			} else { /*5943*/
				$put($1.numericruns, $1.i, 0); /*5943*/
			} /*5943*/
			var _9O = $k[--$j]; /*5945*/
			var _9Q = $get($1.alphanumeric, _9O) !== undefined; /*5945*/
			$k[$j++] = _9O; /*5949*/
			if (_9Q) { /*5948*/
				$put($1.alphanumericruns, $1.i, $get($1.alphanumericruns, $1.i + 1) + 1); /*5946*/
			} else { /*5948*/
				$put($1.alphanumericruns, $1.i, 0); /*5948*/
			} /*5948*/
			var _9Y = $k[--$j]; /*5950*/
			var _9a = $get($1.iso646, _9Y) !== undefined; /*5950*/
			var _9c = $get($1.alphanumeric, _9Y) !== undefined; /*5950*/
			if (_9a && (!_9c)) { /*5953*/
				$put($1.nextiso646only, $1.i, 0); /*5951*/
			} else { /*5953*/
				$put($1.nextiso646only, $1.i, $get($1.nextiso646only, $1.i + 1) + 1); /*5953*/
			} /*5953*/
		} /*5953*/
		$1.gpfenc = $a(252); /*5958*/
		$1.i = 0; /*5959*/
		$1.j = 0; /*5959*/
		$1.mode = "numeric"; /*5959*/
		for (;;) { /*6049*/
			if ($1.i == $1.gpf.length) { /*5961*/
				break; /*5961*/
			} /*5961*/
			for (;;) { /*6048*/
				if ($eq($1.mode, "numeric")) { /*5997*/
					if ($1.i <= ($1.gpf.length - 2)) { /*5994*/
						var _9q = $s(2); /*5966*/
						var _9t = $get($1.gpf, $1.i); /*5967*/
						$k[$j++] = _9q; /*5967*/
						$k[$j++] = _9q; /*5967*/
						$k[$j++] = 0; /*5967*/
						$k[$j++] = _9t; /*5967*/
						if (_9t == $1.fnc1) { /*5967*/
							$j--; /*5967*/
							$k[$j++] = 94; /*5967*/
						} /*5967*/
						var _9v = $k[--$j]; /*5967*/
						var _9w = $k[--$j]; /*5967*/
						$put($k[--$j], _9w, _9v); /*5967*/
						var _9y = $k[--$j]; /*5968*/
						var _A1 = $get($1.gpf, $1.i + 1); /*5968*/
						$k[$j++] = _9y; /*5968*/
						$k[$j++] = _9y; /*5968*/
						$k[$j++] = 1; /*5968*/
						$k[$j++] = _A1; /*5968*/
						if (_A1 == $1.fnc1) { /*5968*/
							$j--; /*5968*/
							$k[$j++] = 94; /*5968*/
						} /*5968*/
						var _A3 = $k[--$j]; /*5968*/
						var _A4 = $k[--$j]; /*5968*/
						$put($k[--$j], _A4, _A3); /*5968*/
						var _A6 = $k[--$j]; /*5969*/
						var _A8 = $get($1.numeric, _A6) !== undefined; /*5969*/
						$k[$j++] = _A6; /*5973*/
						if (_A8) { /*5973*/
							$k[$j++] = $1.numeric; /*5970*/
							$1.encode(); /*5970*/
							$1.i = $1.i + 2; /*5971*/
							break; /*5972*/
						} /*5972*/
						$j--; /*5974*/
						$k[$j++] = $1.lalphanumeric; /*5975*/
						$k[$j++] = $1.numeric; /*5975*/
						$1.encode(); /*5975*/
						$1.mode = "alphanumeric"; /*5976*/
						break; /*5977*/
					} else { /*5994*/
						var _AF = $get($1.gpf, $1.i); /*5979*/
						if ((_AF < 48) || (_AF > 57)) { /*5983*/
							$k[$j++] = $1.lalphanumeric; /*5980*/
							$k[$j++] = $1.numeric; /*5980*/
							$1.encode(); /*5980*/
							$1.mode = "alphanumeric"; /*5981*/
							break; /*5982*/
						} /*5982*/
						$k[$j++] = "rem"; /*5984*/
						$k[$j++] = ((((12 + 1) + $1.method.length) + $1.vlf.length) + $1.cdf.length) + $1.j; /*5984*/
						$1.rembits(); /*5984*/
						var _AM = $k[--$j]; /*5984*/
						$1[$k[--$j]] = _AM; /*5984*/
						if (($1.rem >= 4) && ($1.rem <= 6)) { /*5994*/
							var _AT = $geti($strcpy($s(6), "000000"), 0, $1.rem); /*5986*/
							var _AY = $cvrs($s(4), $get($1.gpf, $1.i) - 47, 2); /*5987*/
							$puti(_AT, 4 - _AY.length, _AY); /*5988*/
							$k[$j++] = _AT; /*5988*/
							$k[$j++] = "raw"; /*5988*/
							$1.encode(); /*5988*/
							$1.i = $1.i + 1; /*5989*/
							break; /*5990*/
						} else { /*5994*/
							var _Aa = $s(2); /*5992*/
							$put(_Aa, 0, $get($1.gpf, $1.i)); /*5992*/
							$put(_Aa, 1, 94); /*5992*/
							$k[$j++] = _Aa; /*5992*/
							$k[$j++] = $1.numeric; /*5992*/
							$1.encode(); /*5992*/
							$1.i = $1.i + 1; /*5993*/
							break; /*5994*/
						} /*5994*/
					} /*5994*/
				} /*5994*/
				if ($eq($1.mode, "alphanumeric")) { /*6024*/
					if ($get($1.gpf, $1.i) == $1.fnc1) { /*6005*/
						$k[$j++] = $1.fnc1; /*6001*/
						$k[$j++] = $1.alphanumeric; /*6001*/
						$1.encode(); /*6001*/
						$1.mode = "numeric"; /*6002*/
						$1.i = $1.i + 1; /*6003*/
						break; /*6004*/
					} /*6004*/
					var _Aq = $get($1.gpf, $1.i); /*6006*/
					var _As = $get($1.iso646, _Aq) !== undefined; /*6006*/
					var _Au = $get($1.alphanumeric, _Aq) !== undefined; /*6006*/
					if (_As && (!_Au)) { /*6010*/
						$k[$j++] = $1.liso646; /*6007*/
						$k[$j++] = $1.alphanumeric; /*6007*/
						$1.encode(); /*6007*/
						$1.mode = "iso646"; /*6008*/
						break; /*6009*/
					} /*6009*/
					if ($get($1.numericruns, $1.i) >= 6) { /*6015*/
						$k[$j++] = $1.lnumeric; /*6012*/
						$k[$j++] = $1.alphanumeric; /*6012*/
						$1.encode(); /*6012*/
						$1.mode = "numeric"; /*6013*/
						break; /*6014*/
					} /*6014*/
					var _B4 = $get($1.numericruns, $1.i); /*6016*/
					if ((_B4 >= 4) && ((_B4 + $1.i) == $1.gpf.length)) { /*6020*/
						$k[$j++] = $1.lnumeric; /*6017*/
						$k[$j++] = $1.alphanumeric; /*6017*/
						$1.encode(); /*6017*/
						$1.mode = "numeric"; /*6018*/
						break; /*6019*/
					} /*6019*/
					$k[$j++] = $get($1.gpf, $1.i); /*6021*/
					$k[$j++] = $1.alphanumeric; /*6021*/
					$1.encode(); /*6021*/
					$1.i = $1.i + 1; /*6022*/
					break; /*6023*/
				} /*6023*/
				if ($eq($1.mode, "iso646")) { /*6046*/
					if ($get($1.gpf, $1.i) == $1.fnc1) { /*6032*/
						$k[$j++] = $1.fnc1; /*6028*/
						$k[$j++] = $1.iso646; /*6028*/
						$1.encode(); /*6028*/
						$1.mode = "numeric"; /*6029*/
						$1.i = $1.i + 1; /*6030*/
						break; /*6031*/
					} /*6031*/
					if (($get($1.numericruns, $1.i) >= 4) && ($get($1.nextiso646only, $1.i) >= 10)) { /*6037*/
						$k[$j++] = $1.lnumeric; /*6034*/
						$k[$j++] = $1.iso646; /*6034*/
						$1.encode(); /*6034*/
						$1.mode = "numeric"; /*6035*/
						break; /*6036*/
					} /*6036*/
					if (($get($1.alphanumericruns, $1.i) >= 5) && ($get($1.nextiso646only, $1.i) >= 10)) { /*6042*/
						$k[$j++] = $1.lalphanumeric; /*6039*/
						$k[$j++] = $1.iso646; /*6039*/
						$1.encode(); /*6039*/
						$1.mode = "alphanumeric"; /*6040*/
						break; /*6041*/
					} /*6041*/
					$k[$j++] = $get($1.gpf, $1.i); /*6043*/
					$k[$j++] = $1.iso646; /*6043*/
					$1.encode(); /*6043*/
					$1.i = $1.i + 1; /*6044*/
					break; /*6045*/
				} /*6045*/
			} /*6045*/
		} /*6045*/
		$1.gpf = $geti($1.gpfenc, 0, $1.j); /*6050*/
		var _Bo = ((((1 + 12) + $1.method.length) + $1.vlf.length) + $1.cdf.length) + $1.gpf.length; /*6054*/
		$k[$j++] = _Bo; /*6054*/
		$k[$j++] = _Bo; /*6054*/
		$1.rembits(); /*6054*/
		var _Bp = $k[--$j]; /*6054*/
		$1.pad = $a(_Bp); /*6054*/
		$k[$j++] = _Bp; /*6061*/
		if ($1.vlf.length != 0) { /*6060*/
			var _Bs = $k[--$j]; /*6056*/
			var _Bu = ~~(($k[--$j] + _Bs) / 12); /*6057*/
			$put($1.vlf, 0, _Bu % 2); /*6057*/
			var _Bw = (_Bu <= 14) ? 0 : 1; /*6058*/
			$put($1.vlf, 1, _Bw); /*6058*/
		} else { /*6060*/
			$j -= 2; /*6060*/
		} /*6060*/
		if ($1.pad.length > 0) { /*6070*/
			for (var _C1 = 0, _C0 = $1.pad.length - 1; _C1 <= _C0; _C1 += 5) { /*6066*/
				$1.i = _C1; /*6064*/
				var _C2 = $1.pad; /*6065*/
				var _C3 = $1.i; /*6065*/
				var _C4 = $a([0, 0, 1, 0, 0]); /*6065*/
				var _C5 = $1.pad; /*6065*/
				var _C6 = $1.i; /*6065*/
				var _C7 = 5; /*6065*/
				var _C8 = _C5.length - _C6; /*6065*/
				if ((_C5.length - _C6) > 5) { /*6065*/
					var _ = _C7; /*6065*/
					_C7 = _C8; /*6065*/
					_C8 = _; /*6065*/
				} /*6065*/
				$puti(_C2, _C3, $geti(_C4, 0, _C8)); /*6065*/
			} /*6065*/
			if ($eq($1.mode, "numeric")) { /*6069*/
				$k[$j++] = "pad"; /*6068*/
				$k[$j++] = Infinity; /*6068*/
				$k[$j++] = 0; /*6068*/
				$k[$j++] = 0; /*6068*/
				$k[$j++] = 0; /*6068*/
				$k[$j++] = 0; /*6068*/
				$aload($1.pad); /*6068*/
				var _CE = $geti($a(), 0, $1.pad.length); /*6068*/
				$1[$k[--$j]] = _CE; /*6068*/
			} /*6068*/
		} /*6068*/
		$k[$j++] = "binval"; /*6079*/
		$k[$j++] = Infinity; /*6079*/
		var _CH = $1.linkage ? 1 : 0; /*6074*/
		$k[$j++] = _CH; /*6075*/
		$forall($1.method, function() { /*6075*/
			var _CJ = $k[--$j]; /*6075*/
			$k[$j++] = _CJ - 48; /*6075*/
		}) /*6075*/
		$aload($1.vlf); /*6076*/
		$aload($1.cdf); /*6077*/
		$aload($1.gpf); /*6078*/
		$aload($1.pad); /*6079*/
		var _CO = $a(); /*6079*/
		$1[$k[--$j]] = _CO; /*6080*/
		$1.datalen = ~~($1.binval.length / 12); /*6081*/
		$1.ncr = function() {
			var _CR = $k[--$j]; /*6084*/
			var _CS = $k[--$j]; /*6084*/
			var _CT = _CS - _CR; /*6084*/
			if (_CR < (_CS - _CR)) { /*6084*/
				var _ = _CT; /*6084*/
				_CT = _CR; /*6084*/
				_CR = _; /*6084*/
			} /*6084*/
			$k[$j++] = _CT; /*6091*/
			$k[$j++] = 1; /*6091*/
			$k[$j++] = 1; /*6091*/
			for (var _CV = _CS, _CU = _CR + 1; _CV >= _CU; _CV -= 1) { /*6091*/
				var _CW = $k[--$j]; /*6087*/
				var _CX = $k[--$j]; /*6088*/
				var _CY = $k[--$j]; /*6088*/
				$k[$j++] = _CY; /*6090*/
				$k[$j++] = _CX; /*6090*/
				$k[$j++] = _CW * _CV; /*6090*/
				if ($le(_CX, _CY)) { /*6090*/
					var _CZ = $k[--$j]; /*6089*/
					var _Ca = $k[--$j]; /*6089*/
					$k[$j++] = _Ca + 1; /*6089*/
					$k[$j++] = ~~(_CZ / _Ca); /*6089*/
				} /*6089*/
			} /*6089*/
			for (;;) { /*6095*/
				var _Cb = $k[--$j]; /*6093*/
				var _Cc = $k[--$j]; /*6093*/
				var _Cd = $k[--$j]; /*6093*/
				$k[$j++] = _Cd; /*6093*/
				$k[$j++] = _Cc; /*6093*/
				$k[$j++] = _Cb; /*6093*/
				if ($gt(_Cc, _Cd)) { /*6093*/
					break; /*6093*/
				} /*6093*/
				var _Ce = $k[--$j]; /*6094*/
				var _Cf = $k[--$j]; /*6094*/
				$k[$j++] = _Cf + 1; /*6094*/
				$k[$j++] = ~~(_Ce / _Cf); /*6094*/
			} /*6094*/
			var _Cg = $k[--$j]; /*6096*/
			var _Ch = $k[--$j]; /*6096*/
			var _Ci = $k[--$j]; /*6096*/
			$k[$j++] = _Cg; /*6096*/
		}; /*6097*/
		$1.getRSSwidths = function() {
			$1.oe = $k[--$j]; /*6100*/
			$1.el = $k[--$j]; /*6101*/
			$1.mw = $k[--$j]; /*6102*/
			$1.nm = $k[--$j]; /*6103*/
			$1.val = $k[--$j]; /*6104*/
			$1.out = $a($1.el); /*6105*/
			$1.mask = 0; /*6106*/
			for (var _Cs = 0, _Cr = $1.el - 2; _Cs <= _Cr; _Cs += 1) { /*6133*/
				$1.bar = _Cs; /*6108*/
				$1.ew = 1; /*6109*/
				var _Cu = $1.bar; /*6110*/
				$1.mask = $1.mask | ((_Cu < 0 ? 1 >>> -_Cu : 1 << _Cu)); /*6110*/
				for (;;) { /*6129*/
					$k[$j++] = "sval"; /*6111*/
					$k[$j++] = ($1.nm - $1.ew) - 1; /*6111*/
					$k[$j++] = ($1.el - $1.bar) - 2; /*6111*/
					$1.ncr(); /*6111*/
					var _Cz = $k[--$j]; /*6111*/
					$1[$k[--$j]] = _Cz; /*6111*/
					if (($1.oe && ($1.mask == 0)) && (((($1.nm - $1.ew) - ($1.el * 2)) + ($1.bar * 2)) >= -2)) { /*6114*/
						$k[$j++] = "sval"; /*6113*/
						$k[$j++] = $1.sval; /*6113*/
						$k[$j++] = (($1.nm - $1.ew) - $1.el) + $1.bar; /*6113*/
						$k[$j++] = ($1.el - $1.bar) - 2; /*6113*/
						$1.ncr(); /*6113*/
						var _DE = $k[--$j]; /*6113*/
						var _DF = $k[--$j]; /*6113*/
						$1[$k[--$j]] = _DF - _DE; /*6113*/
					} /*6113*/
					if (($1.el - $1.bar) > 2) { /*6123*/
						$1.lval = 0; /*6116*/
						for (var _DP = ((($1.nm - $1.ew) - $1.el) + $1.bar) + 2, _DO = $1.mw + 1; _DP >= _DO; _DP -= 1) { /*6120*/
							$k[$j++] = (($1.nm - _DP) - $1.ew) - 1; /*6118*/
							$k[$j++] = ($1.el - $1.bar) - 3; /*6118*/
							$1.ncr(); /*6118*/
							$1.lval = $k[--$j] + $1.lval; /*6119*/
						} /*6119*/
						$1.sval = $1.sval - ($1.lval * (($1.el - $1.bar) - 1)); /*6121*/
					} else { /*6123*/
						if (($1.nm - $1.ew) > $1.mw) { /*6123*/
							$1.sval = $1.sval - 1; /*6123*/
						} /*6123*/
					} /*6123*/
					$1.val = $1.val - $1.sval; /*6125*/
					if ($1.val < 0) { /*6126*/
						break; /*6126*/
					} /*6126*/
					$1.ew = $1.ew + 1; /*6127*/
					var _Dj = $1.bar; /*6128*/
					$1.mask = $1.mask & (~((_Dj < 0 ? 1 >>> -_Dj : 1 << _Dj))); /*6128*/
				} /*6128*/
				$1.val = $1.val + $1.sval; /*6130*/
				$1.nm = $1.nm - $1.ew; /*6131*/
				$put($1.out, $1.bar, $1.ew); /*6132*/
			} /*6132*/
			$put($1.out, $1.el - 1, $1.nm); /*6134*/
			$k[$j++] = $1.out; /*6135*/
		}; /*6136*/
		$1.tab174 = $a([347, 0, 12, 5, 7, 2, 87, 4, 1387, 348, 10, 7, 5, 4, 52, 20, 2947, 1388, 8, 9, 4, 5, 30, 52, 3987, 2948, 6, 11, 3, 6, 10, 104, 4191, 3988, 4, 13, 1, 8, 1, 204]); /*6144*/
		$1.dxw = $a($1.datalen); /*6146*/
		for (var _E0 = 0, _Dz = $1.datalen - 1; _E0 <= _Dz; _E0 += 1) { /*6187*/
			$1.x = _E0; /*6150*/
			$1.d = $geti($1.binval, $1.x * 12, 12); /*6152*/
			$k[$j++] = "d"; /*6153*/
			$k[$j++] = 0; /*6153*/
			for (var _E4 = 0; _E4 <= 11; _E4 += 1) { /*6153*/
				$1.j = _E4; /*6153*/
				var _E9 = $k[--$j]; /*6153*/
				$k[$j++] = _E9 + ((~~Math.pow(2, 11 - $1.j)) * $get($1.d, $1.j)); /*6153*/
			} /*6153*/
			var _EA = $k[--$j]; /*6153*/
			$1[$k[--$j]] = _EA; /*6153*/
			$1.j = 0; /*6155*/
			for (;;) { /*6165*/
				if ($le($1.d, $get($1.tab174, $1.j))) { /*6163*/
					$forall($geti($1.tab174, $1.j + 1, 7)); /*6157*/
					$1.dte = $k[--$j]; /*6158*/
					$1.dto = $k[--$j]; /*6158*/
					$1.dmwe = $k[--$j]; /*6159*/
					$1.dmwo = $k[--$j]; /*6159*/
					$1.dele = $k[--$j]; /*6160*/
					$1.delo = $k[--$j]; /*6160*/
					$1.dgs = $k[--$j]; /*6161*/
					break; /*6162*/
				} /*6162*/
				$1.j = $1.j + 8; /*6164*/
			} /*6164*/
			$k[$j++] = "dwo"; /*6167*/
			$k[$j++] = ~~(($1.d - $1.dgs) / $1.dte); /*6167*/
			$k[$j++] = $1.delo; /*6167*/
			$k[$j++] = $1.dmwo; /*6167*/
			$k[$j++] = 4; /*6167*/
			$k[$j++] = true; /*6167*/
			$1.getRSSwidths(); /*6167*/
			var _EW = $k[--$j]; /*6167*/
			$1[$k[--$j]] = _EW; /*6167*/
			$k[$j++] = "dwe"; /*6168*/
			$k[$j++] = ($1.d - $1.dgs) % $1.dte; /*6168*/
			$k[$j++] = $1.dele; /*6168*/
			$k[$j++] = $1.dmwe; /*6168*/
			$k[$j++] = 4; /*6168*/
			$k[$j++] = false; /*6168*/
			$1.getRSSwidths(); /*6168*/
			var _Ed = $k[--$j]; /*6168*/
			$1[$k[--$j]] = _Ed; /*6168*/
			$1.dw = $a(8); /*6170*/
			if (($1.x % 2) == 0) { /*6181*/
				for (var _Eh = 0; _Eh <= 3; _Eh += 1) { /*6176*/
					$1.j = _Eh; /*6173*/
					$put($1.dw, 7 - ($1.j * 2), $get($1.dwo, $1.j)); /*6174*/
					$put($1.dw, 6 - ($1.j * 2), $get($1.dwe, $1.j)); /*6175*/
				} /*6175*/
			} else { /*6181*/
				for (var _Es = 0; _Es <= 3; _Es += 1) { /*6182*/
					$1.j = _Es; /*6179*/
					$put($1.dw, $1.j * 2, $get($1.dwo, $1.j)); /*6180*/
					$put($1.dw, ($1.j * 2) + 1, $get($1.dwe, $1.j)); /*6181*/
				} /*6181*/
			} /*6181*/
			$put($1.dxw, $1.x, $1.dw); /*6185*/
		} /*6185*/
		$1.finderwidths = $a([1, 8, 4, 1, 1, 1, 1, 4, 8, 1, 3, 6, 4, 1, 1, 1, 1, 4, 6, 3, 3, 4, 6, 1, 1, 1, 1, 6, 4, 3, 3, 2, 8, 1, 1, 1, 1, 8, 2, 3, 2, 6, 5, 1, 1, 1, 1, 5, 6, 2, 2, 2, 9, 1, 1, 1, 1, 9, 2, 2]); /*6196*/
		$1.finderseq = $a([$a([0, 1]), $a([0, 3, 2]), $a([0, 5, 2, 7]), $a([0, 9, 2, 7, 4]), $a([0, 9, 2, 7, 6, 11]), $a([0, 9, 2, 7, 8, 11, 10]), $a([0, 1, 2, 3, 4, 5, 6, 7]), $a([0, 1, 2, 3, 4, 5, 6, 9, 8]), $a([0, 1, 2, 3, 4, 5, 6, 9, 10, 11]), $a([0, 1, 2, 3, 4, 7, 6, 9, 8, 11, 10])]); /*6209*/
		$1.seq = $get($1.finderseq, ~~(($1.datalen - 2) / 2)); /*6211*/
		$1.fxw = $a($1.seq.length); /*6212*/
		for (var _FP = 0, _FO = $1.seq.length - 1; _FP <= _FO; _FP += 1) { /*6216*/
			$1.x = _FP; /*6214*/
			$put($1.fxw, $1.x, $geti($1.finderwidths, $get($1.seq, $1.x) * 5, 5)); /*6215*/
		} /*6215*/
		$1.checkweights = $a([-1, -1, -1, -1, -1, -1, -1, -1, 77, 96, 32, 81, 27, 9, 3, 1, 20, 60, 180, 118, 143, 7, 21, 63, 205, 209, 140, 117, 39, 13, 145, 189, 193, 157, 49, 147, 19, 57, 171, 91, 132, 44, 85, 169, 197, 136, 186, 62, 185, 133, 188, 142, 4, 12, 36, 108, 50, 87, 29, 80, 97, 173, 128, 113, 150, 28, 84, 41, 123, 158, 52, 156, 166, 196, 206, 139, 187, 203, 138, 46, 76, 17, 51, 153, 37, 111, 122, 155, 146, 119, 110, 107, 106, 176, 129, 43, 16, 48, 144, 10, 30, 90, 59, 177, 164, 125, 112, 178, 200, 137, 116, 109, 70, 210, 208, 202, 184, 130, 179, 115, 190, 204, 68, 93, 31, 151, 191, 134, 148, 22, 66, 198, 172, 94, 71, 2, 40, 154, 192, 64, 162, 54, 18, 6, 120, 149, 25, 75, 14, 42, 126, 167, 175, 199, 207, 69, 23, 78, 26, 79, 103, 98, 83, 38, 114, 131, 182, 124, 159, 53, 88, 170, 127, 183, 61, 161, 55, 165, 73, 8, 24, 72, 5, 15, 89, 100, 174, 58, 160, 194, 135, 45]); /*6243*/
		$k[$j++] = "checkweightseq"; /*6246*/
		$k[$j++] = Infinity; /*6246*/
		$forall($1.seq, function() { /*6246*/
			$aload($geti($1.checkweights, $k[--$j] * 16, 16)); /*6246*/
		}) /*6246*/
		var _Fc = $a(); /*6246*/
		$1[$k[--$j]] = $geti(_Fc, 8, _Fc.length - 8); /*6247*/
		$k[$j++] = "widths"; /*6250*/
		$k[$j++] = Infinity; /*6250*/
		var _Ff = $1.dxw; /*6250*/
		for (var _Fg = 0, _Fh = _Ff.length; _Fg < _Fh; _Fg++) { /*6250*/
			$forall($get(_Ff, _Fg)); /*6250*/
		} /*6250*/
		var _Fj = $a(); /*6250*/
		$1[$k[--$j]] = _Fj; /*6251*/
		$1.checksum = 0; /*6253*/
		for (var _Fn = 0, _Fm = $1.widths.length - 1; _Fn <= _Fm; _Fn += 1) { /*6257*/
			$1.i = _Fn; /*6255*/
			$1.checksum = $1.checksum + ($get($1.widths, $1.i) * $get($1.checkweightseq, $1.i)); /*6256*/
		} /*6256*/
		$1.checksum = ($1.checksum % 211) + (($1.datalen - 3) * 211); /*6258*/
		$1.i = 0; /*6260*/
		for (;;) { /*6270*/
			if ($1.checksum <= $get($1.tab174, $1.i)) { /*6268*/
				$forall($geti($1.tab174, $1.i + 1, 7)); /*6262*/
				$1.cte = $k[--$j]; /*6263*/
				$1.cto = $k[--$j]; /*6263*/
				$1.cmwe = $k[--$j]; /*6264*/
				$1.cmwo = $k[--$j]; /*6264*/
				$1.cele = $k[--$j]; /*6265*/
				$1.celo = $k[--$j]; /*6265*/
				$1.cgs = $k[--$j]; /*6266*/
				break; /*6267*/
			} /*6267*/
			$1.i = $1.i + 8; /*6269*/
		} /*6269*/
		$k[$j++] = "cwo"; /*6272*/
		$k[$j++] = ~~(($1.checksum - $1.cgs) / $1.cte); /*6272*/
		$k[$j++] = $1.celo; /*6272*/
		$k[$j++] = $1.cmwo; /*6272*/
		$k[$j++] = 4; /*6272*/
		$k[$j++] = true; /*6272*/
		$1.getRSSwidths(); /*6272*/
		var _GH = $k[--$j]; /*6272*/
		$1[$k[--$j]] = _GH; /*6272*/
		$k[$j++] = "cwe"; /*6273*/
		$k[$j++] = ($1.checksum - $1.cgs) % $1.cte; /*6273*/
		$k[$j++] = $1.cele; /*6273*/
		$k[$j++] = $1.cmwe; /*6273*/
		$k[$j++] = 4; /*6273*/
		$k[$j++] = false; /*6273*/
		$1.getRSSwidths(); /*6273*/
		var _GO = $k[--$j]; /*6273*/
		$1[$k[--$j]] = _GO; /*6273*/
		$1.cw = $a(8); /*6275*/
		for (var _GR = 0; _GR <= 3; _GR += 1) { /*6280*/
			$1.i = _GR; /*6277*/
			$put($1.cw, $1.i * 2, $get($1.cwo, $1.i)); /*6278*/
			$put($1.cw, ($1.i * 2) + 1, $get($1.cwe, $1.i)); /*6279*/
		} /*6279*/
		var _Gc = $a(22); /*6282*/
		$put(_Gc, 0, $1.cw); /*6283*/
		$puti(_Gc, 1, $1.dxw); /*6283*/
		$1.dxw = $geti(_Gc, 0, $1.datalen + 1); /*6284*/
		$1.datalen = $1.dxw.length; /*6285*/
		$1.rows = $a(~~Math.ceil($1.datalen / $1.segments)); /*6288*/
		$1.numrows = $1.rows.length; /*6289*/
		for (var _Go = 0, _Gn = $1.numrows - 1; _Go <= _Gn; _Go += 1) { /*6304*/
			$1.r = _Go; /*6291*/
			$k[$j++] = Infinity; /*6292*/
			if ((($1.segments % 4) != 0) && (($1.r % 2) == 1)) { /*6293*/
				$k[$j++] = 0; /*6293*/
			} /*6293*/
			$k[$j++] = 1; /*6301*/
			$k[$j++] = 1; /*6301*/
			for (var _Gt = 0, _Gs = $1.segments - 1; _Gt <= _Gs; _Gt += 1) { /*6301*/
				$1.pos = _Gt + ($1.r * $1.segments); /*6296*/
				if ($1.pos < $1.datalen) { /*6300*/
					$forall($get($1.dxw, $1.pos)); /*6298*/
					if (($1.pos % 2) == 0) { /*6299*/
						$forall($get($1.fxw, ~~($1.pos / 2))); /*6299*/
					} /*6299*/
				} /*6299*/
			} /*6299*/
			var _H5 = $counttomark() + 2; /*6303*/
			$k[$j++] = 1; /*6303*/
			$k[$j++] = 1; /*6303*/
			$astore($a(_H5)); /*6303*/
			$put($1.rows, $1.r, $k[--$j]); /*6303*/
			$j--; /*6303*/
		} /*6303*/
		if ($ne($1.format, "expandedstacked")) { /*6428*/
			var _HC = $get($1.rows, 0); /*6309*/
			$1.sbs = $geti(_HC, 1, _HC.length - 1); /*6309*/
			$k[$j++] = "sbs"; /*6318*/
			$k[$j++] = Infinity; /*6318*/
			$k[$j++] = 1; /*6317*/
			for (var _HG = 0, _HF = $1.datalen - 1; _HG <= _HF; _HG += 1) { /*6317*/
				$1.i = _HG; /*6314*/
				$forall($get($1.dxw, $1.i)); /*6315*/
				if (($1.i % 2) == 0) { /*6316*/
					$forall($get($1.fxw, ~~($1.i / 2))); /*6316*/
				} /*6316*/
			} /*6316*/
			$k[$j++] = 1; /*6318*/
			$k[$j++] = 1; /*6318*/
			var _HO = $a(); /*6318*/
			$1[$k[--$j]] = _HO; /*6319*/
			$k[$j++] = Infinity; /*6326*/
			$k[$j++] = "ren"; /*6324*/
			$k[$j++] = $0.renlinear; /*6324*/
			$k[$j++] = "sbs"; /*6324*/
			$k[$j++] = $1.sbs; /*6324*/
			$k[$j++] = "bhs"; /*6324*/
			$k[$j++] = Infinity; /*6324*/
			for (var _HS = 0, _HT = ~~(($1.sbs.length + 1) / 2); _HS < _HT; _HS++) { /*6324*/
				$k[$j++] = $1.height; /*6324*/
			} /*6324*/
			var _HV = $a(); /*6324*/
			$k[$j++] = _HV; /*6325*/
			$k[$j++] = "bbs"; /*6325*/
			$k[$j++] = Infinity; /*6325*/
			for (var _HX = 0, _HY = ~~(($1.sbs.length + 1) / 2); _HX < _HY; _HX++) { /*6325*/
				$k[$j++] = 0; /*6325*/
			} /*6325*/
			var _HZ = $a(); /*6325*/
			$k[$j++] = _HZ; /*6326*/
			$k[$j++] = "opt"; /*6326*/
			$k[$j++] = $1.options; /*6326*/
			var _Hb = $d(); /*6326*/
			$k[$j++] = _Hb; /*6329*/
			if (!$1.dontdraw) { /*6329*/
				$0.renlinear(); /*6329*/
			} /*6329*/
		} else { /*6428*/
			$1.seps = $a($1.numrows); /*6333*/
			for (var _Hh = 0, _Hg = $1.numrows - 1; _Hh <= _Hg; _Hh += 1) { /*6389*/
				$1.r = _Hh; /*6336*/
				$1.row = $get($1.rows, $1.r); /*6337*/
				$k[$j++] = Infinity; /*6340*/
				for (var _Hn = 0, _Hm = $1.row.length - 1; _Hn <= _Hm; _Hn += 2) { /*6345*/
					$1.i = _Hn; /*6342*/
					for (var _Hr = 0, _Hs = $get($1.row, $1.i); _Hr < _Hs; _Hr++) { /*6343*/
						$k[$j++] = 0; /*6343*/
					} /*6343*/
					if ($1.i < ($1.row.length - 1)) { /*6344*/
						for (var _Hy = 0, _Hz = $get($1.row, $1.i + 1); _Hy < _Hz; _Hy++) { /*6344*/
							$k[$j++] = 1; /*6344*/
						} /*6344*/
					} /*6344*/
				} /*6344*/
				$astore($a($counttomark())); /*6346*/
				$1.row = $k[--$j]; /*6346*/
				$j--; /*6346*/
				$k[$j++] = "sep"; /*6349*/
				$k[$j++] = Infinity; /*6349*/
				$forall($1.row, function() { /*6349*/
					var _I4 = $k[--$j]; /*6349*/
					$k[$j++] = 1 - _I4; /*6349*/
				}) /*6349*/
				var _I5 = $a(); /*6349*/
				$1[$k[--$j]] = _I5; /*6349*/
				$puti($1.sep, 0, $a([0, 0, 0, 0])); /*6350*/
				$puti($1.sep, $1.row.length - 4, $a([0, 0, 0, 0])); /*6351*/
				$k[$j++] = "finderpos"; /*6354*/
				$k[$j++] = Infinity; /*6354*/
				for (var _IE = 19, _ID = $1.row.length - 13; _IE <= _ID; _IE += 98) { /*6353*/
					$k[$j++] = _IE; /*6353*/
				} /*6353*/
				for (var _IH = 68, _IG = $1.row.length - 13; _IH <= _IG; _IH += 98) { /*6354*/
					$k[$j++] = _IH; /*6354*/
				} /*6354*/
				var _II = $a(); /*6354*/
				$1[$k[--$j]] = _II; /*6355*/
				$forall($1.finderpos, function() { /*6370*/
					var _IL = $k[--$j]; /*6357*/
					for (var _IN = _IL, _IM = _IL + 14; _IN <= _IM; _IN += 1) { /*6369*/
						$1.i = _IN; /*6358*/
						if ($get($1.row, $1.i) == 0) { /*6366*/
							if ($get($1.row, $1.i - 1) == 1) { /*6363*/
								$k[$j++] = 1; /*6361*/
							} else { /*6363*/
								var _IX = ($get($1.sep, $1.i - 1) == 0) ? 1 : 0; /*6363*/
								$k[$j++] = _IX; /*6363*/
							} /*6363*/
						} else { /*6366*/
							$k[$j++] = 0; /*6366*/
						} /*6366*/
						$put($1.sep, $1.i, $k[--$j]); /*6368*/
					} /*6368*/
				}) /*6368*/
				if ((($1.segments % 4) == 0) && (($1.r % 2) == 1)) { /*6384*/
					if (($get($1.rows, $1.r).length != $get($1.rows, 0).length) && (($1.finderpos.length % 2) == 1)) { /*6382*/
						$k[$j++] = "row"; /*6376*/
						$k[$j++] = Infinity; /*6376*/
						$k[$j++] = 0; /*6376*/
						$aload($1.row); /*6376*/
						var _Ik = $a(); /*6376*/
						$1[$k[--$j]] = _Ik; /*6376*/
						$k[$j++] = "sep"; /*6377*/
						$k[$j++] = Infinity; /*6377*/
						$k[$j++] = 0; /*6377*/
						$aload($1.sep); /*6377*/
						var _In = $a(); /*6377*/
						$1[$k[--$j]] = _In; /*6377*/
					} else { /*6382*/
						for (var _Iq = $1.row.length - 1; _Iq >= 0; _Iq -= 1) { /*6379*/
							$k[$j++] = $get($1.row, _Iq); /*6379*/
						} /*6379*/
						$astore($1.row); /*6380*/
						$j--; /*6380*/
						for (var _Iv = $1.sep.length - 1; _Iv >= 0; _Iv -= 1) { /*6381*/
							$k[$j++] = $get($1.sep, _Iv); /*6381*/
						} /*6381*/
						$astore($1.sep); /*6382*/
						$j--; /*6382*/
					} /*6382*/
				} /*6382*/
				$put($1.rows, $1.r, $1.row); /*6386*/
				$put($1.seps, $1.r, $1.sep); /*6387*/
			} /*6387*/
			$1.pixx = $get($1.rows, 0).length; /*6392*/
			$k[$j++] = Infinity; /*6393*/
			for (var _J8 = 0, _J9 = $1.pixx; _J8 < _J9; _J8++) { /*6393*/
				$k[$j++] = 0; /*6393*/
			} /*6393*/
			var _JA = $a(); /*6393*/
			$puti(_JA, 0, $get($1.rows, $1.numrows - 1)); /*6393*/
			$put($1.rows, $1.numrows - 1, _JA); /*6394*/
			$k[$j++] = Infinity; /*6395*/
			for (var _JH = 0, _JI = $1.pixx; _JH < _JI; _JH++) { /*6395*/
				$k[$j++] = 0; /*6395*/
			} /*6395*/
			var _JJ = $a(); /*6395*/
			$puti(_JJ, 0, $get($1.seps, $1.numrows - 1)); /*6395*/
			$put($1.seps, $1.numrows - 1, _JJ); /*6396*/
			$k[$j++] = "sep"; /*6399*/
			$k[$j++] = Infinity; /*6399*/
			for (var _JQ = 0, _JR = (~~($1.pixx / 2)) + 1; _JQ < _JR; _JQ++) { /*6399*/
				$k[$j++] = 0; /*6399*/
				$k[$j++] = 1; /*6399*/
			} /*6399*/
			var _JU = $geti($a(), 0, $1.pixx); /*6399*/
			$1[$k[--$j]] = _JU; /*6399*/
			$puti($1.sep, 0, $a([0, 0, 0, 0])); /*6400*/
			$puti($1.sep, $1.pixx - 4, $a([0, 0, 0, 0])); /*6401*/
			$k[$j++] = "pixs"; /*6413*/
			$k[$j++] = Infinity; /*6413*/
			for (var _Jd = 0, _Jc = $1.numrows - 1; _Jd <= _Jc; _Jd += 1) { /*6415*/
				$1.r = _Jd; /*6406*/
				if ($1.r != 0) { /*6409*/
					$aload($get($1.seps, $1.r)); /*6408*/
				} /*6408*/
				for (var _Ji = 0, _Jj = 34; _Ji < _Jj; _Ji++) { /*6410*/
					$aload($get($1.rows, $1.r)); /*6410*/
				} /*6410*/
				if ($1.r != ($1.numrows - 1)) { /*6414*/
					$aload($get($1.seps, $1.r)); /*6412*/
					$aload($1.sep); /*6413*/
				} /*6413*/
			} /*6413*/
			var _Jt = $a(); /*6413*/
			$1[$k[--$j]] = _Jt; /*6416*/
			var _K3 = {
				ren: $0.renmatrix,
				pixs: $1.pixs,
				pixx: $1.pixx,
				pixy: ~~($1.pixs.length / $1.pixx),
				height: (~~($1.pixs.length / $1.pixx)) / 72,
				width: $1.pixx / 72,
				opt: $1.options
			}; /*6425*/
			$k[$j++] = _K3; /*6428*/
			if (!$1.dontdraw) { /*6428*/
				$0.renmatrix(); /*6428*/
			} /*6428*/
		} /*6428*/
	};
	$0.databarexpandedstacked = function() {
		var $1 = {}; /*6458*/
		$1.options = $k[--$j]; /*6460*/
		$1.barcode = $k[--$j]; /*6461*/
		$1.dontdraw = false; /*6463*/
		$forall($1.options, function() { /*6474*/
			var _3 = $k[--$j]; /*6474*/
			$1[$k[--$j]] = _3; /*6474*/
		}) /*6474*/
		$1.options.dontdraw = true; /*6477*/
		$1.options.format = "expandedstacked"; /*6478*/
		$k[$j++] = "args"; /*6480*/
		$k[$j++] = $1.barcode; /*6480*/
		$k[$j++] = $1.options; /*6480*/
		$0.databarexpanded(); /*6480*/
		var _9 = $k[--$j]; /*6480*/
		$1[$k[--$j]] = _9; /*6480*/
		$1.args.opt = $1.options; /*6482*/
		$k[$j++] = $1.args; /*6485*/
		if (!$1.dontdraw) { /*6485*/
			$0.renmatrix(); /*6485*/
		} /*6485*/
	};
	$0.pharmacode = function() {
		var $1 = {}; /*6512*/
		$1.options = $k[--$j]; /*6514*/
		$1.barcode = $k[--$j]; /*6515*/
		$1.dontdraw = false; /*6517*/
		$1.height = (8 * 2.835) / 72; /*6518*/
		$1.nwidth = 0.5 * 2.835; /*6519*/
		$1.wwidth = 1.5 * 2.835; /*6520*/
		$1.swidth = 1 * 2.835; /*6521*/
		$forall($1.options, function() { /*6532*/
			var _3 = $k[--$j]; /*6532*/
			$1[$k[--$j]] = _3; /*6532*/
		}) /*6532*/
		$1.height = +$1.height; /*6534*/
		$1.nwidth = +$1.nwidth; /*6535*/
		$1.wwidth = +$1.wwidth; /*6536*/
		$1.swidth = +$1.swidth; /*6537*/
		if (($1.barcode.length < 1) || ($1.barcode.length > 6)) { /*6542*/
			$k[$j++] = "bwipp.pharmacodeBadLength"; /*6541*/
			$k[$j++] = "Pharmacode must be 1 to 6 digits"; /*6541*/
			$0.raiseerror(); /*6541*/
		} /*6541*/
		$forall($1.barcode, function() { /*6547*/
			var _C = $k[--$j]; /*6544*/
			if ((_C < 48) || (_C > 57)) { /*6546*/
				$k[$j++] = "bwipp.pharmacodeBadCharacter"; /*6545*/
				$k[$j++] = "Pharmacode must contain only digits"; /*6545*/
				$0.raiseerror(); /*6545*/
			} /*6545*/
		}) /*6545*/
		var _E = ~~$z($1.barcode); /*6548*/
		if ((_E < 3) || (_E > 131070)) { /*6550*/
			$k[$j++] = "bwipp.pharmacodeBadValue"; /*6549*/
			$k[$j++] = "Pharmacode value must be between 3 and 131070"; /*6549*/
			$0.raiseerror(); /*6549*/
		} /*6549*/
		$1.txt = $a($1.barcode.length); /*6553*/
		for (var _J = 0, _I = $1.barcode.length - 1; _J <= _I; _J += 1) { /*6557*/
			$1.i = _J; /*6555*/
			$put($1.txt, $1.i, $a([$geti($1.barcode, $1.i, 1), 0, 0, "", 0])); /*6556*/
		} /*6556*/
		$1.barcode = $cvrs($s(17), (~~$z($1.barcode)) + 1, 2); /*6560*/
		$1.barcode = $geti($1.barcode, 1, $1.barcode.length - 1); /*6561*/
		$1.barlen = $1.barcode.length; /*6563*/
		$1.sbs = $a($1.barlen * 2); /*6564*/
		for (var _b = 0, _a = $1.barlen - 1; _b <= _a; _b += 1) { /*6575*/
			$1.i = _b; /*6567*/
			$1.enc = $geti($1.barcode, $1.i, 1); /*6568*/
			if ($eq($1.enc, "0")) { /*6572*/
				$put($1.sbs, $1.i * 2, $1.nwidth); /*6570*/
			} else { /*6572*/
				$put($1.sbs, $1.i * 2, $1.wwidth); /*6572*/
			} /*6572*/
			$put($1.sbs, ($1.i * 2) + 1, $1.swidth); /*6574*/
		} /*6574*/
		$k[$j++] = Infinity; /*6585*/
		$k[$j++] = "ren"; /*6581*/
		$k[$j++] = $0.renlinear; /*6581*/
		$k[$j++] = "sbs"; /*6581*/
		$k[$j++] = $1.sbs; /*6581*/
		$k[$j++] = "bhs"; /*6581*/
		$k[$j++] = Infinity; /*6581*/
		for (var _r = 0, _s = ~~(($1.sbs.length + 1) / 2); _r < _s; _r++) { /*6581*/
			$k[$j++] = $1.height; /*6581*/
		} /*6581*/
		var _u = $a(); /*6581*/
		$k[$j++] = _u; /*6582*/
		$k[$j++] = "bbs"; /*6582*/
		$k[$j++] = Infinity; /*6582*/
		for (var _w = 0, _x = ~~(($1.sbs.length + 1) / 2); _w < _x; _w++) { /*6582*/
			$k[$j++] = 0; /*6582*/
		} /*6582*/
		var _y = $a(); /*6582*/
		$k[$j++] = _y; /*6585*/
		$k[$j++] = "txt"; /*6585*/
		$k[$j++] = $1.txt; /*6585*/
		$k[$j++] = "textxalign"; /*6585*/
		$k[$j++] = "center"; /*6585*/
		$k[$j++] = "opt"; /*6585*/
		$k[$j++] = $1.options; /*6585*/
		var _11 = $d(); /*6585*/
		$k[$j++] = _11; /*6588*/
		if (!$1.dontdraw) { /*6588*/
			$0.renlinear(); /*6588*/
		} /*6588*/
	};
	$0.pharmacode2 = function() {
		var $1 = {}; /*6615*/
		$1.options = $k[--$j]; /*6617*/
		$1.barcode = $k[--$j]; /*6618*/
		$1.dontdraw = false; /*6620*/
		$1.includetext = false; /*6621*/
		$1.height = 4; /*6622*/
		$forall($1.options, function() { /*6633*/
			var _3 = $k[--$j]; /*6633*/
			$1[$k[--$j]] = _3; /*6633*/
		}) /*6633*/
		$1.height = +$1.height; /*6635*/
		if (($1.barcode.length < 1) || ($1.barcode.length > 8)) { /*6640*/
			$k[$j++] = "bwipp.pharmacode2BadLength"; /*6639*/
			$k[$j++] = "Two-track Pharmacode must be 1 to 6 digits"; /*6639*/
			$0.raiseerror(); /*6639*/
		} /*6639*/
		$forall($1.barcode, function() { /*6645*/
			var _9 = $k[--$j]; /*6642*/
			if ((_9 < 48) || (_9 > 57)) { /*6644*/
				$k[$j++] = "bwipp.pharmacode2badCharacter"; /*6643*/
				$k[$j++] = "Two-track Pharmacode must contain only digits"; /*6643*/
				$0.raiseerror(); /*6643*/
			} /*6643*/
		}) /*6643*/
		var _B = ~~$z($1.barcode); /*6646*/
		if ((_B < 4) || (_B > 64570080)) { /*6648*/
			$k[$j++] = "bwipp.pharmacode2badValue"; /*6647*/
			$k[$j++] = "Two-track Pharmacode value must be between 4 and 64570080"; /*6647*/
			$0.raiseerror(); /*6647*/
		} /*6647*/
		$1.txt = $a($1.barcode.length); /*6651*/
		for (var _G = 0, _F = $1.barcode.length - 1; _G <= _F; _G += 1) { /*6655*/
			$1.i = _G; /*6653*/
			$put($1.txt, $1.i, $a([$geti($1.barcode, $1.i, 1), 0, 0, "", 0])); /*6654*/
		} /*6654*/
		$1.encstr = $s(16); /*6657*/
		$1.bhs = $a(16); /*6658*/
		$1.bbs = $a(16); /*6659*/
		$1.sbs = $a(32); /*6660*/
		$1.bar = (1 / 25.4) * $1.height; /*6661*/
		$1.spc = (1 / 25.4) * 72; /*6662*/
		$1.i = 15; /*6665*/
		$1.val = ~~$z($1.barcode); /*6666*/
		for (;;) { /*6673*/
			if ($1.val == 0) { /*6668*/
				break; /*6668*/
			} /*6668*/
			var _V = $1.val % 3; /*6669*/
			$1.val = ~~(($1.val - $get($a([3, 1, 2]), _V)) / 3); /*6670*/
			$put($1.encstr, $1.i, $get($a([2, 0, 1]), _V)); /*6671*/
			$1.i = $1.i - 1; /*6672*/
		} /*6672*/
		$1.encstr = $geti($1.encstr, $1.i + 1, 15 - $1.i); /*6674*/
		for (var _k = 0, _j = $1.encstr.length - 1; _k <= _j; _k += 1) { /*6682*/
			$1.i = _k; /*6678*/
			var _n = $get($1.encstr, $1.i); /*6679*/
			$put($1.bhs, $1.i, $1.bar * $get($a([1, 1, 2]), _n)); /*6680*/
			$put($1.bbs, $1.i, $get($a([0, $1.bar, 0]), _n)); /*6681*/
		} /*6681*/
		$k[$j++] = Infinity; /*6693*/
		$k[$j++] = "ren"; /*6689*/
		$k[$j++] = $0.renlinear; /*6689*/
		$k[$j++] = "bhs"; /*6689*/
		$k[$j++] = $1.bhs; /*6689*/
		$k[$j++] = "bbs"; /*6689*/
		$k[$j++] = $1.bbs; /*6689*/
		$k[$j++] = "sbs"; /*6689*/
		$k[$j++] = Infinity; /*6689*/
		for (var _11 = 0, _12 = $1.encstr.length * 2; _11 < _12; _11++) { /*6689*/
			$k[$j++] = $1.spc; /*6689*/
		} /*6689*/
		var _14 = $a(); /*6689*/
		$k[$j++] = _14; /*6693*/
		$k[$j++] = "txt"; /*6693*/
		$k[$j++] = $1.txt; /*6693*/
		$k[$j++] = "textxalign"; /*6693*/
		$k[$j++] = "center"; /*6693*/
		$k[$j++] = "textyoffset"; /*6693*/
		$k[$j++] = 4; /*6693*/
		$k[$j++] = "opt"; /*6693*/
		$k[$j++] = $1.options; /*6693*/
		var _17 = $d(); /*6693*/
		$k[$j++] = _17; /*6696*/
		if (!$1.dontdraw) { /*6696*/
			$0.renlinear(); /*6696*/
		} /*6696*/
	};
	$0.code2of5 = function() {
		var $1 = {}; /*6723*/
		$1.options = $k[--$j]; /*6725*/
		$1.barcode = $k[--$j]; /*6726*/
		$1.dontdraw = false; /*6728*/
		$1.includecheck = false; /*6729*/
		$1.validatecheck = false; /*6730*/
		$1.includetext = false; /*6731*/
		$1.includecheckintext = false; /*6732*/
		$1.textfont = "Courier"; /*6733*/
		$1.textsize = 10; /*6734*/
		$1.textyoffset = -8.5; /*6735*/
		$1.height = 1; /*6736*/
		$1.version = "industrial"; /*6737*/
		$forall($1.options, function() { /*6748*/
			var _3 = $k[--$j]; /*6748*/
			$1[$k[--$j]] = _3; /*6748*/
		}) /*6748*/
		$1.textfont = "" + $1.textfont; /*6750*/
		$1.textsize = +$1.textsize; /*6751*/
		$1.textyoffset = +$1.textyoffset; /*6752*/
		$1.height = +$1.height; /*6753*/
		$forall($1.barcode, function() { /*6760*/
			var _A = $k[--$j]; /*6757*/
			if ((_A < 48) || (_A > 57)) { /*6759*/
				$k[$j++] = "bwipp.code2of5badCharacter"; /*6758*/
				$k[$j++] = "Code 25 must contain only digits"; /*6758*/
				$0.raiseerror(); /*6758*/
			} /*6758*/
		}) /*6758*/
		$k[$j++] = "barlen"; /*6762*/
		$k[$j++] = $1.barcode.length; /*6762*/
		if ($1.validatecheck) { /*6762*/
			var _D = $k[--$j]; /*6762*/
			$k[$j++] = _D - 1; /*6762*/
		} /*6762*/
		var _E = $k[--$j]; /*6762*/
		$1[$k[--$j]] = _E; /*6762*/
		$1.checksum = 0; /*6764*/
		for (var _I = 0, _H = $1.barlen - 1; _I <= _H; _I += 1) { /*6768*/
			$1.i = _I; /*6766*/
			$k[$j++] = "checksum"; /*6767*/
			$k[$j++] = $1.checksum; /*6767*/
			$k[$j++] = $get($1.barcode, $1.i) - 48; /*6767*/
			if ((($1.barlen - $1.i) % 2) != 0) { /*6767*/
				var _P = $k[--$j]; /*6767*/
				$k[$j++] = _P * 3; /*6767*/
			} /*6767*/
			var _Q = $k[--$j]; /*6767*/
			var _R = $k[--$j]; /*6767*/
			$1[$k[--$j]] = _R + _Q; /*6767*/
		} /*6767*/
		$1.checksum = (10 - ($1.checksum % 10)) % 10; /*6769*/
		if ($1.validatecheck) { /*6776*/
			if ($get($1.barcode, $1.barlen) != ($1.checksum + 48)) { /*6773*/
				$k[$j++] = "bwipp.code2of5badCheckDigit"; /*6772*/
				$k[$j++] = "Incorrect Code 25 check digit provided"; /*6772*/
				$0.raiseerror(); /*6772*/
			} /*6772*/
			$1.barcode = $geti($1.barcode, 0, $1.barlen); /*6774*/
			$1.includecheck = true; /*6775*/
		} /*6775*/
		var _h = {
			industrial: $a(["1111313111", "3111111131", "1131111131", "3131111111", "1111311131", "3111311111", "1131311111", "1111113131", "3111113111", "1131113111", "313111", "31113"]),
			iata: $a(["1111313111", "3111111131", "1131111131", "3131111111", "1111311131", "3111311111", "1131311111", "1111113131", "3111113111", "1131113111", "1111", "311"]),
			matrix: $a(["113311", "311131", "131131", "331111", "113131", "313111", "133111", "111331", "311311", "131311", "311111", "31111"]),
			coop: $a(["331111", "111331", "113131", "113311", "131131", "131311", "133111", "311131", "311311", "313111", "3131", "133"]),
			datalogic: $a(["113311", "311131", "131131", "331111", "113131", "313111", "133111", "111331", "311311", "131311", "1111", "311"])
		}; /*6800*/
		$1.versions = _h; /*6802*/
		var _k = $get($1.versions, $1.version) !== undefined; /*6803*/
		if (!_k) { /*6805*/
			$k[$j++] = "bwipp.code2of5badVersion"; /*6804*/
			$k[$j++] = "Unrecognised Code 25 version"; /*6804*/
			$0.raiseerror(); /*6804*/
		} /*6804*/
		$1.encs = $get($1.versions, $1.version); /*6806*/
		$1.cs = $get($1.encs, 0).length; /*6808*/
		$k[$j++] = "cw"; /*6809*/
		$k[$j++] = 0; /*6809*/
		$forall($get($1.encs, 0), function() { /*6809*/
			var _s = $k[--$j]; /*6809*/
			var _t = $k[--$j]; /*6809*/
			$k[$j++] = _t + (_s - 48); /*6809*/
		}) /*6809*/
		var _u = $k[--$j]; /*6809*/
		$1[$k[--$j]] = _u; /*6809*/
		var _w = $1.encs; /*6810*/
		$1.ss = $get(_w, _w.length - 2).length; /*6810*/
		var _y = $1.encs; /*6811*/
		$k[$j++] = "sw"; /*6811*/
		$k[$j++] = 0; /*6811*/
		$forall($get(_y, _y.length - 2), function() { /*6811*/
			var _10 = $k[--$j]; /*6811*/
			var _11 = $k[--$j]; /*6811*/
			$k[$j++] = _11 + (_10 - 48); /*6811*/
		}) /*6811*/
		var _12 = $k[--$j]; /*6811*/
		$1[$k[--$j]] = _12; /*6811*/
		$1.barchars = "0123456789"; /*6814*/
		$k[$j++] = "sbs"; /*6816*/
		$k[$j++] = $1.barlen; /*6816*/
		if ($1.includecheck) { /*6816*/
			var _16 = $k[--$j]; /*6816*/
			$k[$j++] = _16 + 1; /*6816*/
		} /*6816*/
		var _1B = $s((($k[--$j] * $1.cs) + $1.ss) + $1.ss); /*6816*/
		$1[$k[--$j]] = _1B; /*6816*/
		$k[$j++] = "txt"; /*6817*/
		$k[$j++] = $1.barlen; /*6817*/
		if ($1.includecheck) { /*6817*/
			var _1F = $k[--$j]; /*6817*/
			$k[$j++] = _1F + 1; /*6817*/
		} /*6817*/
		var _1H = $a($k[--$j]); /*6817*/
		$1[$k[--$j]] = _1H; /*6817*/
		$puti($1.sbs, 0, $get($1.encs, 10)); /*6820*/
		for (var _1O = 0, _1N = $1.barlen - 1; _1O <= _1N; _1O += 1) { /*6831*/
			$1.i = _1O; /*6822*/
			$search($1.barchars, $geti($1.barcode, $1.i, 1)); /*6824*/
			$j--; /*6825*/
			$1.indx = $k[--$j].length; /*6826*/
			$j -= 2; /*6827*/
			$1.enc = $get($1.encs, $1.indx); /*6828*/
			$puti($1.sbs, ($1.i * $1.cs) + $1.ss, $1.enc); /*6829*/
			$put($1.txt, $1.i, $a([$geti($1.barcode, $1.i, 1), ($1.i * $1.cw) + $1.sw, $1.textyoffset, $1.textfont, $1.textsize])); /*6830*/
		} /*6830*/
		if ($1.includecheck) { /*6843*/
			$puti($1.sbs, ($1.barlen * $1.cs) + $1.ss, $get($1.encs, $1.checksum)); /*6835*/
			$puti($1.sbs, (($1.barlen * $1.cs) + $1.cs) + $1.ss, $get($1.encs, 11)); /*6836*/
			if ($1.includecheckintext) { /*6840*/
				$put($1.txt, $1.barlen, $a([$geti($1.barchars, $1.checksum, 1), ($1.barlen * $1.cw) + $1.sw, $1.textyoffset, $1.textfont, $1.textsize])); /*6838*/
			} else { /*6840*/
				$put($1.txt, $1.barlen, $a([" ", ($1.barlen * $1.cw) + $1.sw, $1.textyoffset, $1.textfont, $1.textsize])); /*6840*/
			} /*6840*/
		} else { /*6843*/
			$puti($1.sbs, ($1.barlen * $1.cs) + $1.ss, $get($1.encs, 11)); /*6843*/
		} /*6843*/
		$k[$j++] = Infinity; /*6855*/
		$k[$j++] = "ren"; /*6849*/
		$k[$j++] = $0.renlinear; /*6849*/
		$k[$j++] = "sbs"; /*6849*/
		$k[$j++] = Infinity; /*6849*/
		$forall($1.sbs, function() { /*6849*/
			var _2W = $k[--$j]; /*6849*/
			$k[$j++] = _2W - 48; /*6849*/
		}) /*6849*/
		var _2X = $a(); /*6849*/
		$k[$j++] = _2X; /*6850*/
		$k[$j++] = "bhs"; /*6850*/
		$k[$j++] = Infinity; /*6850*/
		for (var _2Z = 0, _2a = ~~(($1.sbs.length + 1) / 2); _2Z < _2a; _2Z++) { /*6850*/
			$k[$j++] = $1.height; /*6850*/
		} /*6850*/
		var _2c = $a(); /*6850*/
		$k[$j++] = _2c; /*6851*/
		$k[$j++] = "bbs"; /*6851*/
		$k[$j++] = Infinity; /*6851*/
		for (var _2e = 0, _2f = ~~(($1.sbs.length + 1) / 2); _2e < _2f; _2e++) { /*6851*/
			$k[$j++] = 0; /*6851*/
		} /*6851*/
		var _2g = $a(); /*6851*/
		$k[$j++] = _2g; /*6854*/
		if ($1.includetext) { /*6854*/
			$k[$j++] = "txt"; /*6853*/
			$k[$j++] = $1.txt; /*6853*/
		} /*6853*/
		$k[$j++] = "opt"; /*6855*/
		$k[$j++] = $1.options; /*6855*/
		var _2k = $d(); /*6855*/
		$k[$j++] = _2k; /*6858*/
		if (!$1.dontdraw) { /*6858*/
			$0.renlinear(); /*6858*/
		} /*6858*/
	};
	$0.industrial2of5 = function() {
		var $1 = {}; /*6886*/
		$1.options = $k[--$j]; /*6888*/
		$1.barcode = $k[--$j]; /*6889*/
		$1.dontdraw = false; /*6891*/
		$1.includetext = false; /*6892*/
		$1.textfont = "Courier"; /*6893*/
		$1.textsize = 10; /*6894*/
		$1.textxoffset = 0; /*6895*/
		$1.textyoffset = -8.5; /*6896*/
		$1.height = 1; /*6897*/
		$forall($1.options, function() { /*6908*/
			var _3 = $k[--$j]; /*6908*/
			$1[$k[--$j]] = _3; /*6908*/
		}) /*6908*/
		$1.textfont = "" + $1.textfont; /*6910*/
		$1.textsize = +$1.textsize; /*6911*/
		$1.textxoffset = +$1.textxoffset; /*6912*/
		$1.textyoffset = +$1.textyoffset; /*6913*/
		$1.height = +$1.height; /*6914*/
		$1.options.dontdraw = true; /*6917*/
		$1.options.version = "industrial"; /*6918*/
		$k[$j++] = "args"; /*6920*/
		$k[$j++] = $1.barcode; /*6920*/
		$k[$j++] = $1.options; /*6920*/
		$0.code2of5(); /*6920*/
		var _E = $k[--$j]; /*6920*/
		$1[$k[--$j]] = _E; /*6920*/
		$1.args.opt = $1.options; /*6922*/
		$k[$j++] = $1.args; /*6925*/
		if (!$1.dontdraw) { /*6925*/
			$0.renlinear(); /*6925*/
		} /*6925*/
	};
	$0.iata2of5 = function() {
		var $1 = {}; /*6953*/
		$1.options = $k[--$j]; /*6955*/
		$1.barcode = $k[--$j]; /*6956*/
		$1.dontdraw = false; /*6958*/
		$1.includetext = false; /*6959*/
		$1.textfont = "Courier"; /*6960*/
		$1.textsize = 10; /*6961*/
		$1.textxoffset = 0; /*6962*/
		$1.textyoffset = -8.5; /*6963*/
		$1.height = 1; /*6964*/
		$forall($1.options, function() { /*6975*/
			var _3 = $k[--$j]; /*6975*/
			$1[$k[--$j]] = _3; /*6975*/
		}) /*6975*/
		$1.textfont = "" + $1.textfont; /*6977*/
		$1.textsize = +$1.textsize; /*6978*/
		$1.textxoffset = +$1.textxoffset; /*6979*/
		$1.textyoffset = +$1.textyoffset; /*6980*/
		$1.height = +$1.height; /*6981*/
		$1.options.dontdraw = true; /*6984*/
		$1.options.version = "iata"; /*6985*/
		$k[$j++] = "args"; /*6987*/
		$k[$j++] = $1.barcode; /*6987*/
		$k[$j++] = $1.options; /*6987*/
		$0.code2of5(); /*6987*/
		var _E = $k[--$j]; /*6987*/
		$1[$k[--$j]] = _E; /*6987*/
		$1.args.opt = $1.options; /*6989*/
		$k[$j++] = $1.args; /*6992*/
		if (!$1.dontdraw) { /*6992*/
			$0.renlinear(); /*6992*/
		} /*6992*/
	};
	$0.matrix2of5 = function() {
		var $1 = {}; /*7020*/
		$1.options = $k[--$j]; /*7022*/
		$1.barcode = $k[--$j]; /*7023*/
		$1.dontdraw = false; /*7025*/
		$1.includetext = false; /*7026*/
		$1.textfont = "Courier"; /*7027*/
		$1.textsize = 10; /*7028*/
		$1.textxoffset = 0; /*7029*/
		$1.textyoffset = -8.5; /*7030*/
		$1.height = 1; /*7031*/
		$forall($1.options, function() { /*7042*/
			var _3 = $k[--$j]; /*7042*/
			$1[$k[--$j]] = _3; /*7042*/
		}) /*7042*/
		$1.textfont = "" + $1.textfont; /*7044*/
		$1.textsize = +$1.textsize; /*7045*/
		$1.textxoffset = +$1.textxoffset; /*7046*/
		$1.textyoffset = +$1.textyoffset; /*7047*/
		$1.height = +$1.height; /*7048*/
		$1.options.dontdraw = true; /*7051*/
		$1.options.version = "matrix"; /*7052*/
		$k[$j++] = "args"; /*7054*/
		$k[$j++] = $1.barcode; /*7054*/
		$k[$j++] = $1.options; /*7054*/
		$0.code2of5(); /*7054*/
		var _E = $k[--$j]; /*7054*/
		$1[$k[--$j]] = _E; /*7054*/
		$1.args.opt = $1.options; /*7056*/
		$k[$j++] = $1.args; /*7059*/
		if (!$1.dontdraw) { /*7059*/
			$0.renlinear(); /*7059*/
		} /*7059*/
	};
	$0.coop2of5 = function() {
		var $1 = {}; /*7087*/
		$1.options = $k[--$j]; /*7089*/
		$1.barcode = $k[--$j]; /*7090*/
		$1.dontdraw = false; /*7092*/
		$1.includetext = false; /*7093*/
		$1.textfont = "Courier"; /*7094*/
		$1.textsize = 10; /*7095*/
		$1.textxoffset = 0; /*7096*/
		$1.textyoffset = -8.5; /*7097*/
		$1.height = 1; /*7098*/
		$forall($1.options, function() { /*7109*/
			var _3 = $k[--$j]; /*7109*/
			$1[$k[--$j]] = _3; /*7109*/
		}) /*7109*/
		$1.textfont = "" + $1.textfont; /*7111*/
		$1.textsize = +$1.textsize; /*7112*/
		$1.textxoffset = +$1.textxoffset; /*7113*/
		$1.textyoffset = +$1.textyoffset; /*7114*/
		$1.height = +$1.height; /*7115*/
		$1.options.dontdraw = true; /*7118*/
		$1.options.version = "coop"; /*7119*/
		$k[$j++] = "args"; /*7121*/
		$k[$j++] = $1.barcode; /*7121*/
		$k[$j++] = $1.options; /*7121*/
		$0.code2of5(); /*7121*/
		var _E = $k[--$j]; /*7121*/
		$1[$k[--$j]] = _E; /*7121*/
		$1.args.opt = $1.options; /*7123*/
		$k[$j++] = $1.args; /*7126*/
		if (!$1.dontdraw) { /*7126*/
			$0.renlinear(); /*7126*/
		} /*7126*/
	};
	$0.datalogic2of5 = function() {
		var $1 = {}; /*7154*/
		$1.options = $k[--$j]; /*7156*/
		$1.barcode = $k[--$j]; /*7157*/
		$1.dontdraw = false; /*7159*/
		$1.includetext = false; /*7160*/
		$1.textfont = "Courier"; /*7161*/
		$1.textsize = 10; /*7162*/
		$1.textxoffset = 0; /*7163*/
		$1.textyoffset = -8.5; /*7164*/
		$1.height = 1; /*7165*/
		$forall($1.options, function() { /*7176*/
			var _3 = $k[--$j]; /*7176*/
			$1[$k[--$j]] = _3; /*7176*/
		}) /*7176*/
		$1.textfont = "" + $1.textfont; /*7178*/
		$1.textsize = +$1.textsize; /*7179*/
		$1.textxoffset = +$1.textxoffset; /*7180*/
		$1.textyoffset = +$1.textyoffset; /*7181*/
		$1.height = +$1.height; /*7182*/
		$1.options.dontdraw = true; /*7185*/
		$1.options.version = "datalogic"; /*7186*/
		$k[$j++] = "args"; /*7188*/
		$k[$j++] = $1.barcode; /*7188*/
		$k[$j++] = $1.options; /*7188*/
		$0.code2of5(); /*7188*/
		var _E = $k[--$j]; /*7188*/
		$1[$k[--$j]] = _E; /*7188*/
		$1.args.opt = $1.options; /*7190*/
		$k[$j++] = $1.args; /*7193*/
		if (!$1.dontdraw) { /*7193*/
			$0.renlinear(); /*7193*/
		} /*7193*/
	};
	$0.code11 = function() {
		var $1 = {}; /*7220*/
		$1.options = $k[--$j]; /*7222*/
		$1.barcode = $k[--$j]; /*7223*/
		$1.dontdraw = false; /*7225*/
		$1.includecheck = false; /*7226*/
		$1.validatecheck = false; /*7227*/
		$1.includetext = false; /*7228*/
		$1.includecheckintext = false; /*7229*/
		$1.textfont = "Courier"; /*7230*/
		$1.textsize = 10; /*7231*/
		$1.textyoffset = -8.5; /*7232*/
		$1.height = 1; /*7233*/
		$forall($1.options, function() { /*7244*/
			var _3 = $k[--$j]; /*7244*/
			$1[$k[--$j]] = _3; /*7244*/
		}) /*7244*/
		$1.textfont = "" + $1.textfont; /*7246*/
		$1.textsize = +$1.textsize; /*7247*/
		$1.textyoffset = +$1.textyoffset; /*7248*/
		$1.height = +$1.height; /*7249*/
		$1.encs = $a(["111131", "311131", "131131", "331111", "113131", "313111", "133111", "111331", "311311", "311111", "113111", "113311"]); /*7256*/
		$1.barchars = "0123456789-"; /*7259*/
		$1.charvals = {}; /*7260*/
		for (var _A = 0; _A <= 10; _A += 1) { /*7261*/
			$put($1.charvals, $geti($1.barchars, _A, 1), _A); /*7261*/
		} /*7261*/
		for (var _G = 0, _F = $1.barcode.length - 1; _G <= _F; _G += 1) { /*7268*/
			var _K = $get($1.charvals, $geti($1.barcode, _G, 1)) !== undefined; /*7265*/
			if (!_K) { /*7267*/
				$k[$j++] = "bwipp.code11badCharacter"; /*7266*/
				$k[$j++] = "Code 11 must contain only digits and dashes"; /*7266*/
				$0.raiseerror(); /*7266*/
			} /*7266*/
		} /*7266*/
		$1.barlen = $1.barcode.length; /*7270*/
		if ($1.validatecheck) { /*7276*/
			if ($1.barlen == 11) { /*7274*/
				$k[$j++] = "bwipp.code11badLength"; /*7273*/
				$k[$j++] = "Code 11 cannot be 11 characters using check digits"; /*7273*/
				$0.raiseerror(); /*7273*/
			} /*7273*/
			var _Q = ($1.barlen <= 10) ? 1 : 2; /*7275*/
			$1.barlen = $1.barlen - _Q; /*7275*/
		} /*7275*/
		$k[$j++] = "numchecks"; /*7278*/
		if ($1.includecheck || $1.validatecheck) { /*7278*/
			var _U = ($1.barlen >= 10) ? 2 : 1; /*7278*/
			$k[$j++] = _U; /*7278*/
		} else { /*7278*/
			$k[$j++] = 0; /*7278*/
		} /*7278*/
		var _V = $k[--$j]; /*7278*/
		$1[$k[--$j]] = _V; /*7278*/
		$1.checksum1 = 0; /*7279*/
		$1.checksum2 = 0; /*7279*/
		for (var _Z = 0, _Y = $1.barlen - 1; _Z <= _Y; _Z += 1) { /*7285*/
			$1.i = _Z; /*7281*/
			$1.indx = $get($1.charvals, $geti($1.barcode, $1.i, 1)); /*7282*/
			$1.checksum1 = $1.checksum1 + ((((($1.barlen - $1.i) - 1) % 10) + 1) * $1.indx); /*7283*/
			$1.checksum2 = $1.checksum2 + (((($1.barlen - $1.i) % 9) + 1) * $1.indx); /*7284*/
		} /*7284*/
		$1.checksum1 = $1.checksum1 % 11; /*7286*/
		$1.checksum2 = ($1.checksum2 + $1.checksum1) % 11; /*7287*/
		if ($1.validatecheck) { /*7301*/
			if ($1.numchecks == 1) { /*7296*/
				if ($get($1.barcode, $1.barlen) != $get($1.barchars, $1.checksum1)) { /*7292*/
					$k[$j++] = "bwipp.code11badCheckDigit"; /*7291*/
					$k[$j++] = "Incorrect Code 11 check digit provided"; /*7291*/
					$0.raiseerror(); /*7291*/
				} /*7291*/
			} else { /*7296*/
				if (($get($1.barcode, $1.barlen) != $get($1.barchars, $1.checksum1)) || ($get($1.barcode, $1.barlen + 1) != $get($1.barchars, $1.checksum2))) { /*7297*/
					$k[$j++] = "bwipp.code11badCheckDigits"; /*7296*/
					$k[$j++] = "Incorrect Code 11 check digits provided"; /*7296*/
					$0.raiseerror(); /*7296*/
				} /*7296*/
			} /*7296*/
			$1.barcode = $geti($1.barcode, 0, $1.barlen); /*7299*/
			$1.includecheck = true; /*7300*/
		} /*7300*/
		$1.sbs = $s((($1.barlen + $1.numchecks) * 6) + 12); /*7303*/
		$1.txt = $a($1.barlen + $1.numchecks); /*7304*/
		$puti($1.sbs, 0, $get($1.encs, 11)); /*7307*/
		$1.xpos = 8; /*7309*/
		for (var _1O = 0, _1N = $1.barlen - 1; _1O <= _1N; _1O += 1) { /*7319*/
			$1.i = _1O; /*7311*/
			$1.indx = $get($1.charvals, $geti($1.barcode, $1.i, 1)); /*7312*/
			$1.enc = $get($1.encs, $1.indx); /*7313*/
			$puti($1.sbs, ($1.i * 6) + 6, $1.enc); /*7314*/
			$put($1.txt, $1.i, $a([$geti($1.barcode, $1.i, 1), $1.xpos, $1.textyoffset, $1.textfont, $1.textsize])); /*7315*/
			for (var _1k = 0; _1k <= 5; _1k += 1) { /*7318*/
				$1.xpos = ($get($1.enc, _1k) - 48) + $1.xpos; /*7317*/
			} /*7317*/
		} /*7317*/
		if ($1.includecheck) { /*7348*/
			if ($1.barlen >= 10) { /*7345*/
				$puti($1.sbs, ($1.barlen * 6) + 6, $get($1.encs, $1.checksum1)); /*7324*/
				$puti($1.sbs, ($1.barlen * 6) + 12, $get($1.encs, $1.checksum2)); /*7325*/
				if ($1.includecheckintext) { /*7335*/
					$put($1.txt, $1.barlen, $a([$geti($1.barchars, $1.checksum1, 1), $1.xpos, $1.textyoffset, $1.textfont, $1.textsize])); /*7327*/
					$1.enc = $get($1.encs, $1.checksum1); /*7328*/
					for (var _2E = 0; _2E <= 5; _2E += 1) { /*7331*/
						$1.xpos = ($get($1.enc, _2E) - 48) + $1.xpos; /*7330*/
					} /*7330*/
					$put($1.txt, $1.barlen + 1, $a([$geti($1.barchars, $1.checksum2, 1), $1.xpos, $1.textyoffset, $1.textfont, $1.textsize])); /*7332*/
				} else { /*7335*/
					$put($1.txt, $1.barlen, $a(["", $1.xpos, $1.textyoffset, $1.textfont, $1.textsize])); /*7334*/
					$put($1.txt, $1.barlen + 1, $a(["", $1.xpos, $1.textyoffset, $1.textfont, $1.textsize])); /*7335*/
				} /*7335*/
				$puti($1.sbs, ($1.barlen * 6) + 18, $get($1.encs, 11)); /*7337*/
			} else { /*7345*/
				$puti($1.sbs, ($1.barlen * 6) + 6, $get($1.encs, $1.checksum1)); /*7339*/
				if ($1.includecheckintext) { /*7343*/
					$put($1.txt, $1.barlen, $a([$geti($1.barchars, $1.checksum1, 1), $1.xpos, $1.textyoffset, $1.textfont, $1.textsize])); /*7341*/
				} else { /*7343*/
					$put($1.txt, $1.barlen, $a(["", $1.xpos, $1.textyoffset, $1.textfont, $1.textsize])); /*7343*/
				} /*7343*/
				$puti($1.sbs, ($1.barlen * 6) + 12, $get($1.encs, 11)); /*7345*/
			} /*7345*/
		} else { /*7348*/
			$puti($1.sbs, ($1.barlen * 6) + 6, $get($1.encs, 11)); /*7348*/
		} /*7348*/
		$k[$j++] = Infinity; /*7360*/
		$k[$j++] = "ren"; /*7354*/
		$k[$j++] = $0.renlinear; /*7354*/
		$k[$j++] = "sbs"; /*7354*/
		$k[$j++] = Infinity; /*7354*/
		var _3F = $1.sbs; /*7354*/
		for (var _3G = 0, _3H = _3F.length; _3G < _3H; _3G++) { /*7354*/
			$k[$j++] = $get(_3F, _3G) - 48; /*7354*/
		} /*7354*/
		var _3J = $a(); /*7354*/
		$k[$j++] = _3J; /*7355*/
		$k[$j++] = "bhs"; /*7355*/
		$k[$j++] = Infinity; /*7355*/
		for (var _3L = 0, _3M = ~~(($1.sbs.length + 1) / 2); _3L < _3M; _3L++) { /*7355*/
			$k[$j++] = $1.height; /*7355*/
		} /*7355*/
		var _3O = $a(); /*7355*/
		$k[$j++] = _3O; /*7356*/
		$k[$j++] = "bbs"; /*7356*/
		$k[$j++] = Infinity; /*7356*/
		for (var _3Q = 0, _3R = ~~(($1.sbs.length + 1) / 2); _3Q < _3R; _3Q++) { /*7356*/
			$k[$j++] = 0; /*7356*/
		} /*7356*/
		var _3S = $a(); /*7356*/
		$k[$j++] = _3S; /*7359*/
		if ($1.includetext) { /*7359*/
			$k[$j++] = "txt"; /*7358*/
			$k[$j++] = $1.txt; /*7358*/
		} /*7358*/
		$k[$j++] = "opt"; /*7360*/
		$k[$j++] = $1.options; /*7360*/
		var _3W = $d(); /*7360*/
		$k[$j++] = _3W; /*7363*/
		if (!$1.dontdraw) { /*7363*/
			$0.renlinear(); /*7363*/
		} /*7363*/
	};
	$0.bc412 = function() {
		var $1 = {}; /*7390*/
		$1.options = $k[--$j]; /*7392*/
		$1.barcode = $k[--$j]; /*7393*/
		$1.dontdraw = false; /*7395*/
		$1.includecheck = false; /*7396*/
		$1.validatecheck = false; /*7397*/
		$1.includetext = false; /*7398*/
		$1.includecheckintext = false; /*7399*/
		$1.includestartstop = false; /*7400*/
		$1.semi = false; /*7401*/
		$1.textfont = "Courier"; /*7402*/
		$1.textsize = 10; /*7403*/
		$1.textyoffset = -8.5; /*7404*/
		$1.height = 1; /*7405*/
		$forall($1.options, function() { /*7416*/
			var _3 = $k[--$j]; /*7416*/
			$1[$k[--$j]] = _3; /*7416*/
		}) /*7416*/
		$1.textfont = "" + $1.textfont; /*7418*/
		$1.textsize = +$1.textsize; /*7419*/
		$1.textyoffset = +$1.textyoffset; /*7420*/
		$1.height = +$1.height; /*7421*/
		if ($1.semi) { /*7426*/
			$1.includecheck = true; /*7424*/
			$1.includestartstop = true; /*7425*/
		} /*7425*/
		$1.barchars = "0R9GLVHA8EZ4NTS1J2Q6C7DYKBUIX3FWP5M"; /*7429*/
		$1.charvals = {}; /*7430*/
		for (var _A = 0; _A <= 34; _A += 1) { /*7431*/
			$put($1.charvals, $geti($1.barchars, _A, 1), _A); /*7431*/
		} /*7431*/
		for (var _G = 0, _F = $1.barcode.length - 1; _G <= _F; _G += 1) { /*7438*/
			var _K = $get($1.charvals, $geti($1.barcode, _G, 1)) !== undefined; /*7435*/
			if (!_K) { /*7437*/
				$k[$j++] = "bwipp.bc412badCharacter"; /*7436*/
				$k[$j++] = "BC412 must contain only digits and capital letters except O"; /*7436*/
				$0.raiseerror(); /*7436*/
			} /*7436*/
		} /*7436*/
		$k[$j++] = "barlen"; /*7440*/
		$k[$j++] = $1.barcode.length; /*7440*/
		if ($1.validatecheck) { /*7440*/
			var _N = $k[--$j]; /*7440*/
			$k[$j++] = _N - 1; /*7440*/
		} /*7440*/
		var _O = $k[--$j]; /*7440*/
		$1[$k[--$j]] = _O; /*7440*/
		$1.checksum = 0; /*7442*/
		for (var _S = 0, _R = $1.barlen - 1; _S <= _R; _S += 1) { /*7446*/
			$1.checksum = $get($1.charvals, $geti($1.barcode, _S, 1)) + $1.checksum; /*7445*/
		} /*7445*/
		$1.checksum = $1.checksum % 35; /*7447*/
		if ($1.validatecheck) { /*7454*/
			if ($get($1.barcode, $1.barlen) != $get($1.barchars, $1.checksum)) { /*7451*/
				$k[$j++] = "bwipp.bc412badCheckDigit"; /*7450*/
				$k[$j++] = "Incorrect BC412 check digit provided"; /*7450*/
				$0.raiseerror(); /*7450*/
			} /*7450*/
			$1.barcode = $geti($1.barcode, 0, $1.barlen); /*7452*/
			$1.includecheck = true; /*7453*/
		} /*7453*/
		$1.encs = $a(["11111115", "13111212", "11131113", "12111213", "12121311", "13131111", "12111312", "11131212", "11121411", "11151111", "15111111", "11111511", "12131211", "13121112", "13111212", "11111214", "12121113", "11111313", "13111113", "11121213", "11141112", "11121312", "11141211", "14121111", "12121212", "11131311", "13121211", "12111411", "14111211", "11111412", "12111114", "14111112", "12141111", "11121114", "12131112", "12", "111"]); /*7466*/
		$1.sbs = $s((($1.barlen + 1) * 8) + 5); /*7468*/
		if ($1.includecheck) { /*7472*/
			$1.txt = $a($1.barlen + 1); /*7470*/
		} else { /*7472*/
			$1.txt = $a($1.barlen); /*7472*/
		} /*7472*/
		if ($1.includestartstop) { /*7482*/
			$puti($1.sbs, 0, $get($1.encs, 35)); /*7477*/
			$1.pos = 2; /*7478*/
			$1.txtpos = 3; /*7479*/
		} else { /*7482*/
			$1.pos = 0; /*7481*/
			$1.txtpos = 0; /*7482*/
		} /*7482*/
		for (var _x = 0, _w = $1.barlen - 1; _x <= _w; _x += 1) { /*7491*/
			$1.i = _x; /*7486*/
			$1.indx = $get($1.charvals, $geti($1.barcode, $1.i, 1)); /*7487*/
			$puti($1.sbs, $1.pos, $get($1.encs, $1.indx)); /*7488*/
			$put($1.txt, $1.i, $a([$geti($1.barcode, $1.i, 1), ($1.i * 12) + $1.txtpos, $1.textyoffset, $1.textfont, $1.textsize])); /*7489*/
			$1.pos = $1.pos + 8; /*7490*/
		} /*7490*/
		if ($1.includecheck) { /*7502*/
			$puti($1.sbs, $1.pos, $get($1.encs, $1.checksum)); /*7495*/
			if ($1.includecheckintext) { /*7499*/
				$put($1.txt, $1.barlen, $a([$geti($1.barchars, $1.checksum, 1), ($1.barlen * 12) + $1.txtpos, $1.textyoffset, $1.textfont, $1.textsize])); /*7497*/
			} else { /*7499*/
				$put($1.txt, $1.barlen, $a(["", ($1.barlen * 12) + $1.txtpos, $1.textyoffset, $1.textfont, $1.textsize])); /*7499*/
			} /*7499*/
			$1.pos = $1.pos + 8; /*7501*/
		} /*7501*/
		if ($1.includestartstop) { /*7508*/
			$puti($1.sbs, $1.pos, $get($1.encs, 36)); /*7506*/
			$1.pos = $1.pos + 2; /*7507*/
		} /*7507*/
		$1.sbs = $geti($1.sbs, 0, $1.pos); /*7511*/
		$k[$j++] = Infinity; /*7520*/
		$k[$j++] = "ren"; /*7514*/
		$k[$j++] = $0.renlinear; /*7514*/
		$k[$j++] = "sbs"; /*7514*/
		$k[$j++] = Infinity; /*7514*/
		$forall($1.sbs, function() { /*7514*/
			var _1v = $k[--$j]; /*7514*/
			$k[$j++] = _1v - 48; /*7514*/
		}) /*7514*/
		var _1w = $a(); /*7514*/
		$k[$j++] = _1w; /*7515*/
		$k[$j++] = "bhs"; /*7515*/
		$k[$j++] = Infinity; /*7515*/
		for (var _1y = 0, _1z = ~~(($1.sbs.length + 1) / 2); _1y < _1z; _1y++) { /*7515*/
			$k[$j++] = $1.height; /*7515*/
		} /*7515*/
		var _21 = $a(); /*7515*/
		$k[$j++] = _21; /*7516*/
		$k[$j++] = "bbs"; /*7516*/
		$k[$j++] = Infinity; /*7516*/
		for (var _23 = 0, _24 = ~~(($1.sbs.length + 1) / 2); _23 < _24; _23++) { /*7516*/
			$k[$j++] = 0; /*7516*/
		} /*7516*/
		var _25 = $a(); /*7516*/
		$k[$j++] = _25; /*7519*/
		if ($1.includetext) { /*7519*/
			$k[$j++] = "txt"; /*7518*/
			$k[$j++] = $1.txt; /*7518*/
		} /*7518*/
		$k[$j++] = "opt"; /*7520*/
		$k[$j++] = $1.options; /*7520*/
		var _29 = $d(); /*7520*/
		$k[$j++] = _29; /*7523*/
		if (!$1.dontdraw) { /*7523*/
			$0.renlinear(); /*7523*/
		} /*7523*/
	};
	$0.rationalizedCodabar = function() {
		var $1 = {}; /*7550*/
		$1.options = $k[--$j]; /*7552*/
		$1.barcode = $k[--$j]; /*7553*/
		$1.dontdraw = false; /*7555*/
		$1.altstartstop = false; /*7556*/
		$1.includecheck = false; /*7557*/
		$1.validatecheck = false; /*7558*/
		$1.includetext = false; /*7559*/
		$1.includecheckintext = false; /*7560*/
		$1.textfont = "Courier"; /*7561*/
		$1.textsize = 10; /*7562*/
		$1.textyoffset = -8.5; /*7563*/
		$1.height = 1; /*7564*/
		$forall($1.options, function() { /*7575*/
			var _3 = $k[--$j]; /*7575*/
			$1[$k[--$j]] = _3; /*7575*/
		}) /*7575*/
		$1.textfont = "" + $1.textfont; /*7577*/
		$1.textsize = +$1.textsize; /*7578*/
		$1.textyoffset = +$1.textyoffset; /*7579*/
		$1.height = +$1.height; /*7580*/
		$1.encs = $a(["11111331", "11113311", "11131131", "33111111", "11311311", "31111311", "13111131", "13113111", "13311111", "31131111", "11133111", "11331111", "31113131", "31311131", "31313111", "11313131", "11331311", "13131131", "11131331", "11133311"]); /*7588*/
		if ($1.altstartstop) { /*7594*/
			$1.barchars = "0123456789-$:/.+TN*E"; /*7592*/
		} else { /*7594*/
			$1.barchars = "0123456789-$:/.+ABCD"; /*7594*/
		} /*7594*/
		$1.charvals = {}; /*7596*/
		for (var _B = 0; _B <= 19; _B += 1) { /*7597*/
			$put($1.charvals, $geti($1.barchars, _B, 1), _B); /*7597*/
		} /*7597*/
		$1.bodyvals = {}; /*7598*/
		for (var _F = 0; _F <= 15; _F += 1) { /*7599*/
			$put($1.bodyvals, $geti($1.barchars, _F, 1), _F); /*7599*/
		} /*7599*/
		$1.ssvals = {}; /*7600*/
		for (var _J = 16; _J <= 19; _J += 1) { /*7601*/
			$put($1.ssvals, $geti($1.barchars, _J, 1), _J); /*7601*/
		} /*7601*/
		var _Q = $get($1.ssvals, $geti($1.barcode, 0, 1)) !== undefined; /*7604*/
		var _V = $get($1.ssvals, $geti($1.barcode, $1.barcode.length - 1, 1)) !== undefined; /*7605*/
		if ((!_Q) || (!_V)) { /*7611*/
			if ($1.altstartstop) { /*7609*/
				$k[$j++] = "bwipp.rationalizedCodabarBadAltStartStop"; /*7607*/
				$k[$j++] = "Codabar start and stop characters must be one of E N T or *"; /*7607*/
				$0.raiseerror(); /*7607*/
			} else { /*7609*/
				$k[$j++] = "bwipp.rationalizedCodabarBadStartStop"; /*7609*/
				$k[$j++] = "Codabar start and stop characters must be one of A B C or D"; /*7609*/
				$0.raiseerror(); /*7609*/
			} /*7609*/
		} /*7609*/
		for (var _Z = 1, _Y = $1.barcode.length - 2; _Z <= _Y; _Z += 1) { /*7616*/
			var _d = $get($1.bodyvals, $geti($1.barcode, _Z, 1)) !== undefined; /*7613*/
			if (!_d) { /*7615*/
				$k[$j++] = "bwipp.rationalizedCodabarBadCharacter"; /*7614*/
				$k[$j++] = "Codabar body must contain only digits and symbols - $ : / . +"; /*7614*/
				$0.raiseerror(); /*7614*/
			} /*7614*/
		} /*7614*/
		$k[$j++] = "barlen"; /*7618*/
		$k[$j++] = $1.barcode.length; /*7618*/
		if ($1.validatecheck) { /*7618*/
			var _g = $k[--$j]; /*7618*/
			$k[$j++] = _g - 1; /*7618*/
		} /*7618*/
		var _h = $k[--$j]; /*7618*/
		$1[$k[--$j]] = _h; /*7618*/
		$1.checksum = 0; /*7620*/
		for (var _l = 0, _k = $1.barlen - 2; _l <= _k; _l += 1) { /*7624*/
			$1.checksum = $get($1.charvals, $geti($1.barcode, _l, 1)) + $1.checksum; /*7623*/
		} /*7623*/
		$1.checksum = $get($1.charvals, $geti($1.barcode, $1.barcode.length - 1, 1)) + $1.checksum; /*7626*/
		$1.checksum = (16 - ($1.checksum % 16)) % 16; /*7627*/
		if ($1.validatecheck) { /*7637*/
			if ($get($1.barcode, $1.barlen - 1) != $get($1.barchars, $1.checksum)) { /*7631*/
				$k[$j++] = "bwipp.rationalizedCodabarBadCheckDigit"; /*7630*/
				$k[$j++] = "Incorrect Codabar check digit provided"; /*7630*/
				$0.raiseerror(); /*7630*/
			} /*7630*/
			var _16 = $s($1.barlen); /*7632*/
			$puti(_16, 0, $geti($1.barcode, 0, $1.barlen - 1)); /*7633*/
			$puti(_16, $1.barlen - 1, $geti($1.barcode, $1.barlen, 1)); /*7634*/
			$1.barcode = _16; /*7635*/
			$1.includecheck = true; /*7636*/
		} /*7636*/
		$k[$j++] = "sbs"; /*7639*/
		$k[$j++] = $1.barlen; /*7639*/
		if ($1.includecheck) { /*7639*/
			var _1G = $k[--$j]; /*7639*/
			$k[$j++] = _1G + 1; /*7639*/
		} /*7639*/
		var _1I = $s($k[--$j] * 8); /*7639*/
		$1[$k[--$j]] = _1I; /*7639*/
		$k[$j++] = "txt"; /*7640*/
		$k[$j++] = $1.barlen; /*7640*/
		if ($1.includecheck) { /*7640*/
			var _1M = $k[--$j]; /*7640*/
			$k[$j++] = _1M + 1; /*7640*/
		} /*7640*/
		var _1O = $a($k[--$j]); /*7640*/
		$1[$k[--$j]] = _1O; /*7640*/
		$1.xpos = 0; /*7642*/
		for (var _1S = 0, _1R = $1.barlen - 2; _1S <= _1R; _1S += 1) { /*7652*/
			$1.i = _1S; /*7644*/
			$1.indx = $get($1.charvals, $geti($1.barcode, $1.i, 1)); /*7645*/
			$1.enc = $get($1.encs, $1.indx); /*7646*/
			$puti($1.sbs, $1.i * 8, $1.enc); /*7647*/
			$put($1.txt, $1.i, $a([$geti($1.barcode, $1.i, 1), $1.xpos, $1.textyoffset, $1.textfont, $1.textsize])); /*7648*/
			for (var _1o = 0; _1o <= 7; _1o += 1) { /*7651*/
				$1.xpos = ($get($1.enc, _1o) - 48) + $1.xpos; /*7650*/
			} /*7650*/
		} /*7650*/
		if ($1.includecheck) { /*7676*/
			$puti($1.sbs, ($1.barlen * 8) - 8, $get($1.encs, $1.checksum)); /*7657*/
			if ($1.includecheckintext) { /*7661*/
				$put($1.txt, $1.barlen - 1, $a([$geti($1.barchars, $1.checksum, 1), $1.xpos, $1.textyoffset, $1.textfont, $1.textsize])); /*7659*/
			} else { /*7661*/
				$put($1.txt, $1.barlen - 1, $a([" ", $1.xpos, $1.textyoffset, $1.textfont, $1.textsize])); /*7661*/
			} /*7661*/
			for (var _2G = 0; _2G <= 7; _2G += 1) { /*7665*/
				$1.xpos = ($get($get($1.encs, $1.checksum), _2G) - 48) + $1.xpos; /*7664*/
			} /*7664*/
			$1.indx = $get($1.charvals, $geti($1.barcode, $1.barlen - 1, 1)); /*7667*/
			$1.enc = $get($1.encs, $1.indx); /*7668*/
			$puti($1.sbs, $1.barlen * 8, $1.enc); /*7669*/
			$put($1.txt, $1.barlen, $a([$geti($1.barcode, $1.barlen - 1, 1), $1.xpos, $1.textyoffset, $1.textfont, $1.textsize])); /*7670*/
		} else { /*7676*/
			$1.indx = $get($1.charvals, $geti($1.barcode, $1.barlen - 1, 1)); /*7673*/
			$1.enc = $get($1.encs, $1.indx); /*7674*/
			$puti($1.sbs, ($1.barlen * 8) - 8, $1.enc); /*7675*/
			$put($1.txt, $1.barlen - 1, $a([$geti($1.barcode, $1.barlen - 1, 1), $1.xpos, $1.textyoffset, $1.textfont, $1.textsize])); /*7676*/
		} /*7676*/
		$k[$j++] = Infinity; /*7688*/
		$k[$j++] = "ren"; /*7682*/
		$k[$j++] = $0.renlinear; /*7682*/
		$k[$j++] = "sbs"; /*7682*/
		$k[$j++] = Infinity; /*7682*/
		$forall($1.sbs, function() { /*7682*/
			var _33 = $k[--$j]; /*7682*/
			$k[$j++] = _33 - 48; /*7682*/
		}) /*7682*/
		var _34 = $a(); /*7682*/
		$k[$j++] = _34; /*7683*/
		$k[$j++] = "bhs"; /*7683*/
		$k[$j++] = Infinity; /*7683*/
		for (var _36 = 0, _37 = ~~(($1.sbs.length + 1) / 2); _36 < _37; _36++) { /*7683*/
			$k[$j++] = $1.height; /*7683*/
		} /*7683*/
		var _39 = $a(); /*7683*/
		$k[$j++] = _39; /*7684*/
		$k[$j++] = "bbs"; /*7684*/
		$k[$j++] = Infinity; /*7684*/
		for (var _3B = 0, _3C = ~~(($1.sbs.length + 1) / 2); _3B < _3C; _3B++) { /*7684*/
			$k[$j++] = 0; /*7684*/
		} /*7684*/
		var _3D = $a(); /*7684*/
		$k[$j++] = _3D; /*7687*/
		if ($1.includetext) { /*7687*/
			$k[$j++] = "txt"; /*7686*/
			$k[$j++] = $1.txt; /*7686*/
		} /*7686*/
		$k[$j++] = "opt"; /*7688*/
		$k[$j++] = $1.options; /*7688*/
		var _3H = $d(); /*7688*/
		$k[$j++] = _3H; /*7691*/
		if (!$1.dontdraw) { /*7691*/
			$0.renlinear(); /*7691*/
		} /*7691*/
	};
	$0.onecode = function() {
		var $1 = {}; /*7718*/
		$1.options = $k[--$j]; /*7720*/
		$1.barcode = $k[--$j]; /*7721*/
		$1.dontdraw = false; /*7723*/
		$1.height = 0.15; /*7724*/
		$forall($1.options, function() { /*7735*/
			var _3 = $k[--$j]; /*7735*/
			$1[$k[--$j]] = _3; /*7735*/
		}) /*7735*/
		$1.height = +$1.height; /*7737*/
		$1.barlen = $1.barcode.length; /*7739*/
		$k[$j++] = "txtdict"; /*7748*/
		$k[$j++] = Infinity; /*7748*/
		var _9 = $eq($geti($1.barcode, 5, 1), "9") ? 14 : 11; /*7745*/
		$k[$j++] = 2; /*7748*/
		$k[$j++] = 2; /*7748*/
		$k[$j++] = 5; /*7748*/
		$k[$j++] = 5; /*7748*/
		$k[$j++] = _9; /*7748*/
		$k[$j++] = _9; /*7748*/
		$k[$j++] = 20; /*7748*/
		$k[$j++] = 20; /*7748*/
		$k[$j++] = 25; /*7748*/
		$k[$j++] = 25; /*7748*/
		$k[$j++] = 29; /*7748*/
		$k[$j++] = 29; /*7748*/
		var _A = $d(); /*7748*/
		$1[$k[--$j]] = _A; /*7749*/
		$1.txt = $a($1.barlen + 6); /*7750*/
		$1.spacecnt = 0; /*7751*/
		for (var _G = 0, _F = $1.barlen - 1; _G <= _F; _G += 1) { /*7759*/
			$1.i = _G; /*7753*/
			var _J = $get($1.txtdict, $1.i) !== undefined; /*7754*/
			if (_J) { /*7757*/
				$put($1.txt, $1.i + $1.spacecnt, $a([" ", 0, 0, "", 0])); /*7755*/
				$1.spacecnt = $1.spacecnt + 1; /*7756*/
			} /*7756*/
			$put($1.txt, $1.i + $1.spacecnt, $a([$geti($1.barcode, $1.i, 1), 0, 0, "", 0])); /*7758*/
		} /*7758*/
		$1.txt = $geti($1.txt, 0, $1.barcode.length + $1.spacecnt); /*7760*/
		$1.normalize = function() {
			$1.base = $k[--$j]; /*7763*/
			$1.num = $k[--$j]; /*7764*/
			for (var _d = $1.num.length - 1; _d >= 1; _d -= 1) { /*7769*/
				$1.i = _d; /*7766*/
				var _e = $1.num; /*7767*/
				var _f = $1.i; /*7767*/
				$put(_e, _f - 1, $get(_e, _f - 1) + (~~($get($1.num, $1.i) / $1.base))); /*7767*/
				$put($1.num, $1.i, $get($1.num, $1.i) % $1.base); /*7768*/
			} /*7768*/
			for (;;) { /*7775*/
				if ($lt($get($1.num, 0), $1.base)) { /*7771*/
					break; /*7771*/
				} /*7771*/
				$k[$j++] = "num"; /*7772*/
				$k[$j++] = Infinity; /*7772*/
				$k[$j++] = 0; /*7772*/
				$forall($1.num); /*7772*/
				var _v = $a(); /*7772*/
				$1[$k[--$j]] = _v; /*7772*/
				$put($1.num, 0, $get($1.num, 0) + (~~($get($1.num, 1) / $1.base))); /*7773*/
				$put($1.num, 1, $get($1.num, 1) % $1.base); /*7774*/
			} /*7774*/
			$k[$j++] = "num"; /*7777*/
			$k[$j++] = Infinity; /*7777*/
			$1.i = true; /*7777*/
			$forall($1.num, function() { /*7777*/
				var _18 = $k[--$j]; /*7777*/
				$k[$j++] = _18; /*7777*/
				if ((_18 == 0) && $1.i) { /*7777*/
					$j--; /*7777*/
				} else { /*7777*/
					$1.i = false; /*7777*/
				} /*7777*/
			}) /*7777*/
			var _1A = $a(); /*7777*/
			$1[$k[--$j]] = _1A; /*7777*/
			if ($1.num.length == 0) { /*7778*/
				$1.num = $a([0]); /*7778*/
			} /*7778*/
			$k[$j++] = $1.num; /*7779*/
		}; /*7780*/
		$1.bigadd = function() {
			var _1F = $k[--$j]; /*7783*/
			var _1G = $k[--$j]; /*7783*/
			$1.offset = Math.abs(_1F.length - _1G.length); /*7784*/
			if (_1F.length < _1G.length) { /*7785*/
				var _ = _1F; /*7785*/
				_1F = _1G; /*7785*/
				_1G = _; /*7785*/
			} /*7785*/
			$1.a = _1F; /*7786*/
			$1.b = _1G; /*7786*/
			for (var _1J = 0, _1I = $1.b.length - 1; _1J <= _1I; _1J += 1) { /*7789*/
				var _1K = $1.a; /*7788*/
				var _1L = $1.offset; /*7788*/
				$put(_1K, _1J + _1L, $get(_1K, _1J + _1L) + $get($1.b, _1J)); /*7788*/
			} /*7788*/
			$k[$j++] = $1.a; /*7790*/
		}; /*7791*/
		if ($1.barlen == 20) { /*7794*/
			$k[$j++] = $a([0]); /*7794*/
		} /*7794*/
		if ($1.barlen == 25) { /*7795*/
			$k[$j++] = $a([1]); /*7795*/
		} /*7795*/
		if ($1.barlen == 29) { /*7796*/
			$k[$j++] = $a([1, 0, 0, 0, 0, 1]); /*7796*/
		} /*7796*/
		if ($1.barlen == 31) { /*7797*/
			$k[$j++] = $a([1, 0, 0, 0, 1, 0, 0, 0, 0, 1]); /*7797*/
		} /*7797*/
		var _1Y = $k[--$j]; /*7798*/
		$k[$j++] = "binval"; /*7798*/
		$k[$j++] = _1Y; /*7798*/
		$k[$j++] = Infinity; /*7798*/
		$forall($geti($1.barcode, 20, $1.barlen - 20), function() { /*7798*/
			var _1c = $k[--$j]; /*7798*/
			$k[$j++] = _1c - 48; /*7798*/
		}) /*7798*/
		var _1d = $a(); /*7798*/
		$k[$j++] = _1d; /*7798*/
		$1.bigadd(); /*7798*/
		var _1e = $k[--$j]; /*7798*/
		$1[$k[--$j]] = _1e; /*7798*/
		$k[$j++] = "binval"; /*7799*/
		$k[$j++] = Infinity; /*7799*/
		$forall($1.binval); /*7799*/
		$k[$j++] = $get($1.barcode, 0) - 48; /*7799*/
		var _1j = $a(); /*7799*/
		$1[$k[--$j]] = _1j; /*7799*/
		$k[$j++] = "binval"; /*7800*/
		$k[$j++] = Infinity; /*7800*/
		$forall($1.binval, function() { /*7800*/
			var _1m = $k[--$j]; /*7800*/
			$k[$j++] = _1m * 5; /*7800*/
		}) /*7800*/
		var _1n = $a(); /*7800*/
		$k[$j++] = _1n; /*7800*/
		$k[$j++] = $a([$get($1.barcode, 1) - 48]); /*7800*/
		$1.bigadd(); /*7800*/
		$k[$j++] = 10; /*7800*/
		$1.normalize(); /*7800*/
		var _1r = $k[--$j]; /*7800*/
		$1[$k[--$j]] = _1r; /*7800*/
		$k[$j++] = "binval"; /*7801*/
		$k[$j++] = Infinity; /*7801*/
		$forall($1.binval); /*7801*/
		$forall($geti($1.barcode, 2, 18), function() { /*7801*/
			var _1w = $k[--$j]; /*7801*/
			$k[$j++] = _1w - 48; /*7801*/
		}) /*7801*/
		var _1x = $a(); /*7801*/
		$1[$k[--$j]] = _1x; /*7801*/
		$1.bytes = $a(13); /*7804*/
		$k[$j++] = "bintmp"; /*7805*/
		$k[$j++] = Infinity; /*7805*/
		$forall($1.binval); /*7805*/
		var _21 = $a(); /*7805*/
		$1[$k[--$j]] = _21; /*7805*/
		for (var _23 = 12; _23 >= 0; _23 -= 1) { /*7815*/
			$1.i = _23; /*7807*/
			for (var _26 = 0, _25 = $1.bintmp.length - 2; _26 <= _25; _26 += 1) { /*7812*/
				$1.j = _26; /*7809*/
				var _27 = $1.bintmp; /*7810*/
				var _28 = $1.j; /*7810*/
				$put(_27, _28 + 1, $get(_27, _28 + 1) + (($get($1.bintmp, $1.j) % 256) * 10)); /*7810*/
				$put($1.bintmp, $1.j, ~~($get($1.bintmp, $1.j) / 256)); /*7811*/
			} /*7811*/
			$put($1.bytes, $1.i, $get($1.bintmp, $1.bintmp.length - 1) % 256); /*7813*/
			var _2N = $1.bintmp; /*7814*/
			var _2O = $1.bintmp; /*7814*/
			$put(_2N, _2O.length - 1, ~~($get(_2N, _2O.length - 1) / 256)); /*7814*/
		} /*7814*/
		$1.fcs = 2047; /*7818*/
		$1.dat = $get($1.bytes, 0) << 5; /*7819*/
		for (var _2S = 0, _2T = 6; _2S < _2T; _2S++) { /*7828*/
			if ((($1.fcs ^ $1.dat) & 1024) != 0) { /*7824*/
				$1.fcs = ($1.fcs << 1) ^ 3893; /*7822*/
			} else { /*7824*/
				$1.fcs = $1.fcs << 1; /*7824*/
			} /*7824*/
			$1.fcs = $1.fcs & 2047; /*7826*/
			$1.dat = $1.dat << 1; /*7827*/
		} /*7827*/
		for (var _2a = 1; _2a <= 12; _2a += 1) { /*7840*/
			$1.dat = $get($1.bytes, _2a) << 3; /*7830*/
			for (var _2d = 0, _2e = 8; _2d < _2e; _2d++) { /*7839*/
				if ((($1.fcs ^ $1.dat) & 1024) != 0) { /*7835*/
					$1.fcs = ($1.fcs << 1) ^ 3893; /*7833*/
				} else { /*7835*/
					$1.fcs = $1.fcs << 1; /*7835*/
				} /*7835*/
				$1.fcs = $1.fcs & 2047; /*7837*/
				$1.dat = $1.dat << 1; /*7838*/
			} /*7838*/
		} /*7838*/
		$1.codewords = $a(10); /*7843*/
		for (var _2m = 9; _2m >= 0; _2m -= 1) { /*7858*/
			$1.i = _2m; /*7845*/
			if ($1.i == 9) { /*7849*/
				$1.b = 636; /*7847*/
			} else { /*7849*/
				$1.b = 1365; /*7849*/
			} /*7849*/
			for (var _2q = 0, _2p = $1.binval.length - 2; _2q <= _2p; _2q += 1) { /*7855*/
				$1.j = _2q; /*7852*/
				var _2r = $1.binval; /*7853*/
				var _2s = $1.j; /*7853*/
				$put(_2r, _2s + 1, $get(_2r, _2s + 1) + (($get($1.binval, $1.j) % $1.b) * 10)); /*7853*/
				$put($1.binval, $1.j, ~~($get($1.binval, $1.j) / $1.b)); /*7854*/
			} /*7854*/
			$put($1.codewords, $1.i, $get($1.binval, $1.binval.length - 1) % $1.b); /*7856*/
			var _3A = $1.binval; /*7857*/
			var _3B = $1.binval; /*7857*/
			$put(_3A, _3B.length - 1, ~~($get(_3A, _3B.length - 1) / $1.b)); /*7857*/
		} /*7857*/
		$put($1.codewords, 9, $get($1.codewords, 9) * 2); /*7861*/
		if (($1.fcs & 1024) != 0) { /*7864*/
			$put($1.codewords, 0, $get($1.codewords, 0) + 659); /*7863*/
		} /*7863*/
		$1.tab513 = $a([31, 7936, 47, 7808, 55, 7552, 59, 7040, 61, 6016, 62, 3968, 79, 7744, 87, 7488, 91, 6976, 93, 5952, 94, 3904, 103, 7360, 107, 6848, 109, 5824, 110, 3776, 115, 6592, 117, 5568, 118, 3520, 121, 5056, 122, 3008, 124, 1984, 143, 7712, 151, 7456, 155, 6944, 157, 5920, 158, 3872, 167, 7328, 171, 6816, 173, 5792, 174, 3744, 179, 6560, 181, 5536, 182, 3488, 185, 5024, 186, 2976, 188, 1952, 199, 7264, 203, 6752, 205, 5728, 206, 3680, 211, 6496, 213, 5472, 214, 3424, 217, 4960, 218, 2912, 220, 1888, 227, 6368, 229, 5344, 230, 3296, 233, 4832, 234, 2784, 236, 1760, 241, 4576, 242, 2528, 244, 1504, 248, 992, 271, 7696, 279, 7440, 283, 6928, 285, 5904, 286, 3856, 295, 7312, 299, 6800, 301, 5776, 302, 3728, 307, 6544, 309, 5520, 310, 3472, 313, 5008, 314, 2960, 316, 1936, 327, 7248, 331, 6736, 333, 5712, 334, 3664, 339, 6480, 341, 5456, 342, 3408, 345, 4944, 346, 2896, 348, 1872, 355, 6352, 357, 5328, 358, 3280, 361, 4816, 362, 2768, 364, 1744, 369, 4560, 370, 2512, 372, 1488, 376, 976, 391, 7216, 395, 6704, 397, 5680, 398, 3632, 403, 6448, 405, 5424, 406, 3376, 409, 4912, 410, 2864, 412, 1840, 419, 6320, 421, 5296, 422, 3248, 425, 4784, 426, 2736, 428, 1712, 433, 4528, 434, 2480, 436, 1456, 440, 944, 451, 6256, 453, 5232, 454, 3184, 457, 4720, 458, 2672, 460, 1648, 465, 4464, 466, 2416, 468, 1392, 472, 880, 481, 4336, 482, 2288, 484, 1264, 488, 752, 527, 7688, 535, 7432, 539, 6920, 541, 5896, 542, 3848, 551, 7304, 555, 6792, 557, 5768, 558, 3720, 563, 6536, 565, 5512, 566, 3464, 569, 5000, 570, 2952, 572, 1928, 583, 7240, 587, 6728, 589, 5704, 590, 3656, 595, 6472, 597, 5448, 598, 3400, 601, 4936, 602, 2888, 604, 1864, 611, 6344, 613, 5320, 614, 3272, 617, 4808, 618, 2760, 620, 1736, 625, 4552, 626, 2504, 628, 1480, 632, 968, 647, 7208, 651, 6696, 653, 5672, 654, 3624, 659, 6440, 661, 5416, 662, 3368, 665, 4904, 666, 2856, 668, 1832, 675, 6312, 677, 5288, 678, 3240, 681, 4776, 682, 2728, 684, 1704, 689, 4520, 690, 2472, 692, 1448, 696, 936, 707, 6248, 709, 5224, 710, 3176, 713, 4712, 714, 2664, 716, 1640, 721, 4456, 722, 2408, 724, 1384, 728, 872, 737, 4328, 738, 2280, 740, 1256, 775, 7192, 779, 6680, 781, 5656, 782, 3608, 787, 6424, 789, 5400, 790, 3352, 793, 4888, 794, 2840, 796, 1816, 803, 6296, 805, 5272, 806, 3224, 809, 4760, 810, 2712, 812, 1688, 817, 4504, 818, 2456, 820, 1432, 824, 920, 835, 6232, 837, 5208, 838, 3160, 841, 4696, 842, 2648, 844, 1624, 849, 4440, 850, 2392, 852, 1368, 865, 4312, 866, 2264, 868, 1240, 899, 6200, 901, 5176, 902, 3128, 905, 4664, 906, 2616, 908, 1592, 913, 4408, 914, 2360, 916, 1336, 929, 4280, 930, 2232, 932, 1208, 961, 4216, 962, 2168, 964, 1144, 1039, 7684, 1047, 7428, 1051, 6916, 1053, 5892, 1054, 3844, 1063, 7300, 1067, 6788, 1069, 5764, 1070, 3716, 1075, 6532, 1077, 5508, 1078, 3460, 1081, 4996, 1082, 2948, 1084, 1924, 1095, 7236, 1099, 6724, 1101, 5700, 1102, 3652, 1107, 6468, 1109, 5444, 1110, 3396, 1113, 4932, 1114, 2884, 1116, 1860, 1123, 6340, 1125, 5316, 1126, 3268, 1129, 4804, 1130, 2756, 1132, 1732, 1137, 4548, 1138, 2500, 1140, 1476, 1159, 7204, 1163, 6692, 1165, 5668, 1166, 3620, 1171, 6436, 1173, 5412, 1174, 3364, 1177, 4900, 1178, 2852, 1180, 1828, 1187, 6308, 1189, 5284, 1190, 3236, 1193, 4772, 1194, 2724, 1196, 1700, 1201, 4516, 1202, 2468, 1204, 1444, 1219, 6244, 1221, 5220, 1222, 3172, 1225, 4708, 1226, 2660, 1228, 1636, 1233, 4452, 1234, 2404, 1236, 1380, 1249, 4324, 1250, 2276, 1287, 7188, 1291, 6676, 1293, 5652, 1294, 3604, 1299, 6420, 1301, 5396, 1302, 3348, 1305, 4884, 1306, 2836, 1308, 1812, 1315, 6292, 1317, 5268, 1318, 3220, 1321, 4756, 1322, 2708, 1324, 1684, 1329, 4500, 1330, 2452, 1332, 1428, 1347, 6228, 1349, 5204, 1350, 3156, 1353, 4692, 1354, 2644, 1356, 1620, 1361, 4436, 1362, 2388, 1377, 4308, 1378, 2260, 1411, 6196, 1413, 5172, 1414, 3124, 1417, 4660, 1418, 2612, 1420, 1588, 1425, 4404, 1426, 2356, 1441, 4276, 1442, 2228, 1473, 4212, 1474, 2164, 1543, 7180, 1547, 6668, 1549, 5644, 1550, 3596, 1555, 6412, 1557, 5388, 1558, 3340, 1561, 4876, 1562, 2828, 1564, 1804, 1571, 6284, 1573, 5260, 1574, 3212, 1577, 4748, 1578, 2700, 1580, 1676, 1585, 4492, 1586, 2444, 1603, 6220, 1605, 5196, 1606, 3148, 1609, 4684, 1610, 2636, 1617, 4428, 1618, 2380, 1633, 4300, 1634, 2252, 1667, 6188, 1669, 5164, 1670, 3116, 1673, 4652, 1674, 2604, 1681, 4396, 1682, 2348, 1697, 4268, 1698, 2220, 1729, 4204, 1730, 2156, 1795, 6172, 1797, 5148, 1798, 3100, 1801, 4636, 1802, 2588, 1809, 4380, 1810, 2332, 1825, 4252, 1826, 2204, 1857, 4188, 1858, 2140, 1921, 4156, 1922, 2108, 2063, 7682, 2071, 7426, 2075, 6914, 2077, 5890, 2078, 3842, 2087, 7298, 2091, 6786, 2093, 5762, 2094, 3714, 2099, 6530, 2101, 5506, 2102, 3458, 2105, 4994, 2106, 2946, 2119, 7234, 2123, 6722, 2125, 5698, 2126, 3650, 2131, 6466, 2133, 5442, 2134, 3394, 2137, 4930, 2138, 2882, 2147, 6338, 2149, 5314, 2150, 3266, 2153, 4802, 2154, 2754, 2161, 4546, 2162, 2498, 2183, 7202, 2187, 6690, 2189, 5666, 2190, 3618, 2195, 6434, 2197, 5410, 2198, 3362, 2201, 4898, 2202, 2850, 2211, 6306, 2213, 5282, 2214, 3234, 2217, 4770, 2218, 2722, 2225, 4514, 2226, 2466, 2243, 6242, 2245, 5218, 2246, 3170, 2249, 4706, 2250, 2658, 2257, 4450, 2258, 2402, 2273, 4322, 2311, 7186, 2315, 6674, 2317, 5650, 2318, 3602, 2323, 6418, 2325, 5394, 2326, 3346, 2329, 4882, 2330, 2834, 2339, 6290, 2341, 5266, 2342, 3218, 2345, 4754, 2346, 2706, 2353, 4498, 2354, 2450, 2371, 6226, 2373, 5202, 2374, 3154, 2377, 4690, 2378, 2642, 2385, 4434, 2401, 4306, 2435, 6194, 2437, 5170, 2438, 3122, 2441, 4658, 2442, 2610, 2449, 4402, 2465, 4274, 2497, 4210, 2567, 7178, 2571, 6666, 2573, 5642, 2574, 3594, 2579, 6410, 2581, 5386, 2582, 3338, 2585, 4874, 2586, 2826, 2595, 6282, 2597, 5258, 2598, 3210, 2601, 4746, 2602, 2698, 2609, 4490, 2627, 6218, 2629, 5194, 2630, 3146, 2633, 4682, 2641, 4426, 2657, 4298, 2691, 6186, 2693, 5162, 2694, 3114, 2697, 4650, 2705, 4394, 2721, 4266, 2753, 4202, 2819, 6170, 2821, 5146, 2822, 3098, 2825, 4634, 2833, 4378, 2849, 4250, 2881, 4186, 2945, 4154, 3079, 7174, 3083, 6662, 3085, 5638, 3086, 3590, 3091, 6406, 3093, 5382, 3094, 3334, 3097, 4870, 3107, 6278, 3109, 5254, 3110, 3206, 3113, 4742, 3121, 4486, 3139, 6214, 3141, 5190, 3145, 4678, 3153, 4422, 3169, 4294, 3203, 6182, 3205, 5158, 3209, 4646, 3217, 4390, 3233, 4262, 3265, 4198, 3331, 6166, 3333, 5142, 3337, 4630, 3345, 4374, 3361, 4246, 3393, 4182, 3457, 4150, 3587, 6158, 3589, 5134, 3593, 4622, 3601, 4366, 3617, 4238, 3649, 4174, 3713, 4142, 3841, 4126, 4111, 7681, 4119, 7425, 4123, 6913, 4125, 5889, 4135, 7297, 4139, 6785, 4141, 5761, 4147, 6529, 4149, 5505, 4153, 4993, 4167, 7233, 4171, 6721, 4173, 5697, 4179, 6465, 4181, 5441, 4185, 4929, 4195, 6337, 4197, 5313, 4201, 4801, 4209, 4545, 4231, 7201, 4235, 6689, 4237, 5665, 4243, 6433, 4245, 5409, 4249, 4897, 4259, 6305, 4261, 5281, 4265, 4769, 4273, 4513, 4291, 6241, 4293, 5217, 4297, 4705, 4305, 4449, 4359, 7185, 4363, 6673, 4365, 5649, 4371, 6417, 4373, 5393, 4377, 4881, 4387, 6289, 4389, 5265, 4393, 4753, 4401, 4497, 4419, 6225, 4421, 5201, 4425, 4689, 4483, 6193, 4485, 5169, 4489, 4657, 4615, 7177, 4619, 6665, 4621, 5641, 4627, 6409, 4629, 5385, 4633, 4873, 4643, 6281, 4645, 5257, 4649, 4745, 4675, 6217, 4677, 5193, 4739, 6185, 4741, 5161, 4867, 6169, 4869, 5145, 5127, 7173, 5131, 6661, 5133, 5637, 5139, 6405, 5141, 5381, 5155, 6277, 5157, 5253, 5187, 6213, 5251, 6181, 5379, 6165, 5635, 6157, 6151, 7171, 6155, 6659, 6163, 6403, 6179, 6275, 6211, 5189, 4681, 4433, 4321, 3142, 2634, 2386, 2274, 1612, 1364, 1252, 856, 744, 496]); /*7954*/
		$1.tab213 = $a([3, 6144, 5, 5120, 6, 3072, 9, 4608, 10, 2560, 12, 1536, 17, 4352, 18, 2304, 20, 1280, 24, 768, 33, 4224, 34, 2176, 36, 1152, 40, 640, 48, 384, 65, 4160, 66, 2112, 68, 1088, 72, 576, 80, 320, 96, 192, 129, 4128, 130, 2080, 132, 1056, 136, 544, 144, 288, 257, 4112, 258, 2064, 260, 1040, 264, 528, 513, 4104, 514, 2056, 516, 1032, 1025, 4100, 1026, 2052, 2049, 4098, 4097, 2050, 1028, 520, 272, 160]); /*7963*/
		$1.chars = $a(10); /*7965*/
		for (var _3O = 0; _3O <= 9; _3O += 1) { /*7974*/
			$1.i = _3O; /*7967*/
			var _3R = $get($1.codewords, $1.i); /*7968*/
			$k[$j++] = _3R; /*7972*/
			if (_3R <= 1286) { /*7971*/
				var _3U = $get($1.tab513, $k[--$j]); /*7969*/
				$k[$j++] = _3U; /*7969*/
			} else { /*7971*/
				var _3X = $get($1.tab213, $k[--$j] - 1287); /*7971*/
				$k[$j++] = _3X; /*7971*/
			} /*7971*/
			$put($1.chars, $1.i, $k[--$j]); /*7973*/
		} /*7973*/
		for (var _3b = 9; _3b >= 0; _3b -= 1) { /*7981*/
			$1.i = _3b; /*7977*/
			if (((~~Math.pow(2, $1.i)) & $1.fcs) != 0) { /*7980*/
				$put($1.chars, $1.i, $get($1.chars, $1.i) ^ 8191); /*7979*/
			} /*7979*/
		} /*7979*/
		$1.barmap = $a([7, 2, 4, 3, 1, 10, 0, 0, 9, 12, 2, 8, 5, 5, 6, 11, 8, 9, 3, 1, 0, 1, 5, 12, 2, 5, 1, 8, 4, 4, 9, 11, 6, 3, 8, 10, 3, 9, 7, 6, 5, 11, 1, 4, 8, 5, 2, 12, 9, 10, 0, 2, 7, 1, 6, 7, 3, 6, 4, 9, 0, 3, 8, 6, 6, 4, 2, 7, 1, 1, 9, 9, 7, 10, 5, 2, 4, 0, 3, 8, 6, 2, 0, 4, 8, 11, 1, 0, 9, 8, 3, 12, 2, 6, 7, 7, 5, 1, 4, 10, 1, 12, 6, 9, 7, 3, 8, 0, 5, 8, 9, 7, 4, 6, 2, 10, 3, 4, 0, 5, 8, 4, 5, 7, 7, 11, 1, 9, 6, 0, 9, 6, 0, 6, 4, 8, 2, 1, 3, 2, 5, 9, 8, 12, 4, 11, 6, 1, 9, 5, 7, 4, 3, 3, 1, 2, 0, 7, 2, 0, 1, 3, 4, 1, 6, 10, 3, 5, 8, 7, 9, 4, 2, 11, 5, 6, 0, 8, 7, 12, 4, 2, 8, 1, 5, 10, 3, 0, 9, 3, 0, 9, 6, 5, 2, 4, 7, 8, 1, 7, 5, 0, 4, 5, 2, 3, 0, 10, 6, 12, 9, 2, 3, 11, 1, 6, 8, 8, 7, 9, 5, 4, 0, 11, 1, 5, 2, 2, 9, 1, 4, 12, 8, 3, 6, 6, 7, 0, 3, 7, 4, 7, 7, 5, 0, 12, 1, 11, 2, 9, 9, 0, 6, 8, 5, 3, 3, 10, 8, 2]); /*7998*/
		$1.bbs = $a(65); /*8000*/
		$1.bhs = $a(65); /*8001*/
		for (var _3m = 0; _3m <= 64; _3m += 1) { /*8022*/
			$1.i = _3m; /*8003*/
			$1.dec = ($get($1.chars, $get($1.barmap, $1.i * 4)) & (~~Math.pow(2, $get($1.barmap, ($1.i * 4) + 1)))) != 0; /*8004*/
			$1.asc = ($get($1.chars, $get($1.barmap, ($1.i * 4) + 2)) & (~~Math.pow(2, $get($1.barmap, ($1.i * 4) + 3)))) != 0; /*8005*/
			if ((!$1.dec) && (!$1.asc)) { /*8009*/
				$put($1.bbs, $1.i, (3 * $1.height) / 8); /*8007*/
				$put($1.bhs, $1.i, (2 * $1.height) / 8); /*8008*/
			} /*8008*/
			if ((!$1.dec) && $1.asc) { /*8013*/
				$put($1.bbs, $1.i, (3 * $1.height) / 8); /*8011*/
				$put($1.bhs, $1.i, (5 * $1.height) / 8); /*8012*/
			} /*8012*/
			if ($1.dec && (!$1.asc)) { /*8017*/
				$put($1.bbs, $1.i, (0 * $1.height) / 8); /*8015*/
				$put($1.bhs, $1.i, (5 * $1.height) / 8); /*8016*/
			} /*8016*/
			if ($1.dec && $1.asc) { /*8021*/
				$put($1.bbs, $1.i, (0 * $1.height) / 8); /*8019*/
				$put($1.bhs, $1.i, (8 * $1.height) / 8); /*8020*/
			} /*8020*/
		} /*8020*/
		$k[$j++] = Infinity; /*8035*/
		$k[$j++] = "ren"; /*8029*/
		$k[$j++] = $0.renlinear; /*8029*/
		$k[$j++] = "bbs"; /*8029*/
		$k[$j++] = $1.bbs; /*8029*/
		$k[$j++] = "bhs"; /*8029*/
		$k[$j++] = $1.bhs; /*8029*/
		$k[$j++] = "sbs"; /*8029*/
		$k[$j++] = Infinity; /*8029*/
		for (var _4c = 0, _4d = $1.bhs.length - 1; _4c < _4d; _4c++) { /*8029*/
			$k[$j++] = 1.44; /*8029*/
			$k[$j++] = 1.872; /*8029*/
		} /*8029*/
		$k[$j++] = 1.44; /*8029*/
		var _4e = $a(); /*8029*/
		$k[$j++] = _4e; /*8035*/
		$k[$j++] = "txt"; /*8035*/
		$k[$j++] = $1.txt; /*8035*/
		$k[$j++] = "textxalign"; /*8035*/
		$k[$j++] = "left"; /*8035*/
		$k[$j++] = "textfont"; /*8035*/
		$k[$j++] = "Helvetica"; /*8035*/
		$k[$j++] = "textyoffset"; /*8035*/
		$k[$j++] = 1; /*8035*/
		$k[$j++] = "textxoffset"; /*8035*/
		$k[$j++] = -0.3; /*8035*/
		$k[$j++] = "opt"; /*8035*/
		$k[$j++] = $1.options; /*8035*/
		var _4h = $d(); /*8035*/
		$k[$j++] = _4h; /*8038*/
		if (!$1.dontdraw) { /*8038*/
			$0.renlinear(); /*8038*/
		} /*8038*/
	};
	$0.postnet = function() {
		var $1 = {}; /*8065*/
		$1.options = $k[--$j]; /*8067*/
		$1.barcode = $k[--$j]; /*8068*/
		$1.dontdraw = false; /*8070*/
		$1.includetext = false; /*8071*/
		$1.validatecheck = false; /*8072*/
		$1.includecheckintext = false; /*8073*/
		$1.textfont = "Courier"; /*8074*/
		$1.textsize = 10; /*8075*/
		$1.textyoffset = -8.5; /*8076*/
		$1.height = 0.125; /*8077*/
		$forall($1.options, function() { /*8088*/
			var _3 = $k[--$j]; /*8088*/
			$1[$k[--$j]] = _3; /*8088*/
		}) /*8088*/
		$1.textfont = "" + $1.textfont; /*8090*/
		$1.textsize = +$1.textsize; /*8091*/
		$1.textyoffset = +$1.textyoffset; /*8092*/
		$1.height = +$1.height; /*8093*/
		$k[$j++] = "barlen"; /*8095*/
		$k[$j++] = $1.barcode.length; /*8095*/
		if ($1.validatecheck) { /*8095*/
			var _B = $k[--$j]; /*8095*/
			$k[$j++] = _B - 1; /*8095*/
		} /*8095*/
		var _C = $k[--$j]; /*8095*/
		$1[$k[--$j]] = _C; /*8095*/
		if ((($1.barlen != 5) && ($1.barlen != 9)) && ($1.barlen != 11)) { /*8100*/
			$k[$j++] = "bwipp.postnetBadLength"; /*8099*/
			$k[$j++] = "USPS POSTNET must be 5, 9 or 11 digits excluding check digit"; /*8099*/
			$0.raiseerror(); /*8099*/
		} /*8099*/
		$forall($1.barcode, function() { /*8105*/
			var _I = $k[--$j]; /*8102*/
			if ((_I < 48) || (_I > 57)) { /*8104*/
				$k[$j++] = "bwipp.postnetBadCharacter"; /*8103*/
				$k[$j++] = "USPS POSTNET must contain only digits"; /*8103*/
				$0.raiseerror(); /*8103*/
			} /*8103*/
		}) /*8103*/
		$1.barchars = "0123456789"; /*8108*/
		$1.checksum = 0; /*8110*/
		for (var _L = 0, _K = $1.barlen - 1; _L <= _K; _L += 1) { /*8114*/
			$1.i = _L; /*8112*/
			$1.checksum = $1.checksum + ($get($1.barcode, $1.i) - 48); /*8113*/
		} /*8113*/
		$1.checksum = (10 - ($1.checksum % 10)) % 10; /*8115*/
		if ($1.validatecheck) { /*8121*/
			if ($get($1.barcode, $1.barlen) != $get($1.barchars, $1.checksum)) { /*8119*/
				$k[$j++] = "bwipp.postnetBadCheckDigit"; /*8118*/
				$k[$j++] = "Incorrect USPS POSTNET check digit provided"; /*8118*/
				$0.raiseerror(); /*8118*/
			} /*8118*/
			$1.barcode = $geti($1.barcode, 0, $1.barlen); /*8120*/
		} /*8120*/
		$1.encs = $a(["55222", "22255", "22525", "22552", "25225", "25252", "25522", "52225", "52252", "52522", "5", "5"]); /*8128*/
		$1.bhs = $a(($1.barlen * 5) + 7); /*8130*/
		$1.txt = $a($1.barlen + 1); /*8131*/
		$1.enc = $get($1.encs, 10); /*8134*/
		$1.heights = $a($1.enc.length); /*8135*/
		for (var _m = 0, _l = $1.enc.length - 1; _m <= _l; _m += 1) { /*8139*/
			$1.j = _m; /*8137*/
			$put($1.heights, $1.j, ((~~$z($geti($1.enc, $1.j, 1))) * $1.height) / 5); /*8138*/
		} /*8138*/
		$puti($1.bhs, 0, $1.heights); /*8140*/
		for (var _x = 0, _w = $1.barlen - 1; _x <= _w; _x += 1) { /*8152*/
			$1.i = _x; /*8143*/
			$1.enc = $get($1.encs, $get($1.barcode, $1.i) - 48); /*8144*/
			$1.heights = $a($1.enc.length); /*8145*/
			for (var _17 = 0, _16 = $1.enc.length - 1; _17 <= _16; _17 += 1) { /*8149*/
				$1.j = _17; /*8147*/
				$put($1.heights, $1.j, ((~~$z($geti($1.enc, $1.j, 1))) * $1.height) / 5); /*8148*/
			} /*8148*/
			$puti($1.bhs, ($1.i * 5) + 1, $1.heights); /*8150*/
			$put($1.txt, $1.i, $a([$geti($1.barcode, $1.i, 1), (($1.i * 5) + 1) * 3.312, $1.textyoffset, $1.textfont, $1.textsize])); /*8151*/
		} /*8151*/
		$1.enc = $get($1.encs, $1.checksum); /*8155*/
		$1.heights = $a($1.enc.length); /*8156*/
		for (var _1Y = 0, _1X = $1.enc.length - 1; _1Y <= _1X; _1Y += 1) { /*8160*/
			$1.j = _1Y; /*8158*/
			$put($1.heights, $1.j, ((~~$z($geti($1.enc, $1.j, 1))) * $1.height) / 5); /*8159*/
		} /*8159*/
		$puti($1.bhs, ($1.barlen * 5) + 1, $1.heights); /*8161*/
		if ($1.includecheckintext) { /*8166*/
			$put($1.txt, $1.barlen, $a([$geti($1.barchars, $1.checksum, 1), (($1.barlen * 5) + 1) * 3.312, $1.textyoffset, $1.textfont, $1.textsize])); /*8164*/
		} else { /*8166*/
			$put($1.txt, $1.barlen, $a([" ", ((($1.barlen * 5) + 1) * 72) / 25, $1.textyoffset, $1.textfont, $1.textsize])); /*8166*/
		} /*8166*/
		$1.enc = $get($1.encs, 11); /*8170*/
		$1.heights = $a($1.enc.length); /*8171*/
		for (var _26 = 0, _25 = $1.enc.length - 1; _26 <= _25; _26 += 1) { /*8175*/
			$1.j = _26; /*8173*/
			$put($1.heights, $1.j, ((~~$z($geti($1.enc, $1.j, 1))) * $1.height) / 5); /*8174*/
		} /*8174*/
		$puti($1.bhs, ($1.barlen * 5) + 6, $1.heights); /*8176*/
		$k[$j++] = Infinity; /*8187*/
		$k[$j++] = "ren"; /*8182*/
		$k[$j++] = $0.renlinear; /*8182*/
		$k[$j++] = "bhs"; /*8182*/
		$k[$j++] = $1.bhs; /*8182*/
		$k[$j++] = "bbs"; /*8182*/
		$k[$j++] = Infinity; /*8182*/
		for (var _2I = 0, _2J = $1.bhs.length; _2I < _2J; _2I++) { /*8182*/
			$k[$j++] = 0; /*8182*/
		} /*8182*/
		var _2K = $a(); /*8182*/
		$k[$j++] = _2K; /*8183*/
		$k[$j++] = "sbs"; /*8183*/
		$k[$j++] = Infinity; /*8183*/
		for (var _2M = 0, _2N = $1.bhs.length - 1; _2M < _2N; _2M++) { /*8183*/
			$k[$j++] = 1.44; /*8183*/
			$k[$j++] = 1.872; /*8183*/
		} /*8183*/
		$k[$j++] = 1.44; /*8183*/
		var _2O = $a(); /*8183*/
		$k[$j++] = _2O; /*8186*/
		if ($1.includetext) { /*8186*/
			$k[$j++] = "txt"; /*8185*/
			$k[$j++] = $1.txt; /*8185*/
		} /*8185*/
		$k[$j++] = "opt"; /*8187*/
		$k[$j++] = $1.options; /*8187*/
		var _2S = $d(); /*8187*/
		$k[$j++] = _2S; /*8190*/
		if (!$1.dontdraw) { /*8190*/
			$0.renlinear(); /*8190*/
		} /*8190*/
	};
	$0.planet = function() {
		var $1 = {}; /*8217*/
		$1.options = $k[--$j]; /*8219*/
		$1.barcode = $k[--$j]; /*8220*/
		$1.dontdraw = false; /*8222*/
		$1.includetext = false; /*8223*/
		$1.validatecheck = false; /*8224*/
		$1.includecheckintext = false; /*8225*/
		$1.textfont = "Courier"; /*8226*/
		$1.textsize = 10; /*8227*/
		$1.textyoffset = -8.5; /*8228*/
		$1.height = 0.125; /*8229*/
		$forall($1.options, function() { /*8240*/
			var _3 = $k[--$j]; /*8240*/
			$1[$k[--$j]] = _3; /*8240*/
		}) /*8240*/
		$1.textfont = "" + $1.textfont; /*8242*/
		$1.textsize = +$1.textsize; /*8243*/
		$1.textyoffset = +$1.textyoffset; /*8244*/
		$1.height = +$1.height; /*8245*/
		$k[$j++] = "barlen"; /*8247*/
		$k[$j++] = $1.barcode.length; /*8247*/
		if ($1.validatecheck) { /*8247*/
			var _B = $k[--$j]; /*8247*/
			$k[$j++] = _B - 1; /*8247*/
		} /*8247*/
		var _C = $k[--$j]; /*8247*/
		$1[$k[--$j]] = _C; /*8247*/
		if (($1.barlen != 11) && ($1.barlen != 13)) { /*8252*/
			$k[$j++] = "bwipp.planetBadLength"; /*8251*/
			$k[$j++] = "USPS PLANET must be 11 or 13 digits excluding check digit"; /*8251*/
			$0.raiseerror(); /*8251*/
		} /*8251*/
		$forall($1.barcode, function() { /*8257*/
			var _H = $k[--$j]; /*8254*/
			if ((_H < 48) || (_H > 57)) { /*8256*/
				$k[$j++] = "bwipp.planetBadCharacter"; /*8255*/
				$k[$j++] = "USPS PLANET must contain only digits"; /*8255*/
				$0.raiseerror(); /*8255*/
			} /*8255*/
		}) /*8255*/
		$1.barchars = "0123456789"; /*8260*/
		$1.checksum = 0; /*8263*/
		for (var _K = 0, _J = $1.barlen - 1; _K <= _J; _K += 1) { /*8267*/
			$1.i = _K; /*8265*/
			$1.checksum = $1.checksum + ($get($1.barcode, $1.i) - 48); /*8266*/
		} /*8266*/
		$1.checksum = (10 - ($1.checksum % 10)) % 10; /*8268*/
		if ($1.validatecheck) { /*8274*/
			if ($get($1.barcode, $1.barlen) != $get($1.barchars, $1.checksum)) { /*8272*/
				$k[$j++] = "bwipp.planetBadCheckDigit"; /*8271*/
				$k[$j++] = "Incorrect USPS PLANET check digit provided"; /*8271*/
				$0.raiseerror(); /*8271*/
			} /*8271*/
			$1.barcode = $geti($1.barcode, 0, $1.barlen); /*8273*/
		} /*8273*/
		$1.encs = $a(["22555", "55522", "55252", "55225", "52552", "52525", "52255", "25552", "25525", "25255", "5", "5"]); /*8281*/
		$1.bhs = $a(($1.barlen * 5) + 7); /*8283*/
		$1.txt = $a($1.barlen + 1); /*8284*/
		$1.enc = $get($1.encs, 10); /*8287*/
		$1.heights = $a($1.enc.length); /*8288*/
		for (var _l = 0, _k = $1.enc.length - 1; _l <= _k; _l += 1) { /*8292*/
			$1.j = _l; /*8290*/
			$put($1.heights, $1.j, ((~~$z($geti($1.enc, $1.j, 1))) * $1.height) / 5); /*8291*/
		} /*8291*/
		$puti($1.bhs, 0, $1.heights); /*8293*/
		for (var _w = 0, _v = $1.barlen - 1; _w <= _v; _w += 1) { /*8305*/
			$1.i = _w; /*8296*/
			$1.enc = $get($1.encs, $get($1.barcode, $1.i) - 48); /*8297*/
			$1.heights = $a($1.enc.length); /*8298*/
			for (var _16 = 0, _15 = $1.enc.length - 1; _16 <= _15; _16 += 1) { /*8302*/
				$1.j = _16; /*8300*/
				$put($1.heights, $1.j, ((~~$z($geti($1.enc, $1.j, 1))) * $1.height) / 5); /*8301*/
			} /*8301*/
			$puti($1.bhs, ($1.i * 5) + 1, $1.heights); /*8303*/
			$put($1.txt, $1.i, $a([$geti($1.barcode, $1.i, 1), (($1.i * 5) + 1) * 3.312, $1.textyoffset, $1.textfont, $1.textsize])); /*8304*/
		} /*8304*/
		$1.enc = $get($1.encs, $1.checksum); /*8308*/
		$1.heights = $a($1.enc.length); /*8309*/
		for (var _1X = 0, _1W = $1.enc.length - 1; _1X <= _1W; _1X += 1) { /*8313*/
			$1.j = _1X; /*8311*/
			$put($1.heights, $1.j, ((~~$z($geti($1.enc, $1.j, 1))) * $1.height) / 5); /*8312*/
		} /*8312*/
		$puti($1.bhs, ($1.barlen * 5) + 1, $1.heights); /*8314*/
		if ($1.includecheckintext) { /*8319*/
			$put($1.txt, $1.barlen, $a([$geti($1.barchars, $1.checksum, 1), (($1.barlen * 5) + 1) * 3.312, $1.textyoffset, $1.textfont, $1.textsize])); /*8317*/
		} else { /*8319*/
			$put($1.txt, $1.barlen, $a([" ", ((($1.barlen * 5) + 1) * 72) / 25, $1.textyoffset, $1.textfont, $1.textsize])); /*8319*/
		} /*8319*/
		$1.enc = $get($1.encs, 11); /*8323*/
		$1.heights = $a($1.enc.length); /*8324*/
		for (var _25 = 0, _24 = $1.enc.length - 1; _25 <= _24; _25 += 1) { /*8328*/
			$1.j = _25; /*8326*/
			$put($1.heights, $1.j, ((~~$z($geti($1.enc, $1.j, 1))) * $1.height) / 5); /*8327*/
		} /*8327*/
		$puti($1.bhs, ($1.barlen * 5) + 6, $1.heights); /*8329*/
		$k[$j++] = Infinity; /*8340*/
		$k[$j++] = "ren"; /*8335*/
		$k[$j++] = $0.renlinear; /*8335*/
		$k[$j++] = "bhs"; /*8335*/
		$k[$j++] = $1.bhs; /*8335*/
		$k[$j++] = "bbs"; /*8335*/
		$k[$j++] = Infinity; /*8335*/
		for (var _2H = 0, _2I = $1.bhs.length; _2H < _2I; _2H++) { /*8335*/
			$k[$j++] = 0; /*8335*/
		} /*8335*/
		var _2J = $a(); /*8335*/
		$k[$j++] = _2J; /*8336*/
		$k[$j++] = "sbs"; /*8336*/
		$k[$j++] = Infinity; /*8336*/
		for (var _2L = 0, _2M = $1.bhs.length - 1; _2L < _2M; _2L++) { /*8336*/
			$k[$j++] = 1.44; /*8336*/
			$k[$j++] = 1.872; /*8336*/
		} /*8336*/
		$k[$j++] = 1.44; /*8336*/
		var _2N = $a(); /*8336*/
		$k[$j++] = _2N; /*8339*/
		if ($1.includetext) { /*8339*/
			$k[$j++] = "txt"; /*8338*/
			$k[$j++] = $1.txt; /*8338*/
		} /*8338*/
		$k[$j++] = "opt"; /*8340*/
		$k[$j++] = $1.options; /*8340*/
		var _2R = $d(); /*8340*/
		$k[$j++] = _2R; /*8343*/
		if (!$1.dontdraw) { /*8343*/
			$0.renlinear(); /*8343*/
		} /*8343*/
	};
	$0.royalmail = function() {
		var $1 = {}; /*8370*/
		$1.options = $k[--$j]; /*8372*/
		$1.barcode = $k[--$j]; /*8373*/
		$1.dontdraw = false; /*8375*/
		$1.includetext = false; /*8376*/
		$1.validatecheck = false; /*8377*/
		$1.includecheckintext = false; /*8378*/
		$1.textfont = "Courier"; /*8379*/
		$1.textsize = 10; /*8380*/
		$1.textyoffset = -8.5; /*8381*/
		$1.height = 0.175; /*8382*/
		$forall($1.options, function() { /*8393*/
			var _3 = $k[--$j]; /*8393*/
			$1[$k[--$j]] = _3; /*8393*/
		}) /*8393*/
		$1.textfont = "" + $1.textfont; /*8395*/
		$1.textsize = +$1.textsize; /*8396*/
		$1.textyoffset = +$1.textyoffset; /*8397*/
		$1.height = +$1.height; /*8398*/
		$1.barchars = "ZUVWXY501234B6789AHCDEFGNIJKLMTOPQRS"; /*8401*/
		$1.charvals = {}; /*8402*/
		for (var _9 = 0; _9 <= 35; _9 += 1) { /*8403*/
			$put($1.charvals, $geti($1.barchars, _9, 1), _9); /*8403*/
		} /*8403*/
		for (var _F = 0, _E = $1.barcode.length - 1; _F <= _E; _F += 1) { /*8410*/
			var _J = $get($1.charvals, $geti($1.barcode, _F, 1)) !== undefined; /*8407*/
			if (!_J) { /*8409*/
				$k[$j++] = "bwipp.royalmailBadCharacter"; /*8408*/
				$k[$j++] = "RM4SCC must contain only capital letters and digits"; /*8408*/
				$0.raiseerror(); /*8408*/
			} /*8408*/
		} /*8408*/
		$k[$j++] = "barlen"; /*8412*/
		$k[$j++] = $1.barcode.length; /*8412*/
		if ($1.validatecheck) { /*8412*/
			var _M = $k[--$j]; /*8412*/
			$k[$j++] = _M - 1; /*8412*/
		} /*8412*/
		var _N = $k[--$j]; /*8412*/
		$1[$k[--$j]] = _N; /*8412*/
		$1.checksumrow = 0; /*8414*/
		$1.checksumcol = 0; /*8415*/
		for (var _R = 0, _Q = $1.barlen - 1; _R <= _Q; _R += 1) { /*8421*/
			$1.i = _R; /*8417*/
			$1.indx = $get($1.charvals, $geti($1.barcode, $1.i, 1)); /*8418*/
			$1.checksumrow = $1.checksumrow + (~~($1.indx / 6)); /*8419*/
			$1.checksumcol = $1.checksumcol + ($1.indx % 6); /*8420*/
		} /*8420*/
		$1.checksum = (($1.checksumrow % 6) * 6) + ($1.checksumcol % 6); /*8422*/
		if ($1.validatecheck) { /*8428*/
			if ($get($1.barcode, $1.barlen) != $get($1.barchars, $1.checksum)) { /*8426*/
				$k[$j++] = "bwipp.royalmailBadCheckDigit"; /*8425*/
				$k[$j++] = "Incorrect RM4SCC check digit provided"; /*8425*/
				$0.raiseerror(); /*8425*/
			} /*8425*/
			$1.barcode = $geti($1.barcode, 0, $1.barlen); /*8427*/
		} /*8427*/
		$1.encs = $a(["3300", "2211", "2301", "2310", "3201", "3210", "1122", "0033", "0123", "0132", "1023", "1032", "1302", "0213", "0303", "0312", "1203", "1212", "1320", "0231", "0321", "0330", "1221", "1230", "3102", "2013", "2103", "2112", "3003", "3012", "3120", "2031", "2121", "2130", "3021", "3030", "2", "3"]); /*8439*/
		$1.encstr = $s(($1.barlen * 4) + 6); /*8441*/
		$1.txt = $a($1.barlen + 1); /*8442*/
		$puti($1.encstr, 0, $get($1.encs, 36)); /*8445*/
		for (var _x = 0, _w = $1.barlen - 1; _x <= _w; _x += 1) { /*8452*/
			$1.i = _x; /*8448*/
			$1.indx = $get($1.charvals, $geti($1.barcode, $1.i, 1)); /*8449*/
			$puti($1.encstr, ($1.i * 4) + 1, $get($1.encs, $1.indx)); /*8450*/
			$put($1.txt, $1.i, $a([$geti($1.barcode, $1.i, 1), (($1.i * 4) + 1) * 3.312, $1.textyoffset, $1.textfont, $1.textsize])); /*8451*/
		} /*8451*/
		$puti($1.encstr, ($1.barlen * 4) + 1, $get($1.encs, $1.checksum)); /*8455*/
		if ($1.includecheckintext) { /*8459*/
			$put($1.txt, $1.barlen, $a([$geti($1.barchars, $1.checksum, 1), (($1.barlen * 4) + 1) * 3.312, $1.textyoffset, $1.textfont, $1.textsize])); /*8457*/
		} else { /*8459*/
			$put($1.txt, $1.barlen, $a([" ", (($1.barlen * 4) + 1) * 3.312, $1.textyoffset, $1.textfont, $1.textsize])); /*8459*/
		} /*8459*/
		$puti($1.encstr, ($1.barlen * 4) + 5, $get($1.encs, 37)); /*8463*/
		$1.bbs = $a($1.encstr.length); /*8465*/
		$1.bhs = $a($1.encstr.length); /*8466*/
		for (var _1p = 0, _1o = $1.encstr.length - 1; _1p <= _1o; _1p += 1) { /*8486*/
			$1.i = _1p; /*8468*/
			$1.enc = $geti($1.encstr, $1.i, 1); /*8469*/
			if ($eq($1.enc, "0")) { /*8473*/
				$put($1.bbs, $1.i, (3 * $1.height) / 8); /*8471*/
				$put($1.bhs, $1.i, (2 * $1.height) / 8); /*8472*/
			} /*8472*/
			if ($eq($1.enc, "1")) { /*8477*/
				$put($1.bbs, $1.i, (0 * $1.height) / 8); /*8475*/
				$put($1.bhs, $1.i, (5 * $1.height) / 8); /*8476*/
			} /*8476*/
			if ($eq($1.enc, "2")) { /*8481*/
				$put($1.bbs, $1.i, (3 * $1.height) / 8); /*8479*/
				$put($1.bhs, $1.i, (5 * $1.height) / 8); /*8480*/
			} /*8480*/
			if ($eq($1.enc, "3")) { /*8485*/
				$put($1.bbs, $1.i, (0 * $1.height) / 8); /*8483*/
				$put($1.bhs, $1.i, (8 * $1.height) / 8); /*8484*/
			} /*8484*/
		} /*8484*/
		$k[$j++] = Infinity; /*8497*/
		$k[$j++] = "ren"; /*8493*/
		$k[$j++] = $0.renlinear; /*8493*/
		$k[$j++] = "bbs"; /*8493*/
		$k[$j++] = $1.bbs; /*8493*/
		$k[$j++] = "bhs"; /*8493*/
		$k[$j++] = $1.bhs; /*8493*/
		$k[$j++] = "sbs"; /*8493*/
		$k[$j++] = Infinity; /*8493*/
		for (var _2O = 0, _2P = $1.bhs.length - 1; _2O < _2P; _2O++) { /*8493*/
			$k[$j++] = 1.44; /*8493*/
			$k[$j++] = 1.872; /*8493*/
		} /*8493*/
		$k[$j++] = 1.44; /*8493*/
		var _2Q = $a(); /*8493*/
		$k[$j++] = _2Q; /*8496*/
		if ($1.includetext) { /*8496*/
			$k[$j++] = "txt"; /*8495*/
			$k[$j++] = $1.txt; /*8495*/
		} /*8495*/
		$k[$j++] = "opt"; /*8497*/
		$k[$j++] = $1.options; /*8497*/
		var _2U = $d(); /*8497*/
		$k[$j++] = _2U; /*8500*/
		if (!$1.dontdraw) { /*8500*/
			$0.renlinear(); /*8500*/
		} /*8500*/
	};
	$0.auspost = function() {
		var $1 = {}; /*8527*/
		$1.options = $k[--$j]; /*8529*/
		$1.barcode = $k[--$j]; /*8530*/
		$1.dontdraw = false; /*8532*/
		$1.includetext = false; /*8533*/
		$1.textfont = "Courier"; /*8534*/
		$1.textsize = 10; /*8535*/
		$1.textyoffset = -8.5; /*8536*/
		$1.height = 0.175; /*8537*/
		$1.custinfoenc = "character"; /*8538*/
		$forall($1.options, function() { /*8549*/
			var _3 = $k[--$j]; /*8549*/
			$1[$k[--$j]] = _3; /*8549*/
		}) /*8549*/
		$1.textfont = "" + $1.textfont; /*8551*/
		$1.textsize = +$1.textsize; /*8552*/
		$1.textyoffset = +$1.textyoffset; /*8553*/
		$1.height = +$1.height; /*8554*/
		$1.encs = $a(["000", "001", "002", "010", "011", "012", "020", "021", "022", "100", "101", "102", "110", "111", "112", "120", "121", "122", "200", "201", "202", "210", "211", "212", "220", "221", "222", "300", "301", "302", "310", "311", "312", "320", "321", "322", "023", "030", "031", "032", "033", "103", "113", "123", "130", "131", "132", "133", "203", "213", "223", "230", "231", "232", "233", "303", "313", "323", "330", "331", "332", "333", "003", "013", "00", "01", "02", "10", "11", "12", "20", "21", "22", "30", "13", "3"]); /*8568*/
		$1.barchars = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789abcdefghijklmnopqrstuvwxyz #"; /*8571*/
		$1.barlen = $1.barcode.length; /*8573*/
		if ($eq($geti($1.barcode, 0, 2), "11")) { /*8574*/
			$k[$j++] = 37; /*8574*/
		} /*8574*/
		if ($eq($geti($1.barcode, 0, 2), "45")) { /*8575*/
			$k[$j++] = 37; /*8575*/
		} /*8575*/
		if ($eq($geti($1.barcode, 0, 2), "59")) { /*8576*/
			$k[$j++] = 52; /*8576*/
		} /*8576*/
		if ($eq($geti($1.barcode, 0, 2), "62")) { /*8577*/
			$k[$j++] = 67; /*8577*/
		} /*8577*/
		$1.encstr = $s($k[--$j]); /*8578*/
		$1.txt = $a($1.barlen - 2); /*8579*/
		$puti($1.encstr, 0, $get($1.encs, 74)); /*8582*/
		for (var _Q = 0; _Q <= 1; _Q += 1) { /*8589*/
			$1.i = _Q; /*8586*/
			$puti($1.encstr, ($1.i * 2) + 2, $get($1.encs, (~~$z($geti($1.barcode, $1.i, 1))) + 64)); /*8588*/
		} /*8588*/
		for (var _Y = 2; _Y <= 9; _Y += 1) { /*8597*/
			$1.i = _Y; /*8593*/
			$puti($1.encstr, ($1.i * 2) + 2, $get($1.encs, (~~$z($geti($1.barcode, $1.i, 1))) + 64)); /*8595*/
			$put($1.txt, $1.i - 2, $a([$geti($1.barcode, $1.i, 1), ((($1.i - 2) * 2) + 6) * 3.312, $1.textyoffset, $1.textfont, $1.textsize])); /*8596*/
		} /*8596*/
		if ($eq($1.custinfoenc, "numeric")) { /*8619*/
			for (var _t = 0, _s = $1.barlen - 11; _t <= _s; _t += 1) { /*8606*/
				$1.i = _t; /*8602*/
				$puti($1.encstr, ($1.i * 2) + 22, $get($1.encs, (~~$z($geti($1.barcode, $1.i + 10, 1))) + 64)); /*8604*/
				$put($1.txt, $1.i + 8, $a([$geti($1.barcode, $1.i + 10, 1), (($1.i * 2) + 22) * 3.312, $1.textyoffset, $1.textfont, $1.textsize])); /*8605*/
			} /*8605*/
			$1.ciflen = ($1.barlen - 10) * 2; /*8607*/
		} else { /*8619*/
			for (var _1E = 0, _1D = $1.barlen - 11; _1E <= _1D; _1E += 1) { /*8618*/
				$1.i = _1E; /*8610*/
				$search($1.barchars, $geti($1.barcode, $1.i + 10, 1)); /*8611*/
				$j--; /*8612*/
				$1.indx = $k[--$j].length; /*8613*/
				$j -= 2; /*8614*/
				$1.enc = $get($1.encs, $1.indx); /*8615*/
				$puti($1.encstr, ($1.i * 3) + 22, $1.enc); /*8616*/
				$put($1.txt, $1.i + 8, $a([$geti($1.barcode, $1.i + 10, 1), (($1.i * 3) + 22) * 3.312, $1.textyoffset, $1.textfont, $1.textsize])); /*8617*/
			} /*8617*/
			$1.ciflen = ($1.barlen - 10) * 3; /*8619*/
		} /*8619*/
		for (var _1e = 22 + $1.ciflen, _1d = $1.encstr.length - 14; _1e <= _1d; _1e += 1) { /*8625*/
			$puti($1.encstr, _1e, $get($1.encs, 75)); /*8624*/
		} /*8624*/
		$1.rstable = $a(64 * 64); /*8628*/
		$k[$j++] = $1.rstable; /*8629*/
		$k[$j++] = 0; /*8629*/
		$k[$j++] = Infinity; /*8629*/
		for (var _1k = 0, _1l = 64; _1k < _1l; _1k++) { /*8629*/
			$k[$j++] = 0; /*8629*/
		} /*8629*/
		var _1m = $a(); /*8629*/
		var _1n = $k[--$j]; /*8629*/
		$puti($k[--$j], _1n, _1m); /*8629*/
		$k[$j++] = $1.rstable; /*8630*/
		$k[$j++] = 64; /*8630*/
		$k[$j++] = Infinity; /*8630*/
		for (var _1q = 0; _1q <= 63; _1q += 1) { /*8630*/
			$k[$j++] = _1q; /*8630*/
		} /*8630*/
		var _1r = $a(); /*8630*/
		var _1s = $k[--$j]; /*8630*/
		$puti($k[--$j], _1s, _1r); /*8630*/
		$1.prev = 1; /*8631*/
		for (var _1u = 0, _1v = 64; _1u < _1v; _1u++) { /*8646*/
			$1.next = $1.prev << 1; /*8633*/
			if (($1.next & 64) != 0) { /*8636*/
				$1.next = $1.next ^ 67; /*8635*/
			} /*8635*/
			for (var _1z = 0; _1z <= 63; _1z += 1) { /*8644*/
				$1.j = _1z; /*8638*/
				$1.nextcell = function() {
					$k[$j++] = $1.rstable; /*8639*/
					$k[$j++] = (64 * $1.next) + $1.j; /*8639*/
				}; /*8639*/
				$1.nextcell(); /*8640*/
				var _27 = $k[--$j]; /*8640*/
				$put($k[--$j], _27, $get($1.rstable, (64 * $1.prev) + $1.j) << 1); /*8640*/
				$1.nextcell(); /*8641*/
				var _29 = $k[--$j]; /*8641*/
				if (($get($k[--$j], _29) & 64) != 0) { /*8643*/
					$1.nextcell(); /*8642*/
					$1.nextcell(); /*8642*/
					var _2C = $k[--$j]; /*8642*/
					var _2E = $get($k[--$j], _2C); /*8642*/
					var _2F = $k[--$j]; /*8642*/
					$put($k[--$j], _2F, _2E ^ 67); /*8642*/
				} /*8642*/
			} /*8642*/
			$1.prev = $1.next; /*8645*/
		} /*8645*/
		$1.rscodes = $a((~~(($1.encstr.length - 16) / 3)) + 4); /*8649*/
		$k[$j++] = $1.rscodes; /*8650*/
		$k[$j++] = 0; /*8650*/
		$k[$j++] = Infinity; /*8650*/
		for (var _2L = 0, _2M = 4; _2L < _2M; _2L++) { /*8650*/
			$k[$j++] = 0; /*8650*/
		} /*8650*/
		var _2N = $a(); /*8650*/
		var _2O = $k[--$j]; /*8650*/
		$puti($k[--$j], _2O, _2N); /*8650*/
		for (var _2S = 2, _2R = $1.encstr.length - 16; _2S <= _2R; _2S += 3) { /*8658*/
			$1.i = _2S; /*8652*/
			$put($1.rscodes, ($1.rscodes.length - (~~(($1.i - 2) / 3))) - 1, (((~~$z($geti($1.encstr, $1.i, 1))) * 16) + ((~~$z($geti($1.encstr, $1.i + 1, 1))) * 4)) + (~~$z($geti($1.encstr, $1.i + 2, 1)))); /*8657*/
		} /*8657*/
		for (var _2g = $1.rscodes.length - 5; _2g >= 0; _2g -= 1) { /*8667*/
			$1.i = _2g; /*8660*/
			for (var _2h = 0; _2h <= 4; _2h += 1) { /*8666*/
				$1.j = _2h; /*8662*/
				$put($1.rscodes, $1.i + $1.j, $xo($get($1.rscodes, $1.i + $1.j), $get($1.rstable, (64 * $get($a([48, 17, 29, 30, 1]), $1.j)) + $get($1.rscodes, $1.i + 4)))); /*8665*/
			} /*8665*/
		} /*8665*/
		$1.checkcode = $strcpy($s(12), "000000000000"); /*8668*/
		for (var _2z = 0; _2z <= 3; _2z += 1) { /*8673*/
			$1.i = _2z; /*8670*/
			$1.enc = $cvrs($s(3), $get($1.rscodes, 3 - $1.i), 4); /*8671*/
			$puti($1.checkcode, ($1.i * 3) + (3 - $1.enc.length), $1.enc); /*8672*/
		} /*8672*/
		$puti($1.encstr, $1.encstr.length - 14, $1.checkcode); /*8676*/
		$puti($1.encstr, $1.encstr.length - 2, $get($1.encs, 74)); /*8677*/
		$1.bbs = $a($1.encstr.length); /*8679*/
		$1.bhs = $a($1.encstr.length); /*8680*/
		for (var _3M = 0, _3L = $1.encstr.length - 1; _3M <= _3L; _3M += 1) { /*8700*/
			$1.i = _3M; /*8682*/
			$1.enc = $geti($1.encstr, $1.i, 1); /*8683*/
			if ($eq($1.enc, "0")) { /*8687*/
				$put($1.bbs, $1.i, (0 * $1.height) / 8); /*8685*/
				$put($1.bhs, $1.i, (8 * $1.height) / 8); /*8686*/
			} /*8686*/
			if ($eq($1.enc, "1")) { /*8691*/
				$put($1.bbs, $1.i, (3 * $1.height) / 8); /*8689*/
				$put($1.bhs, $1.i, (5 * $1.height) / 8); /*8690*/
			} /*8690*/
			if ($eq($1.enc, "2")) { /*8695*/
				$put($1.bbs, $1.i, (0 * $1.height) / 8); /*8693*/
				$put($1.bhs, $1.i, (5 * $1.height) / 8); /*8694*/
			} /*8694*/
			if ($eq($1.enc, "3")) { /*8699*/
				$put($1.bbs, $1.i, (3 * $1.height) / 8); /*8697*/
				$put($1.bhs, $1.i, (2 * $1.height) / 8); /*8698*/
			} /*8698*/
		} /*8698*/
		$k[$j++] = Infinity; /*8711*/
		$k[$j++] = "ren"; /*8707*/
		$k[$j++] = $0.renlinear; /*8707*/
		$k[$j++] = "bbs"; /*8707*/
		$k[$j++] = $1.bbs; /*8707*/
		$k[$j++] = "bhs"; /*8707*/
		$k[$j++] = $1.bhs; /*8707*/
		$k[$j++] = "sbs"; /*8707*/
		$k[$j++] = Infinity; /*8707*/
		for (var _3v = 0, _3w = $1.bhs.length - 1; _3v < _3w; _3v++) { /*8707*/
			$k[$j++] = 1.44; /*8707*/
			$k[$j++] = 1.872; /*8707*/
		} /*8707*/
		$k[$j++] = 1.44; /*8707*/
		var _3x = $a(); /*8707*/
		$k[$j++] = _3x; /*8710*/
		if ($1.includetext) { /*8710*/
			$k[$j++] = "txt"; /*8709*/
			$k[$j++] = $1.txt; /*8709*/
		} /*8709*/
		$k[$j++] = "opt"; /*8711*/
		$k[$j++] = $1.options; /*8711*/
		var _41 = $d(); /*8711*/
		$k[$j++] = _41; /*8714*/
		if (!$1.dontdraw) { /*8714*/
			$0.renlinear(); /*8714*/
		} /*8714*/
	};
	$0.kix = function() {
		var $1 = {}; /*8741*/
		$1.options = $k[--$j]; /*8743*/
		$1.barcode = $k[--$j]; /*8744*/
		$1.dontdraw = false; /*8746*/
		$1.includetext = false; /*8747*/
		$1.textfont = "Courier"; /*8748*/
		$1.textsize = 10; /*8749*/
		$1.textyoffset = -8.5; /*8750*/
		$1.height = 0.175; /*8751*/
		$forall($1.options, function() { /*8762*/
			var _3 = $k[--$j]; /*8762*/
			$1[$k[--$j]] = _3; /*8762*/
		}) /*8762*/
		$1.textfont = "" + $1.textfont; /*8764*/
		$1.textsize = +$1.textsize; /*8765*/
		$1.textyoffset = +$1.textyoffset; /*8766*/
		$1.height = +$1.height; /*8767*/
		$1.encs = $a(["0033", "0123", "0132", "1023", "1032", "1122", "0213", "0303", "0312", "1203", "1212", "1302", "0231", "0321", "0330", "1221", "1230", "1320", "2013", "2103", "2112", "3003", "3012", "3102", "2031", "2121", "2130", "3021", "3030", "3120", "2211", "2301", "2310", "3201", "3210", "3300"]); /*8777*/
		$1.barchars = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ"; /*8780*/
		$1.charvals = {}; /*8781*/
		for (var _A = 0; _A <= 35; _A += 1) { /*8782*/
			$put($1.charvals, $geti($1.barchars, _A, 1), _A); /*8782*/
		} /*8782*/
		for (var _G = 0, _F = $1.barcode.length - 1; _G <= _F; _G += 1) { /*8789*/
			var _K = $get($1.charvals, $geti($1.barcode, _G, 1)) !== undefined; /*8786*/
			if (!_K) { /*8788*/
				$k[$j++] = "bwipp.kixBadCharacter"; /*8787*/
				$k[$j++] = "KIX must contain only capital letters and digits"; /*8787*/
				$0.raiseerror(); /*8787*/
			} /*8787*/
		} /*8787*/
		$1.barlen = $1.barcode.length; /*8791*/
		$1.encstr = $s($1.barlen * 4); /*8792*/
		$1.txt = $a($1.barlen); /*8793*/
		for (var _S = 0, _R = $1.barlen - 1; _S <= _R; _S += 1) { /*8800*/
			$1.i = _S; /*8796*/
			$1.indx = $get($1.charvals, $geti($1.barcode, $1.i, 1)); /*8797*/
			$puti($1.encstr, $1.i * 4, $get($1.encs, $1.indx)); /*8798*/
			$put($1.txt, $1.i, $a([$geti($1.barcode, $1.i, 1), ($1.i * 4) * 3.312, $1.textyoffset, $1.textfont, $1.textsize])); /*8799*/
		} /*8799*/
		$1.bbs = $a($1.encstr.length); /*8802*/
		$1.bhs = $a($1.encstr.length); /*8803*/
		for (var _t = 0, _s = $1.encstr.length - 1; _t <= _s; _t += 1) { /*8823*/
			$1.i = _t; /*8805*/
			$1.enc = $geti($1.encstr, $1.i, 1); /*8806*/
			if ($eq($1.enc, "0")) { /*8810*/
				$put($1.bbs, $1.i, (3 * $1.height) / 8); /*8808*/
				$put($1.bhs, $1.i, (2 * $1.height) / 8); /*8809*/
			} /*8809*/
			if ($eq($1.enc, "1")) { /*8814*/
				$put($1.bbs, $1.i, (0 * $1.height) / 8); /*8812*/
				$put($1.bhs, $1.i, (5 * $1.height) / 8); /*8813*/
			} /*8813*/
			if ($eq($1.enc, "2")) { /*8818*/
				$put($1.bbs, $1.i, (3 * $1.height) / 8); /*8816*/
				$put($1.bhs, $1.i, (5 * $1.height) / 8); /*8817*/
			} /*8817*/
			if ($eq($1.enc, "3")) { /*8822*/
				$put($1.bbs, $1.i, (0 * $1.height) / 8); /*8820*/
				$put($1.bhs, $1.i, (8 * $1.height) / 8); /*8821*/
			} /*8821*/
		} /*8821*/
		$k[$j++] = Infinity; /*8834*/
		$k[$j++] = "ren"; /*8830*/
		$k[$j++] = $0.renlinear; /*8830*/
		$k[$j++] = "bbs"; /*8830*/
		$k[$j++] = $1.bbs; /*8830*/
		$k[$j++] = "bhs"; /*8830*/
		$k[$j++] = $1.bhs; /*8830*/
		$k[$j++] = "sbs"; /*8830*/
		$k[$j++] = Infinity; /*8830*/
		for (var _1S = 0, _1T = $1.bhs.length - 1; _1S < _1T; _1S++) { /*8830*/
			$k[$j++] = 1.44; /*8830*/
			$k[$j++] = 1.872; /*8830*/
		} /*8830*/
		$k[$j++] = 1.44; /*8830*/
		var _1U = $a(); /*8830*/
		$k[$j++] = _1U; /*8833*/
		if ($1.includetext) { /*8833*/
			$k[$j++] = "txt"; /*8832*/
			$k[$j++] = $1.txt; /*8832*/
		} /*8832*/
		$k[$j++] = "opt"; /*8834*/
		$k[$j++] = $1.options; /*8834*/
		var _1Y = $d(); /*8834*/
		$k[$j++] = _1Y; /*8837*/
		if (!$1.dontdraw) { /*8837*/
			$0.renlinear(); /*8837*/
		} /*8837*/
	};
	$0.japanpost = function() {
		var $1 = {}; /*8864*/
		$1.options = $k[--$j]; /*8866*/
		$1.barcode = $k[--$j]; /*8867*/
		$1.dontdraw = false; /*8869*/
		$1.includetext = false; /*8870*/
		$1.includecheckintext = false; /*8871*/
		$1.textfont = "Courier"; /*8872*/
		$1.textsize = 10; /*8873*/
		$1.textyoffset = -8.5; /*8874*/
		$1.height = 0.175; /*8875*/
		$forall($1.options, function() { /*8886*/
			var _3 = $k[--$j]; /*8886*/
			$1[$k[--$j]] = _3; /*8886*/
		}) /*8886*/
		$1.textfont = "" + $1.textfont; /*8888*/
		$1.textsize = +$1.textsize; /*8889*/
		$1.textyoffset = +$1.textyoffset; /*8890*/
		$1.height = +$1.height; /*8891*/
		$1.encs = $a(["300", "330", "312", "132", "321", "303", "123", "231", "213", "033", "030", "120", "102", "210", "012", "201", "021", "003", "333", "31", "13"]); /*8899*/
		$1.barchars = "0123456789-ABCDEFGHIJKLMNOPQRSTUVWXYZ"; /*8902*/
		$1.barlen = $1.barcode.length; /*8903*/
		$1.encstr = $s(((20 + 1) * 3) + 4); /*8905*/
		$1.digits = $a(20); /*8906*/
		$1.txt = $a($1.barlen + 1); /*8907*/
		$puti($1.encstr, 0, $get($1.encs, 19)); /*8910*/
		$1.checksum = 0; /*8912*/
		$1.j = 0; /*8913*/
		$1.i = 0; /*8913*/
		for (var _K = 0, _J = $1.barlen - 1; _K <= _J; _K += 1) { /*8947*/
			$1.i = _K; /*8915*/
			$search($1.barchars, $geti($1.barcode, $1.i, 1)); /*8916*/
			$j--; /*8917*/
			$1.indx = $k[--$j].length; /*8918*/
			$j -= 2; /*8919*/
			if (($1.indx >= 11) && ($1.indx < 37)) { /*8930*/
				if ($1.j > 18) { /*8921*/
					break; /*8921*/
				} /*8921*/
				$1.digit = (~~(($1.indx - 1) / 10)) + 10; /*8925*/
				$puti($1.encstr, ($1.j * 3) + 2, $get($1.encs, $1.digit)); /*8926*/
				$1.checksum = $1.checksum + $1.digit; /*8927*/
				$put($1.digits, $1.j, $1.digit); /*8928*/
				$1.j = $1.j + 1; /*8929*/
			} /*8929*/
			if ($1.j > 19) { /*8931*/
				break; /*8931*/
			} /*8931*/
			$1.digit = 0; /*8932*/
			if ($1.indx == 37) { /*8935*/
				$1.digit = 14; /*8934*/
			} /*8934*/
			if (($1.indx >= 11) && ($1.indx < 37)) { /*8938*/
				$1.digit = ($1.indx - 1) % 10; /*8937*/
			} /*8937*/
			if ($1.indx < 11) { /*8941*/
				$1.digit = $1.indx; /*8940*/
			} /*8940*/
			$puti($1.encstr, ($1.j * 3) + 2, $get($1.encs, $1.digit)); /*8942*/
			$1.checksum = $1.checksum + $1.digit; /*8943*/
			$put($1.digits, $1.j, $1.digit); /*8944*/
			$put($1.txt, $1.i, $a([$geti($1.barcode, $1.i, 1), (($1.j * 3) + 2) * 3.312, $1.textyoffset, $1.textfont, $1.textsize])); /*8945*/
			$1.j = $1.j + 1; /*8946*/
		} /*8946*/
		for (var _19 = $1.j, _18 = 20 - 1; _19 <= _18; _19 += 1) { /*8955*/
			$1.k = _19; /*8951*/
			$puti($1.encstr, ($1.k * 3) + 2, $get($1.encs, 14)); /*8952*/
			$1.checksum = $1.checksum + 14; /*8953*/
			$put($1.digits, $1.k, 14); /*8954*/
		} /*8954*/
		$1.checksum = 19 - ($1.checksum % 19); /*8958*/
		$puti($1.encstr, 2 + (20 * 3), $get($1.encs, $1.checksum)); /*8959*/
		$puti($1.encstr, 2 + (21 * 3), $get($1.encs, 20)); /*8962*/
		$1.checkdigit = " "; /*8963*/
		if ($1.includecheckintext) { /*8966*/
			$1.checkdigit = $geti($1.barchars, $1.checksum, 1); /*8965*/
		} /*8965*/
		$put($1.txt, $1.i + 1, $a([$1.checkdigit, ((20 * 3) + 2) * 3.312, $1.textyoffset, $1.textfont, $1.textsize])); /*8967*/
		$puti($1.encstr, ((20 + 1) * 3) + 2, $get($1.encs, 20)); /*8970*/
		$1.bbs = $a((21 * 3) + 4); /*8972*/
		$1.bhs = $a($1.bbs.length); /*8973*/
		for (var _1i = 0, _1h = $1.bbs.length - 1; _1i <= _1h; _1i += 1) { /*8997*/
			$1.i = _1i; /*8975*/
			$1.enc = $geti($1.encstr, $1.i, 1); /*8976*/
			$1.bunit = 0; /*8977*/
			$1.hunit = 0; /*8978*/
			if ($eq($1.enc, "0")) { /*8982*/
				$1.bunit = 3; /*8980*/
				$1.hunit = 2; /*8981*/
			} /*8981*/
			if ($eq($1.enc, "1")) { /*8986*/
				$1.bunit = 0; /*8984*/
				$1.hunit = 5; /*8985*/
			} /*8985*/
			if ($eq($1.enc, "2")) { /*8990*/
				$1.bunit = 3; /*8988*/
				$1.hunit = 5; /*8989*/
			} /*8989*/
			if ($eq($1.enc, "3")) { /*8994*/
				$1.bunit = 0; /*8992*/
				$1.hunit = 8; /*8993*/
			} /*8993*/
			$put($1.bbs, $1.i, ($1.bunit * $1.height) / 8); /*8995*/
			$put($1.bhs, $1.i, ($1.hunit * $1.height) / 8); /*8996*/
		} /*8996*/
		$k[$j++] = Infinity; /*9008*/
		$k[$j++] = "ren"; /*9004*/
		$k[$j++] = $0.renlinear; /*9004*/
		$k[$j++] = "bbs"; /*9004*/
		$k[$j++] = $1.bbs; /*9004*/
		$k[$j++] = "bhs"; /*9004*/
		$k[$j++] = $1.bhs; /*9004*/
		$k[$j++] = "sbs"; /*9004*/
		$k[$j++] = Infinity; /*9004*/
		for (var _21 = 0, _22 = $1.bhs.length - 1; _21 < _22; _21++) { /*9004*/
			$k[$j++] = 1.44; /*9004*/
			$k[$j++] = 1.872; /*9004*/
		} /*9004*/
		$k[$j++] = 1.44; /*9004*/
		var _23 = $a(); /*9004*/
		$k[$j++] = _23; /*9007*/
		if ($1.includetext) { /*9007*/
			$k[$j++] = "txt"; /*9006*/
			$k[$j++] = $1.txt; /*9006*/
		} /*9006*/
		$k[$j++] = "opt"; /*9008*/
		$k[$j++] = $1.options; /*9008*/
		var _27 = $d(); /*9008*/
		$k[$j++] = _27; /*9011*/
		if (!$1.dontdraw) { /*9011*/
			$0.renlinear(); /*9011*/
		} /*9011*/
	};
	$0.msi = function() {
		var $1 = {}; /*9038*/
		$1.options = $k[--$j]; /*9040*/
		$1.barcode = $k[--$j]; /*9041*/
		$1.dontdraw = false; /*9043*/
		$1.includecheck = false; /*9044*/
		$1.includetext = false; /*9045*/
		$1.includecheckintext = false; /*9046*/
		$1.checktype = "mod10"; /*9047*/
		$1.badmod11 = false; /*9048*/
		$1.textfont = "Courier"; /*9049*/
		$1.textsize = 10; /*9050*/
		$1.textyoffset = -8.5; /*9051*/
		$1.height = 1; /*9052*/
		$forall($1.options, function() { /*9063*/
			var _3 = $k[--$j]; /*9063*/
			$1[$k[--$j]] = _3; /*9063*/
		}) /*9063*/
		$1.textfont = "" + $1.textfont; /*9065*/
		$1.textsize = +$1.textsize; /*9066*/
		$1.textyoffset = +$1.textyoffset; /*9067*/
		$1.height = +$1.height; /*9068*/
		$1.encs = $a(["12121212", "12121221", "12122112", "12122121", "12211212", "12211221", "12212112", "12212121", "21121212", "21121221", "21", "121"]); /*9075*/
		$1.barchars = "0123456789"; /*9078*/
		$1.barlen = $1.barcode.length; /*9080*/
		$1.txtlen = $1.barlen; /*9081*/
		$1.mod10 = function() {
			$1.code = $k[--$j]; /*9084*/
			$k[$j++] = 0; /*9085*/
			$k[$j++] = 0; /*9085*/
			$forall($1.code, function() { /*9085*/
				var _E = $k[--$j]; /*9085*/
				var _F = $k[--$j]; /*9085*/
				var _G = $k[--$j]; /*9085*/
				$k[$j++] = (_E - 48) + (_F * 10); /*9085*/
				$k[$j++] = _G; /*9085*/
			}) /*9085*/
			$j--; /*9085*/
			var _H = $k[--$j]; /*9085*/
			$k[$j++] = _H * 2; /*9086*/
			$k[$j++] = 0; /*9086*/
			for (;;) { /*9086*/
				var _I = $k[--$j]; /*9086*/
				var _J = $k[--$j]; /*9086*/
				var _K = ~~(_J / 10); /*9086*/
				$k[$j++] = _I + (_J % 10); /*9086*/
				$k[$j++] = _K; /*9086*/
				if (_K == 0) { /*9086*/
					$j--; /*9086*/
					break; /*9086*/
				} /*9086*/
				var _L = $k[--$j]; /*9086*/
				var _M = $k[--$j]; /*9086*/
				$k[$j++] = _L; /*9086*/
				$k[$j++] = _M; /*9086*/
			} /*9086*/
			$k[$j++] = 0; /*9087*/
			$k[$j++] = 0; /*9087*/
			$forall($1.code, function() { /*9087*/
				var _O = $k[--$j]; /*9087*/
				var _P = $k[--$j]; /*9087*/
				var _Q = $k[--$j]; /*9087*/
				$k[$j++] = _P + (_O - 48); /*9087*/
				$k[$j++] = _Q; /*9087*/
			}) /*9087*/
			var _R = $k[--$j]; /*9087*/
			var _S = $k[--$j]; /*9087*/
			var _V = $s($1.code.length + 1); /*9089*/
			$puti(_V, 0, $1.code); /*9089*/
			$put(_V, $1.code.length, ((10 - (($k[--$j] + _R) % 10)) % 10) + 48); /*9089*/
			$k[$j++] = _V; /*9089*/
		}; /*9090*/
		$1.mod11 = function() {
			$1.code = $k[--$j]; /*9093*/
			$k[$j++] = $1.code.length - 1; /*9094*/
			$forall($1.code, function() { /*9094*/
				var _b = $k[--$j]; /*9094*/
				var _c = $k[--$j]; /*9094*/
				$k[$j++] = _b - 48; /*9094*/
				$k[$j++] = (_c % 6) + 2; /*9094*/
				$k[$j++] = _c - 1; /*9094*/
			}) /*9094*/
			$j--; /*9094*/
			$k[$j++] = 0; /*9095*/
			for (var _e = 0, _f = $1.code.length; _e < _f; _e++) { /*9095*/
				var _g = $k[--$j]; /*9095*/
				var _h = $k[--$j]; /*9095*/
				var _i = $k[--$j]; /*9095*/
				$k[$j++] = _g + (_i * _h); /*9095*/
			} /*9095*/
			var _k = (11 - ($k[--$j] % 11)) % 11; /*9097*/
			$k[$j++] = _k; /*9101*/
			if ((_k == 10) && $1.badmod11) { /*9100*/
				$j--; /*9098*/
				var _n = $s($1.code.length + 2); /*9098*/
				$puti(_n, 0, $1.code); /*9098*/
				$puti(_n, $1.code.length, "10"); /*9098*/
				$k[$j++] = _n; /*9098*/
			} else { /*9100*/
				var _r = $s($1.code.length + 1); /*9100*/
				$puti(_r, 0, $1.code); /*9100*/
				$put(_r, $1.code.length, $k[--$j] + 48); /*9100*/
				$k[$j++] = _r; /*9100*/
			} /*9100*/
		}; /*9102*/
		$1.ncrmod11 = function() {
			$1.code = $k[--$j]; /*9105*/
			$k[$j++] = $1.code.length - 1; /*9106*/
			$forall($1.code, function() { /*9106*/
				var _y = $k[--$j]; /*9106*/
				var _z = $k[--$j]; /*9106*/
				$k[$j++] = _y - 48; /*9106*/
				$k[$j++] = (_z % 8) + 2; /*9106*/
				$k[$j++] = _z - 1; /*9106*/
			}) /*9106*/
			$j--; /*9106*/
			$k[$j++] = 0; /*9107*/
			for (var _11 = 0, _12 = $1.code.length; _11 < _12; _11++) { /*9107*/
				var _13 = $k[--$j]; /*9107*/
				var _14 = $k[--$j]; /*9107*/
				var _15 = $k[--$j]; /*9107*/
				$k[$j++] = _13 + (_15 * _14); /*9107*/
			} /*9107*/
			var _17 = (11 - ($k[--$j] % 11)) % 11; /*9109*/
			$k[$j++] = _17; /*9113*/
			if ((_17 == 10) && $1.badmod11) { /*9112*/
				$j--; /*9110*/
				var _1A = $s($1.code.length + 2); /*9110*/
				$puti(_1A, 0, $1.code); /*9110*/
				$puti(_1A, $1.code.length, "10"); /*9110*/
				$k[$j++] = _1A; /*9110*/
			} else { /*9112*/
				var _1E = $s($1.code.length + 1); /*9112*/
				$puti(_1E, 0, $1.code); /*9112*/
				$put(_1E, $1.code.length, $k[--$j] + 48); /*9112*/
				$k[$j++] = _1E; /*9112*/
			} /*9112*/
		}; /*9114*/
		if ($1.includecheck) { /*9127*/
			if ($eq($1.checktype, "mod10")) { /*9118*/
				$k[$j++] = $1.barcode; /*9118*/
				$1.mod10(); /*9118*/
			} /*9118*/
			if ($eq($1.checktype, "mod1010")) { /*9119*/
				$k[$j++] = $1.barcode; /*9119*/
				$1.mod10(); /*9119*/
				$1.mod10(); /*9119*/
			} /*9119*/
			if ($eq($1.checktype, "mod11")) { /*9120*/
				$k[$j++] = $1.barcode; /*9120*/
				$1.mod11(); /*9120*/
			} /*9120*/
			if ($eq($1.checktype, "ncrmod11")) { /*9121*/
				$k[$j++] = $1.barcode; /*9121*/
				$1.ncrmod11(); /*9121*/
			} /*9121*/
			if ($eq($1.checktype, "mod1110")) { /*9122*/
				$k[$j++] = $1.barcode; /*9122*/
				$1.mod11(); /*9122*/
				$1.mod10(); /*9122*/
			} /*9122*/
			if ($eq($1.checktype, "ncrmod1110")) { /*9123*/
				$k[$j++] = $1.barcode; /*9123*/
				$1.ncrmod11(); /*9123*/
				$1.mod10(); /*9123*/
			} /*9123*/
			$1.barcode = $k[--$j]; /*9124*/
			$1.barlen = $1.barcode.length; /*9125*/
			if ($1.includecheckintext) { /*9126*/
				$1.txtlen = $1.barlen; /*9126*/
			} /*9126*/
		} /*9126*/
		$1.sbs = $s(($1.barlen * 8) + 5); /*9129*/
		$1.txt = $a($1.barlen); /*9130*/
		$puti($1.sbs, 0, $get($1.encs, 10)); /*9133*/
		for (var _1i = 0, _1h = $1.barlen - 1; _1i <= _1h; _1i += 1) { /*9145*/
			$1.i = _1i; /*9136*/
			$search($1.barchars, $geti($1.barcode, $1.i, 1)); /*9138*/
			$j--; /*9139*/
			$1.indx = $k[--$j].length; /*9140*/
			$j -= 2; /*9141*/
			$1.enc = $get($1.encs, $1.indx); /*9142*/
			$puti($1.sbs, ($1.i * 8) + 2, $1.enc); /*9143*/
			$put($1.txt, $1.i, $a([$geti($1.barcode, $1.i, 1), ($1.i * 12) + 3, $1.textyoffset, $1.textfont, $1.textsize])); /*9144*/
		} /*9144*/
		$puti($1.sbs, ($1.barlen * 8) + 2, $get($1.encs, 11)); /*9148*/
		$k[$j++] = Infinity; /*9159*/
		$k[$j++] = "ren"; /*9153*/
		$k[$j++] = $0.renlinear; /*9153*/
		$k[$j++] = "sbs"; /*9153*/
		$k[$j++] = Infinity; /*9153*/
		var _28 = $1.sbs; /*9153*/
		for (var _29 = 0, _2A = _28.length; _29 < _2A; _29++) { /*9153*/
			$k[$j++] = $get(_28, _29) - 48; /*9153*/
		} /*9153*/
		var _2C = $a(); /*9153*/
		$k[$j++] = _2C; /*9154*/
		$k[$j++] = "bhs"; /*9154*/
		$k[$j++] = Infinity; /*9154*/
		for (var _2E = 0, _2F = ~~(($1.sbs.length + 1) / 2); _2E < _2F; _2E++) { /*9154*/
			$k[$j++] = $1.height; /*9154*/
		} /*9154*/
		var _2H = $a(); /*9154*/
		$k[$j++] = _2H; /*9155*/
		$k[$j++] = "bbs"; /*9155*/
		$k[$j++] = Infinity; /*9155*/
		for (var _2J = 0, _2K = ~~(($1.sbs.length + 1) / 2); _2J < _2K; _2J++) { /*9155*/
			$k[$j++] = 0; /*9155*/
		} /*9155*/
		var _2L = $a(); /*9155*/
		$k[$j++] = _2L; /*9158*/
		if ($1.includetext) { /*9158*/
			$k[$j++] = "txt"; /*9157*/
			$k[$j++] = $geti($1.txt, 0, $1.txtlen); /*9157*/
		} /*9157*/
		$k[$j++] = "opt"; /*9159*/
		$k[$j++] = $1.options; /*9159*/
		var _2R = $d(); /*9159*/
		$k[$j++] = _2R; /*9162*/
		if (!$1.dontdraw) { /*9162*/
			$0.renlinear(); /*9162*/
		} /*9162*/
	};
	$0.plessey = function() {
		var $1 = {}; /*9189*/
		$1.options = $k[--$j]; /*9191*/
		$1.barcode = $k[--$j]; /*9192*/
		$1.dontdraw = false; /*9194*/
		$1.includetext = false; /*9195*/
		$1.validatecheck = false; /*9196*/
		$1.includecheckintext = false; /*9197*/
		$1.unidirectional = false; /*9198*/
		$1.textfont = "Courier"; /*9199*/
		$1.textsize = 10; /*9200*/
		$1.textyoffset = -8.5; /*9201*/
		$1.height = 1; /*9202*/
		$forall($1.options, function() { /*9213*/
			var _3 = $k[--$j]; /*9213*/
			$1[$k[--$j]] = _3; /*9213*/
		}) /*9213*/
		$1.textfont = "" + $1.textfont; /*9215*/
		$1.textsize = +$1.textsize; /*9216*/
		$1.textyoffset = +$1.textyoffset; /*9217*/
		$1.height = +$1.height; /*9218*/
		$1.barchars = "0123456789ABCDEF"; /*9221*/
		$1.charvals = {}; /*9222*/
		for (var _9 = 0; _9 <= 15; _9 += 1) { /*9223*/
			$put($1.charvals, $geti($1.barchars, _9, 1), _9); /*9223*/
		} /*9223*/
		for (var _F = 0, _E = $1.barcode.length - 1; _F <= _E; _F += 1) { /*9230*/
			var _J = $get($1.charvals, $geti($1.barcode, _F, 1)) !== undefined; /*9227*/
			if (!_J) { /*9229*/
				$k[$j++] = "bwipp.plesseyBadCharacter"; /*9228*/
				$k[$j++] = "Plessey must contain only digits and letters A B C D E F"; /*9228*/
				$0.raiseerror(); /*9228*/
			} /*9228*/
		} /*9228*/
		$k[$j++] = "barlen"; /*9232*/
		$k[$j++] = $1.barcode.length; /*9232*/
		if ($1.validatecheck) { /*9232*/
			var _M = $k[--$j]; /*9232*/
			$k[$j++] = _M - 2; /*9232*/
		} /*9232*/
		var _N = $k[--$j]; /*9232*/
		$1[$k[--$j]] = _N; /*9232*/
		$1.checkbits = $a(($1.barlen * 4) + 8); /*9235*/
		$puti($1.checkbits, $1.barlen * 4, $a([0, 0, 0, 0, 0, 0, 0, 0])); /*9236*/
		for (var _W = 0, _V = $1.barlen - 1; _W <= _V; _W += 1) { /*9246*/
			$1.i = _W; /*9238*/
			$1.indx = $get($1.charvals, $geti($1.barcode, $1.i, 1)); /*9239*/
			$puti($1.checkbits, $1.i * 4, $a([$1.indx & 1, ($1.indx >>> 1) & 1, ($1.indx >>> 2) & 1, $1.indx >>> 3])); /*9245*/
		} /*9245*/
		$1.checksalt = $a([1, 1, 1, 1, 0, 1, 0, 0, 1]); /*9247*/
		for (var _m = 0, _l = ($1.barlen * 4) - 1; _m <= _l; _m += 1) { /*9256*/
			$1.i = _m; /*9249*/
			if ($get($1.checkbits, $1.i) == 1) { /*9255*/
				for (var _q = 0; _q <= 8; _q += 1) { /*9254*/
					$1.j = _q; /*9252*/
					$put($1.checkbits, $1.i + $1.j, $xo($get($1.checkbits, $1.i + $1.j), $get($1.checksalt, $1.j))); /*9253*/
				} /*9253*/
			} /*9253*/
		} /*9253*/
		$1.checkval = 0; /*9257*/
		for (var _11 = 0; _11 <= 7; _11 += 1) { /*9261*/
			$1.i = _11; /*9259*/
			$1.checkval = $1.checkval + ((~~Math.pow(2, $1.i)) * $get($1.checkbits, ($1.barlen * 4) + $1.i)); /*9260*/
		} /*9260*/
		$1.checksum1 = $1.checkval & 15; /*9262*/
		$1.checksum2 = $1.checkval >>> 4; /*9263*/
		if ($1.validatecheck) { /*9270*/
			if (($get($1.barcode, $1.barlen) != $get($1.barchars, $1.checksum1)) || ($get($1.barcode, $1.barlen + 1) != $get($1.barchars, $1.checksum2))) { /*9268*/
				$k[$j++] = "bwipp.plesseyBadCheckDigits"; /*9267*/
				$k[$j++] = "Incorrect Plessey check digits provided"; /*9267*/
				$0.raiseerror(); /*9267*/
			} /*9267*/
			$1.barcode = $geti($1.barcode, 0, $1.barlen); /*9269*/
		} /*9269*/
		$1.encs = $a(["14141414", "32141414", "14321414", "32321414", "14143214", "32143214", "14323214", "32323214", "14141432", "32141432", "14321432", "32321432", "14143232", "32143232", "14323232", "32323232", "32321432", "541412323", "323"]); /*9279*/
		var _1T = $1.unidirectional ? 27 : 33; /*9281*/
		$1.sbs = $s(($1.barlen * 8) + _1T); /*9281*/
		$1.txt = $a($1.barlen + 2); /*9282*/
		$puti($1.sbs, 0, $get($1.encs, 16)); /*9285*/
		for (var _1c = 0, _1b = $1.barlen - 1; _1c <= _1b; _1c += 1) { /*9292*/
			$1.i = _1c; /*9288*/
			$1.indx = $get($1.charvals, $geti($1.barcode, $1.i, 1)); /*9289*/
			$puti($1.sbs, ($1.i * 8) + 8, $get($1.encs, $1.indx)); /*9290*/
			$put($1.txt, $1.i, $a([$geti($1.barcode, $1.i, 1), ($1.i * 20) + 20, $1.textyoffset, $1.textfont, $1.textsize])); /*9291*/
		} /*9291*/
		$puti($1.sbs, ($1.barlen * 8) + 8, $get($1.encs, $1.checksum1)); /*9295*/
		$puti($1.sbs, ($1.barlen * 8) + 16, $get($1.encs, $1.checksum2)); /*9296*/
		if ($1.includecheckintext) { /*9302*/
			$put($1.txt, $1.barlen, $a([$geti($1.barchars, $1.checksum1, 1), ($1.barlen * 20) + 20, $1.textyoffset, $1.textfont, $1.textsize])); /*9298*/
			$put($1.txt, $1.barlen + 1, $a([$geti($1.barchars, $1.checksum2, 1), (($1.barlen + 1) * 20) + 20, $1.textyoffset, $1.textfont, $1.textsize])); /*9299*/
		} else { /*9302*/
			$put($1.txt, $1.barlen, $a([" ", ($1.barlen * 20) + 20, $1.textyoffset, $1.textfont, $1.textsize])); /*9301*/
			$put($1.txt, $1.barlen + 1, $a([" ", (($1.barlen + 1) * 20) + 20, $1.textyoffset, $1.textfont, $1.textsize])); /*9302*/
		} /*9302*/
		var _2k = $1.unidirectional ? 18 : 17; /*9306*/
		$puti($1.sbs, ($1.barlen * 8) + 24, $get($1.encs, _2k)); /*9306*/
		$k[$j++] = Infinity; /*9317*/
		$k[$j++] = "ren"; /*9311*/
		$k[$j++] = $0.renlinear; /*9311*/
		$k[$j++] = "sbs"; /*9311*/
		$k[$j++] = Infinity; /*9311*/
		var _2m = $1.sbs; /*9311*/
		for (var _2n = 0, _2o = _2m.length; _2n < _2o; _2n++) { /*9311*/
			$k[$j++] = $get(_2m, _2n) - 48; /*9311*/
		} /*9311*/
		var _2q = $a(); /*9311*/
		$k[$j++] = _2q; /*9312*/
		$k[$j++] = "bhs"; /*9312*/
		$k[$j++] = Infinity; /*9312*/
		for (var _2s = 0, _2t = ~~(($1.sbs.length + 1) / 2); _2s < _2t; _2s++) { /*9312*/
			$k[$j++] = $1.height; /*9312*/
		} /*9312*/
		var _2v = $a(); /*9312*/
		$k[$j++] = _2v; /*9313*/
		$k[$j++] = "bbs"; /*9313*/
		$k[$j++] = Infinity; /*9313*/
		for (var _2x = 0, _2y = ~~(($1.sbs.length + 1) / 2); _2x < _2y; _2x++) { /*9313*/
			$k[$j++] = 0; /*9313*/
		} /*9313*/
		var _2z = $a(); /*9313*/
		$k[$j++] = _2z; /*9316*/
		if ($1.includetext) { /*9316*/
			$k[$j++] = "txt"; /*9315*/
			$k[$j++] = $1.txt; /*9315*/
		} /*9315*/
		$k[$j++] = "opt"; /*9317*/
		$k[$j++] = $1.options; /*9317*/
		var _33 = $d(); /*9317*/
		$k[$j++] = _33; /*9320*/
		if (!$1.dontdraw) { /*9320*/
			$0.renlinear(); /*9320*/
		} /*9320*/
	};
	$0.telepen = function() {
		var $1 = {}; /*9347*/
		$1.options = $k[--$j]; /*9349*/
		$1.barcode = $k[--$j]; /*9350*/
		$1.numeric = false; /*9352*/
		$1.dontdraw = false; /*9353*/
		$1.includetext = false; /*9354*/
		$1.textfont = "Courier"; /*9355*/
		$1.textsize = 10; /*9356*/
		$1.textyoffset = -8.5; /*9357*/
		$1.height = 1; /*9358*/
		$1.parse = false; /*9359*/
		$forall($1.options, function() { /*9370*/
			var _3 = $k[--$j]; /*9370*/
			$1[$k[--$j]] = _3; /*9370*/
		}) /*9370*/
		$1.textfont = "" + $1.textfont; /*9372*/
		$1.textsize = +$1.textsize; /*9373*/
		$1.textyoffset = +$1.textyoffset; /*9374*/
		$1.height = +$1.height; /*9375*/
		$1.encs = $a(["31313131", "1131313111", "33313111", "1111313131", "3111313111", "11333131", "13133131", "111111313111", "31333111", "1131113131", "33113131", "1111333111", "3111113131", "1113133111", "1311133111", "111111113131", "3131113111", "11313331", "333331", "111131113111", "31113331", "1133113111", "1313113111", "1111113331", "31131331", "113111113111", "3311113111", "1111131331", "311111113111", "1113111331", "1311111331", "11111111113111", "31313311", "1131311131", "33311131", "1111313311", "3111311131", "11333311", "13133311", "111111311131", "31331131", "1131113311", "33113311", "1111331131", "3111113311", "1113131131", "1311131131", "111111113311", "3131111131", "1131131311", "33131311", "111131111131", "3111131311", "1133111131", "1313111131", "111111131311", "3113111311", "113111111131", "3311111131", "111113111311", "311111111131", "111311111311", "131111111311", "11111111111131", "3131311111", "11313133", "333133", "111131311111", "31113133", "1133311111", "1313311111", "1111113133", "313333", "113111311111", "3311311111", "11113333", "311111311111", "11131333", "13111333", "11111111311111", "31311133", "1131331111", "33331111", "1111311133", "3111331111", "11331133", "13131133", "111111331111", "3113131111", "1131111133", "33111133", "111113131111", "3111111133", "111311131111", "131111131111", "111111111133", "31311313", "113131111111", "3331111111", "1111311313", "311131111111", "11331313", "13131313", "11111131111111", "3133111111", "1131111313", "33111313", "111133111111", "3111111313", "111313111111", "131113111111", "111111111313", "313111111111", "1131131113", "33131113", "11113111111111", "3111131113", "113311111111", "131311111111", "111111131113", "3113111113", "11311111111111", "331111111111", "111113111113", "31111111111111", "111311111113", "131111111113", "1111111111111111"]); /*9432*/
		$1.barlen = $1.barcode.length; /*9434*/
		$1.sbs = $s(($1.barlen * 16) + 48); /*9435*/
		$1.txt = $a($1.barlen); /*9436*/
		$1.enc = $get($1.encs, 95); /*9439*/
		$puti($1.sbs, 0, $1.enc); /*9440*/
		$1.l = $1.enc.length; /*9441*/
		$1.checksum = 0; /*9443*/
		$1.i = 0; /*9444*/
		$1.j = 0; /*9444*/
		for (;;) { /*9476*/
			if ($1.i == $1.barlen) { /*9446*/
				break; /*9446*/
			} /*9446*/
			if ($1.numeric) { /*9469*/
				if ($get($1.barcode, $1.i) > 16) { /*9460*/
					$1.np = $geti($1.barcode, $1.i, 2); /*9449*/
					if ($eq($geti($1.np, 1, 1), "X")) { /*9453*/
						$1.indx = (~~$z($geti($1.np, 0, 1))) + 17; /*9451*/
					} else { /*9453*/
						$1.indx = (~~$z($1.np)) + 27; /*9453*/
					} /*9453*/
					$put($1.txt, $1.j, $a([$1.np, ($1.j * 16) + 16, $1.textyoffset, $1.textfont, $1.textsize])); /*9455*/
					$1.i = $1.i + 2; /*9456*/
				} else { /*9460*/
					$1.indx = $get($1.barcode, $1.i); /*9458*/
					$put($1.txt, $1.j, $a([" ", ($1.j * 16) + 16, $1.textyoffset, $1.textfont, $1.textsize])); /*9459*/
					$1.i = $1.i + 1; /*9460*/
				} /*9460*/
			} else { /*9469*/
				$1.indx = $get($1.barcode, $1.i); /*9463*/
				if (($1.indx >= 32) && ($1.indx <= 126)) { /*9467*/
					$put($1.txt, $1.j, $a([$geti($1.barcode, $1.i, 1), ($1.j * 16) + 16, $1.textyoffset, $1.textfont, $1.textsize])); /*9465*/
				} else { /*9467*/
					$put($1.txt, $1.j, $a([" ", ($1.j * 16) + 16, $1.textyoffset, $1.textfont, $1.textsize])); /*9467*/
				} /*9467*/
				$1.i = $1.i + 1; /*9469*/
			} /*9469*/
			$1.checksum = $1.checksum + $1.indx; /*9471*/
			$1.enc = $get($1.encs, $1.indx); /*9472*/
			$puti($1.sbs, $1.l, $1.enc); /*9473*/
			$1.l = $1.l + $1.enc.length; /*9474*/
			$1.j = $1.j + 1; /*9475*/
		} /*9475*/
		$1.checksum = (127 - ($1.checksum % 127)) % 127; /*9479*/
		$1.enc = $get($1.encs, $1.checksum); /*9480*/
		$puti($1.sbs, $1.l, $1.enc); /*9481*/
		$1.l = $1.l + $1.enc.length; /*9482*/
		$1.enc = $get($1.encs, 122); /*9485*/
		$puti($1.sbs, $1.l, $1.enc); /*9486*/
		$1.l = $1.l + $1.enc.length; /*9487*/
		$1.sbs = $geti($1.sbs, 0, $1.l); /*9490*/
		$1.txt = $geti($1.txt, 0, $1.j); /*9491*/
		$k[$j++] = Infinity; /*9502*/
		$k[$j++] = "ren"; /*9496*/
		$k[$j++] = $0.renlinear; /*9496*/
		$k[$j++] = "sbs"; /*9496*/
		$k[$j++] = Infinity; /*9496*/
		$forall($1.sbs, function() { /*9496*/
			var _1n = $k[--$j]; /*9496*/
			$k[$j++] = _1n - 48; /*9496*/
		}) /*9496*/
		var _1o = $a(); /*9496*/
		$k[$j++] = _1o; /*9497*/
		$k[$j++] = "bhs"; /*9497*/
		$k[$j++] = Infinity; /*9497*/
		for (var _1q = 0, _1r = ~~(($1.sbs.length + 1) / 2); _1q < _1r; _1q++) { /*9497*/
			$k[$j++] = $1.height; /*9497*/
		} /*9497*/
		var _1t = $a(); /*9497*/
		$k[$j++] = _1t; /*9498*/
		$k[$j++] = "bbs"; /*9498*/
		$k[$j++] = Infinity; /*9498*/
		for (var _1v = 0, _1w = ~~(($1.sbs.length + 1) / 2); _1v < _1w; _1v++) { /*9498*/
			$k[$j++] = 0; /*9498*/
		} /*9498*/
		var _1x = $a(); /*9498*/
		$k[$j++] = _1x; /*9501*/
		if ($1.includetext) { /*9501*/
			$k[$j++] = "txt"; /*9500*/
			$k[$j++] = $1.txt; /*9500*/
		} /*9500*/
		$k[$j++] = "opt"; /*9502*/
		$k[$j++] = $1.options; /*9502*/
		var _21 = $d(); /*9502*/
		$k[$j++] = _21; /*9505*/
		if (!$1.dontdraw) { /*9505*/
			$0.renlinear(); /*9505*/
		} /*9505*/
	};
	$0.telepennumeric = function() {
		var $1 = {}; /*9533*/
		$1.options = $k[--$j]; /*9535*/
		$1.barcode = $k[--$j]; /*9536*/
		$1.dontdraw = false; /*9538*/
		$1.includetext = false; /*9539*/
		$1.textfont = "Courier"; /*9540*/
		$1.textsize = 10; /*9541*/
		$1.textxoffset = 0; /*9542*/
		$1.textyoffset = -8.5; /*9543*/
		$1.height = 1; /*9544*/
		$forall($1.options, function() { /*9555*/
			var _3 = $k[--$j]; /*9555*/
			$1[$k[--$j]] = _3; /*9555*/
		}) /*9555*/
		$1.textfont = "" + $1.textfont; /*9557*/
		$1.textsize = +$1.textsize; /*9558*/
		$1.textxoffset = +$1.textxoffset; /*9559*/
		$1.textyoffset = +$1.textyoffset; /*9560*/
		$1.height = +$1.height; /*9561*/
		$1.options.dontdraw = true; /*9564*/
		$1.options.numeric = true; /*9565*/
		$k[$j++] = "args"; /*9567*/
		$k[$j++] = $1.barcode; /*9567*/
		$k[$j++] = $1.options; /*9567*/
		$0.telepen(); /*9567*/
		var _E = $k[--$j]; /*9567*/
		$1[$k[--$j]] = _E; /*9567*/
		$1.args.opt = $1.options; /*9569*/
		$k[$j++] = $1.args; /*9572*/
		if (!$1.dontdraw) { /*9572*/
			$0.renlinear(); /*9572*/
		} /*9572*/
	};
	$0.posicode = function() {
		var $1 = {}; /*9599*/
		$1.options = $k[--$j]; /*9601*/
		$1.barcode = $k[--$j]; /*9602*/
		$1.dontdraw = false; /*9604*/
		$1.includetext = false; /*9605*/
		$1.textfont = "Courier"; /*9606*/
		$1.textsize = 10; /*9607*/
		$1.textxoffset = 0; /*9608*/
		$1.textyoffset = -8.5; /*9609*/
		$1.height = 1; /*9610*/
		$1.encoding = "auto"; /*9611*/
		$1.version = "a"; /*9612*/
		$1.checkoffset = 0; /*9613*/
		$1.raw = false; /*9614*/
		$1.parse = false; /*9615*/
		$1.parsefnc = false; /*9616*/
		$forall($1.options, function() { /*9627*/
			var _3 = $k[--$j]; /*9627*/
			$1[$k[--$j]] = _3; /*9627*/
		}) /*9627*/
		$1.textfont = "" + $1.textfont; /*9629*/
		$1.textsize = +$1.textsize; /*9630*/
		$1.textxoffset = +$1.textxoffset; /*9631*/
		$1.textyoffset = +$1.textyoffset; /*9632*/
		$1.encoding = "" + $1.encoding; /*9633*/
		$1.version = "" + $1.version; /*9634*/
		$1.checkoffset = ~~$1.checkoffset; /*9635*/
		$1.height = +$1.height; /*9636*/
		$1.barlen = $1.barcode.length; /*9659*/
		$1.la0 = -1; /*9662*/
		$1.la1 = -2; /*9662*/
		$1.la2 = -3; /*9662*/
		$1.sf0 = -4; /*9663*/
		$1.sf1 = -5; /*9663*/
		$1.sf2 = -6; /*9663*/
		$1.fn1 = -7; /*9664*/
		$1.fn2 = -8; /*9664*/
		$1.fn3 = -9; /*9664*/
		$1.fn4 = -10; /*9664*/
		var _1m = {
			normal: $a([$a(["0", "^", "'"]), $a(["1", ";", 27]), $a(["2", "<", 28]), $a(["3", "=", 29]), $a(["4", ">", 30]), $a(["5", "?", 31]), $a(["6", "@", "!"]), $a(["7", "[", "\""]), $a(["8", 92, "#"]), $a(["9", "]", "&"]), $a(["A", "a", 1]), $a(["B", "b", 2]), $a(["C", "c", 3]), $a(["D", "d", 4]), $a(["E", "e", 5]), $a(["F", "f", 6]), $a(["G", "g", 7]), $a(["H", "h", 8]), $a(["I", "i", 9]), $a(["J", "j", 10]), $a(["K", "k", 11]), $a(["L", "l", 12]), $a(["M", "m", 13]), $a(["N", "n", 14]), $a(["O", "o", 15]), $a(["P", "p", 16]), $a(["Q", "q", 17]), $a(["R", "r", 18]), $a(["S", "s", 19]), $a(["T", "t", 20]), $a(["U", "u", 21]), $a(["V", "v", 22]), $a(["W", "w", 23]), $a(["X", "x", 24]), $a(["Y", "y", 25]), $a(["Z", "z", 26]), $a(["-", "_", 40]), $a([".", "`", 41]), $a([" ", 127, 0]), $a(["$", "{", "*"]), $a(["/", "|", ","]), $a(["+", "}", ":"]), $a(["%", "~", $1.fn1]), $a([$1.la1, $1.la0, $1.fn2]), $a([$1.sf1, $1.sf0, $1.fn3]), $a([$1.sf2, $1.sf2, $1.fn4])]),
			limited: $a([$a(["0", -98, -98]), $a(["1", -98, -98]), $a(["2", -98, -98]), $a(["3", -98, -98]), $a(["4", -98, -98]), $a(["5", -98, -98]), $a(["6", -98, -98]), $a(["7", -98, -98]), $a(["8", -98, -98]), $a(["9", -98, -98]), $a(["A", -98, -98]), $a(["B", -98, -98]), $a(["C", -98, -98]), $a(["D", -98, -98]), $a(["E", -98, -98]), $a(["F", -98, -98]), $a(["G", -98, -98]), $a(["H", -98, -98]), $a(["I", -98, -98]), $a(["J", -98, -98]), $a(["K", -98, -98]), $a(["L", -98, -98]), $a(["M", -98, -98]), $a(["N", -98, -98]), $a(["O", -98, -98]), $a(["P", -98, -98]), $a(["Q", -98, -98]), $a(["R", -98, -98]), $a(["S", -98, -98]), $a(["T", -98, -98]), $a(["U", -98, -98]), $a(["V", -98, -98]), $a(["W", -98, -98]), $a(["X", -98, -98]), $a(["Y", -98, -98]), $a(["Z", -98, -98]), $a(["-", -98, -98]), $a([".", -98, -98])])
		}; /*9702*/
		$k[$j++] = _1m; /*9705*/
		if ($eq($1.version, "a") || $eq($1.version, "b")) { /*9705*/
			$k[$j++] = "normal"; /*9705*/
		} else { /*9705*/
			$k[$j++] = "limited"; /*9705*/
		} /*9705*/
		var _1p = $k[--$j]; /*9705*/
		$1.charmaps = $get($k[--$j], _1p); /*9706*/
		var _1s = $1.charmaps; /*9710*/
		var _1t = $1.charmaps; /*9710*/
		var _1u = $1.charmaps; /*9710*/
		$1.charvals = $a([{}, {}, {}]); /*9711*/
		for (var _1y = 0, _1x = $1.charmaps.length - 1; _1y <= _1x; _1y += 1) { /*9720*/
			$1.i = _1y; /*9713*/
			$1.encs = $get($1.charmaps, $1.i); /*9714*/
			for (var _22 = 0; _22 <= 2; _22 += 1) { /*9719*/
				$1.j = _22; /*9716*/
				var _25 = $get($1.encs, $1.j); /*9717*/
				$k[$j++] = _25; /*9717*/
				if ($eq($type(_25), "stringtype")) { /*9717*/
					var _28 = $get($k[--$j], 0); /*9717*/
					$k[$j++] = _28; /*9717*/
				} /*9717*/
				$put($get($1.charvals, $1.j), $k[--$j], $1.i); /*9718*/
			} /*9718*/
		} /*9718*/
		$1.set0 = $get($1.charvals, 0); /*9721*/
		$1.set1 = $get($1.charvals, 1); /*9722*/
		$1.set2 = $get($1.charvals, 2); /*9723*/
		if ($1.raw) { /*9725*/
			$1.encoding = "raw"; /*9725*/
		} /*9725*/
		if ($eq($1.encoding, "raw")) { /*9739*/
			$1.cws = $a($1.barlen); /*9728*/
			$1.i = 0; /*9729*/
			$1.j = 0; /*9729*/
			for (;;) { /*9736*/
				if ($1.i == $1.barlen) { /*9731*/
					break; /*9731*/
				} /*9731*/
				$1.cw = ~~$z($geti($1.barcode, $1.i + 1, 3)); /*9732*/
				$put($1.cws, $1.j, $1.cw); /*9733*/
				$1.i = $1.i + 4; /*9734*/
				$1.j = $1.j + 1; /*9735*/
			} /*9735*/
			$1.cws = $geti($1.cws, 0, $1.j); /*9737*/
			$1.text = ""; /*9738*/
		} /*9738*/
		if ($eq($1.encoding, "auto")) { /*9867*/
			var _2f = {
				FNC1: $1.fn1,
				FNC2: $1.fn2,
				FNC3: $1.fn3
			}; /*9746*/
			$1.fncvals = _2f; /*9748*/
			$1.msg = $a($1.barlen); /*9751*/
			$1.text = $s($1.barlen); /*9752*/
			$1.i = 0; /*9753*/
			$1.j = 0; /*9753*/
			for (;;) { /*9769*/
				if ($1.i == $1.barlen) { /*9754*/
					break; /*9754*/
				} /*9754*/
				$1.char = $get($1.barcode, $1.i); /*9755*/
				$put($1.text, $1.j, $1.char); /*9756*/
				if (($1.parsefnc && ($1.char == 94)) && ($1.i < ($1.barlen - 4))) { /*9765*/
					if ($get($1.barcode, $1.i + 1) != 94) { /*9763*/
						$1.char = $get($1.fncvals, $geti($1.barcode, $1.i + 1, 4)); /*9759*/
						$puti($1.text, $1.j, " "); /*9760*/
						$1.i = $1.i + 4; /*9761*/
					} else { /*9763*/
						$1.i = $1.i + 1; /*9763*/
					} /*9763*/
				} /*9763*/
				$put($1.msg, $1.j, $1.char); /*9766*/
				$1.i = $1.i + 1; /*9767*/
				$1.j = $1.j + 1; /*9768*/
			} /*9768*/
			$1.msg = $geti($1.msg, 0, $1.j); /*9770*/
			$1.msglen = $1.msg.length; /*9771*/
			$1.text = $geti($1.text, 0, $1.j); /*9772*/
			$k[$j++] = "numSA"; /*9775*/
			$k[$j++] = Infinity; /*9775*/
			for (var _3L = 0, _3M = $1.msglen; _3L < _3M; _3L++) { /*9775*/
				$k[$j++] = 0; /*9775*/
			} /*9775*/
			$k[$j++] = 0; /*9775*/
			var _3N = $a(); /*9775*/
			$1[$k[--$j]] = _3N; /*9775*/
			$k[$j++] = "numEA"; /*9776*/
			$k[$j++] = Infinity; /*9776*/
			for (var _3Q = 0, _3R = $1.msglen; _3Q < _3R; _3Q++) { /*9776*/
				$k[$j++] = 0; /*9776*/
			} /*9776*/
			$k[$j++] = 0; /*9776*/
			var _3S = $a(); /*9776*/
			$1[$k[--$j]] = _3S; /*9776*/
			for (var _3V = $1.msglen - 1; _3V >= 0; _3V -= 1) { /*9786*/
				$1.i = _3V; /*9778*/
				if ($get($1.msg, $1.i) >= 0) { /*9785*/
					if ($get($1.msg, $1.i) >= 128) { /*9783*/
						$put($1.numEA, $1.i, $get($1.numEA, $1.i + 1) + 1); /*9781*/
					} else { /*9783*/
						$put($1.numSA, $1.i, $get($1.numSA, $1.i + 1) + 1); /*9783*/
					} /*9783*/
				} /*9783*/
			} /*9783*/
			$1.ea = false; /*9789*/
			$1.msgtmp = $a([]); /*9789*/
			for (var _3p = 0, _3o = $1.msglen - 1; _3p <= _3o; _3p += 1) { /*9804*/
				$1.i = _3p; /*9791*/
				$1.c = $get($1.msg, $1.i); /*9792*/
				if ((!$xo($1.ea, $1.c < 128)) && ($1.c >= 0)) { /*9802*/
					if ($1.ea) { /*9794*/
						$k[$j++] = $1.numSA; /*9794*/
					} else { /*9794*/
						$k[$j++] = $1.numEA; /*9794*/
					} /*9794*/
					var _41 = $get($k[--$j], $1.i); /*9794*/
					var _44 = ((_41 + $1.i) == $1.msglen) ? 3 : 5; /*9795*/
					if (_41 < _44) { /*9800*/
						$k[$j++] = "msgtmp"; /*9797*/
						$k[$j++] = Infinity; /*9797*/
						$aload($1.msgtmp); /*9797*/
						$k[$j++] = $1.fn4; /*9797*/
						var _47 = $a(); /*9797*/
						$1[$k[--$j]] = _47; /*9797*/
					} else { /*9800*/
						$k[$j++] = "msgtmp"; /*9799*/
						$k[$j++] = Infinity; /*9799*/
						$aload($1.msgtmp); /*9799*/
						$k[$j++] = $1.fn4; /*9799*/
						$k[$j++] = $1.fn4; /*9799*/
						var _4C = $a(); /*9799*/
						$1[$k[--$j]] = _4C; /*9799*/
						$1.ea = !$1.ea; /*9800*/
					} /*9800*/
				} /*9800*/
				$k[$j++] = "msgtmp"; /*9803*/
				$k[$j++] = Infinity; /*9803*/
				$aload($1.msgtmp); /*9803*/
				if ($1.c >= 0) { /*9803*/
					$k[$j++] = $1.c & 127; /*9803*/
				} else { /*9803*/
					$k[$j++] = $1.c; /*9803*/
				} /*9803*/
				var _4J = $a(); /*9803*/
				$1[$k[--$j]] = _4J; /*9803*/
			} /*9803*/
			$1.msg = $1.msgtmp; /*9805*/
			$1.msglen = $1.msg.length; /*9806*/
			$1.enc = function() {
				var _4N = $k[--$j]; /*9810*/
				$put($1.cws, $1.j, $get(_4N, $k[--$j])); /*9810*/
				$1.j = $1.j + 1; /*9811*/
			}; /*9812*/
			$1.cws = $a($1.msglen * 2); /*9814*/
			$1.i = 0; /*9815*/
			$1.j = 0; /*9815*/
			$1.cset = "set0"; /*9815*/
			for (;;) { /*9865*/
				if ($1.i == $1.msglen) { /*9817*/
					break; /*9817*/
				} /*9817*/
				for (;;) { /*9863*/
					$1.char1 = $get($1.msg, $1.i); /*9822*/
					$k[$j++] = "char2"; /*9823*/
					if (($1.i + 1) < $1.msglen) { /*9823*/
						$k[$j++] = $get($1.msg, $1.i + 1); /*9823*/
					} else { /*9823*/
						$k[$j++] = -99; /*9823*/
					} /*9823*/
					var _4f = $k[--$j]; /*9823*/
					$1[$k[--$j]] = _4f; /*9823*/
					var _4k = $get($1[$1.cset], $1.char1) !== undefined; /*9826*/
					if (_4k) { /*9830*/
						$k[$j++] = $1.char1; /*9827*/
						$k[$j++] = $1[$1.cset]; /*9827*/
						$1.enc(); /*9827*/
						$1.i = $1.i + 1; /*9828*/
						break; /*9829*/
					} /*9829*/
					var _4r = $get($1.set2, $1.char1) !== undefined; /*9833*/
					if (_4r) { /*9838*/
						$k[$j++] = $1.sf2; /*9834*/
						$k[$j++] = $1[$1.cset]; /*9834*/
						$1.enc(); /*9834*/
						$k[$j++] = $1.char1; /*9835*/
						$k[$j++] = $1.set2; /*9835*/
						$1.enc(); /*9835*/
						$1.i = $1.i + 1; /*9836*/
						break; /*9837*/
					} /*9837*/
					var _51 = $get($1[$1.cset], $1.char2) !== undefined; /*9841*/
					if (!_51) { /*9859*/
						if ($eq($1.cset, "set0")) { /*9847*/
							$k[$j++] = $1.la1; /*9843*/
							$k[$j++] = $1[$1.cset]; /*9843*/
							$1.enc(); /*9843*/
							$1.cset = "set1"; /*9844*/
						} else { /*9847*/
							$k[$j++] = $1.la0; /*9846*/
							$k[$j++] = $1[$1.cset]; /*9846*/
							$1.enc(); /*9846*/
							$1.cset = "set0"; /*9847*/
						} /*9847*/
						break; /*9849*/
					} else { /*9859*/
						if ($eq($1.cset, "set0")) { /*9856*/
							$k[$j++] = $1.sf1; /*9852*/
							$k[$j++] = $1[$1.cset]; /*9852*/
							$1.enc(); /*9852*/
							$k[$j++] = $1.char1; /*9853*/
							$k[$j++] = $1.set1; /*9853*/
							$1.enc(); /*9853*/
						} else { /*9856*/
							$k[$j++] = $1.sf0; /*9855*/
							$k[$j++] = $1[$1.cset]; /*9855*/
							$1.enc(); /*9855*/
							$k[$j++] = $1.char1; /*9856*/
							$k[$j++] = $1.set0; /*9856*/
							$1.enc(); /*9856*/
						} /*9856*/
						$1.i = $1.i + 1; /*9858*/
						break; /*9859*/
					} /*9859*/
					break; /*9862*/
				} /*9862*/
			} /*9862*/
			$1.cws = $geti($1.cws, 0, $1.j); /*9866*/
		} /*9866*/
		var _5S = {
			a: $a(["141112", "131212", "121312", "111412", "131113", "121213", "111313", "121114", "111214", "111115", "181111", "171211", "161311", "151411", "141511", "131611", "121711", "111811", "171112", "161212", "151312", "141412", "131512", "121612", "111712", "161113", "151213", "141313", "131413", "121513", "111613", "151114", "141214", "131314", "121414", "111514", "141115", "131215", "121315", "111415", "131116", "121216", "111316", "121117", "111217", "111118", "1<111112", "111111111;1"]),
			b: $a(["151213", "141313", "131413", "121513", "141214", "131314", "121414", "131215", "121315", "121216", "191212", "181312", "171412", "161512", "151612", "141712", "131812", "121912", "181213", "171313", "161413", "151513", "141613", "131713", "121813", "171214", "161314", "151414", "141514", "131614", "121714", "161215", "151315", "141415", "131515", "121615", "151216", "141316", "131416", "121516", "141217", "131317", "121417", "131218", "121318", "121219", "1<121312", "121212121<1"]),
			limiteda: $a(["111411", "111312", "111213", "111114", "121311", "121212", "121113", "141111", "131211", "131112", "171111", "161211", "151311", "141411", "131511", "121611", "111711", "161112", "151212", "141312", "131412", "121512", "111612", "151113", "141213", "131313", "121413", "111513", "141114", "131214", "121314", "111414", "131115", "121215", "111315", "121116", "111216", "111117", "151111", "1"]),
			limitedb: $a(["121512", "121413", "121314", "121215", "131412", "131313", "131214", "151212", "141312", "141213", "181212", "171312", "161412", "151512", "141612", "131712", "121812", "171213", "161313", "151413", "141513", "131613", "121713", "161214", "151314", "141414", "131514", "121614", "151215", "141315", "131415", "121515", "141216", "131316", "121416", "131217", "121317", "121218", "141212", "1"])
		}; /*9913*/
		$1.encs = $get(_5S, $1.version); /*9916*/
		$1.c2w = $a([$a([495, 330, 210, 126, 70, 35, 15, 5]), $a([165, 120, 84, 56, 35, 20, 10, 4]), $a([45, 36, 28, 21, 15, 10, 6, 3]), $a([9, 8, 7, 6, 5, 4, 3, 2]), $a([1, 1, 1, 1, 1, 1, 1, 1])]); /*9924*/
		$1.v = 0; /*9925*/
		$forall($1.cws, function() { /*9935*/
			$1.cw = $k[--$j]; /*9927*/
			for (var _5d = 0, _5e = 6; _5d < _5e; _5d++) { /*9934*/
				if ((($1.cw ^ $1.v) & 1) != 0) { /*9931*/
					$1.v = $1.v ^ 7682; /*9930*/
				} /*9930*/
				$1.v = $1.v >>> 1; /*9932*/
				$1.cw = $1.cw >>> 1; /*9933*/
			} /*9933*/
		}) /*9933*/
		$1.v = $1.v + $1.checkoffset; /*9936*/
		if ($eq($1.version, "limiteda") || $eq($1.version, "limitedb")) { /*9944*/
			$1.v = $1.v & 1023; /*9939*/
			if (($1.v > 824) && ($1.v < 853)) { /*9942*/
				$1.v = $1.v + 292; /*9941*/
			} /*9941*/
		} else { /*9944*/
			$1.v = ($1.v & 1023) + 45; /*9944*/
		} /*9944*/
		$1.d = $a([2, 2, 2, 2, 2, 2]); /*9947*/
		$1.r = 0; /*9948*/
		$1.c = 0; /*9948*/
		$1.w = 0; /*9948*/
		$1.sum = 0; /*9948*/
		for (;;) { /*9967*/
			if ($1.sum == $1.v) { /*9950*/
				break; /*9950*/
			} /*9950*/
			$1.t = $1.sum + $get($get($1.c2w, $1.r), $1.c); /*9951*/
			if ($1.t == $1.v) { /*9956*/
				$1.w = $1.w + 1; /*9953*/
				$put($1.d, $1.r, $1.w + 2); /*9954*/
				$1.sum = $1.t; /*9955*/
			} /*9955*/
			if ($1.t > $1.v) { /*9961*/
				$put($1.d, $1.r, $1.w + 2); /*9958*/
				$1.r = $1.r + 1; /*9959*/
				$1.w = 0; /*9960*/
			} /*9960*/
			if ($1.t < $1.v) { /*9966*/
				$1.c = $1.c + 1; /*9963*/
				$1.w = $1.w + 1; /*9964*/
				$1.sum = $1.t; /*9965*/
			} /*9965*/
		} /*9965*/
		$k[$j++] = 20; /*9968*/
		for (var _6K = 0; _6K <= 4; _6K += 1) { /*9968*/
			var _6N = $k[--$j]; /*9968*/
			$k[$j++] = _6N - $get($1.d, _6K); /*9968*/
		} /*9968*/
		$put($1.d, 5, $k[--$j]); /*9969*/
		if ($eq($1.version, "b") || $eq($1.version, "limitedb")) { /*9972*/
			$k[$j++] = "d"; /*9971*/
			$k[$j++] = Infinity; /*9971*/
			var _6S = $1.d; /*9971*/
			for (var _6T = 0, _6U = _6S.length; _6T < _6U; _6T++) { /*9971*/
				$k[$j++] = $get(_6S, _6T) + 1; /*9971*/
			} /*9971*/
			var _6W = $a(); /*9971*/
			$1[$k[--$j]] = _6W; /*9971*/
		} /*9971*/
		$1.cbs = $strcpy($s(12), "111111111111"); /*9973*/
		for (var _6a = 5; _6a >= 0; _6a -= 1) { /*9977*/
			$1.i = _6a; /*9975*/
			$put($1.cbs, ((5 - $1.i) * 2) + 1, $get($1.d, $1.i) + 47); /*9976*/
		} /*9976*/
		$1.sbs = $s(($1.cws.length * 6) + 31); /*9980*/
		var _6k = $get($1.encs, $1.encs.length - 2); /*9981*/
		$puti($1.sbs, 0, _6k); /*9982*/
		$1.j = _6k.length; /*9983*/
		for (var _6o = 0, _6n = $1.cws.length - 1; _6o <= _6n; _6o += 1) { /*9988*/
			$1.i = _6o; /*9985*/
			$puti($1.sbs, $1.j, $get($1.encs, $get($1.cws, $1.i))); /*9986*/
			$1.j = $1.j + 6; /*9987*/
		} /*9987*/
		$puti($1.sbs, $1.j, $1.cbs); /*9989*/
		$1.j = $1.j + 12; /*9990*/
		var _73 = $get($1.encs, $1.encs.length - 1); /*9991*/
		$puti($1.sbs, $1.j, _73); /*9992*/
		$1.j = _73.length + $1.j; /*9993*/
		$1.sbs = $geti($1.sbs, 0, $1.j); /*9994*/
		$k[$j++] = Infinity; /*10004*/
		$k[$j++] = "ren"; /*9999*/
		$k[$j++] = $0.renlinear; /*9999*/
		$k[$j++] = "sbs"; /*9999*/
		$k[$j++] = Infinity; /*9999*/
		$forall($1.sbs, function() { /*9999*/
			var _7B = $k[--$j]; /*9999*/
			$k[$j++] = _7B - 48; /*9999*/
		}) /*9999*/
		var _7C = $a(); /*9999*/
		$k[$j++] = _7C; /*10000*/
		$k[$j++] = "bhs"; /*10000*/
		$k[$j++] = Infinity; /*10000*/
		for (var _7E = 0, _7F = ~~(($1.sbs.length + 1) / 2); _7E < _7F; _7E++) { /*10000*/
			$k[$j++] = $1.height; /*10000*/
		} /*10000*/
		var _7H = $a(); /*10000*/
		$k[$j++] = _7H; /*10001*/
		$k[$j++] = "bbs"; /*10001*/
		$k[$j++] = Infinity; /*10001*/
		for (var _7J = 0, _7K = ~~(($1.sbs.length + 1) / 2); _7J < _7K; _7J++) { /*10001*/
			$k[$j++] = 0; /*10001*/
		} /*10001*/
		var _7L = $a(); /*10001*/
		$k[$j++] = _7L; /*10004*/
		$k[$j++] = "txt"; /*10004*/
		$k[$j++] = $a([$a([$1.text, $1.textxoffset, $1.textyoffset, $1.textfont, $1.textsize])]); /*10004*/
		$k[$j++] = "textxalign"; /*10004*/
		$k[$j++] = "center"; /*10004*/
		$k[$j++] = "opt"; /*10004*/
		$k[$j++] = $1.options; /*10004*/
		var _7U = $d(); /*10004*/
		$k[$j++] = _7U; /*10007*/
		if (!$1.dontdraw) { /*10007*/
			$0.renlinear(); /*10007*/
		} /*10007*/
	};
	$0.codablockf = function() {
		var $1 = {}; /*10034*/
		$1.options = $k[--$j]; /*10036*/
		$1.barcode = $k[--$j]; /*10037*/
		$1.dontdraw = false; /*10039*/
		$1.rows = -1; /*10040*/
		$1.columns = 8; /*10041*/
		$1.rowheight = 10; /*10042*/
		$1.sepheight = 1; /*10043*/
		$1.encoding = "auto"; /*10044*/
		$1.parse = false; /*10045*/
		$1.parsefnc = false; /*10046*/
		$forall($1.options, function() { /*10057*/
			var _3 = $k[--$j]; /*10057*/
			$1[$k[--$j]] = _3; /*10057*/
		}) /*10057*/
		$1.rows = ~~$1.rows; /*10059*/
		$1.columns = ~~$1.columns; /*10060*/
		$1.rowheight = ~~$1.rowheight; /*10061*/
		$1.sepheight = ~~$1.sepheight; /*10062*/
		if ((($1.columns >= 4) && ($1.columns <= 62)) && ((($1.rows >= 2) && ($1.rows <= 44)) || ($1.rows == -1))) { /*10065*/
			$1.c = $1.columns; /*10065*/
		} /*10065*/
		$1.barlen = $1.barcode.length; /*10088*/
		$1.swa = -1; /*10091*/
		$1.swb = -2; /*10091*/
		$1.swc = -3; /*10091*/
		$1.sft = -4; /*10091*/
		$1.fn1 = -5; /*10092*/
		$1.fn2 = -6; /*10092*/
		$1.fn3 = -7; /*10092*/
		$1.fn4 = -8; /*10092*/
		$1.sta = -9; /*10093*/
		$1.stp = -10; /*10093*/
		$1.charmaps = $a([$a([32, 32, "00"]), $a(["!", "!", "01"]), $a(["\"", "\"", "02"]), $a(["#", "#", "03"]), $a(["$", "$", "04"]), $a(["%", "%", "05"]), $a(["&", "&", "06"]), $a(["'", "'", "07"]), $a([40, 40, "08"]), $a([41, 41, "09"]), $a(["*", "*", "10"]), $a(["+", "+", "11"]), $a([",", ",", "12"]), $a(["-", "-", "13"]), $a([".", ".", "14"]), $a(["/", "/", "15"]), $a(["0", "0", "16"]), $a(["1", "1", "17"]), $a(["2", "2", "18"]), $a(["3", "3", "19"]), $a(["4", "4", "20"]), $a(["5", "5", "21"]), $a(["6", "6", "22"]), $a(["7", "7", "23"]), $a(["8", "8", "24"]), $a(["9", "9", "25"]), $a([":", ":", "26"]), $a([";", ";", "27"]), $a(["<", "<", "28"]), $a(["=", "=", "29"]), $a([">", ">", "30"]), $a(["?", "?", "31"]), $a(["@", "@", "32"]), $a(["A", "A", "33"]), $a(["B", "B", "34"]), $a(["C", "C", "35"]), $a(["D", "D", "36"]), $a(["E", "E", "37"]), $a(["F", "F", "38"]), $a(["G", "G", "39"]), $a(["H", "H", "40"]), $a(["I", "I", "41"]), $a(["J", "J", "42"]), $a(["K", "K", "43"]), $a(["L", "L", "44"]), $a(["M", "M", "45"]), $a(["N", "N", "46"]), $a(["O", "O", "47"]), $a(["P", "P", "48"]), $a(["Q", "Q", "49"]), $a(["R", "R", "50"]), $a(["S", "S", "51"]), $a(["T", "T", "52"]), $a(["U", "U", "53"]), $a(["V", "V", "54"]), $a(["W", "W", "55"]), $a(["X", "X", "56"]), $a(["Y", "Y", "57"]), $a(["Z", "Z", "58"]), $a(["[", "[", "59"]), $a([92, 92, "60"]), $a(["]", "]", "61"]), $a(["^", "^", "62"]), $a(["_", "_", "63"]), $a([0, "`", "64"]), $a([1, "a", "65"]), $a([2, "b", "66"]), $a([3, "c", "67"]), $a([4, "d", "68"]), $a([5, "e", "69"]), $a([6, "f", "70"]), $a([7, "g", "71"]), $a([8, "h", "72"]), $a([9, "i", "73"]), $a([10, "j", "74"]), $a([11, "k", "75"]), $a([12, "l", "76"]), $a([13, "m", "77"]), $a([14, "n", "78"]), $a([15, "o", "79"]), $a([16, "p", "80"]), $a([17, "q", "81"]), $a([18, "r", "82"]), $a([19, "s", "83"]), $a([20, "t", "84"]), $a([21, "u", "85"]), $a([22, "v", "86"]), $a([23, "w", "87"]), $a([24, "x", "88"]), $a([25, "y", "89"]), $a([26, "z", "90"]), $a([27, "{", "91"]), $a([28, "|", "92"]), $a([29, "}", "93"]), $a([30, "~", "94"]), $a([31, 127, "95"]), $a([$1.fn3, $1.fn3, "96"]), $a([$1.fn2, $1.fn2, "97"]), $a([$1.sft, $1.sft, "98"]), $a([$1.swc, $1.swc, "99"]), $a([$1.swb, $1.fn4, $1.swb]), $a([$1.fn4, $1.swa, $1.swa]), $a([$1.fn1, $1.fn1, $1.fn1]), $a([$1.sta, $1.sta, $1.sta]), $a([$1.stp, $1.stp, $1.stp])]); /*10133*/
		$1.charvals = $a([{}, {}, {}]); /*10136*/
		for (var _2O = 0, _2N = $1.charmaps.length - 1; _2O <= _2N; _2O += 1) { /*10145*/
			$1.i = _2O; /*10138*/
			$1.encs = $get($1.charmaps, $1.i); /*10139*/
			for (var _2S = 0; _2S <= 2; _2S += 1) { /*10144*/
				$1.j = _2S; /*10141*/
				var _2V = $get($1.encs, $1.j); /*10142*/
				$k[$j++] = _2V; /*10142*/
				if ($eq($type(_2V), "stringtype")) { /*10142*/
					var _2Y = $get($k[--$j], 0); /*10142*/
					$k[$j++] = _2Y; /*10142*/
				} /*10142*/
				$put($get($1.charvals, $1.j), $k[--$j], $1.i); /*10143*/
			} /*10143*/
		} /*10143*/
		$1.seta = $get($1.charvals, 0); /*10146*/
		$1.setb = $get($1.charvals, 1); /*10147*/
		$1.setc = $get($1.charvals, 2); /*10148*/
		var _2m = {
			FNC1: $1.fn1,
			FNC3: $1.fn3
		}; /*10153*/
		$1.fncvals = _2m; /*10155*/
		$1.msg = $a($1.barlen); /*10156*/
		$1.i = 0; /*10157*/
		$1.j = 0; /*10157*/
		for (;;) { /*10171*/
			if ($1.i == $1.barlen) { /*10158*/
				break; /*10158*/
			} /*10158*/
			$1.char = $get($1.barcode, $1.i); /*10159*/
			if (($1.parsefnc && ($1.char == 94)) && ($1.i < ($1.barlen - 4))) { /*10167*/
				if ($get($1.barcode, $1.i + 1) != 94) { /*10165*/
					$1.char = $get($1.fncvals, $geti($1.barcode, $1.i + 1, 4)); /*10162*/
					$1.i = $1.i + 4; /*10163*/
				} else { /*10165*/
					$1.i = $1.i + 1; /*10165*/
				} /*10165*/
			} /*10165*/
			$put($1.msg, $1.j, $1.char); /*10168*/
			$1.i = $1.i + 1; /*10169*/
			$1.j = $1.j + 1; /*10170*/
		} /*10170*/
		$1.msg = $geti($1.msg, 0, $1.j); /*10172*/
		$1.msglen = $1.msg.length; /*10173*/
		$1.msgtmp = $a([]); /*10176*/
		$forall($1.msg, function() { /*10180*/
			$1.char = $k[--$j]; /*10178*/
			$k[$j++] = "msgtmp"; /*10179*/
			$k[$j++] = Infinity; /*10179*/
			$aload($1.msgtmp); /*10179*/
			if ($1.char < 128) { /*10179*/
				$k[$j++] = $1.char; /*10179*/
			} else { /*10179*/
				$k[$j++] = $1.fn4; /*10179*/
				$k[$j++] = $1.char & 127; /*10179*/
			} /*10179*/
			var _3P = $a(); /*10179*/
			$1[$k[--$j]] = _3P; /*10179*/
		}) /*10179*/
		$1.msg = $1.msgtmp; /*10181*/
		$1.msglen = $1.msg.length; /*10182*/
		$1.numsscr = function() {
			$1.n = 0; /*10186*/
			$1.s = 0; /*10186*/
			$1.p = $k[--$j]; /*10187*/
			for (;;) { /*10198*/
				if ($1.p >= $1.msglen) { /*10188*/
					break; /*10188*/
				} /*10188*/
				var _3Y = $get($1.msg, $1.p); /*10189*/
				var _3a = $get($1.setc, _3Y) !== undefined; /*10190*/
				$k[$j++] = _3Y; /*10190*/
				if (!_3a) { /*10190*/
					$j--; /*10190*/
					break; /*10190*/
				} /*10190*/
				if ($k[--$j] == $1.fn1) { /*10194*/
					if (($1.s % 2) == 0) { /*10193*/
						$1.s = $1.s + 1; /*10193*/
					} else { /*10193*/
						break; /*10193*/
					} /*10193*/
				} /*10193*/
				$1.n = $1.n + 1; /*10195*/
				$1.s = $1.s + 1; /*10196*/
				$1.p = $1.p + 1; /*10197*/
			} /*10197*/
			$k[$j++] = $1.n; /*10199*/
			$k[$j++] = $1.s; /*10199*/
		}; /*10200*/
		$1.enca = function() {
			$put($1.cws, $1.j, $get($1.seta, $k[--$j])); /*10204*/
			$1.j = $1.j + 1; /*10205*/
		}; /*10206*/
		$1.encb = function() {
			$put($1.cws, $1.j, $get($1.setb, $k[--$j])); /*10208*/
			$1.j = $1.j + 1; /*10209*/
		}; /*10210*/
		$1.encc = function() {
			var _3w = $k[--$j]; /*10212*/
			$k[$j++] = _3w; /*10216*/
			if ($ne($type(_3w), "arraytype")) { /*10215*/
				var _40 = $get($1.setc, $k[--$j]); /*10213*/
				$k[$j++] = _40; /*10213*/
			} else { /*10215*/
				$aload($k[--$j]); /*10215*/
				var _42 = $k[--$j]; /*10215*/
				var _43 = $k[--$j]; /*10215*/
				$k[$j++] = (_42 - 48) + ((_43 - 48) * 10); /*10215*/
			} /*10215*/
			$put($1.cws, $1.j, $k[--$j]); /*10217*/
			$1.j = $1.j + 1; /*10218*/
		}; /*10219*/
		$1.anotb = function() {
			var _48 = $k[--$j]; /*10222*/
			var _4A = $get($1.seta, _48) !== undefined; /*10222*/
			var _4C = $get($1.setb, _48) !== undefined; /*10222*/
			$k[$j++] = _4A && (!_4C); /*10222*/
		}; /*10222*/
		$1.bnota = function() {
			var _4D = $k[--$j]; /*10223*/
			var _4F = $get($1.setb, _4D) !== undefined; /*10223*/
			var _4H = $get($1.seta, _4D) !== undefined; /*10223*/
			$k[$j++] = _4F && (!_4H); /*10223*/
		}; /*10223*/
		$k[$j++] = "nextanotb"; /*10226*/
		$k[$j++] = Infinity; /*10226*/
		for (var _4J = 0, _4K = $1.msg.length; _4J < _4K; _4J++) { /*10226*/
			$k[$j++] = 0; /*10226*/
		} /*10226*/
		$k[$j++] = 9999; /*10226*/
		var _4L = $a(); /*10226*/
		$1[$k[--$j]] = _4L; /*10226*/
		$k[$j++] = "nextbnota"; /*10227*/
		$k[$j++] = Infinity; /*10227*/
		for (var _4O = 0, _4P = $1.msg.length; _4O < _4P; _4O++) { /*10227*/
			$k[$j++] = 0; /*10227*/
		} /*10227*/
		$k[$j++] = 9999; /*10227*/
		var _4Q = $a(); /*10227*/
		$1[$k[--$j]] = _4Q; /*10227*/
		for (var _4T = $1.msg.length - 1; _4T >= 0; _4T -= 1) { /*10240*/
			$1.i = _4T; /*10229*/
			$k[$j++] = $get($1.msg, $1.i); /*10230*/
			$1.anotb(); /*10230*/
			if ($k[--$j]) { /*10233*/
				$put($1.nextanotb, $1.i, 0); /*10231*/
			} else { /*10233*/
				$put($1.nextanotb, $1.i, $get($1.nextanotb, $1.i + 1) + 1); /*10233*/
			} /*10233*/
			$k[$j++] = $get($1.msg, $1.i); /*10235*/
			$1.bnota(); /*10235*/
			if ($k[--$j]) { /*10238*/
				$put($1.nextbnota, $1.i, 0); /*10236*/
			} else { /*10238*/
				$put($1.nextbnota, $1.i, $get($1.nextbnota, $1.i + 1) + 1); /*10238*/
			} /*10238*/
		} /*10238*/
		$1.abeforeb = function() {
			var _4q = $k[--$j]; /*10243*/
			$k[$j++] = $lt($get($1.nextanotb, _4q), $get($1.nextbnota, _4q)); /*10243*/
		}; /*10243*/
		$1.bbeforea = function() {
			var _4v = $k[--$j]; /*10244*/
			$k[$j++] = $lt($get($1.nextbnota, _4v), $get($1.nextanotb, _4v)); /*10244*/
		}; /*10244*/
		$1.padrow = function() {
			for (var _51 = 0, _52 = $k[--$j]; _51 < _52; _51++) { /*10254*/
				for (;;) { /*10253*/
					if ($eq($1.cset, "seta")) { /*10250*/
						$k[$j++] = $1.swc; /*10250*/
						$1.enca(); /*10250*/
						$1.cset = "setc"; /*10250*/
						break; /*10250*/
					} /*10250*/
					if ($eq($1.cset, "setb")) { /*10251*/
						$k[$j++] = $1.swc; /*10251*/
						$1.encb(); /*10251*/
						$1.cset = "setc"; /*10251*/
						break; /*10251*/
					} /*10251*/
					if ($eq($1.cset, "setc")) { /*10252*/
						$k[$j++] = $1.swb; /*10252*/
						$1.encc(); /*10252*/
						$1.cset = "setb"; /*10252*/
						break; /*10252*/
					} /*10252*/
				} /*10252*/
			} /*10252*/
		}; /*10255*/
		$k[$j++] = "cws"; /*10258*/
		$k[$j++] = $1.c + 5; /*10258*/
		if ($1.rows != -1) { /*10258*/
			$k[$j++] = $1.rows; /*10258*/
		} else { /*10258*/
			$k[$j++] = 44; /*10258*/
		} /*10258*/
		var _5C = $k[--$j]; /*10258*/
		var _5E = $a($k[--$j] * _5C); /*10258*/
		$1[$k[--$j]] = _5E; /*10258*/
		$1.i = 0; /*10260*/
		$1.j = 0; /*10260*/
		$1.r = 1; /*10260*/
		$1.lastrow = false; /*10261*/
		for (;;) { /*10429*/
			if ($1.lastrow) { /*10263*/
				break; /*10263*/
			} /*10263*/
			$k[$j++] = $1.sta; /*10266*/
			$1.enca(); /*10266*/
			if ($1.i < $1.msglen) { /*10267*/
				$k[$j++] = $1.i; /*10267*/
				$1.numsscr(); /*10267*/
			} else { /*10267*/
				$k[$j++] = -1; /*10267*/
				$k[$j++] = -1; /*10267*/
			} /*10267*/
			$1.nums = $k[--$j]; /*10267*/
			$1.nchars = $k[--$j]; /*10267*/
			for (;;) { /*10287*/
				if ($1.msglen == 0) { /*10273*/
					$k[$j++] = $1.swb; /*10270*/
					$1.enca(); /*10270*/
					$1.cset = "setb"; /*10271*/
					break; /*10272*/
				} /*10272*/
				if ($1.nums >= 2) { /*10278*/
					$k[$j++] = $1.swc; /*10275*/
					$1.enca(); /*10275*/
					$1.cset = "setc"; /*10276*/
					break; /*10277*/
				} /*10277*/
				$k[$j++] = $1.i; /*10279*/
				$1.abeforeb(); /*10279*/
				if ($k[--$j]) { /*10283*/
					$k[$j++] = $1.sft; /*10280*/
					$1.enca(); /*10280*/
					$1.cset = "seta"; /*10281*/
					break; /*10282*/
				} /*10282*/
				$k[$j++] = $1.swb; /*10284*/
				$1.enca(); /*10284*/
				$1.cset = "setb"; /*10285*/
				break; /*10286*/
			} /*10286*/
			$1.j = $1.j + 1; /*10288*/
			$1.endofrow = false; /*10291*/
			for (;;) { /*10414*/
				$1.rem = ($1.c + 3) - ($1.j % ($1.c + 5)); /*10292*/
				if (($1.i == $1.msglen) || $1.endofrow) { /*10294*/
					break; /*10294*/
				} /*10294*/
				$k[$j++] = $1.i; /*10296*/
				$1.numsscr(); /*10296*/
				$1.nums = $k[--$j]; /*10296*/
				$1.nchars = $k[--$j]; /*10296*/
				for (;;) { /*10412*/
					if ((($eq($1.cset, "seta") || $eq($1.cset, "setb")) && ($1.nums >= 4)) && ($get($1.msg, $1.i) != $1.fn1)) { /*10334*/
						if ((($1.nums % 2) == 0) && ($1.rem >= 3)) { /*10316*/
							$k[$j++] = $1.swc; /*10304*/
							if ($eq($1.cset, "seta")) { /*10304*/
								$1.enca(); /*10304*/
							} else { /*10304*/
								$1.encb(); /*10304*/
							} /*10304*/
							$1.cset = "setc"; /*10305*/
							for (var _5q = 0, _5r = 2; _5q < _5r; _5q++) { /*10314*/
								if ($get($1.msg, $1.i) == $1.fn1) { /*10312*/
									$k[$j++] = $1.fn1; /*10308*/
									$1.encc(); /*10308*/
									$1.i = $1.i + 1; /*10309*/
								} else { /*10312*/
									$k[$j++] = $geti($1.msg, $1.i, 2); /*10311*/
									$1.encc(); /*10311*/
									$1.i = $1.i + 2; /*10312*/
								} /*10312*/
							} /*10312*/
							break; /*10315*/
						} /*10315*/
						if ((($1.nums % 2) != 0) && ($1.rem >= 4)) { /*10333*/
							$k[$j++] = $get($1.msg, $1.i); /*10319*/
							if ($eq($1.cset, "seta")) { /*10319*/
								$1.enca(); /*10319*/
							} else { /*10319*/
								$1.encb(); /*10319*/
							} /*10319*/
							$1.i = $1.i + 1; /*10320*/
							$k[$j++] = $1.swc; /*10321*/
							if ($eq($1.cset, "seta")) { /*10321*/
								$1.enca(); /*10321*/
							} else { /*10321*/
								$1.encb(); /*10321*/
							} /*10321*/
							$1.cset = "setc"; /*10322*/
							for (var _6B = 0, _6C = 2; _6B < _6C; _6B++) { /*10331*/
								if ($get($1.msg, $1.i) == $1.fn1) { /*10329*/
									$k[$j++] = $1.fn1; /*10325*/
									$1.encc(); /*10325*/
									$1.i = $1.i + 1; /*10326*/
								} else { /*10329*/
									$k[$j++] = $geti($1.msg, $1.i, 2); /*10328*/
									$1.encc(); /*10328*/
									$1.i = $1.i + 2; /*10329*/
								} /*10329*/
							} /*10329*/
							break; /*10332*/
						} /*10332*/
					} /*10332*/
					$k[$j++] = $eq($1.cset, "setb"); /*10335*/
					$k[$j++] = $get($1.msg, $1.i); /*10335*/
					$1.anotb(); /*10335*/
					var _6R = $k[--$j]; /*10335*/
					if (($k[--$j] && _6R) && ($1.rem >= 2)) { /*10350*/
						if ($1.i < ($1.msglen - 1)) { /*10344*/
							$k[$j++] = $1.i + 1; /*10338*/
							$1.bbeforea(); /*10338*/
							if ($k[--$j]) { /*10343*/
								$k[$j++] = $1.sft; /*10339*/
								$1.encb(); /*10339*/
								$k[$j++] = $get($1.msg, $1.i); /*10340*/
								$1.enca(); /*10340*/
								$1.i = $1.i + 1; /*10341*/
								break; /*10342*/
							} /*10342*/
						} /*10342*/
						$k[$j++] = $1.swa; /*10345*/
						$1.encb(); /*10345*/
						$1.cset = "seta"; /*10346*/
						$k[$j++] = $get($1.msg, $1.i); /*10347*/
						$1.enca(); /*10347*/
						$1.i = $1.i + 1; /*10348*/
						break; /*10349*/
					} /*10349*/
					$k[$j++] = $eq($1.cset, "seta"); /*10351*/
					$k[$j++] = $get($1.msg, $1.i); /*10351*/
					$1.bnota(); /*10351*/
					var _6m = $k[--$j]; /*10351*/
					if (($k[--$j] && _6m) && ($1.rem >= 2)) { /*10366*/
						if ($1.i < ($1.msglen - 1)) { /*10360*/
							$k[$j++] = $1.i + 1; /*10354*/
							$1.abeforeb(); /*10354*/
							if ($k[--$j]) { /*10359*/
								$k[$j++] = $1.sft; /*10355*/
								$1.enca(); /*10355*/
								$k[$j++] = $get($1.msg, $1.i); /*10356*/
								$1.encb(); /*10356*/
								$1.i = $1.i + 1; /*10357*/
								break; /*10358*/
							} /*10358*/
						} /*10358*/
						$k[$j++] = $1.swb; /*10361*/
						$1.enca(); /*10361*/
						$1.cset = "setb"; /*10362*/
						$k[$j++] = $get($1.msg, $1.i); /*10363*/
						$1.encb(); /*10363*/
						$1.i = $1.i + 1; /*10364*/
						break; /*10365*/
					} /*10365*/
					if (($eq($1.cset, "setc") && ($1.nums < 2)) && ($1.rem >= 2)) { /*10381*/
						$k[$j++] = $1.i; /*10369*/
						$1.abeforeb(); /*10369*/
						if ($k[--$j]) { /*10375*/
							$k[$j++] = $1.swa; /*10370*/
							$1.encc(); /*10370*/
							$1.cset = "seta"; /*10371*/
							$k[$j++] = $get($1.msg, $1.i); /*10372*/
							$1.enca(); /*10372*/
							$1.i = $1.i + 1; /*10373*/
							break; /*10374*/
						} /*10374*/
						$k[$j++] = $1.swb; /*10376*/
						$1.encc(); /*10376*/
						$1.cset = "setb"; /*10377*/
						$k[$j++] = $get($1.msg, $1.i); /*10378*/
						$1.encb(); /*10378*/
						$1.i = $1.i + 1; /*10379*/
						break; /*10380*/
					} /*10380*/
					var _7N = $get($1.seta, $get($1.msg, $1.i)) !== undefined; /*10384*/
					if (($eq($1.cset, "seta") && _7N) && ($1.rem >= 1)) { /*10389*/
						$k[$j++] = $get($1.msg, $1.i); /*10386*/
						$1.enca(); /*10386*/
						$1.i = $1.i + 1; /*10387*/
						break; /*10388*/
					} /*10388*/
					var _7Y = $get($1.setb, $get($1.msg, $1.i)) !== undefined; /*10390*/
					if (($eq($1.cset, "setb") && _7Y) && ($1.rem >= 1)) { /*10395*/
						$k[$j++] = $get($1.msg, $1.i); /*10392*/
						$1.encb(); /*10392*/
						$1.i = $1.i + 1; /*10393*/
						break; /*10394*/
					} /*10394*/
					if (($eq($1.cset, "setc") && ($1.nums >= 2)) && ($1.rem >= 1)) { /*10406*/
						if ($get($1.msg, $1.i) == $1.fn1) { /*10403*/
							$k[$j++] = $1.fn1; /*10399*/
							$1.encc(); /*10399*/
							$1.i = $1.i + 1; /*10400*/
						} else { /*10403*/
							$k[$j++] = $geti($1.msg, $1.i, 2); /*10402*/
							$1.encc(); /*10402*/
							$1.i = $1.i + 2; /*10403*/
						} /*10403*/
						break; /*10405*/
					} /*10405*/
					$1.endofrow = true; /*10409*/
					break; /*10410*/
				} /*10410*/
			} /*10410*/
			if ((((($1.r == $1.rows) || ($1.rows == -1)) && ($1.r > 1)) && ($1.i == $1.msglen)) && ($1.rem >= 2)) { /*10426*/
				$k[$j++] = $1.rem - 2; /*10418*/
				$1.padrow(); /*10418*/
				$1.j = $1.j + 3; /*10419*/
				$k[$j++] = $1.stp; /*10420*/
				$1.enca(); /*10420*/
				$1.lastrow = true; /*10421*/
			} else { /*10426*/
				$k[$j++] = $1.rem; /*10423*/
				$1.padrow(); /*10423*/
				$1.j = $1.j + 1; /*10424*/
				$k[$j++] = $1.stp; /*10425*/
				$1.enca(); /*10425*/
				$1.r = $1.r + 1; /*10426*/
			} /*10426*/
		} /*10426*/
		$1.cws = $geti($1.cws, 0, $1.j); /*10430*/
		$k[$j++] = "abmap"; /*10436*/
		$k[$j++] = Infinity; /*10436*/
		for (var _88 = 64; _88 <= 95; _88 += 1) { /*10434*/
			$k[$j++] = _88; /*10434*/
		} /*10434*/
		for (var _89 = 0; _89 <= 15; _89 += 1) { /*10435*/
			$k[$j++] = _89; /*10435*/
		} /*10435*/
		for (var _8A = 26; _8A <= 63; _8A += 1) { /*10436*/
			$k[$j++] = _8A; /*10436*/
		} /*10436*/
		var _8B = $a(); /*10436*/
		$1[$k[--$j]] = _8B; /*10437*/
		$k[$j++] = "cmap"; /*10438*/
		$k[$j++] = Infinity; /*10438*/
		for (var _8D = 0; _8D <= 85; _8D += 1) { /*10438*/
			$k[$j++] = _8D; /*10438*/
		} /*10438*/
		var _8E = $a(); /*10438*/
		$1[$k[--$j]] = _8E; /*10438*/
		$1.chkmsg = $a($1.msglen); /*10441*/
		$1.j = 0; /*10442*/
		for (var _8K = 0, _8J = $1.msglen - 1; _8K <= _8J; _8K += 1) { /*10448*/
			$1.i = _8K; /*10444*/
			$1.char = $get($1.msg, $1.i); /*10445*/
			if ($1.char >= 0) { /*10446*/
				$put($1.chkmsg, $1.j, $1.char); /*10446*/
				$1.j = $1.j + 1; /*10446*/
			} /*10446*/
			if (($1.char == $1.fn1) && ($1.i != 0)) { /*10447*/
				$put($1.chkmsg, $1.j, 29); /*10447*/
				$1.j = $1.j + 1; /*10447*/
			} /*10447*/
		} /*10447*/
		$1.t1 = 0; /*10449*/
		$1.t2 = 0; /*10449*/
		$1.k1 = 0; /*10449*/
		$1.k2 = 0; /*10449*/
		for (var _8b = 0, _8a = $1.j - 1; _8b <= _8a; _8b += 1) { /*10456*/
			$1.i = _8b; /*10451*/
			$1.t1 = ($get($1.chkmsg, $1.i) * $1.i) % 86; /*10452*/
			$1.t2 = ($1.t1 + $get($1.chkmsg, $1.i)) % 86; /*10453*/
			$1.k1 = ($1.k1 + $1.t2) % 86; /*10454*/
			$1.k2 = ($1.k2 + $1.t1) % 86; /*10455*/
		} /*10455*/
		$k[$j++] = $1.cws; /*10457*/
		$k[$j++] = $1.cws.length - 4; /*10457*/
		if ($ne($1.cset, "setc")) { /*10457*/
			$k[$j++] = $1.abmap; /*10457*/
		} else { /*10457*/
			$k[$j++] = $1.cmap; /*10457*/
		} /*10457*/
		var _8v = $get($k[--$j], $1.k1); /*10457*/
		var _8w = $k[--$j]; /*10457*/
		$put($k[--$j], _8w, _8v); /*10457*/
		$k[$j++] = $1.cws; /*10458*/
		$k[$j++] = $1.cws.length - 3; /*10458*/
		if ($ne($1.cset, "setc")) { /*10458*/
			$k[$j++] = $1.abmap; /*10458*/
		} else { /*10458*/
			$k[$j++] = $1.cmap; /*10458*/
		} /*10458*/
		var _95 = $get($k[--$j], $1.k2); /*10458*/
		var _96 = $k[--$j]; /*10458*/
		$put($k[--$j], _96, _95); /*10458*/
		var _98 = $1.cws; /*10461*/
		$k[$j++] = _98; /*10461*/
		$k[$j++] = 2; /*10461*/
		if ($get(_98, 2 - 1) != 99) { /*10461*/
			$k[$j++] = $1.abmap; /*10461*/
		} else { /*10461*/
			$k[$j++] = $1.cmap; /*10461*/
		} /*10461*/
		var _9E = $get($k[--$j], $1.r - 2); /*10461*/
		var _9F = $k[--$j]; /*10461*/
		$put($k[--$j], _9F, _9E); /*10461*/
		for (var _9J = 1, _9I = $1.r - 1; _9J <= _9I; _9J += 1) { /*10465*/
			$1.i = _9J; /*10463*/
			var _9K = $1.cws; /*10464*/
			var _9L = $1.i; /*10464*/
			var _9M = $1.c; /*10464*/
			$k[$j++] = _9K; /*10464*/
			$k[$j++] = (_9L * (_9M + 5)) + 2; /*10464*/
			if ($get(_9K, ((_9L * (_9M + 5)) + 2) - 1) != 99) { /*10464*/
				$k[$j++] = $1.abmap; /*10464*/
			} else { /*10464*/
				$k[$j++] = $1.cmap; /*10464*/
			} /*10464*/
			var _9S = $get($k[--$j], $1.i + 42); /*10464*/
			var _9T = $k[--$j]; /*10464*/
			$put($k[--$j], _9T, _9S); /*10464*/
		} /*10464*/
		for (var _9X = 0, _9W = $1.r - 1; _9X <= _9W; _9X += 1) { /*10476*/
			$1.rcws = $geti($1.cws, _9X * ($1.c + 5), $1.c + 4); /*10469*/
			$1.csum = $get($1.rcws, 0); /*10470*/
			for (var _9g = 1, _9f = $1.rcws.length - 2; _9g <= _9f; _9g += 1) { /*10474*/
				$1.i = _9g; /*10472*/
				$1.csum = $1.csum + ($get($1.rcws, $1.i) * $1.i); /*10473*/
			} /*10473*/
			$put($1.rcws, $1.rcws.length - 1, $1.csum % 103); /*10475*/
		} /*10475*/
		$1.encs = $a(["212222", "222122", "222221", "121223", "121322", "131222", "122213", "122312", "132212", "221213", "221312", "231212", "112232", "122132", "122231", "113222", "123122", "123221", "223211", "221132", "221231", "213212", "223112", "312131", "311222", "321122", "321221", "312212", "322112", "322211", "212123", "212321", "232121", "111323", "131123", "131321", "112313", "132113", "132311", "211313", "231113", "231311", "112133", "112331", "132131", "113123", "113321", "133121", "313121", "211331", "231131", "213113", "213311", "213131", "311123", "311321", "331121", "312113", "312311", "332111", "314111", "221411", "431111", "111224", "111422", "121124", "121421", "141122", "141221", "112214", "112412", "122114", "122411", "142112", "142211", "241211", "221114", "413111", "241112", "134111", "111242", "121142", "121241", "114212", "124112", "124211", "411212", "421112", "421211", "212141", "214121", "412121", "111143", "111341", "131141", "114113", "114311", "411113", "411311", "113141", "114131", "311141", "411131", "211412", "2331112"]); /*10495*/
		$1.rowbits = $a($1.r); /*10498*/
		for (var _9u = 0, _9t = $1.r - 1; _9u <= _9t; _9u += 1) { /*10510*/
			$1.i = _9u; /*10500*/
			$k[$j++] = "sbs"; /*10503*/
			$k[$j++] = Infinity; /*10503*/
			$forall($geti($1.cws, $1.i * ($1.c + 5), $1.c + 5), function() { /*10504*/
				$forall($get($1.encs, $k[--$j]), function() { /*10503*/
					var _A3 = $k[--$j]; /*10503*/
					$k[$j++] = _A3 - 48; /*10503*/
				}) /*10503*/
			}) /*10503*/
			var _A4 = $a(); /*10503*/
			$1[$k[--$j]] = _A4; /*10505*/
			$k[$j++] = Infinity; /*10506*/
			$k[$j++] = 0; /*10507*/
			$forall($1.sbs, function() { /*10507*/
				var _A7 = $k[--$j]; /*10507*/
				var _A8 = $k[--$j]; /*10507*/
				var _A9 = (_A8 == 1) ? 0 : 1; /*10507*/
				$k[$j++] = _A8; /*10507*/
				for (var _AA = 0, _AB = _A7; _AA < _AB; _AA++) { /*10507*/
					$k[$j++] = _A9 /*10507*/
				} /*10507*/
			}) /*10507*/
			$astore($a($counttomark() - 1)); /*10508*/
			var _AE = $k[--$j]; /*10508*/
			var _AF = $k[--$j]; /*10508*/
			var _AG = $k[--$j]; /*10508*/
			$put($1.rowbits, $1.i, _AE); /*10509*/
		} /*10509*/
		$1.symwid = ($1.c * 11) + 57; /*10513*/
		$k[$j++] = "pixs"; /*10526*/
		$k[$j++] = Infinity; /*10526*/
		for (var _AM = 0, _AN = $1.symwid * $1.sepheight; _AM < _AN; _AM++) { /*10515*/
			$k[$j++] = 1; /*10515*/
		} /*10515*/
		for (var _AQ = 0, _AP = $1.r - 2; _AQ <= _AP; _AQ += 1) { /*10524*/
			$1.i = _AQ; /*10517*/
			for (var _AS = 0, _AT = $1.rowheight; _AS < _AT; _AS++) { /*10518*/
				$aload($get($1.rowbits, $1.i)); /*10518*/
			} /*10518*/
			for (var _AY = 0, _AZ = $1.sepheight; _AY < _AZ; _AY++) { /*10523*/
				$k[$j++] = 1; /*10521*/
				$k[$j++] = 1; /*10521*/
				$k[$j++] = 0; /*10521*/
				$k[$j++] = 1; /*10521*/
				$k[$j++] = 0; /*10521*/
				$k[$j++] = 0; /*10521*/
				$k[$j++] = 0; /*10521*/
				$k[$j++] = 0; /*10521*/
				$k[$j++] = 1; /*10521*/
				$k[$j++] = 0; /*10521*/
				$k[$j++] = 0; /*10521*/
				for (var _Ab = 0, _Ac = $1.symwid - 24; _Ab < _Ac; _Ab++) { /*10521*/
					$k[$j++] = 1; /*10521*/
				} /*10521*/
				$k[$j++] = 1; /*10522*/
				$k[$j++] = 1; /*10522*/
				$k[$j++] = 0; /*10522*/
				$k[$j++] = 0; /*10522*/
				$k[$j++] = 0; /*10522*/
				$k[$j++] = 1; /*10522*/
				$k[$j++] = 1; /*10522*/
				$k[$j++] = 1; /*10522*/
				$k[$j++] = 0; /*10522*/
				$k[$j++] = 1; /*10522*/
				$k[$j++] = 0; /*10522*/
				$k[$j++] = 1; /*10522*/
				$k[$j++] = 1; /*10522*/
			} /*10522*/
		} /*10522*/
		for (var _Ae = 0, _Af = $1.rowheight; _Ae < _Af; _Ae++) { /*10525*/
			$aload($get($1.rowbits, $1.r - 1)); /*10525*/
		} /*10525*/
		for (var _Al = 0, _Am = $1.symwid * $1.sepheight; _Al < _Am; _Al++) { /*10526*/
			$k[$j++] = 1; /*10526*/
		} /*10526*/
		var _An = $a(); /*10526*/
		$1[$k[--$j]] = _An; /*10527*/
		var _Ax = {
			ren: $0.renmatrix,
			pixs: $1.pixs,
			pixx: $1.symwid,
			pixy: ~~($1.pixs.length / $1.symwid),
			height: (~~($1.pixs.length / $1.symwid)) / 72,
			width: $1.symwid / 72,
			opt: $1.options
		}; /*10537*/
		$k[$j++] = _Ax; /*10540*/
		if (!$1.dontdraw) { /*10540*/
			$0.renmatrix(); /*10540*/
		} /*10540*/
	};
	$0.code16k = function() {
		var $1 = {}; /*10567*/
		$1.options = $k[--$j]; /*10569*/
		$1.barcode = $k[--$j]; /*10570*/
		$1.dontdraw = false; /*10572*/
		$1.mode = -1; /*10573*/
		$1.pos = -1; /*10574*/
		$1.rows = 0; /*10575*/
		$1.rowheight = 8; /*10576*/
		$1.sepheight = 1; /*10577*/
		$1.encoding = "auto"; /*10578*/
		$1.raw = false; /*10579*/
		$1.parse = false; /*10580*/
		$1.parsefnc = false; /*10581*/
		$forall($1.options, function() { /*10592*/
			var _3 = $k[--$j]; /*10592*/
			$1[$k[--$j]] = _3; /*10592*/
		}) /*10592*/
		$1.mode = ~~$1.mode; /*10594*/
		$1.pos = ~~$1.pos; /*10595*/
		$1.rows = ~~$1.rows; /*10596*/
		$1.rowheight = ~~$1.rowheight; /*10597*/
		$1.sepheight = ~~$1.sepheight; /*10598*/
		if ($1.pos != -1) { /*10600*/
			$1.rows = 16; /*10600*/
		} /*10600*/
		$1.barlen = $1.barcode.length; /*10623*/
		$1.swa = -1; /*10626*/
		$1.swb = -2; /*10626*/
		$1.swc = -3; /*10626*/
		$1.sa1 = -4; /*10627*/
		$1.sb1 = -5; /*10627*/
		$1.sc1 = -6; /*10627*/
		$1.sa2 = -7; /*10628*/
		$1.sb2 = -8; /*10628*/
		$1.sc2 = -9; /*10628*/
		$1.pad = -10; /*10629*/
		$1.sb3 = -11; /*10629*/
		$1.sc3 = -12; /*10629*/
		$1.fn1 = -13; /*10630*/
		$1.fn2 = -14; /*10630*/
		$1.fn3 = -15; /*10630*/
		$1.fn4 = -16; /*10630*/
		$1.charmaps = $a([$a([32, 32, "00"]), $a(["!", "!", "01"]), $a(["\"", "\"", "02"]), $a(["#", "#", "03"]), $a(["$", "$", "04"]), $a(["%", "%", "05"]), $a(["&", "&", "06"]), $a(["'", "'", "07"]), $a([40, 40, "08"]), $a([41, 41, "09"]), $a(["*", "*", "10"]), $a(["+", "+", "11"]), $a([",", ",", "12"]), $a(["-", "-", "13"]), $a([".", ".", "14"]), $a(["/", "/", "15"]), $a(["0", "0", "16"]), $a(["1", "1", "17"]), $a(["2", "2", "18"]), $a(["3", "3", "19"]), $a(["4", "4", "20"]), $a(["5", "5", "21"]), $a(["6", "6", "22"]), $a(["7", "7", "23"]), $a(["8", "8", "24"]), $a(["9", "9", "25"]), $a([":", ":", "26"]), $a([";", ";", "27"]), $a(["<", "<", "28"]), $a(["=", "=", "29"]), $a([">", ">", "30"]), $a(["?", "?", "31"]), $a(["@", "@", "32"]), $a(["A", "A", "33"]), $a(["B", "B", "34"]), $a(["C", "C", "35"]), $a(["D", "D", "36"]), $a(["E", "E", "37"]), $a(["F", "F", "38"]), $a(["G", "G", "39"]), $a(["H", "H", "40"]), $a(["I", "I", "41"]), $a(["J", "J", "42"]), $a(["K", "K", "43"]), $a(["L", "L", "44"]), $a(["M", "M", "45"]), $a(["N", "N", "46"]), $a(["O", "O", "47"]), $a(["P", "P", "48"]), $a(["Q", "Q", "49"]), $a(["R", "R", "50"]), $a(["S", "S", "51"]), $a(["T", "T", "52"]), $a(["U", "U", "53"]), $a(["V", "V", "54"]), $a(["W", "W", "55"]), $a(["X", "X", "56"]), $a(["Y", "Y", "57"]), $a(["Z", "Z", "58"]), $a(["[", "[", "59"]), $a([92, 92, "60"]), $a(["]", "]", "61"]), $a(["^", "^", "62"]), $a(["_", "_", "63"]), $a([0, "`", "64"]), $a([1, "a", "65"]), $a([2, "b", "66"]), $a([3, "c", "67"]), $a([4, "d", "68"]), $a([5, "e", "69"]), $a([6, "f", "70"]), $a([7, "g", "71"]), $a([8, "h", "72"]), $a([9, "i", "73"]), $a([10, "j", "74"]), $a([11, "k", "75"]), $a([12, "l", "76"]), $a([13, "m", "77"]), $a([14, "n", "78"]), $a([15, "o", "79"]), $a([16, "p", "80"]), $a([17, "q", "81"]), $a([18, "r", "82"]), $a([19, "s", "83"]), $a([20, "t", "84"]), $a([21, "u", "85"]), $a([22, "v", "86"]), $a([23, "w", "87"]), $a([24, "x", "88"]), $a([25, "y", "89"]), $a([26, "z", "90"]), $a([27, "{", "91"]), $a([28, "|", "92"]), $a([29, "}", "93"]), $a([30, "~", "94"]), $a([31, 127, "95"]), $a([$1.fn3, $1.fn3, "96"]), $a([$1.fn2, $1.fn2, "97"]), $a([$1.sb1, $1.sa1, "98"]), $a([$1.swc, $1.swc, "99"]), $a([$1.swb, $1.fn4, $1.swb]), $a([$1.fn4, $1.swa, $1.swa]), $a([$1.fn1, $1.fn1, $1.fn1]), $a([$1.pad, $1.pad, $1.pad]), $a([$1.sb2, $1.sa2, $1.sb1]), $a([$1.sc2, $1.sc2, $1.sb2]), $a([$1.sc3, $1.sc3, $1.sb3])]); /*10671*/
		$1.charvals = $a([{}, {}, {}]); /*10674*/
		for (var _2S = 0, _2R = $1.charmaps.length - 1; _2S <= _2R; _2S += 1) { /*10683*/
			$1.i = _2S; /*10676*/
			$1.encs = $get($1.charmaps, $1.i); /*10677*/
			for (var _2W = 0; _2W <= 2; _2W += 1) { /*10682*/
				$1.j = _2W; /*10679*/
				var _2Z = $get($1.encs, $1.j); /*10680*/
				$k[$j++] = _2Z; /*10680*/
				if ($eq($type(_2Z), "stringtype")) { /*10680*/
					var _2c = $get($k[--$j], 0); /*10680*/
					$k[$j++] = _2c; /*10680*/
				} /*10680*/
				$put($get($1.charvals, $1.j), $k[--$j], $1.i); /*10681*/
			} /*10681*/
		} /*10681*/
		$1.seta = $get($1.charvals, 0); /*10684*/
		$1.setb = $get($1.charvals, 1); /*10685*/
		$1.setc = $get($1.charvals, 2); /*10686*/
		if ($1.raw) { /*10688*/
			$1.encoding = "raw"; /*10688*/
		} /*10688*/
		if ($eq($1.encoding, "raw")) { /*10702*/
			$1.cws = $a($1.barlen); /*10691*/
			$1.i = 0; /*10692*/
			$1.j = 0; /*10692*/
			for (;;) { /*10699*/
				if ($1.i == $1.barlen) { /*10694*/
					break; /*10694*/
				} /*10694*/
				$1.cw = ~~$z($geti($1.barcode, $1.i + 1, 3)); /*10695*/
				$put($1.cws, $1.j, $1.cw); /*10696*/
				$1.i = $1.i + 4; /*10697*/
				$1.j = $1.j + 1; /*10698*/
			} /*10698*/
			$1.cws = $geti($1.cws, 0, $1.j); /*10700*/
			$1.text = ""; /*10701*/
		} /*10701*/
		if ($eq($1.encoding, "auto")) { /*11165*/
			var _39 = {
				FNC1: $1.fn1,
				FNC2: $1.fn2,
				FNC3: $1.fn3
			}; /*10709*/
			$1.fncvals = _39; /*10711*/
			$1.msg = $a($1.barlen); /*10712*/
			$1.i = 0; /*10713*/
			$1.j = 0; /*10713*/
			for (;;) { /*10727*/
				if ($1.i == $1.barlen) { /*10714*/
					break; /*10714*/
				} /*10714*/
				$1.char = $get($1.barcode, $1.i); /*10715*/
				if (($1.parsefnc && ($1.char == 94)) && ($1.i < ($1.barlen - 4))) { /*10723*/
					if ($get($1.barcode, $1.i + 1) != 94) { /*10721*/
						$1.char = $get($1.fncvals, $geti($1.barcode, $1.i + 1, 4)); /*10718*/
						$1.i = $1.i + 4; /*10719*/
					} else { /*10721*/
						$1.i = $1.i + 1; /*10721*/
					} /*10721*/
				} /*10721*/
				$put($1.msg, $1.j, $1.char); /*10724*/
				$1.i = $1.i + 1; /*10725*/
				$1.j = $1.j + 1; /*10726*/
			} /*10726*/
			$1.msg = $geti($1.msg, 0, $1.j); /*10728*/
			$1.msglen = $1.msg.length; /*10729*/
			$k[$j++] = "numSA"; /*10732*/
			$k[$j++] = Infinity; /*10732*/
			for (var _3f = 0, _3g = $1.msglen; _3f < _3g; _3f++) { /*10732*/
				$k[$j++] = 0; /*10732*/
			} /*10732*/
			$k[$j++] = 0; /*10732*/
			var _3h = $a(); /*10732*/
			$1[$k[--$j]] = _3h; /*10732*/
			$k[$j++] = "numEA"; /*10733*/
			$k[$j++] = Infinity; /*10733*/
			for (var _3k = 0, _3l = $1.msglen; _3k < _3l; _3k++) { /*10733*/
				$k[$j++] = 0; /*10733*/
			} /*10733*/
			$k[$j++] = 0; /*10733*/
			var _3m = $a(); /*10733*/
			$1[$k[--$j]] = _3m; /*10733*/
			for (var _3p = $1.msglen - 1; _3p >= 0; _3p -= 1) { /*10743*/
				$1.i = _3p; /*10735*/
				if ($get($1.msg, $1.i) >= 0) { /*10742*/
					if ($get($1.msg, $1.i) >= 128) { /*10740*/
						$put($1.numEA, $1.i, $get($1.numEA, $1.i + 1) + 1); /*10738*/
					} else { /*10740*/
						$put($1.numSA, $1.i, $get($1.numSA, $1.i + 1) + 1); /*10740*/
					} /*10740*/
				} /*10740*/
			} /*10740*/
			$1.ea = false; /*10746*/
			$1.msgtmp = $a([]); /*10746*/
			for (var _49 = 0, _48 = $1.msglen - 1; _49 <= _48; _49 += 1) { /*10761*/
				$1.i = _49; /*10748*/
				$1.c = $get($1.msg, $1.i); /*10749*/
				if ((!$xo($1.ea, $1.c < 128)) && ($1.c >= 0)) { /*10759*/
					if ($1.ea) { /*10751*/
						$k[$j++] = $1.numSA; /*10751*/
					} else { /*10751*/
						$k[$j++] = $1.numEA; /*10751*/
					} /*10751*/
					var _4L = $get($k[--$j], $1.i); /*10751*/
					var _4O = ((_4L + $1.i) == $1.msglen) ? 3 : 5; /*10752*/
					if (_4L < _4O) { /*10757*/
						$k[$j++] = "msgtmp"; /*10754*/
						$k[$j++] = Infinity; /*10754*/
						$aload($1.msgtmp); /*10754*/
						$k[$j++] = $1.fn4; /*10754*/
						var _4R = $a(); /*10754*/
						$1[$k[--$j]] = _4R; /*10754*/
					} else { /*10757*/
						$k[$j++] = "msgtmp"; /*10756*/
						$k[$j++] = Infinity; /*10756*/
						$aload($1.msgtmp); /*10756*/
						$k[$j++] = $1.fn4; /*10756*/
						$k[$j++] = $1.fn4; /*10756*/
						var _4W = $a(); /*10756*/
						$1[$k[--$j]] = _4W; /*10756*/
						$1.ea = !$1.ea; /*10757*/
					} /*10757*/
				} /*10757*/
				$k[$j++] = "msgtmp"; /*10760*/
				$k[$j++] = Infinity; /*10760*/
				$aload($1.msgtmp); /*10760*/
				if ($1.c >= 0) { /*10760*/
					$k[$j++] = $1.c & 127; /*10760*/
				} else { /*10760*/
					$k[$j++] = $1.c; /*10760*/
				} /*10760*/
				var _4d = $a(); /*10760*/
				$1[$k[--$j]] = _4d; /*10760*/
			} /*10760*/
			$1.msg = $1.msgtmp; /*10762*/
			$1.msglen = $1.msg.length; /*10763*/
			$1.numsscr = function() {
				$1.n = 0; /*10767*/
				$1.s = 0; /*10767*/
				$1.p = $k[--$j]; /*10768*/
				for (;;) { /*10779*/
					if ($1.p >= $1.msglen) { /*10769*/
						break; /*10769*/
					} /*10769*/
					var _4m = $get($1.msg, $1.p); /*10770*/
					var _4o = $get($1.setc, _4m) !== undefined; /*10771*/
					$k[$j++] = _4m; /*10771*/
					if (!_4o) { /*10771*/
						$j--; /*10771*/
						break; /*10771*/
					} /*10771*/
					if ($k[--$j] == $1.fn1) { /*10775*/
						if (($1.s % 2) == 0) { /*10774*/
							$1.s = $1.s + 1; /*10774*/
						} else { /*10774*/
							break; /*10774*/
						} /*10774*/
					} /*10774*/
					$1.n = $1.n + 1; /*10776*/
					$1.s = $1.s + 1; /*10777*/
					$1.p = $1.p + 1; /*10778*/
				} /*10778*/
				$k[$j++] = $1.n; /*10780*/
				$k[$j++] = $1.s; /*10780*/
			}; /*10781*/
			$1.enca = function() {
				$put($1.cws, $1.j, $get($1.seta, $k[--$j])); /*10785*/
				$1.j = $1.j + 1; /*10786*/
			}; /*10787*/
			$1.encb = function() {
				$put($1.cws, $1.j, $get($1.setb, $k[--$j])); /*10789*/
				$1.j = $1.j + 1; /*10790*/
			}; /*10791*/
			$1.encc = function() {
				var _5A = $k[--$j]; /*10793*/
				$k[$j++] = _5A; /*10797*/
				if ($ne($type(_5A), "arraytype")) { /*10796*/
					var _5E = $get($1.setc, $k[--$j]); /*10794*/
					$k[$j++] = _5E; /*10794*/
				} else { /*10796*/
					$aload($k[--$j]); /*10796*/
					var _5G = $k[--$j]; /*10796*/
					var _5H = $k[--$j]; /*10796*/
					$k[$j++] = (_5G - 48) + ((_5H - 48) * 10); /*10796*/
				} /*10796*/
				$put($1.cws, $1.j, $k[--$j]); /*10798*/
				$1.j = $1.j + 1; /*10799*/
			}; /*10800*/
			$1.anotb = function() {
				var _5M = $k[--$j]; /*10803*/
				var _5O = $get($1.seta, _5M) !== undefined; /*10803*/
				var _5Q = $get($1.setb, _5M) !== undefined; /*10803*/
				$k[$j++] = _5O && (!_5Q); /*10803*/
			}; /*10803*/
			$1.bnota = function() {
				var _5R = $k[--$j]; /*10804*/
				var _5T = $get($1.setb, _5R) !== undefined; /*10804*/
				var _5V = $get($1.seta, _5R) !== undefined; /*10804*/
				$k[$j++] = _5T && (!_5V); /*10804*/
			}; /*10804*/
			$k[$j++] = "nextanotb"; /*10807*/
			$k[$j++] = Infinity; /*10807*/
			for (var _5X = 0, _5Y = $1.msg.length; _5X < _5Y; _5X++) { /*10807*/
				$k[$j++] = 0; /*10807*/
			} /*10807*/
			$k[$j++] = 9999; /*10807*/
			var _5Z = $a(); /*10807*/
			$1[$k[--$j]] = _5Z; /*10807*/
			$k[$j++] = "nextbnota"; /*10808*/
			$k[$j++] = Infinity; /*10808*/
			for (var _5c = 0, _5d = $1.msg.length; _5c < _5d; _5c++) { /*10808*/
				$k[$j++] = 0; /*10808*/
			} /*10808*/
			$k[$j++] = 9999; /*10808*/
			var _5e = $a(); /*10808*/
			$1[$k[--$j]] = _5e; /*10808*/
			for (var _5h = $1.msg.length - 1; _5h >= 0; _5h -= 1) { /*10821*/
				$1.i = _5h; /*10810*/
				$k[$j++] = $get($1.msg, $1.i); /*10811*/
				$1.anotb(); /*10811*/
				if ($k[--$j]) { /*10814*/
					$put($1.nextanotb, $1.i, 0); /*10812*/
				} else { /*10814*/
					$put($1.nextanotb, $1.i, $get($1.nextanotb, $1.i + 1) + 1); /*10814*/
				} /*10814*/
				$k[$j++] = $get($1.msg, $1.i); /*10816*/
				$1.bnota(); /*10816*/
				if ($k[--$j]) { /*10819*/
					$put($1.nextbnota, $1.i, 0); /*10817*/
				} else { /*10819*/
					$put($1.nextbnota, $1.i, $get($1.nextbnota, $1.i + 1) + 1); /*10819*/
				} /*10819*/
			} /*10819*/
			$1.abeforeb = function() {
				var _64 = $k[--$j]; /*10824*/
				$k[$j++] = $lt($get($1.nextanotb, _64), $get($1.nextbnota, _64)); /*10824*/
			}; /*10824*/
			$1.bbeforea = function() {
				var _69 = $k[--$j]; /*10825*/
				$k[$j++] = $lt($get($1.nextbnota, _69), $get($1.nextanotb, _69)); /*10825*/
			}; /*10825*/
			$1.cws = $a(($1.barcode.length * 2) + 3); /*10827*/
			$1.i = 0; /*10830*/
			$1.j = 0; /*10830*/
			for (;;) { /*10920*/
				if ($1.pos != -1) { /*10841*/
					$put($1.cws, 0, (~~($1.pos / 10)) - 1); /*10835*/
					$put($1.cws, 1, ($1.pos % 10) - 1); /*10836*/
					$1.j = 2; /*10837*/
					$1.cset = "setb"; /*10838*/
					$1.mode = 7; /*10839*/
					break; /*10840*/
				} /*10840*/
				if ($1.msglen == 0) { /*10847*/
					$1.cset = "setb"; /*10844*/
					$1.mode = 1; /*10845*/
					break; /*10846*/
				} /*10846*/
				if ($1.msglen >= 2) { /*10856*/
					$k[$j++] = $get($1.msg, 0) == $1.fn1; /*10850*/
					$k[$j++] = 1; /*10850*/
					$1.numsscr(); /*10850*/
					var _6Q = $k[--$j]; /*10850*/
					var _6R = $k[--$j]; /*10850*/
					if ($k[--$j] && (_6Q >= 2)) { /*10855*/
						$1.cset = "setc"; /*10851*/
						$1.mode = 4; /*10852*/
						$1.i = 1; /*10853*/
						break; /*10854*/
					} /*10854*/
				} /*10854*/
				if ($get($1.msg, 0) == $1.fn1) { /*10863*/
					$1.cset = "setb"; /*10859*/
					$1.mode = 3; /*10860*/
					$1.i = 1; /*10861*/
					break; /*10862*/
				} /*10862*/
				if ($1.msglen >= 2) { /*10909*/
					$k[$j++] = 0; /*10866*/
					$1.numsscr(); /*10866*/
					var _6X = $k[--$j]; /*10866*/
					var _6Y = $k[--$j]; /*10866*/
					if ((_6X >= 2) && ((_6X % 2) == 0)) { /*10870*/
						$1.cset = "setc"; /*10867*/
						$1.mode = 2; /*10868*/
						break; /*10869*/
					} /*10869*/
					$k[$j++] = 0; /*10872*/
					$1.numsscr(); /*10872*/
					var _6Z = $k[--$j]; /*10872*/
					var _6a = $k[--$j]; /*10872*/
					if ((_6Z >= 3) && ((_6Z % 2) == 1)) { /*10878*/
						$k[$j++] = $get($1.msg, 0); /*10873*/
						$1.encb(); /*10873*/
						$1.cset = "setc"; /*10874*/
						$1.mode = 5; /*10875*/
						$1.i = 1; /*10876*/
						break; /*10877*/
					} /*10877*/
					var _6g = $get($1.setb, $get($1.msg, 0)) !== undefined; /*10880*/
					$k[$j++] = _6g; /*10881*/
					$k[$j++] = 1; /*10881*/
					$1.numsscr(); /*10881*/
					var _6h = $k[--$j]; /*10881*/
					var _6i = $k[--$j]; /*10881*/
					if ($k[--$j] && ((_6h >= 2) && ((_6h % 2) == 0))) { /*10887*/
						$k[$j++] = $get($1.msg, 0); /*10882*/
						$1.encb(); /*10882*/
						$1.cset = "setc"; /*10883*/
						$1.mode = 5; /*10884*/
						$1.i = 1; /*10885*/
						break; /*10886*/
					} /*10886*/
					var _6p = $get($1.setb, $get($1.msg, 0)) !== undefined; /*10889*/
					$k[$j++] = _6p; /*10890*/
					$k[$j++] = 1; /*10890*/
					$1.numsscr(); /*10890*/
					var _6q = $k[--$j]; /*10890*/
					var _6r = $k[--$j]; /*10890*/
					if ($k[--$j] && ((_6q >= 3) && ((_6q % 2) == 1))) { /*10897*/
						$k[$j++] = $get($1.msg, 0); /*10891*/
						$1.encb(); /*10891*/
						$k[$j++] = $get($1.msg, 1); /*10892*/
						$1.encb(); /*10892*/
						$1.cset = "setc"; /*10893*/
						$1.mode = 6; /*10894*/
						$1.i = 2; /*10895*/
						break; /*10896*/
					} /*10896*/
					var _70 = $get($1.setb, $get($1.msg, 0)) !== undefined; /*10899*/
					var _74 = $get($1.setb, $get($1.msg, 1)) !== undefined; /*10900*/
					$k[$j++] = _70 && _74; /*10901*/
					$k[$j++] = 2; /*10901*/
					$1.numsscr(); /*10901*/
					var _75 = $k[--$j]; /*10901*/
					var _76 = $k[--$j]; /*10901*/
					if ($k[--$j] && ((_75 >= 2) && ((_75 % 2) == 0))) { /*10908*/
						$k[$j++] = $get($1.msg, 0); /*10902*/
						$1.encb(); /*10902*/
						$k[$j++] = $get($1.msg, 1); /*10903*/
						$1.encb(); /*10903*/
						$1.cset = "setc"; /*10904*/
						$1.mode = 6; /*10905*/
						$1.i = 2; /*10906*/
						break; /*10907*/
					} /*10907*/
				} /*10907*/
				$k[$j++] = 0; /*10911*/
				$1.abeforeb(); /*10911*/
				if ($k[--$j]) { /*10915*/
					$1.cset = "seta"; /*10912*/
					$1.mode = 0; /*10913*/
					break; /*10914*/
				} /*10914*/
				$1.cset = "setb"; /*10917*/
				$1.mode = 1; /*10918*/
				break; /*10919*/
			} /*10919*/
			for (;;) { /*11163*/
				if ($1.i == $1.msglen) { /*10923*/
					break; /*10923*/
				} /*10923*/
				$k[$j++] = $1.i; /*10925*/
				$1.numsscr(); /*10925*/
				$1.nums = $k[--$j]; /*10925*/
				$1.nchars = $k[--$j]; /*10925*/
				for (;;) { /*11161*/
					if ($eq($1.cset, "seta")) { /*11002*/
						if ($1.i < ($1.msglen - 1)) { /*10939*/
							$k[$j++] = $get($1.msg, $1.i); /*10932*/
							$1.bnota(); /*10932*/
							$k[$j++] = $1.i + 1; /*10933*/
							$1.abeforeb(); /*10933*/
							var _7P = $k[--$j]; /*10933*/
							if (($k[--$j] && _7P)) { /*10938*/
								$k[$j++] = $1.sb1; /*10934*/
								$1.enca(); /*10934*/
								$k[$j++] = $get($1.msg, $1.i); /*10935*/
								$1.encb(); /*10935*/
								$1.i = $1.i + 1; /*10936*/
								break; /*10937*/
							} /*10937*/
						} /*10937*/
						if ($1.i < ($1.msglen - 2)) { /*10951*/
							$k[$j++] = $get($1.msg, $1.i); /*10942*/
							$1.bnota(); /*10942*/
							$k[$j++] = $get($1.msg, $1.i + 1); /*10943*/
							$1.bnota(); /*10943*/
							var _7e = $k[--$j]; /*10943*/
							var _7f = $k[--$j]; /*10943*/
							$k[$j++] = $an(_7f, _7e); /*10944*/
							$k[$j++] = $1.i + 2; /*10944*/
							$1.abeforeb(); /*10944*/
							var _7h = $k[--$j]; /*10944*/
							if (($k[--$j] && _7h)) { /*10950*/
								$k[$j++] = $1.sb2; /*10945*/
								$1.enca(); /*10945*/
								$k[$j++] = $get($1.msg, $1.i); /*10946*/
								$1.encb(); /*10946*/
								$k[$j++] = $get($1.msg, $1.i + 1); /*10947*/
								$1.encb(); /*10947*/
								$1.i = $1.i + 2; /*10948*/
								break; /*10949*/
							} /*10949*/
						} /*10949*/
						$k[$j++] = $get($1.msg, $1.i); /*10953*/
						$1.bnota(); /*10953*/
						if ($k[--$j]) { /*10957*/
							$k[$j++] = $1.swb; /*10954*/
							$1.enca(); /*10954*/
							$1.cset = "setb"; /*10955*/
							break; /*10956*/
						} /*10956*/
						if ($1.i < ($1.msglen - 4)) { /*10974*/
							var _83 = $get($1.seta, $get($1.msg, $1.i + 4)) !== undefined; /*10961*/
							if (($1.nums == 4) && _83) { /*10973*/
								$k[$j++] = $1.sc2; /*10962*/
								$1.enca(); /*10962*/
								for (var _85 = 0, _86 = 2; _85 < _86; _85++) { /*10971*/
									if ($get($1.msg, $1.i) == $1.fn1) { /*10969*/
										$k[$j++] = $1.fn1; /*10965*/
										$1.encc(); /*10965*/
										$1.i = $1.i + 1; /*10966*/
									} else { /*10969*/
										$k[$j++] = $geti($1.msg, $1.i, 2); /*10968*/
										$1.encc(); /*10968*/
										$1.i = $1.i + 2; /*10969*/
									} /*10969*/
								} /*10969*/
								break; /*10972*/
							} /*10972*/
						} /*10972*/
						if ($1.i < ($1.msglen - 6)) { /*10991*/
							var _8O = $get($1.seta, $get($1.msg, $1.i + 6)) !== undefined; /*10978*/
							if (($1.nums == 6) && _8O) { /*10990*/
								$k[$j++] = $1.sc3; /*10979*/
								$1.enca(); /*10979*/
								for (var _8Q = 0, _8R = 3; _8Q < _8R; _8Q++) { /*10988*/
									if ($get($1.msg, $1.i) == $1.fn1) { /*10986*/
										$k[$j++] = $1.fn1; /*10982*/
										$1.encc(); /*10982*/
										$1.i = $1.i + 1; /*10983*/
									} else { /*10986*/
										$k[$j++] = $geti($1.msg, $1.i, 2); /*10985*/
										$1.encc(); /*10985*/
										$1.i = $1.i + 2; /*10986*/
									} /*10986*/
								} /*10986*/
								break; /*10989*/
							} /*10989*/
						} /*10989*/
						if (($1.nums >= 4) && (($1.nums % 2) == 0)) { /*10997*/
							$k[$j++] = $1.swc; /*10994*/
							$1.enca(); /*10994*/
							$1.cset = "setc"; /*10995*/
							break; /*10996*/
						} /*10996*/
						$k[$j++] = $get($1.msg, $1.i); /*10999*/
						$1.enca(); /*10999*/
						$1.i = $1.i + 1; /*11000*/
						break; /*11001*/
					} /*11001*/
					if ($eq($1.cset, "setb")) { /*11076*/
						if ($1.i < ($1.msglen - 1)) { /*11013*/
							$k[$j++] = $get($1.msg, $1.i); /*11006*/
							$1.anotb(); /*11006*/
							$k[$j++] = $1.i + 1; /*11007*/
							$1.bbeforea(); /*11007*/
							var _8q = $k[--$j]; /*11007*/
							if (($k[--$j] && _8q)) { /*11012*/
								$k[$j++] = $1.sa1; /*11008*/
								$1.encb(); /*11008*/
								$k[$j++] = $get($1.msg, $1.i); /*11009*/
								$1.enca(); /*11009*/
								$1.i = $1.i + 1; /*11010*/
								break; /*11011*/
							} /*11011*/
						} /*11011*/
						if ($1.i < ($1.msglen - 2)) { /*11025*/
							$k[$j++] = $get($1.msg, $1.i); /*11016*/
							$1.anotb(); /*11016*/
							$k[$j++] = $get($1.msg, $1.i + 1); /*11017*/
							$1.anotb(); /*11017*/
							var _95 = $k[--$j]; /*11017*/
							var _96 = $k[--$j]; /*11017*/
							$k[$j++] = $an(_96, _95); /*11018*/
							$k[$j++] = $1.i + 2; /*11018*/
							$1.bbeforea(); /*11018*/
							var _98 = $k[--$j]; /*11018*/
							if (($k[--$j] && _98)) { /*11024*/
								$k[$j++] = $1.sa2; /*11019*/
								$1.encb(); /*11019*/
								$k[$j++] = $get($1.msg, $1.i); /*11020*/
								$1.enca(); /*11020*/
								$k[$j++] = $get($1.msg, $1.i + 1); /*11021*/
								$1.enca(); /*11021*/
								$1.i = $1.i + 2; /*11022*/
								break; /*11023*/
							} /*11023*/
						} /*11023*/
						$k[$j++] = $get($1.msg, $1.i); /*11027*/
						$1.anotb(); /*11027*/
						if ($k[--$j]) { /*11031*/
							$k[$j++] = $1.swa; /*11028*/
							$1.encb(); /*11028*/
							$1.cset = "seta"; /*11029*/
							break; /*11030*/
						} /*11030*/
						if ($1.i < ($1.msglen - 4)) { /*11048*/
							var _9U = $get($1.setb, $get($1.msg, $1.i + 4)) !== undefined; /*11035*/
							if (($1.nums == 4) && _9U) { /*11047*/
								$k[$j++] = $1.sc2; /*11036*/
								$1.encb(); /*11036*/
								for (var _9W = 0, _9X = 2; _9W < _9X; _9W++) { /*11045*/
									if ($get($1.msg, $1.i) == $1.fn1) { /*11043*/
										$k[$j++] = $1.fn1; /*11039*/
										$1.encc(); /*11039*/
										$1.i = $1.i + 1; /*11040*/
									} else { /*11043*/
										$k[$j++] = $geti($1.msg, $1.i, 2); /*11042*/
										$1.encc(); /*11042*/
										$1.i = $1.i + 2; /*11043*/
									} /*11043*/
								} /*11043*/
								break; /*11046*/
							} /*11046*/
						} /*11046*/
						if ($1.i < ($1.msglen - 6)) { /*11065*/
							var _9p = $get($1.setb, $get($1.msg, $1.i + 6)) !== undefined; /*11052*/
							if (($1.nums == 6) && _9p) { /*11064*/
								$k[$j++] = $1.sc3; /*11053*/
								$1.encb(); /*11053*/
								for (var _9r = 0, _9s = 3; _9r < _9s; _9r++) { /*11062*/
									if ($get($1.msg, $1.i) == $1.fn1) { /*11060*/
										$k[$j++] = $1.fn1; /*11056*/
										$1.encc(); /*11056*/
										$1.i = $1.i + 1; /*11057*/
									} else { /*11060*/
										$k[$j++] = $geti($1.msg, $1.i, 2); /*11059*/
										$1.encc(); /*11059*/
										$1.i = $1.i + 2; /*11060*/
									} /*11060*/
								} /*11060*/
								break; /*11063*/
							} /*11063*/
						} /*11063*/
						if (($1.nums >= 4) && (($1.nums % 2) == 0)) { /*11071*/
							$k[$j++] = $1.swc; /*11068*/
							$1.encb(); /*11068*/
							$1.cset = "setc"; /*11069*/
							break; /*11070*/
						} /*11070*/
						$k[$j++] = $get($1.msg, $1.i); /*11073*/
						$1.encb(); /*11073*/
						$1.i = $1.i + 1; /*11074*/
						break; /*11075*/
					} /*11075*/
					if ($eq($1.cset, "setc")) { /*11159*/
						if ($1.nums >= 2) { /*11088*/
							if ($get($1.msg, $1.i) == $1.fn1) { /*11085*/
								$k[$j++] = $1.fn1; /*11081*/
								$1.encc(); /*11081*/
								$1.i = $1.i + 1; /*11082*/
							} else { /*11085*/
								$k[$j++] = $geti($1.msg, $1.i, 2); /*11084*/
								$1.encc(); /*11084*/
								$1.i = $1.i + 2; /*11085*/
							} /*11085*/
							break; /*11087*/
						} /*11087*/
						if ($1.i < ($1.msglen - 1)) { /*11098*/
							var _AS = $get($1.setb, $get($1.msg, $1.i)) !== undefined; /*11091*/
							$k[$j++] = _AS; /*11092*/
							$k[$j++] = $1.i + 1; /*11092*/
							$1.numsscr(); /*11092*/
							var _AU = $k[--$j]; /*11092*/
							var _AV = $k[--$j]; /*11092*/
							if ($k[--$j] && ((_AU >= 2) && ((_AU % 2) == 0))) { /*11097*/
								$k[$j++] = $1.sb1; /*11093*/
								$1.encc(); /*11093*/
								$k[$j++] = $get($1.msg, $1.i); /*11094*/
								$1.encb(); /*11094*/
								$1.i = $1.i + 1; /*11095*/
								break; /*11096*/
							} /*11096*/
						} /*11096*/
						if ($1.i < ($1.msglen - 1)) { /*11109*/
							var _Ai = $get($1.setb, $get($1.msg, $1.i)) !== undefined; /*11101*/
							$k[$j++] = _Ai; /*11102*/
							$k[$j++] = $1.i + 1; /*11102*/
							$1.numsscr(); /*11102*/
							var _Ak = $k[--$j]; /*11102*/
							var _Al = $k[--$j]; /*11102*/
							if ($k[--$j] && ((_Ak >= 3) && ((_Ak % 2) == 1))) { /*11108*/
								$k[$j++] = $1.sb2; /*11103*/
								$1.encc(); /*11103*/
								$k[$j++] = $get($1.msg, $1.i); /*11104*/
								$1.encb(); /*11104*/
								$k[$j++] = $get($1.msg, $1.i + 1); /*11105*/
								$1.encb(); /*11105*/
								$1.i = $1.i + 2; /*11106*/
								break; /*11107*/
							} /*11107*/
						} /*11107*/
						if ($1.i < ($1.msglen - 2)) { /*11121*/
							var _B1 = $get($1.setb, $get($1.msg, $1.i)) !== undefined; /*11112*/
							var _B6 = $get($1.setb, $get($1.msg, $1.i + 1)) !== undefined; /*11113*/
							$k[$j++] = _B1 && _B6; /*11114*/
							$k[$j++] = $1.i + 2; /*11114*/
							$1.numsscr(); /*11114*/
							var _B8 = $k[--$j]; /*11114*/
							var _B9 = $k[--$j]; /*11114*/
							if ($k[--$j] && ((_B8 >= 2) && ((_B8 % 2) == 0))) { /*11120*/
								$k[$j++] = $1.sb2; /*11115*/
								$1.encc(); /*11115*/
								$k[$j++] = $get($1.msg, $1.i); /*11116*/
								$1.encb(); /*11116*/
								$k[$j++] = $get($1.msg, $1.i + 1); /*11117*/
								$1.encb(); /*11117*/
								$1.i = $1.i + 2; /*11118*/
								break; /*11119*/
							} /*11119*/
						} /*11119*/
						if ($1.i < ($1.msglen - 3)) { /*11134*/
							var _BP = $get($1.setb, $get($1.msg, $1.i)) !== undefined; /*11124*/
							var _BU = $get($1.setb, $get($1.msg, $1.i + 1)) !== undefined; /*11125*/
							$k[$j++] = _BP && _BU; /*11126*/
							$k[$j++] = $1.i + 2; /*11126*/
							$1.numsscr(); /*11126*/
							var _BW = $k[--$j]; /*11126*/
							var _BX = $k[--$j]; /*11126*/
							if ($k[--$j] && ((_BW >= 3) && ((_BW % 2) == 1))) { /*11133*/
								$k[$j++] = $1.sb3; /*11127*/
								$1.encc(); /*11127*/
								$k[$j++] = $get($1.msg, $1.i); /*11128*/
								$1.encb(); /*11128*/
								$k[$j++] = $get($1.msg, $1.i + 1); /*11129*/
								$1.encb(); /*11129*/
								$k[$j++] = $get($1.msg, $1.i + 2); /*11130*/
								$1.encb(); /*11130*/
								$1.i = $1.i + 3; /*11131*/
								break; /*11132*/
							} /*11132*/
						} /*11132*/
						if ($1.i < ($1.msglen - 3)) { /*11148*/
							var _Bq = $get($1.setb, $get($1.msg, $1.i)) !== undefined; /*11137*/
							var _Bv = $get($1.setb, $get($1.msg, $1.i + 1)) !== undefined; /*11138*/
							var _C0 = $get($1.setb, $get($1.msg, $1.i + 2)) !== undefined; /*11139*/
							$k[$j++] = (_Bq && _Bv) && _C0; /*11140*/
							$k[$j++] = $1.i + 3; /*11140*/
							$1.numsscr(); /*11140*/
							var _C2 = $k[--$j]; /*11140*/
							var _C3 = $k[--$j]; /*11140*/
							if ($k[--$j] && ((_C2 >= 2) && ((_C2 % 2) == 0))) { /*11147*/
								$k[$j++] = $1.sb3; /*11141*/
								$1.encc(); /*11141*/
								$k[$j++] = $get($1.msg, $1.i); /*11142*/
								$1.encb(); /*11142*/
								$k[$j++] = $get($1.msg, $1.i + 1); /*11143*/
								$1.encb(); /*11143*/
								$k[$j++] = $get($1.msg, $1.i + 2); /*11144*/
								$1.encb(); /*11144*/
								$1.i = $1.i + 3; /*11145*/
								break; /*11146*/
							} /*11146*/
						} /*11146*/
						$k[$j++] = $1.i; /*11150*/
						$1.abeforeb(); /*11150*/
						if ($k[--$j]) { /*11154*/
							$k[$j++] = $1.swa; /*11151*/
							$1.encc(); /*11151*/
							$1.cset = "seta"; /*11152*/
							break; /*11153*/
						} /*11153*/
						$k[$j++] = $1.swb; /*11156*/
						$1.encc(); /*11156*/
						$1.cset = "setb"; /*11157*/
						break; /*11158*/
					} /*11158*/
					break; /*11160*/
				} /*11160*/
			} /*11160*/
			$1.cws = $geti($1.cws, 0, $1.j); /*11164*/
		} /*11164*/
		$1.metrics = $a([$a([2, 7]), $a([3, 12]), $a([4, 17]), $a([5, 22]), $a([6, 27]), $a([7, 32]), $a([8, 37]), $a([9, 42]), $a([10, 47]), $a([11, 52]), $a([12, 57]), $a([13, 62]), $a([14, 67]), $a([15, 72]), $a([16, 77])]); /*11185*/
		$1.urows = $1.rows; /*11188*/
		$1.i = 0; /*11189*/
		for (;;) { /*11199*/
			$1.m = $get($1.metrics, $1.i); /*11191*/
			$1.r = $get($1.m, 0); /*11192*/
			$1.dcws = $get($1.m, 1); /*11193*/
			$1.okay = true; /*11194*/
			if (($1.urows != 0) && ($1.urows != $1.r)) { /*11195*/
				$1.okay = false; /*11195*/
			} /*11195*/
			if ($1.cws.length > $1.dcws) { /*11196*/
				$1.okay = false; /*11196*/
			} /*11196*/
			if ($1.okay) { /*11197*/
				break; /*11197*/
			} /*11197*/
			$1.i = $1.i + 1; /*11198*/
		} /*11198*/
		$k[$j++] = "cws"; /*11202*/
		$k[$j++] = Infinity; /*11202*/
		$aload($1.cws); /*11202*/
		for (var _Cv = 0, _Cw = $1.dcws - $1.cws.length; _Cv < _Cw; _Cv++) { /*11202*/
			$k[$j++] = 103; /*11202*/
		} /*11202*/
		var _Cx = $a(); /*11202*/
		$1[$k[--$j]] = _Cx; /*11202*/
		$k[$j++] = "cws"; /*11205*/
		$k[$j++] = Infinity; /*11205*/
		$k[$j++] = (($1.r - 2) * 7) + $1.mode; /*11205*/
		$aload($1.cws); /*11205*/
		var _D2 = $a(); /*11205*/
		$1[$k[--$j]] = _D2; /*11205*/
		$k[$j++] = 0; /*11208*/
		for (var _D6 = 0, _D5 = $1.dcws; _D6 <= _D5; _D6 += 1) { /*11208*/
			var _D9 = $k[--$j]; /*11208*/
			$k[$j++] = _D9 + ((_D6 + 2) * $get($1.cws, _D6)); /*11208*/
		} /*11208*/
		$1.c1 = $k[--$j] % 107; /*11209*/
		$k[$j++] = 0; /*11210*/
		for (var _DD = 0, _DC = $1.dcws; _DD <= _DC; _DD += 1) { /*11210*/
			var _DG = $k[--$j]; /*11210*/
			$k[$j++] = _DG + ((_DD + 1) * $get($1.cws, _DD)); /*11210*/
		} /*11210*/
		$1.c2 = ($k[--$j] + ($1.c1 * ($1.dcws + 2))) % 107; /*11211*/
		$k[$j++] = "cws"; /*11212*/
		$k[$j++] = Infinity; /*11212*/
		$aload($1.cws); /*11212*/
		$k[$j++] = $1.c1; /*11212*/
		$k[$j++] = $1.c2; /*11212*/
		var _DN = $a(); /*11212*/
		$1[$k[--$j]] = _DN; /*11212*/
		$1.encs = $a(["212222", "222122", "222221", "121223", "121322", "131222", "122213", "122312", "132212", "221213", "221312", "231212", "112232", "122132", "122231", "113222", "123122", "123221", "223211", "221132", "221231", "213212", "223112", "312131", "311222", "321122", "321221", "312212", "322112", "322211", "212123", "212321", "232121", "111323", "131123", "131321", "112313", "132113", "132311", "211313", "231113", "231311", "112133", "112331", "132131", "113123", "113321", "133121", "313121", "211331", "231131", "213113", "213311", "213131", "311123", "311321", "331121", "312113", "312311", "332111", "314111", "221411", "431111", "111224", "111422", "121124", "121421", "141122", "141221", "112214", "112412", "122114", "122411", "142112", "142211", "241211", "221114", "413111", "241112", "134111", "111242", "121142", "121241", "114212", "124112", "124211", "411212", "421112", "421211", "212141", "214121", "412121", "111143", "111341", "131141", "114113", "114311", "411113", "411311", "113141", "114131", "311141", "411131", "211412", "211214", "211232", "211133"]); /*11232*/
		$1.startencs = $a(["3211", "2221", "2122", "1411", "1132", "1231", "1114", "3112", "3211", "2221", "2122", "1411", "1132", "1231", "1114", "3112"]); /*11238*/
		$1.stopencsodd = $a(["3211", "2221", "2122", "1411", "1132", "1231", "1114", "3112", "1132", "1231", "1114", "3112", "3211", "2221", "2122", "1411"]); /*11242*/
		$1.stopencseven = $a(["2122", "1411", "1132", "1231", "1114", "3112", "1132", "1231", "1114", "3112", "3211", "2221", "2122", "1411", "3211", "2221"]); /*11246*/
		if (($1.pos == -1) || (((~~($1.pos / 10)) % 2) == 1)) { /*11250*/
			$1.stopencs = $1.stopencsodd; /*11248*/
		} else { /*11250*/
			$1.stopencs = $1.stopencseven; /*11250*/
		} /*11250*/
		$1.rowbits = $a($1.r); /*11254*/
		for (var _Db = 0, _Da = $1.r - 1; _Db <= _Da; _Db += 1) { /*11271*/
			$1.i = _Db; /*11256*/
			$k[$j++] = "sbs"; /*11265*/
			$k[$j++] = Infinity; /*11265*/
			$k[$j++] = 10; /*11259*/
			$forall($get($1.startencs, $1.i), function() { /*11259*/
				var _Df = $k[--$j]; /*11259*/
				$k[$j++] = _Df - 48; /*11259*/
			}) /*11259*/
			$k[$j++] = 1; /*11263*/
			$forall($geti($1.cws, $1.i * 5, 5), function() { /*11263*/
				$forall($get($1.encs, $k[--$j]), function() { /*11262*/
					var _Dm = $k[--$j]; /*11262*/
					$k[$j++] = _Dm - 48; /*11262*/
				}) /*11262*/
			}) /*11262*/
			$forall($get($1.stopencs, $1.i), function() { /*11264*/
				var _Dq = $k[--$j]; /*11264*/
				$k[$j++] = _Dq - 48; /*11264*/
			}) /*11264*/
			$k[$j++] = 1; /*11265*/
			var _Dr = $a(); /*11265*/
			$1[$k[--$j]] = _Dr; /*11266*/
			$k[$j++] = Infinity; /*11267*/
			$k[$j++] = 1; /*11268*/
			$forall($1.sbs, function() { /*11268*/
				var _Du = $k[--$j]; /*11268*/
				var _Dv = $k[--$j]; /*11268*/
				var _Dw = (_Dv == 0) ? 1 : 0; /*11268*/
				$k[$j++] = _Dv; /*11268*/
				for (var _Dx = 0, _Dy = _Du; _Dx < _Dy; _Dx++) { /*11268*/
					$k[$j++] = _Dw /*11268*/
				} /*11268*/
			}) /*11268*/
			$astore($a($counttomark() - 1)); /*11269*/
			var _E1 = $k[--$j]; /*11269*/
			var _E2 = $k[--$j]; /*11269*/
			var _E3 = $k[--$j]; /*11269*/
			$put($1.rowbits, $1.i, _E1); /*11270*/
		} /*11270*/
		$k[$j++] = "pixs"; /*11282*/
		$k[$j++] = Infinity; /*11282*/
		for (var _E7 = 0, _E8 = 81 * $1.sepheight; _E7 < _E8; _E7++) { /*11275*/
			$k[$j++] = 1; /*11275*/
		} /*11275*/
		for (var _EB = 0, _EA = $1.r - 2; _EB <= _EA; _EB += 1) { /*11280*/
			$1.i = _EB; /*11277*/
			for (var _ED = 0, _EE = $1.rowheight; _ED < _EE; _ED++) { /*11278*/
				$aload($get($1.rowbits, $1.i)); /*11278*/
			} /*11278*/
			for (var _EJ = 0, _EK = $1.sepheight; _EJ < _EK; _EJ++) { /*11279*/
				for (var _EL = 0, _EM = 10; _EL < _EM; _EL++) { /*11279*/
					$k[$j++] = 0; /*11279*/
				} /*11279*/
				for (var _EN = 0, _EO = 70; _EN < _EO; _EN++) { /*11279*/
					$k[$j++] = 1; /*11279*/
				} /*11279*/
				$k[$j++] = 0; /*11279*/
			} /*11279*/
		} /*11279*/
		for (var _EQ = 0, _ER = $1.rowheight; _EQ < _ER; _EQ++) { /*11281*/
			$aload($get($1.rowbits, $1.r - 1)); /*11281*/
		} /*11281*/
		for (var _EW = 0, _EX = 81 * $1.sepheight; _EW < _EX; _EW++) { /*11282*/
			$k[$j++] = 1; /*11282*/
		} /*11282*/
		var _EY = $a(); /*11282*/
		$1[$k[--$j]] = _EY; /*11283*/
		var _Ee = {
			ren: $0.renmatrix,
			pixs: $1.pixs,
			pixx: 81,
			pixy: ~~($1.pixs.length / 81),
			height: (~~($1.pixs.length / 81)) / 72,
			width: 81 / 72,
			opt: $1.options
		}; /*11293*/
		$k[$j++] = _Ee; /*11296*/
		if (!$1.dontdraw) { /*11296*/
			$0.renmatrix(); /*11296*/
		} /*11296*/
	};
	$0.code49 = function() {
		var $1 = {}; /*11323*/
		$1.options = $k[--$j]; /*11325*/
		$1.barcode = $k[--$j]; /*11326*/
		$1.dontdraw = false; /*11328*/
		$1.mode = -1; /*11329*/
		$1.pos = -1; /*11330*/
		$1.rows = 0; /*11331*/
		$1.rowheight = 8; /*11332*/
		$1.sepheight = 1; /*11333*/
		$1.parse = false; /*11334*/
		$1.parsefnc = false; /*11335*/
		$forall($1.options, function() { /*11346*/
			var _3 = $k[--$j]; /*11346*/
			$1[$k[--$j]] = _3; /*11346*/
		}) /*11346*/
		$1.mode = ~~$1.mode; /*11348*/
		$1.pos = ~~$1.pos; /*11349*/
		$1.rows = ~~$1.rows; /*11350*/
		$1.rowheight = ~~$1.rowheight; /*11351*/
		$1.sepheight = ~~$1.sepheight; /*11352*/
		$1.barlen = $1.barcode.length; /*11375*/
		$1.s1 = -1; /*11378*/
		$1.s2 = -2; /*11378*/
		$1.fn1 = -3; /*11378*/
		$1.fn2 = -4; /*11378*/
		$1.fn3 = -5; /*11378*/
		$1.ns = -6; /*11378*/
		var _E = {
			FNC1: $1.fn1,
			FNC2: $1.fn2,
			FNC3: $1.fn3
		}; /*11382*/
		$1.fncvals = _E; /*11383*/
		$1.msg = $a($1.barlen); /*11384*/
		$1.i = 0; /*11385*/
		$1.j = 0; /*11385*/
		for (;;) { /*11399*/
			if ($1.i == $1.barlen) { /*11386*/
				break; /*11386*/
			} /*11386*/
			$1.char = $get($1.barcode, $1.i); /*11387*/
			if (($1.parsefnc && ($1.char == 94)) && ($1.i < ($1.barlen - 4))) { /*11395*/
				if ($get($1.barcode, $1.i + 1) != 94) { /*11393*/
					$1.char = $get($1.fncvals, $geti($1.barcode, $1.i + 1, 4)); /*11390*/
					$1.i = $1.i + 4; /*11391*/
				} else { /*11393*/
					$1.i = $1.i + 1; /*11393*/
				} /*11393*/
			} /*11393*/
			$put($1.msg, $1.j, $1.char); /*11396*/
			$1.i = $1.i + 1; /*11397*/
			$1.j = $1.j + 1; /*11398*/
		} /*11398*/
		$1.msg = $geti($1.msg, 0, $1.j); /*11400*/
		$1.msglen = $1.msg.length; /*11401*/
		$1.charmap = $a(["0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "-", ".", " ", "$", "/", "+", "%", $1.s1, $1.s2, $1.fn1, $1.fn2, $1.fn3, $1.ns]); /*11410*/
		$1.charvals = {}; /*11413*/
		for (var _q = 0; _q <= 48; _q += 1) { /*11419*/
			$1.i = _q; /*11415*/
			var _t = $get($1.charmap, $1.i); /*11416*/
			$k[$j++] = _t; /*11417*/
			if ($eq($type(_t), "stringtype")) { /*11417*/
				var _w = $get($k[--$j], 0); /*11417*/
				$k[$j++] = _w; /*11417*/
			} /*11417*/
			$put($1.charvals, $k[--$j], $1.i); /*11418*/
		} /*11418*/
		$1.combos = $a(["1 ", "1A", "1B", "1C", "1D", "1E", "1F", "1G", "1H", "1I", "1J", "1K", "1L", "1M", "1N", "1O", "1P", "1Q", "1R", "1S", "1T", "1U", "1V", "1W", "1X", "1Y", "1Z", "11", "12", "13", "14", "15", "  ", "16", "17", "18", " $", " %", "19", "10", "1-", "1.", "1$", " +", "1/", " -", " .", " /", " 0", " 1", " 2", " 3", " 4", " 5", " 6", " 7", " 8", " 9", "1+", "21", "22", "23", "24", "25", "26", " A", " B", " C", " D", " E", " F", " G", " H", " I", " J", " K", " L", " M", " N", " O", " P", " Q", " R", " S", " T", " U", " V", " W", " X", " Y", " Z", "27", "28", "29", "20", "2-", "2.", "2A", "2B", "2C", "2D", "2E", "2F", "2G", "2H", "2I", "2J", "2K", "2L", "2M", "2N", "2O", "2P", "2Q", "2R", "2S", "2T", "2U", "2V", "2W", "2X", "2Y", "2Z", "2$", "2/", "2+", "2%", "2 "]); /*11431*/
		for (var _11 = 0; _11 <= 127; _11 += 1) { /*11441*/
			$1.i = _11; /*11433*/
			var _14 = $get($1.combos, $1.i); /*11434*/
			$1.c1 = $get(_14, 0); /*11434*/
			$1.c2 = $get(_14, 1); /*11434*/
			if ($1.c1 == 49) { /*11437*/
				$put($1.charvals, $1.i, $a([$get($1.charvals, $1.s1), $get($1.charvals, $1.c2)])); /*11436*/
			} /*11436*/
			if ($1.c1 == 50) { /*11440*/
				$put($1.charvals, $1.i, $a([$get($1.charvals, $1.s2), $get($1.charvals, $1.c2)])); /*11439*/
			} /*11439*/
		} /*11439*/
		$1.encodealpha = function() {
			var _1T = $get($1.charvals, $k[--$j]); /*11444*/
			$k[$j++] = _1T; /*11445*/
			if ($ne($type(_1T), "arraytype")) { /*11445*/
				$astore($a(1)); /*11445*/
			} /*11445*/
			var _1W = $k[--$j]; /*11446*/
			$puti($1.cws, $1.j, _1W); /*11446*/
			$1.j = _1W.length + $1.j; /*11447*/
		}; /*11448*/
		$1.base48 = function() {
			var _1a = $k[--$j]; /*11451*/
			$k[$j++] = 0; /*11451*/
			$forall(_1a, function() { /*11451*/
				var _1b = $k[--$j]; /*11451*/
				var _1c = $k[--$j]; /*11451*/
				$k[$j++] = (_1b - 48) + (_1c * 10); /*11451*/
			}) /*11451*/
			$k[$j++] = Infinity; /*11452*/
			var _1d = $k[--$j]; /*11452*/
			var _1e = $k[--$j]; /*11452*/
			var _1f = $k[--$j]; /*11452*/
			$k[$j++] = _1d; /*11452*/
			$k[$j++] = _1e; /*11452*/
			for (var _1g = 0, _1h = _1f - 1; _1g < _1h; _1g++) { /*11452*/
				var _1i = $k[--$j]; /*11452*/
				$k[$j++] = _1i % 48; /*11452*/
				$k[$j++] = ~~(_1i / 48); /*11452*/
			} /*11452*/
			var _1j = $a(); /*11452*/
			$k[$j++] = _1j; /*11453*/
			$k[$j++] = Infinity; /*11453*/
			var _1k = $k[--$j]; /*11453*/
			var _1l = $k[--$j]; /*11453*/
			$k[$j++] = _1k; /*11453*/
			$k[$j++] = _1l; /*11453*/
			for (var _1m = _1l.length - 1; _1m >= 0; _1m -= 1) { /*11453*/
				var _1n = $k[--$j]; /*11453*/
				$k[$j++] = $get(_1n, _1m); /*11453*/
				$k[$j++] = _1n; /*11453*/
			} /*11453*/
			$j--; /*11453*/
			var _1p = $a(); /*11453*/
			$puti($1.cws, $1.j, _1p); /*11454*/
			$1.j = _1p.length + $1.j; /*11455*/
		}; /*11456*/
		$1.encodenumeric = function() {
			$1.nums = $k[--$j]; /*11459*/
			var _1v = $1.nums.length; /*11460*/
			var _1w = _1v % 5; /*11460*/
			$k[$j++] = "pre"; /*11460*/
			$k[$j++] = _1v; /*11460*/
			$k[$j++] = _1w; /*11460*/
			if (_1w != 2) { /*11460*/
				var _1x = $k[--$j]; /*11460*/
				var _1y = $k[--$j]; /*11460*/
				$k[$j++] = _1y - _1x; /*11460*/
			} else { /*11460*/
				var _1z = $k[--$j]; /*11460*/
				var _20 = $k[--$j]; /*11460*/
				$k[$j++] = (_20 - _1z) - 5; /*11460*/
			} /*11460*/
			var _21 = $k[--$j]; /*11460*/
			$1[$k[--$j]] = _21; /*11460*/
			for (var _25 = 0, _24 = $1.pre - 1; _25 <= _24; _25 += 5) { /*11461*/
				$k[$j++] = 3; /*11461*/
				$k[$j++] = $geti($1.nums, _25, 5); /*11461*/
				$1.base48(); /*11461*/
			} /*11461*/
			$1.nums = $geti($1.nums, $1.pre, $1.nums.length - $1.pre); /*11462*/
			var _2E = $1.nums.length; /*11464*/
			$k[$j++] = _2E; /*11464*/
			if (_2E == 1) { /*11464*/
				$k[$j++] = $get($1.nums, $1.i); /*11464*/
				$1.encodealpha(); /*11464*/
			} /*11464*/
			var _2I = $k[--$j]; /*11465*/
			$k[$j++] = _2I; /*11465*/
			if (_2I == 3) { /*11465*/
				$k[$j++] = 2; /*11465*/
				$k[$j++] = $1.nums; /*11465*/
				$1.base48(); /*11465*/
			} /*11465*/
			var _2K = $k[--$j]; /*11466*/
			$k[$j++] = _2K; /*11466*/
			if (_2K == 4) { /*11466*/
				$k[$j++] = 3; /*11466*/
				$k[$j++] = Infinity; /*11466*/
				$k[$j++] = 49; /*11466*/
				$k[$j++] = 48; /*11466*/
				$aload($1.nums); /*11466*/
				var _2M = $a(); /*11466*/
				$k[$j++] = _2M; /*11466*/
				$1.base48(); /*11466*/
			} /*11466*/
			if ($k[--$j] == 7) { /*11470*/
				$k[$j++] = 3; /*11468*/
				$k[$j++] = Infinity; /*11468*/
				$k[$j++] = 49; /*11468*/
				$k[$j++] = 48; /*11468*/
				$aload($geti($1.nums, 0, 4)); /*11468*/
				var _2Q = $a(); /*11468*/
				$k[$j++] = _2Q; /*11468*/
				$1.base48(); /*11468*/
				$k[$j++] = 2; /*11469*/
				$k[$j++] = $geti($1.nums, 4, 3); /*11469*/
				$1.base48(); /*11469*/
			} /*11469*/
		}; /*11471*/
		$k[$j++] = "numericruns"; /*11474*/
		$k[$j++] = Infinity; /*11474*/
		for (var _2U = 0, _2V = $1.msglen; _2U < _2V; _2U++) { /*11474*/
			$k[$j++] = 0; /*11474*/
		} /*11474*/
		$k[$j++] = 0; /*11474*/
		var _2W = $a(); /*11474*/
		$1[$k[--$j]] = _2W; /*11474*/
		for (var _2Z = $1.msglen - 1; _2Z >= 0; _2Z -= 1) { /*11483*/
			$1.i = _2Z; /*11476*/
			var _2c = $get($1.msg, $1.i); /*11477*/
			if ((_2c >= 48) && (_2c <= 57)) { /*11481*/
				$put($1.numericruns, $1.i, $get($1.numericruns, $1.i + 1) + 1); /*11479*/
			} else { /*11481*/
				$put($1.numericruns, $1.i, 0); /*11481*/
			} /*11481*/
		} /*11481*/
		if ($1.mode == -1) { /*11495*/
			for (;;) { /*11494*/
				if ($1.pos != -1) { /*11488*/
					$1.mode = 3; /*11488*/
					break; /*11488*/
				} /*11488*/
				if ($get($1.numericruns, 0) >= 5) { /*11489*/
					$1.mode = 2; /*11489*/
					break; /*11489*/
				} /*11489*/
				var _2r = $get($1.charvals, $get($1.msg, 0)); /*11490*/
				$k[$j++] = _2r; /*11491*/
				if ($ne($type(_2r), "arraytype")) { /*11491*/
					$j--; /*11491*/
					$1.mode = 0; /*11491*/
					break; /*11491*/
				} /*11491*/
				var _2v = ($get($k[--$j], 0) == 43) ? 4 : 5; /*11492*/
				$1.mode = _2v; /*11492*/
				break; /*11493*/
			} /*11493*/
		} /*11493*/
		$1.cws = $a(($1.msglen * 2) + 1); /*11497*/
		$1.method = "alpha"; /*11498*/
		$1.i = -1; /*11498*/
		$1.j = -1; /*11498*/
		if (($1.mode == 0) || ($1.mode == 1)) { /*11501*/
			$1.method = "alpha"; /*11501*/
			$1.i = 0; /*11501*/
			$1.j = 0; /*11501*/
		} /*11501*/
		if ($1.mode == 2) { /*11502*/
			$1.method = "numeric"; /*11502*/
			$1.i = 0; /*11502*/
			$1.j = 0; /*11502*/
		} /*11502*/
		if ($1.mode == 3) { /*11516*/
			$1.posval = $a([12, 22, 13, 23, 33, 14, 24, 34, 44, 15, 25, 35, 45, 55, 16, 26, 36, 46, 56, 66, 17, 27, 37, 47, 57, 67, 77, 18, 28, 38, 48, 58, 68, 78, 88, 19, 29, 39, 49, 59, 69, 79, 89, 99]); /*11513*/
			$k[$j++] = $1.cws; /*11514*/
			$k[$j++] = 0; /*11514*/
			for (var _34 = 0; _34 <= 43; _34 += 1) { /*11514*/
				$k[$j++] = _34; /*11514*/
				if ($get($1.posval, _34) != $1.pos) { /*11514*/
					$j--; /*11514*/
				} /*11514*/
			} /*11514*/
			var _38 = $k[--$j]; /*11514*/
			var _39 = $k[--$j]; /*11514*/
			$put($k[--$j], _39, _38 + 1); /*11514*/
			$1.method = "alpha"; /*11515*/
			$1.i = 0; /*11515*/
			$1.j = 1; /*11515*/
		} /*11515*/
		if (($1.mode == 4) || ($1.mode == 5)) { /*11520*/
			$put($1.cws, 0, $get($get($1.charvals, $get($1.msg, 0)), 1)); /*11518*/
			$1.method = "alpha"; /*11519*/
			$1.i = 1; /*11519*/
			$1.j = 1; /*11519*/
		} /*11519*/
		for (;;) { /*11547*/
			if ($1.i == $1.msglen) { /*11524*/
				break; /*11524*/
			} /*11524*/
			for (;;) { /*11546*/
				if ($eq($1.method, "alpha")) { /*11535*/
					if ($get($1.numericruns, $1.i) >= 5) { /*11531*/
						$k[$j++] = $1.ns; /*11528*/
						$1.encodealpha(); /*11528*/
						$1.method = "numeric"; /*11529*/
						break; /*11530*/
					} /*11530*/
					$k[$j++] = $get($1.msg, $1.i); /*11532*/
					$1.encodealpha(); /*11532*/
					$1.i = $1.i + 1; /*11533*/
					break; /*11534*/
				} /*11534*/
				if ($eq($1.method, "numeric")) { /*11545*/
					if ($get($1.numericruns, $1.i) < 5) { /*11541*/
						$k[$j++] = $1.ns; /*11538*/
						$1.encodealpha(); /*11538*/
						$1.method = "alpha"; /*11539*/
						break; /*11540*/
					} /*11540*/
					$k[$j++] = $geti($1.msg, $1.i, $get($1.numericruns, $1.i)); /*11542*/
					$1.encodenumeric(); /*11542*/
					$1.i = $1.i + $get($1.numericruns, $1.i); /*11543*/
					break; /*11544*/
				} /*11544*/
			} /*11544*/
		} /*11544*/
		$1.cws = $geti($1.cws, 0, $1.j); /*11548*/
		$1.metrics = $a([$a([2, 9]), $a([3, 16]), $a([4, 23]), $a([5, 30]), $a([6, 37]), $a([7, 42]), $a([8, 49])]); /*11560*/
		$1.urows = $1.rows; /*11563*/
		$1.i = 0; /*11564*/
		for (;;) { /*11574*/
			$1.m = $get($1.metrics, $1.i); /*11566*/
			$1.r = $get($1.m, 0); /*11567*/
			$1.dcws = $get($1.m, 1); /*11568*/
			$1.okay = true; /*11569*/
			if (($1.urows != 0) && ($1.urows != $1.r)) { /*11570*/
				$1.okay = false; /*11570*/
			} /*11570*/
			if ($1.cws.length > $1.dcws) { /*11571*/
				$1.okay = false; /*11571*/
			} /*11571*/
			if ($1.okay) { /*11572*/
				break; /*11572*/
			} /*11572*/
			$1.i = $1.i + 1; /*11573*/
		} /*11573*/
		$k[$j++] = "cws"; /*11577*/
		$k[$j++] = Infinity; /*11577*/
		$aload($1.cws); /*11577*/
		for (var _4C = 0, _4D = $1.dcws - $1.cws.length; _4C < _4D; _4C++) { /*11577*/
			$k[$j++] = 48; /*11577*/
		} /*11577*/
		var _4E = $a(); /*11577*/
		$1[$k[--$j]] = _4E; /*11577*/
		$1.ccs = $a($1.r * 8); /*11580*/
		$1.j = 0; /*11581*/
		for (var _4K = 0, _4J = $1.r - 2; _4K <= _4J; _4K += 1) { /*11588*/
			$1.i = _4K; /*11583*/
			$1.cc = $geti($1.cws, $1.j, 7); /*11584*/
			$puti($1.ccs, $1.i * 8, $1.cc); /*11585*/
			$k[$j++] = $1.ccs; /*11586*/
			$k[$j++] = ($1.i * 8) + 7; /*11586*/
			$k[$j++] = 0; /*11586*/
			$forall($1.cc, function() { /*11586*/
				var _4U = $k[--$j]; /*11586*/
				var _4V = $k[--$j]; /*11586*/
				$k[$j++] = _4V + _4U; /*11586*/
			}) /*11586*/
			var _4W = $k[--$j]; /*11586*/
			var _4X = $k[--$j]; /*11586*/
			$put($k[--$j], _4X, _4W % 49); /*11586*/
			$1.j = $1.j + 7; /*11587*/
		} /*11587*/
		if ($1.j < $1.dcws) { /*11591*/
			$puti($1.ccs, $1.ccs.length - 8, $geti($1.cws, $1.j, $1.dcws - $1.j)); /*11590*/
		} /*11590*/
		$1.cr7 = (($1.r - 2) * 7) + $1.mode; /*11594*/
		$put($1.ccs, $1.ccs.length - 2, $1.cr7); /*11595*/
		var _4o = $a([1, 9, 31, 26, 2, 12, 17, 23, 37, 18, 22, 6, 27, 44, 15, 43, 39, 11, 13, 5, 41, 33, 36, 8, 4, 32, 3, 19, 40, 25, 29, 10, 24, 30]); /*11599*/
		$k[$j++] = _4o; /*11600*/
		$k[$j++] = _4o; /*11600*/
		$k[$j++] = Infinity; /*11600*/
		var _4p = $k[--$j]; /*11600*/
		var _4r = $geti($k[--$j], 0, 32); /*11600*/
		$k[$j++] = _4p; /*11600*/
		$k[$j++] = 20; /*11600*/
		$aload(_4r); /*11600*/
		$1.weightx = $a(); /*11600*/
		var _4t = $k[--$j]; /*11601*/
		$k[$j++] = _4t; /*11601*/
		$k[$j++] = _4t; /*11601*/
		$k[$j++] = Infinity; /*11601*/
		var _4u = $k[--$j]; /*11601*/
		var _4w = $geti($k[--$j], 1, 32); /*11601*/
		$k[$j++] = _4u; /*11601*/
		$k[$j++] = 16; /*11601*/
		$aload(_4w); /*11601*/
		$1.weighty = $a(); /*11601*/
		$k[$j++] = Infinity; /*11602*/
		var _4y = $k[--$j]; /*11602*/
		var _50 = $geti($k[--$j], 2, 32); /*11602*/
		$k[$j++] = _4y; /*11602*/
		$k[$j++] = 38; /*11602*/
		$aload(_50); /*11602*/
		$1.weightz = $a(); /*11602*/
		$1.calccheck = function() {
			$1.weights = $k[--$j]; /*11604*/
			$1.score = 0; /*11605*/
			for (var _55 = 0, _54 = (~~((($1.r - 1) * 8) / 2)) - 1; _55 <= _54; _55 += 1) { /*11610*/
				$1.i = _55; /*11607*/
				$1.score = ((($get($1.ccs, $1.i * 2) * 49) + $get($1.ccs, ($1.i * 2) + 1)) * $get($1.weights, $1.i + 1)) + $1.score; /*11609*/
			} /*11609*/
			$k[$j++] = $1.score; /*11611*/
		}; /*11612*/
		$1.lastrow = $geti($1.ccs, $1.ccs.length - 8, 8); /*11613*/
		if ($1.r >= 7) { /*11620*/
			$k[$j++] = $1.cr7 * $get($1.weightz, 0); /*11617*/
			$k[$j++] = $1.weightz; /*11617*/
			$1.calccheck(); /*11617*/
			var _5P = $k[--$j]; /*11617*/
			var _5R = ($k[--$j] + _5P) % 2401; /*11618*/
			$k[$j++] = ~~(_5R / 49); /*11618*/
			$k[$j++] = _5R % 49; /*11618*/
			$astore($a(2)); /*11618*/
			$puti($1.lastrow, 0, $k[--$j]); /*11619*/
		} /*11619*/
		$1.wr1 = ($get($1.lastrow, 0) * 49) + $get($1.lastrow, 1); /*11621*/
		$k[$j++] = $1.cr7 * $get($1.weighty, 0); /*11624*/
		$k[$j++] = $1.weighty; /*11624*/
		$1.calccheck(); /*11624*/
		var _5d = $k[--$j]; /*11624*/
		var _5j = (($k[--$j] + _5d) + ($1.wr1 * $get($1.weighty, ($1.r * 4) - 3))) % 2401; /*11626*/
		$1.wr2 = _5j; /*11626*/
		$k[$j++] = ~~(_5j / 49); /*11627*/
		$k[$j++] = _5j % 49; /*11627*/
		$astore($a(2)); /*11627*/
		$puti($1.lastrow, 2, $k[--$j]); /*11628*/
		$k[$j++] = $1.cr7 * $get($1.weightx, 0); /*11631*/
		$k[$j++] = $1.weightx; /*11631*/
		$1.calccheck(); /*11631*/
		var _5r = $k[--$j]; /*11631*/
		var _61 = ((($k[--$j] + _5r) + ($1.wr1 * $get($1.weightx, ($1.r * 4) - 3))) + ($1.wr2 * $get($1.weightx, ($1.r * 4) - 2))) % 2401; /*11635*/
		$k[$j++] = ~~(_61 / 49); /*11635*/
		$k[$j++] = _61 % 49; /*11635*/
		$astore($a(2)); /*11635*/
		$puti($1.lastrow, 4, $k[--$j]); /*11636*/
		$k[$j++] = 0; /*11639*/
		$forall($geti($1.ccs, $1.ccs.length - 8, 7), function() { /*11639*/
			var _68 = $k[--$j]; /*11639*/
			var _69 = $k[--$j]; /*11639*/
			$k[$j++] = _69 + _68; /*11639*/
		}) /*11639*/
		$put($1.ccs, $1.ccs.length - 1, $k[--$j] % 49); /*11640*/
		$1.patterns = $a([$a(["11521132", "25112131", "14212132", "25121221", "14221222", "12412132", "23321221", "12421222", "21521221", "15112222", "15121312", "13312222", "24221311", "13321312", "11512222", "22421311", "11521312", "25112311", "14212312", "23312311", "12412312", "21512311", "16121131", "14321131", "12521131", "15212131", "15221221", "13412131", "13421221", "11612131", "16112221", "16121311", "14312221", "14321311", "12512221", "12521311", "15212311", "13412311", "11612311", "11131135", "31131133", "51131131", "21122134", "41122132", "21131224", "41131222", "11113135", "31113133", "51113131", "11122225", "31122223", "51122221", "11131315", "31131313", "51131311", "21113224", "41113222", "21122314", "41122312", "11113315", "31113313", "51113311", "12131134", "32131132", "21231133", "41231131", "22122133", "42122131", "11222134", "22131223", "42131221", "11231224", "31231222", "12113134", "32113132", "12122224", "32122222", "12131314", "32131312", "21231313", "41231311", "22113223", "42113221", "11213224", "22122313", "42122311", "11222314", "31222312", "12113314", "32113312", "21213313", "41213311", "13131133", "33131131", "22231132", "11331133", "31331131", "23122132", "12222133", "23131222", "12231223", "32231221", "21331222", "13113133", "33113131", "13122223", "33122221", "11313133", "13131313", "33131311", "11322223", "22231312", "11331313", "31331311", "23113222", "12213223", "23122312", "12222313", "32222311", "21322312", "13113313", "33113311", "22213312", "11313313", "31313311", "14131132", "23231131", "12331132", "21431131", "24122131", "13222132", "24131221", "13231222", "11422132", "22331221", "11431222", "14113132", "14122222", "12313132", "14131312", "12322222", "23231311", "12331312", "21431311", "24113221", "13213222", "24122311", "13222312", "11413222", "22322311", "11422312", "14113312", "23213311", "12313312", "21413311", "15131131", "13331131", "14222131", "14231221", "12422131", "12431221", "15113131", "15122221", "13313131", "15131311", "13322221", "11513131", "13331311", "11522221", "14213221", "14222311", "12413221", "12422311", "15113311", "13313311", "11513311", "11141134", "31141132", "21132133", "41132131", "21141223", "41141221", "11123134", "31123132", "11132224", "31132222", "11141314", "31141312", "21114133", "41114131", "21123223", "41123221", "21132313", "41132311", "11114224", "31114222", "11123314", "31123312", "21114313", "41114311", "12141133", "32141131", "21241132", "22132132", "11232133", "22141222", "11241223", "31241221", "12123133", "32123131", "12132223", "32132221", "12141313", "32141311", "21241312", "22114132", "11214133", "22123222", "11223223", "22132312", "11232313", "31232311", "12114223", "32114221", "12123313", "32123311", "21223312", "22114312", "11214313", "31214311", "13141132", "22241131", "11341132", "23132131", "12232132", "23141221", "12241222", "21341221", "13123132", "13132222", "11323132", "13141312", "11332222", "22241311", "11341312", "23114131", "12214132", "23123221", "12223222", "23132311", "12232312", "21332311", "13114222", "13123312", "11314222", "22223311", "11323312", "23114311", "12214312", "21314311", "14141131", "12341131", "13232131", "13241221", "11432131", "14123131", "14132221", "12323131", "14141311", "12332221", "12341311", "13214131", "13223221", "11414131", "13232311", "11423221", "11432311", "14114221", "14123311", "12314221", "12323311", "13214311", "11414311", "11151133", "31151131", "21142132", "21151222", "11133133", "31133131", "11142223", "31142221", "11151313", "31151311", "21124132", "21133222", "21142312", "11115133", "31115131", "11124223", "31124221", "11133313", "31133311", "21115222", "21124312", "12151132", "21251131", "22142131", "11242132", "22151221", "11251222", "12133132", "12142222", "12151312", "21251311", "22124131", "11224132", "22133221", "11233222", "22142311", "11242312", "12115132", "12124222", "12133312", "21233311", "22115221", "11215222", "22124311", "11224312", "13151131", "12242131", "12251221", "13133131", "13142221", "11333131", "13151311", "11342221", "12224131", "12233221", "12242311", "13115131", "13124221", "11315131", "13133311", "11324221", "11333311", "12215221", "12224311", "11161132", "21152131", "21161221", "11143132", "11152222", "11161312", "21134131", "21143221", "21152311", "11125132", "11134222", "11143312", "21116131", "21125221", "21134311", "12161131", "11252131", "12143131", "12152221", "12161311", "11234131", "11243221", "11252311", "12125131", "12134221", "12143311", "11216131", "11225221", "11234311", "11111236", "31111234", "51111232", "21111325", "41111323", "61111321", "11111416", "31111414", "51111412", "31211143", "51211141", "12111235", "32111233", "52111231", "21211234", "41211232", "22111324", "42111322", "11211325", "31211323", "51211321", "12111415", "32111413", "52111411", "21211414", "41211412", "12211144", "32211142", "21311143", "41311141", "13111234", "33111232", "22211233", "42211231", "11311234", "31311232", "23111323", "43111321", "12211324", "32211322", "21311323", "41311321", "13111414", "33111412", "22211413", "42211411", "11311414", "31311412", "13211143", "33211141", "22311142", "11411143", "31411141", "14111233", "34111231", "23211232", "12311233", "32311231", "21411232", "24111322", "13211323", "33211321", "22311322", "11411323", "31411321", "14111413", "34111411", "23211412", "12311413", "32311411", "21411412", "14211142", "23311141", "12411142", "21511141", "15111232", "24211231", "13311232", "22411231", "11511232", "25111321", "14211322", "23311321", "12411322", "21511321", "15111412", "24211411", "13311412", "22411411", "11511412", "15211141", "13411141", "11611141", "16111231", "14311231", "12511231", "15211321", "13411321", "11611321", "16111411", "14311411", "12511411", "21121144", "41121142", "11112145", "31112143", "51112141", "11121235", "31121233", "51121231", "21112234", "41112232", "21121324", "41121322", "11112325", "31112323", "51112321", "11121415", "31121413", "51121411", "21112414", "41112412", "22121143", "42121141", "11221144", "31221142", "12112144", "32112142", "12121234", "32121232", "21221233", "41221231", "22112233", "42112231", "11212234", "22121323", "42121321", "11221324", "31221322", "12112324", "32112322", "12121414", "32121412", "21221413", "41221411", "22112413", "42112411", "11212414", "31212412", "23121142", "12221143", "32221141", "21321142", "13112143", "33112141", "13121233", "33121231", "11312143", "22221232", "11321233", "31321231", "23112232", "12212233", "23121322", "12221323", "32221321", "21321322", "13112323", "33112321", "13121413", "33121411", "11312323", "22221412", "11321413", "31321411", "23112412", "12212413", "32212411", "21312412", "24121141", "13221142", "22321141", "11421142", "14112142", "14121232", "12312142", "23221231", "12321232", "21421231", "24112231", "13212232", "24121321", "13221322", "11412232", "22321321", "11421322", "14112322", "14121412", "12312322", "23221411", "12321412", "21421411", "24112411", "13212412", "22312411", "11412412", "14221141", "12421141", "15112141", "15121231", "13312141", "13321231", "11512141", "11521231", "14212231", "14221321", "12412231", "12421321", "15112321", "15121411", "13312321", "13321411", "11512321", "11521411", "14212411", "12412411", "21131143", "41131141", "11122144", "31122142", "11131234", "31131232", "21113143", "41113141", "21122233", "41122231", "21131323", "41131321", "11113234", "31113232", "11122324", "31122322", "11131414", "31131412", "21113323", "41113321", "21122413", "41122411", "11113414", "31113412", "22131142", "11231143", "31231141", "12122143", "32122141", "12131233", "32131231", "21231232", "22113142", "11213143", "22122232", "11222233", "22131322", "11231323", "31231321", "12113233", "32113231", "12122323", "32122321", "12131413", "32131411", "21231412", "22113322", "11213323", "22122412", "11222413", "31222411", "12113413", "32113411", "21213412", "23131141", "12231142", "21331141", "13122142", "13131232", "11322142", "22231231", "11331232", "23113141", "12213142", "23122231", "12222232", "23131321", "12231322", "21331321", "13113232", "13122322", "11313232", "13131412", "11322322", "22231411", "11331412", "23113321", "12213322", "23122411", "12222412", "21322411", "13113412", "22213411", "11313412", "13231141", "11431141", "14122141", "14131231", "12322141", "12331231", "13213141", "13222231", "11413141", "13231321", "11422231", "11431321", "14113231", "14122321", "12313231", "14131411", "12322321", "12331411", "13213321", "13222411", "11413321", "11422411", "14113411", "12313411", "21141142", "11132143", "31132141", "11141233", "31141231", "21123142", "21132232", "21141322", "11114143", "31114141", "11123233", "31123231", "11132323", "31132321", "11141413", "31141411", "21114232", "21123322", "21132412", "11114323", "31114321", "11123413", "31123411", "22141141", "11241142", "12132142", "12141232", "21241231", "22123141", "11223142", "22132231", "11232232", "22141321", "11241322", "12114142", "12123232", "12132322", "12141412", "21241411", "22114231", "11214232", "22123321", "11223322", "22132411", "11232412", "12114322", "12123412", "21223411", "12241141", "13132141", "13141231", "11332141", "11341231", "12223141", "12232231", "12241321", "13114141", "13123231", "11314141", "13132321", "11323231", "13141411", "11332321", "11341411", "12214231", "12223321", "12232411", "13114321", "13123411", "11314321", "11323411", "21151141", "11142142", "11151232", "21133141", "21142231", "21151321", "11124142", "11133232", "11142322", "11151412", "21115141", "21124231", "21133321", "21142411", "11115232", "11124322", "11133412", "11251141", "12142141", "12151231", "11233141", "11242231", "11251321", "12124141", "12133231", "12142321", "12151411", "11215141", "11224231", "11233321", "11242411", "12115231", "12124321", "12133411", "11152141", "11161231", "11134141", "11143231", "11152321", "11161411", "11116141", "11125231", "11134321", "11143411", "21111244", "41111242", "11111335", "31111333", "51111331", "21111424", "41111422", "11111515", "31111513", "51111511", "21211153", "41211151", "22111243", "42111241", "11211244", "31211242", "12111334", "32111332", "21211333", "41211331", "22111423", "42111421", "11211424", "31211422", "12111514", "32111512", "21211513", "41211511", "22211152", "11311153", "31311151", "23111242", "12211243", "32211241", "21311242", "13111333", "33111331", "22211332", "11311333", "31311331", "23111422", "12211423", "32211421", "21311422", "13111513", "33111511", "22211512", "11311513", "31311511", "23211151", "12311152", "21411151", "24111241", "13211242", "22311241", "11411242", "14111332", "23211331", "12311332", "21411331", "24111421", "13211422", "22311421", "11411422", "14111512", "23211511", "12311512", "21411511", "13311151", "11511151", "14211241", "12411241", "15111331", "13311331", "11511331", "14211421", "12411421", "15111511", "13311511", "11511511", "31121152", "21112153", "41112151", "21121243", "41121241", "11112244", "31112242", "11121334", "31121332", "21112333", "41112331", "21121423", "41121421", "11112424", "31112422", "11121514", "31121512", "21112513", "41112511", "12121153", "32121151", "21221152", "22112152", "11212153", "22121242", "11221243", "31221241", "12112243", "32112241", "12121333", "32121331", "21221332", "22112332", "11212333", "22121422", "11221423", "31221421", "12112423", "32112421", "12121513", "32121511", "21221512", "22112512", "11212513", "31212511", "13121152", "22221151", "11321152", "23112151", "12212152", "23121241", "12221242", "21321241", "13112242", "13121332", "11312242", "22221331", "11321332", "23112331", "12212332", "23121421", "12221422", "21321421", "13112422", "13121512", "11312422", "22221511", "11321512", "23112511", "12212512", "21312511", "14121151", "12321151", "13212151", "13221241", "11412151", "11421241", "14112241", "14121331", "12312241", "12321331", "13212331", "13221421", "11412331", "11421421", "14112421", "14121511", "12312421", "12321511", "13212511", "11412511", "11131153", "31131151", "21122152", "21131242", "11113153", "31113151", "11122243", "31122241", "11131333", "31131331", "21113242", "21122332", "21131422", "11113333", "31113331", "11122423", "31122421", "11131513", "31131511", "21113422", "21122512", "12131152", "21231151", "22122151", "11222152", "22131241", "11231242", "12113152", "12122242", "12131332", "21231331", "22113241", "11213242", "22122331", "11222332", "22131421", "11231422", "12113332", "12122422", "12131512", "21231511", "22113421", "11213422", "22122511", "11222512", "13131151", "11331151", "12222151", "12231241", "13113151", "13122241", "11313151", "13131331", "11322241", "11331331", "12213241", "12222331", "12231421", "13113331", "13122421", "11313331", "13131511", "11322421", "11331511", "12213421", "12222511", "11141152", "21132151", "21141241", "11123152", "11132242", "11141332", "21114151", "21123241", "21132331", "21141421", "11114242", "11123332", "11132422", "11141512", "21114331", "21123421", "21132511", "12141151", "11232151", "11241241", "12123151", "12132241", "12141331", "11214151", "11223241", "11232331", "11241421", "12114241", "12123331", "12132421", "12141511", "11214331", "11223421", "11232511", "11151151", "11133151", "11142241", "11151331", "11115151", "11124241", "11133331", "11142421", "11151511", "11111254", "31111252", "21111343", "41111341", "11111434", "31111432", "21111523", "41111521", "11111614", "31111612", "31211161", "12111253", "32111251", "21211252", "22111342", "11211343", "31211341", "12111433", "32111431", "21211432", "22111522", "11211523", "31211521", "12111613", "32111611", "21211612", "12211162", "21311161", "13111252", "22211251", "11311252", "23111341", "12211342", "21311341", "13111432", "22211431", "11311432", "23111521", "12211522", "21311521", "13111612", "22211611", "11311612", "13211161", "11411161", "14111251", "12311251", "13211341", "11411341", "14111431", "12311431", "13211521", "11411521", "14111611", "12311611", "21121162", "11112163", "31112161", "11121253", "31121251", "21112252", "21121342", "11112343", "31112341", "11121433", "31121431", "21112432", "21121522", "11112523", "31112521", "11121613", "31121611", "22121161", "11221162", "12112162", "12121252", "21221251", "22112251", "11212252", "22121341", "11221342", "12112342", "12121432", "21221431", "22112431", "11212432", "22121521", "11221522", "12112522", "12121612", "21221611", "12221161", "13112161", "13121251", "11312161", "11321251", "32121115", "52121113", "21221116", "41221114", "61221112", "22112116", "42112114", "31212115", "51212113", "13121116", "33121114", "22221115", "42221113", "11321116", "31321114", "51321112", "23112115", "43112113", "12212116", "32212114", "52212112", "21312115", "41312113", "61312111", "14121115", "34121113", "23221114", "43221112", "12321115", "32321113", "52321111", "21421114", "41421112", "24112114", "13212115", "33212113", "22312114", "42312112", "11412115", "31412113", "51412111", "15121114", "24221113", "13321114", "33321112", "22421113", "42421111", "11521114", "31521112", "25112113", "14212114", "34212112", "23312113", "43312111", "12412114", "32412112", "21512113", "41512111", "16121113", "25221112", "14321113", "34321111", "23421112", "12521113", "32521111", "15212113", "24312112", "13412113", "33412111", "22512112", "11612113", "31612111", "31131115", "51131113", "21122116", "41122114", "61122112", "31113115", "51113113", "12131116", "32131114", "52131112", "21231115", "41231113", "61231111", "22122115", "42122113", "11222116", "31222114", "51222112", "12113116", "32113114", "52113112", "21213115", "41213113", "61213111", "13131115", "33131113", "22231114", "42231112", "11331115", "31331113", "51331111", "23122114", "43122112", "12222115", "32222113", "52222111", "21322114", "41322112", "13113115", "33113113", "22213114", "42213112", "11313115", "31313113", "51313111", "14131114", "34131112", "23231113", "43231111", "12331114", "32331112", "21431113", "41431111", "24122113", "13222114", "33222112", "22322113", "42322111", "11422114", "31422112", "14113114", "34113112", "23213113", "43213111", "12313114", "32313112", "21413113", "41413111", "15131113", "24231112", "13331113", "33331111", "22431112", "25122112", "14222113", "34222111", "23322112", "12422113", "32422111", "21522112", "15113113", "24213112", "13313113", "33313111", "22413112", "11513113", "31513111", "16131112", "25231111", "14331112", "23431111", "15222112", "24322111", "13422112", "22522111", "16113112", "25213111", "14313112", "23413111", "12513112", "21613111", "11141116", "31141114", "51141112", "21132115", "41132113", "61132111", "11123116", "31123114", "51123112", "21114115", "41114113", "61114111", "12141115", "32141113", "52141111", "21241114", "41241112", "22132114", "42132112", "11232115", "31232113", "51232111", "12123115", "32123113", "52123111", "21223114", "41223112", "22114114", "42114112", "11214115", "31214113", "51214111", "13141114", "33141112", "22241113", "42241111", "11341114", "31341112", "23132113", "43132111", "12232114", "32232112", "21332113", "41332111", "13123114", "33123112", "22223113", "42223111", "11323114", "31323112", "23114113", "43114111", "12214114", "32214112", "21314113", "41314111", "14141113", "34141111", "23241112", "12341113", "32341111", "24132112", "13232113", "33232111", "22332112", "11432113", "31432111", "14123113", "34123111", "23223112", "12323113", "32323111", "21423112", "24114112", "13214113", "33214111", "22314112", "11414113", "31414111", "15141112", "24241111", "13341112", "25132111", "14232112", "23332111", "12432112", "15123112", "24223111", "13323112", "22423111", "11523112", "25114111", "14214112", "23314111", "12414112", "21514111", "16141111", "14341111", "15232111", "13432111", "16123111", "14323111", "12523111", "15214111", "13414111", "11614111", "11151115", "31151113", "51151111", "21142114", "41142112", "11133115", "31133113", "51133111", "21124114", "41124112", "11115115", "31115113", "51115111", "12151114", "32151112", "21251113", "41251111", "22142113", "42142111", "11242114", "31242112", "12133114", "32133112", "21233113", "41233111", "22124113", "42124111", "11224114", "31224112", "12115114", "32115112", "21215113", "41215111", "13151113", "33151111", "22251112", "23142112", "12242113", "32242111", "21342112", "13133113", "33133111", "22233112", "11333113", "31333111", "23124112", "12224113", "32224111", "21324112", "13115113", "33115111", "22215112", "11315113", "31315111", "14151112", "23251111", "24142111", "13242112", "22342111", "14133112", "23233111", "12333112", "21433111", "24124111", "13224112", "22324111", "11424112", "14115112", "23215111", "12315112", "21415111", "15151111", "14242111", "15133111", "13333111", "14224111", "12424111", "15115111", "13315111", "11515111", "11161114", "31161112", "21152113", "41152111", "11143114", "31143112", "21134113", "41134111", "11125114", "31125112", "21116113", "41116111", "12161113", "32161111", "22152112", "11252113", "31252111", "12143113", "32143111", "21243112", "22134112", "11234113", "31234111", "12125113", "32125111", "21225112", "22116112", "11216113", "31216111", "13161112", "23152111", "12252112", "13143112", "22243111", "11343112", "23134111", "12234112", "21334111", "13125112", "22225111", "11325112", "23116111", "12216112", "21316111", "14161111", "13252111", "14143111", "12343111", "13234111", "11434111", "14125111", "12325111", "13216111", "11416111", "31111216", "51111214", "31211125", "51211123", "32111215", "52111213", "21211216", "41211214", "61211212", "12211126", "32211124", "52211122", "21311125", "41311123", "61311121", "13111216", "33111214", "22211215", "42211213", "11311216", "31311214", "51311212", "13211125", "33211123", "22311124", "42311122", "11411125", "31411123", "51411121", "14111215", "34111213", "23211214", "43211212", "12311215", "32311213", "52311211", "21411214", "41411212", "14211124", "34211122", "23311123", "43311121", "12411124", "32411122", "21511123", "41511121", "15111214", "24211213", "13311214", "33311212", "22411213", "42411211", "11511214", "31511212", "15211123", "24311122", "13411123", "33411121", "22511122", "11611123", "31611121", "16111213", "25211212", "14311213", "34311211", "23411212", "12511213", "32511211", "21611212", "21121126", "41121124", "61121122", "31112125", "51112123", "31121215", "51121213", "21112216", "41112214", "61112212", "22121125", "42121123", "11221126", "31221124", "51221122", "12112126", "32112124", "52112122", "12121216", "32121214", "52121212", "21221215", "41221213", "61221211", "22112215", "42112213", "11212216", "31212214", "51212212", "23121124", "43121122", "12221125", "32221123", "52221121", "21321124", "41321122", "13112125", "33112123", "13121215", "33121213", "11312125", "22221214", "42221212", "11321215", "31321213", "51321211", "23112214", "43112212", "12212215", "32212213", "52212211", "21312214", "41312212", "24121123", "13221124", "33221122", "22321123", "42321121", "11421124", "31421122", "14112124", "34112122", "14121214", "34121212", "12312124", "23221213", "43221211", "12321214", "32321212", "21421213", "41421211", "24112213", "13212214", "33212212", "22312213", "42312211", "11412214", "31412212", "25121122", "14221123", "34221121", "23321122", "12421123", "32421121", "21521122", "15112123", "15121213", "13312123", "24221212", "13321213", "33321211", "11512123", "22421212", "11521213", "31521211", "25112212", "14212213", "34212211", "23312212", "12412213", "32412211", "21512212", "15221122", "24321121", "13421122", "22521121", "16112122", "16121212", "14312122", "25221211", "14321212", "12512122", "23421211", "12521212", "15212212", "24312211", "13412212", "22512211", "11612212", "21131125", "41131123", "61131121", "11122126", "31122124", "51122122", "11131216", "31131214", "51131212", "21113125", "41113123", "61113121", "21122215", "41122213", "61122211", "11113216", "31113214", "51113212", "22131124", "42131122", "11231125", "31231123", "51231121", "12122125", "32122123", "52122121", "12131215", "32131213", "52131211", "21231214", "41231212", "22113124", "42113122", "11213125", "22122214", "42122212", "11222215", "31222213", "51222211", "12113215", "32113213", "52113211", "21213214", "41213212", "23131123", "43131121", "12231124", "32231122", "21331123", "41331121", "13122124", "33122122", "13131214", "33131212", "11322124", "22231213", "42231211", "11331214", "31331212", "23113123", "43113121", "12213124", "23122213", "43122211", "12222214", "32222212", "21322213", "41322211", "13113214", "33113212", "22213213", "42213211", "11313214", "31313212", "24131122", "13231123", "33231121", "22331122", "11431123", "31431121", "14122123", "34122121", "14131213", "34131211", "12322123", "23231212", "12331213", "32331211", "21431212", "24113122", "13213123", "24122212", "13222213", "33222211", "11413123", "22322212", "11422213", "31422211", "14113213", "34113211", "23213212", "12313213", "32313211", "21413212", "25131121", "14231122", "23331121", "12431122", "15122122", "15131212", "13322122", "24231211", "13331212", "11522122", "22431211", "25113121", "14213122", "25122211", "14222212", "12413122", "23322211", "12422212", "21522211", "15113212", "24213211", "13313212", "22413211", "11513212", "15231121", "13431121", "16122121", "16131211", "14322121", "14331211", "12522121", "15213121", "15222211", "13413121", "13422211", "11613121", "16113211", "14313211", "12513211", "21141124", "41141122", "11132125", "31132123", "51132121", "11141215", "31141213", "51141211", "21123124", "41123122", "21132214", "41132212", "11114125", "31114123", "51114121", "11123215", "31123213", "51123211", "21114214", "41114212", "22141123", "42141121", "11241124", "31241122", "12132124", "32132122", "12141214", "32141212", "21241213", "41241211", "22123123", "42123121", "11223124", "22132213", "42132211", "11232214", "31232212", "12114124", "32114122", "12123214", "32123212", "21223213", "41223211", "22114213", "42114211", "11214214", "31214212", "23141122", "12241123", "32241121", "21341122", "13132123", "33132121", "13141213", "33141211", "11332123", "22241212", "11341213", "31341211", "23123122", "12223123", "23132212", "12232213", "32232211", "21332212", "13114123", "33114121", "13123213", "33123211", "11314123", "22223212", "11323213", "31323211", "23114212", "12214213", "32214211", "21314212", "24141121", "13241122", "22341121", "14132122", "14141212", "12332122", "23241211", "12341212", "24123121", "13223122", "24132211", "13232212", "11423122", "22332211", "11432212", "14114122", "14123212", "12314122", "23223211", "12323212", "21423211", "24114211", "13214212", "22314211", "11414212", "14241121", "15132121", "15141211", "13332121", "13341211", "14223121", "14232211", "12423121", "12432211", "15114121", "15123211", "13314121", "13323211", "11514121", "11523211", "14214211", "12414211", "21151123", "41151121", "11142124", "31142122", "11151214", "31151212", "21133123", "41133121", "21142213", "41142211", "11124124", "31124122", "11133214", "31133212", "21115123", "41115121", "21124213", "41124211", "11115214", "31115212", "22151122", "11251123", "31251121", "12142123", "32142121", "12151213", "32151211", "21251212", "22133122", "11233123", "22142212", "11242213", "31242211", "12124123", "32124121", "12133213", "32133211", "21233212", "22115122", "11215123", "22124212", "11224213", "31224211", "12115213", "32115211", "21215212", "23151121", "12251122", "13142122", "13151212", "11342122", "22251211", "23133121", "12233122", "23142211", "12242212", "21342211", "13124122", "13133212", "11324122", "22233211", "11333212", "23115121", "12215122", "23124211", "12224212", "21324211", "13115212", "22215211", "11315212", "13251121", "14142121", "14151211", "12342121", "13233121", "13242211", "11433121", "14124121", "14133211", "12324121", "12333211", "13215121", "13224211", "11415121", "11424211", "14115211", "12315211", "21161122", "11152123", "31152121", "11161213", "31161211", "21143122", "21152212", "11134123", "31134121", "11143213", "31143211", "21125122", "21134212", "11116123", "31116121", "11125213", "31125211", "22161121", "12152122", "12161212", "22143121", "11243122", "22152211", "11252212", "12134122", "12143212", "21243211", "22125121", "11225122", "22134211", "11234212", "12116122", "12125212", "21225211", "13152121", "13161211", "12243121", "12252211", "13134121", "13143211", "11334121", "11343211", "12225121", "12234211", "13116121", "13125211", "11316121", "11325211", "21111226", "41111224", "61111222", "31111315", "51111313", "21211135", "41211133", "61211131", "22111225", "42111223", "11211226", "31211224", "51211222", "12111316", "32111314", "52111312", "21211315", "41211313", "61211311", "22211134", "42211132", "11311135", "31311133", "51311131", "23111224", "43111222", "12211225", "32211223", "52211221", "21311224", "41311222", "13111315", "33111313", "22211314", "42211312", "11311315", "31311313", "51311311", "23211133", "43211131", "12311134", "32311132", "21411133", "41411131", "24111223", "13211224", "33211222", "22311223", "42311221", "11411224", "31411222", "14111314", "34111312", "23211313", "43211311", "12311314", "32311312", "21411313", "41411311", "24211132", "13311133", "33311131", "22411132", "11511133", "31511131", "25111222", "14211223", "34211221", "23311222", "12411223", "32411221", "21511222", "15111313", "24211312", "13311313", "33311311", "22411312", "11511313", "31511311", "25211131", "14311132", "23411131", "12511132", "21611131", "15211222", "24311221", "13411222", "22511221", "11611222", "16111312", "25211311", "14311312", "23411311", "12511312", "21611311", "31121134", "51121132", "21112135", "41112133", "61112131", "21121225", "41121223", "61121221", "11112226", "31112224", "51112222", "11121316", "31121314", "51121312", "21112315", "41112313", "61112311", "12121135", "32121133", "52121131", "21221134", "41221132", "22112134", "42112132", "11212135", "22121224", "42121222", "11221225", "31221223", "51221221", "12112225", "32112223", "52112221", "12121315", "32121313", "52121311", "21221314", "41221312", "22112314", "42112312", "11212315", "31212313", "51212311", "13121134", "33121132", "22221133", "42221131", "11321134", "31321132", "23112133", "43112131", "12212134", "23121223", "43121221", "12221224", "32221222", "21321223", "41321221", "13112224", "33112222", "13121314", "33121312", "11312224", "22221313", "42221311", "11321314", "31321312", "23112313", "43112311", "12212314", "32212312", "21312313", "41312311", "14121133", "34121131", "23221132", "12321133", "32321131", "21421132", "24112132", "13212133", "24121222", "13221223", "33221221", "11412133", "22321222", "11421223", "31421221", "14112223", "34112221", "14121313", "34121311", "12312223", "23221312", "12321313", "32321311", "21421312", "24112312", "13212313", "33212311", "22312312", "11412313", "31412311", "15121132", "24221131", "13321132", "22421131"]), $a(["22121116", "42121114", "31221115", "51221113", "32112115", "52112113", "21212116", "41212114", "61212112", "23121115", "43121113", "12221116", "32221114", "52221112", "21321115", "41321113", "61321111", "13112116", "33112114", "22212115", "42212113", "11312116", "31312114", "51312112", "24121114", "13221115", "33221113", "22321114", "42321112", "11421115", "31421113", "51421111", "14112115", "34112113", "23212114", "43212112", "12312115", "32312113", "52312111", "21412114", "41412112", "25121113", "14221114", "34221112", "23321113", "43321111", "12421114", "32421112", "21521113", "41521111", "15112114", "24212113", "13312114", "33312112", "22412113", "42412111", "11512114", "31512112", "15221113", "24321112", "13421113", "33421111", "22521112", "16112113", "25212112", "14312113", "34312111", "23412112", "12512113", "32512111", "21612112", "21131116", "41131114", "61131112", "31122115", "51122113", "21113116", "41113114", "61113112", "22131115", "42131113", "11231116", "31231114", "51231112", "12122116", "32122114", "52122112", "21222115", "41222113", "61222111", "22113115", "42113113", "11213116", "31213114", "51213112", "23131114", "43131112", "12231115", "32231113", "52231111", "21331114", "41331112", "13122115", "33122113", "22222114", "42222112", "11322115", "31322113", "51322111", "23113114", "43113112", "12213115", "32213113", "52213111", "21313114", "41313112", "24131113", "13231114", "33231112", "22331113", "42331111", "11431114", "31431112", "14122114", "34122112", "23222113", "43222111", "12322114", "32322112", "21422113", "41422111", "24113113", "13213114", "33213112", "22313113", "42313111", "11413114", "31413112", "25131112", "14231113", "34231111", "23331112", "12431113", "32431111", "15122113", "24222112", "13322113", "33322111", "22422112", "11522113", "31522111", "25113112", "14213113", "34213111", "23313112", "12413113", "32413111", "21513112", "15231112", "24331111", "13431112", "16122112", "25222111", "14322112", "23422111", "12522112", "15213112", "24313111", "13413112", "22513111", "11613112", "21141115", "41141113", "61141111", "11132116", "31132114", "51132112", "21123115", "41123113", "61123111", "11114116", "31114114", "51114112", "22141114", "42141112", "11241115", "31241113", "51241111", "12132115", "32132113", "52132111", "21232114", "41232112", "22123114", "42123112", "11223115", "31223113", "51223111", "12114115", "32114113", "52114111", "21214114", "41214112", "23141113", "43141111", "12241114", "32241112", "21341113", "41341111", "13132114", "33132112", "22232113", "42232111", "11332114", "31332112", "23123113", "43123111", "12223114", "32223112", "21323113", "41323111", "13114114", "33114112", "22214113", "42214111", "11314114", "31314112", "24141112", "13241113", "33241111", "22341112", "14132113", "34132111", "23232112", "12332113", "32332111", "21432112", "24123112", "13223113", "33223111", "22323112", "11423113", "31423111", "14114113", "34114111", "23214112", "12314113", "32314111", "21414112", "25141111", "14241112", "23341111", "15132112", "24232111", "13332112", "22432111", "25123111", "14223112", "23323111", "12423112", "21523111", "15114112", "24214111", "13314112", "22414111", "11514112", "15241111", "16132111", "14332111", "15223111", "13423111", "16114111", "14314111", "12514111", "21151114", "41151112", "11142115", "31142113", "51142111", "21133114", "41133112", "11124115", "31124113", "51124111", "21115114", "41115112", "22151113", "42151111", "11251114", "31251112", "12142114", "32142112", "21242113", "41242111", "22133113", "42133111", "11233114", "31233112", "12124114", "32124112", "21224113", "41224111", "22115113", "42115111", "11215114", "31215112", "23151112", "12251113", "32251111", "13142113", "33142111", "22242112", "11342113", "31342111", "23133112", "12233113", "32233111", "21333112", "13124113", "33124111", "22224112", "11324113", "31324111", "23115112", "12215113", "32215111", "21315112", "24151111", "13251112", "14142112", "23242111", "12342112", "24133111", "13233112", "22333111", "11433112", "14124112", "23224111", "12324112", "21424111", "24115111", "13215112", "22315111", "11415112", "14251111", "15142111", "13342111", "14233111", "12433111", "15124111", "13324111", "11524111", "14215111", "12415111", "21161113", "41161111", "11152114", "31152112", "21143113", "41143111", "11134114", "31134112", "21125113", "41125111", "11116114", "31116112", "22161112", "12152113", "32152111", "21252112", "22143112", "11243113", "31243111", "12134113", "32134111", "21234112", "22125112", "11225113", "31225111", "12116113", "32116111", "21216112", "23161111", "13152112", "22252111", "23143111", "12243112", "21343111", "13134112", "22234111", "11334112", "23125111", "12225112", "21325111", "13116112", "22216111", "11316112", "14152111", "13243111", "14134111", "12334111", "13225111", "11425111", "14116111", "12316111", "41111215", "61111213", "21211126", "41211124", "61211122", "22111216", "42111214", "31211215", "51211213", "22211125", "42211123", "11311126", "31311124", "51311122", "23111215", "43111213", "12211216", "32211214", "52211212", "21311215", "41311213", "61311211", "23211124", "43211122", "12311125", "32311123", "52311121", "21411124", "41411122", "24111214", "13211215", "33211213", "22311214", "42311212", "11411215", "31411213", "51411211", "24211123", "13311124", "33311122", "22411123", "42411121", "11511124", "31511122", "25111213", "14211214", "34211212", "23311213", "43311211", "12411214", "32411212", "21511213", "41511211", "25211122", "14311123", "34311121", "23411122", "12511123", "32511121", "21611122", "15211213", "24311212", "13411213", "33411211", "22511212", "11611213", "31611211", "31121125", "51121123", "21112126", "41112124", "61112122", "21121216", "41121214", "61121212", "31112215", "51112213", "12121126", "32121124", "52121122", "21221125", "41221123", "61221121", "22112125", "42112123", "11212126", "22121215", "42121213", "11221216", "31221214", "51221212", "12112216", "32112214", "52112212", "21212215", "41212213", "61212211", "13121125", "33121123", "22221124", "42221122", "11321125", "31321123", "51321121", "23112124", "43112122", "12212125", "23121214", "43121212", "12221215", "32221213", "52221211", "21321214", "41321212", "13112215", "33112213", "22212214", "42212212", "11312215", "31312213", "51312211", "14121124", "34121122", "23221123", "43221121", "12321124", "32321122", "21421123", "41421121", "24112123", "13212124", "24121213", "13221214", "33221212", "11412124", "22321213", "42321211", "11421214", "31421212", "14112214", "34112212", "23212213", "43212211", "12312214", "32312212", "21412213", "41412211", "15121123", "24221122", "13321123", "33321121", "22421122", "11521123", "31521121", "25112122", "14212123", "25121212", "14221213", "34221211", "12412123", "23321212", "12421213", "32421211", "21521212", "15112213", "24212212", "13312213", "33312211", "22412212", "11512213", "31512211", "16121122", "25221121", "14321122", "23421121", "12521122", "15212122", "15221212", "13412122", "24321211", "13421212", "11612122", "22521211", "16112212", "25212211", "14312212", "23412211", "12512212", "21612211", "11131126", "31131124", "51131122", "21122125", "41122123", "61122121", "21131215", "41131213", "61131211", "11113126", "31113124", "51113122", "11122216", "31122214", "51122212", "21113215", "41113213", "61113211", "12131125", "32131123", "52131121", "21231124", "41231122", "22122124", "42122122", "11222125", "22131214", "42131212", "11231215", "31231213", "51231211", "12113125", "32113123", "52113121", "12122215", "32122213", "52122211", "21222214", "41222212", "22113214", "42113212", "11213215", "31213213", "51213211", "13131124", "33131122", "22231123", "42231121", "11331124", "31331122", "23122123", "43122121", "12222124", "23131213", "43131211", "12231214", "32231212", "21331213", "41331211", "13113124", "33113122", "13122214", "33122212", "11313124", "22222213", "42222211", "11322214", "31322212", "23113213", "43113211", "12213214", "32213212", "21313213", "41313211", "14131123", "34131121", "23231122", "12331123", "32331121", "21431122", "24122122", "13222123", "24131212", "13231213", "33231211", "11422123", "22331212", "11431213", "31431211", "14113123", "34113121", "14122213", "34122211", "12313123", "23222212", "12322213", "32322211", "21422212", "24113212", "13213213", "33213211", "22313212", "11413213", "31413211", "15131122", "24231121", "13331122", "22431121", "25122121", "14222122", "25131211", "14231212", "12422122", "23331211", "12431212", "15113122", "15122212", "13313122", "24222211", "13322212", "11513122", "22422211", "11522212", "25113211", "14213212", "23313211", "12413212", "21513211", "16131121", "14331121", "15222121", "15231211", "13422121", "13431211", "16113121", "16122211", "14313121", "14322211", "12513121", "12522211", "15213211", "13413211", "11613211", "11141125", "31141123", "51141121", "21132124", "41132122", "21141214", "41141212", "11123125", "31123123", "51123121", "11132215", "31132213", "51132211", "21114124", "41114122", "21123214", "41123212", "11114215", "31114213", "51114211", "12141124", "32141122", "21241123", "41241121", "22132123", "42132121", "11232124", "22141213", "42141211", "11241214", "31241212", "12123124", "32123122", "12132214", "32132212", "21232213", "41232211", "22114123", "42114121", "11214124", "22123213", "42123211", "11223214", "31223212", "12114214", "32114212", "21214213", "41214211", "13141123", "33141121", "22241122", "11341123", "31341121", "23132122", "12232123", "23141212", "12241213", "32241211", "21341212", "13123123", "33123121", "13132213", "33132211", "11323123", "22232212", "11332213", "31332211", "23114122", "12214123", "23123212", "12223213", "32223211", "21323212", "13114213", "33114211", "22214212", "11314213", "31314211", "14141122", "23241121", "12341122", "24132121", "13232122", "24141211", "13241212", "11432122", "22341211", "14123122", "14132212", "12323122", "23232211", "12332212", "21432211", "24114121", "13214122", "24123211", "13223212", "11414122", "22323211", "11423212", "14114212", "23214211", "12314212", "21414211", "15141121", "13341121", "14232121", "14241211", "12432121", "15123121", "15132211", "13323121", "13332211", "11523121", "14214121", "14223211", "12414121", "12423211", "15114211", "13314211", "11514211", "11151124", "31151122", "21142123", "41142121", "21151213", "41151211", "11133124", "31133122", "11142214", "31142212", "21124123", "41124121", "21133213", "41133211", "11115124", "31115122", "11124214", "31124212", "21115213", "41115211", "12151123", "32151121", "21251122", "22142122", "11242123", "22151212", "11251213", "31251211", "12133123", "32133121", "12142213", "32142211", "21242212", "22124122", "11224123", "22133212", "11233213", "31233211", "12115123", "32115121", "12124213", "32124211", "21224212", "22115212", "11215213", "31215211", "13151122", "22251121", "23142121", "12242122", "23151211", "12251212", "13133122", "13142212", "11333122", "22242211", "11342212", "23124121", "12224122", "23133211", "12233212", "21333211", "13115122", "13124212", "11315122", "22224211", "11324212", "23115211", "12215212", "21315211", "14151121", "13242121", "13251211", "14133121", "14142211", "12333121", "12342211", "13224121", "13233211", "11424121", "11433211", "14115121", "14124211", "12315121", "12324211", "13215211", "11415211", "11161123", "31161121", "21152122", "21161212", "11143123", "31143121", "11152213", "31152211", "21134122", "21143212", "11125123", "31125121", "11134213", "31134211", "21116122", "21125212", "12161122", "22152121", "11252122", "22161211", "12143122", "12152212", "21252211", "22134121", "11234122", "22143211", "11243212", "12125122", "12134212", "21234211", "22116121", "11216122", "22125211", "11225212", "13161121", "12252121", "13143121", "13152211", "11343121", "12234121", "12243211", "13125121", "13134211", "11325121", "11334211", "12216121", "12225211", "31111225", "51111223", "21111316", "41111314", "61111312", "31211134", "51211132", "12111226", "32111224", "52111222", "21211225", "41211223", "61211221", "22111315", "42111313", "11211316", "31211314", "51211312", "12211135", "32211133", "52211131", "21311134", "41311132", "13111225", "33111223", "22211224", "42211222", "11311225", "31311223", "51311221", "23111314", "43111312", "12211315", "32211313", "52211311", "21311314", "41311312", "13211134", "33211132", "22311133", "42311131", "11411134", "31411132", "14111224", "34111222", "23211223", "43211221", "12311224", "32311222", "21411223", "41411221", "24111313", "13211314", "33211312", "22311313", "42311311", "11411314", "31411312", "14211133", "34211131", "23311132", "12411133", "32411131", "21511132", "15111223", "24211222", "13311223", "33311221", "22411222", "11511223", "31511221", "25111312", "14211313", "34211311", "23311312", "12411313", "32411311", "21511312", "15211132", "24311131", "13411132", "22511131", "11611132", "16111222", "25211221", "14311222", "23411221", "12511222", "21611221", "15211312", "24311311", "13411312", "22511311", "11611312", "21121135", "41121133", "61121131", "11112136", "31112134", "51112132", "11121226", "31121224", "51121222", "21112225", "41112223", "61112221", "21121315", "41121313", "61121311", "11112316", "31112314", "51112312", "22121134", "42121132", "11221135", "31221133", "51221131", "12112135", "32112133", "52112131", "12121225", "32121223", "52121221", "21221224", "41221222", "22112224", "42112222", "11212225", "22121314", "42121312", "11221315", "31221313", "51221311", "12112315", "32112313", "52112311", "21212314", "41212312", "23121133", "43121131", "12221134", "32221132", "21321133", "41321131", "13112134", "33112132", "13121224", "33121222", "11312134", "22221223", "42221221", "11321224", "31321222", "23112223", "43112221", "12212224", "23121313", "43121311", "12221314", "32221312", "21321313", "41321311", "13112314", "33112312", "22212313", "42212311", "11312314", "31312312", "24121132", "13221133", "33221131", "22321132", "11421133", "31421131", "14112133", "34112131", "14121223", "34121221", "12312133", "23221222", "12321223", "32321221", "21421222", "24112222", "13212223", "24121312", "13221313", "33221311", "11412223", "22321312", "11421313", "31421311", "14112313", "34112311", "23212312", "12312313", "32312311", "21412312", "25121131", "14221132", "23321131", "12421132", "21521131", "15112132", "15121222", "13312132", "24221221", "13321222", "11512132", "22421221", "11521222", "25112221", "14212222", "25121311", "14221312", "12412222", "23321311", "12421312", "21521311", "15112312", "24212311", "13312312", "22412311", "11512312", "15221131", "13421131", "16112131", "16121221", "14312131", "14321221", "12512131", "12521221", "15212221", "15221311", "13412221", "13421311", "11612221", "16112311", "14312311", "12512311", "21131134", "41131132", "11122135", "31122133", "51122131", "11131225", "31131223", "51131221", "21113134", "41113132", "21122224", "41122222", "21131314", "41131312", "11113225", "31113223", "51113221", "11122315", "31122313", "51122311", "21113314", "41113312", "22131133", "42131131", "11231134", "31231132", "12122134", "32122132", "12131224", "32131222", "21231223", "41231221", "22113133", "42113131", "11213134", "22122223", "42122221", "11222224", "22131313", "42131311", "11231314", "31231312", "12113224", "32113222", "12122314", "32122312", "21222313", "41222311", "22113313", "42113311", "11213314", "31213312", "23131132", "12231133", "32231131", "21331132", "13122133", "33122131", "13131223", "33131221", "11322133", "22231222", "11331223", "31331221", "23113132", "12213133", "23122222", "12222223", "23131312", "12231313", "32231311", "21331312", "13113223", "33113221", "13122313", "33122311", "11313223", "22222312", "11322313", "31322311", "23113312", "12213313", "32213311", "21313312", "24131131", "13231132", "22331131", "11431132", "14122132", "14131222", "12322132", "23231221", "12331222", "21431221", "24113131", "13213132", "24122221", "13222222", "24131311", "11413132", "13231312", "11422222", "22331311", "11431312", "14113222", "14122312", "12313222", "23222311", "12322312", "21422311", "24113311", "13213312", "22313311", "11413312", "14231131", "12431131", "15122131", "15131221", "13322131", "13331221", "11522131", "14213131", "14222221", "12413131", "14231311", "12422221", "12431311", "15113221", "15122311", "13313221", "13322311", "11513221", "11522311", "14213311", "12413311", "21141133", "41141131", "11132134", "31132132", "11141224", "31141222", "21123133", "41123131", "21132223", "41132221", "21141313", "41141311", "11114134", "31114132", "11123224", "31123222", "11132314", "31132312", "21114223", "41114221", "21123313", "41123311", "11114314", "31114312", "22141132", "11241133", "31241131", "12132133", "32132131", "12141223", "32141221", "21241222", "22123132", "11223133", "22132222", "11232223", "22141312", "11241313", "31241311", "12114133", "32114131", "12123223", "32123221", "12132313", "32132311", "21232312", "22114222", "11214223", "22123312", "11223313", "31223311", "12114313", "32114311", "21214312", "23141131", "12241132", "21341131", "13132132", "13141222", "11332132", "22241221", "11341222", "23123131", "12223132", "23132221", "12232222", "23141311", "12241312", "21341311", "13114132", "13123222", "11314132", "13132312", "11323222", "22232311", "11332312", "23114221", "12214222", "23123311", "12223312", "21323311", "13114312", "22214311", "11314312", "13241131", "14132131", "14141221", "12332131", "12341221", "13223131", "13232221", "11423131", "13241311", "11432221", "14114131", "14123221", "12314131", "14132311", "12323221", "12332311", "13214221", "13223311", "11414221", "11423311", "14114311", "12314311", "21151132", "11142133", "31142131", "11151223", "31151221", "21133132", "21142222", "21151312", "11124133", "31124131", "11133223", "31133221", "11142313", "31142311", "21115132", "21124222", "21133312", "11115223", "31115221", "11124313", "31124311", "22151131", "11251132", "12142132", "12151222", "21251221", "22133131", "11233132", "22142221", "11242222", "22151311", "11251312", "12124132", "12133222", "12142312", "21242311", "22115131", "11215132", "22124221", "11224222", "22133311", "11233312", "12115222", "12124312", "21224311", "12251131", "13142131", "13151221", "11342131", "12233131", "12242221", "12251311", "13124131", "13133221", "11324131", "13142311", "11333221", "11342311", "12215131", "12224221", "12233311", "13115221", "13124311", "11315221", "11324311", "21161131", "11152132", "11161222", "21143131", "21152221", "21161311", "11134132", "11143222", "11152312", "21125131", "21134221", "21143311", "11116132", "11125222", "11134312", "12152131", "12161221", "11243131", "11252221", "12134131", "12143221", "12152311", "11225131", "11234221", "11243311", "12116131", "12125221", "12134311", "21111235", "41111233", "61111231", "11111326", "31111324", "51111322", "21111415", "41111413", "61111411", "21211144", "41211142", "22111234", "42111232", "11211235", "31211233", "51211231", "12111325", "32111323", "52111321", "21211324", "41211322", "22111414", "42111412", "11211415", "31211413", "51211411", "22211143", "42211141", "11311144", "31311142", "23111233", "43111231", "12211234", "32211232", "21311233", "41311231", "13111324", "33111322", "22211323", "42211321", "11311324", "31311322", "23111413", "43111411", "12211414", "32211412", "21311413", "41311411", "23211142", "12311143", "32311141", "21411142", "24111232", "13211233", "33211231", "22311232", "11411233", "31411231", "14111323", "34111321", "23211322", "12311323", "32311321", "21411322", "24111412", "13211413", "33211411", "22311412", "11411413", "31411411", "24211141", "13311142", "22411141", "11511142", "25111231", "14211232", "23311231", "12411232", "21511231", "15111322", "24211321", "13311322", "22411321", "11511322", "25111411", "14211412", "23311411", "12411412", "21511411", "14311141", "12511141", "15211231", "13411231", "11611231", "16111321", "14311321", "12511321", "15211411", "13411411", "11611411", "31121143", "51121141", "21112144", "41112142", "21121234", "41121232", "11112235", "31112233", "51112231", "11121325", "31121323", "51121321", "21112324", "41112322", "21121414", "41121412", "11112415", "31112413", "51112411", "12121144", "32121142", "21221143", "41221141", "22112143", "42112141", "11212144", "22121233", "42121231", "11221234", "31221232", "12112234", "32112232", "12121324", "32121322", "21221323", "41221321", "22112323", "42112321", "11212324", "22121413", "42121411", "11221414", "31221412", "12112414", "32112412", "21212413", "41212411", "13121143", "33121141", "22221142", "11321143", "31321141", "23112142", "12212143", "23121232", "12221233", "32221231", "21321232", "13112233", "33112231", "13121323", "33121321", "11312233", "22221322", "11321323", "31321321", "23112322", "12212323", "23121412", "12221413", "32221411", "21321412", "13112413", "33112411", "22212412", "11312413", "31312411", "14121142", "23221141", "12321142", "21421141", "24112141", "13212142", "24121231", "13221232", "11412142", "22321231", "11421232", "14112232", "14121322", "12312232", "23221321", "12321322", "21421321", "24112321", "13212322", "24121411", "13221412", "11412322", "22321411", "11421412", "14112412", "23212411", "12312412", "21412411", "15121141", "13321141", "11521141", "14212141", "14221231", "12412141", "12421231", "15112231", "15121321", "13312231", "13321321", "11512231", "11521321", "14212321", "14221411", "12412321", "12421411", "15112411", "13312411", "11512411", "11131144", "31131142", "21122143", "41122141", "21131233", "41131231", "11113144", "31113142", "11122234", "31122232", "11131324", "31131322", "21113233", "41113231", "21122323", "41122321", "21131413", "41131411", "11113324", "31113322", "11122414", "31122412", "21113413", "41113411", "12131143", "32131141", "21231142", "22122142", "11222143", "22131232", "11231233", "31231231", "12113143", "32113141", "12122233", "32122231", "12131323", "32131321", "21231322", "22113232", "11213233", "22122322", "11222323", "22131412", "11231413", "31231411", "12113323", "32113321", "12122413", "32122411", "21222412", "22113412", "11213413", "31213411", "13131142", "22231141", "11331142", "23122141", "12222142", "23131231", "12231232", "21331231", "13113142", "13122232", "11313142", "13131322", "11322232", "22231321", "11331322", "23113231", "12213232", "23122321", "12222322", "23131411", "12231412", "21331411", "13113322", "13122412", "11313322", "22222411", "11322412", "23113411", "12213412", "21313411", "14131141", "12331141", "13222141", "13231231", "11422141", "11431231", "14113141", "14122231", "12313141", "14131321", "12322231", "12331321", "13213231", "13222321", "11413231", "13231411", "11422321", "11431411", "14113321", "14122411", "12313321", "12322411", "13213411", "11413411", "11141143", "31141141", "21132142", "21141232", "11123143", "31123141", "11132233", "31132231", "11141323", "31141321", "21114142", "21123232", "21132322", "21141412", "11114233", "31114231", "11123323", "31123321", "11132413", "31132411", "21114322", "21123412", "12141142", "21241141", "22132141", "11232142", "22141231", "11241232", "12123142", "12132232", "12141322", "21241321", "22114141", "11214142", "22123231", "11223232", "22132321", "11232322", "22141411", "11241412", "12114232", "12123322", "12132412", "21232411", "22114321", "11214322", "22123411", "11223412", "13141141", "11341141", "12232141", "12241231", "13123141", "13132231", "11323141", "13141321", "11332231", "11341321", "12214141", "12223231", "12232321", "12241411", "13114231", "13123321", "11314231", "13132411", "11323321", "11332411", "12214321", "12223411", "11151142", "21142141", "21151231", "11133142", "11142232", "11151322", "21124141", "21133231", "21142321", "21151411", "11115142", "11124232", "11133322", "11142412", "21115231", "21124321", "21133411", "12151141", "11242141", "11251231", "12133141", "12142231", "12151321", "11224141", "11233231", "11242321", "11251411", "12115141", "12124231", "12133321", "12142411", "11215231", "11224321", "11233411", "11161141", "11143141", "11152231", "11161321", "11125141", "11134231", "11143321", "11152411", "11111245", "31111243", "51111241", "21111334", "41111332", "11111425", "31111423", "51111421", "21111514", "41111512", "31211152", "12111244", "32111242", "21211243", "41211241", "22111333", "42111331", "11211334", "31211332", "12111424", "32111422", "21211423", "41211421", "22111513", "42111511", "11211514", "31211512", "12211153", "32211151", "21311152", "13111243", "33111241", "22211242", "11311243", "31311241", "23111332", "12211333", "32211331", "21311332", "13111423", "33111421", "22211422", "11311423", "31311421", "23111512", "12211513", "32211511", "21311512", "13211152", "22311151", "11411152", "14111242", "23211241", "12311242", "21411241", "24111331", "13211332", "22311331", "11411332", "14111422", "23211421", "12311422", "21411421", "24111511", "13211512", "22311511", "11411512", "14211151", "12411151", "15111241", "13311241", "11511241", "14211331", "12411331", "15111421", "13311421", "11511421", "14211511", "12411511", "21121153", "41121151", "11112154", "31112152", "11121244", "31121242", "21112243", "41112241", "21121333", "41121331", "11112334", "31112332", "11121424", "31121422", "21112423", "41112421", "21121513", "41121511", "11112514", "31112512", "22121152", "11221153", "31221151", "12112153", "32112151", "12121243", "32121241", "21221242", "22112242", "11212243", "22121332", "11221333", "31221331", "12112333", "32112331", "12121423", "32121421", "21221422", "22112422", "11212423", "22121512", "11221513", "31221511", "12112513", "32112511", "21212512", "23121151", "12221152", "21321151", "13112152", "13121242", "11312152", "22221241", "11321242", "23112241", "12212242", "23121331", "12221332", "21321331", "13112332", "13121422", "11312332", "22221421", "11321422", "23112421", "12212422", "23121511", "12221512", "21321511", "13112512", "22212511", "11312512", "13221151", "11421151", "14112151", "14121241", "12312151", "12321241", "13212241", "13221331", "11412241", "11421331", "14112331", "14121421", "12312331", "12321421", "13212421", "13221511", "11412421", "11421511", "14112511", "12312511", "21131152", "11122153", "31122151", "11131243", "31131241", "21113152", "21122242", "21131332", "11113243", "31113241", "11122333", "31122331", "11131423", "31131421", "21113332", "21122422", "21131512", "11113423", "31113421", "11122513", "31122511", "22131151", "11231152", "12122152", "12131242", "21231241", "22113151", "11213152", "22122241", "11222242", "22131331", "11231332", "12113242", "12122332", "12131422", "21231421", "22113331", "11213332", "22122421", "11222422", "22131511", "11231512", "12113422", "12122512", "21222511", "12231151", "13122151", "13131241", "11322151", "11331241", "12213151", "12222241", "12231331", "13113241", "13122331", "11313241", "13131421", "11322331", "11331421", "12213331", "12222421", "12231511", "13113421", "13122511", "11313421", "11322511", "21141151", "11132152", "11141242", "21123151", "21132241", "21141331", "11114152", "11123242", "11132332", "11141422", "21114241", "21123331", "21132421", "21141511", "11114332", "11123422", "11132512", "11241151", "12132151", "12141241", "11223151", "11232241", "11241331", "12114151", "12123241", "12132331", "12141421", "11214241", "11223331", "11232421", "11241511", "12114331", "12123421", "12132511", "11142151", "11151241", "11124151", "11133241", "11142331", "11151421", "11115241", "11124331", "11133421", "11142511", "21111253", "41111251", "11111344", "31111342", "21111433", "41111431", "11111524", "31111522", "21111613", "41111611", "21211162", "22111252", "11211253", "31211251", "12111343", "32111341", "21211342", "22111432", "11211433", "31211431", "12111523", "32111521", "21211522", "22111612", "11211613", "31211611", "22211161", "11311162", "23111251", "12211252", "21311251", "13111342", "22211341", "11311342", "23111431", "12211432", "21311431", "13111522", "22211521", "11311522", "23111611", "12211612", "21311611", "12311161", "13211251", "11411251", "14111341", "12311341", "13211431", "11411431", "14111521", "12311521", "13211611", "11411611", "31121161", "21112162", "21121252", "11112253", "31112251", "11121343", "31121341", "21112342", "21121432", "11112433", "31112431", "11121523", "31121521", "21112522", "21121612", "12121162", "21221161", "22112161", "11212162", "22121251", "11221252", "12112252", "12121342", "21221341", "22112341", "11212342", "22121431", "11221432", "12112432", "12121522", "21221521", "22112521", "11212522", "22121611", "11221612", "13121161", "11321161", "12212161", "12221251", "13112251", "13121341", "11312251", "11321341", "12212341", "12221431", "13112431", "13121521", "11312431", "11321521", "12212521", "12221611", "11131162", "21122161", "21131251", "11113162"])]); /*12332*/
		$1.parity = $a(["1001", "0101", "1100", "0011", "1010", "0110", "1111", "0000"]); /*12336*/
		$1.rowbits = $a($1.r); /*12339*/
		for (var _6L = 0, _6K = $1.r - 1; _6L <= _6K; _6L += 1) { /*12359*/
			$1.i = _6L; /*12341*/
			$k[$j++] = "p"; /*12342*/
			if ($1.i != ($1.r - 1)) { /*12342*/
				$k[$j++] = $get($1.parity, $1.i); /*12342*/
			} else { /*12342*/
				$k[$j++] = "0000"; /*12342*/
			} /*12342*/
			var _6R = $k[--$j]; /*12342*/
			$1[$k[--$j]] = _6R; /*12342*/
			$1.ccrow = $geti($1.ccs, $1.i * 8, 8); /*12343*/
			$k[$j++] = "scrow"; /*12345*/
			$k[$j++] = Infinity; /*12345*/
			for (var _6W = 0; _6W <= 7; _6W += 2) { /*12345*/
				$aload($geti($1.ccrow, _6W, 2)); /*12345*/
				var _6Z = $k[--$j]; /*12345*/
				var _6a = $k[--$j]; /*12345*/
				$k[$j++] = _6Z + (_6a * 49); /*12345*/
			} /*12345*/
			var _6b = $a(); /*12345*/
			$1[$k[--$j]] = _6b; /*12346*/
			$k[$j++] = "sbs"; /*12353*/
			$k[$j++] = Infinity; /*12353*/
			$k[$j++] = 10; /*12352*/
			$k[$j++] = 1; /*12352*/
			$k[$j++] = 1; /*12352*/
			for (var _6d = 0; _6d <= 3; _6d += 1) { /*12352*/
				$1.j = _6d; /*12350*/
				$forall($get($get($1.patterns, $get($1.p, $1.j) - 48), $get($1.scrow, $1.j)), function() { /*12351*/
					var _6n = $k[--$j]; /*12351*/
					$k[$j++] = _6n - 48; /*12351*/
				}) /*12351*/
			} /*12351*/
			$k[$j++] = 4; /*12353*/
			$k[$j++] = 1; /*12353*/
			var _6o = $a(); /*12353*/
			$1[$k[--$j]] = _6o; /*12354*/
			$k[$j++] = Infinity; /*12355*/
			$k[$j++] = 1; /*12356*/
			$forall($1.sbs, function() { /*12356*/
				var _6r = $k[--$j]; /*12356*/
				var _6s = $k[--$j]; /*12356*/
				var _6t = (_6s == 0) ? 1 : 0; /*12356*/
				$k[$j++] = _6s; /*12356*/
				for (var _6u = 0, _6v = _6r; _6u < _6v; _6u++) { /*12356*/
					$k[$j++] = _6t /*12356*/
				} /*12356*/
			}) /*12356*/
			$astore($a($counttomark() - 1)); /*12357*/
			var _6y = $k[--$j]; /*12357*/
			var _6z = $k[--$j]; /*12357*/
			var _70 = $k[--$j]; /*12357*/
			$put($1.rowbits, $1.i, _6y); /*12358*/
		} /*12358*/
		$k[$j++] = "pixs"; /*12370*/
		$k[$j++] = Infinity; /*12370*/
		for (var _74 = 0, _75 = 81 * $1.sepheight; _74 < _75; _74++) { /*12363*/
			$k[$j++] = 1; /*12363*/
		} /*12363*/
		for (var _78 = 0, _77 = $1.r - 2; _78 <= _77; _78 += 1) { /*12368*/
			$1.i = _78; /*12365*/
			for (var _7A = 0, _7B = $1.rowheight; _7A < _7B; _7A++) { /*12366*/
				$aload($get($1.rowbits, $1.i)); /*12366*/
			} /*12366*/
			for (var _7G = 0, _7H = $1.sepheight; _7G < _7H; _7G++) { /*12367*/
				for (var _7I = 0, _7J = 10; _7I < _7J; _7I++) { /*12367*/
					$k[$j++] = 0; /*12367*/
				} /*12367*/
				for (var _7K = 0, _7L = 70; _7K < _7L; _7K++) { /*12367*/
					$k[$j++] = 1; /*12367*/
				} /*12367*/
				$k[$j++] = 0; /*12367*/
			} /*12367*/
		} /*12367*/
		for (var _7N = 0, _7O = $1.rowheight; _7N < _7O; _7N++) { /*12369*/
			$aload($get($1.rowbits, $1.r - 1)); /*12369*/
		} /*12369*/
		for (var _7T = 0, _7U = 81 * $1.sepheight; _7T < _7U; _7T++) { /*12370*/
			$k[$j++] = 1; /*12370*/
		} /*12370*/
		var _7V = $a(); /*12370*/
		$1[$k[--$j]] = _7V; /*12371*/
		var _7b = {
			ren: $0.renmatrix,
			pixs: $1.pixs,
			pixx: 81,
			pixy: ~~($1.pixs.length / 81),
			height: (~~($1.pixs.length / 81)) / 72,
			width: 81 / 72,
			opt: $1.options
		}; /*12381*/
		$k[$j++] = _7b; /*12384*/
		if (!$1.dontdraw) { /*12384*/
			$0.renmatrix(); /*12384*/
		} /*12384*/
	};
	$0.channelcode = function() {
		var $1 = {}; /*12411*/
		$1.options = $k[--$j]; /*12413*/
		$1.barcode = $k[--$j]; /*12414*/
		$1.dontdraw = false; /*12416*/
		$1.shortfinder = false; /*12417*/
		$1.includetext = false; /*12418*/
		$1.includecheck = false; /*12419*/
		$1.height = 1; /*12420*/
		$forall($1.options, function() { /*12431*/
			var _3 = $k[--$j]; /*12431*/
			$1[$k[--$j]] = _3; /*12431*/
		}) /*12431*/
		$1.height = +$1.height; /*12433*/
		if (($1.barcode.length < 2) || ($1.barcode.length > 7)) { /*12438*/
			$k[$j++] = "bwipp.channelcodeBadLength"; /*12437*/
			$k[$j++] = "Channel Code must be 2 to 7 digits"; /*12437*/
			$0.raiseerror(); /*12437*/
		} /*12437*/
		$forall($1.barcode, function() { /*12443*/
			var _9 = $k[--$j]; /*12440*/
			if ((_9 < 48) || (_9 > 57)) { /*12442*/
				$k[$j++] = "bwipp.channelcodeBadCharacter"; /*12441*/
				$k[$j++] = "Channel Code must contain only digits"; /*12441*/
				$0.raiseerror(); /*12441*/
			} /*12441*/
		}) /*12441*/
		if ((~~$z($1.barcode)) > $get($a([26, 292, 3493, 44072, 576688, 7742862]), $1.barcode.length - 2)) { /*12446*/
			$k[$j++] = "bwipp.channelcodeTooBig"; /*12445*/
			$k[$j++] = "The Channel Code value is too big for the number of channels"; /*12445*/
			$0.raiseerror(); /*12445*/
		} /*12445*/
		$1.nextb = function() {
			var _E = $k[--$j]; /*12449*/
			var _N = (($get($1.s, _E) + ($get($1.b, _E - 1) + ($get($1.b, _E - 2) + $get($1.s, _E - 1)))) > 4) ? 1 : 2; /*12454*/
			$k[$j++] = _E; /*12470*/
			$k[$j++] = _N; /*12470*/
			if (_E < ($1.chan + 2)) { /*12468*/
				var _P = $k[--$j]; /*12456*/
				var _Q = $k[--$j]; /*12456*/
				var _R = $k[--$j]; /*12456*/
				$k[$j++] = _R; /*12459*/
				$k[$j++] = _Q; /*12459*/
				$k[$j++] = _P; /*12459*/
				for (var _T = _P, _S = _R; _T <= _S; _T += 1) { /*12459*/
					var _V = $k[--$j]; /*12457*/
					var _W = $k[--$j]; /*12457*/
					$put($1.b, _W, _T); /*12457*/
					var _X = $k[--$j]; /*12458*/
					var _Y = $k[--$j]; /*12458*/
					$k[$j++] = _Y; /*12458*/
					$k[$j++] = _X; /*12458*/
					$k[$j++] = _W; /*12458*/
					$k[$j++] = _V; /*12458*/
					$k[$j++] = (_X - _T) + 1; /*12458*/
					$k[$j++] = _Y; /*12458*/
					$k[$j++] = _W + 1; /*12458*/
					$1.nexts(); /*12458*/
				} /*12458*/
			} else { /*12468*/
				var _Z = $k[--$j]; /*12461*/
				var _a = $k[--$j]; /*12461*/
				var _b = $k[--$j]; /*12461*/
				$k[$j++] = _b; /*12469*/
				$k[$j++] = _a; /*12469*/
				$k[$j++] = _Z; /*12469*/
				if ($le(_Z, _b)) { /*12469*/
					var _d = $k[--$j]; /*12462*/
					var _e = $k[--$j]; /*12462*/
					var _f = $k[--$j]; /*12462*/
					$put($1.b, _e, _f); /*12462*/
					$k[$j++] = _f; /*12467*/
					$k[$j++] = _e; /*12467*/
					$k[$j++] = _d; /*12467*/
					if ($1.value == $1.target) { /*12467*/
						$k[$j++] = "out"; /*12465*/
						$k[$j++] = Infinity; /*12465*/
						for (var _i = 3; _i <= 10; _i += 1) { /*12465*/
							$k[$j++] = $get($1.s, _i); /*12465*/
							$k[$j++] = $get($1.b, _i); /*12465*/
						} /*12465*/
						var _p = $geti($a(), 0, $1.chan * 2); /*12466*/
						$1[$k[--$j]] = _p; /*12466*/
					} /*12466*/
					$1.value = $1.value + 1; /*12468*/
				} /*12468*/
			} /*12468*/
			$j -= 4; /*12471*/
		}; /*12472*/
		$1.nexts = function() {
			var _s = $k[--$j]; /*12475*/
			$k[$j++] = _s; /*12475*/
			if (_s < ($1.chan + 2)) { /*12475*/
				$k[$j++] = 1; /*12475*/
			} else { /*12475*/
				var _u = $k[--$j]; /*12475*/
				var _v = $k[--$j]; /*12475*/
				$k[$j++] = _v; /*12475*/
				$k[$j++] = _u; /*12475*/
				$k[$j++] = _v; /*12475*/
			} /*12475*/
			var _w = $k[--$j]; /*12475*/
			var _x = $k[--$j]; /*12475*/
			var _y = $k[--$j]; /*12475*/
			$k[$j++] = _y; /*12478*/
			$k[$j++] = _x; /*12478*/
			for (var _10 = _w, _z = _y; _10 <= _z; _10 += 1) { /*12478*/
				var _12 = $k[--$j]; /*12476*/
				$put($1.s, _12, _10); /*12476*/
				var _13 = $k[--$j]; /*12477*/
				var _14 = $k[--$j]; /*12477*/
				$k[$j++] = _14; /*12477*/
				$k[$j++] = _13; /*12477*/
				$k[$j++] = _12; /*12477*/
				$k[$j++] = (_13 - _10) + 1; /*12477*/
				$k[$j++] = _14; /*12477*/
				$k[$j++] = _12; /*12477*/
				$1.nextb(); /*12477*/
			} /*12477*/
			$j -= 3; /*12479*/
		}; /*12480*/
		$1.encode = function() {
			$1.chan = $k[--$j]; /*12483*/
			$1.target = $k[--$j]; /*12484*/
			$1.value = 0; /*12485*/
			$1.out = -1; /*12486*/
			$1.b = $a([1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0]); /*12487*/
			$1.s = $a([0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0]); /*12488*/
			var _19 = $1.chan; /*12489*/
			$k[$j++] = _19; /*12489*/
			$k[$j++] = _19; /*12489*/
			$k[$j++] = 3; /*12489*/
			$1.nexts(); /*12489*/
			$k[$j++] = $1.out; /*12490*/
		}; /*12491*/
		$1.barlen = $1.barcode.length; /*12493*/
		$k[$j++] = "finder"; /*12496*/
		if ($1.shortfinder) { /*12496*/
			$k[$j++] = $a([1, 1, 1, 1, 1]); /*12496*/
		} else { /*12496*/
			$k[$j++] = $a([1, 1, 1, 1, 1, 1, 1, 1, 1]); /*12496*/
		} /*12496*/
		var _1F = $k[--$j]; /*12496*/
		$1[$k[--$j]] = _1F; /*12496*/
		$k[$j++] = "data"; /*12499*/
		$k[$j++] = ~~$z($1.barcode); /*12499*/
		$k[$j++] = $1.barlen + 1; /*12499*/
		$1.encode(); /*12499*/
		var _1J = $k[--$j]; /*12499*/
		$1[$k[--$j]] = _1J; /*12499*/
		$1.check = $a([]); /*12502*/
		if ($1.includecheck) { /*12518*/
			$1.mod23 = $get($a([$a([]), $a([]), $a([13, 12, 4, 9, 3, 1]), $a([13, 2, 12, 3, 18, 16, 4, 1]), $a([11, 16, 17, 8, 20, 4, 10, 2, 5, 1]), $a([1, 4, 16, 18, 3, 12, 2, 8, 9, 13, 6, 1]), $a([20, 16, 22, 13, 15, 12, 5, 4, 8, 9, 21, 3, 7, 1]), $a([2, 6, 18, 8, 1, 3, 9, 4, 12, 13, 16, 2, 6, 18, 8, 1])]), $1.barlen); /*12512*/
			$k[$j++] = 0; /*12516*/
			for (var _1a = 0, _1Z = $1.data.length - 1; _1a <= _1Z; _1a += 1) { /*12516*/
				var _1f = $k[--$j]; /*12515*/
				$k[$j++] = _1f + (($get($1.data, _1a) - 1) * $get($1.mod23, _1a)); /*12515*/
			} /*12515*/
			var _1g = $k[--$j]; /*12517*/
			$k[$j++] = _1g % 23; /*12517*/
			$k[$j++] = 3; /*12517*/
			$1.encode(); /*12517*/
			$1.check = $k[--$j]; /*12517*/
		} /*12517*/
		$k[$j++] = "sbs"; /*12524*/
		$k[$j++] = Infinity; /*12524*/
		$aload($1.finder); /*12522*/
		$aload($1.data); /*12523*/
		$aload($1.check); /*12524*/
		var _1l = $a(); /*12524*/
		$1[$k[--$j]] = _1l; /*12525*/
		$1.txt = $a($1.barlen); /*12528*/
		for (var _1r = 0, _1q = $1.barlen - 1; _1r <= _1q; _1r += 1) { /*12532*/
			$1.i = _1r; /*12530*/
			$put($1.txt, $1.i, $a([$geti($1.barcode, $1.i, 1), 0, 0, "", 0])); /*12531*/
		} /*12531*/
		$k[$j++] = Infinity; /*12542*/
		$k[$j++] = "ren"; /*12538*/
		$k[$j++] = $0.renlinear; /*12538*/
		$k[$j++] = "sbs"; /*12538*/
		$k[$j++] = $1.sbs; /*12538*/
		$k[$j++] = "bhs"; /*12538*/
		$k[$j++] = Infinity; /*12538*/
		for (var _20 = 0, _21 = ~~(($1.sbs.length + 1) / 2); _20 < _21; _20++) { /*12538*/
			$k[$j++] = $1.height; /*12538*/
		} /*12538*/
		var _23 = $a(); /*12538*/
		$k[$j++] = _23; /*12539*/
		$k[$j++] = "bbs"; /*12539*/
		$k[$j++] = Infinity; /*12539*/
		for (var _25 = 0, _26 = ~~(($1.sbs.length + 1) / 2); _25 < _26; _25++) { /*12539*/
			$k[$j++] = 0; /*12539*/
		} /*12539*/
		var _27 = $a(); /*12539*/
		$k[$j++] = _27; /*12542*/
		$k[$j++] = "txt"; /*12542*/
		$k[$j++] = $1.txt; /*12542*/
		$k[$j++] = "textxalign"; /*12542*/
		$k[$j++] = "center"; /*12542*/
		$k[$j++] = "opt"; /*12542*/
		$k[$j++] = $1.options; /*12542*/
		var _2A = $d(); /*12542*/
		$k[$j++] = _2A; /*12545*/
		if (!$1.dontdraw) { /*12545*/
			$0.renlinear(); /*12545*/
		} /*12545*/
	};
	$0.flattermarken = function() {
		var $1 = {}; /*12572*/
		$1.options = $k[--$j]; /*12574*/
		$1.barcode = $k[--$j]; /*12575*/
		$1.dontdraw = false; /*12577*/
		$1.includetext = false; /*12578*/
		$1.textfont = "Courier"; /*12579*/
		$1.textsize = 10; /*12580*/
		$1.textyoffset = -8.5; /*12581*/
		$1.height = 0.3; /*12582*/
		$forall($1.barcode, function() { /*12589*/
			var _3 = $k[--$j]; /*12586*/
			if ((_3 < 48) || (_3 > 57)) { /*12588*/
				$k[$j++] = "bwipp.flattermarkenBadCharacter"; /*12587*/
				$k[$j++] = "Flattermarken must contain only digits"; /*12587*/
				$0.raiseerror(); /*12587*/
			} /*12587*/
		}) /*12587*/
		$forall($1.options, function() { /*12600*/
			var _5 = $k[--$j]; /*12600*/
			$1[$k[--$j]] = _5; /*12600*/
		}) /*12600*/
		$1.textfont = "" + $1.textfont; /*12602*/
		$1.textsize = +$1.textsize; /*12603*/
		$1.textyoffset = +$1.textyoffset; /*12604*/
		$1.height = +$1.height; /*12605*/
		$forall($1.barcode, function() { /*12612*/
			var _C = $k[--$j]; /*12609*/
			if ((_C < 48) || (_C > 57)) { /*12611*/
				$k[$j++] = "bwipp.flattermarkenBadCharacter"; /*12610*/
				$k[$j++] = "Flattermarken must contain only digits"; /*12610*/
				$0.raiseerror(); /*12610*/
			} /*12610*/
		}) /*12610*/
		$1.encs = $a(["0018", "0117", "0216", "0315", "0414", "0513", "0612", "0711", "0810", "0900"]); /*12618*/
		$1.barchars = "1234567890"; /*12621*/
		$1.barlen = $1.barcode.length; /*12623*/
		$1.sbs = $s($1.barlen * 4); /*12625*/
		$1.txt = $a($1.barlen); /*12626*/
		for (var _L = 0, _K = $1.barlen - 1; _L <= _K; _L += 1) { /*12638*/
			$1.i = _L; /*12629*/
			$search($1.barchars, $geti($1.barcode, $1.i, 1)); /*12631*/
			$j--; /*12632*/
			$1.indx = $k[--$j].length; /*12633*/
			$j -= 2; /*12634*/
			$1.enc = $get($1.encs, $1.indx); /*12635*/
			$puti($1.sbs, $1.i * 4, $1.enc); /*12636*/
			$put($1.txt, $1.i, $a([$geti($1.barcode, $1.i, 1), $1.i * 9, $1.textyoffset, $1.textfont, $1.textsize])); /*12637*/
		} /*12637*/
		$k[$j++] = Infinity; /*12647*/
		$k[$j++] = "ren"; /*12643*/
		$k[$j++] = $0.renlinear; /*12643*/
		$k[$j++] = "sbs"; /*12643*/
		$k[$j++] = Infinity; /*12643*/
		var _h = $1.sbs; /*12643*/
		for (var _i = 0, _j = _h.length; _i < _j; _i++) { /*12643*/
			$k[$j++] = $get(_h, _i) - 48; /*12643*/
		} /*12643*/
		var _l = $a(); /*12643*/
		$k[$j++] = _l; /*12644*/
		$k[$j++] = "bhs"; /*12644*/
		$k[$j++] = Infinity; /*12644*/
		for (var _n = 0, _o = ~~(($1.sbs.length + 1) / 2); _n < _o; _n++) { /*12644*/
			$k[$j++] = $1.height; /*12644*/
		} /*12644*/
		var _q = $a(); /*12644*/
		$k[$j++] = _q; /*12645*/
		$k[$j++] = "bbs"; /*12645*/
		$k[$j++] = Infinity; /*12645*/
		for (var _s = 0, _t = ~~(($1.sbs.length + 1) / 2); _s < _t; _s++) { /*12645*/
			$k[$j++] = 0; /*12645*/
		} /*12645*/
		var _u = $a(); /*12645*/
		$k[$j++] = _u; /*12647*/
		$k[$j++] = "txt"; /*12647*/
		$k[$j++] = $1.txt; /*12647*/
		$k[$j++] = "opt"; /*12647*/
		$k[$j++] = $1.options; /*12647*/
		var _x = $d(); /*12647*/
		$k[$j++] = _x; /*12650*/
		if (!$1.dontdraw) { /*12650*/
			$0.renlinear(); /*12650*/
		} /*12650*/
	};
	$0.raw = function() {
		var $1 = {}; /*12677*/
		$1.options = $k[--$j]; /*12679*/
		$1.barcode = $k[--$j]; /*12680*/
		$1.dontdraw = false; /*12682*/
		$1.height = 1; /*12683*/
		$forall($1.options, function() { /*12694*/
			var _3 = $k[--$j]; /*12694*/
			$1[$k[--$j]] = _3; /*12694*/
		}) /*12694*/
		$1.height = +$1.height; /*12696*/
		$forall($1.barcode, function() { /*12703*/
			var _7 = $k[--$j]; /*12700*/
			if ((_7 < 49) || (_7 > 57)) { /*12702*/
				$k[$j++] = "bwipp.rawBadCharacter"; /*12701*/
				$k[$j++] = "Raw must contain only digits 1 to 9"; /*12701*/
				$0.raiseerror(); /*12701*/
			} /*12701*/
		}) /*12701*/
		$k[$j++] = Infinity; /*12711*/
		$k[$j++] = "ren"; /*12708*/
		$k[$j++] = $0.renlinear; /*12708*/
		$k[$j++] = "sbs"; /*12708*/
		$k[$j++] = Infinity; /*12708*/
		$forall($1.barcode, function() { /*12708*/
			var _9 = $k[--$j]; /*12708*/
			$k[$j++] = _9 - 48; /*12708*/
		}) /*12708*/
		var _A = $a(); /*12708*/
		$k[$j++] = _A; /*12709*/
		$k[$j++] = "bhs"; /*12709*/
		$k[$j++] = Infinity; /*12709*/
		for (var _C = 0, _D = ~~(($1.barcode.length + 1) / 2); _C < _D; _C++) { /*12709*/
			$k[$j++] = $1.height; /*12709*/
		} /*12709*/
		var _F = $a(); /*12709*/
		$k[$j++] = _F; /*12710*/
		$k[$j++] = "bbs"; /*12710*/
		$k[$j++] = Infinity; /*12710*/
		for (var _H = 0, _I = ~~(($1.barcode.length + 1) / 2); _H < _I; _H++) { /*12710*/
			$k[$j++] = 0; /*12710*/
		} /*12710*/
		var _J = $a(); /*12710*/
		$k[$j++] = _J; /*12711*/
		$k[$j++] = "opt"; /*12711*/
		$k[$j++] = $1.options; /*12711*/
		var _L = $d(); /*12711*/
		$k[$j++] = _L; /*12714*/
		if (!$1.dontdraw) { /*12714*/
			$0.renlinear(); /*12714*/
		} /*12714*/
	};
	$0.daft = function() {
		var $1 = {}; /*12741*/
		$1.options = $k[--$j]; /*12743*/
		$1.barcode = $k[--$j]; /*12744*/
		$1.dontdraw = false; /*12746*/
		$1.height = 0.175; /*12747*/
		$forall($1.options, function() { /*12758*/
			var _3 = $k[--$j]; /*12758*/
			$1[$k[--$j]] = _3; /*12758*/
		}) /*12758*/
		$1.height = +$1.height; /*12760*/
		$forall($1.barcode, function() { /*12766*/
			var _7 = $k[--$j]; /*12763*/
			if ((_7 != 68) && ((_7 != 65) && ((_7 != 70) && (_7 != 84)))) { /*12765*/
				$k[$j++] = "bwipp.daftBadCharacter"; /*12764*/
				$k[$j++] = "DAFT must contain only characters D, A, F and T"; /*12764*/
				$0.raiseerror(); /*12764*/
			} /*12764*/
		}) /*12764*/
		$1.barlen = $1.barcode.length; /*12768*/
		$1.bbs = $a($1.barlen); /*12770*/
		$1.bhs = $a($1.barlen); /*12771*/
		for (var _F = 0, _E = $1.barlen - 1; _F <= _E; _F += 1) { /*12791*/
			$1.i = _F; /*12773*/
			$1.enc = $geti($1.barcode, $1.i, 1); /*12774*/
			if ($eq($1.enc, "D")) { /*12778*/
				$put($1.bbs, $1.i, (0 * $1.height) / 8); /*12776*/
				$put($1.bhs, $1.i, (5 * $1.height) / 8); /*12777*/
			} /*12777*/
			if ($eq($1.enc, "A")) { /*12782*/
				$put($1.bbs, $1.i, (3 * $1.height) / 8); /*12780*/
				$put($1.bhs, $1.i, (5 * $1.height) / 8); /*12781*/
			} /*12781*/
			if ($eq($1.enc, "F")) { /*12786*/
				$put($1.bbs, $1.i, (0 * $1.height) / 8); /*12784*/
				$put($1.bhs, $1.i, (8 * $1.height) / 8); /*12785*/
			} /*12785*/
			if ($eq($1.enc, "T")) { /*12790*/
				$put($1.bbs, $1.i, (3 * $1.height) / 8); /*12788*/
				$put($1.bhs, $1.i, (2 * $1.height) / 8); /*12789*/
			} /*12789*/
		} /*12789*/
		$k[$j++] = Infinity; /*12799*/
		$k[$j++] = "ren"; /*12798*/
		$k[$j++] = $0.renlinear; /*12798*/
		$k[$j++] = "bbs"; /*12798*/
		$k[$j++] = $1.bbs; /*12798*/
		$k[$j++] = "bhs"; /*12798*/
		$k[$j++] = $1.bhs; /*12798*/
		$k[$j++] = "sbs"; /*12798*/
		$k[$j++] = Infinity; /*12798*/
		for (var _o = 0, _p = $1.bhs.length - 1; _o < _p; _o++) { /*12798*/
			$k[$j++] = 1.44; /*12798*/
			$k[$j++] = 1.872; /*12798*/
		} /*12798*/
		$k[$j++] = 1.44; /*12798*/
		var _q = $a(); /*12798*/
		$k[$j++] = _q; /*12799*/
		$k[$j++] = "opt"; /*12799*/
		$k[$j++] = $1.options; /*12799*/
		var _s = $d(); /*12799*/
		$k[$j++] = _s; /*12802*/
		if (!$1.dontdraw) { /*12802*/
			$0.renlinear(); /*12802*/
		} /*12802*/
	};
	$0.symbol = function() {
		var $1 = {}; /*12829*/
		$1.options = $k[--$j]; /*12831*/
		$1.barcode = $k[--$j]; /*12832*/
		$1.dontdraw = false; /*12834*/
		$forall($1.options, function() { /*12845*/
			var _3 = $k[--$j]; /*12845*/
			$1[$k[--$j]] = _3; /*12845*/
		}) /*12845*/
		var _H = {
			fima: function() {
				$1.sbs = $a([2.25, 2.25, 2.25, 11.25, 2.25, 11.25, 2.25, 2.25, 2.25]); /*12849*/
				$1.bhs = $a([0.625, 0.625, 0.625, 0.625, 0.625]); /*12850*/
				$1.bbs = $a([0, 0, 0, 0, 0]); /*12851*/
			},
			fimb: function() {
				$1.sbs = $a([2.25, 6.75, 2.25, 2.25, 2.25, 6.25, 2.25, 2.25, 2.25, 6.75, 2.25]); /*12854*/
				$1.bhs = $a([0.625, 0.625, 0.625, 0.625, 0.625, 0.625]); /*12855*/
				$1.bbs = $a([0, 0, 0, 0, 0, 0]); /*12856*/
			},
			fimc: function() {
				$1.sbs = $a([2.25, 2.25, 2.25, 6.75, 2.25, 6.75, 2.25, 6.75, 2.25, 2.25, 2.25]); /*12859*/
				$1.bhs = $a([0.625, 0.625, 0.625, 0.625, 0.625, 0.625]); /*12860*/
				$1.bbs = $a([0, 0, 0, 0, 0, 0]); /*12861*/
			},
			fimd: function() {
				$1.sbs = $a([2.25, 2.25, 2.25, 2.25, 2.25, 6.75, 2.25, 6.75, 2.25, 2.25, 2.25, 2.25, 2.25]); /*12864*/
				$1.bhs = $a([0.625, 0.625, 0.625, 0.625, 0.625, 0.625, 0.625]); /*12865*/
				$1.bbs = $a([0, 0, 0, 0, 0, 0, 0]); /*12866*/
			}
		}; /*12866*/
		$1.symbols = _H; /*12868*/
		var _K = $get($1.symbols, $1.barcode) !== undefined; /*12871*/
		if (!_K) { /*12873*/
			$k[$j++] = "bwipp.symbolUnknownSymbol"; /*12872*/
			$k[$j++] = "Unknown symbol name provided"; /*12872*/
			$0.raiseerror(); /*12872*/
		} /*12872*/
		$get($1.symbols, $1.barcode)(); /*12875*/
		var _S = {
			ren: $0.renlinear,
			sbs: $1.sbs,
			bhs: $1.bhs,
			bbs: $1.bbs,
			opt: $1.options
		}; /*12883*/
		$k[$j++] = _S; /*12886*/
		if (!$1.dontdraw) { /*12886*/
			$0.renlinear(); /*12886*/
		} /*12886*/
	};
	$0.pdf417 = function() {
		var $1 = {}; /*12913*/
		$1.options = $k[--$j]; /*12915*/
		$1.barcode = $k[--$j]; /*12916*/
		$1.dontdraw = false; /*12918*/
		$1.compact = false; /*12919*/
		$1.eclevel = -1; /*12920*/
		$1.columns = 0; /*12921*/
		$1.rows = 0; /*12922*/
		$1.rowmult = 3; /*12923*/
		$1.encoding = "auto"; /*12924*/
		$1.ccc = false; /*12925*/
		$1.raw = false; /*12926*/
		$1.parse = false; /*12927*/
		$forall($1.options, function() { /*12938*/
			var _3 = $k[--$j]; /*12938*/
			$1[$k[--$j]] = _3; /*12938*/
		}) /*12938*/
		$1.eclevel = ~~$1.eclevel; /*12940*/
		$1.columns = ~~$1.columns; /*12941*/
		$1.rows = ~~$1.rows; /*12942*/
		$1.rowmult = +$1.rowmult; /*12943*/
		if ($1.raw) { /*12966*/
			$1.encoding = "raw"; /*12966*/
		} /*12966*/
		if ($eq($1.encoding, "raw")) { /*12980*/
			$1.datcws = $a($1.barcode.length); /*12970*/
			$1.i = 0; /*12971*/
			$1.j = 0; /*12971*/
			for (;;) { /*12978*/
				if ($1.i == $1.barcode.length) { /*12973*/
					break; /*12973*/
				} /*12973*/
				$1.cw = ~~$z($geti($1.barcode, $1.i + 1, 3)); /*12974*/
				$put($1.datcws, $1.j, $1.cw); /*12975*/
				$1.i = $1.i + 4; /*12976*/
				$1.j = $1.j + 1; /*12977*/
			} /*12977*/
			$1.datcws = $geti($1.datcws, 0, $1.j); /*12979*/
		} /*12979*/
		$k[$j++] = "barcode"; /*12982*/
		$k[$j++] = Infinity; /*12982*/
		$forall($1.barcode); /*12982*/
		var _R = $a(); /*12982*/
		$1[$k[--$j]] = _R; /*12982*/
		$1.barlen = $1.barcode.length; /*12983*/
		if ($1.ccc) { /*12985*/
			$1.encoding = "ccc"; /*12985*/
		} /*12985*/
		$1.encb = function() {
			$1.in = $k[--$j]; /*12988*/
			$1.inlen = $1.in.length; /*12989*/
			$1.out = $a(((~~($1.inlen / 6)) * 5) + ($1.inlen % 6)); /*12990*/
			for (var _c = 0, _b = (~~($1.inlen / 6)) - 1; _c <= _b; _c += 1) { /*13013*/
				$1.k = _c; /*12992*/
				$k[$j++] = "msbs"; /*12993*/
				$k[$j++] = Infinity; /*12993*/
				$aload($geti($1.in, $1.k * 6, 3)); /*12993*/
				var _g = $a(); /*12993*/
				$1[$k[--$j]] = _g; /*12993*/
				$k[$j++] = "mscs"; /*12996*/
				$k[$j++] = Infinity; /*12996*/
				$aload($1.msbs); /*12995*/
				var _j = $k[--$j]; /*12995*/
				var _k = $k[--$j]; /*12995*/
				var _l = $k[--$j]; /*12995*/
				$k[$j++] = (_j + (_k * 256)) + (_l * 65536); /*12996*/
				for (var _m = 0, _n = 3; _m < _n; _m++) { /*12996*/
					var _o = $k[--$j]; /*12996*/
					$k[$j++] = _o % 900; /*12996*/
					$k[$j++] = ~~(_o / 900); /*12996*/
				} /*12996*/
				var _p = $a(); /*12996*/
				$1[$k[--$j]] = _p; /*12997*/
				$k[$j++] = "lsbs"; /*12998*/
				$k[$j++] = Infinity; /*12998*/
				$aload($geti($1.in, ($1.k * 6) + 3, 3)); /*12998*/
				var _u = $a(); /*12998*/
				$1[$k[--$j]] = _u; /*12998*/
				$k[$j++] = "lscs"; /*13001*/
				$k[$j++] = Infinity; /*13001*/
				$aload($1.lsbs); /*13000*/
				var _x = $k[--$j]; /*13000*/
				var _y = $k[--$j]; /*13000*/
				var _z = $k[--$j]; /*13000*/
				$k[$j++] = (_x + (_y * 256)) + (_z * 65536); /*13001*/
				for (var _10 = 0, _11 = 3; _10 < _11; _10++) { /*13001*/
					var _12 = $k[--$j]; /*13001*/
					$k[$j++] = _12 % 900; /*13001*/
					$k[$j++] = ~~(_12 / 900); /*13001*/
				} /*13001*/
				var _13 = $a(); /*13001*/
				$1[$k[--$j]] = _13; /*13002*/
				var _16 = $get($1.lscs, 0); /*13003*/
				var _18 = $get($1.mscs, 0); /*13003*/
				$put($1.out, ($1.k * 5) + 4, (_16 + (_18 * 316)) % 900); /*13004*/
				var _1C = $get($1.lscs, 1); /*13005*/
				var _1E = $get($1.mscs, 0); /*13005*/
				var _1G = $get($1.mscs, 1); /*13005*/
				$put($1.out, ($1.k * 5) + 3, ((((~~((_16 + (_18 * 316)) / 900)) + _1C) + (_1E * 641)) + (_1G * 316)) % 900); /*13006*/
				var _1K = $get($1.lscs, 2); /*13007*/
				var _1M = $get($1.mscs, 0); /*13007*/
				var _1O = $get($1.mscs, 1); /*13007*/
				var _1Q = $get($1.mscs, 2); /*13007*/
				$put($1.out, ($1.k * 5) + 2, (((((~~(((((~~((_16 + (_18 * 316)) / 900)) + _1C) + (_1E * 641)) + (_1G * 316)) / 900)) + _1K) + (_1M * 20)) + (_1O * 641)) + (_1Q * 316)) % 900); /*13008*/
				var _1U = $get($1.lscs, 3); /*13009*/
				var _1W = $get($1.mscs, 1); /*13009*/
				var _1Y = $get($1.mscs, 2); /*13009*/
				$put($1.out, ($1.k * 5) + 1, ((((~~((((((~~(((((~~((_16 + (_18 * 316)) / 900)) + _1C) + (_1E * 641)) + (_1G * 316)) / 900)) + _1K) + (_1M * 20)) + (_1O * 641)) + (_1Q * 316)) / 900)) + _1U) + (_1W * 20)) + (_1Y * 641)) % 900); /*13010*/
				$put($1.out, $1.k * 5, ((~~(((((~~((((((~~(((((~~((_16 + (_18 * 316)) / 900)) + _1C) + (_1E * 641)) + (_1G * 316)) / 900)) + _1K) + (_1M * 20)) + (_1O * 641)) + (_1Q * 316)) / 900)) + _1U) + (_1W * 20)) + (_1Y * 641)) / 900)) + ($get($1.mscs, 2) * 20)) % 900); /*13012*/
			} /*13012*/
			$1.rem = $1.inlen % 6; /*13014*/
			if ($1.rem != 0) { /*13019*/
				$k[$j++] = $1.out; /*13017*/
				$k[$j++] = $1.out.length - $1.rem; /*13017*/
				$k[$j++] = Infinity; /*13017*/
				$aload($geti($1.in, $1.inlen - $1.rem, $1.rem)); /*13017*/
				var _1p = $a(); /*13017*/
				var _1q = $k[--$j]; /*13018*/
				$puti($k[--$j], _1q, _1p); /*13018*/
			} /*13018*/
			$k[$j++] = $1.out; /*13020*/
		}; /*13021*/
		if ($eq($1.encoding, "byte") || $eq($1.encoding, "ccc")) { /*13028*/
			$1.datcws = $a((((~~($1.barlen / 6)) * 5) + ($1.barlen % 6)) + 1); /*13024*/
			var _20 = (($1.barlen % 6) == 0) ? 924 : 901; /*13025*/
			$put($1.datcws, 0, _20); /*13025*/
			$k[$j++] = $1.datcws; /*13026*/
			$k[$j++] = 1; /*13026*/
			$k[$j++] = $1.barcode; /*13026*/
			$1.encb(); /*13026*/
			var _23 = $k[--$j]; /*13026*/
			var _24 = $k[--$j]; /*13026*/
			$puti($k[--$j], _24, _23); /*13026*/
			if ($eq($1.encoding, "ccc")) { /*13027*/
				$k[$j++] = "datcws"; /*13027*/
				$k[$j++] = Infinity; /*13027*/
				$k[$j++] = 920; /*13027*/
				$aload($1.datcws); /*13027*/
				var _28 = $a(); /*13027*/
				$1[$k[--$j]] = _28; /*13027*/
			} /*13027*/
		} /*13027*/
		if ($eq($1.encoding, "auto")) { /*13392*/
			$1.T = 0; /*13033*/
			$1.N = 1; /*13033*/
			$1.B = 2; /*13033*/
			$1.A = 0; /*13034*/
			$1.L = 1; /*13034*/
			$1.M = 2; /*13034*/
			$1.P = 3; /*13034*/
			$1.tl = -1; /*13037*/
			$1.nl = -2; /*13037*/
			$1.bl = -3; /*13037*/
			$1.bl6 = -4; /*13037*/
			$1.bs = -5; /*13037*/
			$1.al = -6; /*13040*/
			$1.ll = -7; /*13040*/
			$1.ml = -8; /*13040*/
			$1.pl = -9; /*13040*/
			$1.as = -10; /*13040*/
			$1.ps = -11; /*13040*/
			$1.charmaps = $a([$a(["A", "a", "0", ";"]), $a(["B", "b", "1", "<"]), $a(["C", "c", "2", ">"]), $a(["D", "d", "3", "@"]), $a(["E", "e", "4", "["]), $a(["F", "f", "5", 92]), $a(["G", "g", "6", "]"]), $a(["H", "h", "7", "_"]), $a(["I", "i", "8", "`"]), $a(["J", "j", "9", "~"]), $a(["K", "k", "&", "!"]), $a(["L", "l", 13, 13]), $a(["M", "m", 9, 9]), $a(["N", "n", ",", ","]), $a(["O", "o", ":", ":"]), $a(["P", "p", "#", 10]), $a(["Q", "q", "-", "-"]), $a(["R", "r", ".", "."]), $a(["S", "s", "$", "$"]), $a(["T", "t", "/", "/"]), $a(["U", "u", "+", "\""]), $a(["V", "v", "%", "|"]), $a(["W", "w", "*", "*"]), $a(["X", "x", "=", 40]), $a(["Y", "y", "^", 41]), $a(["Z", "z", $1.pl, "?"]), $a([" ", " ", " ", "{"]), $a([$1.ll, $1.as, $1.ll, "}"]), $a([$1.ml, $1.ml, $1.al, "'"]), $a([$1.ps, $1.ps, $1.ps, $1.al])]); /*13075*/
			$1.charvals = $a([{}, {}, {}, {}]); /*13078*/
			$1.alltext = {}; /*13079*/
			for (var _2u = 0, _2t = $1.charmaps.length - 1; _2u <= _2t; _2u += 1) { /*13089*/
				$1.i = _2u; /*13081*/
				$1.encs = $get($1.charmaps, $1.i); /*13082*/
				for (var _2y = 0; _2y <= 3; _2y += 1) { /*13088*/
					$1.j = _2y; /*13084*/
					var _31 = $get($1.encs, $1.j); /*13085*/
					$k[$j++] = _31; /*13085*/
					if ($eq($type(_31), "stringtype")) { /*13085*/
						var _34 = $get($k[--$j], 0); /*13085*/
						$k[$j++] = _34; /*13085*/
					} /*13085*/
					var _35 = $k[--$j]; /*13086*/
					$put($get($1.charvals, $1.j), _35, $1.i); /*13086*/
					$put($1.alltext, _35, -1); /*13087*/
				} /*13087*/
			} /*13087*/
			$1.e = 10000; /*13091*/
			$1.latlen = $a([$a([0, 1, 1, 2]), $a([2, 0, 1, 2]), $a([1, 1, 0, 1]), $a([1, 2, 2, 0])]); /*13099*/
			$1.latseq = $a([$a([$a([]), $a([$1.ll]), $a([$1.ml]), $a([$1.ml, $1.pl])]), $a([$a([$1.ml, $1.al]), $a([]), $a([$1.ml]), $a([$1.ml, $1.pl])]), $a([$a([$1.al]), $a([$1.ll]), $a([]), $a([$1.pl])]), $a([$a([$1.al]), $a([$1.al, $1.ll]), $a([$1.al, $1.ml]), $a([])])]); /*13107*/
			$1.shftlen = $a([$a([$1.e, $1.e, $1.e, 1]), $a([1, $1.e, $1.e, 1]), $a([$1.e, $1.e, $1.e, 1]), $a([$1.e, $1.e, $1.e, $1.e])]); /*13115*/
			$k[$j++] = "numdigits"; /*13118*/
			$k[$j++] = Infinity; /*13118*/
			for (var _4A = 0, _4B = $1.barlen; _4A < _4B; _4A++) { /*13118*/
				$k[$j++] = 0; /*13118*/
			} /*13118*/
			$k[$j++] = 0; /*13118*/
			var _4C = $a(); /*13118*/
			$1[$k[--$j]] = _4C; /*13118*/
			$k[$j++] = "numtext"; /*13119*/
			$k[$j++] = Infinity; /*13119*/
			for (var _4F = 0, _4G = $1.barlen; _4F < _4G; _4F++) { /*13119*/
				$k[$j++] = 0; /*13119*/
			} /*13119*/
			$k[$j++] = 0; /*13119*/
			var _4H = $a(); /*13119*/
			$1[$k[--$j]] = _4H; /*13119*/
			$k[$j++] = "numbytes"; /*13120*/
			$k[$j++] = Infinity; /*13120*/
			for (var _4K = 0, _4L = $1.barlen; _4K < _4L; _4K++) { /*13120*/
				$k[$j++] = 0; /*13120*/
			} /*13120*/
			$k[$j++] = 0; /*13120*/
			var _4M = $a(); /*13120*/
			$1[$k[--$j]] = _4M; /*13120*/
			for (var _4P = $1.barlen - 1; _4P >= 0; _4P -= 1) { /*13132*/
				$1.i = _4P; /*13122*/
				var _4S = $get($1.barcode, $1.i); /*13123*/
				if ((_4S >= 48) && (_4S <= 57)) { /*13125*/
					$put($1.numdigits, $1.i, $get($1.numdigits, $1.i + 1) + 1); /*13124*/
				} /*13124*/
				var _4c = $get($1.alltext, $get($1.barcode, $1.i)) !== undefined; /*13126*/
				if (_4c && ($get($1.numdigits, $1.i) < 13)) { /*13128*/
					$put($1.numtext, $1.i, $get($1.numtext, $1.i + 1) + 1); /*13127*/
				} /*13127*/
				if (($get($1.numtext, $1.i) < 5) && ($get($1.numdigits, $1.i) < 13)) { /*13131*/
					$put($1.numbytes, $1.i, $get($1.numbytes, $1.i + 1) + 1); /*13130*/
				} /*13130*/
			} /*13130*/
			$1.numdigits = $geti($1.numdigits, 0, $1.barlen); /*13133*/
			$1.numtext = $geti($1.numtext, 0, $1.barlen); /*13134*/
			$1.numbytes = $geti($1.numbytes, 0, $1.barlen); /*13135*/
			$1.seq = $a([]); /*13137*/
			$1.seqlen = 0; /*13137*/
			$1.state = $1.T; /*13137*/
			$1.p = 0; /*13137*/
			for (;;) { /*13180*/
				if ($1.p == $1.barlen) { /*13138*/
					break; /*13138*/
				} /*13138*/
				$1.n = $get($1.numdigits, $1.p); /*13139*/
				if ($1.n >= 13) { /*13178*/
					$k[$j++] = "seq"; /*13144*/
					$k[$j++] = Infinity; /*13144*/
					$aload($1.seq); /*13142*/
					$k[$j++] = $1.nl; /*13144*/
					$k[$j++] = Infinity; /*13144*/
					$aload($geti($1.barcode, $1.p, $1.n)); /*13144*/
					var _5J = $a(); /*13144*/
					$k[$j++] = _5J; /*13144*/
					var _5K = $a(); /*13144*/
					$1[$k[--$j]] = _5K; /*13145*/
					$1.state = $1.N; /*13146*/
					$1.p = $1.p + $1.n; /*13147*/
					$1.seqlen = ($1.seqlen + 1) + $1.n; /*13148*/
				} else { /*13178*/
					$1.t = $get($1.numtext, $1.p); /*13150*/
					if ($1.t >= 5) { /*13178*/
						$k[$j++] = "seq"; /*13155*/
						$k[$j++] = Infinity; /*13155*/
						$aload($1.seq); /*13153*/
						if ($1.state != $1.T) { /*13154*/
							$k[$j++] = $1.tl; /*13154*/
						} /*13154*/
						$k[$j++] = Infinity; /*13155*/
						$aload($geti($1.barcode, $1.p, $1.t)); /*13155*/
						var _5d = $a(); /*13155*/
						$k[$j++] = _5d; /*13155*/
						var _5e = $a(); /*13155*/
						$1[$k[--$j]] = _5e; /*13156*/
						$1.state = $1.T; /*13157*/
						$1.p = $1.p + $1.t; /*13158*/
						$1.seqlen = ($1.seqlen + 1) + $1.t; /*13159*/
					} else { /*13178*/
						$1.b = $get($1.numbytes, $1.p); /*13161*/
						if (($1.b == 1) && ($1.state == $1.T)) { /*13178*/
							$k[$j++] = "seq"; /*13166*/
							$k[$j++] = Infinity; /*13166*/
							$aload($1.seq); /*13164*/
							$k[$j++] = $1.bs; /*13166*/
							$k[$j++] = $a([$get($1.barcode, $1.p)]); /*13166*/
							var _5x = $a(); /*13166*/
							$1[$k[--$j]] = _5x; /*13167*/
							$1.p = $1.p + $1.b; /*13168*/
							$1.seqlen = $1.seqlen + 2; /*13169*/
						} else { /*13178*/
							$k[$j++] = "seq"; /*13174*/
							$k[$j++] = Infinity; /*13174*/
							$aload($1.seq); /*13172*/
							if (($1.b % 6) != 0) { /*13173*/
								$k[$j++] = $1.bl; /*13173*/
							} else { /*13173*/
								$k[$j++] = $1.bl6; /*13173*/
							} /*13173*/
							$k[$j++] = Infinity; /*13174*/
							$aload($geti($1.barcode, $1.p, $1.b)); /*13174*/
							var _6A = $a(); /*13174*/
							$k[$j++] = _6A; /*13174*/
							var _6B = $a(); /*13174*/
							$1[$k[--$j]] = _6B; /*13175*/
							$1.state = $1.B; /*13176*/
							$1.p = $1.p + $1.b; /*13177*/
							$1.seqlen = ($1.seqlen + 1) + $1.b; /*13178*/
						} /*13178*/
					} /*13178*/
				} /*13178*/
			} /*13178*/
			$k[$j++] = "latchcws"; /*13183*/
			$k[$j++] = Infinity; /*13183*/
			$k[$j++] = $1.tl; /*13183*/
			$k[$j++] = 900; /*13183*/
			$k[$j++] = $1.bl; /*13183*/
			$k[$j++] = 901; /*13183*/
			$k[$j++] = $1.bl6; /*13183*/
			$k[$j++] = 924; /*13183*/
			$k[$j++] = $1.nl; /*13183*/
			$k[$j++] = 902; /*13183*/
			$k[$j++] = $1.bs; /*13183*/
			$k[$j++] = 913; /*13183*/
			var _6N = $d(); /*13183*/
			$1[$k[--$j]] = _6N; /*13184*/
			$1.enca = function() {
				var _6T = $get($get($1.charvals, $1.A), $k[--$j]); /*13187*/
				$k[$j++] = _6T; /*13187*/
			}; /*13187*/
			$1.encl = function() {
				var _6Y = $get($get($1.charvals, $1.L), $k[--$j]); /*13188*/
				$k[$j++] = _6Y; /*13188*/
			}; /*13188*/
			$1.encm = function() {
				var _6d = $get($get($1.charvals, $1.M), $k[--$j]); /*13189*/
				$k[$j++] = _6d; /*13189*/
			}; /*13189*/
			$1.encp = function() {
				var _6i = $get($get($1.charvals, $1.P), $k[--$j]); /*13190*/
				$k[$j++] = _6i; /*13190*/
			}; /*13190*/
			$1.textencfuncs = $a(["enca", "encl", "encm", "encp"]); /*13191*/
			$1.addtotext = function() {
				$put($1.text, $1.l, $k[--$j]); /*13194*/
				$1.l = $1.l + 1; /*13195*/
			}; /*13196*/
			$1.enct = function() {
				$1.in = $k[--$j]; /*13200*/
				$1.curlen = $a([$1.e, $1.e, $1.e, $1.e]); /*13202*/
				$put($1.curlen, $1.submode, 0); /*13203*/
				$1.curseq = $a([$a([]), $a([]), $a([]), $a([])]); /*13204*/
				$forall($1.in, function() { /*13274*/
					$1.char = $k[--$j]; /*13209*/
					for (;;) { /*13230*/
						$1.imp = false; /*13213*/
						var _77 = $a([$1.A, $1.L, $1.M, $1.P]); /*13214*/
						for (var _78 = 0, _79 = _77.length; _78 < _79; _78++) { /*13228*/
							$1.x = $get(_77, _78); /*13215*/
							var _7F = $a([$1.A, $1.L, $1.M, $1.P]); /*13216*/
							for (var _7G = 0, _7H = _7F.length; _7G < _7H; _7G++) { /*13227*/
								$1.y = $get(_7F, _7G); /*13217*/
								$1.cost = $get($1.curlen, $1.x) + $get($get($1.latlen, $1.x), $1.y); /*13218*/
								if ($1.cost < $get($1.curlen, $1.y)) { /*13226*/
									$put($1.curlen, $1.y, $1.cost); /*13220*/
									$k[$j++] = $1.curseq; /*13223*/
									$k[$j++] = $1.y; /*13223*/
									$k[$j++] = Infinity; /*13223*/
									$aload($get($1.curseq, $1.x)); /*13222*/
									$aload($get($get($1.latseq, $1.x), $1.y)); /*13223*/
									var _7i = $a(); /*13223*/
									var _7j = $k[--$j]; /*13224*/
									$put($k[--$j], _7j, _7i); /*13224*/
									$1.imp = true; /*13225*/
								} /*13225*/
							} /*13225*/
						} /*13225*/
						if (!$1.imp) { /*13229*/
							break; /*13229*/
						} /*13229*/
					} /*13229*/
					$1.nxtlen = $a([$1.e, $1.e, $1.e, $1.e]); /*13233*/
					$1.nxtseq = $a(4); /*13234*/
					var _7w = $a([$1.A, $1.L, $1.M, $1.P]); /*13236*/
					for (var _7x = 0, _7y = _7w.length; _7x < _7y; _7x++) { /*13269*/
						$1.x = $get(_7w, _7x); /*13237*/
						for (;;) { /*13267*/
							var _84 = $get($get($1.charvals, $1.x), $1.char) !== undefined; /*13241*/
							if (!_84) { /*13241*/
								break; /*13241*/
							} /*13241*/
							$1.cost = $get($1.curlen, $1.x) + 1; /*13244*/
							if ($1.cost < $get($1.nxtlen, $1.x)) { /*13248*/
								$put($1.nxtlen, $1.x, $1.cost); /*13246*/
								$k[$j++] = $1.nxtseq; /*13247*/
								$k[$j++] = $1.x; /*13247*/
								$k[$j++] = Infinity; /*13247*/
								$aload($get($1.curseq, $1.x)); /*13247*/
								$k[$j++] = $1.char; /*13247*/
								var _8L = $a(); /*13247*/
								var _8M = $k[--$j]; /*13247*/
								$put($k[--$j], _8M, _8L); /*13247*/
							} /*13247*/
							var _8S = $a([$1.A, $1.L, $1.M, $1.P]); /*13251*/
							for (var _8T = 0, _8U = _8S.length; _8T < _8U; _8T++) { /*13264*/
								$1.y = $get(_8S, _8T); /*13252*/
								if ($ne($1.x, $1.y)) { /*13263*/
									$1.cost = ($get($1.curlen, $1.y) + $get($get($1.shftlen, $1.y), $1.x)) + 1; /*13254*/
									if ($1.cost < $get($1.nxtlen, $1.y)) { /*13262*/
										$put($1.nxtlen, $1.y, $1.cost); /*13256*/
										$k[$j++] = $1.nxtseq; /*13260*/
										$k[$j++] = $1.y; /*13260*/
										$k[$j++] = Infinity; /*13260*/
										$aload($get($1.curseq, $1.y)); /*13258*/
										if ($1.x == $1.A) { /*13259*/
											$k[$j++] = $1.as; /*13259*/
										} else { /*13259*/
											$k[$j++] = $1.ps; /*13259*/
										} /*13259*/
										$k[$j++] = $1.char; /*13260*/
										var _8x = $a(); /*13260*/
										var _8y = $k[--$j]; /*13261*/
										$put($k[--$j], _8y, _8x); /*13261*/
									} /*13261*/
								} /*13261*/
							} /*13261*/
							break; /*13266*/
						} /*13266*/
					} /*13266*/
					$1.curlen = $1.nxtlen; /*13271*/
					$1.curseq = $1.nxtseq; /*13272*/
				}) /*13272*/
				$1.minseq = $1.e; /*13277*/
				var _97 = $a([$1.A, $1.L, $1.M, $1.P]); /*13278*/
				for (var _98 = 0, _99 = _97.length; _98 < _99; _98++) { /*13284*/
					$1.k = $get(_97, _98); /*13279*/
					if ($get($1.curlen, $1.k) < $1.minseq) { /*13283*/
						$1.minseq = $get($1.curlen, $1.k); /*13281*/
						$1.txtseq = $get($1.curseq, $1.k); /*13282*/
					} /*13282*/
				} /*13282*/
				$1.text = $a($1.minseq); /*13287*/
				$1.k = 0; /*13288*/
				$1.l = 0; /*13288*/
				for (;;) { /*13308*/
					if ($1.k >= $1.txtseq.length) { /*13289*/
						break; /*13289*/
					} /*13289*/
					$1.char = $get($1.txtseq, $1.k); /*13291*/
					$k[$j++] = $1.char; /*13294*/
					$1[$get($1.textencfuncs, $1.submode)](); /*13294*/
					$1.addtotext(); /*13294*/
					$1.k = $1.k + 1; /*13295*/
					if (($1.char == $1.as) || ($1.char == $1.ps)) { /*13301*/
						$k[$j++] = $get($1.txtseq, $1.k); /*13299*/
						if ($1.char == $1.as) { /*13299*/
							$1.enca(); /*13299*/
						} else { /*13299*/
							$1.encp(); /*13299*/
						} /*13299*/
						$1.addtotext(); /*13299*/
						$1.k = $1.k + 1; /*13300*/
					} /*13300*/
					if ($1.char == $1.al) { /*13304*/
						$1.submode = $1.A; /*13304*/
					} /*13304*/
					if ($1.char == $1.ll) { /*13305*/
						$1.submode = $1.L; /*13305*/
					} /*13305*/
					if ($1.char == $1.ml) { /*13306*/
						$1.submode = $1.M; /*13306*/
					} /*13306*/
					if ($1.char == $1.pl) { /*13307*/
						$1.submode = $1.P; /*13307*/
					} /*13307*/
				} /*13307*/
				if (($1.text.length % 2) == 1) { /*13318*/
					if ($1.submode == $1.P) { /*13315*/
						$k[$j++] = "pad"; /*13312*/
						$k[$j++] = $1.al; /*13312*/
						$1.encp(); /*13312*/
						var _9y = $k[--$j]; /*13312*/
						$1[$k[--$j]] = _9y; /*13312*/
						$1.submode = $1.A; /*13313*/
					} else { /*13315*/
						$k[$j++] = "pad"; /*13315*/
						$k[$j++] = $1.ps; /*13315*/
						$1[$get($1.textencfuncs, $1.submode)](); /*13315*/
						var _A6 = $k[--$j]; /*13315*/
						$1[$k[--$j]] = _A6; /*13315*/
					} /*13315*/
					$k[$j++] = "text"; /*13317*/
					$k[$j++] = Infinity; /*13317*/
					$aload($1.text); /*13317*/
					$k[$j++] = $1.pad; /*13317*/
					var _AA = $a(); /*13317*/
					$1[$k[--$j]] = _AA; /*13317*/
				} /*13317*/
				$1.out = $a(~~($1.text.length / 2)); /*13320*/
				for (var _AG = 0, _AF = $1.out.length - 1; _AG <= _AF; _AG += 1) { /*13324*/
					$1.k = _AG; /*13322*/
					$put($1.out, $1.k, ($get($1.text, $1.k * 2) * 30) + $get($1.text, ($1.k * 2) + 1)); /*13323*/
				} /*13323*/
				$k[$j++] = $1.out; /*13326*/
			}; /*13328*/
			$1.encn = function() {
				$1.in = $k[--$j]; /*13331*/
				$1.out = $a([]); /*13332*/
				for (var _AU = 0, _AT = $1.in.length - 1; _AU <= _AT; _AU += 44) { /*13360*/
					$1.k = _AU; /*13334*/
					$k[$j++] = "gmod"; /*13337*/
					$k[$j++] = Infinity; /*13337*/
					var _AZ = $1.in.length - $1.k; /*13336*/
					$k[$j++] = 1; /*13336*/
					$k[$j++] = $1.in; /*13336*/
					$k[$j++] = $1.k; /*13336*/
					$k[$j++] = _AZ; /*13336*/
					if (_AZ > 44) { /*13336*/
						$j--; /*13336*/
						$k[$j++] = 44; /*13336*/
					} /*13336*/
					var _Aa = $k[--$j]; /*13336*/
					var _Ab = $k[--$j]; /*13336*/
					$forall($geti($k[--$j], _Ab, _Aa), function() { /*13337*/
						var _Ae = $k[--$j]; /*13337*/
						$k[$j++] = _Ae - 48; /*13337*/
					}) /*13337*/
					var _Af = $a(); /*13337*/
					$1[$k[--$j]] = _Af; /*13338*/
					$1.cwn = $a([]); /*13339*/
					for (;;) { /*13358*/
						$1.dv = 900; /*13340*/
						$1.gmul = $a([]); /*13341*/
						$1.val = 0; /*13341*/
						for (;;) { /*13353*/
							if ($1.gmod.length == 0) { /*13342*/
								break; /*13342*/
							} /*13342*/
							$1.val = ($1.val * 10) + $get($1.gmod, 0); /*13343*/
							$1.gmod = $geti($1.gmod, 1, $1.gmod.length - 1); /*13344*/
							if ($1.val < $1.dv) { /*13350*/
								if ($1.gmul.length != 0) { /*13348*/
									$k[$j++] = "gmul"; /*13347*/
									$k[$j++] = Infinity; /*13347*/
									$aload($1.gmul); /*13347*/
									$k[$j++] = 0; /*13347*/
									var _Au = $a(); /*13347*/
									$1[$k[--$j]] = _Au; /*13347*/
								} /*13347*/
							} else { /*13350*/
								$k[$j++] = "gmul"; /*13350*/
								$k[$j++] = Infinity; /*13350*/
								$aload($1.gmul); /*13350*/
								$k[$j++] = ~~($1.val / $1.dv); /*13350*/
								var _Az = $a(); /*13350*/
								$1[$k[--$j]] = _Az; /*13350*/
							} /*13350*/
							$1.val = $1.val % $1.dv; /*13352*/
						} /*13352*/
						$1.dv = $1.val; /*13354*/
						$k[$j++] = "cwn"; /*13355*/
						$k[$j++] = Infinity; /*13355*/
						$k[$j++] = $1.dv; /*13355*/
						$aload($1.cwn); /*13355*/
						var _B6 = $a(); /*13355*/
						$1[$k[--$j]] = _B6; /*13355*/
						$1.gmod = $1.gmul; /*13356*/
						if ($1.gmul.length == 0) { /*13357*/
							break; /*13357*/
						} /*13357*/
					} /*13357*/
					$k[$j++] = "out"; /*13359*/
					$k[$j++] = Infinity; /*13359*/
					$aload($1.out); /*13359*/
					$aload($1.cwn); /*13359*/
					var _BC = $a(); /*13359*/
					$1[$k[--$j]] = _BC; /*13359*/
				} /*13359*/
				$k[$j++] = $1.out; /*13361*/
			}; /*13362*/
			$1.encfuncs = $a(["enct", "encn", "encb"]); /*13364*/
			$1.addtocws = function() {
				var _BG = $k[--$j]; /*13367*/
				$puti($1.datcws, $1.j, _BG); /*13367*/
				$1.j = _BG.length + $1.j; /*13368*/
			}; /*13369*/
			$1.state = $1.T; /*13372*/
			$1.submode = $1.A; /*13372*/
			$1.datcws = $a($1.seqlen); /*13373*/
			$1.i = 0; /*13374*/
			$1.j = 0; /*13374*/
			for (;;) { /*13390*/
				if ($1.i >= $1.seq.length) { /*13375*/
					break; /*13375*/
				} /*13375*/
				$1.chars = $get($1.seq, $1.i); /*13376*/
				if ($eq($type($1.chars), "arraytype")) { /*13386*/
					$k[$j++] = $1.chars; /*13378*/
					$1[$get($1.encfuncs, $1.state)](); /*13378*/
					$1.addtocws(); /*13378*/
				} else { /*13386*/
					$k[$j++] = $a([$get($1.latchcws, $1.chars)]); /*13380*/
					$1.addtocws(); /*13380*/
					if ($1.chars == $1.tl) { /*13381*/
						$1.state = $1.T; /*13381*/
						$1.submode = $1.A; /*13381*/
					} /*13381*/
					if ($1.chars == $1.nl) { /*13382*/
						$1.state = $1.N; /*13382*/
					} /*13382*/
					if (($1.chars == $1.bl) || ($1.chars == $1.bl6)) { /*13383*/
						$1.state = $1.B; /*13383*/
					} /*13383*/
					if ($1.chars == $1.bs) { /*13387*/
						$1.i = $1.i + 1; /*13385*/
						$k[$j++] = $get($1.seq, $1.i); /*13386*/
						$1.encb(); /*13386*/
						$1.addtocws(); /*13386*/
					} /*13386*/
				} /*13386*/
				$1.i = $1.i + 1; /*13389*/
			} /*13389*/
			$1.datcws = $geti($1.datcws, 0, $1.j); /*13391*/
		} /*13391*/
		$1.m = $1.datcws.length; /*13395*/
		if ($1.eclevel == -1) { /*13401*/
			if ($1.m <= 40) { /*13397*/
				$1.eclevel = 2; /*13397*/
			} /*13397*/
			if (($1.m >= 41) && ($1.m <= 160)) { /*13398*/
				$1.eclevel = 3; /*13398*/
			} /*13398*/
			if (($1.m >= 161) && ($1.m <= 320)) { /*13399*/
				$1.eclevel = 4; /*13399*/
			} /*13399*/
			if ($1.m >= 321) { /*13400*/
				$1.eclevel = 5; /*13400*/
			} /*13400*/
		} /*13400*/
		$1.maxeclevel = (~~((Math.log((928 - 1) - $1.m)) / Math.log(2))) - 1; /*13404*/
		if ($1.eclevel > $1.maxeclevel) { /*13405*/
			$1.eclevel = $1.maxeclevel; /*13405*/
		} /*13405*/
		$1.k = ~~Math.pow(2, $1.eclevel + 1); /*13406*/
		if ($1.columns == 0) { /*13409*/
			$1.columns = ~~(Math.round(Math.sqrt(($1.m + $1.k) / 3))); /*13409*/
		} /*13409*/
		if (($1.columns >= 1) && ($1.columns <= 30)) { /*13410*/
			$1.c = $1.columns; /*13410*/
		} /*13410*/
		$1.r = ~~(Math.ceil((($1.m + $1.k) + 1) / $1.columns)); /*13413*/
		if (($1.r < $1.rows) && ($1.rows <= 90)) { /*13414*/
			$1.r = $1.rows; /*13414*/
		} /*13414*/
		if ($1.r < 3) { /*13415*/
			$1.r = 3; /*13415*/
		} /*13415*/
		var _CR = $1.c; /*13418*/
		var _CS = $1.r; /*13418*/
		var _CT = $1.m; /*13418*/
		var _CU = 8; /*13418*/
		var _CV = (~~((Math.log(((_CR * _CS) - 1) - _CT)) / Math.log(2))) - 1; /*13418*/
		if (((~~((Math.log(((_CR * _CS) - 1) - _CT)) / Math.log(2))) - 1) > 8) { /*13418*/
			var _ = _CU; /*13418*/
			_CU = _CV; /*13418*/
			_CV = _; /*13418*/
		} /*13418*/
		$1.maxeclevel = _CV; /*13418*/
		if ($1.maxeclevel > $1.eclevel) { /*13422*/
			$1.eclevel = $1.maxeclevel; /*13420*/
			$1.k = ~~Math.pow(2, $1.eclevel + 1); /*13421*/
		} /*13421*/
		$1.n = ($1.c * $1.r) - $1.k; /*13425*/
		$1.cws = $a(($1.c * $1.r) + 1); /*13426*/
		$put($1.cws, 0, $1.n); /*13427*/
		$puti($1.cws, 1, $1.datcws); /*13428*/
		$k[$j++] = $1.cws; /*13429*/
		$k[$j++] = $1.m + 1; /*13429*/
		$k[$j++] = Infinity; /*13429*/
		for (var _Co = 0, _Cp = ($1.n - $1.m) - 1; _Co < _Cp; _Co++) { /*13429*/
			$k[$j++] = 900; /*13429*/
		} /*13429*/
		var _Cq = $a(); /*13429*/
		var _Cr = $k[--$j]; /*13429*/
		$puti($k[--$j], _Cr, _Cq); /*13429*/
		$k[$j++] = $1.cws; /*13430*/
		$k[$j++] = $1.n; /*13430*/
		$k[$j++] = Infinity; /*13430*/
		for (var _Cw = 0, _Cx = $1.k; _Cw < _Cx; _Cw++) { /*13430*/
			$k[$j++] = 0; /*13430*/
		} /*13430*/
		$k[$j++] = 0; /*13430*/
		var _Cy = $a(); /*13430*/
		var _Cz = $k[--$j]; /*13430*/
		$puti($k[--$j], _Cz, _Cy); /*13430*/
		$k[$j++] = "rsalog"; /*13433*/
		$k[$j++] = Infinity; /*13433*/
		$k[$j++] = 1; /*13433*/
		for (var _D1 = 0, _D2 = 928; _D1 < _D2; _D1++) { /*13433*/
			var _D3 = $k[--$j]; /*13433*/
			$k[$j++] = _D3; /*13433*/
			$k[$j++] = (_D3 * 3) % 929; /*13433*/
		} /*13433*/
		var _D4 = $a(); /*13433*/
		$1[$k[--$j]] = _D4; /*13433*/
		$1.rslog = $a(929); /*13434*/
		for (var _D7 = 1; _D7 <= 928; _D7 += 1) { /*13435*/
			$put($1.rslog, $get($1.rsalog, _D7), _D7); /*13435*/
		} /*13435*/
		$1.rsprod = function() {
			var _DB = $k[--$j]; /*13439*/
			var _DC = $k[--$j]; /*13439*/
			$k[$j++] = _DC; /*13443*/
			$k[$j++] = _DB; /*13443*/
			if ((_DB != 0) && (_DC != 0)) { /*13442*/
				var _DF = $get($1.rslog, $k[--$j]); /*13440*/
				var _DK = $get($1.rsalog, (_DF + $get($1.rslog, $k[--$j])) % 928); /*13440*/
				$k[$j++] = _DK; /*13440*/
			} else { /*13442*/
				$j -= 2; /*13442*/
				$k[$j++] = 0; /*13442*/
			} /*13442*/
		}; /*13444*/
		$k[$j++] = "coeffs"; /*13447*/
		$k[$j++] = Infinity; /*13447*/
		$k[$j++] = 1; /*13447*/
		for (var _DM = 0, _DN = $1.k; _DM < _DN; _DM++) { /*13447*/
			$k[$j++] = 0; /*13447*/
		} /*13447*/
		var _DO = $a(); /*13447*/
		$1[$k[--$j]] = _DO; /*13447*/
		for (var _DS = 1, _DR = $1.k; _DS <= _DR; _DS += 1) { /*13456*/
			$1.i = _DS; /*13449*/
			$put($1.coeffs, $1.i, $get($1.coeffs, $1.i - 1)); /*13450*/
			for (var _DZ = $1.i - 1; _DZ >= 1; _DZ -= 1) { /*13454*/
				$1.j = _DZ; /*13452*/
				$k[$j++] = $1.coeffs; /*13453*/
				$k[$j++] = $1.j; /*13453*/
				$k[$j++] = $get($1.coeffs, $1.j - 1); /*13453*/
				$k[$j++] = $get($1.coeffs, $1.j); /*13453*/
				$k[$j++] = $get($1.rsalog, $1.i); /*13453*/
				$1.rsprod(); /*13453*/
				var _Dl = $k[--$j]; /*13453*/
				var _Dm = $k[--$j]; /*13453*/
				var _Dn = $k[--$j]; /*13453*/
				$put($k[--$j], _Dn, (_Dm + _Dl) % 929); /*13453*/
			} /*13453*/
			$k[$j++] = $1.coeffs; /*13455*/
			$k[$j++] = 0; /*13455*/
			$k[$j++] = $get($1.coeffs, 0); /*13455*/
			$k[$j++] = $get($1.rsalog, $1.i); /*13455*/
			$1.rsprod(); /*13455*/
			var _Dv = $k[--$j]; /*13455*/
			var _Dw = $k[--$j]; /*13455*/
			$put($k[--$j], _Dw, _Dv); /*13455*/
		} /*13455*/
		$1.coeffs = $geti($1.coeffs, 0, $1.coeffs.length - 1); /*13457*/
		for (var _E2 = $1.coeffs.length - 1; _E2 >= 0; _E2 -= 2) { /*13458*/
			var _E3 = $1.coeffs; /*13458*/
			$put(_E3, _E2, 929 - $get(_E3, _E2)); /*13458*/
		} /*13458*/
		for (var _E7 = 0, _E6 = $1.n - 1; _E7 <= _E6; _E7 += 1) { /*13467*/
			$1.t = ($get($1.cws, _E7) + $get($1.cws, $1.n)) % 929; /*13462*/
			for (var _EF = 0, _EE = $1.k - 1; _EF <= _EE; _EF += 1) { /*13466*/
				$1.j = _EF; /*13464*/
				$put($1.cws, $1.n + $1.j, ($get($1.cws, ($1.n + $1.j) + 1) + (929 - (($1.t * $get($1.coeffs, ($1.k - $1.j) - 1)) % 929))) % 929); /*13465*/
			} /*13465*/
		} /*13465*/
		for (var _EW = $1.n, _EV = $1.n + $1.k; _EW <= _EV; _EW += 1) { /*13468*/
			$put($1.cws, _EW, (929 - $get($1.cws, _EW)) % 929); /*13468*/
		} /*13468*/
		$1.cws = $geti($1.cws, 0, $1.cws.length - 1); /*13471*/
		$1.clusters = $a([$a([120256, 125680, 128380, 120032, 125560, 128318, 108736, 119920, 108640, 86080, 108592, 86048, 110016, 120560, 125820, 109792, 120440, 125758, 88256, 109680, 88160, 89536, 110320, 120700, 89312, 110200, 120638, 89200, 110140, 89840, 110460, 89720, 110398, 89980, 128506, 119520, 125304, 128190, 107712, 119408, 125244, 107616, 119352, 84032, 107568, 119324, 84000, 107544, 83984, 108256, 119672, 125374, 85184, 108144, 119612, 85088, 108088, 119582, 85040, 108060, 85728, 108408, 119742, 85616, 108348, 85560, 108318, 85880, 108478, 85820, 85790, 107200, 119152, 125116, 107104, 119096, 125086, 83008, 107056, 119068, 82976, 107032, 82960, 82952, 83648, 107376, 119228, 83552, 107320, 119198, 83504, 107292, 83480, 83468, 83824, 107452, 83768, 107422, 83740, 83900, 106848, 118968, 125022, 82496, 106800, 118940, 82464, 106776, 118926, 82448, 106764, 82440, 106758, 82784, 106936, 119006, 82736, 106908, 82712, 106894, 82700, 82694, 106974, 82830, 82240, 106672, 118876, 82208, 106648, 118862, 82192, 106636, 82184, 106630, 82180, 82352, 82328, 82316, 82080, 118830, 106572, 106566, 82050, 117472, 124280, 127678, 103616, 117360, 124220, 103520, 117304, 124190, 75840, 103472, 75808, 104160, 117624, 124350, 76992, 104048, 117564, 76896, 103992, 76848, 76824, 77536, 104312, 117694, 77424, 104252, 77368, 77340, 77688, 104382, 77628, 77758, 121536, 126320, 128700, 121440, 126264, 128670, 111680, 121392, 126236, 111648, 121368, 126222, 111632, 121356, 103104, 117104, 124092, 112320, 103008, 117048, 124062, 112224, 121656, 126366, 93248, 74784, 102936, 117006, 93216, 112152, 93200, 75456, 103280, 117180, 93888, 75360, 103224, 117150, 93792, 112440, 121758, 93744, 75288, 93720, 75632, 103356, 94064, 75576, 103326, 94008, 112542, 93980, 75708, 94140, 75678, 94110, 121184, 126136, 128606, 111168, 121136, 126108, 111136, 121112, 126094, 111120, 121100, 111112, 111108, 102752, 116920, 123998, 111456, 102704, 116892, 91712, 74272, 121244, 116878, 91680, 74256, 102668, 91664, 111372, 102662, 74244, 74592, 102840, 116958, 92000, 74544, 102812, 91952, 111516, 102798, 91928, 74508, 74502, 74680, 102878, 92088, 74652, 92060, 74638, 92046, 92126, 110912, 121008, 126044, 110880, 120984, 126030, 110864, 120972, 110856, 120966, 110852, 110850, 74048, 102576, 116828, 90944, 74016, 102552, 116814, 90912, 111000, 121038, 90896, 73992, 102534, 90888, 110982, 90884, 74160, 102620, 91056, 74136, 102606, 91032, 111054, 91020, 74118, 91014, 91100, 91086, 110752, 120920, 125998, 110736, 120908, 110728, 120902, 110724, 110722, 73888, 102488, 116782, 90528, 73872, 102476, 90512, 110796, 102470, 90504, 73860, 90500, 73858, 73944, 90584, 90572, 90566, 120876, 120870, 110658, 102444, 73800, 90312, 90308, 90306, 101056, 116080, 123580, 100960, 116024, 70720, 100912, 115996, 70688, 100888, 70672, 70664, 71360, 101232, 116156, 71264, 101176, 116126, 71216, 101148, 71192, 71180, 71536, 101308, 71480, 101278, 71452, 71612, 71582, 118112, 124600, 127838, 105024, 118064, 124572, 104992, 118040, 124558, 104976, 118028, 104968, 118022, 100704, 115896, 123486, 105312, 100656, 115868, 79424, 70176, 118172, 115854, 79392, 105240, 100620, 79376, 70152, 79368, 70496, 100792, 115934, 79712, 70448, 118238, 79664, 105372, 100750, 79640, 70412, 79628, 70584, 100830, 79800, 70556, 79772, 70542, 70622, 79838, 122176, 126640, 128860, 122144, 126616, 128846, 122128, 126604, 122120, 126598, 122116, 104768, 117936, 124508, 113472, 104736, 126684, 124494, 113440, 122264, 126670, 113424, 104712, 117894, 113416, 122246, 104706, 69952, 100528, 115804, 78656, 69920, 100504, 115790, 96064, 78624, 104856, 117966, 96032, 113560, 122318, 100486, 96016, 78600, 104838, 96008, 69890, 70064, 100572, 78768, 70040, 100558, 96176, 78744, 104910, 96152, 113614, 70022, 78726, 70108, 78812, 70094, 96220, 78798, 122016, 126552, 128814, 122000, 126540, 121992, 126534, 121988, 121986, 104608, 117848, 124462, 113056, 104592, 126574, 113040, 122060, 117830, 113032, 104580, 113028, 104578, 113026, 69792, 100440, 115758, 78240, 69776, 100428, 95136, 78224, 104652, 100422, 95120, 113100, 69764, 95112, 78212, 69762, 78210, 69848, 100462, 78296, 69836, 95192, 78284, 69830, 95180, 78278, 69870, 95214, 121936, 126508, 121928, 126502, 121924, 121922, 104528, 117804, 112848, 104520, 117798, 112840, 121958, 112836, 104514, 112834, 69712, 100396, 78032, 69704, 100390, 94672, 78024, 104550, 94664, 112870, 69698, 94660, 78018, 94658, 78060, 94700, 94694, 126486, 121890, 117782, 104484, 104482, 69672, 77928, 94440, 69666, 77922, 99680, 68160, 99632, 68128, 99608, 115342, 68112, 99596, 68104, 99590, 68448, 99768, 115422, 68400, 99740, 68376, 99726, 68364, 68358, 68536, 99806, 68508, 68494, 68574, 101696, 116400, 123740, 101664, 116376, 101648, 116364, 101640, 116358, 101636, 67904, 99504, 115292, 72512, 67872, 116444, 115278, 72480, 101784, 116430, 72464, 67848, 99462, 72456, 101766, 67842, 68016, 99548, 72624, 67992, 99534, 72600, 101838, 72588, 67974, 68060, 72668, 68046, 72654, 118432, 124760, 127918, 118416, 124748, 118408, 124742, 118404, 118402, 101536, 116312, 105888, 101520, 116300, 105872, 118476, 116294, 105864, 101508, 105860, 101506, 105858, 67744, 99416, 72096, 67728, 116334, 80800, 72080, 101580, 99398, 80784, 105932, 67716, 80776, 72068, 67714, 72066, 67800, 99438, 72152, 67788, 80856, 72140, 67782, 80844, 72134, 67822, 72174, 80878, 126800, 128940, 126792, 128934, 126788, 126786, 118352, 124716, 122576, 126828, 124710, 122568, 126822, 122564, 118338, 122562, 101456, 116268, 105680, 101448, 116262, 114128, 105672, 118374, 114120, 122598, 101442, 114116, 105666, 114114, 67664, 99372, 71888, 67656, 99366, 80336, 71880, 101478, 97232, 80328, 105702, 67650, 97224, 114150, 71874, 97220, 67692, 71916, 67686, 80364, 71910, 97260, 80358, 97254, 126760, 128918, 126756, 126754, 118312, 124694, 122472, 126774, 122468, 118306, 122466, 101416, 116246, 105576, 101412, 113896, 105572, 101410, 113892, 105570, 113890, 67624, 99350, 71784, 101430, 80104, 71780, 67618, 96744, 80100, 71778, 96740, 80098, 96738, 71798, 96758, 126738, 122420, 122418, 105524, 113780, 113778, 71732, 79988, 96500, 96498, 66880, 66848, 98968, 66832, 66824, 66820, 66992, 66968, 66956, 66950, 67036, 67022, 100000, 99984, 115532, 99976, 115526, 99972, 99970, 66720, 98904, 69024, 100056, 98892, 69008, 100044, 69000, 100038, 68996, 66690, 68994, 66776, 98926, 69080, 100078, 69068, 66758, 69062, 66798, 69102, 116560, 116552, 116548, 116546, 99920, 102096, 116588, 115494, 102088, 116582, 102084, 99906, 102082, 66640, 68816, 66632, 98854, 73168, 68808, 66628, 73160, 68804, 66626, 73156, 68802, 66668, 68844, 66662, 73196, 68838, 73190, 124840, 124836, 124834, 116520, 118632, 124854, 118628, 116514, 118626, 99880, 115478, 101992, 116534, 106216, 101988, 99874, 106212, 101986, 106210, 66600, 98838, 68712, 99894, 72936, 68708, 66594, 81384, 72932, 68706, 81380, 72930, 66614, 68726, 72950, 81398, 128980, 128978, 124820, 126900, 124818, 126898, 116500, 118580, 116498, 122740, 118578, 122738, 99860, 101940, 99858, 106100, 101938, 114420]), $a([128352, 129720, 125504, 128304, 129692, 125472, 128280, 129678, 125456, 128268, 125448, 128262, 125444, 125792, 128440, 129758, 120384, 125744, 128412, 120352, 125720, 128398, 120336, 125708, 120328, 125702, 120324, 120672, 125880, 128478, 110144, 120624, 125852, 110112, 120600, 125838, 110096, 120588, 110088, 120582, 110084, 110432, 120760, 125918, 89664, 110384, 120732, 89632, 110360, 120718, 89616, 110348, 89608, 110342, 89952, 110520, 120798, 89904, 110492, 89880, 110478, 89868, 90040, 110558, 90012, 89998, 125248, 128176, 129628, 125216, 128152, 129614, 125200, 128140, 125192, 128134, 125188, 125186, 119616, 125360, 128220, 119584, 125336, 128206, 119568, 125324, 119560, 125318, 119556, 119554, 108352, 119728, 125404, 108320, 119704, 125390, 108304, 119692, 108296, 119686, 108292, 108290, 85824, 108464, 119772, 85792, 108440, 119758, 85776, 108428, 85768, 108422, 85764, 85936, 108508, 85912, 108494, 85900, 85894, 85980, 85966, 125088, 128088, 129582, 125072, 128076, 125064, 128070, 125060, 125058, 119200, 125144, 128110, 119184, 125132, 119176, 125126, 119172, 119170, 107424, 119256, 125166, 107408, 119244, 107400, 119238, 107396, 107394, 83872, 107480, 119278, 83856, 107468, 83848, 107462, 83844, 83842, 83928, 107502, 83916, 83910, 83950, 125008, 128044, 125000, 128038, 124996, 124994, 118992, 125036, 118984, 125030, 118980, 118978, 106960, 119020, 106952, 119014, 106948, 106946, 82896, 106988, 82888, 106982, 82884, 82882, 82924, 82918, 124968, 128022, 124964, 124962, 118888, 124982, 118884, 118882, 106728, 118902, 106724, 106722, 82408, 106742, 82404, 82402, 124948, 124946, 118836, 118834, 106612, 106610, 124224, 127664, 129372, 124192, 127640, 129358, 124176, 127628, 124168, 127622, 124164, 124162, 117568, 124336, 127708, 117536, 124312, 127694, 117520, 124300, 117512, 124294, 117508, 117506, 104256, 117680, 124380, 104224, 117656, 124366, 104208, 117644, 104200, 117638, 104196, 104194, 77632, 104368, 117724, 77600, 104344, 117710, 77584, 104332, 77576, 104326, 77572, 77744, 104412, 77720, 104398, 77708, 77702, 77788, 77774, 128672, 129880, 93168, 128656, 129868, 92664, 128648, 129862, 92412, 128644, 128642, 124064, 127576, 129326, 126368, 124048, 129902, 126352, 128716, 127558, 126344, 124036, 126340, 124034, 126338, 117152, 124120, 127598, 121760, 117136, 124108, 121744, 126412, 124102, 121736, 117124, 121732, 117122, 121730, 103328, 117208, 124142, 112544, 103312, 117196, 112528, 121804, 117190, 112520, 103300, 112516, 103298, 112514, 75680, 103384, 117230, 94112, 75664, 103372, 94096, 112588, 103366, 94088, 75652, 94084, 75650, 75736, 103406, 94168, 75724, 94156, 75718, 94150, 75758, 128592, 129836, 91640, 128584, 129830, 91388, 128580, 91262, 128578, 123984, 127532, 126160, 123976, 127526, 126152, 128614, 126148, 123970, 126146, 116944, 124012, 121296, 116936, 124006, 121288, 126182, 121284, 116930, 121282, 102864, 116972, 111568, 102856, 116966, 111560, 121318, 111556, 102850, 111554, 74704, 102892, 92112, 74696, 102886, 92104, 111590, 92100, 74690, 92098, 74732, 92140, 74726, 92134, 128552, 129814, 90876, 128548, 90750, 128546, 123944, 127510, 126056, 128566, 126052, 123938, 126050, 116840, 123958, 121064, 116836, 121060, 116834, 121058, 102632, 116854, 111080, 121078, 111076, 102626, 111074, 74216, 102646, 91112, 74212, 91108, 74210, 91106, 74230, 91126, 128532, 90494, 128530, 123924, 126004, 123922, 126002, 116788, 120948, 116786, 120946, 102516, 110836, 102514, 110834, 73972, 90612, 73970, 90610, 128522, 123914, 125978, 116762, 120890, 102458, 110714, 123552, 127320, 129198, 123536, 127308, 123528, 127302, 123524, 123522, 116128, 123608, 127342, 116112, 123596, 116104, 123590, 116100, 116098, 101280, 116184, 123630, 101264, 116172, 101256, 116166, 101252, 101250, 71584, 101336, 116206, 71568, 101324, 71560, 101318, 71556, 71554, 71640, 101358, 71628, 71622, 71662, 127824, 129452, 79352, 127816, 129446, 79100, 127812, 78974, 127810, 123472, 127276, 124624, 123464, 127270, 124616, 127846, 124612, 123458, 124610, 115920, 123500, 118224, 115912, 123494, 118216, 124646, 118212, 115906, 118210, 100816, 115948, 105424, 100808, 115942, 105416, 118246, 105412, 100802, 105410, 70608, 100844, 79824, 70600, 100838, 79816, 105446, 79812, 70594, 79810, 70636, 79852, 70630, 79846, 129960, 95728, 113404, 129956, 95480, 113278, 129954, 95356, 95294, 127784, 129430, 78588, 128872, 129974, 95996, 78462, 128868, 127778, 95870, 128866, 123432, 127254, 124520, 123428, 126696, 128886, 123426, 126692, 124514, 126690, 115816, 123446, 117992, 115812, 122344, 117988, 115810, 122340, 117986, 122338, 100584, 115830, 104936, 100580, 113640, 104932, 100578, 113636, 104930, 113634, 70120, 100598, 78824, 70116, 96232, 78820, 70114, 96228, 78818, 96226, 70134, 78838, 129940, 94968, 113022, 129938, 94844, 94782, 127764, 78206, 128820, 127762, 95102, 128818, 123412, 124468, 123410, 126580, 124466, 126578, 115764, 117876, 115762, 122100, 117874, 122098, 100468, 104692, 100466, 113140, 104690, 113138, 69876, 78324, 69874, 95220, 78322, 95218, 129930, 94588, 94526, 127754, 128794, 123402, 124442, 126522, 115738, 117818, 121978, 100410, 104570, 112890, 69754, 78074, 94714, 94398, 123216, 127148, 123208, 127142, 123204, 123202, 115408, 123244, 115400, 123238, 115396, 115394, 99792, 115436, 99784, 115430, 99780, 99778, 68560, 99820, 68552, 99814, 68548, 68546, 68588, 68582, 127400, 129238, 72444, 127396, 72318, 127394, 123176, 127126, 123752, 123172, 123748, 123170, 123746, 115304, 123190, 116456, 115300, 116452, 115298, 116450, 99560, 115318, 101864, 99556, 101860, 99554, 101858, 68072, 99574, 72680, 68068, 72676, 68066, 72674, 68086, 72694, 129492, 80632, 105854, 129490, 80508, 80446, 127380, 72062, 127924, 127378, 80766, 127922, 123156, 123700, 123154, 124788, 123698, 124786, 115252, 116340, 115250, 118516, 116338, 118514, 99444, 101620, 99442, 105972, 101618, 105970, 67828, 72180, 67826, 80884, 72178, 80882, 97008, 114044, 96888, 113982, 96828, 96798, 129482, 80252, 130010, 97148, 80190, 97086, 127370, 127898, 128954, 123146, 123674, 124730, 126842, 115226, 116282, 118394, 122618, 99386, 101498, 105722, 114170, 67706, 71930, 80378, 96632, 113854, 96572, 96542, 80062, 96702, 96444, 96414, 96350, 123048, 123044, 123042, 115048, 123062, 115044, 115042, 99048, 115062, 99044, 99042, 67048, 99062, 67044, 67042, 67062, 127188, 68990, 127186, 123028, 123316, 123026, 123314, 114996, 115572, 114994, 115570, 98932, 100084, 98930, 100082, 66804, 69108, 66802, 69106, 129258, 73084, 73022, 127178, 127450, 123018, 123290, 123834, 114970, 115514, 116602, 98874, 99962, 102138, 66682, 68858, 73210, 81272, 106174, 81212, 81182, 72894, 81342, 97648, 114364, 97592, 114334, 97564, 97550, 81084, 97724, 81054, 97694, 97464, 114270, 97436, 97422, 80990, 97502, 97372, 97358, 97326, 114868, 114866, 98676, 98674, 66292, 66290, 123098, 114842, 115130, 98618, 99194, 66170, 67322, 69310, 73404, 73374, 81592, 106334, 81564, 81550, 73310, 81630, 97968, 114524, 97944, 114510, 97932, 97926, 81500, 98012, 81486, 97998, 97880, 114478, 97868, 97862, 81454, 97902, 97836, 97830, 69470, 73564, 73550, 81752, 106414, 81740, 81734, 73518, 81774, 81708, 81702]), $a([109536, 120312, 86976, 109040, 120060, 86496, 108792, 119934, 86256, 108668, 86136, 129744, 89056, 110072, 129736, 88560, 109820, 129732, 88312, 109694, 129730, 88188, 128464, 129772, 89592, 128456, 129766, 89340, 128452, 89214, 128450, 125904, 128492, 125896, 128486, 125892, 125890, 120784, 125932, 120776, 125926, 120772, 120770, 110544, 120812, 110536, 120806, 110532, 84928, 108016, 119548, 84448, 107768, 119422, 84208, 107644, 84088, 107582, 84028, 129640, 85488, 108284, 129636, 85240, 108158, 129634, 85116, 85054, 128232, 129654, 85756, 128228, 85630, 128226, 125416, 128246, 125412, 125410, 119784, 125430, 119780, 119778, 108520, 119798, 108516, 108514, 83424, 107256, 119166, 83184, 107132, 83064, 107070, 83004, 82974, 129588, 83704, 107390, 129586, 83580, 83518, 128116, 83838, 128114, 125172, 125170, 119284, 119282, 107508, 107506, 82672, 106876, 82552, 106814, 82492, 82462, 129562, 82812, 82750, 128058, 125050, 119034, 82296, 106686, 82236, 82206, 82366, 82108, 82078, 76736, 103920, 117500, 76256, 103672, 117374, 76016, 103548, 75896, 103486, 75836, 129384, 77296, 104188, 129380, 77048, 104062, 129378, 76924, 76862, 127720, 129398, 77564, 127716, 77438, 127714, 124392, 127734, 124388, 124386, 117736, 124406, 117732, 117730, 104424, 117750, 104420, 104418, 112096, 121592, 126334, 92608, 111856, 121468, 92384, 111736, 121406, 92272, 111676, 92216, 111646, 92188, 75232, 103160, 117118, 93664, 74992, 103036, 93424, 112252, 102974, 93304, 74812, 93244, 74782, 93214, 129332, 75512, 103294, 129908, 129330, 93944, 75388, 129906, 93820, 75326, 93758, 127604, 75646, 128756, 127602, 94078, 128754, 124148, 126452, 124146, 126450, 117236, 121844, 117234, 121842, 103412, 103410, 91584, 111344, 121212, 91360, 111224, 121150, 91248, 111164, 91192, 111134, 91164, 91150, 74480, 102780, 91888, 74360, 102718, 91768, 111422, 91708, 74270, 91678, 129306, 74620, 129850, 92028, 74558, 91966, 127546, 128634, 124026, 126202, 116986, 121338, 102906, 90848, 110968, 121022, 90736, 110908, 90680, 110878, 90652, 90638, 74104, 102590, 91000, 74044, 90940, 74014, 90910, 74174, 91070, 90480, 110780, 90424, 110750, 90396, 90382, 73916, 90556, 73886, 90526, 90296, 110686, 90268, 90254, 73822, 90334, 90204, 90190, 71136, 101112, 116094, 70896, 100988, 70776, 100926, 70716, 70686, 129204, 71416, 101246, 129202, 71292, 71230, 127348, 71550, 127346, 123636, 123634, 116212, 116210, 101364, 101362, 79296, 105200, 118140, 79072, 105080, 118078, 78960, 105020, 78904, 104990, 78876, 78862, 70384, 100732, 79600, 70264, 100670, 79480, 105278, 79420, 70174, 79390, 129178, 70524, 129466, 79740, 70462, 79678, 127290, 127866, 123514, 124666, 115962, 118266, 100858, 113376, 122232, 126654, 95424, 113264, 122172, 95328, 113208, 122142, 95280, 113180, 95256, 113166, 95244, 78560, 104824, 117950, 95968, 78448, 104764, 95856, 113468, 104734, 95800, 78364, 95772, 78350, 95758, 70008, 100542, 78712, 69948, 96120, 78652, 69918, 96060, 78622, 96030, 70078, 78782, 96190, 94912, 113008, 122044, 94816, 112952, 122014, 94768, 112924, 94744, 112910, 94732, 94726, 78192, 104636, 95088, 78136, 104606, 95032, 113054, 95004, 78094, 94990, 69820, 78268, 69790, 95164, 78238, 95134, 94560, 112824, 121950, 94512, 112796, 94488, 112782, 94476, 94470, 78008, 104542, 94648, 77980, 94620, 77966, 94606, 69726, 78046, 94686, 94384, 112732, 94360, 112718, 94348, 94342, 77916, 94428, 77902, 94414, 94296, 112686, 94284, 94278, 77870, 94318, 94252, 94246, 68336, 99708, 68216, 99646, 68156, 68126, 68476, 68414, 127162, 123258, 115450, 99834, 72416, 101752, 116414, 72304, 101692, 72248, 101662, 72220, 72206, 67960, 99518, 72568, 67900, 72508, 67870, 72478, 68030, 72638, 80576, 105840, 118460, 80480, 105784, 118430, 80432, 105756, 80408, 105742, 80396, 80390, 72048, 101564, 80752, 71992, 101534, 80696, 71964, 80668, 71950, 80654, 67772, 72124, 67742, 80828, 72094, 80798, 114016, 122552, 126814, 96832, 113968, 122524, 96800, 113944, 122510, 96784, 113932, 96776, 113926, 96772, 80224, 105656, 118366, 97120, 80176, 105628, 97072, 114076, 105614, 97048, 80140, 97036, 80134, 97030, 71864, 101470, 80312, 71836, 97208, 80284, 71822, 97180, 80270, 97166, 67678, 71902, 80350, 97246, 96576, 113840, 122460, 96544, 113816, 122446, 96528, 113804, 96520, 113798, 96516, 96514, 80048, 105564, 96688, 80024, 105550, 96664, 113870, 96652, 80006, 96646, 71772, 80092, 71758, 96732, 80078, 96718, 96416, 113752, 122414, 96400, 113740, 96392, 113734, 96388, 96386, 79960, 105518, 96472, 79948, 96460, 79942, 96454, 71726, 79982, 96494, 96336, 113708, 96328, 113702, 96324, 96322, 79916, 96364, 79910, 96358, 96296, 113686, 96292, 96290, 79894, 96310, 66936, 99006, 66876, 66846, 67006, 68976, 100028, 68920, 99998, 68892, 68878, 66748, 69052, 66718, 69022, 73056, 102072, 116574, 73008, 102044, 72984, 102030, 72972, 72966, 68792, 99934, 73144, 68764, 73116, 68750, 73102, 66654, 68830, 73182, 81216, 106160, 118620, 81184, 106136, 118606, 81168, 106124, 81160, 106118, 81156, 81154, 72880, 101980, 81328, 72856, 101966, 81304, 106190, 81292, 72838, 81286, 68700, 72924, 68686, 81372, 72910, 81358, 114336, 122712, 126894, 114320, 122700, 114312, 122694, 114308, 114306, 81056, 106072, 118574, 97696, 81040, 106060, 97680, 114380, 106054, 97672, 81028, 97668, 81026, 97666, 72792, 101934, 81112, 72780, 97752, 81100, 72774, 97740, 81094, 97734, 68654, 72814, 81134, 97774, 114256, 122668, 114248, 122662, 114244, 114242, 80976, 106028, 97488, 80968, 106022, 97480, 114278, 97476, 80962, 97474, 72748, 81004, 72742, 97516, 80998, 97510, 114216, 122646, 114212, 114210, 80936, 106006, 97384, 80932, 97380, 80930, 97378, 72726, 80950, 97398, 114196, 114194, 80916, 97332, 80914, 97330, 66236, 66206, 67256, 99166, 67228, 67214, 66142, 67294, 69296, 100188, 69272, 100174, 69260, 69254, 67164, 69340, 67150, 69326, 73376, 102232, 116654, 73360, 102220, 73352, 102214, 73348, 73346, 69208, 100142, 73432, 102254, 73420, 69190, 73414, 67118, 69230, 73454, 106320, 118700, 106312, 118694, 106308, 106306, 73296, 102188, 81616, 106348, 102182, 81608, 73284, 81604, 73282, 81602, 69164, 73324, 69158, 81644, 73318, 81638, 122792, 126934, 122788, 122786, 106280, 118678, 114536, 106276, 114532, 106274, 114530, 73256, 102166, 81512, 73252, 98024, 81508, 73250, 98020, 81506, 98018, 69142, 73270, 81526, 98038, 122772, 122770, 106260, 114484, 106258, 114482, 73236, 81460, 73234, 97908, 81458, 97906, 122762, 106250, 114458, 73226, 81434, 97850, 66396, 66382, 67416, 99246, 67404, 67398, 66350, 67438, 69456, 100268, 69448, 100262, 69444, 69442, 67372, 69484, 67366, 69478, 102312, 116694, 102308, 102306, 69416, 100246, 73576, 102326, 73572, 69410, 73570, 67350, 69430, 73590, 118740, 118738, 102292, 106420, 102290, 106418, 69396, 73524, 69394, 81780, 73522, 81778, 118730, 102282, 106394, 69386, 73498, 81722, 66476, 66470, 67496, 99286, 67492, 67490, 66454, 67510, 100308, 100306, 67476, 69556, 67474, 69554, 116714])]); /*13713*/
		$1.cwtobits = function() {
			var _Ej = $get($1.clusters, $k[--$j]); /*13717*/
			$1.v = $get(_Ej, $k[--$j]); /*13717*/
			$k[$j++] = Infinity; /*13718*/
			for (var _Em = 0, _En = 17; _Em < _En; _Em++) { /*13718*/
				$k[$j++] = 0; /*13718*/
			} /*13718*/
			var _Eq = $cvrs($s(17), $1.v, 2); /*13718*/
			for (var _Er = 0, _Es = _Eq.length; _Er < _Es; _Er++) { /*13718*/
				$k[$j++] = $get(_Eq, _Er) - 48; /*13718*/
			} /*13718*/
			var _Eu = $a(); /*13718*/
			$k[$j++] = $geti(_Eu, _Eu.length - 17, 17); /*13719*/
		}; /*13720*/
		if ($1.compact) { /*13726*/
			$1.rwid = (((17 * $1.c) + 17) + 17) + 1; /*13724*/
		} else { /*13726*/
			$1.rwid = ((((17 * $1.c) + 17) + 17) + 17) + 18; /*13726*/
		} /*13726*/
		$1.pixs = $a($1.rwid * $1.r); /*13728*/
		for (var _F4 = 0, _F3 = $1.r - 1; _F4 <= _F3; _F4 += 1) { /*13758*/
			$1.i = _F4; /*13731*/
			if (($1.i % 3) == 0) { /*13736*/
				$1.lcw = ((~~($1.i / 3)) * 30) + (~~(($1.r - 1) / 3)); /*13734*/
				$1.rcw = (((~~($1.i / 3)) * 30) + $1.c) - 1; /*13735*/
			} /*13735*/
			if (($1.i % 3) == 1) { /*13740*/
				$1.lcw = (((~~($1.i / 3)) * 30) + ($1.eclevel * 3)) + (($1.r - 1) % 3); /*13738*/
				$1.rcw = ((~~($1.i / 3)) * 30) + (~~(($1.r - 1) / 3)); /*13739*/
			} /*13739*/
			if (($1.i % 3) == 2) { /*13744*/
				$1.lcw = (((~~($1.i / 3)) * 30) + $1.c) - 1; /*13742*/
				$1.rcw = (((~~($1.i / 3)) * 30) + ($1.eclevel * 3)) + (($1.r - 1) % 3); /*13743*/
			} /*13743*/
			$k[$j++] = $1.pixs; /*13754*/
			$k[$j++] = $1.rwid * $1.i; /*13754*/
			$k[$j++] = Infinity; /*13754*/
			$k[$j++] = 1; /*13748*/
			$k[$j++] = 1; /*13748*/
			$k[$j++] = 1; /*13748*/
			$k[$j++] = 1; /*13748*/
			$k[$j++] = 1; /*13748*/
			$k[$j++] = 1; /*13748*/
			$k[$j++] = 1; /*13748*/
			$k[$j++] = 1; /*13748*/
			$k[$j++] = 0; /*13748*/
			$k[$j++] = 1; /*13748*/
			$k[$j++] = 0; /*13748*/
			$k[$j++] = 1; /*13748*/
			$k[$j++] = 0; /*13748*/
			$k[$j++] = 1; /*13748*/
			$k[$j++] = 0; /*13748*/
			$k[$j++] = 0; /*13748*/
			$k[$j++] = 0; /*13748*/
			$k[$j++] = $1.lcw; /*13748*/
			$k[$j++] = $1.i % 3; /*13748*/
			$1.cwtobits(); /*13748*/
			$forall($k[--$j]); /*13748*/
			$forall($geti($1.cws, $1.c * $1.i, $1.c), function() { /*13749*/
				$k[$j++] = $1.i % 3; /*13749*/
				$1.cwtobits(); /*13749*/
				$forall($k[--$j]); /*13749*/
			}) /*13749*/
			if ($1.compact) { /*13754*/
				$k[$j++] = 1; /*13751*/
			} else { /*13754*/
				$k[$j++] = $1.rcw; /*13753*/
				$k[$j++] = $1.i % 3; /*13753*/
				$1.cwtobits(); /*13753*/
				$forall($k[--$j]); /*13753*/
				$k[$j++] = 1; /*13754*/
				$k[$j++] = 1; /*13754*/
				$k[$j++] = 1; /*13754*/
				$k[$j++] = 1; /*13754*/
				$k[$j++] = 1; /*13754*/
				$k[$j++] = 1; /*13754*/
				$k[$j++] = 1; /*13754*/
				$k[$j++] = 0; /*13754*/
				$k[$j++] = 1; /*13754*/
				$k[$j++] = 0; /*13754*/
				$k[$j++] = 0; /*13754*/
				$k[$j++] = 0; /*13754*/
				$k[$j++] = 1; /*13754*/
				$k[$j++] = 0; /*13754*/
				$k[$j++] = 1; /*13754*/
				$k[$j++] = 0; /*13754*/
				$k[$j++] = 0; /*13754*/
				$k[$j++] = 1; /*13754*/
			} /*13754*/
			var _Fd = $a(); /*13754*/
			var _Fe = $k[--$j]; /*13756*/
			$puti($k[--$j], _Fe, _Fd); /*13756*/
		} /*13756*/
		var _Fn = {
			ren: $0.renmatrix,
			pixs: $1.pixs,
			pixx: $1.rwid,
			pixy: $1.r,
			height: ($1.r / 72) * $1.rowmult,
			width: $1.rwid / 72,
			opt: $1.options
		}; /*13768*/
		$k[$j++] = _Fn; /*13771*/
		if (!$1.dontdraw) { /*13771*/
			$0.renmatrix(); /*13771*/
		} /*13771*/
	};
	$0.pdf417compact = function() {
		var $1 = {}; /*13799*/
		$1.options = $k[--$j]; /*13801*/
		$1.barcode = $k[--$j]; /*13802*/
		$1.dontdraw = false; /*13804*/
		$forall($1.options, function() { /*13815*/
			var _3 = $k[--$j]; /*13815*/
			$1[$k[--$j]] = _3; /*13815*/
		}) /*13815*/
		$1.options.dontdraw = true; /*13818*/
		$1.options.compact = true; /*13819*/
		$k[$j++] = "args"; /*13821*/
		$k[$j++] = $1.barcode; /*13821*/
		$k[$j++] = $1.options; /*13821*/
		$0.pdf417(); /*13821*/
		var _9 = $k[--$j]; /*13821*/
		$1[$k[--$j]] = _9; /*13821*/
		$1.args.opt = $1.options; /*13823*/
		$k[$j++] = $1.args; /*13826*/
		if (!$1.dontdraw) { /*13826*/
			$0.renmatrix(); /*13826*/
		} /*13826*/
	};
	$0.micropdf417 = function() {
		var $1 = {}; /*13853*/
		$1.options = $k[--$j]; /*13855*/
		$1.barcode = $k[--$j]; /*13856*/
		$1.dontdraw = false; /*13858*/
		$1.version = "unset"; /*13859*/
		$1.columns = 0; /*13860*/
		$1.rows = 0; /*13861*/
		$1.rowmult = 2; /*13862*/
		$1.encoding = "auto"; /*13863*/
		$1.cca = false; /*13864*/
		$1.ccb = false; /*13865*/
		$1.raw = false; /*13866*/
		$1.parse = false; /*13867*/
		$forall($1.options, function() { /*13878*/
			var _3 = $k[--$j]; /*13878*/
			$1[$k[--$j]] = _3; /*13878*/
		}) /*13878*/
		if ($ne($1.version, "unset")) { /*13884*/
			$search($1.version, "x"); /*13881*/
			$j--; /*13882*/
			$1.columns = $k[--$j]; /*13882*/
			$j--; /*13883*/
			$1.rows = $k[--$j]; /*13883*/
		} /*13883*/
		$1.columns = ~~$z($1.columns); /*13886*/
		$1.rows = ~~$z($1.rows); /*13887*/
		$1.rowmult = +$1.rowmult; /*13888*/
		if ($1.raw) { /*13911*/
			$1.encoding = "raw"; /*13911*/
		} /*13911*/
		if ($1.cca) { /*13912*/
			$1.encoding = "cca"; /*13912*/
		} /*13912*/
		if ($eq($1.encoding, "raw") || $eq($1.encoding, "cca")) { /*13926*/
			$1.datcws = $a($1.barcode.length); /*13916*/
			$1.i = 0; /*13917*/
			$1.j = 0; /*13917*/
			for (;;) { /*13924*/
				if ($1.i == $1.barcode.length) { /*13919*/
					break; /*13919*/
				} /*13919*/
				$1.cw = ~~$z($geti($1.barcode, $1.i + 1, 3)); /*13920*/
				$put($1.datcws, $1.j, $1.cw); /*13921*/
				$1.i = $1.i + 4; /*13922*/
				$1.j = $1.j + 1; /*13923*/
			} /*13923*/
			$1.datcws = $geti($1.datcws, 0, $1.j); /*13925*/
		} /*13925*/
		$k[$j++] = "barcode"; /*13928*/
		$k[$j++] = Infinity; /*13928*/
		$forall($1.barcode); /*13928*/
		var _W = $a(); /*13928*/
		$1[$k[--$j]] = _W; /*13928*/
		$1.barlen = $1.barcode.length; /*13929*/
		if ($1.ccb) { /*13931*/
			$1.encoding = "ccb"; /*13931*/
		} /*13931*/
		$1.encb = function() {
			$1.in = $k[--$j]; /*13934*/
			$1.inlen = $1.in.length; /*13935*/
			$1.out = $a(((~~($1.inlen / 6)) * 5) + ($1.inlen % 6)); /*13936*/
			for (var _h = 0, _g = (~~($1.inlen / 6)) - 1; _h <= _g; _h += 1) { /*13959*/
				$1.k = _h; /*13938*/
				$k[$j++] = "msbs"; /*13939*/
				$k[$j++] = Infinity; /*13939*/
				$aload($geti($1.in, $1.k * 6, 3)); /*13939*/
				var _l = $a(); /*13939*/
				$1[$k[--$j]] = _l; /*13939*/
				$k[$j++] = "mscs"; /*13942*/
				$k[$j++] = Infinity; /*13942*/
				$aload($1.msbs); /*13941*/
				var _o = $k[--$j]; /*13941*/
				var _p = $k[--$j]; /*13941*/
				var _q = $k[--$j]; /*13941*/
				$k[$j++] = (_o + (_p * 256)) + (_q * 65536); /*13942*/
				for (var _r = 0, _s = 3; _r < _s; _r++) { /*13942*/
					var _t = $k[--$j]; /*13942*/
					$k[$j++] = _t % 900; /*13942*/
					$k[$j++] = ~~(_t / 900); /*13942*/
				} /*13942*/
				var _u = $a(); /*13942*/
				$1[$k[--$j]] = _u; /*13943*/
				$k[$j++] = "lsbs"; /*13944*/
				$k[$j++] = Infinity; /*13944*/
				$aload($geti($1.in, ($1.k * 6) + 3, 3)); /*13944*/
				var _z = $a(); /*13944*/
				$1[$k[--$j]] = _z; /*13944*/
				$k[$j++] = "lscs"; /*13947*/
				$k[$j++] = Infinity; /*13947*/
				$aload($1.lsbs); /*13946*/
				var _12 = $k[--$j]; /*13946*/
				var _13 = $k[--$j]; /*13946*/
				var _14 = $k[--$j]; /*13946*/
				$k[$j++] = (_12 + (_13 * 256)) + (_14 * 65536); /*13947*/
				for (var _15 = 0, _16 = 3; _15 < _16; _15++) { /*13947*/
					var _17 = $k[--$j]; /*13947*/
					$k[$j++] = _17 % 900; /*13947*/
					$k[$j++] = ~~(_17 / 900); /*13947*/
				} /*13947*/
				var _18 = $a(); /*13947*/
				$1[$k[--$j]] = _18; /*13948*/
				var _1B = $get($1.lscs, 0); /*13949*/
				var _1D = $get($1.mscs, 0); /*13949*/
				$put($1.out, ($1.k * 5) + 4, (_1B + (_1D * 316)) % 900); /*13950*/
				var _1H = $get($1.lscs, 1); /*13951*/
				var _1J = $get($1.mscs, 0); /*13951*/
				var _1L = $get($1.mscs, 1); /*13951*/
				$put($1.out, ($1.k * 5) + 3, ((((~~((_1B + (_1D * 316)) / 900)) + _1H) + (_1J * 641)) + (_1L * 316)) % 900); /*13952*/
				var _1P = $get($1.lscs, 2); /*13953*/
				var _1R = $get($1.mscs, 0); /*13953*/
				var _1T = $get($1.mscs, 1); /*13953*/
				var _1V = $get($1.mscs, 2); /*13953*/
				$put($1.out, ($1.k * 5) + 2, (((((~~(((((~~((_1B + (_1D * 316)) / 900)) + _1H) + (_1J * 641)) + (_1L * 316)) / 900)) + _1P) + (_1R * 20)) + (_1T * 641)) + (_1V * 316)) % 900); /*13954*/
				var _1Z = $get($1.lscs, 3); /*13955*/
				var _1b = $get($1.mscs, 1); /*13955*/
				var _1d = $get($1.mscs, 2); /*13955*/
				$put($1.out, ($1.k * 5) + 1, ((((~~((((((~~(((((~~((_1B + (_1D * 316)) / 900)) + _1H) + (_1J * 641)) + (_1L * 316)) / 900)) + _1P) + (_1R * 20)) + (_1T * 641)) + (_1V * 316)) / 900)) + _1Z) + (_1b * 20)) + (_1d * 641)) % 900); /*13956*/
				$put($1.out, $1.k * 5, ((~~(((((~~((((((~~(((((~~((_1B + (_1D * 316)) / 900)) + _1H) + (_1J * 641)) + (_1L * 316)) / 900)) + _1P) + (_1R * 20)) + (_1T * 641)) + (_1V * 316)) / 900)) + _1Z) + (_1b * 20)) + (_1d * 641)) / 900)) + ($get($1.mscs, 2) * 20)) % 900); /*13958*/
			} /*13958*/
			$1.rem = $1.inlen % 6; /*13960*/
			if ($1.rem != 0) { /*13965*/
				$k[$j++] = $1.out; /*13963*/
				$k[$j++] = $1.out.length - $1.rem; /*13963*/
				$k[$j++] = Infinity; /*13963*/
				$aload($geti($1.in, $1.inlen - $1.rem, $1.rem)); /*13963*/
				var _1u = $a(); /*13963*/
				var _1v = $k[--$j]; /*13964*/
				$puti($k[--$j], _1v, _1u); /*13964*/
			} /*13964*/
			$k[$j++] = $1.out; /*13966*/
		}; /*13967*/
		if ($eq($1.encoding, "byte") || $eq($1.encoding, "ccb")) { /*13974*/
			$1.datcws = $a((((~~($1.barlen / 6)) * 5) + ($1.barlen % 6)) + 1); /*13970*/
			var _25 = (($1.barlen % 6) == 0) ? 924 : 901; /*13971*/
			$put($1.datcws, 0, _25); /*13971*/
			$k[$j++] = $1.datcws; /*13972*/
			$k[$j++] = 1; /*13972*/
			$k[$j++] = $1.barcode; /*13972*/
			$1.encb(); /*13972*/
			var _28 = $k[--$j]; /*13972*/
			var _29 = $k[--$j]; /*13972*/
			$puti($k[--$j], _29, _28); /*13972*/
			if ($eq($1.encoding, "ccb")) { /*13973*/
				$k[$j++] = "datcws"; /*13973*/
				$k[$j++] = Infinity; /*13973*/
				$k[$j++] = 920; /*13973*/
				$aload($1.datcws); /*13973*/
				var _2D = $a(); /*13973*/
				$1[$k[--$j]] = _2D; /*13973*/
			} /*13973*/
		} /*13973*/
		if ($eq($1.encoding, "auto")) { /*14338*/
			$1.T = 0; /*13979*/
			$1.N = 1; /*13979*/
			$1.B = 2; /*13979*/
			$1.A = 0; /*13980*/
			$1.L = 1; /*13980*/
			$1.M = 2; /*13980*/
			$1.P = 3; /*13980*/
			$1.tl = -1; /*13983*/
			$1.nl = -2; /*13983*/
			$1.bl = -3; /*13983*/
			$1.bl6 = -4; /*13983*/
			$1.bs = -5; /*13983*/
			$1.al = -6; /*13986*/
			$1.ll = -7; /*13986*/
			$1.ml = -8; /*13986*/
			$1.pl = -9; /*13986*/
			$1.as = -10; /*13986*/
			$1.ps = -11; /*13986*/
			$1.charmaps = $a([$a(["A", "a", "0", ";"]), $a(["B", "b", "1", "<"]), $a(["C", "c", "2", ">"]), $a(["D", "d", "3", "@"]), $a(["E", "e", "4", "["]), $a(["F", "f", "5", 92]), $a(["G", "g", "6", "]"]), $a(["H", "h", "7", "_"]), $a(["I", "i", "8", "`"]), $a(["J", "j", "9", "~"]), $a(["K", "k", "&", "!"]), $a(["L", "l", 13, 13]), $a(["M", "m", 9, 9]), $a(["N", "n", ",", ","]), $a(["O", "o", ":", ":"]), $a(["P", "p", "#", 10]), $a(["Q", "q", "-", "-"]), $a(["R", "r", ".", "."]), $a(["S", "s", "$", "$"]), $a(["T", "t", "/", "/"]), $a(["U", "u", "+", "\""]), $a(["V", "v", "%", "|"]), $a(["W", "w", "*", "*"]), $a(["X", "x", "=", 40]), $a(["Y", "y", "^", 41]), $a(["Z", "z", $1.pl, "?"]), $a([" ", " ", " ", "{"]), $a([$1.ll, $1.as, $1.ll, "}"]), $a([$1.ml, $1.ml, $1.al, "'"]), $a([$1.ps, $1.ps, $1.ps, $1.al])]); /*14021*/
			$1.charvals = $a([{}, {}, {}, {}]); /*14024*/
			$1.alltext = {}; /*14025*/
			for (var _2z = 0, _2y = $1.charmaps.length - 1; _2z <= _2y; _2z += 1) { /*14035*/
				$1.i = _2z; /*14027*/
				$1.encs = $get($1.charmaps, $1.i); /*14028*/
				for (var _33 = 0; _33 <= 3; _33 += 1) { /*14034*/
					$1.j = _33; /*14030*/
					var _36 = $get($1.encs, $1.j); /*14031*/
					$k[$j++] = _36; /*14031*/
					if ($eq($type(_36), "stringtype")) { /*14031*/
						var _39 = $get($k[--$j], 0); /*14031*/
						$k[$j++] = _39; /*14031*/
					} /*14031*/
					var _3A = $k[--$j]; /*14032*/
					$put($get($1.charvals, $1.j), _3A, $1.i); /*14032*/
					$put($1.alltext, _3A, -1); /*14033*/
				} /*14033*/
			} /*14033*/
			$1.e = 10000; /*14037*/
			$1.latlen = $a([$a([0, 1, 1, 2]), $a([2, 0, 1, 2]), $a([1, 1, 0, 1]), $a([1, 2, 2, 0])]); /*14045*/
			$1.latseq = $a([$a([$a([]), $a([$1.ll]), $a([$1.ml]), $a([$1.ml, $1.pl])]), $a([$a([$1.ml, $1.al]), $a([]), $a([$1.ml]), $a([$1.ml, $1.pl])]), $a([$a([$1.al]), $a([$1.ll]), $a([]), $a([$1.pl])]), $a([$a([$1.al]), $a([$1.al, $1.ll]), $a([$1.al, $1.ml]), $a([])])]); /*14053*/
			$1.shftlen = $a([$a([$1.e, $1.e, $1.e, 1]), $a([1, $1.e, $1.e, 1]), $a([$1.e, $1.e, $1.e, 1]), $a([$1.e, $1.e, $1.e, $1.e])]); /*14061*/
			$k[$j++] = "numdigits"; /*14064*/
			$k[$j++] = Infinity; /*14064*/
			for (var _4F = 0, _4G = $1.barlen; _4F < _4G; _4F++) { /*14064*/
				$k[$j++] = 0; /*14064*/
			} /*14064*/
			$k[$j++] = 0; /*14064*/
			var _4H = $a(); /*14064*/
			$1[$k[--$j]] = _4H; /*14064*/
			$k[$j++] = "numtext"; /*14065*/
			$k[$j++] = Infinity; /*14065*/
			for (var _4K = 0, _4L = $1.barlen; _4K < _4L; _4K++) { /*14065*/
				$k[$j++] = 0; /*14065*/
			} /*14065*/
			$k[$j++] = 0; /*14065*/
			var _4M = $a(); /*14065*/
			$1[$k[--$j]] = _4M; /*14065*/
			$k[$j++] = "numbytes"; /*14066*/
			$k[$j++] = Infinity; /*14066*/
			for (var _4P = 0, _4Q = $1.barlen; _4P < _4Q; _4P++) { /*14066*/
				$k[$j++] = 0; /*14066*/
			} /*14066*/
			$k[$j++] = 0; /*14066*/
			var _4R = $a(); /*14066*/
			$1[$k[--$j]] = _4R; /*14066*/
			for (var _4U = $1.barlen - 1; _4U >= 0; _4U -= 1) { /*14078*/
				$1.i = _4U; /*14068*/
				var _4X = $get($1.barcode, $1.i); /*14069*/
				if ((_4X >= 48) && (_4X <= 57)) { /*14071*/
					$put($1.numdigits, $1.i, $get($1.numdigits, $1.i + 1) + 1); /*14070*/
				} /*14070*/
				var _4h = $get($1.alltext, $get($1.barcode, $1.i)) !== undefined; /*14072*/
				if (_4h && ($get($1.numdigits, $1.i) < 13)) { /*14074*/
					$put($1.numtext, $1.i, $get($1.numtext, $1.i + 1) + 1); /*14073*/
				} /*14073*/
				if (($get($1.numtext, $1.i) < 5) && ($get($1.numdigits, $1.i) < 13)) { /*14077*/
					$put($1.numbytes, $1.i, $get($1.numbytes, $1.i + 1) + 1); /*14076*/
				} /*14076*/
			} /*14076*/
			$1.numdigits = $geti($1.numdigits, 0, $1.barlen); /*14079*/
			$1.numtext = $geti($1.numtext, 0, $1.barlen); /*14080*/
			$1.numbytes = $geti($1.numbytes, 0, $1.barlen); /*14081*/
			$1.seq = $a([]); /*14083*/
			$1.seqlen = 0; /*14083*/
			$1.state = $1.B; /*14083*/
			$1.p = 0; /*14083*/
			for (;;) { /*14126*/
				if ($1.p == $1.barlen) { /*14084*/
					break; /*14084*/
				} /*14084*/
				$1.n = $get($1.numdigits, $1.p); /*14085*/
				if ($1.n >= 13) { /*14124*/
					$k[$j++] = "seq"; /*14090*/
					$k[$j++] = Infinity; /*14090*/
					$aload($1.seq); /*14088*/
					$k[$j++] = $1.nl; /*14090*/
					$k[$j++] = Infinity; /*14090*/
					$aload($geti($1.barcode, $1.p, $1.n)); /*14090*/
					var _5O = $a(); /*14090*/
					$k[$j++] = _5O; /*14090*/
					var _5P = $a(); /*14090*/
					$1[$k[--$j]] = _5P; /*14091*/
					$1.state = $1.N; /*14092*/
					$1.p = $1.p + $1.n; /*14093*/
					$1.seqlen = ($1.seqlen + 1) + $1.n; /*14094*/
				} else { /*14124*/
					$1.t = $get($1.numtext, $1.p); /*14096*/
					if ($1.t >= 5) { /*14124*/
						$k[$j++] = "seq"; /*14101*/
						$k[$j++] = Infinity; /*14101*/
						$aload($1.seq); /*14099*/
						if ($1.state != $1.T) { /*14100*/
							$k[$j++] = $1.tl; /*14100*/
						} /*14100*/
						$k[$j++] = Infinity; /*14101*/
						$aload($geti($1.barcode, $1.p, $1.t)); /*14101*/
						var _5i = $a(); /*14101*/
						$k[$j++] = _5i; /*14101*/
						var _5j = $a(); /*14101*/
						$1[$k[--$j]] = _5j; /*14102*/
						$1.state = $1.T; /*14103*/
						$1.p = $1.p + $1.t; /*14104*/
						$1.seqlen = ($1.seqlen + 1) + $1.t; /*14105*/
					} else { /*14124*/
						$1.b = $get($1.numbytes, $1.p); /*14107*/
						if (($1.b == 1) && ($1.state == $1.T)) { /*14124*/
							$k[$j++] = "seq"; /*14112*/
							$k[$j++] = Infinity; /*14112*/
							$aload($1.seq); /*14110*/
							$k[$j++] = $1.bs; /*14112*/
							$k[$j++] = $a([$get($1.barcode, $1.p)]); /*14112*/
							var _62 = $a(); /*14112*/
							$1[$k[--$j]] = _62; /*14113*/
							$1.p = $1.p + $1.b; /*14114*/
							$1.seqlen = $1.seqlen + 2; /*14115*/
						} else { /*14124*/
							$k[$j++] = "seq"; /*14120*/
							$k[$j++] = Infinity; /*14120*/
							$aload($1.seq); /*14118*/
							if (($1.b % 6) != 0) { /*14119*/
								$k[$j++] = $1.bl; /*14119*/
							} else { /*14119*/
								$k[$j++] = $1.bl6; /*14119*/
							} /*14119*/
							$k[$j++] = Infinity; /*14120*/
							$aload($geti($1.barcode, $1.p, $1.b)); /*14120*/
							var _6F = $a(); /*14120*/
							$k[$j++] = _6F; /*14120*/
							var _6G = $a(); /*14120*/
							$1[$k[--$j]] = _6G; /*14121*/
							$1.state = $1.B; /*14122*/
							$1.p = $1.p + $1.b; /*14123*/
							$1.seqlen = ($1.seqlen + 1) + $1.b; /*14124*/
						} /*14124*/
					} /*14124*/
				} /*14124*/
			} /*14124*/
			$k[$j++] = "latchcws"; /*14129*/
			$k[$j++] = Infinity; /*14129*/
			$k[$j++] = $1.tl; /*14129*/
			$k[$j++] = 900; /*14129*/
			$k[$j++] = $1.bl; /*14129*/
			$k[$j++] = 901; /*14129*/
			$k[$j++] = $1.bl6; /*14129*/
			$k[$j++] = 924; /*14129*/
			$k[$j++] = $1.nl; /*14129*/
			$k[$j++] = 902; /*14129*/
			$k[$j++] = $1.bs; /*14129*/
			$k[$j++] = 913; /*14129*/
			var _6S = $d(); /*14129*/
			$1[$k[--$j]] = _6S; /*14130*/
			$1.enca = function() {
				var _6Y = $get($get($1.charvals, $1.A), $k[--$j]); /*14133*/
				$k[$j++] = _6Y; /*14133*/
			}; /*14133*/
			$1.encl = function() {
				var _6d = $get($get($1.charvals, $1.L), $k[--$j]); /*14134*/
				$k[$j++] = _6d; /*14134*/
			}; /*14134*/
			$1.encm = function() {
				var _6i = $get($get($1.charvals, $1.M), $k[--$j]); /*14135*/
				$k[$j++] = _6i; /*14135*/
			}; /*14135*/
			$1.encp = function() {
				var _6n = $get($get($1.charvals, $1.P), $k[--$j]); /*14136*/
				$k[$j++] = _6n; /*14136*/
			}; /*14136*/
			$1.textencfuncs = $a(["enca", "encl", "encm", "encp"]); /*14137*/
			$1.addtotext = function() {
				$put($1.text, $1.l, $k[--$j]); /*14140*/
				$1.l = $1.l + 1; /*14141*/
			}; /*14142*/
			$1.enct = function() {
				$1.in = $k[--$j]; /*14146*/
				$1.curlen = $a([$1.e, $1.e, $1.e, $1.e]); /*14148*/
				$put($1.curlen, $1.submode, 0); /*14149*/
				$1.curseq = $a([$a([]), $a([]), $a([]), $a([])]); /*14150*/
				$forall($1.in, function() { /*14220*/
					$1.char = $k[--$j]; /*14155*/
					for (;;) { /*14176*/
						$1.imp = false; /*14159*/
						var _7C = $a([$1.A, $1.L, $1.M, $1.P]); /*14160*/
						for (var _7D = 0, _7E = _7C.length; _7D < _7E; _7D++) { /*14174*/
							$1.x = $get(_7C, _7D); /*14161*/
							var _7K = $a([$1.A, $1.L, $1.M, $1.P]); /*14162*/
							for (var _7L = 0, _7M = _7K.length; _7L < _7M; _7L++) { /*14173*/
								$1.y = $get(_7K, _7L); /*14163*/
								$1.cost = $get($1.curlen, $1.x) + $get($get($1.latlen, $1.x), $1.y); /*14164*/
								if ($1.cost < $get($1.curlen, $1.y)) { /*14172*/
									$put($1.curlen, $1.y, $1.cost); /*14166*/
									$k[$j++] = $1.curseq; /*14169*/
									$k[$j++] = $1.y; /*14169*/
									$k[$j++] = Infinity; /*14169*/
									$aload($get($1.curseq, $1.x)); /*14168*/
									$aload($get($get($1.latseq, $1.x), $1.y)); /*14169*/
									var _7n = $a(); /*14169*/
									var _7o = $k[--$j]; /*14170*/
									$put($k[--$j], _7o, _7n); /*14170*/
									$1.imp = true; /*14171*/
								} /*14171*/
							} /*14171*/
						} /*14171*/
						if (!$1.imp) { /*14175*/
							break; /*14175*/
						} /*14175*/
					} /*14175*/
					$1.nxtlen = $a([$1.e, $1.e, $1.e, $1.e]); /*14179*/
					$1.nxtseq = $a(4); /*14180*/
					var _81 = $a([$1.A, $1.L, $1.M, $1.P]); /*14182*/
					for (var _82 = 0, _83 = _81.length; _82 < _83; _82++) { /*14215*/
						$1.x = $get(_81, _82); /*14183*/
						for (;;) { /*14213*/
							var _89 = $get($get($1.charvals, $1.x), $1.char) !== undefined; /*14187*/
							if (!_89) { /*14187*/
								break; /*14187*/
							} /*14187*/
							$1.cost = $get($1.curlen, $1.x) + 1; /*14190*/
							if ($1.cost < $get($1.nxtlen, $1.x)) { /*14194*/
								$put($1.nxtlen, $1.x, $1.cost); /*14192*/
								$k[$j++] = $1.nxtseq; /*14193*/
								$k[$j++] = $1.x; /*14193*/
								$k[$j++] = Infinity; /*14193*/
								$aload($get($1.curseq, $1.x)); /*14193*/
								$k[$j++] = $1.char; /*14193*/
								var _8Q = $a(); /*14193*/
								var _8R = $k[--$j]; /*14193*/
								$put($k[--$j], _8R, _8Q); /*14193*/
							} /*14193*/
							var _8X = $a([$1.A, $1.L, $1.M, $1.P]); /*14197*/
							for (var _8Y = 0, _8Z = _8X.length; _8Y < _8Z; _8Y++) { /*14210*/
								$1.y = $get(_8X, _8Y); /*14198*/
								if ($ne($1.x, $1.y)) { /*14209*/
									$1.cost = ($get($1.curlen, $1.y) + $get($get($1.shftlen, $1.y), $1.x)) + 1; /*14200*/
									if ($1.cost < $get($1.nxtlen, $1.y)) { /*14208*/
										$put($1.nxtlen, $1.y, $1.cost); /*14202*/
										$k[$j++] = $1.nxtseq; /*14206*/
										$k[$j++] = $1.y; /*14206*/
										$k[$j++] = Infinity; /*14206*/
										$aload($get($1.curseq, $1.y)); /*14204*/
										if ($1.x == $1.A) { /*14205*/
											$k[$j++] = $1.as; /*14205*/
										} else { /*14205*/
											$k[$j++] = $1.ps; /*14205*/
										} /*14205*/
										$k[$j++] = $1.char; /*14206*/
										var _92 = $a(); /*14206*/
										var _93 = $k[--$j]; /*14207*/
										$put($k[--$j], _93, _92); /*14207*/
									} /*14207*/
								} /*14207*/
							} /*14207*/
							break; /*14212*/
						} /*14212*/
					} /*14212*/
					$1.curlen = $1.nxtlen; /*14217*/
					$1.curseq = $1.nxtseq; /*14218*/
				}) /*14218*/
				$1.minseq = $1.e; /*14223*/
				var _9C = $a([$1.A, $1.L, $1.M, $1.P]); /*14224*/
				for (var _9D = 0, _9E = _9C.length; _9D < _9E; _9D++) { /*14230*/
					$1.k = $get(_9C, _9D); /*14225*/
					if ($get($1.curlen, $1.k) < $1.minseq) { /*14229*/
						$1.minseq = $get($1.curlen, $1.k); /*14227*/
						$1.txtseq = $get($1.curseq, $1.k); /*14228*/
					} /*14228*/
				} /*14228*/
				$1.text = $a($1.minseq); /*14233*/
				$1.k = 0; /*14234*/
				$1.l = 0; /*14234*/
				for (;;) { /*14254*/
					if ($1.k >= $1.txtseq.length) { /*14235*/
						break; /*14235*/
					} /*14235*/
					$1.char = $get($1.txtseq, $1.k); /*14237*/
					$k[$j++] = $1.char; /*14240*/
					$1[$get($1.textencfuncs, $1.submode)](); /*14240*/
					$1.addtotext(); /*14240*/
					$1.k = $1.k + 1; /*14241*/
					if (($1.char == $1.as) || ($1.char == $1.ps)) { /*14247*/
						$k[$j++] = $get($1.txtseq, $1.k); /*14245*/
						if ($1.char == $1.as) { /*14245*/
							$1.enca(); /*14245*/
						} else { /*14245*/
							$1.encp(); /*14245*/
						} /*14245*/
						$1.addtotext(); /*14245*/
						$1.k = $1.k + 1; /*14246*/
					} /*14246*/
					if ($1.char == $1.al) { /*14250*/
						$1.submode = $1.A; /*14250*/
					} /*14250*/
					if ($1.char == $1.ll) { /*14251*/
						$1.submode = $1.L; /*14251*/
					} /*14251*/
					if ($1.char == $1.ml) { /*14252*/
						$1.submode = $1.M; /*14252*/
					} /*14252*/
					if ($1.char == $1.pl) { /*14253*/
						$1.submode = $1.P; /*14253*/
					} /*14253*/
				} /*14253*/
				if (($1.text.length % 2) == 1) { /*14264*/
					if ($1.submode == $1.P) { /*14261*/
						$k[$j++] = "pad"; /*14258*/
						$k[$j++] = $1.al; /*14258*/
						$1.encp(); /*14258*/
						var _A3 = $k[--$j]; /*14258*/
						$1[$k[--$j]] = _A3; /*14258*/
						$1.submode = $1.A; /*14259*/
					} else { /*14261*/
						$k[$j++] = "pad"; /*14261*/
						$k[$j++] = $1.ps; /*14261*/
						$1[$get($1.textencfuncs, $1.submode)](); /*14261*/
						var _AB = $k[--$j]; /*14261*/
						$1[$k[--$j]] = _AB; /*14261*/
					} /*14261*/
					$k[$j++] = "text"; /*14263*/
					$k[$j++] = Infinity; /*14263*/
					$aload($1.text); /*14263*/
					$k[$j++] = $1.pad; /*14263*/
					var _AF = $a(); /*14263*/
					$1[$k[--$j]] = _AF; /*14263*/
				} /*14263*/
				$1.out = $a(~~($1.text.length / 2)); /*14266*/
				for (var _AL = 0, _AK = $1.out.length - 1; _AL <= _AK; _AL += 1) { /*14270*/
					$1.k = _AL; /*14268*/
					$put($1.out, $1.k, ($get($1.text, $1.k * 2) * 30) + $get($1.text, ($1.k * 2) + 1)); /*14269*/
				} /*14269*/
				$k[$j++] = $1.out; /*14272*/
			}; /*14274*/
			$1.encn = function() {
				$1.in = $k[--$j]; /*14277*/
				$1.out = $a([]); /*14278*/
				for (var _AZ = 0, _AY = $1.in.length - 1; _AZ <= _AY; _AZ += 44) { /*14306*/
					$1.k = _AZ; /*14280*/
					$k[$j++] = "gmod"; /*14283*/
					$k[$j++] = Infinity; /*14283*/
					var _Ae = $1.in.length - $1.k; /*14282*/
					$k[$j++] = 1; /*14282*/
					$k[$j++] = $1.in; /*14282*/
					$k[$j++] = $1.k; /*14282*/
					$k[$j++] = _Ae; /*14282*/
					if (_Ae > 44) { /*14282*/
						$j--; /*14282*/
						$k[$j++] = 44; /*14282*/
					} /*14282*/
					var _Af = $k[--$j]; /*14282*/
					var _Ag = $k[--$j]; /*14282*/
					$forall($geti($k[--$j], _Ag, _Af), function() { /*14283*/
						var _Aj = $k[--$j]; /*14283*/
						$k[$j++] = _Aj - 48; /*14283*/
					}) /*14283*/
					var _Ak = $a(); /*14283*/
					$1[$k[--$j]] = _Ak; /*14284*/
					$1.cwn = $a([]); /*14285*/
					for (;;) { /*14304*/
						$1.dv = 900; /*14286*/
						$1.gmul = $a([]); /*14287*/
						$1.val = 0; /*14287*/
						for (;;) { /*14299*/
							if ($1.gmod.length == 0) { /*14288*/
								break; /*14288*/
							} /*14288*/
							$1.val = ($1.val * 10) + $get($1.gmod, 0); /*14289*/
							$1.gmod = $geti($1.gmod, 1, $1.gmod.length - 1); /*14290*/
							if ($1.val < $1.dv) { /*14296*/
								if ($1.gmul.length != 0) { /*14294*/
									$k[$j++] = "gmul"; /*14293*/
									$k[$j++] = Infinity; /*14293*/
									$aload($1.gmul); /*14293*/
									$k[$j++] = 0; /*14293*/
									var _Az = $a(); /*14293*/
									$1[$k[--$j]] = _Az; /*14293*/
								} /*14293*/
							} else { /*14296*/
								$k[$j++] = "gmul"; /*14296*/
								$k[$j++] = Infinity; /*14296*/
								$aload($1.gmul); /*14296*/
								$k[$j++] = ~~($1.val / $1.dv); /*14296*/
								var _B4 = $a(); /*14296*/
								$1[$k[--$j]] = _B4; /*14296*/
							} /*14296*/
							$1.val = $1.val % $1.dv; /*14298*/
						} /*14298*/
						$1.dv = $1.val; /*14300*/
						$k[$j++] = "cwn"; /*14301*/
						$k[$j++] = Infinity; /*14301*/
						$k[$j++] = $1.dv; /*14301*/
						$aload($1.cwn); /*14301*/
						var _BB = $a(); /*14301*/
						$1[$k[--$j]] = _BB; /*14301*/
						$1.gmod = $1.gmul; /*14302*/
						if ($1.gmul.length == 0) { /*14303*/
							break; /*14303*/
						} /*14303*/
					} /*14303*/
					$k[$j++] = "out"; /*14305*/
					$k[$j++] = Infinity; /*14305*/
					$aload($1.out); /*14305*/
					$aload($1.cwn); /*14305*/
					var _BH = $a(); /*14305*/
					$1[$k[--$j]] = _BH; /*14305*/
				} /*14305*/
				$k[$j++] = $1.out; /*14307*/
			}; /*14308*/
			$1.encfuncs = $a(["enct", "encn", "encb"]); /*14310*/
			$1.addtocws = function() {
				var _BL = $k[--$j]; /*14313*/
				$puti($1.datcws, $1.j, _BL); /*14313*/
				$1.j = _BL.length + $1.j; /*14314*/
			}; /*14315*/
			$1.state = $1.T; /*14318*/
			$1.submode = $1.A; /*14318*/
			$1.datcws = $a($1.seqlen); /*14319*/
			$1.i = 0; /*14320*/
			$1.j = 0; /*14320*/
			for (;;) { /*14336*/
				if ($1.i >= $1.seq.length) { /*14321*/
					break; /*14321*/
				} /*14321*/
				$1.chars = $get($1.seq, $1.i); /*14322*/
				if ($eq($type($1.chars), "arraytype")) { /*14332*/
					$k[$j++] = $1.chars; /*14324*/
					$1[$get($1.encfuncs, $1.state)](); /*14324*/
					$1.addtocws(); /*14324*/
				} else { /*14332*/
					$k[$j++] = $a([$get($1.latchcws, $1.chars)]); /*14326*/
					$1.addtocws(); /*14326*/
					if ($1.chars == $1.tl) { /*14327*/
						$1.state = $1.T; /*14327*/
						$1.submode = $1.A; /*14327*/
					} /*14327*/
					if ($1.chars == $1.nl) { /*14328*/
						$1.state = $1.N; /*14328*/
					} /*14328*/
					if (($1.chars == $1.bl) || ($1.chars == $1.bl6)) { /*14329*/
						$1.state = $1.B; /*14329*/
					} /*14329*/
					if ($1.chars == $1.bs) { /*14333*/
						$1.i = $1.i + 1; /*14331*/
						$k[$j++] = $get($1.seq, $1.i); /*14332*/
						$1.encb(); /*14332*/
						$1.addtocws(); /*14332*/
					} /*14332*/
				} /*14332*/
				$1.i = $1.i + 1; /*14335*/
			} /*14335*/
			$1.datcws = $geti($1.datcws, 0, $1.j); /*14337*/
		} /*14337*/
		$1.metrics = $a([$a([1, 11, 7, 1, 0, 9]), $a([1, 14, 7, 8, 0, 8]), $a([1, 17, 7, 36, 0, 36]), $a([1, 20, 8, 19, 0, 19]), $a([1, 24, 8, 9, 0, 17]), $a([1, 28, 8, 25, 0, 33]), $a([2, 8, 8, 1, 0, 1]), $a([2, 11, 9, 1, 0, 9]), $a([2, 14, 9, 8, 0, 8]), $a([2, 17, 10, 36, 0, 36]), $a([2, 20, 11, 19, 0, 19]), $a([2, 23, 13, 9, 0, 17]), $a([2, 26, 15, 27, 0, 35]), $a([3, 6, 12, 1, 1, 1]), $a([3, 8, 14, 7, 7, 7]), $a([3, 10, 16, 15, 15, 15]), $a([3, 12, 18, 25, 25, 25]), $a([3, 15, 21, 37, 37, 37]), $a([3, 20, 26, 1, 17, 33]), $a([3, 26, 32, 1, 9, 17]), $a([3, 32, 38, 21, 29, 37]), $a([3, 38, 44, 15, 31, 47]), $a([3, 44, 50, 1, 25, 49]), $a([4, 4, 8, 47, 19, 43]), $a([4, 6, 12, 1, 1, 1]), $a([4, 8, 14, 7, 7, 7]), $a([4, 10, 16, 15, 15, 15]), $a([4, 12, 18, 25, 25, 25]), $a([4, 15, 21, 37, 37, 37]), $a([4, 20, 26, 1, 17, 33]), $a([4, 26, 32, 1, 9, 17]), $a([4, 32, 38, 21, 29, 37]), $a([4, 38, 44, 15, 31, 47]), $a([4, 44, 50, 1, 25, 49])]); /*14377*/
		$1.ccametrics = $a([$a([2, 5, 4, 39, 0, 19]), $a([2, 6, 4, 1, 0, 33]), $a([2, 7, 5, 32, 0, 12]), $a([2, 8, 5, 8, 0, 40]), $a([2, 9, 6, 14, 0, 46]), $a([2, 10, 6, 43, 0, 23]), $a([2, 12, 7, 20, 0, 52]), $a([3, 4, 4, 11, 43, 23]), $a([3, 5, 5, 1, 33, 13]), $a([3, 6, 6, 5, 37, 17]), $a([3, 7, 7, 15, 47, 27]), $a([3, 8, 7, 21, 1, 33]), $a([4, 3, 4, 40, 20, 52]), $a([4, 4, 5, 43, 23, 3]), $a([4, 5, 6, 46, 26, 6]), $a([4, 6, 7, 34, 14, 46]), $a([4, 7, 8, 29, 9, 41])]); /*14399*/
		if ($1.cca) { /*14400*/
			$1.metrics = $1.ccametrics; /*14400*/
		} /*14400*/
		$1.urows = $1.rows; /*14403*/
		$1.ucols = $1.columns; /*14404*/
		$1.i = 0; /*14405*/
		for (;;) { /*14421*/
			$1.m = $get($1.metrics, $1.i); /*14407*/
			$1.c = $get($1.m, 0); /*14408*/
			$1.r = $get($1.m, 1); /*14409*/
			$1.k = $get($1.m, 2); /*14410*/
			$1.rapl = $get($1.m, 3); /*14411*/
			$1.rapc = $get($1.m, 4); /*14412*/
			$1.rapr = $get($1.m, 5); /*14413*/
			$1.ncws = ($1.r * $1.c) - $1.k; /*14414*/
			$1.okay = true; /*14415*/
			if ($1.datcws.length > $1.ncws) { /*14416*/
				$1.okay = false; /*14416*/
			} /*14416*/
			if (($1.urows != 0) && ($1.urows != $1.r)) { /*14417*/
				$1.okay = false; /*14417*/
			} /*14417*/
			if (($1.ucols != 0) && ($1.ucols != $1.c)) { /*14418*/
				$1.okay = false; /*14418*/
			} /*14418*/
			if ($1.okay) { /*14419*/
				break; /*14419*/
			} /*14419*/
			$1.i = $1.i + 1; /*14420*/
		} /*14420*/
		$1.m = $1.datcws.length; /*14422*/
		$1.n = ($1.c * $1.r) - $1.k; /*14425*/
		$1.cws = $a(($1.c * $1.r) + 1); /*14426*/
		$puti($1.cws, 0, $1.datcws); /*14427*/
		$k[$j++] = $1.cws; /*14428*/
		$k[$j++] = $1.m; /*14428*/
		$k[$j++] = Infinity; /*14428*/
		for (var _Df = 0, _Dg = $1.n - $1.m; _Df < _Dg; _Df++) { /*14428*/
			$k[$j++] = 900; /*14428*/
		} /*14428*/
		var _Dh = $a(); /*14428*/
		var _Di = $k[--$j]; /*14428*/
		$puti($k[--$j], _Di, _Dh); /*14428*/
		$k[$j++] = $1.cws; /*14429*/
		$k[$j++] = $1.n; /*14429*/
		$k[$j++] = Infinity; /*14429*/
		for (var _Dn = 0, _Do = $1.k; _Dn < _Do; _Dn++) { /*14429*/
			$k[$j++] = 0; /*14429*/
		} /*14429*/
		$k[$j++] = 0; /*14429*/
		var _Dp = $a(); /*14429*/
		var _Dq = $k[--$j]; /*14429*/
		$puti($k[--$j], _Dq, _Dp); /*14429*/
		$k[$j++] = "rsalog"; /*14432*/
		$k[$j++] = Infinity; /*14432*/
		$k[$j++] = 1; /*14432*/
		for (var _Ds = 0, _Dt = 928; _Ds < _Dt; _Ds++) { /*14432*/
			var _Du = $k[--$j]; /*14432*/
			$k[$j++] = _Du; /*14432*/
			$k[$j++] = (_Du * 3) % 929; /*14432*/
		} /*14432*/
		var _Dv = $a(); /*14432*/
		$1[$k[--$j]] = _Dv; /*14432*/
		$1.rslog = $a(929); /*14433*/
		for (var _Dy = 1; _Dy <= 928; _Dy += 1) { /*14434*/
			$put($1.rslog, $get($1.rsalog, _Dy), _Dy); /*14434*/
		} /*14434*/
		$1.rsprod = function() {
			var _E2 = $k[--$j]; /*14438*/
			var _E3 = $k[--$j]; /*14438*/
			$k[$j++] = _E3; /*14442*/
			$k[$j++] = _E2; /*14442*/
			if ((_E2 != 0) && (_E3 != 0)) { /*14441*/
				var _E6 = $get($1.rslog, $k[--$j]); /*14439*/
				var _EB = $get($1.rsalog, (_E6 + $get($1.rslog, $k[--$j])) % 928); /*14439*/
				$k[$j++] = _EB; /*14439*/
			} else { /*14441*/
				$j -= 2; /*14441*/
				$k[$j++] = 0; /*14441*/
			} /*14441*/
		}; /*14443*/
		$k[$j++] = "coeffs"; /*14446*/
		$k[$j++] = Infinity; /*14446*/
		$k[$j++] = 1; /*14446*/
		for (var _ED = 0, _EE = $1.k; _ED < _EE; _ED++) { /*14446*/
			$k[$j++] = 0; /*14446*/
		} /*14446*/
		var _EF = $a(); /*14446*/
		$1[$k[--$j]] = _EF; /*14446*/
		for (var _EJ = 1, _EI = $1.k; _EJ <= _EI; _EJ += 1) { /*14455*/
			$1.i = _EJ; /*14448*/
			$put($1.coeffs, $1.i, $get($1.coeffs, $1.i - 1)); /*14449*/
			for (var _EQ = $1.i - 1; _EQ >= 1; _EQ -= 1) { /*14453*/
				$1.j = _EQ; /*14451*/
				$k[$j++] = $1.coeffs; /*14452*/
				$k[$j++] = $1.j; /*14452*/
				$k[$j++] = $get($1.coeffs, $1.j - 1); /*14452*/
				$k[$j++] = $get($1.coeffs, $1.j); /*14452*/
				$k[$j++] = $get($1.rsalog, $1.i); /*14452*/
				$1.rsprod(); /*14452*/
				var _Ec = $k[--$j]; /*14452*/
				var _Ed = $k[--$j]; /*14452*/
				var _Ee = $k[--$j]; /*14452*/
				$put($k[--$j], _Ee, (_Ed + _Ec) % 929); /*14452*/
			} /*14452*/
			$k[$j++] = $1.coeffs; /*14454*/
			$k[$j++] = 0; /*14454*/
			$k[$j++] = $get($1.coeffs, 0); /*14454*/
			$k[$j++] = $get($1.rsalog, $1.i); /*14454*/
			$1.rsprod(); /*14454*/
			var _Em = $k[--$j]; /*14454*/
			var _En = $k[--$j]; /*14454*/
			$put($k[--$j], _En, _Em); /*14454*/
		} /*14454*/
		$1.coeffs = $geti($1.coeffs, 0, $1.coeffs.length - 1); /*14456*/
		for (var _Et = $1.coeffs.length - 1; _Et >= 0; _Et -= 2) { /*14457*/
			var _Eu = $1.coeffs; /*14457*/
			$put(_Eu, _Et, 929 - $get(_Eu, _Et)); /*14457*/
		} /*14457*/
		for (var _Ey = 0, _Ex = $1.n - 1; _Ey <= _Ex; _Ey += 1) { /*14466*/
			$1.t = ($get($1.cws, _Ey) + $get($1.cws, $1.n)) % 929; /*14461*/
			for (var _F6 = 0, _F5 = $1.k - 1; _F6 <= _F5; _F6 += 1) { /*14465*/
				$1.j = _F6; /*14463*/
				$put($1.cws, $1.n + $1.j, ($get($1.cws, ($1.n + $1.j) + 1) + (929 - (($1.t * $get($1.coeffs, ($1.k - $1.j) - 1)) % 929))) % 929); /*14464*/
			} /*14464*/
		} /*14464*/
		for (var _FN = $1.n, _FM = $1.n + $1.k; _FN <= _FM; _FN += 1) { /*14467*/
			$put($1.cws, _FN, (929 - $get($1.cws, _FN)) % 929); /*14467*/
		} /*14467*/
		$1.cws = $geti($1.cws, 0, $1.cws.length - 1); /*14470*/
		$1.clusters = $a([$a([120256, 125680, 128380, 120032, 125560, 128318, 108736, 119920, 108640, 86080, 108592, 86048, 110016, 120560, 125820, 109792, 120440, 125758, 88256, 109680, 88160, 89536, 110320, 120700, 89312, 110200, 120638, 89200, 110140, 89840, 110460, 89720, 110398, 89980, 128506, 119520, 125304, 128190, 107712, 119408, 125244, 107616, 119352, 84032, 107568, 119324, 84000, 107544, 83984, 108256, 119672, 125374, 85184, 108144, 119612, 85088, 108088, 119582, 85040, 108060, 85728, 108408, 119742, 85616, 108348, 85560, 108318, 85880, 108478, 85820, 85790, 107200, 119152, 125116, 107104, 119096, 125086, 83008, 107056, 119068, 82976, 107032, 82960, 82952, 83648, 107376, 119228, 83552, 107320, 119198, 83504, 107292, 83480, 83468, 83824, 107452, 83768, 107422, 83740, 83900, 106848, 118968, 125022, 82496, 106800, 118940, 82464, 106776, 118926, 82448, 106764, 82440, 106758, 82784, 106936, 119006, 82736, 106908, 82712, 106894, 82700, 82694, 106974, 82830, 82240, 106672, 118876, 82208, 106648, 118862, 82192, 106636, 82184, 106630, 82180, 82352, 82328, 82316, 82080, 118830, 106572, 106566, 82050, 117472, 124280, 127678, 103616, 117360, 124220, 103520, 117304, 124190, 75840, 103472, 75808, 104160, 117624, 124350, 76992, 104048, 117564, 76896, 103992, 76848, 76824, 77536, 104312, 117694, 77424, 104252, 77368, 77340, 77688, 104382, 77628, 77758, 121536, 126320, 128700, 121440, 126264, 128670, 111680, 121392, 126236, 111648, 121368, 126222, 111632, 121356, 103104, 117104, 124092, 112320, 103008, 117048, 124062, 112224, 121656, 126366, 93248, 74784, 102936, 117006, 93216, 112152, 93200, 75456, 103280, 117180, 93888, 75360, 103224, 117150, 93792, 112440, 121758, 93744, 75288, 93720, 75632, 103356, 94064, 75576, 103326, 94008, 112542, 93980, 75708, 94140, 75678, 94110, 121184, 126136, 128606, 111168, 121136, 126108, 111136, 121112, 126094, 111120, 121100, 111112, 111108, 102752, 116920, 123998, 111456, 102704, 116892, 91712, 74272, 121244, 116878, 91680, 74256, 102668, 91664, 111372, 102662, 74244, 74592, 102840, 116958, 92000, 74544, 102812, 91952, 111516, 102798, 91928, 74508, 74502, 74680, 102878, 92088, 74652, 92060, 74638, 92046, 92126, 110912, 121008, 126044, 110880, 120984, 126030, 110864, 120972, 110856, 120966, 110852, 110850, 74048, 102576, 116828, 90944, 74016, 102552, 116814, 90912, 111000, 121038, 90896, 73992, 102534, 90888, 110982, 90884, 74160, 102620, 91056, 74136, 102606, 91032, 111054, 91020, 74118, 91014, 91100, 91086, 110752, 120920, 125998, 110736, 120908, 110728, 120902, 110724, 110722, 73888, 102488, 116782, 90528, 73872, 102476, 90512, 110796, 102470, 90504, 73860, 90500, 73858, 73944, 90584, 90572, 90566, 120876, 120870, 110658, 102444, 73800, 90312, 90308, 90306, 101056, 116080, 123580, 100960, 116024, 70720, 100912, 115996, 70688, 100888, 70672, 70664, 71360, 101232, 116156, 71264, 101176, 116126, 71216, 101148, 71192, 71180, 71536, 101308, 71480, 101278, 71452, 71612, 71582, 118112, 124600, 127838, 105024, 118064, 124572, 104992, 118040, 124558, 104976, 118028, 104968, 118022, 100704, 115896, 123486, 105312, 100656, 115868, 79424, 70176, 118172, 115854, 79392, 105240, 100620, 79376, 70152, 79368, 70496, 100792, 115934, 79712, 70448, 118238, 79664, 105372, 100750, 79640, 70412, 79628, 70584, 100830, 79800, 70556, 79772, 70542, 70622, 79838, 122176, 126640, 128860, 122144, 126616, 128846, 122128, 126604, 122120, 126598, 122116, 104768, 117936, 124508, 113472, 104736, 126684, 124494, 113440, 122264, 126670, 113424, 104712, 117894, 113416, 122246, 104706, 69952, 100528, 115804, 78656, 69920, 100504, 115790, 96064, 78624, 104856, 117966, 96032, 113560, 122318, 100486, 96016, 78600, 104838, 96008, 69890, 70064, 100572, 78768, 70040, 100558, 96176, 78744, 104910, 96152, 113614, 70022, 78726, 70108, 78812, 70094, 96220, 78798, 122016, 126552, 128814, 122000, 126540, 121992, 126534, 121988, 121986, 104608, 117848, 124462, 113056, 104592, 126574, 113040, 122060, 117830, 113032, 104580, 113028, 104578, 113026, 69792, 100440, 115758, 78240, 69776, 100428, 95136, 78224, 104652, 100422, 95120, 113100, 69764, 95112, 78212, 69762, 78210, 69848, 100462, 78296, 69836, 95192, 78284, 69830, 95180, 78278, 69870, 95214, 121936, 126508, 121928, 126502, 121924, 121922, 104528, 117804, 112848, 104520, 117798, 112840, 121958, 112836, 104514, 112834, 69712, 100396, 78032, 69704, 100390, 94672, 78024, 104550, 94664, 112870, 69698, 94660, 78018, 94658, 78060, 94700, 94694, 126486, 121890, 117782, 104484, 104482, 69672, 77928, 94440, 69666, 77922, 99680, 68160, 99632, 68128, 99608, 115342, 68112, 99596, 68104, 99590, 68448, 99768, 115422, 68400, 99740, 68376, 99726, 68364, 68358, 68536, 99806, 68508, 68494, 68574, 101696, 116400, 123740, 101664, 116376, 101648, 116364, 101640, 116358, 101636, 67904, 99504, 115292, 72512, 67872, 116444, 115278, 72480, 101784, 116430, 72464, 67848, 99462, 72456, 101766, 67842, 68016, 99548, 72624, 67992, 99534, 72600, 101838, 72588, 67974, 68060, 72668, 68046, 72654, 118432, 124760, 127918, 118416, 124748, 118408, 124742, 118404, 118402, 101536, 116312, 105888, 101520, 116300, 105872, 118476, 116294, 105864, 101508, 105860, 101506, 105858, 67744, 99416, 72096, 67728, 116334, 80800, 72080, 101580, 99398, 80784, 105932, 67716, 80776, 72068, 67714, 72066, 67800, 99438, 72152, 67788, 80856, 72140, 67782, 80844, 72134, 67822, 72174, 80878, 126800, 128940, 126792, 128934, 126788, 126786, 118352, 124716, 122576, 126828, 124710, 122568, 126822, 122564, 118338, 122562, 101456, 116268, 105680, 101448, 116262, 114128, 105672, 118374, 114120, 122598, 101442, 114116, 105666, 114114, 67664, 99372, 71888, 67656, 99366, 80336, 71880, 101478, 97232, 80328, 105702, 67650, 97224, 114150, 71874, 97220, 67692, 71916, 67686, 80364, 71910, 97260, 80358, 97254, 126760, 128918, 126756, 126754, 118312, 124694, 122472, 126774, 122468, 118306, 122466, 101416, 116246, 105576, 101412, 113896, 105572, 101410, 113892, 105570, 113890, 67624, 99350, 71784, 101430, 80104, 71780, 67618, 96744, 80100, 71778, 96740, 80098, 96738, 71798, 96758, 126738, 122420, 122418, 105524, 113780, 113778, 71732, 79988, 96500, 96498, 66880, 66848, 98968, 66832, 66824, 66820, 66992, 66968, 66956, 66950, 67036, 67022, 100000, 99984, 115532, 99976, 115526, 99972, 99970, 66720, 98904, 69024, 100056, 98892, 69008, 100044, 69000, 100038, 68996, 66690, 68994, 66776, 98926, 69080, 100078, 69068, 66758, 69062, 66798, 69102, 116560, 116552, 116548, 116546, 99920, 102096, 116588, 115494, 102088, 116582, 102084, 99906, 102082, 66640, 68816, 66632, 98854, 73168, 68808, 66628, 73160, 68804, 66626, 73156, 68802, 66668, 68844, 66662, 73196, 68838, 73190, 124840, 124836, 124834, 116520, 118632, 124854, 118628, 116514, 118626, 99880, 115478, 101992, 116534, 106216, 101988, 99874, 106212, 101986, 106210, 66600, 98838, 68712, 99894, 72936, 68708, 66594, 81384, 72932, 68706, 81380, 72930, 66614, 68726, 72950, 81398, 128980, 128978, 124820, 126900, 124818, 126898, 116500, 118580, 116498, 122740, 118578, 122738, 99860, 101940, 99858, 106100, 101938, 114420]), $a([128352, 129720, 125504, 128304, 129692, 125472, 128280, 129678, 125456, 128268, 125448, 128262, 125444, 125792, 128440, 129758, 120384, 125744, 128412, 120352, 125720, 128398, 120336, 125708, 120328, 125702, 120324, 120672, 125880, 128478, 110144, 120624, 125852, 110112, 120600, 125838, 110096, 120588, 110088, 120582, 110084, 110432, 120760, 125918, 89664, 110384, 120732, 89632, 110360, 120718, 89616, 110348, 89608, 110342, 89952, 110520, 120798, 89904, 110492, 89880, 110478, 89868, 90040, 110558, 90012, 89998, 125248, 128176, 129628, 125216, 128152, 129614, 125200, 128140, 125192, 128134, 125188, 125186, 119616, 125360, 128220, 119584, 125336, 128206, 119568, 125324, 119560, 125318, 119556, 119554, 108352, 119728, 125404, 108320, 119704, 125390, 108304, 119692, 108296, 119686, 108292, 108290, 85824, 108464, 119772, 85792, 108440, 119758, 85776, 108428, 85768, 108422, 85764, 85936, 108508, 85912, 108494, 85900, 85894, 85980, 85966, 125088, 128088, 129582, 125072, 128076, 125064, 128070, 125060, 125058, 119200, 125144, 128110, 119184, 125132, 119176, 125126, 119172, 119170, 107424, 119256, 125166, 107408, 119244, 107400, 119238, 107396, 107394, 83872, 107480, 119278, 83856, 107468, 83848, 107462, 83844, 83842, 83928, 107502, 83916, 83910, 83950, 125008, 128044, 125000, 128038, 124996, 124994, 118992, 125036, 118984, 125030, 118980, 118978, 106960, 119020, 106952, 119014, 106948, 106946, 82896, 106988, 82888, 106982, 82884, 82882, 82924, 82918, 124968, 128022, 124964, 124962, 118888, 124982, 118884, 118882, 106728, 118902, 106724, 106722, 82408, 106742, 82404, 82402, 124948, 124946, 118836, 118834, 106612, 106610, 124224, 127664, 129372, 124192, 127640, 129358, 124176, 127628, 124168, 127622, 124164, 124162, 117568, 124336, 127708, 117536, 124312, 127694, 117520, 124300, 117512, 124294, 117508, 117506, 104256, 117680, 124380, 104224, 117656, 124366, 104208, 117644, 104200, 117638, 104196, 104194, 77632, 104368, 117724, 77600, 104344, 117710, 77584, 104332, 77576, 104326, 77572, 77744, 104412, 77720, 104398, 77708, 77702, 77788, 77774, 128672, 129880, 93168, 128656, 129868, 92664, 128648, 129862, 92412, 128644, 128642, 124064, 127576, 129326, 126368, 124048, 129902, 126352, 128716, 127558, 126344, 124036, 126340, 124034, 126338, 117152, 124120, 127598, 121760, 117136, 124108, 121744, 126412, 124102, 121736, 117124, 121732, 117122, 121730, 103328, 117208, 124142, 112544, 103312, 117196, 112528, 121804, 117190, 112520, 103300, 112516, 103298, 112514, 75680, 103384, 117230, 94112, 75664, 103372, 94096, 112588, 103366, 94088, 75652, 94084, 75650, 75736, 103406, 94168, 75724, 94156, 75718, 94150, 75758, 128592, 129836, 91640, 128584, 129830, 91388, 128580, 91262, 128578, 123984, 127532, 126160, 123976, 127526, 126152, 128614, 126148, 123970, 126146, 116944, 124012, 121296, 116936, 124006, 121288, 126182, 121284, 116930, 121282, 102864, 116972, 111568, 102856, 116966, 111560, 121318, 111556, 102850, 111554, 74704, 102892, 92112, 74696, 102886, 92104, 111590, 92100, 74690, 92098, 74732, 92140, 74726, 92134, 128552, 129814, 90876, 128548, 90750, 128546, 123944, 127510, 126056, 128566, 126052, 123938, 126050, 116840, 123958, 121064, 116836, 121060, 116834, 121058, 102632, 116854, 111080, 121078, 111076, 102626, 111074, 74216, 102646, 91112, 74212, 91108, 74210, 91106, 74230, 91126, 128532, 90494, 128530, 123924, 126004, 123922, 126002, 116788, 120948, 116786, 120946, 102516, 110836, 102514, 110834, 73972, 90612, 73970, 90610, 128522, 123914, 125978, 116762, 120890, 102458, 110714, 123552, 127320, 129198, 123536, 127308, 123528, 127302, 123524, 123522, 116128, 123608, 127342, 116112, 123596, 116104, 123590, 116100, 116098, 101280, 116184, 123630, 101264, 116172, 101256, 116166, 101252, 101250, 71584, 101336, 116206, 71568, 101324, 71560, 101318, 71556, 71554, 71640, 101358, 71628, 71622, 71662, 127824, 129452, 79352, 127816, 129446, 79100, 127812, 78974, 127810, 123472, 127276, 124624, 123464, 127270, 124616, 127846, 124612, 123458, 124610, 115920, 123500, 118224, 115912, 123494, 118216, 124646, 118212, 115906, 118210, 100816, 115948, 105424, 100808, 115942, 105416, 118246, 105412, 100802, 105410, 70608, 100844, 79824, 70600, 100838, 79816, 105446, 79812, 70594, 79810, 70636, 79852, 70630, 79846, 129960, 95728, 113404, 129956, 95480, 113278, 129954, 95356, 95294, 127784, 129430, 78588, 128872, 129974, 95996, 78462, 128868, 127778, 95870, 128866, 123432, 127254, 124520, 123428, 126696, 128886, 123426, 126692, 124514, 126690, 115816, 123446, 117992, 115812, 122344, 117988, 115810, 122340, 117986, 122338, 100584, 115830, 104936, 100580, 113640, 104932, 100578, 113636, 104930, 113634, 70120, 100598, 78824, 70116, 96232, 78820, 70114, 96228, 78818, 96226, 70134, 78838, 129940, 94968, 113022, 129938, 94844, 94782, 127764, 78206, 128820, 127762, 95102, 128818, 123412, 124468, 123410, 126580, 124466, 126578, 115764, 117876, 115762, 122100, 117874, 122098, 100468, 104692, 100466, 113140, 104690, 113138, 69876, 78324, 69874, 95220, 78322, 95218, 129930, 94588, 94526, 127754, 128794, 123402, 124442, 126522, 115738, 117818, 121978, 100410, 104570, 112890, 69754, 78074, 94714, 94398, 123216, 127148, 123208, 127142, 123204, 123202, 115408, 123244, 115400, 123238, 115396, 115394, 99792, 115436, 99784, 115430, 99780, 99778, 68560, 99820, 68552, 99814, 68548, 68546, 68588, 68582, 127400, 129238, 72444, 127396, 72318, 127394, 123176, 127126, 123752, 123172, 123748, 123170, 123746, 115304, 123190, 116456, 115300, 116452, 115298, 116450, 99560, 115318, 101864, 99556, 101860, 99554, 101858, 68072, 99574, 72680, 68068, 72676, 68066, 72674, 68086, 72694, 129492, 80632, 105854, 129490, 80508, 80446, 127380, 72062, 127924, 127378, 80766, 127922, 123156, 123700, 123154, 124788, 123698, 124786, 115252, 116340, 115250, 118516, 116338, 118514, 99444, 101620, 99442, 105972, 101618, 105970, 67828, 72180, 67826, 80884, 72178, 80882, 97008, 114044, 96888, 113982, 96828, 96798, 129482, 80252, 130010, 97148, 80190, 97086, 127370, 127898, 128954, 123146, 123674, 124730, 126842, 115226, 116282, 118394, 122618, 99386, 101498, 105722, 114170, 67706, 71930, 80378, 96632, 113854, 96572, 96542, 80062, 96702, 96444, 96414, 96350, 123048, 123044, 123042, 115048, 123062, 115044, 115042, 99048, 115062, 99044, 99042, 67048, 99062, 67044, 67042, 67062, 127188, 68990, 127186, 123028, 123316, 123026, 123314, 114996, 115572, 114994, 115570, 98932, 100084, 98930, 100082, 66804, 69108, 66802, 69106, 129258, 73084, 73022, 127178, 127450, 123018, 123290, 123834, 114970, 115514, 116602, 98874, 99962, 102138, 66682, 68858, 73210, 81272, 106174, 81212, 81182, 72894, 81342, 97648, 114364, 97592, 114334, 97564, 97550, 81084, 97724, 81054, 97694, 97464, 114270, 97436, 97422, 80990, 97502, 97372, 97358, 97326, 114868, 114866, 98676, 98674, 66292, 66290, 123098, 114842, 115130, 98618, 99194, 66170, 67322, 69310, 73404, 73374, 81592, 106334, 81564, 81550, 73310, 81630, 97968, 114524, 97944, 114510, 97932, 97926, 81500, 98012, 81486, 97998, 97880, 114478, 97868, 97862, 81454, 97902, 97836, 97830, 69470, 73564, 73550, 81752, 106414, 81740, 81734, 73518, 81774, 81708, 81702]), $a([109536, 120312, 86976, 109040, 120060, 86496, 108792, 119934, 86256, 108668, 86136, 129744, 89056, 110072, 129736, 88560, 109820, 129732, 88312, 109694, 129730, 88188, 128464, 129772, 89592, 128456, 129766, 89340, 128452, 89214, 128450, 125904, 128492, 125896, 128486, 125892, 125890, 120784, 125932, 120776, 125926, 120772, 120770, 110544, 120812, 110536, 120806, 110532, 84928, 108016, 119548, 84448, 107768, 119422, 84208, 107644, 84088, 107582, 84028, 129640, 85488, 108284, 129636, 85240, 108158, 129634, 85116, 85054, 128232, 129654, 85756, 128228, 85630, 128226, 125416, 128246, 125412, 125410, 119784, 125430, 119780, 119778, 108520, 119798, 108516, 108514, 83424, 107256, 119166, 83184, 107132, 83064, 107070, 83004, 82974, 129588, 83704, 107390, 129586, 83580, 83518, 128116, 83838, 128114, 125172, 125170, 119284, 119282, 107508, 107506, 82672, 106876, 82552, 106814, 82492, 82462, 129562, 82812, 82750, 128058, 125050, 119034, 82296, 106686, 82236, 82206, 82366, 82108, 82078, 76736, 103920, 117500, 76256, 103672, 117374, 76016, 103548, 75896, 103486, 75836, 129384, 77296, 104188, 129380, 77048, 104062, 129378, 76924, 76862, 127720, 129398, 77564, 127716, 77438, 127714, 124392, 127734, 124388, 124386, 117736, 124406, 117732, 117730, 104424, 117750, 104420, 104418, 112096, 121592, 126334, 92608, 111856, 121468, 92384, 111736, 121406, 92272, 111676, 92216, 111646, 92188, 75232, 103160, 117118, 93664, 74992, 103036, 93424, 112252, 102974, 93304, 74812, 93244, 74782, 93214, 129332, 75512, 103294, 129908, 129330, 93944, 75388, 129906, 93820, 75326, 93758, 127604, 75646, 128756, 127602, 94078, 128754, 124148, 126452, 124146, 126450, 117236, 121844, 117234, 121842, 103412, 103410, 91584, 111344, 121212, 91360, 111224, 121150, 91248, 111164, 91192, 111134, 91164, 91150, 74480, 102780, 91888, 74360, 102718, 91768, 111422, 91708, 74270, 91678, 129306, 74620, 129850, 92028, 74558, 91966, 127546, 128634, 124026, 126202, 116986, 121338, 102906, 90848, 110968, 121022, 90736, 110908, 90680, 110878, 90652, 90638, 74104, 102590, 91000, 74044, 90940, 74014, 90910, 74174, 91070, 90480, 110780, 90424, 110750, 90396, 90382, 73916, 90556, 73886, 90526, 90296, 110686, 90268, 90254, 73822, 90334, 90204, 90190, 71136, 101112, 116094, 70896, 100988, 70776, 100926, 70716, 70686, 129204, 71416, 101246, 129202, 71292, 71230, 127348, 71550, 127346, 123636, 123634, 116212, 116210, 101364, 101362, 79296, 105200, 118140, 79072, 105080, 118078, 78960, 105020, 78904, 104990, 78876, 78862, 70384, 100732, 79600, 70264, 100670, 79480, 105278, 79420, 70174, 79390, 129178, 70524, 129466, 79740, 70462, 79678, 127290, 127866, 123514, 124666, 115962, 118266, 100858, 113376, 122232, 126654, 95424, 113264, 122172, 95328, 113208, 122142, 95280, 113180, 95256, 113166, 95244, 78560, 104824, 117950, 95968, 78448, 104764, 95856, 113468, 104734, 95800, 78364, 95772, 78350, 95758, 70008, 100542, 78712, 69948, 96120, 78652, 69918, 96060, 78622, 96030, 70078, 78782, 96190, 94912, 113008, 122044, 94816, 112952, 122014, 94768, 112924, 94744, 112910, 94732, 94726, 78192, 104636, 95088, 78136, 104606, 95032, 113054, 95004, 78094, 94990, 69820, 78268, 69790, 95164, 78238, 95134, 94560, 112824, 121950, 94512, 112796, 94488, 112782, 94476, 94470, 78008, 104542, 94648, 77980, 94620, 77966, 94606, 69726, 78046, 94686, 94384, 112732, 94360, 112718, 94348, 94342, 77916, 94428, 77902, 94414, 94296, 112686, 94284, 94278, 77870, 94318, 94252, 94246, 68336, 99708, 68216, 99646, 68156, 68126, 68476, 68414, 127162, 123258, 115450, 99834, 72416, 101752, 116414, 72304, 101692, 72248, 101662, 72220, 72206, 67960, 99518, 72568, 67900, 72508, 67870, 72478, 68030, 72638, 80576, 105840, 118460, 80480, 105784, 118430, 80432, 105756, 80408, 105742, 80396, 80390, 72048, 101564, 80752, 71992, 101534, 80696, 71964, 80668, 71950, 80654, 67772, 72124, 67742, 80828, 72094, 80798, 114016, 122552, 126814, 96832, 113968, 122524, 96800, 113944, 122510, 96784, 113932, 96776, 113926, 96772, 80224, 105656, 118366, 97120, 80176, 105628, 97072, 114076, 105614, 97048, 80140, 97036, 80134, 97030, 71864, 101470, 80312, 71836, 97208, 80284, 71822, 97180, 80270, 97166, 67678, 71902, 80350, 97246, 96576, 113840, 122460, 96544, 113816, 122446, 96528, 113804, 96520, 113798, 96516, 96514, 80048, 105564, 96688, 80024, 105550, 96664, 113870, 96652, 80006, 96646, 71772, 80092, 71758, 96732, 80078, 96718, 96416, 113752, 122414, 96400, 113740, 96392, 113734, 96388, 96386, 79960, 105518, 96472, 79948, 96460, 79942, 96454, 71726, 79982, 96494, 96336, 113708, 96328, 113702, 96324, 96322, 79916, 96364, 79910, 96358, 96296, 113686, 96292, 96290, 79894, 96310, 66936, 99006, 66876, 66846, 67006, 68976, 100028, 68920, 99998, 68892, 68878, 66748, 69052, 66718, 69022, 73056, 102072, 116574, 73008, 102044, 72984, 102030, 72972, 72966, 68792, 99934, 73144, 68764, 73116, 68750, 73102, 66654, 68830, 73182, 81216, 106160, 118620, 81184, 106136, 118606, 81168, 106124, 81160, 106118, 81156, 81154, 72880, 101980, 81328, 72856, 101966, 81304, 106190, 81292, 72838, 81286, 68700, 72924, 68686, 81372, 72910, 81358, 114336, 122712, 126894, 114320, 122700, 114312, 122694, 114308, 114306, 81056, 106072, 118574, 97696, 81040, 106060, 97680, 114380, 106054, 97672, 81028, 97668, 81026, 97666, 72792, 101934, 81112, 72780, 97752, 81100, 72774, 97740, 81094, 97734, 68654, 72814, 81134, 97774, 114256, 122668, 114248, 122662, 114244, 114242, 80976, 106028, 97488, 80968, 106022, 97480, 114278, 97476, 80962, 97474, 72748, 81004, 72742, 97516, 80998, 97510, 114216, 122646, 114212, 114210, 80936, 106006, 97384, 80932, 97380, 80930, 97378, 72726, 80950, 97398, 114196, 114194, 80916, 97332, 80914, 97330, 66236, 66206, 67256, 99166, 67228, 67214, 66142, 67294, 69296, 100188, 69272, 100174, 69260, 69254, 67164, 69340, 67150, 69326, 73376, 102232, 116654, 73360, 102220, 73352, 102214, 73348, 73346, 69208, 100142, 73432, 102254, 73420, 69190, 73414, 67118, 69230, 73454, 106320, 118700, 106312, 118694, 106308, 106306, 73296, 102188, 81616, 106348, 102182, 81608, 73284, 81604, 73282, 81602, 69164, 73324, 69158, 81644, 73318, 81638, 122792, 126934, 122788, 122786, 106280, 118678, 114536, 106276, 114532, 106274, 114530, 73256, 102166, 81512, 73252, 98024, 81508, 73250, 98020, 81506, 98018, 69142, 73270, 81526, 98038, 122772, 122770, 106260, 114484, 106258, 114482, 73236, 81460, 73234, 97908, 81458, 97906, 122762, 106250, 114458, 73226, 81434, 97850, 66396, 66382, 67416, 99246, 67404, 67398, 66350, 67438, 69456, 100268, 69448, 100262, 69444, 69442, 67372, 69484, 67366, 69478, 102312, 116694, 102308, 102306, 69416, 100246, 73576, 102326, 73572, 69410, 73570, 67350, 69430, 73590, 118740, 118738, 102292, 106420, 102290, 106418, 69396, 73524, 69394, 81780, 73522, 81778, 118730, 102282, 106394, 69386, 73498, 81722, 66476, 66470, 67496, 99286, 67492, 67490, 66454, 67510, 100308, 100306, 67476, 69556, 67474, 69554, 116714])]); /*14712*/
		$1.raps = $a([$a([802, 930, 946, 818, 882, 890, 826, 954, 922, 986, 970, 906, 778, 794, 786, 914, 978, 982, 980, 916, 948, 932, 934, 942, 940, 936, 808, 812, 814, 806, 822, 950, 918, 790, 788, 820, 884, 868, 870, 878, 876, 872, 840, 856, 860, 862, 846, 844, 836, 838, 834, 866]), $a([718, 590, 622, 558, 550, 566, 534, 530, 538, 570, 562, 546, 610, 626, 634, 762, 754, 758, 630, 628, 612, 614, 582, 578, 706, 738, 742, 740, 748, 620, 556, 552, 616, 744, 712, 716, 708, 710, 646, 654, 652, 668, 664, 696, 688, 656, 720, 592, 600, 604, 732, 734])]); /*14727*/
		$1.cwtobits = function() {
			var _Fd = $get($1.clusters, $k[--$j]); /*14731*/
			$1.v = $get(_Fd, $k[--$j]); /*14731*/
			$k[$j++] = Infinity; /*14732*/
			for (var _Fg = 0, _Fh = 17; _Fg < _Fh; _Fg++) { /*14732*/
				$k[$j++] = 0; /*14732*/
			} /*14732*/
			var _Fk = $cvrs($s(17), $1.v, 2); /*14732*/
			for (var _Fl = 0, _Fm = _Fk.length; _Fl < _Fm; _Fl++) { /*14732*/
				$k[$j++] = $get(_Fk, _Fl) - 48; /*14732*/
			} /*14732*/
			var _Fo = $a(); /*14732*/
			$k[$j++] = $geti(_Fo, _Fo.length - 17, 17); /*14733*/
		}; /*14734*/
		$1.raptobits = function() {
			var _Fs = $get($1.raps, $k[--$j]); /*14738*/
			$1.v = $get(_Fs, $k[--$j]); /*14738*/
			$k[$j++] = Infinity; /*14739*/
			for (var _Fv = 0, _Fw = 10; _Fv < _Fw; _Fv++) { /*14739*/
				$k[$j++] = 0; /*14739*/
			} /*14739*/
			var _Fz = $cvrs($s(10), $1.v, 2); /*14739*/
			for (var _G0 = 0, _G1 = _Fz.length; _G0 < _G1; _G0++) { /*14739*/
				$k[$j++] = $get(_Fz, _G0) - 48; /*14739*/
			} /*14739*/
			var _G3 = $a(); /*14739*/
			$k[$j++] = $geti(_G3, _G3.length - 10, 10); /*14740*/
		}; /*14741*/
		$1.rwid = $get($a([38, 55, 82, 99]), $1.c - 1); /*14744*/
		if (($1.c == 3) && $1.cca) { /*14745*/
			$1.rwid = 72; /*14745*/
		} /*14745*/
		$1.pixs = $a($1.rwid * $1.r); /*14746*/
		for (var _GF = 0, _GE = $1.r - 1; _GF <= _GE; _GF += 1) { /*14784*/
			$1.i = _GF; /*14749*/
			$1.clst = (($1.i + $1.rapl) - 1) % 3; /*14750*/
			$k[$j++] = $1.pixs; /*14782*/
			$k[$j++] = $1.rwid * $1.i; /*14782*/
			$k[$j++] = Infinity; /*14782*/
			if ($1.c == 1) { /*14756*/
				$k[$j++] = (($1.i + $1.rapl) - 1) % 52; /*14753*/
				$k[$j++] = 0; /*14753*/
				$1.raptobits(); /*14753*/
				$aload($k[--$j]); /*14753*/
				$k[$j++] = $get($1.cws, $1.i); /*14754*/
				$k[$j++] = $1.clst; /*14754*/
				$1.cwtobits(); /*14754*/
				$aload($k[--$j]); /*14754*/
				$k[$j++] = (($1.i + $1.rapr) - 1) % 52; /*14755*/
				$k[$j++] = 0; /*14755*/
				$1.raptobits(); /*14755*/
				$aload($k[--$j]); /*14755*/
			} /*14755*/
			if ($1.c == 2) { /*14762*/
				$k[$j++] = (($1.i + $1.rapl) - 1) % 52; /*14758*/
				$k[$j++] = 0; /*14758*/
				$1.raptobits(); /*14758*/
				$aload($k[--$j]); /*14758*/
				$k[$j++] = $get($1.cws, $1.i * 2); /*14759*/
				$k[$j++] = $1.clst; /*14759*/
				$1.cwtobits(); /*14759*/
				$aload($k[--$j]); /*14759*/
				$k[$j++] = $get($1.cws, ($1.i * 2) + 1); /*14760*/
				$k[$j++] = $1.clst; /*14760*/
				$1.cwtobits(); /*14760*/
				$aload($k[--$j]); /*14760*/
				$k[$j++] = (($1.i + $1.rapr) - 1) % 52; /*14761*/
				$k[$j++] = 0; /*14761*/
				$1.raptobits(); /*14761*/
				$aload($k[--$j]); /*14761*/
			} /*14761*/
			if ($1.c == 3) { /*14772*/
				if (!$1.cca) { /*14766*/
					$k[$j++] = (($1.i + $1.rapl) - 1) % 52; /*14765*/
					$k[$j++] = 0; /*14765*/
					$1.raptobits(); /*14765*/
					$aload($k[--$j]); /*14765*/
				} /*14765*/
				$k[$j++] = $get($1.cws, $1.i * 3); /*14767*/
				$k[$j++] = $1.clst; /*14767*/
				$1.cwtobits(); /*14767*/
				$aload($k[--$j]); /*14767*/
				$k[$j++] = (($1.i + $1.rapc) - 1) % 52; /*14768*/
				$k[$j++] = 1; /*14768*/
				$1.raptobits(); /*14768*/
				$aload($k[--$j]); /*14768*/
				$k[$j++] = $get($1.cws, ($1.i * 3) + 1); /*14769*/
				$k[$j++] = $1.clst; /*14769*/
				$1.cwtobits(); /*14769*/
				$aload($k[--$j]); /*14769*/
				$k[$j++] = $get($1.cws, ($1.i * 3) + 2); /*14770*/
				$k[$j++] = $1.clst; /*14770*/
				$1.cwtobits(); /*14770*/
				$aload($k[--$j]); /*14770*/
				$k[$j++] = (($1.i + $1.rapr) - 1) % 52; /*14771*/
				$k[$j++] = 0; /*14771*/
				$1.raptobits(); /*14771*/
				$aload($k[--$j]); /*14771*/
			} /*14771*/
			if ($1.c == 4) { /*14781*/
				$k[$j++] = (($1.i + $1.rapl) - 1) % 52; /*14774*/
				$k[$j++] = 0; /*14774*/
				$1.raptobits(); /*14774*/
				$aload($k[--$j]); /*14774*/
				$k[$j++] = $get($1.cws, $1.i * 4); /*14775*/
				$k[$j++] = $1.clst; /*14775*/
				$1.cwtobits(); /*14775*/
				$aload($k[--$j]); /*14775*/
				$k[$j++] = $get($1.cws, ($1.i * 4) + 1); /*14776*/
				$k[$j++] = $1.clst; /*14776*/
				$1.cwtobits(); /*14776*/
				$aload($k[--$j]); /*14776*/
				$k[$j++] = (($1.i + $1.rapc) - 1) % 52; /*14777*/
				$k[$j++] = 1; /*14777*/
				$1.raptobits(); /*14777*/
				$aload($k[--$j]); /*14777*/
				$k[$j++] = $get($1.cws, ($1.i * 4) + 2); /*14778*/
				$k[$j++] = $1.clst; /*14778*/
				$1.cwtobits(); /*14778*/
				$aload($k[--$j]); /*14778*/
				$k[$j++] = $get($1.cws, ($1.i * 4) + 3); /*14779*/
				$k[$j++] = $1.clst; /*14779*/
				$1.cwtobits(); /*14779*/
				$aload($k[--$j]); /*14779*/
				$k[$j++] = (($1.i + $1.rapr) - 1) % 52; /*14780*/
				$k[$j++] = 0; /*14780*/
				$1.raptobits(); /*14780*/
				$aload($k[--$j]); /*14780*/
			} /*14780*/
			$k[$j++] = 1; /*14782*/
			var _Hi = $a(); /*14782*/
			var _Hj = $k[--$j]; /*14783*/
			$puti($k[--$j], _Hj, _Hi); /*14783*/
		} /*14783*/
		var _Hs = {
			ren: $0.renmatrix,
			pixs: $1.pixs,
			pixx: $1.rwid,
			pixy: $1.r,
			height: ($1.r / 72) * $1.rowmult,
			width: $1.rwid / 72,
			opt: $1.options
		}; /*14794*/
		$k[$j++] = _Hs; /*14797*/
		if (!$1.dontdraw) { /*14797*/
			$0.renmatrix(); /*14797*/
		} /*14797*/
	};
	$0.datamatrix = function() {
		var $1 = {}; /*14824*/
		$1.options = $k[--$j]; /*14826*/
		$1.barcode = $k[--$j]; /*14827*/
		$1.dontdraw = false; /*14829*/
		$1.columns = 0; /*14830*/
		$1.rows = 0; /*14831*/
		$1.format = "square"; /*14832*/
		$1.version = "unset"; /*14833*/
		$1.parse = false; /*14834*/
		$1.parsefnc = false; /*14835*/
		$1.dmre = false; /*14836*/
		$forall($1.options, function() { /*14847*/
			var _3 = $k[--$j]; /*14847*/
			$1[$k[--$j]] = _3; /*14847*/
		}) /*14847*/
		if ($ne($1.version, "unset")) { /*14853*/
			$search($1.version, "x"); /*14850*/
			$j--; /*14851*/
			$1.rows = $k[--$j]; /*14851*/
			$j--; /*14852*/
			$1.columns = $k[--$j]; /*14852*/
		} /*14852*/
		$1.columns = ~~$z($1.columns); /*14855*/
		$1.rows = ~~$z($1.rows); /*14856*/
		$1.mac05comp = false; /*14880*/
		$1.mac06comp = false; /*14881*/
		if ($1.barcode.length >= 9) { /*14890*/
			var _D = $geti($1.barcode, 0, 7); /*14883*/
			if ((($eq(_D, "[)>03605035")) || ($eq(_D, "[)>03606035"))) && $eq($geti($1.barcode, $1.barcode.length - 2, 2), "036004")) { /*14889*/
				if ($get($1.barcode, 5) == 53) { /*14887*/
					$k[$j++] = "mac05comp"; /*14887*/
				} else { /*14887*/
					$k[$j++] = "mac06comp"; /*14887*/
				} /*14887*/
				$1[$k[--$j]] = true; /*14887*/
				$1.barcode = $geti($1.barcode, 7, $1.barcode.length - 9); /*14888*/
			} /*14888*/
		} /*14888*/
		$1.barlen = $1.barcode.length; /*14892*/
		$1.fnc1 = -1; /*14895*/
		$1.prog = -2; /*14895*/
		$1.m05 = -3; /*14895*/
		$1.m06 = -4; /*14895*/
		var _S = {
			FNC1: $1.fnc1,
			PROG: $1.prog,
			MAC5: $1.m05,
			MAC6: $1.m06
		}; /*14900*/
		$1.fncvals = _S; /*14901*/
		$1.msg = $a($1.barlen); /*14902*/
		$1.i = 0; /*14903*/
		$1.j = 0; /*14903*/
		for (;;) { /*14917*/
			if ($1.i == $1.barlen) { /*14904*/
				break; /*14904*/
			} /*14904*/
			$1.char = $get($1.barcode, $1.i); /*14905*/
			if (($1.parsefnc && ($1.char == 94)) && ($1.i < ($1.barlen - 4))) { /*14913*/
				if ($get($1.barcode, $1.i + 1) != 94) { /*14911*/
					$1.char = $get($1.fncvals, $geti($1.barcode, $1.i + 1, 4)); /*14908*/
					$1.i = $1.i + 4; /*14909*/
				} else { /*14911*/
					$1.i = $1.i + 1; /*14911*/
				} /*14911*/
			} /*14911*/
			$put($1.msg, $1.j, $1.char); /*14914*/
			$1.i = $1.i + 1; /*14915*/
			$1.j = $1.j + 1; /*14916*/
		} /*14916*/
		$1.msg = $geti($1.msg, 0, $1.j); /*14918*/
		if ($1.mac05comp) { /*14921*/
			$k[$j++] = "msg"; /*14921*/
			$k[$j++] = Infinity; /*14921*/
			$k[$j++] = $1.m05; /*14921*/
			$aload($1.msg); /*14921*/
			var _z = $a(); /*14921*/
			$1[$k[--$j]] = _z; /*14921*/
		} /*14921*/
		if ($1.mac06comp) { /*14922*/
			$k[$j++] = "msg"; /*14922*/
			$k[$j++] = Infinity; /*14922*/
			$k[$j++] = $1.m06; /*14922*/
			$aload($1.msg); /*14922*/
			var _14 = $a(); /*14922*/
			$1[$k[--$j]] = _14; /*14922*/
		} /*14922*/
		$1.msglen = $1.msg.length; /*14924*/
		$k[$j++] = "metrics"; /*14972*/
		$k[$j++] = Infinity; /*14972*/
		$k[$j++] = $a([10, 10, 1, 1, 5, 1]); /*14957*/
		$k[$j++] = $a([12, 12, 1, 1, 7, 1]); /*14957*/
		$k[$j++] = $a([14, 14, 1, 1, 10, 1]); /*14957*/
		$k[$j++] = $a([16, 16, 1, 1, 12, 1]); /*14957*/
		$k[$j++] = $a([18, 18, 1, 1, 14, 1]); /*14957*/
		$k[$j++] = $a([20, 20, 1, 1, 18, 1]); /*14957*/
		$k[$j++] = $a([22, 22, 1, 1, 20, 1]); /*14957*/
		$k[$j++] = $a([24, 24, 1, 1, 24, 1]); /*14957*/
		$k[$j++] = $a([26, 26, 1, 1, 28, 1]); /*14957*/
		$k[$j++] = $a([32, 32, 2, 2, 36, 1]); /*14957*/
		$k[$j++] = $a([36, 36, 2, 2, 42, 1]); /*14957*/
		$k[$j++] = $a([40, 40, 2, 2, 48, 1]); /*14957*/
		$k[$j++] = $a([44, 44, 2, 2, 56, 1]); /*14957*/
		$k[$j++] = $a([48, 48, 2, 2, 68, 1]); /*14957*/
		$k[$j++] = $a([52, 52, 2, 2, 84, 2]); /*14957*/
		$k[$j++] = $a([64, 64, 4, 4, 112, 2]); /*14957*/
		$k[$j++] = $a([72, 72, 4, 4, 144, 4]); /*14957*/
		$k[$j++] = $a([80, 80, 4, 4, 192, 4]); /*14957*/
		$k[$j++] = $a([88, 88, 4, 4, 224, 4]); /*14957*/
		$k[$j++] = $a([96, 96, 4, 4, 272, 4]); /*14957*/
		$k[$j++] = $a([104, 104, 4, 4, 336, 6]); /*14957*/
		$k[$j++] = $a([120, 120, 6, 6, 408, 6]); /*14957*/
		$k[$j++] = $a([132, 132, 6, 6, 496, 8]); /*14957*/
		$k[$j++] = $a([144, 144, 6, 6, 620, 10]); /*14957*/
		$k[$j++] = $a([8, 18, 1, 1, 7, 1]); /*14957*/
		$k[$j++] = $a([8, 32, 1, 2, 11, 1]); /*14957*/
		if ($1.dmre) { /*14957*/
			$k[$j++] = $a([8, 48, 1, 2, 15, 1]); /*14957*/
		} /*14957*/
		if ($1.dmre) { /*14958*/
			$k[$j++] = $a([8, 64, 1, 4, 18, 1]); /*14958*/
		} /*14958*/
		$k[$j++] = $a([12, 26, 1, 1, 14, 1]); /*14961*/
		$k[$j++] = $a([12, 36, 1, 2, 18, 1]); /*14961*/
		if ($1.dmre) { /*14961*/
			$k[$j++] = $a([12, 64, 1, 4, 27, 1]); /*14961*/
		} /*14961*/
		$k[$j++] = $a([16, 36, 1, 2, 24, 1]); /*14964*/
		$k[$j++] = $a([16, 48, 1, 2, 28, 1]); /*14964*/
		if ($1.dmre) { /*14964*/
			$k[$j++] = $a([16, 64, 1, 4, 36, 1]); /*14964*/
		} /*14964*/
		if ($1.dmre) { /*14965*/
			$k[$j++] = $a([24, 32, 1, 2, 28, 1]); /*14965*/
		} /*14965*/
		if ($1.dmre) { /*14966*/
			$k[$j++] = $a([24, 36, 1, 2, 33, 1]); /*14966*/
		} /*14966*/
		if ($1.dmre) { /*14967*/
			$k[$j++] = $a([24, 48, 1, 2, 41, 1]); /*14967*/
		} /*14967*/
		if ($1.dmre) { /*14968*/
			$k[$j++] = $a([24, 64, 1, 4, 46, 1]); /*14968*/
		} /*14968*/
		if ($1.dmre) { /*14969*/
			$k[$j++] = $a([26, 32, 1, 2, 32, 1]); /*14969*/
		} /*14969*/
		if ($1.dmre) { /*14970*/
			$k[$j++] = $a([26, 40, 1, 2, 38, 1]); /*14970*/
		} /*14970*/
		if ($1.dmre) { /*14971*/
			$k[$j++] = $a([26, 48, 1, 2, 42, 1]); /*14971*/
		} /*14971*/
		if ($1.dmre) { /*14972*/
			$k[$j++] = $a([26, 64, 1, 4, 50, 1]); /*14972*/
		} /*14972*/
		var _1z = $a(); /*14972*/
		$1[$k[--$j]] = _1z; /*14973*/
		$1.urows = $1.rows; /*14976*/
		$1.ucols = $1.columns; /*14977*/
		$1.fullcws = $a([]); /*14978*/
		$forall($1.metrics, function() { /*14996*/
			$1.m = $k[--$j]; /*14980*/
			$1.rows = $get($1.m, 0); /*14981*/
			$1.cols = $get($1.m, 1); /*14982*/
			$1.regh = $get($1.m, 2); /*14983*/
			$1.regv = $get($1.m, 3); /*14984*/
			$1.rscw = $get($1.m, 4); /*14985*/
			$1.rsbl = $get($1.m, 5); /*14986*/
			$1.mrows = $1.rows - (2 * $1.regh); /*14987*/
			$1.mcols = $1.cols - (2 * $1.regv); /*14988*/
			$1.ncws = (~~(($1.mrows * $1.mcols) / 8)) - $1.rscw; /*14989*/
			$1.okay = true; /*14990*/
			if (($1.urows != 0) && ($1.urows != $1.rows)) { /*14991*/
				$1.okay = false; /*14991*/
			} /*14991*/
			if (($1.ucols != 0) && ($1.ucols != $1.cols)) { /*14992*/
				$1.okay = false; /*14992*/
			} /*14992*/
			if ($eq($1.format, "square") && $ne($1.rows, $1.cols)) { /*14993*/
				$1.okay = false; /*14993*/
			} /*14993*/
			if ($eq($1.format, "rectangle") && $eq($1.rows, $1.cols)) { /*14994*/
				$1.okay = false; /*14994*/
			} /*14994*/
			if ($1.okay) { /*14995*/
				$k[$j++] = "fullcws"; /*14995*/
				$k[$j++] = Infinity; /*14995*/
				$aload($1.fullcws); /*14995*/
				$k[$j++] = $1.ncws; /*14995*/
				var _2e = $a(); /*14995*/
				$1[$k[--$j]] = _2e; /*14995*/
			} /*14995*/
		}) /*14995*/
		$k[$j++] = "numremcws"; /*14997*/
		$k[$j++] = Infinity; /*14997*/
		for (var _2g = 0, _2h = 1558; _2g < _2h; _2g++) { /*14997*/
			$k[$j++] = 10000; /*14997*/
		} /*14997*/
		var _2i = $a(); /*14997*/
		$1[$k[--$j]] = _2i; /*14997*/
		var _2k = $1.fullcws; /*14998*/
		for (var _2l = 0, _2m = _2k.length; _2l < _2m; _2l++) { /*14998*/
			$put($1.numremcws, $get(_2k, _2l) - 1, 1); /*14998*/
		} /*14998*/
		for (var _2p = 1556; _2p >= 0; _2p -= 1) { /*15004*/
			$1.i = _2p; /*15000*/
			if ($get($1.numremcws, $1.i) != 1) { /*15003*/
				$put($1.numremcws, $1.i, $get($1.numremcws, $1.i + 1) + 1); /*15002*/
			} /*15002*/
		} /*15002*/
		$1.lC = -5; /*15007*/
		$1.lB = -6; /*15007*/
		$1.lX = -7; /*15007*/
		$1.lT = -8; /*15007*/
		$1.lE = -9; /*15007*/
		$1.unl = -10; /*15007*/
		$1.sapp = -11; /*15008*/
		$1.usft = -12; /*15008*/
		$1.sft1 = -13; /*15008*/
		$1.sft2 = -14; /*15008*/
		$1.sft3 = -15; /*15008*/
		$1.eci = -16; /*15008*/
		$1.pad = -17; /*15008*/
		$1.unlcw = 254; /*15009*/
		$k[$j++] = "Avals"; /*15018*/
		$k[$j++] = Infinity; /*15018*/
		for (var _2y = 0; _2y <= 128; _2y += 1) { /*15012*/
			$k[$j++] = _2y; /*15012*/
			$k[$j++] = _2y + 1; /*15012*/
		} /*15012*/
		$k[$j++] = $1.pad; /*15017*/
		$k[$j++] = 129; /*15017*/
		for (var _30 = 0; _30 <= 99; _30 += 1) { /*15017*/
			var _32 = $cvrs($s(2), _30, 10); /*15015*/
			var _34 = $strcpy($s(2), "00"); /*15015*/
			$puti(_34, 2 - _32.length, _32); /*15015*/
			$k[$j++] = _34; /*15016*/
			$k[$j++] = _30 + 130; /*15016*/
		} /*15016*/
		var _3H = $a([$1.lC, $1.lB, $1.fnc1, $1.sapp, $1.prog, $1.usft, $1.m05, $1.m06, $1.lX, $1.lT, $1.lE, $1.eci]); /*15018*/
		$k[$j++] = 229; /*15018*/
		for (var _3I = 0, _3J = _3H.length; _3I < _3J; _3I++) { /*15018*/
			var _3M = $k[--$j] + 1; /*15018*/
			$k[$j++] = $get(_3H, _3I); /*15018*/
			$k[$j++] = _3M; /*15018*/
			$k[$j++] = _3M; /*15018*/
		} /*15018*/
		$j--; /*15018*/
		var _3N = $d(); /*15018*/
		$1[$k[--$j]] = _3N; /*15019*/
		$k[$j++] = "Avals"; /*15021*/
		$k[$j++] = Infinity; /*15021*/
		$forall($1.Avals, function() { /*15021*/
			$k[$j++] = Infinity; /*15021*/
			var _3Q = $k[--$j]; /*15021*/
			var _3R = $k[--$j]; /*15021*/
			$k[$j++] = _3Q; /*15021*/
			$k[$j++] = _3R; /*15021*/
			var _3S = $a(); /*15021*/
			$k[$j++] = _3S; /*15021*/
		}) /*15021*/
		var _3T = $d(); /*15021*/
		$1[$k[--$j]] = _3T; /*15022*/
		$k[$j++] = "CNvals"; /*15030*/
		$k[$j++] = Infinity; /*15030*/
		$k[$j++] = $1.sft1; /*15029*/
		$k[$j++] = 0; /*15029*/
		$k[$j++] = $1.sft2; /*15029*/
		$k[$j++] = 1; /*15029*/
		$k[$j++] = $1.sft3; /*15029*/
		$k[$j++] = 2; /*15029*/
		$k[$j++] = 32; /*15029*/
		$k[$j++] = 3; /*15029*/
		for (var _3Y = 48; _3Y <= 57; _3Y += 1) { /*15029*/
			$k[$j++] = _3Y; /*15029*/
			$k[$j++] = _3Y - 44; /*15029*/
		} /*15029*/
		for (var _3Z = 65; _3Z <= 90; _3Z += 1) { /*15030*/
			$k[$j++] = _3Z; /*15030*/
			$k[$j++] = _3Z - 51; /*15030*/
		} /*15030*/
		var _3a = $d(); /*15030*/
		$1[$k[--$j]] = _3a; /*15031*/
		$k[$j++] = "C1vals"; /*15032*/
		$k[$j++] = Infinity; /*15032*/
		for (var _3c = 0; _3c <= 31; _3c += 1) { /*15032*/
			$k[$j++] = _3c; /*15032*/
			$k[$j++] = _3c; /*15032*/
		} /*15032*/
		var _3d = $d(); /*15032*/
		$1[$k[--$j]] = _3d; /*15032*/
		$k[$j++] = "C2vals"; /*15038*/
		$k[$j++] = Infinity; /*15038*/
		for (var _3f = 33; _3f <= 47; _3f += 1) { /*15034*/
			$k[$j++] = _3f; /*15034*/
			$k[$j++] = _3f - 33; /*15034*/
		} /*15034*/
		for (var _3g = 58; _3g <= 64; _3g += 1) { /*15035*/
			$k[$j++] = _3g; /*15035*/
			$k[$j++] = _3g - 43; /*15035*/
		} /*15035*/
		for (var _3h = 91; _3h <= 95; _3h += 1) { /*15036*/
			$k[$j++] = _3h; /*15036*/
			$k[$j++] = _3h - 69; /*15036*/
		} /*15036*/
		$k[$j++] = $1.fnc1; /*15038*/
		$k[$j++] = 27; /*15038*/
		$k[$j++] = $1.usft; /*15038*/
		$k[$j++] = 30; /*15038*/
		var _3k = $d(); /*15038*/
		$1[$k[--$j]] = _3k; /*15039*/
		$k[$j++] = "C3vals"; /*15040*/
		$k[$j++] = Infinity; /*15040*/
		for (var _3m = 96; _3m <= 127; _3m += 1) { /*15040*/
			$k[$j++] = _3m; /*15040*/
			$k[$j++] = _3m - 96; /*15040*/
		} /*15040*/
		var _3n = $d(); /*15040*/
		$1[$k[--$j]] = _3n; /*15040*/
		$k[$j++] = "Cvals"; /*15045*/
		$k[$j++] = Infinity; /*15045*/
		$forall($1.CNvals, function() { /*15042*/
			$k[$j++] = Infinity; /*15042*/
			var _3q = $k[--$j]; /*15042*/
			var _3r = $k[--$j]; /*15042*/
			$k[$j++] = _3q; /*15042*/
			$k[$j++] = _3r; /*15042*/
			var _3s = $a(); /*15042*/
			$k[$j++] = _3s; /*15042*/
		}) /*15042*/
		$forall($1.C1vals, function() { /*15043*/
			$k[$j++] = Infinity; /*15043*/
			var _3u = $k[--$j]; /*15043*/
			var _3v = $k[--$j]; /*15043*/
			$k[$j++] = _3u; /*15043*/
			$k[$j++] = $get($1.CNvals, $1.sft1); /*15043*/
			$k[$j++] = _3v; /*15043*/
			var _3z = $a(); /*15043*/
			$k[$j++] = _3z; /*15043*/
		}) /*15043*/
		$forall($1.C2vals, function() { /*15044*/
			$k[$j++] = Infinity; /*15044*/
			var _41 = $k[--$j]; /*15044*/
			var _42 = $k[--$j]; /*15044*/
			$k[$j++] = _41; /*15044*/
			$k[$j++] = $get($1.CNvals, $1.sft2); /*15044*/
			$k[$j++] = _42; /*15044*/
			var _46 = $a(); /*15044*/
			$k[$j++] = _46; /*15044*/
		}) /*15044*/
		$forall($1.C3vals, function() { /*15045*/
			$k[$j++] = Infinity; /*15045*/
			var _48 = $k[--$j]; /*15045*/
			var _49 = $k[--$j]; /*15045*/
			$k[$j++] = _48; /*15045*/
			$k[$j++] = $get($1.CNvals, $1.sft3); /*15045*/
			$k[$j++] = _49; /*15045*/
			var _4D = $a(); /*15045*/
			$k[$j++] = _4D; /*15045*/
		}) /*15045*/
		var _4E = $d(); /*15045*/
		$1[$k[--$j]] = _4E; /*15046*/
		$k[$j++] = "TNvals"; /*15054*/
		$k[$j++] = Infinity; /*15054*/
		$k[$j++] = $1.sft1; /*15053*/
		$k[$j++] = 0; /*15053*/
		$k[$j++] = $1.sft2; /*15053*/
		$k[$j++] = 1; /*15053*/
		$k[$j++] = $1.sft3; /*15053*/
		$k[$j++] = 2; /*15053*/
		$k[$j++] = 32; /*15053*/
		$k[$j++] = 3; /*15053*/
		for (var _4J = 48; _4J <= 57; _4J += 1) { /*15053*/
			$k[$j++] = _4J; /*15053*/
			$k[$j++] = _4J - 44; /*15053*/
		} /*15053*/
		for (var _4K = 97; _4K <= 122; _4K += 1) { /*15054*/
			$k[$j++] = _4K; /*15054*/
			$k[$j++] = _4K - 83; /*15054*/
		} /*15054*/
		var _4L = $d(); /*15054*/
		$1[$k[--$j]] = _4L; /*15055*/
		$k[$j++] = "T1vals"; /*15056*/
		$k[$j++] = Infinity; /*15056*/
		for (var _4N = 0; _4N <= 31; _4N += 1) { /*15056*/
			$k[$j++] = _4N; /*15056*/
			$k[$j++] = _4N; /*15056*/
		} /*15056*/
		var _4O = $d(); /*15056*/
		$1[$k[--$j]] = _4O; /*15056*/
		$k[$j++] = "T2vals"; /*15062*/
		$k[$j++] = Infinity; /*15062*/
		for (var _4Q = 33; _4Q <= 47; _4Q += 1) { /*15058*/
			$k[$j++] = _4Q; /*15058*/
			$k[$j++] = _4Q - 33; /*15058*/
		} /*15058*/
		for (var _4R = 58; _4R <= 64; _4R += 1) { /*15059*/
			$k[$j++] = _4R; /*15059*/
			$k[$j++] = _4R - 43; /*15059*/
		} /*15059*/
		for (var _4S = 91; _4S <= 95; _4S += 1) { /*15060*/
			$k[$j++] = _4S; /*15060*/
			$k[$j++] = _4S - 69; /*15060*/
		} /*15060*/
		$k[$j++] = $1.fnc1; /*15062*/
		$k[$j++] = 27; /*15062*/
		$k[$j++] = $1.usft; /*15062*/
		$k[$j++] = 30; /*15062*/
		var _4V = $d(); /*15062*/
		$1[$k[--$j]] = _4V; /*15063*/
		$k[$j++] = "T3vals"; /*15067*/
		$k[$j++] = Infinity; /*15067*/
		$k[$j++] = 96; /*15066*/
		$k[$j++] = 0; /*15066*/
		for (var _4X = 65; _4X <= 90; _4X += 1) { /*15066*/
			$k[$j++] = _4X; /*15066*/
			$k[$j++] = _4X - 64; /*15066*/
		} /*15066*/
		for (var _4Y = 123; _4Y <= 127; _4Y += 1) { /*15067*/
			$k[$j++] = _4Y; /*15067*/
			$k[$j++] = _4Y - 96; /*15067*/
		} /*15067*/
		var _4Z = $d(); /*15067*/
		$1[$k[--$j]] = _4Z; /*15068*/
		$k[$j++] = "Tvals"; /*15073*/
		$k[$j++] = Infinity; /*15073*/
		$forall($1.TNvals, function() { /*15070*/
			$k[$j++] = Infinity; /*15070*/
			var _4c = $k[--$j]; /*15070*/
			var _4d = $k[--$j]; /*15070*/
			$k[$j++] = _4c; /*15070*/
			$k[$j++] = _4d; /*15070*/
			var _4e = $a(); /*15070*/
			$k[$j++] = _4e; /*15070*/
		}) /*15070*/
		$forall($1.T1vals, function() { /*15071*/
			$k[$j++] = Infinity; /*15071*/
			var _4g = $k[--$j]; /*15071*/
			var _4h = $k[--$j]; /*15071*/
			$k[$j++] = _4g; /*15071*/
			$k[$j++] = $get($1.TNvals, $1.sft1); /*15071*/
			$k[$j++] = _4h; /*15071*/
			var _4l = $a(); /*15071*/
			$k[$j++] = _4l; /*15071*/
		}) /*15071*/
		$forall($1.T2vals, function() { /*15072*/
			$k[$j++] = Infinity; /*15072*/
			var _4n = $k[--$j]; /*15072*/
			var _4o = $k[--$j]; /*15072*/
			$k[$j++] = _4n; /*15072*/
			$k[$j++] = $get($1.TNvals, $1.sft2); /*15072*/
			$k[$j++] = _4o; /*15072*/
			var _4s = $a(); /*15072*/
			$k[$j++] = _4s; /*15072*/
		}) /*15072*/
		$forall($1.T3vals, function() { /*15073*/
			$k[$j++] = Infinity; /*15073*/
			var _4u = $k[--$j]; /*15073*/
			var _4v = $k[--$j]; /*15073*/
			$k[$j++] = _4u; /*15073*/
			$k[$j++] = $get($1.TNvals, $1.sft3); /*15073*/
			$k[$j++] = _4v; /*15073*/
			var _4z = $a(); /*15073*/
			$k[$j++] = _4z; /*15073*/
		}) /*15073*/
		var _50 = $d(); /*15073*/
		$1[$k[--$j]] = _50; /*15074*/
		for (var _52 = 128; _52 <= 255; _52 += 1) { /*15082*/
			$1.i = _52; /*15078*/
			$k[$j++] = $1.Avals; /*15079*/
			$k[$j++] = $1.i; /*15079*/
			$k[$j++] = Infinity; /*15079*/
			$aload($get($1.Avals, $1.usft)); /*15079*/
			$aload($get($1.Avals, $1.i - 128)); /*15079*/
			var _5B = $a(); /*15079*/
			var _5C = $k[--$j]; /*15079*/
			$put($k[--$j], _5C, _5B); /*15079*/
			$k[$j++] = $1.Cvals; /*15080*/
			$k[$j++] = $1.i; /*15080*/
			$k[$j++] = Infinity; /*15080*/
			$aload($get($1.Cvals, $1.usft)); /*15080*/
			$aload($get($1.Cvals, $1.i - 128)); /*15080*/
			var _5M = $a(); /*15080*/
			var _5N = $k[--$j]; /*15080*/
			$put($k[--$j], _5N, _5M); /*15080*/
			$k[$j++] = $1.Tvals; /*15081*/
			$k[$j++] = $1.i; /*15081*/
			$k[$j++] = Infinity; /*15081*/
			$aload($get($1.Tvals, $1.usft)); /*15081*/
			$aload($get($1.Tvals, $1.i - 128)); /*15081*/
			var _5X = $a(); /*15081*/
			var _5Y = $k[--$j]; /*15081*/
			$put($k[--$j], _5Y, _5X); /*15081*/
		} /*15081*/
		$k[$j++] = "Xvals"; /*15090*/
		$k[$j++] = Infinity; /*15090*/
		$k[$j++] = 13; /*15089*/
		$k[$j++] = 0; /*15089*/
		$k[$j++] = 42; /*15089*/
		$k[$j++] = 1; /*15089*/
		$k[$j++] = 62; /*15089*/
		$k[$j++] = 2; /*15089*/
		$k[$j++] = 32; /*15089*/
		$k[$j++] = 3; /*15089*/
		for (var _5a = 48; _5a <= 57; _5a += 1) { /*15089*/
			$k[$j++] = _5a; /*15089*/
			$k[$j++] = _5a - 44; /*15089*/
		} /*15089*/
		for (var _5b = 65; _5b <= 90; _5b += 1) { /*15090*/
			$k[$j++] = _5b; /*15090*/
			$k[$j++] = _5b - 51; /*15090*/
		} /*15090*/
		var _5c = $d(); /*15090*/
		$1[$k[--$j]] = _5c; /*15091*/
		$k[$j++] = "Xvals"; /*15093*/
		$k[$j++] = Infinity; /*15093*/
		$forall($1.Xvals, function() { /*15093*/
			$k[$j++] = Infinity; /*15093*/
			var _5f = $k[--$j]; /*15093*/
			var _5g = $k[--$j]; /*15093*/
			$k[$j++] = _5f; /*15093*/
			$k[$j++] = _5g; /*15093*/
			var _5h = $a(); /*15093*/
			$k[$j++] = _5h; /*15093*/
		}) /*15093*/
		var _5i = $d(); /*15093*/
		$1[$k[--$j]] = _5i; /*15094*/
		$k[$j++] = "Evals"; /*15099*/
		$k[$j++] = Infinity; /*15099*/
		for (var _5k = 64; _5k <= 94; _5k += 1) { /*15097*/
			$k[$j++] = _5k; /*15097*/
			$k[$j++] = _5k - 64; /*15097*/
		} /*15097*/
		$k[$j++] = $1.unl; /*15099*/
		$k[$j++] = 31; /*15099*/
		for (var _5m = 32; _5m <= 63; _5m += 1) { /*15099*/
			$k[$j++] = _5m; /*15099*/
			$k[$j++] = _5m; /*15099*/
		} /*15099*/
		var _5n = $d(); /*15099*/
		$1[$k[--$j]] = _5n; /*15100*/
		$k[$j++] = "Evals"; /*15102*/
		$k[$j++] = Infinity; /*15102*/
		$forall($1.Evals, function() { /*15102*/
			$k[$j++] = Infinity; /*15102*/
			var _5q = $k[--$j]; /*15102*/
			var _5r = $k[--$j]; /*15102*/
			$k[$j++] = _5q; /*15102*/
			$k[$j++] = _5r; /*15102*/
			var _5s = $a(); /*15102*/
			$k[$j++] = _5s; /*15102*/
		}) /*15102*/
		var _5t = $d(); /*15102*/
		$1[$k[--$j]] = _5t; /*15103*/
		$k[$j++] = "Bvals"; /*15106*/
		$k[$j++] = Infinity; /*15106*/
		for (var _5v = 0; _5v <= 255; _5v += 1) { /*15106*/
			$k[$j++] = _5v; /*15106*/
			$k[$j++] = _5v; /*15106*/
		} /*15106*/
		var _5w = $d(); /*15106*/
		$1[$k[--$j]] = _5w; /*15107*/
		$k[$j++] = "Bvals"; /*15109*/
		$k[$j++] = Infinity; /*15109*/
		$forall($1.Bvals, function() { /*15109*/
			$k[$j++] = Infinity; /*15109*/
			var _5z = $k[--$j]; /*15109*/
			var _60 = $k[--$j]; /*15109*/
			$k[$j++] = _5z; /*15109*/
			$k[$j++] = _60; /*15109*/
			var _61 = $a(); /*15109*/
			$k[$j++] = _61; /*15109*/
		}) /*15109*/
		var _62 = $d(); /*15109*/
		$1[$k[--$j]] = _62; /*15110*/
		$1.encvals = $a([$1.Avals, $1.Cvals, $1.Tvals, $1.Xvals, $1.Evals, $1.Bvals]); /*15112*/
		$k[$j++] = "numD"; /*15114*/
		$k[$j++] = Infinity; /*15114*/
		for (var _6C = 0, _6D = $1.msglen; _6C < _6D; _6C++) { /*15114*/
			$k[$j++] = 0; /*15114*/
		} /*15114*/
		$k[$j++] = 0; /*15114*/
		var _6E = $a(); /*15114*/
		$1[$k[--$j]] = _6E; /*15114*/
		$k[$j++] = "nextXterm"; /*15115*/
		$k[$j++] = Infinity; /*15115*/
		for (var _6H = 0, _6I = $1.msglen; _6H < _6I; _6H++) { /*15115*/
			$k[$j++] = 0; /*15115*/
		} /*15115*/
		$k[$j++] = 9999; /*15115*/
		var _6J = $a(); /*15115*/
		$1[$k[--$j]] = _6J; /*15115*/
		$k[$j++] = "nextNonX"; /*15116*/
		$k[$j++] = Infinity; /*15116*/
		for (var _6M = 0, _6N = $1.msglen; _6M < _6N; _6M++) { /*15116*/
			$k[$j++] = 0; /*15116*/
		} /*15116*/
		$k[$j++] = 9999; /*15116*/
		var _6O = $a(); /*15116*/
		$1[$k[--$j]] = _6O; /*15116*/
		for (var _6R = $1.msglen - 1; _6R >= 0; _6R -= 1) { /*15133*/
			$1.i = _6R; /*15118*/
			$1.barchar = $get($1.msg, $1.i); /*15119*/
			if (($1.barchar >= 48) && ($1.barchar <= 57)) { /*15122*/
				$put($1.numD, $1.i, $get($1.numD, $1.i + 1) + 1); /*15121*/
			} /*15121*/
			if ((($1.barchar == 13) || ($1.barchar == 42)) || ($1.barchar == 62)) { /*15126*/
				$put($1.nextXterm, $1.i, 0); /*15124*/
			} else { /*15126*/
				$put($1.nextXterm, $1.i, $get($1.nextXterm, $1.i + 1) + 1); /*15126*/
			} /*15126*/
			var _6o = $get($1.Xvals, $1.barchar) !== undefined; /*15128*/
			if (!_6o) { /*15131*/
				$put($1.nextNonX, $1.i, 0); /*15129*/
			} else { /*15131*/
				$put($1.nextNonX, $1.i, $get($1.nextNonX, $1.i + 1) + 1); /*15131*/
			} /*15131*/
		} /*15131*/
		$k[$j++] = "nextXterm"; /*15134*/
		$k[$j++] = Infinity; /*15134*/
		$forall($1.nextXterm, function() { /*15134*/
			var _6x = $k[--$j]; /*15134*/
			$k[$j++] = _6x; /*15134*/
			if (_6x > 10000) { /*15134*/
				$j--; /*15134*/
				$k[$j++] = 10000; /*15134*/
			} /*15134*/
		}) /*15134*/
		var _6y = $a(); /*15134*/
		$1[$k[--$j]] = _6y; /*15134*/
		$k[$j++] = "nextNonX"; /*15135*/
		$k[$j++] = Infinity; /*15135*/
		$forall($1.nextNonX, function() { /*15135*/
			var _71 = $k[--$j]; /*15135*/
			$k[$j++] = _71; /*15135*/
			if (_71 > 10000) { /*15135*/
				$j--; /*15135*/
				$k[$j++] = 10000; /*15135*/
			} /*15135*/
		}) /*15135*/
		var _72 = $a(); /*15135*/
		$1[$k[--$j]] = _72; /*15135*/
		$1.isD = function() {
			$k[$j++] = ($1.char >= 48) && ($1.char <= 57); /*15137*/
		}; /*15137*/
		$1.isC = function() {
			var _78 = $get($1.CNvals, $1.char) !== undefined; /*15138*/
			$k[$j++] = _78; /*15138*/
		}; /*15138*/
		$1.isT = function() {
			var _7B = $get($1.TNvals, $1.char) !== undefined; /*15139*/
			$k[$j++] = _7B; /*15139*/
		}; /*15139*/
		$1.isX = function() {
			var _7E = $get($1.Xvals, $1.char) !== undefined; /*15140*/
			$k[$j++] = _7E; /*15140*/
		}; /*15140*/
		$1.isE = function() {
			var _7H = $get($1.Evals, $1.char) !== undefined; /*15141*/
			$k[$j++] = _7H; /*15141*/
		}; /*15141*/
		$1.isEA = function() {
			$k[$j++] = $1.char > 127; /*15142*/
		}; /*15142*/
		$1.isFN = function() {
			$k[$j++] = $1.char < 0; /*15143*/
		}; /*15143*/
		$1.XtermFirst = function() {
			var _7K = $k[--$j]; /*15144*/
			$k[$j++] = $lt($get($1.nextXterm, _7K), $get($1.nextNonX, _7K)); /*15144*/
		}; /*15144*/
		$1.A = 0; /*15146*/
		$1.C = 1; /*15146*/
		$1.T = 2; /*15146*/
		$1.X = 3; /*15146*/
		$1.E = 4; /*15146*/
		$1.B = 5; /*15146*/
		$1.lookup = function() {
			$1.ac = 1; /*15149*/
			$1.cc = 2; /*15149*/
			$1.tc = 2; /*15149*/
			$1.xc = 2; /*15149*/
			$1.ec = 2; /*15149*/
			$1.bc = 2.25; /*15149*/
			if ($1.mode == $1.A) { /*15150*/
				$1.ac = 0; /*15150*/
				$1.cc = 1; /*15150*/
				$1.tc = 1; /*15150*/
				$1.xc = 1; /*15150*/
				$1.ec = 1; /*15150*/
				$1.bc = 1.25; /*15150*/
			} /*15150*/
			if ($1.mode == $1.C) { /*15151*/
				$1.cc = 0; /*15151*/
			} /*15151*/
			if ($1.mode == $1.T) { /*15152*/
				$1.tc = 0; /*15152*/
			} /*15152*/
			if ($1.mode == $1.X) { /*15153*/
				$1.xc = 0; /*15153*/
			} /*15153*/
			if ($1.mode == $1.E) { /*15154*/
				$1.ec = 0; /*15154*/
			} /*15154*/
			if ($1.mode == $1.B) { /*15155*/
				$1.bc = 0; /*15155*/
			} /*15155*/
			for (var _7b = 0, _7c = 1; _7b < _7c; _7b++) { /*15188*/
				$1.k = 0; /*15157*/
				for (;;) { /*15187*/
					if (($1.i + $1.k) == $1.msglen) { /*15166*/
						var _7g = $a(["ac", "cc", "tc", "xc", "ec", "bc"]); /*15159*/
						for (var _7h = 0, _7i = _7g.length; _7h < _7i; _7h++) { /*15159*/
							var _7j = $get(_7g, _7h); /*15159*/
							$1[_7j] = Math.ceil($1[_7j]); /*15159*/
						} /*15159*/
						var _7q = $a([$1.cc, $1.tc, $1.xc, $1.ec, $1.bc]); /*15160*/
						$k[$j++] = true; /*15160*/
						for (var _7r = 0, _7s = _7q.length; _7r < _7s; _7r++) { /*15160*/
							var _7v = $k[--$j]; /*15160*/
							$k[$j++] = _7v && ($1.ac <= $get(_7q, _7r)); /*15160*/
						} /*15160*/
						if ($k[--$j]) { /*15160*/
							$k[$j++] = $1.A; /*15160*/
							break; /*15160*/
						} /*15160*/
						var _83 = $a([$1.ac, $1.cc, $1.tc, $1.xc, $1.ec]); /*15161*/
						$k[$j++] = true; /*15161*/
						for (var _84 = 0, _85 = _83.length; _84 < _85; _84++) { /*15161*/
							var _88 = $k[--$j]; /*15161*/
							$k[$j++] = _88 && ($1.bc < $get(_83, _84)); /*15161*/
						} /*15161*/
						if ($k[--$j]) { /*15161*/
							$k[$j++] = $1.B; /*15161*/
							break; /*15161*/
						} /*15161*/
						var _8G = $a([$1.ac, $1.cc, $1.tc, $1.xc, $1.bc]); /*15162*/
						$k[$j++] = true; /*15162*/
						for (var _8H = 0, _8I = _8G.length; _8H < _8I; _8H++) { /*15162*/
							var _8L = $k[--$j]; /*15162*/
							$k[$j++] = _8L && ($1.ec < $get(_8G, _8H)); /*15162*/
						} /*15162*/
						if ($k[--$j]) { /*15162*/
							$k[$j++] = $1.E; /*15162*/
							break; /*15162*/
						} /*15162*/
						var _8T = $a([$1.ac, $1.cc, $1.xc, $1.ec, $1.bc]); /*15163*/
						$k[$j++] = true; /*15163*/
						for (var _8U = 0, _8V = _8T.length; _8U < _8V; _8U++) { /*15163*/
							var _8Y = $k[--$j]; /*15163*/
							$k[$j++] = _8Y && ($1.tc < $get(_8T, _8U)); /*15163*/
						} /*15163*/
						if ($k[--$j]) { /*15163*/
							$k[$j++] = $1.T; /*15163*/
							break; /*15163*/
						} /*15163*/
						var _8g = $a([$1.ac, $1.cc, $1.tc, $1.ec, $1.bc]); /*15164*/
						$k[$j++] = true; /*15164*/
						for (var _8h = 0, _8i = _8g.length; _8h < _8i; _8h++) { /*15164*/
							var _8l = $k[--$j]; /*15164*/
							$k[$j++] = _8l && ($1.xc < $get(_8g, _8h)); /*15164*/
						} /*15164*/
						if ($k[--$j]) { /*15164*/
							$k[$j++] = $1.X; /*15164*/
							break; /*15164*/
						} /*15164*/
						$k[$j++] = $1.C; /*15165*/
						break; /*15165*/
					} /*15165*/
					$1.char = $get($1.msg, $1.i + $1.k); /*15167*/
					$k[$j++] = "ac"; /*15168*/
					$k[$j++] = $1.ac; /*15168*/
					$1.isD(); /*15168*/
					if ($k[--$j]) { /*15168*/
						var _8v = $k[--$j]; /*15168*/
						$k[$j++] = _8v + (1 / 2); /*15168*/
					} else { /*15168*/
						$1.isEA(); /*15168*/
						if ($k[--$j]) { /*15168*/
							var _8x = $k[--$j]; /*15168*/
							$k[$j++] = Math.ceil(_8x) + 2; /*15168*/
						} else { /*15168*/
							var _8y = $k[--$j]; /*15168*/
							$k[$j++] = Math.ceil(_8y) + 1; /*15168*/
						} /*15168*/
					} /*15168*/
					var _8z = $k[--$j]; /*15168*/
					$1[$k[--$j]] = _8z; /*15168*/
					$k[$j++] = "cc"; /*15169*/
					$k[$j++] = $1.cc; /*15169*/
					$1.isC(); /*15169*/
					if ($k[--$j]) { /*15169*/
						var _93 = $k[--$j]; /*15169*/
						$k[$j++] = _93 + (2 / 3); /*15169*/
					} else { /*15169*/
						$1.isEA(); /*15169*/
						if ($k[--$j]) { /*15169*/
							var _95 = $k[--$j]; /*15169*/
							$k[$j++] = _95 + (8 / 3); /*15169*/
						} else { /*15169*/
							var _96 = $k[--$j]; /*15169*/
							$k[$j++] = _96 + (4 / 3); /*15169*/
						} /*15169*/
					} /*15169*/
					var _97 = $k[--$j]; /*15169*/
					$1[$k[--$j]] = _97; /*15169*/
					$k[$j++] = "tc"; /*15170*/
					$k[$j++] = $1.tc; /*15170*/
					$1.isT(); /*15170*/
					if ($k[--$j]) { /*15170*/
						var _9B = $k[--$j]; /*15170*/
						$k[$j++] = _9B + (2 / 3); /*15170*/
					} else { /*15170*/
						$1.isEA(); /*15170*/
						if ($k[--$j]) { /*15170*/
							var _9D = $k[--$j]; /*15170*/
							$k[$j++] = _9D + (8 / 3); /*15170*/
						} else { /*15170*/
							var _9E = $k[--$j]; /*15170*/
							$k[$j++] = _9E + (4 / 3); /*15170*/
						} /*15170*/
					} /*15170*/
					var _9F = $k[--$j]; /*15170*/
					$1[$k[--$j]] = _9F; /*15170*/
					$k[$j++] = "xc"; /*15171*/
					$k[$j++] = $1.xc; /*15171*/
					$1.isX(); /*15171*/
					if ($k[--$j]) { /*15171*/
						var _9J = $k[--$j]; /*15171*/
						$k[$j++] = _9J + (2 / 3); /*15171*/
					} else { /*15171*/
						$1.isEA(); /*15171*/
						if ($k[--$j]) { /*15171*/
							var _9L = $k[--$j]; /*15171*/
							$k[$j++] = _9L + (13 / 3); /*15171*/
						} else { /*15171*/
							var _9M = $k[--$j]; /*15171*/
							$k[$j++] = _9M + (10 / 3); /*15171*/
						} /*15171*/
					} /*15171*/
					var _9N = $k[--$j]; /*15171*/
					$1[$k[--$j]] = _9N; /*15171*/
					$k[$j++] = "ec"; /*15172*/
					$k[$j++] = $1.ec; /*15172*/
					$1.isE(); /*15172*/
					if ($k[--$j]) { /*15172*/
						var _9R = $k[--$j]; /*15172*/
						$k[$j++] = _9R + (3 / 4); /*15172*/
					} else { /*15172*/
						$1.isEA(); /*15172*/
						if ($k[--$j]) { /*15172*/
							var _9T = $k[--$j]; /*15172*/
							$k[$j++] = _9T + (17 / 4); /*15172*/
						} else { /*15172*/
							var _9U = $k[--$j]; /*15172*/
							$k[$j++] = _9U + (13 / 4); /*15172*/
						} /*15172*/
					} /*15172*/
					var _9V = $k[--$j]; /*15172*/
					$1[$k[--$j]] = _9V; /*15172*/
					$k[$j++] = "bc"; /*15173*/
					$k[$j++] = $1.bc; /*15173*/
					$1.isFN(); /*15173*/
					if ($k[--$j]) { /*15173*/
						var _9Z = $k[--$j]; /*15173*/
						$k[$j++] = _9Z + 4; /*15173*/
					} else { /*15173*/
						var _9a = $k[--$j]; /*15173*/
						$k[$j++] = _9a + 1; /*15173*/
					} /*15173*/
					var _9b = $k[--$j]; /*15173*/
					$1[$k[--$j]] = _9b; /*15173*/
					if ($1.k >= 4) { /*15185*/
						var _9j = $a([$1.cc, $1.tc, $1.xc, $1.ec, $1.bc]); /*15175*/
						$k[$j++] = true; /*15175*/
						for (var _9k = 0, _9l = _9j.length; _9k < _9l; _9k++) { /*15175*/
							var _9o = $k[--$j]; /*15175*/
							$k[$j++] = _9o && (($1.ac + 1) <= $get(_9j, _9k)); /*15175*/
						} /*15175*/
						if ($k[--$j]) { /*15175*/
							$k[$j++] = $1.A; /*15175*/
							break; /*15175*/
						} /*15175*/
						if (($1.bc + 1) <= $1.ac) { /*15176*/
							$k[$j++] = $1.B; /*15176*/
							break; /*15176*/
						} /*15176*/
						var _9y = $a([$1.cc, $1.tc, $1.xc, $1.ec]); /*15177*/
						$k[$j++] = true; /*15177*/
						for (var _9z = 0, _A0 = _9y.length; _9z < _A0; _9z++) { /*15177*/
							var _A3 = $k[--$j]; /*15177*/
							$k[$j++] = _A3 && (($1.bc + 1) < $get(_9y, _9z)); /*15177*/
						} /*15177*/
						if ($k[--$j]) { /*15177*/
							$k[$j++] = $1.B; /*15177*/
							break; /*15177*/
						} /*15177*/
						var _AB = $a([$1.ac, $1.cc, $1.tc, $1.xc, $1.bc]); /*15178*/
						$k[$j++] = true; /*15178*/
						for (var _AC = 0, _AD = _AB.length; _AC < _AD; _AC++) { /*15178*/
							var _AG = $k[--$j]; /*15178*/
							$k[$j++] = _AG && (($1.ec + 1) < $get(_AB, _AC)); /*15178*/
						} /*15178*/
						if ($k[--$j]) { /*15178*/
							$k[$j++] = $1.E; /*15178*/
							break; /*15178*/
						} /*15178*/
						var _AO = $a([$1.ac, $1.cc, $1.xc, $1.ec, $1.bc]); /*15179*/
						$k[$j++] = true; /*15179*/
						for (var _AP = 0, _AQ = _AO.length; _AP < _AQ; _AP++) { /*15179*/
							var _AT = $k[--$j]; /*15179*/
							$k[$j++] = _AT && (($1.tc + 1) < $get(_AO, _AP)); /*15179*/
						} /*15179*/
						if ($k[--$j]) { /*15179*/
							$k[$j++] = $1.T; /*15179*/
							break; /*15179*/
						} /*15179*/
						var _Ab = $a([$1.ac, $1.cc, $1.tc, $1.ec, $1.bc]); /*15180*/
						$k[$j++] = true; /*15180*/
						for (var _Ac = 0, _Ad = _Ab.length; _Ac < _Ad; _Ac++) { /*15180*/
							var _Ag = $k[--$j]; /*15180*/
							$k[$j++] = _Ag && (($1.xc + 1) < $get(_Ab, _Ac)); /*15180*/
						} /*15180*/
						if ($k[--$j]) { /*15180*/
							$k[$j++] = $1.X; /*15180*/
							break; /*15180*/
						} /*15180*/
						var _An = $a([$1.ac, $1.tc, $1.ec, $1.bc]); /*15181*/
						$k[$j++] = true; /*15181*/
						for (var _Ao = 0, _Ap = _An.length; _Ao < _Ap; _Ao++) { /*15181*/
							var _As = $k[--$j]; /*15181*/
							$k[$j++] = _As && (($1.cc + 1) < $get(_An, _Ao)); /*15181*/
						} /*15181*/
						if ($k[--$j]) { /*15184*/
							if ($1.cc < $1.xc) { /*15182*/
								$k[$j++] = $1.C; /*15182*/
								break; /*15182*/
							} /*15182*/
							if ($1.cc == $1.xc) { /*15183*/
								$k[$j++] = ($1.i + $1.k) + 1; /*15183*/
								$1.XtermFirst(); /*15183*/
								if ($k[--$j]) { /*15183*/
									$k[$j++] = $1.X; /*15183*/
									break; /*15183*/
								} else { /*15183*/
									$k[$j++] = $1.C; /*15183*/
									break; /*15183*/
								} /*15183*/
							} /*15183*/
						} /*15183*/
					} /*15183*/
					$1.k = $1.k + 1; /*15186*/
				} /*15186*/
			} /*15186*/
		}; /*15189*/
		$1.addtocws = function() {
			var _B5 = $k[--$j]; /*15192*/
			$puti($1.cws, $1.j, _B5); /*15192*/
			$1.j = _B5.length + $1.j; /*15193*/
		}; /*15194*/
		$1.encA = function() {
			for (var _B9 = 0, _BA = 1; _B9 < _BA; _B9++) { /*15212*/
				if ($get($1.numD, $1.i) >= 2) { /*15202*/
					var _BE = $s(2); /*15199*/
					$put(_BE, 0, $get($1.msg, $1.i)); /*15199*/
					$put(_BE, 1, $get($1.msg, $1.i + 1)); /*15199*/
					$k[$j++] = $get($1.Avals, _BE); /*15199*/
					$1.addtocws(); /*15199*/
					$1.i = $1.i + 2; /*15200*/
					break; /*15201*/
				} /*15201*/
				$k[$j++] = "newmode"; /*15203*/
				$1.lookup(); /*15203*/
				var _BO = $k[--$j]; /*15203*/
				$1[$k[--$j]] = _BO; /*15203*/
				if ($1.newmode != $1.mode) { /*15208*/
					$k[$j++] = $get($1.Avals, $get($a([-1, $1.lC, $1.lT, $1.lX, $1.lE, $1.lB]), $1.newmode)); /*15205*/
					$1.addtocws(); /*15205*/
					$1.mode = $1.newmode; /*15206*/
					break; /*15207*/
				} /*15207*/
				$k[$j++] = $get($1.Avals, $get($1.msg, $1.i)); /*15209*/
				$1.addtocws(); /*15209*/
				$1.i = $1.i + 1; /*15210*/
				break; /*15211*/
			} /*15211*/
		}; /*15213*/
		$1.CTXvalstocws = function() {
			$1.in = $k[--$j]; /*15216*/
			$k[$j++] = Infinity; /*15217*/
			for (var _Bm = 0, _Bl = $1.in.length - 1; _Bm <= _Bl; _Bm += 3) { /*15221*/
				$k[$j++] = 0; /*15219*/
				$forall($geti($1.in, _Bm, 3), function() { /*15219*/
					var _Bp = $k[--$j]; /*15219*/
					var _Bq = $k[--$j]; /*15219*/
					$k[$j++] = (_Bq + _Bp) * 40; /*15219*/
				}) /*15219*/
				var _Bs = (~~($k[--$j] / 40)) + 1; /*15220*/
				$k[$j++] = ~~(_Bs / 256); /*15220*/
				$k[$j++] = _Bs % 256; /*15220*/
			} /*15220*/
			$astore($a($counttomark())); /*15222*/
			var _Bv = $k[--$j]; /*15222*/
			var _Bw = $k[--$j]; /*15222*/
			$k[$j++] = _Bv; /*15222*/
		}; /*15223*/
		$1.encCTX = function() {
			$1.p = 0; /*15226*/
			$1.ctxvals = $a(2500); /*15227*/
			for (;;) { /*15295*/
				if ($1.i == $1.msglen) { /*15231*/
					break; /*15231*/
				} /*15231*/
				var _C6 = $get($get($1.encvals, $1.mode), $get($1.msg, $1.i)) !== undefined; /*15232*/
				if (!_C6) { /*15232*/
					break; /*15232*/
				} /*15232*/
				if (($1.p % 3) == 0) { /*15290*/
					$1.lookup(); /*15234*/
					if ($ne($k[--$j], $1.mode)) { /*15239*/
						$k[$j++] = $geti($1.ctxvals, 0, $1.p); /*15235*/
						$1.CTXvalstocws(); /*15235*/
						$1.addtocws(); /*15235*/
						$k[$j++] = $a([$1.unlcw]); /*15236*/
						$1.addtocws(); /*15236*/
						$1.mode = $1.A; /*15237*/
						break; /*15238*/
					} /*15238*/
					if (($1.msglen - $1.i) <= 3) { /*15289*/
						$1.remcws = $get($1.numremcws, $1.j + ((~~($1.p / 3)) * 2)); /*15241*/
						$k[$j++] = "remvals"; /*15247*/
						$k[$j++] = Infinity; /*15247*/
						$forall($geti($1.msg, $1.i, $1.msglen - $1.i), function() { /*15249*/
							var _CR = $k[--$j]; /*15244*/
							var _CV = $get($get($1.encvals, $1.mode), _CR) !== undefined; /*15244*/
							$k[$j++] = _CR; /*15248*/
							if (_CV) { /*15247*/
								$aload($get($get($1.encvals, $1.mode), $k[--$j])); /*15245*/
							} else { /*15247*/
								$j--; /*15247*/
								$k[$j++] = -1; /*15247*/
								$k[$j++] = -1; /*15247*/
								$k[$j++] = -1; /*15247*/
								$k[$j++] = -1; /*15247*/
							} /*15247*/
						}) /*15247*/
						var _Cb = $a(); /*15247*/
						$1[$k[--$j]] = _Cb; /*15250*/
						if (($1.remcws == 2) && ($1.remvals.length == 3)) { /*15260*/
							$k[$j++] = Infinity; /*15255*/
							$aload($geti($1.ctxvals, 0, $1.p)); /*15254*/
							$aload($1.remvals); /*15255*/
							var _Cj = $a(); /*15255*/
							$k[$j++] = _Cj; /*15256*/
							$1.CTXvalstocws(); /*15256*/
							$1.addtocws(); /*15256*/
							$1.mode = $1.A; /*15257*/
							$1.i = $1.msglen; /*15258*/
							break; /*15259*/
						} /*15259*/
						if ((($1.remcws == 2) && ($1.remvals.length == 2)) && ($1.mode != $1.X)) { /*15271*/
							$k[$j++] = Infinity; /*15266*/
							$aload($geti($1.ctxvals, 0, $1.p)); /*15264*/
							$aload($1.remvals); /*15265*/
							$aload($get($get($1.encvals, $1.mode), $1.sft1)); /*15266*/
							var _Cz = $a(); /*15266*/
							$k[$j++] = _Cz; /*15267*/
							$1.CTXvalstocws(); /*15267*/
							$1.addtocws(); /*15267*/
							$1.mode = $1.A; /*15268*/
							$1.i = $1.msglen; /*15269*/
							break; /*15270*/
						} /*15270*/
						if (($1.remcws == 2) && ($1.remvals.length == 1)) { /*15280*/
							$k[$j++] = $geti($1.ctxvals, 0, $1.p); /*15274*/
							$1.CTXvalstocws(); /*15274*/
							$1.addtocws(); /*15274*/
							$k[$j++] = $a([$1.unlcw]); /*15275*/
							$1.addtocws(); /*15275*/
							$k[$j++] = $get($1.Avals, $get($1.msg, $1.i)); /*15276*/
							$1.addtocws(); /*15276*/
							$1.mode = $1.A; /*15277*/
							$1.i = $1.msglen; /*15278*/
							break; /*15279*/
						} /*15279*/
						if (($1.remcws == 1) && ($1.remvals.length == 1)) { /*15288*/
							$k[$j++] = $geti($1.ctxvals, 0, $1.p); /*15283*/
							$1.CTXvalstocws(); /*15283*/
							$1.addtocws(); /*15283*/
							$k[$j++] = $get($1.Avals, $get($1.msg, $1.i)); /*15284*/
							$1.addtocws(); /*15284*/
							$1.mode = $1.A; /*15285*/
							$1.i = $1.msglen; /*15286*/
							break; /*15287*/
						} /*15287*/
					} /*15287*/
				} /*15287*/
				var _DY = $get($get($1.encvals, $1.mode), $get($1.msg, $1.i)); /*15291*/
				$puti($1.ctxvals, $1.p, _DY); /*15292*/
				$1.p = _DY.length + $1.p; /*15293*/
				$1.i = $1.i + 1; /*15294*/
			} /*15294*/
			if ($1.mode != $1.A) { /*15319*/
				for (;;) { /*15303*/
					if (($1.p % 3) == 0) { /*15300*/
						break; /*15300*/
					} /*15300*/
					$1.i = $1.i - 1; /*15301*/
					$1.p = $1.p - $get($get($1.encvals, $1.mode), $get($1.msg, $1.i)).length; /*15302*/
				} /*15302*/
				$k[$j++] = Infinity; /*15305*/
				$aload($geti($1.ctxvals, 0, $1.p)); /*15305*/
				var _Ds = $a(); /*15305*/
				$k[$j++] = _Ds; /*15306*/
				$1.CTXvalstocws(); /*15306*/
				$1.addtocws(); /*15306*/
				$k[$j++] = $a([$1.unlcw]); /*15307*/
				$1.addtocws(); /*15307*/
				$1.mode = $1.A; /*15308*/
				if ($1.i != $1.msglen) { /*15318*/
					if ($get($1.numD, $1.i) >= 2) { /*15316*/
						var _E1 = $s(2); /*15312*/
						$put(_E1, 0, $get($1.msg, $1.i)); /*15312*/
						$put(_E1, 1, $get($1.msg, $1.i + 1)); /*15312*/
						$k[$j++] = $get($1.Avals, _E1); /*15312*/
						$1.addtocws(); /*15312*/
						$1.i = $1.i + 2; /*15313*/
					} else { /*15316*/
						$k[$j++] = $get($1.Avals, $get($1.msg, $1.i)); /*15315*/
						$1.addtocws(); /*15315*/
						$1.i = $1.i + 1; /*15316*/
					} /*15316*/
				} /*15316*/
			} /*15316*/
		}; /*15321*/
		$1.Evalstocws = function() {
			$1.in = $k[--$j]; /*15324*/
			$1.inlen = $1.in.length; /*15325*/
			$1.outlen = ~~(Math.ceil(($1.in.length / 4) * 3)); /*15326*/
			$k[$j++] = "in"; /*15327*/
			$k[$j++] = Infinity; /*15327*/
			$aload($1.in); /*15327*/
			$k[$j++] = 0; /*15327*/
			$k[$j++] = 0; /*15327*/
			$k[$j++] = 0; /*15327*/
			var _EL = $a(); /*15327*/
			$1[$k[--$j]] = _EL; /*15327*/
			$k[$j++] = Infinity; /*15328*/
			for (var _EP = 0, _EO = $1.inlen - 1; _EP <= _EO; _EP += 4) { /*15334*/
				$k[$j++] = 0; /*15330*/
				$forall($geti($1.in, _EP, 4), function() { /*15330*/
					var _ES = $k[--$j]; /*15330*/
					var _ET = $k[--$j]; /*15330*/
					$k[$j++] = $or(_ET, _ES) << 6; /*15330*/
				}) /*15330*/
				var _EV = $k[--$j] >>> 6; /*15331*/
				$k[$j++] = (_EV >>> 16) & 255; /*15333*/
				$k[$j++] = (_EV >>> 8) & 255; /*15333*/
				$k[$j++] = _EV & 255; /*15333*/
			} /*15333*/
			$astore($a($counttomark())); /*15335*/
			var _EY = $k[--$j]; /*15335*/
			var _EZ = $k[--$j]; /*15335*/
			$k[$j++] = $geti(_EY, 0, $1.outlen); /*15336*/
		}; /*15337*/
		$1.encE = function() {
			$1.p = 0; /*15340*/
			$1.edifactvals = $a(2100); /*15341*/
			for (;;) { /*15383*/
				if ($1.i == $1.msglen) { /*15345*/
					break; /*15345*/
				} /*15345*/
				var _Ej = $get($1.Evals, $get($1.msg, $1.i)) !== undefined; /*15346*/
				if (!_Ej) { /*15346*/
					break; /*15346*/
				} /*15346*/
				if (($1.p % 4) == 0) { /*15378*/
					$1.lookup(); /*15348*/
					if ($k[--$j] != $1.mode) { /*15348*/
						break; /*15348*/
					} /*15348*/
					if (($1.msglen - $1.i) <= 2) { /*15377*/
						$1.remcws = $get($1.numremcws, $1.j + ((~~($1.p / 4)) * 3)); /*15350*/
						$k[$j++] = "remvals"; /*15356*/
						$k[$j++] = Infinity; /*15356*/
						$forall($geti($1.msg, $1.i, $1.msglen - $1.i), function() { /*15358*/
							var _Ey = $k[--$j]; /*15353*/
							var _F0 = $get($1.Evals, _Ey) !== undefined; /*15353*/
							$k[$j++] = _Ey; /*15357*/
							if (_F0) { /*15356*/
								$aload($get($1.Evals, $k[--$j])); /*15354*/
							} else { /*15356*/
								$j--; /*15356*/
								$k[$j++] = -1; /*15356*/
								$k[$j++] = -1; /*15356*/
								$k[$j++] = -1; /*15356*/
								$k[$j++] = -1; /*15356*/
								$k[$j++] = -1; /*15356*/
							} /*15356*/
						}) /*15356*/
						var _F4 = $a(); /*15356*/
						$1[$k[--$j]] = _F4; /*15359*/
						if (($1.remcws == 2) && ($1.remvals.length == 2)) { /*15368*/
							$k[$j++] = $geti($1.edifactvals, 0, $1.p); /*15362*/
							$1.Evalstocws(); /*15362*/
							$1.addtocws(); /*15362*/
							$k[$j++] = $get($1.Avals, $get($1.msg, $1.i)); /*15363*/
							$1.addtocws(); /*15363*/
							$k[$j++] = $get($1.Avals, $get($1.msg, $1.i + 1)); /*15364*/
							$1.addtocws(); /*15364*/
							$1.mode = $1.A; /*15365*/
							$1.i = $1.msglen; /*15366*/
							break; /*15367*/
						} /*15367*/
						if ((($1.remcws == 2) || ($1.remcws == 1)) && ($1.remvals.length == 1)) { /*15376*/
							$k[$j++] = $geti($1.edifactvals, 0, $1.p); /*15371*/
							$1.Evalstocws(); /*15371*/
							$1.addtocws(); /*15371*/
							$k[$j++] = $get($1.Avals, $get($1.msg, $1.i)); /*15372*/
							$1.addtocws(); /*15372*/
							$1.mode = $1.A; /*15373*/
							$1.i = $1.msglen; /*15374*/
							break; /*15375*/
						} /*15375*/
					} /*15375*/
				} /*15375*/
				var _Fe = $get($1.Evals, $get($1.msg, $1.i)); /*15379*/
				$puti($1.edifactvals, $1.p, _Fe); /*15380*/
				$1.p = _Fe.length + $1.p; /*15381*/
				$1.i = $1.i + 1; /*15382*/
			} /*15382*/
			if ($1.mode != $1.A) { /*15405*/
				$1.remcws = $get($1.numremcws, ($1.j + ((~~($1.p / 4)) * 3)) - 1) - 1; /*15387*/
				if ($1.remcws != 0) { /*15392*/
					var _Fs = $get($1.Evals, $1.unl); /*15389*/
					$puti($1.edifactvals, $1.p, _Fs); /*15390*/
					$1.p = _Fs.length + $1.p; /*15391*/
				} /*15391*/
				$k[$j++] = $geti($1.edifactvals, 0, $1.p); /*15393*/
				$1.Evalstocws(); /*15393*/
				$1.addtocws(); /*15393*/
				$1.mode = $1.A; /*15394*/
				if ($1.i != $1.msglen) { /*15404*/
					if ($get($1.numD, $1.i) >= 2) { /*15402*/
						var _G5 = $s(2); /*15398*/
						$put(_G5, 0, $get($1.msg, $1.i)); /*15398*/
						$put(_G5, 1, $get($1.msg, $1.i + 1)); /*15398*/
						$k[$j++] = $get($1.Avals, _G5); /*15398*/
						$1.addtocws(); /*15398*/
						$1.i = $1.i + 2; /*15399*/
					} else { /*15402*/
						$k[$j++] = $get($1.Avals, $get($1.msg, $1.i)); /*15401*/
						$1.addtocws(); /*15401*/
						$1.i = $1.i + 1; /*15402*/
					} /*15402*/
				} /*15402*/
			} /*15402*/
		}; /*15407*/
		$1.encB = function() {
			$1.p = 0; /*15410*/
			$1.bvals = $a(1558); /*15410*/
			for (;;) { /*15416*/
				if ($1.i == $1.msglen) { /*15411*/
					break; /*15411*/
				} /*15411*/
				$1.lookup(); /*15412*/
				if ($k[--$j] != $1.mode) { /*15412*/
					break; /*15412*/
				} /*15412*/
				$put($1.bvals, $1.p, $get($1.msg, $1.i)); /*15413*/
				$1.p = $1.p + 1; /*15414*/
				$1.i = $1.i + 1; /*15415*/
			} /*15415*/
			$1.remcws = $get($1.numremcws, $1.j + $1.p) - 1; /*15417*/
			$k[$j++] = "bvals"; /*15424*/
			$k[$j++] = Infinity; /*15424*/
			if (($1.remcws == 0) && ($1.i == $1.msglen)) { /*15422*/
				$k[$j++] = 0; /*15420*/
			} else { /*15422*/
				if ($1.p < 250) { /*15422*/
					$k[$j++] = $1.p; /*15422*/
				} else { /*15422*/
					$k[$j++] = (~~($1.p / 250)) + 249; /*15422*/
					$k[$j++] = $1.p % 250; /*15422*/
				} /*15422*/
			} /*15422*/
			$aload($geti($1.bvals, 0, $1.p)); /*15424*/
			var _Gl = $a(); /*15424*/
			$1[$k[--$j]] = _Gl; /*15425*/
			for (var _Gp = 0, _Go = $1.bvals.length - 1; _Gp <= _Go; _Gp += 1) { /*15431*/
				$1.p = _Gp; /*15427*/
				var _Gv = ((((($1.j + $1.p) + 1) * 149) % 255) + 1) + $get($1.bvals, $1.p); /*15429*/
				$k[$j++] = _Gv; /*15429*/
				if (_Gv >= 256) { /*15429*/
					var _Gw = $k[--$j]; /*15429*/
					$k[$j++] = _Gw - 256; /*15429*/
				} /*15429*/
				$put($1.bvals, $1.p, $k[--$j]); /*15430*/
			} /*15430*/
			$k[$j++] = $1.bvals; /*15432*/
			$1.addtocws(); /*15432*/
			$1.mode = $1.A; /*15433*/
		}; /*15434*/
		$1.cws = $a(1558); /*15437*/
		$1.mode = $1.A; /*15438*/
		$1.i = 0; /*15438*/
		$1.j = 0; /*15438*/
		for (;;) { /*15441*/
			if ($1.i >= $1.msglen) { /*15439*/
				break; /*15439*/
			} /*15439*/
			$1[$get($a(["encA", "encCTX", "encCTX", "encCTX", "encE", "encB"]), $1.mode)](); /*15440*/
		} /*15440*/
		$1.cws = $geti($1.cws, 0, $1.j); /*15442*/
		$1.datlen = $1.cws.length; /*15445*/
		$1.remcws = $get($1.numremcws, $1.j - 1) - 1; /*15446*/
		if ($1.remcws > 0) { /*15455*/
			$k[$j++] = "cws"; /*15448*/
			$k[$j++] = Infinity; /*15448*/
			$aload($1.cws); /*15448*/
			for (var _HK = 0, _HL = $1.remcws; _HK < _HL; _HK++) { /*15448*/
				$k[$j++] = 129; /*15448*/
			} /*15448*/
			var _HM = $a(); /*15448*/
			$1[$k[--$j]] = _HM; /*15448*/
			for (var _HS = $1.datlen + 1, _HR = ($1.datlen + $1.remcws) - 1; _HS <= _HR; _HS += 1) { /*15454*/
				$1.i = _HS; /*15450*/
				var _HU = (((($1.i + 1) * 149) % 253) + 1) + 129; /*15452*/
				$k[$j++] = _HU; /*15452*/
				if (_HU > 254) { /*15452*/
					var _HV = $k[--$j]; /*15452*/
					$k[$j++] = _HV - 254; /*15452*/
				} /*15452*/
				$put($1.cws, $1.i, $k[--$j]); /*15453*/
			} /*15453*/
		} /*15453*/
		$1.i = 0; /*15458*/
		for (;;) { /*15479*/
			$1.m = $get($1.metrics, $1.i); /*15459*/
			$1.rows = $get($1.m, 0); /*15460*/
			$1.cols = $get($1.m, 1); /*15461*/
			$1.regh = $get($1.m, 2); /*15462*/
			$1.regv = $get($1.m, 3); /*15463*/
			$1.rscw = $get($1.m, 4); /*15464*/
			$1.rsbl = $get($1.m, 5); /*15465*/
			$1.mrows = $1.rows - (2 * $1.regh); /*15466*/
			$1.mcols = $1.cols - (2 * $1.regv); /*15467*/
			$1.rrows = ~~($1.mrows / $1.regh); /*15468*/
			$1.rcols = ~~($1.mcols / $1.regv); /*15469*/
			$1.ncws = (~~(($1.mrows * $1.mcols) / 8)) - $1.rscw; /*15470*/
			$1.okay = true; /*15471*/
			if ($1.cws.length != $1.ncws) { /*15472*/
				$1.okay = false; /*15472*/
			} /*15472*/
			if (($1.urows != 0) && ($1.urows != $1.rows)) { /*15473*/
				$1.okay = false; /*15473*/
			} /*15473*/
			if (($1.ucols != 0) && ($1.ucols != $1.cols)) { /*15474*/
				$1.okay = false; /*15474*/
			} /*15474*/
			if ($eq($1.format, "square") && $ne($1.rows, $1.cols)) { /*15475*/
				$1.okay = false; /*15475*/
			} /*15475*/
			if ($eq($1.format, "rectangle") && $eq($1.rows, $1.cols)) { /*15476*/
				$1.okay = false; /*15476*/
			} /*15476*/
			if ($1.okay) { /*15477*/
				break; /*15477*/
			} /*15477*/
			$1.i = $1.i + 1; /*15478*/
		} /*15478*/
		$1.cwbs = $a($1.rsbl); /*15482*/
		$1.ecbs = $a($1.rsbl); /*15483*/
		for (var _IL = 0, _IK = $1.rsbl - 1; _IL <= _IK; _IL += 1) { /*15498*/
			$1.i = _IL; /*15485*/
			if ($1.cws.length != 1558) { /*15489*/
				$1.cwbsize = ~~($1.cws.length / $1.rsbl); /*15487*/
			} else { /*15489*/
				if ($1.i <= 7) { /*15489*/
					$1.cwbsize = 156; /*15489*/
				} else { /*15489*/
					$1.cwbsize = 155; /*15489*/
				} /*15489*/
			} /*15489*/
			$1.cwb = $a($1.cwbsize); /*15491*/
			for (var _IU = 0, _IT = $1.cwbsize - 1; _IU <= _IT; _IU += 1) { /*15495*/
				$1.j = _IU; /*15493*/
				$put($1.cwb, $1.j, $get($1.cws, ($1.j * $1.rsbl) + $1.i)); /*15494*/
			} /*15494*/
			$put($1.cwbs, $1.i, $1.cwb); /*15496*/
			$k[$j++] = $1.ecbs; /*15497*/
			$k[$j++] = $1.i; /*15497*/
			$k[$j++] = Infinity; /*15497*/
			for (var _Ij = 0, _Ik = ~~($1.rscw / $1.rsbl); _Ij < _Ik; _Ij++) { /*15497*/
				$k[$j++] = 0; /*15497*/
			} /*15497*/
			var _Il = $a(); /*15497*/
			var _Im = $k[--$j]; /*15497*/
			$put($k[--$j], _Im, _Il); /*15497*/
		} /*15497*/
		$k[$j++] = "rsalog"; /*15501*/
		$k[$j++] = Infinity; /*15501*/
		$k[$j++] = 1; /*15501*/
		for (var _Io = 0, _Ip = 255; _Io < _Ip; _Io++) { /*15501*/
			var _Iq = $k[--$j]; /*15501*/
			var _Ir = _Iq * 2; /*15501*/
			$k[$j++] = _Iq; /*15501*/
			$k[$j++] = _Ir; /*15501*/
			if (_Ir >= 256) { /*15501*/
				var _Is = $k[--$j]; /*15501*/
				$k[$j++] = _Is ^ 301; /*15501*/
			} /*15501*/
		} /*15501*/
		var _It = $a(); /*15501*/
		$1[$k[--$j]] = _It; /*15501*/
		$1.rslog = $a(256); /*15502*/
		for (var _Iw = 1; _Iw <= 255; _Iw += 1) { /*15503*/
			$put($1.rslog, $get($1.rsalog, _Iw), _Iw); /*15503*/
		} /*15503*/
		$1.rsprod = function() {
			var _J0 = $k[--$j]; /*15507*/
			var _J1 = $k[--$j]; /*15507*/
			$k[$j++] = _J1; /*15511*/
			$k[$j++] = _J0; /*15511*/
			if ((_J0 != 0) && (_J1 != 0)) { /*15510*/
				var _J4 = $get($1.rslog, $k[--$j]); /*15508*/
				var _J9 = $get($1.rsalog, (_J4 + $get($1.rslog, $k[--$j])) % 255); /*15508*/
				$k[$j++] = _J9; /*15508*/
			} else { /*15510*/
				$j -= 2; /*15510*/
				$k[$j++] = 0; /*15510*/
			} /*15510*/
		}; /*15512*/
		$k[$j++] = "coeffs"; /*15515*/
		$k[$j++] = Infinity; /*15515*/
		$k[$j++] = 1; /*15515*/
		for (var _JC = 0, _JD = ~~($1.rscw / $1.rsbl); _JC < _JD; _JC++) { /*15515*/
			$k[$j++] = 0; /*15515*/
		} /*15515*/
		var _JE = $a(); /*15515*/
		$1[$k[--$j]] = _JE; /*15515*/
		for (var _JJ = 1, _JI = ~~($1.rscw / $1.rsbl); _JJ <= _JI; _JJ += 1) { /*15524*/
			$1.i = _JJ; /*15517*/
			$put($1.coeffs, $1.i, $get($1.coeffs, $1.i - 1)); /*15518*/
			for (var _JQ = $1.i - 1; _JQ >= 1; _JQ -= 1) { /*15522*/
				$1.j = _JQ; /*15520*/
				$k[$j++] = $1.coeffs; /*15521*/
				$k[$j++] = $1.j; /*15521*/
				$k[$j++] = $get($1.coeffs, $1.j - 1); /*15521*/
				$k[$j++] = $get($1.coeffs, $1.j); /*15521*/
				$k[$j++] = $get($1.rsalog, $1.i); /*15521*/
				$1.rsprod(); /*15521*/
				var _Jc = $k[--$j]; /*15521*/
				var _Jd = $k[--$j]; /*15521*/
				var _Je = $k[--$j]; /*15521*/
				$put($k[--$j], _Je, $xo(_Jd, _Jc)); /*15521*/
			} /*15521*/
			$k[$j++] = $1.coeffs; /*15523*/
			$k[$j++] = 0; /*15523*/
			$k[$j++] = $get($1.coeffs, 0); /*15523*/
			$k[$j++] = $get($1.rsalog, $1.i); /*15523*/
			$1.rsprod(); /*15523*/
			var _Jm = $k[--$j]; /*15523*/
			var _Jn = $k[--$j]; /*15523*/
			$put($k[--$j], _Jn, _Jm); /*15523*/
		} /*15523*/
		$1.coeffs = $geti($1.coeffs, 0, $1.coeffs.length - 1); /*15525*/
		for (var _Ju = 0, _Jt = $1.cwbs.length - 1; _Ju <= _Jt; _Ju += 1) { /*15541*/
			$1.i = _Ju; /*15529*/
			$1.cwb = $get($1.cwbs, $1.i); /*15530*/
			$1.ecb = $get($1.ecbs, $1.i); /*15531*/
			for (var _K3 = 0, _K2 = $1.cwb.length - 1; _K3 <= _K2; _K3 += 1) { /*15540*/
				$1.t = $xo($get($1.cwb, _K3), $get($1.ecb, 0)); /*15533*/
				for (var _K9 = $1.ecb.length - 1; _K9 >= 0; _K9 -= 1) { /*15539*/
					$1.j = _K9; /*15535*/
					$1.p = ($1.ecb.length - $1.j) - 1; /*15536*/
					$k[$j++] = $1.ecb; /*15537*/
					$k[$j++] = $1.p; /*15537*/
					$k[$j++] = $1.t; /*15537*/
					$k[$j++] = $get($1.coeffs, $1.j); /*15537*/
					$1.rsprod(); /*15537*/
					var _KI = $k[--$j]; /*15537*/
					var _KJ = $k[--$j]; /*15537*/
					$put($k[--$j], _KJ, _KI); /*15537*/
					if ($1.j > 0) { /*15538*/
						$put($1.ecb, $1.p, $xo($get($1.ecb, $1.p + 1), $get($1.ecb, $1.p))); /*15538*/
					} /*15538*/
				} /*15538*/
			} /*15538*/
		} /*15538*/
		if ($1.ncws == 1558) { /*15546*/
			$k[$j++] = "ecbs"; /*15545*/
			$k[$j++] = Infinity; /*15545*/
			$forall($geti($1.ecbs, 8, 2)); /*15545*/
			$forall($geti($1.ecbs, 0, 8)); /*15545*/
			var _KZ = $a(); /*15545*/
			$1[$k[--$j]] = _KZ; /*15545*/
		} /*15545*/
		$k[$j++] = "cws"; /*15549*/
		$k[$j++] = Infinity; /*15549*/
		$forall($1.cws); /*15549*/
		for (var _Kd = 0, _Ke = $1.rscw; _Kd < _Ke; _Kd++) { /*15549*/
			$k[$j++] = 0; /*15549*/
		} /*15549*/
		var _Kf = $a(); /*15549*/
		$1[$k[--$j]] = _Kf; /*15549*/
		for (var _Kj = 0, _Ki = $1.rscw - 1; _Kj <= _Ki; _Kj += 1) { /*15553*/
			$1.i = _Kj; /*15551*/
			$put($1.cws, $1.ncws + $1.i, $get($get($1.ecbs, $1.i % $1.rsbl), ~~($1.i / $1.rsbl))); /*15552*/
		} /*15552*/
		$1.module = function() {
			var _Ku = $k[--$j]; /*15558*/
			var _Kv = $k[--$j]; /*15558*/
			var _Kw = $k[--$j]; /*15558*/
			var _Kz = $strcpy($s(8), "00000000"); /*15559*/
			var _L1 = $cvrs($s(8), $k[--$j], 2); /*15559*/
			$puti(_Kz, 8 - _L1.length, _L1); /*15560*/
			$k[$j++] = _Kw; /*15561*/
			$k[$j++] = _Kv; /*15561*/
			$k[$j++] = _Ku; /*15561*/
			$k[$j++] = _Kz; /*15561*/
			for (var _L2 = 7; _L2 >= 0; _L2 -= 1) { /*15561*/
				var _L3 = $k[--$j]; /*15561*/
				$k[$j++] = $get(_L3, _L2) - 48; /*15561*/
				$k[$j++] = _L3; /*15561*/
			} /*15561*/
			$j--; /*15561*/
			var _L5 = $k[--$j]; /*15562*/
			var _L6 = $k[--$j]; /*15562*/
			var _L7 = $k[--$j]; /*15562*/
			var _L8 = $k[--$j]; /*15562*/
			var _L9 = $k[--$j]; /*15562*/
			var _LA = $k[--$j]; /*15562*/
			var _LB = $k[--$j]; /*15562*/
			var _LC = $k[--$j]; /*15562*/
			var _LD = $k[--$j]; /*15562*/
			var _LE = $k[--$j]; /*15562*/
			var _LF = $k[--$j]; /*15562*/
			$k[$j++] = _LC; /*15579*/
			$k[$j++] = _LB; /*15579*/
			$k[$j++] = _LA; /*15579*/
			$k[$j++] = _L9; /*15579*/
			$k[$j++] = _L8; /*15579*/
			$k[$j++] = _L7; /*15579*/
			$k[$j++] = _L6; /*15579*/
			$k[$j++] = _L5; /*15579*/
			$k[$j++] = _LF; /*15579*/
			$k[$j++] = _LE; /*15579*/
			$forall(_LD, function() { /*15579*/
				$k[--$j](); /*15565*/
				var _LH = $k[--$j]; /*15566*/
				var _LI = $k[--$j]; /*15566*/
				$k[$j++] = _LI; /*15569*/
				$k[$j++] = _LH; /*15569*/
				if (_LI < 0) { /*15569*/
					var _LJ = $k[--$j]; /*15567*/
					var _LK = $k[--$j]; /*15567*/
					$k[$j++] = _LK + $1.mrows; /*15568*/
					$k[$j++] = _LJ + (4 - (($1.mrows + 4) % 8)); /*15568*/
				} /*15568*/
				var _LN = $k[--$j]; /*15570*/
				$k[$j++] = _LN; /*15573*/
				if (_LN < 0) { /*15573*/
					var _LP = $k[--$j]; /*15571*/
					var _LQ = $k[--$j]; /*15571*/
					$k[$j++] = _LQ + (4 - (($1.mcols + 4) % 8)); /*15572*/
					$k[$j++] = _LP + $1.mcols; /*15572*/
				} /*15572*/
				var _LS = $k[--$j]; /*15574*/
				var _LT = $k[--$j]; /*15574*/
				$k[$j++] = _LT; /*15576*/
				$k[$j++] = _LS; /*15576*/
				if (_LT >= $1.mrows) { /*15576*/
					var _LV = $k[--$j]; /*15575*/
					var _LW = $k[--$j]; /*15575*/
					$k[$j++] = _LW - $1.mrows; /*15575*/
					$k[$j++] = _LV; /*15575*/
				} /*15575*/
				var _LY = $k[--$j]; /*15577*/
				var _LZ = $k[--$j]; /*15577*/
				var _Lc = $k[--$j]; /*15578*/
				var _Ld = $k[--$j]; /*15578*/
				$put($1.mmat, _LY + (_LZ * $1.mcols), $k[--$j]); /*15578*/
				$k[$j++] = _Ld; /*15578*/
				$k[$j++] = _Lc; /*15578*/
			}) /*15578*/
		}; /*15580*/
		var _Lv = $a([function() {
			var _Lf = $k[--$j]; /*15584*/
			var _Lg = $k[--$j]; /*15584*/
			$k[$j++] = _Lg; /*15584*/
			$k[$j++] = _Lf; /*15584*/
			$k[$j++] = _Lg - 2; /*15584*/
			$k[$j++] = _Lf - 2; /*15584*/
		}, function() {
			var _Lh = $k[--$j]; /*15584*/
			var _Li = $k[--$j]; /*15584*/
			$k[$j++] = _Li; /*15584*/
			$k[$j++] = _Lh; /*15584*/
			$k[$j++] = _Li - 2; /*15584*/
			$k[$j++] = _Lh - 1; /*15584*/
		}, function() {
			var _Lj = $k[--$j]; /*15585*/
			var _Lk = $k[--$j]; /*15585*/
			$k[$j++] = _Lk; /*15585*/
			$k[$j++] = _Lj; /*15585*/
			$k[$j++] = _Lk - 1; /*15585*/
			$k[$j++] = _Lj - 2; /*15585*/
		}, function() {
			var _Ll = $k[--$j]; /*15585*/
			var _Lm = $k[--$j]; /*15585*/
			$k[$j++] = _Lm; /*15585*/
			$k[$j++] = _Ll; /*15585*/
			$k[$j++] = _Lm - 1; /*15585*/
			$k[$j++] = _Ll - 1; /*15585*/
		}, function() {
			var _Ln = $k[--$j]; /*15586*/
			var _Lo = $k[--$j]; /*15586*/
			$k[$j++] = _Lo; /*15586*/
			$k[$j++] = _Ln; /*15586*/
			$k[$j++] = _Lo - 1; /*15586*/
			$k[$j++] = _Ln; /*15586*/
		}, function() {
			var _Lp = $k[--$j]; /*15586*/
			var _Lq = $k[--$j]; /*15586*/
			$k[$j++] = _Lq; /*15586*/
			$k[$j++] = _Lp; /*15586*/
			$k[$j++] = _Lq; /*15586*/
			$k[$j++] = _Lp - 2; /*15586*/
		}, function() {
			var _Lr = $k[--$j]; /*15587*/
			var _Ls = $k[--$j]; /*15587*/
			$k[$j++] = _Ls; /*15587*/
			$k[$j++] = _Lr; /*15587*/
			$k[$j++] = _Ls; /*15587*/
			$k[$j++] = _Lr - 1; /*15587*/
		}, function() {
			var _Lt = $k[--$j]; /*15587*/
			var _Lu = $k[--$j]; /*15587*/
			$k[$j++] = _Lu; /*15587*/
			$k[$j++] = _Lt; /*15587*/
			$k[$j++] = _Lu; /*15587*/
			$k[$j++] = _Lt; /*15587*/
		}]); /*15587*/
		$1.dmn = _Lv; /*15588*/
		var _M4 = $a([function() {
			$k[$j++] = $1.mrows - 1; /*15591*/
			$k[$j++] = 0; /*15591*/
		}, function() {
			$k[$j++] = $1.mrows - 1; /*15591*/
			$k[$j++] = 1; /*15591*/
		}, function() {
			$k[$j++] = $1.mrows - 1; /*15592*/
			$k[$j++] = 2; /*15592*/
		}, function() {
			$k[$j++] = 0; /*15592*/
			$k[$j++] = $1.mcols - 2; /*15592*/
		}, function() {
			$k[$j++] = 0; /*15593*/
			$k[$j++] = $1.mcols - 1; /*15593*/
		}, function() {
			$k[$j++] = 1; /*15593*/
			$k[$j++] = $1.mcols - 1; /*15593*/
		}, function() {
			$k[$j++] = 2; /*15594*/
			$k[$j++] = $1.mcols - 1; /*15594*/
		}, function() {
			$k[$j++] = 3; /*15594*/
			$k[$j++] = $1.mcols - 1; /*15594*/
		}]); /*15594*/
		$1.dmc1 = _M4; /*15595*/
		var _MD = $a([function() {
			$k[$j++] = $1.mrows - 3; /*15598*/
			$k[$j++] = 0; /*15598*/
		}, function() {
			$k[$j++] = $1.mrows - 2; /*15598*/
			$k[$j++] = 0; /*15598*/
		}, function() {
			$k[$j++] = $1.mrows - 1; /*15599*/
			$k[$j++] = 0; /*15599*/
		}, function() {
			$k[$j++] = 0; /*15599*/
			$k[$j++] = $1.mcols - 4; /*15599*/
		}, function() {
			$k[$j++] = 0; /*15600*/
			$k[$j++] = $1.mcols - 3; /*15600*/
		}, function() {
			$k[$j++] = 0; /*15600*/
			$k[$j++] = $1.mcols - 2; /*15600*/
		}, function() {
			$k[$j++] = 0; /*15601*/
			$k[$j++] = $1.mcols - 1; /*15601*/
		}, function() {
			$k[$j++] = 1; /*15601*/
			$k[$j++] = $1.mcols - 1; /*15601*/
		}]); /*15601*/
		$1.dmc2 = _MD; /*15602*/
		var _MM = $a([function() {
			$k[$j++] = $1.mrows - 3; /*15605*/
			$k[$j++] = 0; /*15605*/
		}, function() {
			$k[$j++] = $1.mrows - 2; /*15605*/
			$k[$j++] = 0; /*15605*/
		}, function() {
			$k[$j++] = $1.mrows - 1; /*15606*/
			$k[$j++] = 0; /*15606*/
		}, function() {
			$k[$j++] = 0; /*15606*/
			$k[$j++] = $1.mcols - 2; /*15606*/
		}, function() {
			$k[$j++] = 0; /*15607*/
			$k[$j++] = $1.mcols - 1; /*15607*/
		}, function() {
			$k[$j++] = 1; /*15607*/
			$k[$j++] = $1.mcols - 1; /*15607*/
		}, function() {
			$k[$j++] = 2; /*15608*/
			$k[$j++] = $1.mcols - 1; /*15608*/
		}, function() {
			$k[$j++] = 3; /*15608*/
			$k[$j++] = $1.mcols - 1; /*15608*/
		}]); /*15608*/
		$1.dmc3 = _MM; /*15609*/
		var _MW = $a([function() {
			$k[$j++] = $1.mrows - 1; /*15612*/
			$k[$j++] = 0; /*15612*/
		}, function() {
			$k[$j++] = $1.mrows - 1; /*15612*/
			$k[$j++] = $1.mcols - 1; /*15612*/
		}, function() {
			$k[$j++] = 0; /*15613*/
			$k[$j++] = $1.mcols - 3; /*15613*/
		}, function() {
			$k[$j++] = 0; /*15613*/
			$k[$j++] = $1.mcols - 2; /*15613*/
		}, function() {
			$k[$j++] = 0; /*15614*/
			$k[$j++] = $1.mcols - 1; /*15614*/
		}, function() {
			$k[$j++] = 1; /*15614*/
			$k[$j++] = $1.mcols - 3; /*15614*/
		}, function() {
			$k[$j++] = 1; /*15615*/
			$k[$j++] = $1.mcols - 2; /*15615*/
		}, function() {
			$k[$j++] = 1; /*15615*/
			$k[$j++] = $1.mcols - 1; /*15615*/
		}]); /*15615*/
		$1.dmc4 = _MW; /*15616*/
		$k[$j++] = "mmat"; /*15618*/
		$k[$j++] = Infinity; /*15618*/
		for (var _MZ = 0, _Ma = $1.mrows * $1.mcols; _MZ < _Ma; _MZ++) { /*15618*/
			$k[$j++] = -1; /*15618*/
		} /*15618*/
		var _Mb = $a(); /*15618*/
		$1[$k[--$j]] = _Mb; /*15618*/
		for (var _Me = $1.cws.length - 1; _Me >= 0; _Me -= 1) { /*15619*/
			$k[$j++] = $get($1.cws, _Me); /*15619*/
		} /*15619*/
		$k[$j++] = 4; /*15659*/
		$k[$j++] = 0; /*15659*/
		for (;;) { /*15659*/
			var _Mh = $k[--$j]; /*15622*/
			var _Mi = $k[--$j]; /*15622*/
			$k[$j++] = _Mi; /*15624*/
			$k[$j++] = _Mh; /*15624*/
			if ((_Mh == 0) && (_Mi == $1.mrows)) { /*15624*/
				$k[$j++] = $1.dmc1; /*15623*/
				$1.module(); /*15623*/
			} /*15623*/
			var _Ml = $k[--$j]; /*15625*/
			var _Mm = $k[--$j]; /*15625*/
			$k[$j++] = _Mm; /*15627*/
			$k[$j++] = _Ml; /*15627*/
			if (((_Ml == 0) && (_Mm == ($1.mrows - 2))) && (($1.mcols % 4) != 0)) { /*15627*/
				$k[$j++] = $1.dmc2; /*15626*/
				$1.module(); /*15626*/
			} /*15626*/
			var _Mq = $k[--$j]; /*15628*/
			var _Mr = $k[--$j]; /*15628*/
			$k[$j++] = _Mr; /*15630*/
			$k[$j++] = _Mq; /*15630*/
			if (((_Mq == 0) && (_Mr == ($1.mrows - 2))) && (($1.mcols % 8) == 4)) { /*15630*/
				$k[$j++] = $1.dmc3; /*15629*/
				$1.module(); /*15629*/
			} /*15629*/
			var _Mv = $k[--$j]; /*15631*/
			var _Mw = $k[--$j]; /*15631*/
			$k[$j++] = _Mw; /*15633*/
			$k[$j++] = _Mv; /*15633*/
			if (((_Mv == 2) && (_Mw == ($1.mrows + 4))) && (($1.mcols % 8) == 0)) { /*15633*/
				$k[$j++] = $1.dmc4; /*15632*/
				$1.module(); /*15632*/
			} /*15632*/
			for (;;) { /*15643*/
				var _N0 = $k[--$j]; /*15636*/
				var _N1 = $k[--$j]; /*15636*/
				$k[$j++] = _N1; /*15640*/
				$k[$j++] = _N0; /*15640*/
				if ((_N0 >= 0) && (_N1 < $1.mrows)) { /*15640*/
					var _N3 = $k[--$j]; /*15637*/
					var _N4 = $k[--$j]; /*15637*/
					$k[$j++] = _N4; /*15639*/
					$k[$j++] = _N3; /*15639*/
					if ($get($1.mmat, _N3 + (_N4 * $1.mcols)) == -1) { /*15639*/
						$k[$j++] = $1.dmn; /*15638*/
						$1.module(); /*15638*/
					} /*15638*/
				} /*15638*/
				var _N9 = $k[--$j]; /*15641*/
				var _NA = $k[--$j]; /*15641*/
				$k[$j++] = _NA - 2; /*15642*/
				$k[$j++] = _N9 + 2; /*15642*/
				if (!(((_N9 + 2) < $1.mcols) && ((_NA - 2) >= 0))) { /*15642*/
					break; /*15642*/
				} /*15642*/
			} /*15642*/
			var _NC = $k[--$j]; /*15644*/
			var _ND = $k[--$j]; /*15644*/
			$k[$j++] = _ND + 1; /*15654*/
			$k[$j++] = _NC + 3; /*15654*/
			for (;;) { /*15654*/
				var _NE = $k[--$j]; /*15647*/
				var _NF = $k[--$j]; /*15647*/
				$k[$j++] = _NF; /*15651*/
				$k[$j++] = _NE; /*15651*/
				if ((_NE < $1.mcols) && (_NF >= 0)) { /*15651*/
					var _NH = $k[--$j]; /*15648*/
					var _NI = $k[--$j]; /*15648*/
					$k[$j++] = _NI; /*15650*/
					$k[$j++] = _NH; /*15650*/
					if ($get($1.mmat, _NH + (_NI * $1.mcols)) == -1) { /*15650*/
						$k[$j++] = $1.dmn; /*15649*/
						$1.module(); /*15649*/
					} /*15649*/
				} /*15649*/
				var _NN = $k[--$j]; /*15652*/
				var _NO = $k[--$j]; /*15652*/
				$k[$j++] = _NO + 2; /*15653*/
				$k[$j++] = _NN - 2; /*15653*/
				if (!(((_NN - 2) >= 0) && ((_NO + 2) < $1.mrows))) { /*15653*/
					break; /*15653*/
				} /*15653*/
			} /*15653*/
			var _NQ = $k[--$j]; /*15655*/
			var _NR = $k[--$j]; /*15655*/
			$k[$j++] = _NR + 3; /*15657*/
			$k[$j++] = _NQ + 1; /*15657*/
			if (!(((_NQ + 1) < $1.mcols) || ((_NR + 3) < $1.mrows))) { /*15657*/
				$j -= 2; /*15657*/
				break; /*15657*/
			} /*15657*/
		} /*15657*/
		if ($get($1.mmat, ($1.mrows * $1.mcols) - 1) == -1) { /*15665*/
			$puti($1.mmat, ($1.mrows * ($1.mcols - 1)) - 2, $a([1, 0])); /*15663*/
			$puti($1.mmat, ($1.mrows * $1.mcols) - 2, $a([0, 1])); /*15664*/
		} /*15664*/
		$1.pixs = $a($1.rows * $1.cols); /*15668*/
		$1.cwpos = 0; /*15669*/
		for (var _Nl = 0, _Nk = $1.rows - 1; _Nl <= _Nk; _Nl += 1) { /*15685*/
			$1.i = _Nl; /*15671*/
			if (($1.i % ($1.rrows + 2)) == 0) { /*15672*/
				$k[$j++] = $1.pixs; /*15672*/
				$k[$j++] = $1.i * $1.cols; /*15672*/
				$k[$j++] = Infinity; /*15672*/
				for (var _Ns = 0, _Nt = ~~($1.cols / 2); _Ns < _Nt; _Ns++) { /*15672*/
					$k[$j++] = 1; /*15672*/
					$k[$j++] = 0; /*15672*/
				} /*15672*/
				var _Nu = $a(); /*15672*/
				var _Nv = $k[--$j]; /*15672*/
				$puti($k[--$j], _Nv, _Nu); /*15672*/
			} /*15672*/
			if (($1.i % ($1.rrows + 2)) == ($1.rrows + 1)) { /*15673*/
				$k[$j++] = $1.pixs; /*15673*/
				$k[$j++] = $1.i * $1.cols; /*15673*/
				$k[$j++] = Infinity; /*15673*/
				for (var _O4 = 0, _O5 = $1.cols; _O4 < _O5; _O4++) { /*15673*/
					$k[$j++] = 1; /*15673*/
				} /*15673*/
				var _O6 = $a(); /*15673*/
				var _O7 = $k[--$j]; /*15673*/
				$puti($k[--$j], _O7, _O6); /*15673*/
			} /*15673*/
			if ((($1.i % ($1.rrows + 2)) != 0) && (($1.i % ($1.rrows + 2)) != ($1.rrows + 1))) { /*15684*/
				for (var _OG = 0, _OF = $1.cols - 1; _OG <= _OF; _OG += 1) { /*15683*/
					$1.j = _OG; /*15676*/
					if (($1.j % ($1.rcols + 2)) == 0) { /*15677*/
						$put($1.pixs, ($1.i * $1.cols) + $1.j, 1); /*15677*/
					} /*15677*/
					if (($1.j % ($1.rcols + 2)) == ($1.rcols + 1)) { /*15678*/
						$put($1.pixs, ($1.i * $1.cols) + $1.j, $1.i % 2); /*15678*/
					} /*15678*/
					if ((($1.j % ($1.rcols + 2)) != 0) && (($1.j % ($1.rcols + 2)) != ($1.rcols + 1))) { /*15682*/
						$put($1.pixs, ($1.i * $1.cols) + $1.j, $get($1.mmat, $1.cwpos)); /*15680*/
						$1.cwpos = $1.cwpos + 1; /*15681*/
					} /*15681*/
				} /*15681*/
			} /*15681*/
		} /*15681*/
		var _Oo = {
			ren: $0.renmatrix,
			pixs: $1.pixs,
			pixx: $1.cols,
			pixy: $1.rows,
			height: ($1.rows * 2) / 72,
			width: ($1.cols * 2) / 72,
			opt: $1.options
		}; /*15695*/
		$k[$j++] = _Oo; /*15698*/
		if (!$1.dontdraw) { /*15698*/
			$0.renmatrix(); /*15698*/
		} /*15698*/
	};
	$0.datamatrixrectangular = function() {
		var $1 = {}; /*15726*/
		$1.options = $k[--$j]; /*15728*/
		$1.barcode = $k[--$j]; /*15729*/
		$1.dontdraw = false; /*15731*/
		$forall($1.options, function() { /*15742*/
			var _3 = $k[--$j]; /*15742*/
			$1[$k[--$j]] = _3; /*15742*/
		}) /*15742*/
		$1.options.dontdraw = true; /*15745*/
		$1.options.format = "rectangle"; /*15746*/
		$k[$j++] = "args"; /*15748*/
		$k[$j++] = $1.barcode; /*15748*/
		$k[$j++] = $1.options; /*15748*/
		$0.datamatrix(); /*15748*/
		var _9 = $k[--$j]; /*15748*/
		$1[$k[--$j]] = _9; /*15748*/
		$1.args.opt = $1.options; /*15750*/
		$k[$j++] = $1.args; /*15753*/
		if (!$1.dontdraw) { /*15753*/
			$0.renmatrix(); /*15753*/
		} /*15753*/
	};
	$0.qrcode = function() {
		var $1 = {}; /*15780*/
		$1.options = $k[--$j]; /*15782*/
		$1.barcode = $k[--$j]; /*15783*/
		$1.dontdraw = false; /*15785*/
		$1.format = "full"; /*15786*/
		$1.version = "unset"; /*15787*/
		$1.eclevel = "unset"; /*15788*/
		$1.parse = false; /*15789*/
		$1.parsefnc = false; /*15790*/
		$1.mask = -1; /*15791*/
		$forall($1.options, function() { /*15802*/
			var _3 = $k[--$j]; /*15802*/
			$1[$k[--$j]] = _3; /*15802*/
		}) /*15802*/
		$1.mask = ~~$1.mask; /*15804*/
		$1.barlen = $1.barcode.length; /*15827*/
		$1.fn1 = -1; /*15830*/
		var _8 = {
			FNC1: $1.fn1
		}; /*15832*/
		$1.fncvals = _8; /*15833*/
		$1.msg = $a($1.barlen); /*15834*/
		$1.i = 0; /*15835*/
		$1.j = 0; /*15835*/
		for (;;) { /*15849*/
			if ($1.i == $1.barlen) { /*15836*/
				break; /*15836*/
			} /*15836*/
			$1.char = $get($1.barcode, $1.i); /*15837*/
			if (($1.parsefnc && ($1.char == 94)) && ($1.i < ($1.barlen - 4))) { /*15845*/
				if ($get($1.barcode, $1.i + 1) != 94) { /*15843*/
					$1.char = $get($1.fncvals, $geti($1.barcode, $1.i + 1, 4)); /*15840*/
					$1.i = $1.i + 4; /*15841*/
				} else { /*15843*/
					$1.i = $1.i + 1; /*15843*/
				} /*15843*/
			} /*15843*/
			$put($1.msg, $1.j, $1.char); /*15846*/
			$1.i = $1.i + 1; /*15847*/
			$1.j = $1.j + 1; /*15848*/
		} /*15848*/
		$1.msg = $geti($1.msg, 0, $1.j); /*15850*/
		$1.msglen = $1.msg.length; /*15851*/
		$1.fnc1first = false; /*15854*/
		if ($1.msglen > 0) { /*15861*/
			if ($get($1.msg, 0) == $1.fn1) { /*15860*/
				$1.fnc1first = true; /*15857*/
				$k[$j++] = "msg"; /*15858*/
				$k[$j++] = Infinity; /*15858*/
				$forall($geti($1.msg, 1, $1.msglen - 1), function() { /*15858*/
					var _k = $k[--$j]; /*15858*/
					$k[$j++] = _k; /*15858*/
					if (_k == 37) { /*15858*/
						var _l = $k[--$j]; /*15858*/
						$k[$j++] = _l; /*15858*/
						$k[$j++] = _l; /*15858*/
					} /*15858*/
				}) /*15858*/
				var _m = $a(); /*15858*/
				$1[$k[--$j]] = _m; /*15858*/
				$1.msglen = $1.msg.length; /*15859*/
			} /*15859*/
		} /*15859*/
		if ($eq($1.eclevel, "unset")) { /*15864*/
			$k[$j++] = "eclevel"; /*15864*/
			if ($eq($1.format, "full")) { /*15864*/
				$k[$j++] = "M"; /*15864*/
			} else { /*15864*/
				$k[$j++] = "L"; /*15864*/
			} /*15864*/
			var _r = $k[--$j]; /*15864*/
			$1[$k[--$j]] = _r; /*15864*/
		} /*15864*/
		$1.N = 0; /*15867*/
		$1.A = 1; /*15867*/
		$1.B = 2; /*15867*/
		$1.K = 3; /*15867*/
		$k[$j++] = "Nexcl"; /*15872*/
		$k[$j++] = Infinity; /*15872*/
		$k[$j++] = Infinity; /*15871*/
		for (var _t = 48; _t <= 57; _t += 1) { /*15871*/
			$k[$j++] = _t; /*15871*/
		} /*15871*/
		var _u = $a(); /*15871*/
		for (var _v = 0, _w = _u.length; _v < _w; _v++) { /*15872*/
			$k[$j++] = $get(_u, _v); /*15872*/
			$k[$j++] = -1; /*15872*/
		} /*15872*/
		var _y = $d(); /*15872*/
		$1[$k[--$j]] = _y; /*15873*/
		$k[$j++] = "Aexcl"; /*15879*/
		$k[$j++] = Infinity; /*15879*/
		$k[$j++] = Infinity; /*15878*/
		$k[$j++] = 32; /*15878*/
		$k[$j++] = 36; /*15878*/
		$k[$j++] = 37; /*15878*/
		$k[$j++] = 42; /*15878*/
		$k[$j++] = 43; /*15878*/
		$k[$j++] = 45; /*15878*/
		$k[$j++] = 46; /*15878*/
		$k[$j++] = 47; /*15878*/
		$k[$j++] = 58; /*15878*/
		for (var _10 = 65; _10 <= 90; _10 += 1) { /*15878*/
			$k[$j++] = _10; /*15878*/
		} /*15878*/
		var _11 = $a(); /*15878*/
		for (var _12 = 0, _13 = _11.length; _12 < _13; _12++) { /*15879*/
			$k[$j++] = $get(_11, _12); /*15879*/
			$k[$j++] = -1; /*15879*/
		} /*15879*/
		var _15 = $d(); /*15879*/
		$1[$k[--$j]] = _15; /*15880*/
		$k[$j++] = "Bexcl"; /*15889*/
		$k[$j++] = Infinity; /*15889*/
		$k[$j++] = Infinity; /*15888*/
		for (var _17 = 0; _17 <= 31; _17 += 1) { /*15884*/
			$k[$j++] = _17; /*15884*/
		} /*15884*/
		$k[$j++] = 33; /*15886*/
		$k[$j++] = 34; /*15886*/
		$k[$j++] = 35; /*15886*/
		$k[$j++] = 38; /*15886*/
		$k[$j++] = 39; /*15886*/
		$k[$j++] = 40; /*15886*/
		$k[$j++] = 41; /*15886*/
		$k[$j++] = 44; /*15886*/
		for (var _18 = 59; _18 <= 64; _18 += 1) { /*15886*/
			$k[$j++] = _18; /*15886*/
		} /*15886*/
		for (var _19 = 91; _19 <= 127; _19 += 1) { /*15887*/
			$k[$j++] = _19; /*15887*/
		} /*15887*/
		for (var _1A = 160; _1A <= 223; _1A += 1) { /*15888*/
			$k[$j++] = _1A; /*15888*/
		} /*15888*/
		var _1B = $a(); /*15888*/
		for (var _1C = 0, _1D = _1B.length; _1C < _1D; _1C++) { /*15889*/
			$k[$j++] = $get(_1B, _1C); /*15889*/
			$k[$j++] = -1; /*15889*/
		} /*15889*/
		var _1F = $d(); /*15889*/
		$1[$k[--$j]] = _1F; /*15890*/
		$k[$j++] = "Kexcl"; /*15896*/
		$k[$j++] = Infinity; /*15896*/
		$k[$j++] = Infinity; /*15895*/
		for (var _1H = 129; _1H <= 159; _1H += 1) { /*15894*/
			$k[$j++] = _1H; /*15894*/
		} /*15894*/
		for (var _1I = 224; _1I <= 235; _1I += 1) { /*15895*/
			$k[$j++] = _1I; /*15895*/
		} /*15895*/
		var _1J = $a(); /*15895*/
		for (var _1K = 0, _1L = _1J.length; _1K < _1L; _1K++) { /*15896*/
			$k[$j++] = $get(_1J, _1K); /*15896*/
			$k[$j++] = -1; /*15896*/
		} /*15896*/
		var _1N = $d(); /*15896*/
		$1[$k[--$j]] = _1N; /*15897*/
		$1.mids = $a([$a(["0001", "0010", "0100", "1000"]), $a(["0001", "0010", "0100", "1000"]), $a(["0001", "0010", "0100", "1000"]), $a(["", -1, -1, -1]), $a(["0", "1", -1, -1]), $a(["00", "01", "10", "11"]), $a(["000", "001", "010", "011"])]); /*15907*/
		$1.cclens = $a([$a([10, 9, 8, 8]), $a([12, 11, 16, 10]), $a([14, 13, 16, 12]), $a([3, -1, -1, -1]), $a([4, 3, -1, -1]), $a([5, 4, 4, 3]), $a([6, 5, 5, 4])]); /*15917*/
		$1.termlens = $a([4, 4, 4, 3, 5, 7, 9]); /*15919*/
		$1.tobin = function() {
			var _1h = $s($k[--$j]); /*15923*/
			$k[$j++] = _1h; /*15923*/
			for (var _1j = 0, _1i = _1h.length - 1; _1j <= _1i; _1j += 1) { /*15923*/
				var _1k = $k[--$j]; /*15923*/
				$put(_1k, _1j, 48); /*15923*/
				$k[$j++] = _1k; /*15923*/
			} /*15923*/
			var _1l = $k[--$j]; /*15924*/
			var _1o = $cvrs($s(_1l.length), $k[--$j], 2); /*15924*/
			$puti(_1l, _1l.length - _1o.length, _1o); /*15924*/
			$k[$j++] = _1l; /*15924*/
		}; /*15925*/
		$1.charmap = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ $%*+-./:"; /*15928*/
		$1.charvals = {}; /*15929*/
		for (var _1p = 0; _1p <= 44; _1p += 1) { /*15930*/
			$put($1.charvals, $get($1.charmap, _1p), _1p); /*15930*/
		} /*15930*/
		$1.encA = function() {
			$1.in = $k[--$j]; /*15933*/
			if ($1.fnc1first) { /*15936*/
				$k[$j++] = "in"; /*15935*/
				$k[$j++] = Infinity; /*15935*/
				$forall($1.in, function() { /*15935*/
					var _1w = $k[--$j]; /*15935*/
					$k[$j++] = _1w; /*15935*/
					if (_1w == -1) { /*15935*/
						$j--; /*15935*/
						$k[$j++] = 37; /*15935*/
					} /*15935*/
				}) /*15935*/
				var _1x = $a(); /*15935*/
				$1[$k[--$j]] = _1x; /*15935*/
			} /*15935*/
			$1.out = $s((~~(($1.in.length * 11) / 2)) + 1); /*15937*/
			$1.k = 0; /*15938*/
			$1.m = 0; /*15938*/
			for (;;) { /*15949*/
				if ($1.k == $1.in.length) { /*15939*/
					break; /*15939*/
				} /*15939*/
				if ($1.k < ($1.in.length - 1)) { /*15945*/
					$k[$j++] = ($get($1.charvals, $get($1.in, $1.k)) * 45) + $get($1.charvals, $get($1.in, $1.k + 1)); /*15941*/
					$k[$j++] = 11; /*15941*/
					$1.tobin(); /*15941*/
					$1.k = $1.k + 2; /*15942*/
				} else { /*15945*/
					$k[$j++] = $get($1.charvals, $get($1.in, $1.k)); /*15944*/
					$k[$j++] = 6; /*15944*/
					$1.tobin(); /*15944*/
					$1.k = $1.k + 1; /*15945*/
				} /*15945*/
				var _2M = $k[--$j]; /*15947*/
				$puti($1.out, $1.m, _2M); /*15947*/
				$1.m = _2M.length + $1.m; /*15948*/
			} /*15948*/
			$k[$j++] = $geti($1.out, 0, $1.m); /*15950*/
		}; /*15951*/
		$1.encN = function() {
			$1.in = $k[--$j]; /*15954*/
			$1.out = $s((~~(($1.in.length * 10) / 3)) + 1); /*15955*/
			$1.k = 0; /*15956*/
			$1.m = 0; /*15956*/
			for (;;) { /*15972*/
				if ($1.k == $1.in.length) { /*15957*/
					break; /*15957*/
				} /*15957*/
				if ($1.k < ($1.in.length - 2)) { /*15967*/
					$k[$j++] = 0; /*15959*/
					$forall($geti($1.in, $1.k, 3), function() { /*15959*/
						var _2d = $k[--$j]; /*15959*/
						var _2e = $k[--$j]; /*15959*/
						$k[$j++] = _2d + ((_2e * 10) - 48); /*15959*/
					}) /*15959*/
					$k[$j++] = 10; /*15959*/
					$1.tobin(); /*15959*/
					$1.k = $1.k + 3; /*15960*/
				} else { /*15967*/
					if ($1.k == ($1.in.length - 2)) { /*15967*/
						$k[$j++] = 0; /*15963*/
						$forall($geti($1.in, $1.k, 2), function() { /*15963*/
							var _2l = $k[--$j]; /*15963*/
							var _2m = $k[--$j]; /*15963*/
							$k[$j++] = _2l + ((_2m * 10) - 48); /*15963*/
						}) /*15963*/
						$k[$j++] = 7; /*15963*/
						$1.tobin(); /*15963*/
						$1.k = $1.k + 2; /*15964*/
					} else { /*15967*/
						$k[$j++] = 0; /*15966*/
						$forall($geti($1.in, $1.k, 1), function() { /*15966*/
							var _2r = $k[--$j]; /*15966*/
							var _2s = $k[--$j]; /*15966*/
							$k[$j++] = _2r + ((_2s * 10) - 48); /*15966*/
						}) /*15966*/
						$k[$j++] = 4; /*15966*/
						$1.tobin(); /*15966*/
						$1.k = $1.k + 1; /*15967*/
					} /*15967*/
				} /*15967*/
				var _2u = $k[--$j]; /*15970*/
				$puti($1.out, $1.m, _2u); /*15970*/
				$1.m = _2u.length + $1.m; /*15971*/
			} /*15971*/
			$k[$j++] = $geti($1.out, 0, $1.m); /*15973*/
		}; /*15974*/
		$1.encB = function() {
			$1.in = $k[--$j]; /*15977*/
			if ($1.fnc1first) { /*15980*/
				$k[$j++] = "in"; /*15979*/
				$k[$j++] = Infinity; /*15979*/
				$forall($1.in, function() { /*15979*/
					var _34 = $k[--$j]; /*15979*/
					$k[$j++] = _34; /*15979*/
					if (_34 == -1) { /*15979*/
						$j--; /*15979*/
						$k[$j++] = 29; /*15979*/
					} /*15979*/
				}) /*15979*/
				var _35 = $a(); /*15979*/
				$1[$k[--$j]] = _35; /*15979*/
			} /*15979*/
			$1.out = $s($1.in.length * 8); /*15981*/
			for (var _3B = 0, _3A = $1.in.length - 1; _3B <= _3A; _3B += 1) { /*15986*/
				$1.k = _3B; /*15983*/
				$k[$j++] = ~~$z($get($1.in, $1.k)); /*15984*/
				$k[$j++] = 8; /*15984*/
				$1.tobin(); /*15984*/
				$puti($1.out, $1.k * 8, $k[--$j]); /*15985*/
			} /*15985*/
			$k[$j++] = $1.out; /*15987*/
		}; /*15988*/
		$1.encK = function() {
			$1.in = $k[--$j]; /*15991*/
			$1.out = $s((~~($1.in.length / 2)) * 13); /*15992*/
			$1.k = 0; /*15993*/
			$1.m = 0; /*15993*/
			for (;;) { /*16001*/
				if ($1.k == $1.in.length) { /*15994*/
					break; /*15994*/
				} /*15994*/
				var _3U = ($get($1.in, $1.k) * 256) + $get($1.in, $1.k + 1); /*15996*/
				$k[$j++] = _3U; /*15996*/
				if (_3U < 57408) { /*15996*/
					$k[$j++] = 33088; /*15996*/
				} else { /*15996*/
					$k[$j++] = 49472; /*15996*/
				} /*15996*/
				var _3V = $k[--$j]; /*15996*/
				var _3X = $k[--$j] - _3V; /*15997*/
				$k[$j++] = ((_3X >>> 8) * 192) + (_3X & 255); /*15998*/
				$k[$j++] = 13; /*15998*/
				$1.tobin(); /*15998*/
				var _3Y = $k[--$j]; /*15998*/
				$puti($1.out, $1.m, _3Y); /*15998*/
				$1.m = _3Y.length + $1.m; /*15999*/
				$1.k = $1.k + 2; /*16000*/
			} /*16000*/
			$k[$j++] = $1.out; /*16002*/
		}; /*16003*/
		$1.encfuncs = $a(["encN", "encA", "encB", "encK"]); /*16005*/
		$1.addtobits = function() {
			var _3f = $k[--$j]; /*16008*/
			$puti($1.bits, $1.j, _3f); /*16008*/
			$1.j = _3f.length + $1.j; /*16009*/
		}; /*16010*/
		$k[$j++] = "numNs"; /*16012*/
		$k[$j++] = Infinity; /*16012*/
		for (var _3k = 0, _3l = $1.msglen; _3k < _3l; _3k++) { /*16012*/
			$k[$j++] = 0; /*16012*/
		} /*16012*/
		$k[$j++] = 0; /*16012*/
		var _3m = $a(); /*16012*/
		$1[$k[--$j]] = _3m; /*16012*/
		$k[$j++] = "numAs"; /*16013*/
		$k[$j++] = Infinity; /*16013*/
		for (var _3p = 0, _3q = $1.msglen; _3p < _3q; _3p++) { /*16013*/
			$k[$j++] = 0; /*16013*/
		} /*16013*/
		$k[$j++] = 0; /*16013*/
		var _3r = $a(); /*16013*/
		$1[$k[--$j]] = _3r; /*16013*/
		$k[$j++] = "numBs"; /*16014*/
		$k[$j++] = Infinity; /*16014*/
		for (var _3u = 0, _3v = $1.msglen; _3u < _3v; _3u++) { /*16014*/
			$k[$j++] = 0; /*16014*/
		} /*16014*/
		$k[$j++] = 0; /*16014*/
		var _3w = $a(); /*16014*/
		$1[$k[--$j]] = _3w; /*16014*/
		$k[$j++] = "numKs"; /*16015*/
		$k[$j++] = Infinity; /*16015*/
		for (var _3z = 0, _40 = $1.msglen; _3z < _40; _3z++) { /*16015*/
			$k[$j++] = 0; /*16015*/
		} /*16015*/
		$k[$j++] = -1; /*16015*/
		var _41 = $a(); /*16015*/
		$1[$k[--$j]] = _41; /*16015*/
		$k[$j++] = "nextNs"; /*16016*/
		$k[$j++] = Infinity; /*16016*/
		for (var _44 = 0, _45 = $1.msglen; _44 < _45; _44++) { /*16016*/
			$k[$j++] = 0; /*16016*/
		} /*16016*/
		$k[$j++] = 9999; /*16016*/
		var _46 = $a(); /*16016*/
		$1[$k[--$j]] = _46; /*16016*/
		$k[$j++] = "nextBs"; /*16017*/
		$k[$j++] = Infinity; /*16017*/
		for (var _49 = 0, _4A = $1.msglen; _49 < _4A; _49++) { /*16017*/
			$k[$j++] = 0; /*16017*/
		} /*16017*/
		$k[$j++] = 9999; /*16017*/
		var _4B = $a(); /*16017*/
		$1[$k[--$j]] = _4B; /*16017*/
		$k[$j++] = "nextAs"; /*16018*/
		$k[$j++] = Infinity; /*16018*/
		for (var _4E = 0, _4F = $1.msglen; _4E < _4F; _4E++) { /*16018*/
			$k[$j++] = 0; /*16018*/
		} /*16018*/
		$k[$j++] = 9999; /*16018*/
		var _4G = $a(); /*16018*/
		$1[$k[--$j]] = _4G; /*16018*/
		$k[$j++] = "nextKs"; /*16019*/
		$k[$j++] = Infinity; /*16019*/
		for (var _4J = 0, _4K = $1.msglen; _4J < _4K; _4J++) { /*16019*/
			$k[$j++] = 0; /*16019*/
		} /*16019*/
		$k[$j++] = 9999; /*16019*/
		var _4L = $a(); /*16019*/
		$1[$k[--$j]] = _4L; /*16019*/
		for (var _4O = $1.msglen - 1; _4O >= 0; _4O -= 1) { /*16047*/
			$1.i = _4O; /*16021*/
			$1.barchar = $get($1.msg, $1.i); /*16022*/
			var _4U = $get($1.Kexcl, $1.barchar) !== undefined; /*16023*/
			if (_4U) { /*16027*/
				$put($1.nextKs, $1.i, 0); /*16024*/
				$put($1.numKs, $1.i, $get($1.numKs, $1.i + 1) + 1); /*16025*/
			} else { /*16027*/
				$put($1.nextKs, $1.i, $get($1.nextKs, $1.i + 1) + 1); /*16027*/
			} /*16027*/
			var _4j = $get($1.Nexcl, $1.barchar) !== undefined; /*16029*/
			if (_4j) { /*16033*/
				$put($1.nextNs, $1.i, 0); /*16030*/
				$put($1.numNs, $1.i, $get($1.numNs, $1.i + 1) + 1); /*16031*/
			} else { /*16033*/
				$put($1.nextNs, $1.i, $get($1.nextNs, $1.i + 1) + 1); /*16033*/
			} /*16033*/
			var _4y = $get($1.Bexcl, $1.barchar) !== undefined; /*16035*/
			if (_4y) { /*16039*/
				$put($1.nextBs, $1.i, 0); /*16036*/
				$put($1.numBs, $1.i, $get($1.numBs, $1.i + 1) + 1); /*16037*/
			} else { /*16039*/
				$put($1.nextBs, $1.i, $get($1.nextBs, $1.i + 1) + 1); /*16039*/
			} /*16039*/
			var _5D = $get($1.Aexcl, $1.barchar) !== undefined; /*16041*/
			if (_5D) { /*16045*/
				$put($1.nextAs, $1.i, 0); /*16042*/
				$put($1.numAs, $1.i, $get($1.numAs, $1.i + 1) + 1); /*16043*/
			} else { /*16045*/
				$put($1.nextAs, $1.i, $get($1.nextAs, $1.i + 1) + 1); /*16045*/
			} /*16045*/
		} /*16045*/
		$k[$j++] = "numKs"; /*16048*/
		$k[$j++] = Infinity; /*16048*/
		$forall($1.numKs, function() { /*16048*/
			var _5R = $k[--$j]; /*16048*/
			$k[$j++] = ~~((_5R + 1) / 2); /*16048*/
		}) /*16048*/
		var _5S = $a(); /*16048*/
		$1[$k[--$j]] = _5S; /*16048*/
		$1.KbeforeB = function() {
			var _5X = $get($k[--$j], $1.ver); /*16050*/
			$k[$j++] = $ge($1.numK, _5X) && ($get($1.nextBs, ($1.numK * 2) + $1.i) == 0); /*16050*/
		}; /*16050*/
		$1.KbeforeA = function() {
			var _5f = $get($k[--$j], $1.ver); /*16051*/
			$k[$j++] = $ge($1.numK, _5f) && ($get($1.nextAs, ($1.numK * 2) + $1.i) == 0); /*16051*/
		}; /*16051*/
		$1.KbeforeN = function() {
			var _5n = $get($k[--$j], $1.ver); /*16052*/
			$k[$j++] = $ge($1.numK, _5n) && ($get($1.nextNs, ($1.numK * 2) + $1.i) == 0); /*16052*/
		}; /*16052*/
		$1.KbeforeE = function() {
			var _5v = $get($k[--$j], $1.ver); /*16053*/
			$k[$j++] = $ge($1.numK, _5v) && ((($1.numK * 2) + $1.i) == $1.msglen); /*16053*/
		}; /*16053*/
		$1.AbeforeK = function() {
			var _62 = $get($k[--$j], $1.ver); /*16054*/
			$k[$j++] = $ge($1.numA, _62) && ($get($1.nextKs, $1.numA + $1.i) == 0); /*16054*/
		}; /*16054*/
		$1.AbeforeB = function() {
			var _6A = $get($k[--$j], $1.ver); /*16055*/
			$k[$j++] = $ge($1.numA, _6A) && ($get($1.nextBs, $1.numA + $1.i) == 0); /*16055*/
		}; /*16055*/
		$1.AbeforeN = function() {
			var _6I = $get($k[--$j], $1.ver); /*16056*/
			$k[$j++] = $ge($1.numA, _6I) && ($get($1.nextNs, $1.numA + $1.i) == 0); /*16056*/
		}; /*16056*/
		$1.AbeforeE = function() {
			var _6Q = $get($k[--$j], $1.ver); /*16057*/
			$k[$j++] = $ge($1.numA, _6Q) && (($1.numA + $1.i) == $1.msglen); /*16057*/
		}; /*16057*/
		$1.NbeforeK = function() {
			var _6X = $get($k[--$j], $1.ver); /*16058*/
			$k[$j++] = $ge($1.numN, _6X) && ($get($1.nextKs, $1.numN + $1.i) == 0); /*16058*/
		}; /*16058*/
		$1.NbeforeB = function() {
			var _6f = $get($k[--$j], $1.ver); /*16059*/
			$k[$j++] = $ge($1.numN, _6f) && ($get($1.nextBs, $1.numN + $1.i) == 0); /*16059*/
		}; /*16059*/
		$1.NbeforeA = function() {
			var _6n = $get($k[--$j], $1.ver); /*16060*/
			$k[$j++] = $ge($1.numN, _6n) && ($get($1.nextAs, $1.numN + $1.i) == 0); /*16060*/
		}; /*16060*/
		$1.NbeforeE = function() {
			var _6v = $get($k[--$j], $1.ver); /*16061*/
			$k[$j++] = $ge($1.numN, _6v) && (($1.numN + $1.i) == $1.msglen); /*16061*/
		}; /*16061*/
		$1.msgbits = $a([-1, -1, -1, -1, -1, -1, -1]); /*16064*/
		$1.v1to9 = 0; /*16065*/
		$1.v10to26 = 1; /*16065*/
		$1.v27to40 = 2; /*16065*/
		$1.vM1 = 3; /*16065*/
		$1.vM2 = 4; /*16065*/
		$1.vM3 = 5; /*16065*/
		$1.vM4 = 6; /*16065*/
		$1.e = 10000; /*16066*/
		var _77 = $a([$1.v1to9, $1.v10to26, $1.v27to40, $1.vM1, $1.vM2, $1.vM3, $1.vM4]); /*16067*/
		for (var _78 = 0, _79 = _77.length; _78 < _79; _78++) { /*16181*/
			$1.ver = $get(_77, _78); /*16068*/
			$1.mode = -1; /*16071*/
			$1.seq = $a([]); /*16071*/
			$1.i = 0; /*16071*/
			for (;;) { /*16155*/
				if ($1.i >= $1.msglen) { /*16072*/
					break; /*16072*/
				} /*16072*/
				$1.numK = $get($1.numKs, $1.i); /*16073*/
				$1.numB = $get($1.numBs, $1.i); /*16074*/
				$1.numA = $get($1.numAs, $1.i); /*16075*/
				$1.numN = $get($1.numNs, $1.i); /*16076*/
				if (($1.ver == $1.vM1) && ($1.numA >= 1)) { /*16077*/
					$1.seq = -1; /*16077*/
					break; /*16077*/
				} /*16077*/
				if (($1.ver == $1.vM1) && ($1.numB >= 1)) { /*16078*/
					$1.seq = -1; /*16078*/
					break; /*16078*/
				} /*16078*/
				if (($1.ver == $1.vM1) && ($1.numK >= 1)) { /*16079*/
					$1.seq = -1; /*16079*/
					break; /*16079*/
				} /*16079*/
				if (($1.ver == $1.vM2) && ($1.numB >= 1)) { /*16080*/
					$1.seq = -1; /*16080*/
					break; /*16080*/
				} /*16080*/
				if (($1.ver == $1.vM2) && ($1.numK >= 1)) { /*16081*/
					$1.seq = -1; /*16081*/
					break; /*16081*/
				} /*16081*/
				for (;;) { /*16136*/
					if ($1.mode == -1) { /*16100*/
						$k[$j++] = $a([1, 1, 1, $1.e, $1.e, 1, 1]); /*16084*/
						$1.KbeforeA(); /*16084*/
						if ($k[--$j]) { /*16084*/
							$k[$j++] = $1.K; /*16084*/
							break; /*16084*/
						} /*16084*/
						$k[$j++] = $a([1, 1, 1, $1.e, $1.e, 1, 1]); /*16085*/
						$1.KbeforeN(); /*16085*/
						if ($k[--$j]) { /*16085*/
							$k[$j++] = $1.K; /*16085*/
							break; /*16085*/
						} /*16085*/
						$k[$j++] = $a([5, 5, 6, $1.e, $1.e, 2, 3]); /*16086*/
						$1.KbeforeB(); /*16086*/
						if ($k[--$j]) { /*16086*/
							$k[$j++] = $1.K; /*16086*/
							break; /*16086*/
						} /*16086*/
						$k[$j++] = $a([1, 1, 1, $1.e, $1.e, 1, 1]); /*16087*/
						$1.KbeforeE(); /*16087*/
						if ($k[--$j]) { /*16087*/
							$k[$j++] = $1.K; /*16087*/
							break; /*16087*/
						} /*16087*/
						if ($1.numK >= 1) { /*16088*/
							$k[$j++] = $1.B; /*16088*/
							break; /*16088*/
						} /*16088*/
						$k[$j++] = $a([6, 7, 8, $1.e, $1.e, 3, 4]); /*16089*/
						$1.AbeforeB(); /*16089*/
						if ($k[--$j]) { /*16089*/
							$k[$j++] = $1.A; /*16089*/
							break; /*16089*/
						} /*16089*/
						$k[$j++] = $a([1, 1, 1, $1.e, 1, 1, 1]); /*16090*/
						$1.AbeforeE(); /*16090*/
						if ($k[--$j]) { /*16090*/
							$k[$j++] = $1.A; /*16090*/
							break; /*16090*/
						} /*16090*/
						if ($1.numA >= 1) { /*16093*/
							if (($1.ver != $1.vM1) && ($1.ver != $1.vM2)) { /*16092*/
								$k[$j++] = $1.B; /*16092*/
							} else { /*16092*/
								$k[$j++] = $1.A; /*16092*/
							} /*16092*/
							break; /*16092*/
						} /*16092*/
						$k[$j++] = $a([4, 4, 5, $1.e, $1.e, 2, 3]); /*16094*/
						$1.NbeforeB(); /*16094*/
						if ($k[--$j]) { /*16094*/
							$k[$j++] = $1.N; /*16094*/
							break; /*16094*/
						} /*16094*/
						$k[$j++] = $a([1, 1, 1, $1.e, $1.e, 1, 1]); /*16095*/
						$1.NbeforeB(); /*16095*/
						if ($k[--$j]) { /*16095*/
							$k[$j++] = $1.B; /*16095*/
							break; /*16095*/
						} /*16095*/
						$k[$j++] = $a([7, 8, 9, $1.e, 3, 4, 5]); /*16096*/
						$1.NbeforeA(); /*16096*/
						if ($k[--$j]) { /*16096*/
							$k[$j++] = $1.N; /*16096*/
							break; /*16096*/
						} /*16096*/
						$k[$j++] = $a([1, 1, 1, $1.e, 1, 1, 1]); /*16097*/
						$1.NbeforeA(); /*16097*/
						if ($k[--$j]) { /*16097*/
							$k[$j++] = $1.A; /*16097*/
							break; /*16097*/
						} /*16097*/
						if ($1.numN >= 1) { /*16098*/
							$k[$j++] = $1.N; /*16098*/
							break; /*16098*/
						} /*16098*/
						$k[$j++] = $1.B; /*16099*/
						break; /*16099*/
					} /*16099*/
					if ($1.mode == $1.B) { /*16115*/
						$k[$j++] = $a([9, 12, 13, $1.e, $1.e, 4, 5]); /*16102*/
						$1.KbeforeB(); /*16102*/
						if ($k[--$j]) { /*16102*/
							$k[$j++] = $1.K; /*16102*/
							break; /*16102*/
						} /*16102*/
						$k[$j++] = $a([9, 10, 12, $1.e, $1.e, 4, 5]); /*16103*/
						$1.KbeforeA(); /*16103*/
						if ($k[--$j]) { /*16103*/
							$k[$j++] = $1.K; /*16103*/
							break; /*16103*/
						} /*16103*/
						$k[$j++] = $a([9, 10, 11, $1.e, $1.e, 5, 6]); /*16104*/
						$1.KbeforeN(); /*16104*/
						if ($k[--$j]) { /*16104*/
							$k[$j++] = $1.K; /*16104*/
							break; /*16104*/
						} /*16104*/
						$k[$j++] = $a([4, 5, 6, $1.e, $1.e, 2, 3]); /*16105*/
						$1.KbeforeE(); /*16105*/
						if ($k[--$j]) { /*16105*/
							$k[$j++] = $1.K; /*16105*/
							break; /*16105*/
						} /*16105*/
						$k[$j++] = $a([11, 12, 14, $1.e, $1.e, 5, 7]); /*16106*/
						$1.AbeforeK(); /*16106*/
						if ($k[--$j]) { /*16106*/
							$k[$j++] = $1.A; /*16106*/
							break; /*16106*/
						} /*16106*/
						$k[$j++] = $a([11, 15, 16, $1.e, $1.e, 6, 7]); /*16107*/
						$1.AbeforeB(); /*16107*/
						if ($k[--$j]) { /*16107*/
							$k[$j++] = $1.A; /*16107*/
							break; /*16107*/
						} /*16107*/
						$k[$j++] = $a([12, 13, 15, $1.e, $1.e, 6, 8]); /*16108*/
						$1.AbeforeN(); /*16108*/
						if ($k[--$j]) { /*16108*/
							$k[$j++] = $1.A; /*16108*/
							break; /*16108*/
						} /*16108*/
						$k[$j++] = $a([6, 7, 8, $1.e, $1.e, 3, 4]); /*16109*/
						$1.AbeforeE(); /*16109*/
						if ($k[--$j]) { /*16109*/
							$k[$j++] = $1.A; /*16109*/
							break; /*16109*/
						} /*16109*/
						$k[$j++] = $a([6, 7, 8, $1.e, $1.e, 3, 4]); /*16110*/
						$1.NbeforeK(); /*16110*/
						if ($k[--$j]) { /*16110*/
							$k[$j++] = $1.N; /*16110*/
							break; /*16110*/
						} /*16110*/
						$k[$j++] = $a([6, 8, 9, $1.e, $1.e, 3, 4]); /*16111*/
						$1.NbeforeB(); /*16111*/
						if ($k[--$j]) { /*16111*/
							$k[$j++] = $1.N; /*16111*/
							break; /*16111*/
						} /*16111*/
						$k[$j++] = $a([6, 7, 8, $1.e, $1.e, 3, 4]); /*16112*/
						$1.NbeforeA(); /*16112*/
						if ($k[--$j]) { /*16112*/
							$k[$j++] = $1.N; /*16112*/
							break; /*16112*/
						} /*16112*/
						$k[$j++] = $a([3, 4, 5, $1.e, $1.e, 2, 3]); /*16113*/
						$1.NbeforeE(); /*16113*/
						if ($k[--$j]) { /*16113*/
							$k[$j++] = $1.N; /*16113*/
							break; /*16113*/
						} /*16113*/
						$k[$j++] = $1.B; /*16114*/
						break; /*16114*/
					} /*16114*/
					if ($1.mode == $1.A) { /*16123*/
						if ($1.numK >= 1) { /*16117*/
							$k[$j++] = $1.K; /*16117*/
							break; /*16117*/
						} /*16117*/
						if ($1.numB >= 1) { /*16118*/
							$k[$j++] = $1.B; /*16118*/
							break; /*16118*/
						} /*16118*/
						$k[$j++] = $a([13, 15, 17, $1.e, 5, 7, 9]); /*16119*/
						$1.NbeforeA(); /*16119*/
						if ($k[--$j]) { /*16119*/
							$k[$j++] = $1.N; /*16119*/
							break; /*16119*/
						} /*16119*/
						$k[$j++] = $a([13, 17, 18, $1.e, $1.e, 7, 9]); /*16120*/
						$1.NbeforeB(); /*16120*/
						if ($k[--$j]) { /*16120*/
							$k[$j++] = $1.N; /*16120*/
							break; /*16120*/
						} /*16120*/
						$k[$j++] = $a([7, 8, 9, $1.e, 3, 4, 5]); /*16121*/
						$1.NbeforeE(); /*16121*/
						if ($k[--$j]) { /*16121*/
							$k[$j++] = $1.N; /*16121*/
							break; /*16121*/
						} /*16121*/
						$k[$j++] = $1.A; /*16122*/
						break; /*16122*/
					} /*16122*/
					if ($1.mode == $1.N) { /*16129*/
						if ($1.numK >= 1) { /*16125*/
							$k[$j++] = $1.K; /*16125*/
							break; /*16125*/
						} /*16125*/
						if ($1.numB >= 1) { /*16126*/
							$k[$j++] = $1.B; /*16126*/
							break; /*16126*/
						} /*16126*/
						if ($1.numA >= 1) { /*16127*/
							$k[$j++] = $1.A; /*16127*/
							break; /*16127*/
						} /*16127*/
						$k[$j++] = $1.N; /*16128*/
						break; /*16128*/
					} /*16128*/
					if ($1.mode == $1.K) { /*16135*/
						if ($1.numB >= 1) { /*16131*/
							$k[$j++] = $1.B; /*16131*/
							break; /*16131*/
						} /*16131*/
						if ($1.numA >= 1) { /*16132*/
							$k[$j++] = $1.A; /*16132*/
							break; /*16132*/
						} /*16132*/
						if ($1.numN >= 1) { /*16133*/
							$k[$j++] = $1.N; /*16133*/
							break; /*16133*/
						} /*16133*/
						$k[$j++] = $1.K; /*16134*/
						break; /*16134*/
					} /*16134*/
				} /*16134*/
				var _AG = $k[--$j]; /*16137*/
				$k[$j++] = _AG; /*16137*/
				if ((_AG == $1.K) && $1.fnc1first) { /*16137*/
					$j--; /*16137*/
					$k[$j++] = $1.B; /*16137*/
				} /*16137*/
				var _AK = $k[--$j]; /*16138*/
				$k[$j++] = _AK; /*16153*/
				if (_AK == $1.mode) { /*16152*/
					$j--; /*16139*/
					var _AQ = ($1.mode == $1.K) ? 2 : 1; /*16140*/
					$1.dat = $geti($1.msg, $1.i, _AQ); /*16140*/
					$k[$j++] = "seq"; /*16143*/
					$k[$j++] = Infinity; /*16143*/
					$aload($1.seq); /*16142*/
					$k[$j++] = Infinity; /*16143*/
					var _AT = $k[--$j]; /*16143*/
					var _AU = $k[--$j]; /*16143*/
					$k[$j++] = _AT; /*16143*/
					$aload(_AU); /*16143*/
					$aload($1.dat); /*16143*/
					var _AW = $a(); /*16143*/
					$k[$j++] = _AW; /*16143*/
					var _AX = $a(); /*16143*/
					$1[$k[--$j]] = _AX; /*16144*/
				} else { /*16152*/
					$1.mode = $k[--$j]; /*16146*/
					if ($1.mode == $1.K) { /*16147*/
						$k[$j++] = $1.K; /*16147*/
						$k[$j++] = $geti($1.msg, $1.i, $1.numK * 2); /*16147*/
					} /*16147*/
					if ($1.mode == $1.B) { /*16148*/
						$k[$j++] = $1.B; /*16148*/
						$k[$j++] = $geti($1.msg, $1.i, $1.numB); /*16148*/
					} /*16148*/
					if ($1.mode == $1.A) { /*16149*/
						$k[$j++] = $1.A; /*16149*/
						$k[$j++] = $geti($1.msg, $1.i, $1.numA); /*16149*/
					} /*16149*/
					if ($1.mode == $1.N) { /*16150*/
						$k[$j++] = $1.N; /*16150*/
						$k[$j++] = $geti($1.msg, $1.i, $1.numN); /*16150*/
					} /*16150*/
					$1.dat = $k[--$j]; /*16151*/
					$1.sw = $k[--$j]; /*16151*/
					$k[$j++] = "seq"; /*16152*/
					$k[$j++] = Infinity; /*16152*/
					$aload($1.seq); /*16152*/
					$k[$j++] = $1.sw; /*16152*/
					$k[$j++] = $1.dat; /*16152*/
					var _B7 = $a(); /*16152*/
					$1[$k[--$j]] = _B7; /*16152*/
				} /*16152*/
				$1.i = $1.i + $1.dat.length; /*16154*/
			} /*16154*/
			for (;;) { /*16180*/
				if ($1.seq == -1) { /*16159*/
					break; /*16159*/
				} /*16159*/
				$1.bits = $s(23648); /*16160*/
				$1.j = 0; /*16161*/
				if ($1.fnc1first) { /*16162*/
					$k[$j++] = "0101"; /*16162*/
					$1.addtobits(); /*16162*/
				} /*16162*/
				$1.abort = false; /*16163*/
				for (var _BG = 0, _BF = $1.seq.length - 1; _BG <= _BF; _BG += 2) { /*16175*/
					$1.i = _BG; /*16165*/
					$1.mode = $get($1.seq, $1.i); /*16166*/
					$k[$j++] = $get($get($1.mids, $1.ver), $1.mode); /*16167*/
					$1.addtobits(); /*16167*/
					$1.cclen = $get($get($1.cclens, $1.ver), $1.mode); /*16168*/
					$1.chars = $get($1.seq, $1.i + 1); /*16169*/
					if ($1.chars.length >= (~~Math.pow(2, $1.cclen))) { /*16172*/
						$1.abort = true; /*16171*/
						break; /*16171*/
					} /*16171*/
					$k[$j++] = $1.chars.length; /*16173*/
					if ($1.mode == $1.K) { /*16173*/
						var _Bc = $k[--$j]; /*16173*/
						$k[$j++] = ~~(_Bc / 2); /*16173*/
					} /*16173*/
					$k[$j++] = $1.cclen; /*16173*/
					$1.tobin(); /*16173*/
					$1.addtobits(); /*16173*/
					$k[$j++] = $1.chars; /*16174*/
					$1[$get($1.encfuncs, $1.mode)](); /*16174*/
					$1.addtobits(); /*16174*/
				} /*16174*/
				if ($1.abort) { /*16176*/
					break; /*16176*/
				} /*16176*/
				$1.bits = $geti($1.bits, 0, $1.j); /*16177*/
				$put($1.msgbits, $1.ver, $1.bits); /*16178*/
				break; /*16179*/
			} /*16179*/
		} /*16179*/
		$1.metrics = $a([$a(["micro", "M1", $1.vM1, 11, 98, 99, 36, $a([2, 99, 99, 99]), $a([1, 0, -1, -1, -1, -1, -1, -1])]), $a(["micro", "M2", $1.vM2, 13, 98, 99, 80, $a([5, 6, 99, 99]), $a([1, 0, 1, 0, -1, -1, -1, -1])]), $a(["micro", "M3", $1.vM3, 15, 98, 99, 132, $a([6, 8, 99, 99]), $a([1, 0, 1, 0, -1, -1, -1, -1])]), $a(["micro", "M4", $1.vM4, 17, 98, 99, 192, $a([8, 10, 14, 99]), $a([1, 0, 1, 0, 1, 0, -1, -1])]), $a(["full", "1", $1.v1to9, 21, 98, 99, 208, $a([7, 10, 13, 17]), $a([1, 0, 1, 0, 1, 0, 1, 0])]), $a(["full", "2", $1.v1to9, 25, 18, 99, 359, $a([10, 16, 22, 28]), $a([1, 0, 1, 0, 1, 0, 1, 0])]), $a(["full", "3", $1.v1to9, 29, 22, 99, 567, $a([15, 26, 36, 44]), $a([1, 0, 1, 0, 2, 0, 2, 0])]), $a(["full", "4", $1.v1to9, 33, 26, 99, 807, $a([20, 36, 52, 64]), $a([1, 0, 2, 0, 2, 0, 4, 0])]), $a(["full", "5", $1.v1to9, 37, 30, 99, 1079, $a([26, 48, 72, 88]), $a([1, 0, 2, 0, 2, 2, 2, 2])]), $a(["full", "6", $1.v1to9, 41, 34, 99, 1383, $a([36, 64, 96, 112]), $a([2, 0, 4, 0, 4, 0, 4, 0])]), $a(["full", "7", $1.v1to9, 45, 22, 38, 1568, $a([40, 72, 108, 130]), $a([2, 0, 4, 0, 2, 4, 4, 1])]), $a(["full", "8", $1.v1to9, 49, 24, 42, 1936, $a([48, 88, 132, 156]), $a([2, 0, 2, 2, 4, 2, 4, 2])]), $a(["full", "9", $1.v1to9, 53, 26, 46, 2336, $a([60, 110, 160, 192]), $a([2, 0, 3, 2, 4, 4, 4, 4])]), $a(["full", "10", $1.v10to26, 57, 28, 50, 2768, $a([72, 130, 192, 224]), $a([2, 2, 4, 1, 6, 2, 6, 2])]), $a(["full", "11", $1.v10to26, 61, 30, 54, 3232, $a([80, 150, 224, 264]), $a([4, 0, 1, 4, 4, 4, 3, 8])]), $a(["full", "12", $1.v10to26, 65, 32, 58, 3728, $a([96, 176, 260, 308]), $a([2, 2, 6, 2, 4, 6, 7, 4])]), $a(["full", "13", $1.v10to26, 69, 34, 62, 4256, $a([104, 198, 288, 352]), $a([4, 0, 8, 1, 8, 4, 12, 4])]), $a(["full", "14", $1.v10to26, 73, 26, 46, 4651, $a([120, 216, 320, 384]), $a([3, 1, 4, 5, 11, 5, 11, 5])]), $a(["full", "15", $1.v10to26, 77, 26, 48, 5243, $a([132, 240, 360, 432]), $a([5, 1, 5, 5, 5, 7, 11, 7])]), $a(["full", "16", $1.v10to26, 81, 26, 50, 5867, $a([144, 280, 408, 480]), $a([5, 1, 7, 3, 15, 2, 3, 13])]), $a(["full", "17", $1.v10to26, 85, 30, 54, 6523, $a([168, 308, 448, 532]), $a([1, 5, 10, 1, 1, 15, 2, 17])]), $a(["full", "18", $1.v10to26, 89, 30, 56, 7211, $a([180, 338, 504, 588]), $a([5, 1, 9, 4, 17, 1, 2, 19])]), $a(["full", "19", $1.v10to26, 93, 30, 58, 7931, $a([196, 364, 546, 650]), $a([3, 4, 3, 11, 17, 4, 9, 16])]), $a(["full", "20", $1.v10to26, 97, 34, 62, 8683, $a([224, 416, 600, 700]), $a([3, 5, 3, 13, 15, 5, 15, 10])]), $a(["full", "21", $1.v10to26, 101, 28, 50, 9252, $a([224, 442, 644, 750]), $a([4, 4, 17, 0, 17, 6, 19, 6])]), $a(["full", "22", $1.v10to26, 105, 26, 50, 10068, $a([252, 476, 690, 816]), $a([2, 7, 17, 0, 7, 16, 34, 0])]), $a(["full", "23", $1.v10to26, 109, 30, 54, 10916, $a([270, 504, 750, 900]), $a([4, 5, 4, 14, 11, 14, 16, 14])]), $a(["full", "24", $1.v10to26, 113, 28, 54, 11796, $a([300, 560, 810, 960]), $a([6, 4, 6, 14, 11, 16, 30, 2])]), $a(["full", "25", $1.v10to26, 117, 32, 58, 12708, $a([312, 588, 870, 1050]), $a([8, 4, 8, 13, 7, 22, 22, 13])]), $a(["full", "26", $1.v10to26, 121, 30, 58, 13652, $a([336, 644, 952, 1110]), $a([10, 2, 19, 4, 28, 6, 33, 4])]), $a(["full", "27", $1.v27to40, 125, 34, 62, 14628, $a([360, 700, 1020, 1200]), $a([8, 4, 22, 3, 8, 26, 12, 28])]), $a(["full", "28", $1.v27to40, 129, 26, 50, 15371, $a([390, 728, 1050, 1260]), $a([3, 10, 3, 23, 4, 31, 11, 31])]), $a(["full", "29", $1.v27to40, 133, 30, 54, 16411, $a([420, 784, 1140, 1350]), $a([7, 7, 21, 7, 1, 37, 19, 26])]), $a(["full", "30", $1.v27to40, 137, 26, 52, 17483, $a([450, 812, 1200, 1440]), $a([5, 10, 19, 10, 15, 25, 23, 25])]), $a(["full", "31", $1.v27to40, 141, 30, 56, 18587, $a([480, 868, 1290, 1530]), $a([13, 3, 2, 29, 42, 1, 23, 28])]), $a(["full", "32", $1.v27to40, 145, 34, 60, 19723, $a([510, 924, 1350, 1620]), $a([17, 0, 10, 23, 10, 35, 19, 35])]), $a(["full", "33", $1.v27to40, 149, 30, 58, 20891, $a([540, 980, 1440, 1710]), $a([17, 1, 14, 21, 29, 19, 11, 46])]), $a(["full", "34", $1.v27to40, 153, 34, 62, 22091, $a([570, 1036, 1530, 1800]), $a([13, 6, 14, 23, 44, 7, 59, 1])]), $a(["full", "35", $1.v27to40, 157, 30, 54, 23008, $a([570, 1064, 1590, 1890]), $a([12, 7, 12, 26, 39, 14, 22, 41])]), $a(["full", "36", $1.v27to40, 161, 24, 50, 24272, $a([600, 1120, 1680, 1980]), $a([6, 14, 6, 34, 46, 10, 2, 64])]), $a(["full", "37", $1.v27to40, 165, 28, 54, 25568, $a([630, 1204, 1770, 2100]), $a([17, 4, 29, 14, 49, 10, 24, 46])]), $a(["full", "38", $1.v27to40, 169, 32, 58, 26896, $a([660, 1260, 1860, 2220]), $a([4, 18, 13, 32, 48, 14, 42, 32])]), $a(["full", "39", $1.v27to40, 173, 26, 54, 28256, $a([720, 1316, 1950, 2310]), $a([20, 4, 40, 7, 43, 22, 10, 67])]), $a(["full", "40", $1.v27to40, 177, 30, 58, 29648, $a([750, 1372, 2040, 2430]), $a([19, 6, 18, 31, 34, 34, 20, 61])])]); /*16231*/
		$k[$j++] = "eclval"; /*16232*/
		$search("LMQH", $1.eclevel); /*16232*/
		$j--; /*16232*/
		var _Ei = $k[--$j]; /*16232*/
		var _Ej = $k[--$j]; /*16232*/
		var _Ek = $k[--$j]; /*16232*/
		$1[$k[--$j]] = _Ei.length; /*16232*/
		for (var _Em = 0; _Em <= 43; _Em += 1) { /*16269*/
			$1.i = _Em; /*16234*/
			$1.m = $get($1.metrics, $1.i); /*16235*/
			$1.frmt = $get($1.m, 0); /*16236*/
			$1.vers = $get($1.m, 1); /*16237*/
			$1.vergrp = $get($1.m, 2); /*16238*/
			$1.size = $get($1.m, 3); /*16239*/
			$1.asp2 = $get($1.m, 4); /*16240*/
			$1.asp3 = $get($1.m, 5); /*16241*/
			$1.nmod = $get($1.m, 6); /*16242*/
			$1.ncws = ~~($1.nmod / 8); /*16243*/
			$1.rbit = $1.nmod % 8; /*16244*/
			$1.lc4b = false; /*16245*/
			if (($1.size == 11) || ($1.size == 15)) { /*16250*/
				$1.ncws = $1.ncws + 1; /*16247*/
				$1.rbit = 0; /*16248*/
				$1.lc4b = true; /*16249*/
			} /*16249*/
			$1.ecws = $get($get($1.m, 7), $1.eclval); /*16251*/
			$1.dcws = $1.ncws - $1.ecws; /*16252*/
			var _FH = $1.lc4b ? 4 : 0; /*16253*/
			$1.dmod = ($1.dcws * 8) - _FH; /*16253*/
			$1.ecb1 = $get($get($1.m, 8), $1.eclval * 2); /*16254*/
			$1.ecb2 = $get($get($1.m, 8), ($1.eclval * 2) + 1); /*16255*/
			$1.okay = true; /*16256*/
			if ($ne($1.format, "any") && $ne($1.format, $1.frmt)) { /*16257*/
				$1.okay = false; /*16257*/
			} /*16257*/
			if ($eq($1.frmt, "micro") && $1.fnc1first) { /*16258*/
				$1.okay = false; /*16258*/
			} /*16258*/
			if ($ne($1.version, "unset") && $ne($1.version, $1.vers)) { /*16259*/
				$1.okay = false; /*16259*/
			} /*16259*/
			if (($1.ecb1 == -1) || ($1.ecb2 == -1)) { /*16260*/
				$1.okay = false; /*16260*/
			} /*16260*/
			$1.verbits = $get($1.msgbits, $1.vergrp); /*16261*/
			if ($1.verbits == -1) { /*16265*/
				$1.okay = false; /*16263*/
			} else { /*16265*/
				if ($1.verbits.length > $1.dmod) { /*16265*/
					$1.okay = false; /*16265*/
				} /*16265*/
			} /*16265*/
			$1.term = $geti("000000000", 0, $get($1.termlens, $1.vergrp)); /*16267*/
			if ($1.okay) { /*16268*/
				break; /*16268*/
			} /*16268*/
		} /*16268*/
		if (!$1.okay) { /*16273*/
			$k[$j++] = "bwipp.qrcodeNoValidSymbol"; /*16272*/
			$k[$j++] = "No valid symbol available"; /*16272*/
			$0.raiseerror(); /*16272*/
		} /*16272*/
		$1.format = $1.frmt; /*16275*/
		$1.version = $1.vers; /*16276*/
		$1.msgbits = $1.verbits; /*16277*/
		$1.dcpb = ~~($1.dcws / ($1.ecb1 + $1.ecb2)); /*16278*/
		$1.ecpb = (~~($1.ncws / ($1.ecb1 + $1.ecb2))) - $1.dcpb; /*16279*/
		var _Fw = $1.term; /*16282*/
		var _Fx = $1.dmod; /*16282*/
		var _Fy = $1.msgbits; /*16282*/
		var _Fz = $1.term; /*16282*/
		var _G0 = _Fz.length; /*16282*/
		var _G1 = _Fx - _Fy.length; /*16282*/
		if ((_Fx - _Fy.length) > _Fz.length) { /*16282*/
			var _ = _G0; /*16282*/
			_G0 = _G1; /*16282*/
			_G1 = _; /*16282*/
		} /*16282*/
		$1.term = $geti(_Fw, 0, _G1); /*16282*/
		var _G5 = $s($1.msgbits.length + $1.term.length); /*16283*/
		$puti(_G5, 0, $1.msgbits); /*16284*/
		$puti(_G5, $1.msgbits.length, $1.term); /*16285*/
		$1.msgbits = _G5; /*16286*/
		$1.pad = $s($1.dmod); /*16289*/
		for (var _GD = 0, _GC = $1.pad.length - 1; _GD <= _GC; _GD += 1) { /*16290*/
			$put($1.pad, _GD, 48); /*16290*/
		} /*16290*/
		$puti($1.pad, 0, $1.msgbits); /*16291*/
		$1.padstrs = $a(["11101100", "00010001"]); /*16292*/
		$1.padnum = 0; /*16293*/
		var _GL = $1.lc4b ? 5 : 1; /*16294*/
		for (var _GN = ~~(Math.ceil($1.msgbits.length / 8) * 8), _GM = $1.dmod - _GL; _GN <= _GM; _GN += 8) { /*16297*/
			$puti($1.pad, _GN, $get($1.padstrs, $1.padnum)); /*16295*/
			$1.padnum = ($1.padnum + 1) % 2; /*16296*/
		} /*16296*/
		$1.cws = $a($1.dcws); /*16300*/
		for (var _GX = 0, _GW = $1.cws.length - 1; _GX <= _GW; _GX += 1) { /*16312*/
			$1.c = _GX; /*16302*/
			$1.bpcw = 8; /*16303*/
			if ($1.lc4b && ($1.c == ($1.cws.length - 1))) { /*16304*/
				$1.bpcw = 4; /*16304*/
			} /*16304*/
			$1.cwb = $geti($1.pad, $1.c * 8, $1.bpcw); /*16305*/
			$1.cw = 0; /*16306*/
			for (var _Gh = 0, _Gg = $1.bpcw - 1; _Gh <= _Gg; _Gh += 1) { /*16310*/
				$1.i = _Gh; /*16308*/
				$1.cw = $1.cw + ((~~(Math.pow(2, ($1.bpcw - $1.i) - 1))) * ($get($1.cwb, $1.i) - 48)); /*16309*/
			} /*16309*/
			$put($1.cws, $1.c, $1.cw); /*16311*/
		} /*16311*/
		if ($1.lc4b) { /*16315*/
			var _Gs = $1.cws; /*16315*/
			var _Gt = $1.cws; /*16315*/
			$put(_Gs, _Gt.length - 1, $get(_Gs, _Gt.length - 1) << 4); /*16315*/
		} /*16315*/
		$k[$j++] = "rsalog"; /*16318*/
		$k[$j++] = Infinity; /*16318*/
		$k[$j++] = 1; /*16318*/
		for (var _Gv = 0, _Gw = 255; _Gv < _Gw; _Gv++) { /*16318*/
			var _Gx = $k[--$j]; /*16318*/
			var _Gy = _Gx * 2; /*16318*/
			$k[$j++] = _Gx; /*16318*/
			$k[$j++] = _Gy; /*16318*/
			if (_Gy >= 256) { /*16318*/
				var _Gz = $k[--$j]; /*16318*/
				$k[$j++] = _Gz ^ 285; /*16318*/
			} /*16318*/
		} /*16318*/
		var _H0 = $a(); /*16318*/
		$1[$k[--$j]] = _H0; /*16318*/
		$1.rslog = $a(256); /*16319*/
		for (var _H3 = 1; _H3 <= 255; _H3 += 1) { /*16320*/
			$put($1.rslog, $get($1.rsalog, _H3), _H3); /*16320*/
		} /*16320*/
		$1.rsprod = function() {
			var _H7 = $k[--$j]; /*16324*/
			var _H8 = $k[--$j]; /*16324*/
			$k[$j++] = _H8; /*16328*/
			$k[$j++] = _H7; /*16328*/
			if ((_H7 != 0) && (_H8 != 0)) { /*16327*/
				var _HB = $get($1.rslog, $k[--$j]); /*16325*/
				var _HG = $get($1.rsalog, (_HB + $get($1.rslog, $k[--$j])) % 255); /*16325*/
				$k[$j++] = _HG; /*16325*/
			} else { /*16327*/
				$j -= 2; /*16327*/
				$k[$j++] = 0; /*16327*/
			} /*16327*/
		}; /*16329*/
		$k[$j++] = "coeffs"; /*16332*/
		$k[$j++] = Infinity; /*16332*/
		$k[$j++] = 1; /*16332*/
		for (var _HI = 0, _HJ = $1.ecpb; _HI < _HJ; _HI++) { /*16332*/
			$k[$j++] = 0; /*16332*/
		} /*16332*/
		var _HK = $a(); /*16332*/
		$1[$k[--$j]] = _HK; /*16332*/
		for (var _HO = 0, _HN = $1.ecpb - 1; _HO <= _HN; _HO += 1) { /*16341*/
			$1.i = _HO; /*16334*/
			$put($1.coeffs, $1.i + 1, $get($1.coeffs, $1.i)); /*16335*/
			for (var _HV = $1.i; _HV >= 1; _HV -= 1) { /*16339*/
				$1.j = _HV; /*16337*/
				$k[$j++] = $1.coeffs; /*16338*/
				$k[$j++] = $1.j; /*16338*/
				$k[$j++] = $get($1.coeffs, $1.j - 1); /*16338*/
				$k[$j++] = $get($1.coeffs, $1.j); /*16338*/
				$k[$j++] = $get($1.rsalog, $1.i); /*16338*/
				$1.rsprod(); /*16338*/
				var _Hh = $k[--$j]; /*16338*/
				var _Hi = $k[--$j]; /*16338*/
				var _Hj = $k[--$j]; /*16338*/
				$put($k[--$j], _Hj, $xo(_Hi, _Hh)); /*16338*/
			} /*16338*/
			$k[$j++] = $1.coeffs; /*16340*/
			$k[$j++] = 0; /*16340*/
			$k[$j++] = $get($1.coeffs, 0); /*16340*/
			$k[$j++] = $get($1.rsalog, $1.i); /*16340*/
			$1.rsprod(); /*16340*/
			var _Hr = $k[--$j]; /*16340*/
			var _Hs = $k[--$j]; /*16340*/
			$put($k[--$j], _Hs, _Hr); /*16340*/
		} /*16340*/
		$1.coeffs = $geti($1.coeffs, 0, $1.coeffs.length - 1); /*16342*/
		$1.rscodes = function() {
			$1.rscws = $k[--$j]; /*16346*/
			$1.rsnd = $1.rscws.length; /*16347*/
			$k[$j++] = "rscws"; /*16348*/
			$k[$j++] = Infinity; /*16348*/
			$forall($1.rscws); /*16348*/
			for (var _I1 = 0, _I2 = $1.ecpb; _I1 < _I2; _I1++) { /*16348*/
				$k[$j++] = 0; /*16348*/
			} /*16348*/
			var _I3 = $a(); /*16348*/
			$1[$k[--$j]] = _I3; /*16348*/
			for (var _I7 = 0, _I6 = $1.rsnd - 1; _I7 <= _I6; _I7 += 1) { /*16356*/
				$1.m = _I7; /*16350*/
				$1.k = $get($1.rscws, $1.m); /*16351*/
				for (var _ID = 0, _IC = $1.ecpb - 1; _ID <= _IC; _ID += 1) { /*16355*/
					$1.j = _ID; /*16353*/
					$k[$j++] = $1.rscws; /*16354*/
					$k[$j++] = ($1.m + $1.j) + 1; /*16354*/
					$k[$j++] = $get($1.coeffs, ($1.ecpb - $1.j) - 1); /*16354*/
					$k[$j++] = $1.k; /*16354*/
					$1.rsprod(); /*16354*/
					var _IQ = $k[--$j]; /*16354*/
					var _IR = $k[--$j]; /*16354*/
					$put($k[--$j], _IR, $xo(_IQ, $get($1.rscws, ($1.m + $1.j) + 1))); /*16354*/
				} /*16354*/
			} /*16354*/
			$k[$j++] = $geti($1.rscws, $1.rsnd, $1.ecpb); /*16357*/
		}; /*16358*/
		$1.dcwsb = $a($1.ecb1 + $1.ecb2); /*16361*/
		$1.ecwsb = $a($1.ecb1 + $1.ecb2); /*16362*/
		for (var _If = 0, _Ie = $1.ecb1 - 1; _If <= _Ie; _If += 1) { /*16367*/
			$1.i = _If; /*16364*/
			$put($1.dcwsb, $1.i, $geti($1.cws, $1.i * $1.dcpb, $1.dcpb)); /*16365*/
			$k[$j++] = $1.ecwsb; /*16366*/
			$k[$j++] = $1.i; /*16366*/
			$k[$j++] = $get($1.dcwsb, $1.i); /*16366*/
			$1.rscodes(); /*16366*/
			var _Is = $k[--$j]; /*16366*/
			var _It = $k[--$j]; /*16366*/
			$put($k[--$j], _It, _Is); /*16366*/
		} /*16366*/
		for (var _Ix = 0, _Iw = $1.ecb2 - 1; _Ix <= _Iw; _Ix += 1) { /*16372*/
			$1.i = _Ix; /*16369*/
			$put($1.dcwsb, $1.ecb1 + $1.i, $geti($1.cws, ($1.ecb1 * $1.dcpb) + ($1.i * ($1.dcpb + 1)), $1.dcpb + 1)); /*16370*/
			$k[$j++] = $1.ecwsb; /*16371*/
			$k[$j++] = $1.ecb1 + $1.i; /*16371*/
			$k[$j++] = $get($1.dcwsb, $1.ecb1 + $1.i); /*16371*/
			$1.rscodes(); /*16371*/
			var _JF = $k[--$j]; /*16371*/
			var _JG = $k[--$j]; /*16371*/
			$put($k[--$j], _JG, _JF); /*16371*/
		} /*16371*/
		$1.cws = $a($1.ncws); /*16375*/
		$1.cw = 0; /*16376*/
		for (var _JM = 0, _JL = $1.dcpb; _JM <= _JL; _JM += 1) { /*16386*/
			$1.i = _JM; /*16378*/
			for (var _JQ = 0, _JP = ($1.ecb1 + $1.ecb2) - 1; _JQ <= _JP; _JQ += 1) { /*16385*/
				$1.j = _JQ; /*16380*/
				if ($1.i < $get($1.dcwsb, $1.j).length) { /*16384*/
					$put($1.cws, $1.cw, $get($get($1.dcwsb, $1.j), $1.i)); /*16382*/
					$1.cw = $1.cw + 1; /*16383*/
				} /*16383*/
			} /*16383*/
		} /*16383*/
		for (var _Jf = 0, _Je = $1.ecpb - 1; _Jf <= _Je; _Jf += 1) { /*16394*/
			$1.i = _Jf; /*16388*/
			for (var _Jj = 0, _Ji = ($1.ecb1 + $1.ecb2) - 1; _Jj <= _Ji; _Jj += 1) { /*16393*/
				$1.j = _Jj; /*16390*/
				$put($1.cws, $1.cw, $get($get($1.ecwsb, $1.j), $1.i)); /*16391*/
				$1.cw = $1.cw + 1; /*16392*/
			} /*16392*/
		} /*16392*/
		if ($1.rbit > 0) { /*16402*/
			$1.pad = $a($1.cws.length + 1); /*16398*/
			$puti($1.pad, 0, $1.cws); /*16399*/
			$put($1.pad, $1.pad.length - 1, 0); /*16400*/
			$1.cws = $1.pad; /*16401*/
		} /*16401*/
		if ($1.lc4b) { /*16413*/
			var _K1 = $1.cws; /*16406*/
			var _K2 = $1.dcws; /*16406*/
			$put(_K1, _K2 - 1, $get(_K1, _K2 - 1) >>> 4); /*16406*/
			for (var _K7 = $1.dcws - 1, _K6 = $1.ncws - 2; _K7 <= _K6; _K7 += 1) { /*16411*/
				$1.i = _K7; /*16408*/
				$put($1.cws, $1.i, ($get($1.cws, $1.i) & 15) << 4); /*16409*/
				$put($1.cws, $1.i, (($get($1.cws, $1.i + 1) >>> 4) & 15) | $get($1.cws, $1.i)); /*16410*/
			} /*16410*/
			$put($1.cws, $1.ncws - 1, ($get($1.cws, $1.ncws - 1) & 15) << 4); /*16412*/
		} /*16412*/
		$k[$j++] = "pixs"; /*16416*/
		$k[$j++] = Infinity; /*16416*/
		for (var _KS = 0, _KT = $1.size * $1.size; _KS < _KT; _KS++) { /*16416*/
			$k[$j++] = -1; /*16416*/
		} /*16416*/
		var _KU = $a(); /*16416*/
		$1[$k[--$j]] = _KU; /*16416*/
		$1.qmv = function() {
			var _KX = $k[--$j]; /*16417*/
			var _KY = $k[--$j]; /*16417*/
			$k[$j++] = _KY + (_KX * $1.size); /*16417*/
		}; /*16417*/
		$1.fpat = $a([$a([1, 1, 1, 1, 1, 1, 1, 0]), $a([1, 0, 0, 0, 0, 0, 1, 0]), $a([1, 0, 1, 1, 1, 0, 1, 0]), $a([1, 0, 1, 1, 1, 0, 1, 0]), $a([1, 0, 1, 1, 1, 0, 1, 0]), $a([1, 0, 0, 0, 0, 0, 1, 0]), $a([1, 1, 1, 1, 1, 1, 1, 0]), $a([0, 0, 0, 0, 0, 0, 0, 0])]); /*16429*/
		for (var _Kk = 0, _Kj = $1.fpat.length - 1; _Kk <= _Kj; _Kk += 1) { /*16441*/
			$1.y = _Kk; /*16431*/
			for (var _Ko = 0, _Kn = $get($1.fpat, 0).length - 1; _Ko <= _Kn; _Ko += 1) { /*16440*/
				$1.x = _Ko; /*16433*/
				$1.fpb = $get($get($1.fpat, $1.y), $1.x); /*16434*/
				$k[$j++] = $1.pixs; /*16435*/
				$k[$j++] = $1.x; /*16435*/
				$k[$j++] = $1.y; /*16435*/
				$1.qmv(); /*16435*/
				var _Ky = $k[--$j]; /*16435*/
				$put($k[--$j], _Ky, $1.fpb); /*16435*/
				if ($eq($1.format, "full")) { /*16439*/
					$k[$j++] = $1.pixs; /*16437*/
					$k[$j++] = ($1.size - $1.x) - 1; /*16437*/
					$k[$j++] = $1.y; /*16437*/
					$1.qmv(); /*16437*/
					var _L6 = $k[--$j]; /*16437*/
					$put($k[--$j], _L6, $1.fpb); /*16437*/
					$k[$j++] = $1.pixs; /*16438*/
					$k[$j++] = $1.x; /*16438*/
					$k[$j++] = ($1.size - $1.y) - 1; /*16438*/
					$1.qmv(); /*16438*/
					var _LD = $k[--$j]; /*16438*/
					$put($k[--$j], _LD, $1.fpb); /*16438*/
				} /*16438*/
			} /*16438*/
		} /*16438*/
		$1.algnpat = $a([$a([1, 1, 1, 1, 1]), $a([1, 0, 0, 0, 1]), $a([1, 0, 1, 0, 1]), $a([1, 0, 0, 0, 1]), $a([1, 1, 1, 1, 1])]); /*16450*/
		$1.putalgnpat = function() {
			$1.py = $k[--$j]; /*16452*/
			$1.px = $k[--$j]; /*16453*/
			for (var _LN = 0; _LN <= 4; _LN += 1) { /*16460*/
				$1.pb = _LN; /*16455*/
				for (var _LO = 0; _LO <= 4; _LO += 1) { /*16459*/
					$1.pa = _LO; /*16457*/
					$k[$j++] = $1.pixs; /*16458*/
					$k[$j++] = $1.px + $1.pa; /*16458*/
					$k[$j++] = $1.py + $1.pb; /*16458*/
					$1.qmv(); /*16458*/
					var _LZ = $k[--$j]; /*16458*/
					$put($k[--$j], _LZ, $get($get($1.algnpat, $1.pb), $1.pa)); /*16458*/
				} /*16458*/
			} /*16458*/
		}; /*16461*/
		for (var _Lg = $1.asp2 - 2, _Lh = $1.asp3 - $1.asp2, _Lf = $1.size - 13; _Lh < 0 ? _Lg >= _Lf : _Lg <= _Lf; _Lg += _Lh) { /*16466*/
			$1.i = _Lg; /*16463*/
			$k[$j++] = $1.i; /*16464*/
			$k[$j++] = 4; /*16464*/
			$1.putalgnpat(); /*16464*/
			$k[$j++] = 4; /*16465*/
			$k[$j++] = $1.i; /*16465*/
			$1.putalgnpat(); /*16465*/
		} /*16465*/
		for (var _Lp = $1.asp2 - 2, _Lq = $1.asp3 - $1.asp2, _Lo = $1.size - 9; _Lq < 0 ? _Lp >= _Lo : _Lp <= _Lo; _Lp += _Lq) { /*16473*/
			$1.x = _Lp; /*16468*/
			for (var _Lw = $1.asp2 - 2, _Lx = $1.asp3 - $1.asp2, _Lv = $1.size - 9; _Lx < 0 ? _Lw >= _Lv : _Lw <= _Lv; _Lw += _Lx) { /*16472*/
				$1.y = _Lw; /*16470*/
				$k[$j++] = $1.x; /*16471*/
				$k[$j++] = $1.y; /*16471*/
				$1.putalgnpat(); /*16471*/
			} /*16471*/
		} /*16471*/
		if ($eq($1.format, "full")) { /*16486*/
			for (var _M3 = 8, _M2 = $1.size - 9; _M3 <= _M2; _M3 += 1) { /*16481*/
				$1.i = _M3; /*16478*/
				$k[$j++] = $1.pixs; /*16479*/
				$k[$j++] = $1.i; /*16479*/
				$k[$j++] = 6; /*16479*/
				$1.qmv(); /*16479*/
				var _M7 = $k[--$j]; /*16479*/
				$put($k[--$j], _M7, ($1.i + 1) % 2); /*16479*/
				$k[$j++] = $1.pixs; /*16480*/
				$k[$j++] = 6; /*16480*/
				$k[$j++] = $1.i; /*16480*/
				$1.qmv(); /*16480*/
				var _MC = $k[--$j]; /*16480*/
				$put($k[--$j], _MC, ($1.i + 1) % 2); /*16480*/
			} /*16480*/
		} else { /*16486*/
			for (var _MG = 8, _MF = $1.size - 1; _MG <= _MF; _MG += 1) { /*16487*/
				$1.i = _MG; /*16484*/
				$k[$j++] = $1.pixs; /*16485*/
				$k[$j++] = $1.i; /*16485*/
				$k[$j++] = 0; /*16485*/
				$1.qmv(); /*16485*/
				var _MK = $k[--$j]; /*16485*/
				$put($k[--$j], _MK, ($1.i + 1) % 2); /*16485*/
				$k[$j++] = $1.pixs; /*16486*/
				$k[$j++] = 0; /*16486*/
				$k[$j++] = $1.i; /*16486*/
				$1.qmv(); /*16486*/
				var _MP = $k[--$j]; /*16486*/
				$put($k[--$j], _MP, ($1.i + 1) % 2); /*16486*/
			} /*16486*/
		} /*16486*/
		if ($eq($1.format, "full")) { /*16504*/
			$1.formatmap = $a([$a([$a([0, 8]), $a([8, $1.size - 1])]), $a([$a([1, 8]), $a([8, $1.size - 2])]), $a([$a([2, 8]), $a([8, $1.size - 3])]), $a([$a([3, 8]), $a([8, $1.size - 4])]), $a([$a([4, 8]), $a([8, $1.size - 5])]), $a([$a([5, 8]), $a([8, $1.size - 6])]), $a([$a([7, 8]), $a([8, $1.size - 7])]), $a([$a([8, 8]), $a([$1.size - 8, 8])]), $a([$a([8, 7]), $a([$1.size - 7, 8])]), $a([$a([8, 5]), $a([$1.size - 6, 8])]), $a([$a([8, 4]), $a([$1.size - 5, 8])]), $a([$a([8, 3]), $a([$1.size - 4, 8])]), $a([$a([8, 2]), $a([$1.size - 3, 8])]), $a([$a([8, 1]), $a([$1.size - 2, 8])]), $a([$a([8, 0]), $a([$1.size - 1, 8])])]); /*16498*/
		} else { /*16504*/
			$1.formatmap = $a([$a([$a([1, 8])]), $a([$a([2, 8])]), $a([$a([3, 8])]), $a([$a([4, 8])]), $a([$a([5, 8])]), $a([$a([6, 8])]), $a([$a([7, 8])]), $a([$a([8, 8])]), $a([$a([8, 7])]), $a([$a([8, 6])]), $a([$a([8, 5])]), $a([$a([8, 4])]), $a([$a([8, 3])]), $a([$a([8, 2])]), $a([$a([8, 1])])]); /*16504*/
		} /*16504*/
		var _Nw = $1.formatmap; /*16506*/
		for (var _Nx = 0, _Ny = _Nw.length; _Nx < _Ny; _Nx++) { /*16508*/
			$forall($get(_Nw, _Nx), function() { /*16507*/
				$forall($k[--$j]); /*16507*/
				$1.qmv(); /*16507*/
				$put($1.pixs, $k[--$j], 0); /*16507*/
			}) /*16507*/
		} /*16507*/
		if ($1.size >= 45) { /*16524*/
			$1.versionmap = $a([$a([$a([$1.size - 9, 5]), $a([5, $1.size - 9])]), $a([$a([$1.size - 10, 5]), $a([5, $1.size - 10])]), $a([$a([$1.size - 11, 5]), $a([5, $1.size - 11])]), $a([$a([$1.size - 9, 4]), $a([4, $1.size - 9])]), $a([$a([$1.size - 10, 4]), $a([4, $1.size - 10])]), $a([$a([$1.size - 11, 4]), $a([4, $1.size - 11])]), $a([$a([$1.size - 9, 3]), $a([3, $1.size - 9])]), $a([$a([$1.size - 10, 3]), $a([3, $1.size - 10])]), $a([$a([$1.size - 11, 3]), $a([3, $1.size - 11])]), $a([$a([$1.size - 9, 2]), $a([2, $1.size - 9])]), $a([$a([$1.size - 10, 2]), $a([2, $1.size - 10])]), $a([$a([$1.size - 11, 2]), $a([2, $1.size - 11])]), $a([$a([$1.size - 9, 1]), $a([1, $1.size - 9])]), $a([$a([$1.size - 10, 1]), $a([1, $1.size - 10])]), $a([$a([$1.size - 11, 1]), $a([1, $1.size - 11])]), $a([$a([$1.size - 9, 0]), $a([0, $1.size - 9])]), $a([$a([$1.size - 10, 0]), $a([0, $1.size - 10])]), $a([$a([$1.size - 11, 0]), $a([0, $1.size - 11])])]); /*16522*/
		} else { /*16524*/
			$1.versionmap = $a([]); /*16524*/
		} /*16524*/
		var _PY = $1.versionmap; /*16526*/
		for (var _PZ = 0, _Pa = _PY.length; _PZ < _Pa; _PZ++) { /*16528*/
			$forall($get(_PY, _PZ), function() { /*16527*/
				$forall($k[--$j]); /*16527*/
				$1.qmv(); /*16527*/
				$put($1.pixs, $k[--$j], 0); /*16527*/
			}) /*16527*/
		} /*16527*/
		if ($eq($1.format, "full")) { /*16533*/
			$k[$j++] = $1.pixs; /*16532*/
			$k[$j++] = 8; /*16532*/
			$k[$j++] = $1.size - 8; /*16532*/
			$1.qmv(); /*16532*/
			var _Pi = $k[--$j]; /*16532*/
			$put($k[--$j], _Pi, 1); /*16532*/
		} /*16532*/
		if ($eq($1.format, "full")) { /*16553*/
			var _Q2 = $a([function() {
				var _Pl = $k[--$j]; /*16538*/
				var _Pm = $k[--$j]; /*16538*/
				$k[$j++] = (_Pm + _Pl) % 2; /*16538*/
			}, function() {
				var _Pn = $k[--$j]; /*16539*/
				var _Po = $k[--$j]; /*16539*/
				$k[$j++] = _Pn % 2; /*16539*/
			}, function() {
				$j--; /*16540*/
				var _Pp = $k[--$j]; /*16540*/
				$k[$j++] = _Pp % 3; /*16540*/
			}, function() {
				var _Pq = $k[--$j]; /*16541*/
				var _Pr = $k[--$j]; /*16541*/
				$k[$j++] = (_Pr + _Pq) % 3; /*16541*/
			}, function() {
				var _Ps = $k[--$j]; /*16542*/
				var _Pt = $k[--$j]; /*16542*/
				$k[$j++] = ((~~(_Ps / 2)) + (~~(_Pt / 3))) % 2; /*16542*/
			}, function() {
				var _Pu = $k[--$j]; /*16543*/
				var _Pw = $k[--$j] * _Pu; /*16543*/
				$k[$j++] = (_Pw % 2) + (_Pw % 3); /*16543*/
			}, function() {
				var _Px = $k[--$j]; /*16544*/
				var _Pz = $k[--$j] * _Px; /*16544*/
				$k[$j++] = ((_Pz % 2) + (_Pz % 3)) % 2; /*16544*/
			}, function() {
				var _Q0 = $k[--$j]; /*16545*/
				var _Q1 = $k[--$j]; /*16545*/
				$k[$j++] = (((_Q1 * _Q0) % 3) + ((_Q1 + _Q0) % 2)) % 2; /*16545*/
			}]); /*16545*/
			$1.maskfuncs = _Q2; /*16546*/
		} else { /*16553*/
			var _QC = $a([function() {
				var _Q3 = $k[--$j]; /*16549*/
				var _Q4 = $k[--$j]; /*16549*/
				$k[$j++] = _Q3 % 2; /*16549*/
			}, function() {
				var _Q5 = $k[--$j]; /*16550*/
				var _Q6 = $k[--$j]; /*16550*/
				$k[$j++] = ((~~(_Q5 / 2)) + (~~(_Q6 / 3))) % 2; /*16550*/
			}, function() {
				var _Q7 = $k[--$j]; /*16551*/
				var _Q9 = $k[--$j] * _Q7; /*16551*/
				$k[$j++] = ((_Q9 % 2) + (_Q9 % 3)) % 2; /*16551*/
			}, function() {
				var _QA = $k[--$j]; /*16552*/
				var _QB = $k[--$j]; /*16552*/
				$k[$j++] = (((_QB * _QA) % 3) + ((_QB + _QA) % 2)) % 2; /*16552*/
			}]); /*16552*/
			$1.maskfuncs = _QC; /*16553*/
		} /*16553*/
		if ($1.mask != -1) { /*16558*/
			$1.maskfuncs = $a([$get($1.maskfuncs, $1.mask - 1)]); /*16556*/
			$1.bestmaskval = $1.mask - 1; /*16557*/
		} /*16557*/
		$1.masks = $a($1.maskfuncs.length); /*16559*/
		for (var _QN = 0, _QM = $1.masks.length - 1; _QN <= _QM; _QN += 1) { /*16573*/
			$1.m = _QN; /*16561*/
			$1.mask = $a($1.size * $1.size); /*16562*/
			for (var _QT = 0, _QS = $1.size - 1; _QT <= _QS; _QT += 1) { /*16571*/
				$1.j = _QT; /*16564*/
				for (var _QW = 0, _QV = $1.size - 1; _QW <= _QV; _QW += 1) { /*16570*/
					$1.i = _QW; /*16566*/
					$k[$j++] = $1.i; /*16567*/
					$k[$j++] = $1.j; /*16567*/
					$get($1.maskfuncs, $1.m)(); /*16567*/
					var _Qc = $k[--$j]; /*16567*/
					$k[$j++] = _Qc == 0; /*16568*/
					$k[$j++] = $1.pixs; /*16568*/
					$k[$j++] = $1.i; /*16568*/
					$k[$j++] = $1.j; /*16568*/
					$1.qmv(); /*16568*/
					var _Qg = $k[--$j]; /*16568*/
					var _Qi = $get($k[--$j], _Qg); /*16568*/
					var _Qk = ($k[--$j] && (_Qi == -1)) ? 1 : 0; /*16568*/
					$k[$j++] = _Qk; /*16569*/
					$k[$j++] = $1.mask; /*16569*/
					$k[$j++] = $1.i; /*16569*/
					$k[$j++] = $1.j; /*16569*/
					$1.qmv(); /*16569*/
					var _Qo = $k[--$j]; /*16569*/
					var _Qp = $k[--$j]; /*16569*/
					$put(_Qp, _Qo, $k[--$j]); /*16569*/
				} /*16569*/
			} /*16569*/
			$put($1.masks, $1.m, $1.mask); /*16572*/
		} /*16572*/
		$1.posx = $1.size - 1; /*16576*/
		$1.posy = $1.size - 1; /*16577*/
		$1.dir = -1; /*16578*/
		$1.col = 1; /*16579*/
		$1.num = 0; /*16580*/
		for (;;) { /*16603*/
			if ($1.posx < 0) { /*16582*/
				break; /*16582*/
			} /*16582*/
			$k[$j++] = $1.pixs; /*16583*/
			$k[$j++] = $1.posx; /*16583*/
			$k[$j++] = $1.posy; /*16583*/
			$1.qmv(); /*16583*/
			var _R0 = $k[--$j]; /*16583*/
			if ($get($k[--$j], _R0) == -1) { /*16587*/
				var _R5 = $get($1.cws, ~~($1.num / 8)); /*16584*/
				var _R7 = -(7 - ($1.num % 8)); /*16584*/
				$k[$j++] = ((_R7 < 0 ? _R5 >>> -_R7 : _R5 << _R7)) & 1; /*16585*/
				$k[$j++] = $1.pixs; /*16585*/
				$k[$j++] = $1.posx; /*16585*/
				$k[$j++] = $1.posy; /*16585*/
				$1.qmv(); /*16585*/
				var _RB = $k[--$j]; /*16585*/
				var _RC = $k[--$j]; /*16585*/
				$put(_RC, _RB, $k[--$j]); /*16585*/
				$1.num = $1.num + 1; /*16586*/
			} /*16586*/
			if ($1.col == 1) { /*16600*/
				$1.col = 0; /*16589*/
				$1.posx = $1.posx - 1; /*16590*/
			} else { /*16600*/
				$1.col = 1; /*16592*/
				$1.posx = $1.posx + 1; /*16593*/
				$1.posy = $1.posy + $1.dir; /*16594*/
				if (($1.posy < 0) || ($1.posy >= $1.size)) { /*16601*/
					$1.dir = $1.dir * -1; /*16596*/
					$1.posy = $1.posy + $1.dir; /*16597*/
					$1.posx = $1.posx - 2; /*16598*/
					if ($eq($1.format, "full") && ($1.posx == 6)) { /*16600*/
						$1.posx = $1.posx - 1; /*16600*/
					} /*16600*/
				} /*16600*/
			} /*16600*/
		} /*16600*/
		$1.evalfulln1n3 = function() {
			$1.scrle = $k[--$j]; /*16607*/
			$k[$j++] = "scr1"; /*16609*/
			$k[$j++] = 0; /*16609*/
			$forall($1.scrle, function() { /*16609*/
				var _RW = $k[--$j]; /*16609*/
				$k[$j++] = _RW; /*16609*/
				if (_RW >= 5) { /*16609*/
					var _RX = $k[--$j]; /*16609*/
					var _RZ = ($k[--$j] + _RX) - 2; /*16609*/
					$k[$j++] = _RZ; /*16609*/
					$k[$j++] = _RZ; /*16609*/
				} /*16609*/
				$j--; /*16609*/
			}) /*16609*/
			var _Ra = $k[--$j]; /*16609*/
			$1[$k[--$j]] = _Ra; /*16609*/
			$1.scr3 = 0; /*16611*/
			for (var _Re = 3, _Rd = $1.scrle.length - 3; _Re <= _Rd; _Re += 2) { /*16626*/
				$1.j = _Re; /*16613*/
				if (($get($1.scrle, $1.j) % 3) == 0) { /*16625*/
					$1.fact = ~~($get($1.scrle, $1.j) / 3); /*16615*/
					$forall($geti($1.scrle, $1.j - 2, 5), function() { /*16616*/
						var _Rp = $k[--$j]; /*16616*/
						$k[$j++] = _Rp == $1.fact; /*16616*/
					}) /*16616*/
					var _Rq = $k[--$j]; /*16616*/
					var _Rr = $k[--$j]; /*16616*/
					var _Rs = $k[--$j]; /*16616*/
					var _Rt = $k[--$j]; /*16616*/
					if ($k[--$j] && (_Rt && (_Rr && _Rq))) { /*16624*/
						if (($1.j == 3) || (($1.j + 4) >= $1.scrle.length)) { /*16621*/
							$1.scr3 = $1.scr3 + 40; /*16618*/
						} else { /*16621*/
							if (($get($1.scrle, $1.j - 3) >= 4) || ($get($1.scrle, $1.j + 3) >= 4)) { /*16622*/
								$1.scr3 = $1.scr3 + 40; /*16621*/
							} /*16621*/
						} /*16621*/
					} /*16621*/
				} /*16621*/
			} /*16621*/
			$k[$j++] = $1.scr1; /*16627*/
			$k[$j++] = $1.scr3; /*16627*/
		}; /*16628*/
		$1.evalfull = function() {
			$1.sym = $k[--$j]; /*16632*/
			$1.n1 = 0; /*16634*/
			$1.n2 = 0; /*16634*/
			$1.n3 = 0; /*16634*/
			$1.rle = $a($1.size + 1); /*16635*/
			$1.lastpairs = $a($1.size); /*16636*/
			$1.thispairs = $a($1.size); /*16637*/
			$1.sizeadd1 = $1.size + 1; /*16638*/
			for (var _SI = 0, _SH = $1.size - 1; _SI <= _SH; _SI += 1) { /*16677*/
				$1.i = _SI; /*16640*/
				$k[$j++] = Infinity; /*16643*/
				var _SK = $1.size; /*16644*/
				$k[$j++] = 0; /*16646*/
				$k[$j++] = 0; /*16646*/
				for (var _SM = $1.i, _SN = _SK, _SL = (_SK * _SK) - 1; _SN < 0 ? _SM >= _SL : _SM <= _SL; _SM += _SN) { /*16646*/
					var _SP = $get($1.sym, _SM); /*16645*/
					var _SQ = $k[--$j]; /*16645*/
					$k[$j++] = _SP; /*16645*/
					if ($eq(_SQ, _SP)) { /*16645*/
						var _SR = $k[--$j]; /*16645*/
						var _SS = $k[--$j]; /*16645*/
						$k[$j++] = _SS + 1; /*16645*/
						$k[$j++] = _SR; /*16645*/
					} else { /*16645*/
						var _ST = $k[--$j]; /*16645*/
						$k[$j++] = 1; /*16645*/
						$k[$j++] = _ST; /*16645*/
					} /*16645*/
				} /*16645*/
				$j--; /*16647*/
				var _SV = $counttomark() + 2; /*16648*/
				$astore($geti($1.rle, 0, _SV - 2)); /*16648*/
				$1.evalfulln1n3(); /*16649*/
				$1.n3 = $k[--$j] + $1.n3; /*16649*/
				$1.n1 = $k[--$j] + $1.n1; /*16649*/
				$j--; /*16650*/
				$1.symrow = $geti($1.sym, $1.i * $1.size, $1.size); /*16653*/
				$k[$j++] = Infinity; /*16654*/
				$k[$j++] = 0; /*16657*/
				$k[$j++] = 0; /*16657*/
				$forall($1.symrow, function() { /*16657*/
					var _Sh = $k[--$j]; /*16656*/
					var _Si = $k[--$j]; /*16656*/
					$k[$j++] = _Sh; /*16656*/
					if ($eq(_Si, _Sh)) { /*16656*/
						var _Sj = $k[--$j]; /*16656*/
						var _Sk = $k[--$j]; /*16656*/
						$k[$j++] = _Sk + 1; /*16656*/
						$k[$j++] = _Sj; /*16656*/
					} else { /*16656*/
						var _Sl = $k[--$j]; /*16656*/
						$k[$j++] = 1; /*16656*/
						$k[$j++] = _Sl; /*16656*/
					} /*16656*/
				}) /*16656*/
				$j--; /*16658*/
				var _Sn = $counttomark() + 2; /*16659*/
				$astore($geti($1.rle, 0, _Sn - 2)); /*16659*/
				$1.evalfulln1n3(); /*16660*/
				$1.n3 = $k[--$j] + $1.n3; /*16660*/
				$1.n1 = $k[--$j] + $1.n1; /*16660*/
				$j--; /*16661*/
				var _St = $1.thispairs; /*16664*/
				$1.thispairs = $1.lastpairs; /*16664*/
				$1.lastpairs = _St; /*16664*/
				var _Sx = ($get($1.symrow, 0) == 1) ? 0 : 1; /*16665*/
				$k[$j++] = _Sx; /*16666*/
				$forall($1.symrow, function() { /*16666*/
					var _Sz = $k[--$j]; /*16666*/
					var _T0 = $k[--$j]; /*16666*/
					$k[$j++] = _T0 + _Sz; /*16666*/
					$k[$j++] = _Sz; /*16666*/
				}) /*16666*/
				$j--; /*16667*/
				$astore($1.thispairs); /*16668*/
				$j--; /*16668*/
				if ($1.i > 0) { /*16675*/
					$k[$j++] = Infinity; /*16670*/
					$aload($1.lastpairs); /*16671*/
					$aload($1.thispairs); /*16671*/
					$k[$j++] = $1.n2; /*16672*/
					for (var _T7 = 0, _T8 = $1.size; _T7 < _T8; _T7++) { /*16672*/
						var _T9 = $k[--$j]; /*16672*/
						var _TA = $k[--$j]; /*16672*/
						$k[$j++] = _T9; /*16672*/
						$k[$j++] = _TA; /*16672*/
						var _TC = $k[$j - 1 - $1.sizeadd1]; /*16672*/
						if ((($k[--$j] + _TC) & 3) == 0) { /*16672*/
							var _TE = $k[--$j]; /*16672*/
							$k[$j++] = _TE + 3; /*16672*/
						} /*16672*/
					} /*16672*/
					$1.n2 = $k[--$j]; /*16673*/
					$cleartomark(); /*16674*/
				} /*16674*/
			} /*16674*/
			$k[$j++] = "dark"; /*16680*/
			$k[$j++] = 0; /*16680*/
			$forall($1.sym, function() { /*16680*/
				var _TH = $k[--$j]; /*16680*/
				var _TI = $k[--$j]; /*16680*/
				$k[$j++] = _TI + _TH; /*16680*/
			}) /*16680*/
			var _TJ = $k[--$j]; /*16680*/
			$1[$k[--$j]] = _TJ; /*16680*/
			var _TM = $1.size; /*16681*/
			$1.n4 = (~~((Math.abs((($1.dark * 100) / (_TM * _TM)) - 50)) / 5)) * 10; /*16681*/
			$k[$j++] = (($1.n1 + $1.n2) + $1.n3) + $1.n4; /*16683*/
		}; /*16684*/
		$1.evalmicro = function() {
			$1.sym = $k[--$j]; /*16688*/
			$1.dkrhs = 0; /*16689*/
			$1.dkbot = 0; /*16689*/
			for (var _TU = 1, _TT = $1.size - 1; _TU <= _TT; _TU += 1) { /*16694*/
				$1.i = _TU; /*16691*/
				$k[$j++] = "dkrhs"; /*16692*/
				$k[$j++] = $1.dkrhs; /*16692*/
				$k[$j++] = $1.sym; /*16692*/
				$k[$j++] = $1.size - 1; /*16692*/
				$k[$j++] = $1.i; /*16692*/
				$1.qmv(); /*16692*/
				var _TZ = $k[--$j]; /*16692*/
				var _Tb = $get($k[--$j], _TZ); /*16692*/
				var _Tc = $k[--$j]; /*16692*/
				$1[$k[--$j]] = _Tc + _Tb; /*16692*/
				$k[$j++] = "dkbot"; /*16693*/
				$k[$j++] = $1.dkbot; /*16693*/
				$k[$j++] = $1.sym; /*16693*/
				$k[$j++] = $1.i; /*16693*/
				$k[$j++] = $1.size - 1; /*16693*/
				$1.qmv(); /*16693*/
				var _Ti = $k[--$j]; /*16693*/
				var _Tk = $get($k[--$j], _Ti); /*16693*/
				var _Tl = $k[--$j]; /*16693*/
				$1[$k[--$j]] = _Tl + _Tk; /*16693*/
			} /*16693*/
			if ($1.dkrhs <= $1.dkbot) { /*16698*/
				$k[$j++] = -(($1.dkrhs * 16) + $1.dkbot); /*16696*/
			} else { /*16698*/
				$k[$j++] = -(($1.dkbot * 16) + $1.dkrhs); /*16698*/
			} /*16698*/
		}; /*16700*/
		$1.bestscore = 999999999; /*16703*/
		for (var _Tv = 0, _Tu = $1.masks.length - 1; _Tv <= _Tu; _Tv += 1) { /*16725*/
			$1.m = _Tv; /*16705*/
			$1.masksym = $a($1.size * $1.size); /*16706*/
			for (var _U2 = 0, _U1 = ($1.size * $1.size) - 1; _U2 <= _U1; _U2 += 1) { /*16710*/
				$1.i = _U2; /*16708*/
				$put($1.masksym, $1.i, $xo($get($1.pixs, $1.i), $get($get($1.masks, $1.m), $1.i))); /*16709*/
			} /*16709*/
			if ($1.masks.length != 1) { /*16723*/
				if ($eq($1.format, "full")) { /*16715*/
					$k[$j++] = $1.masksym; /*16713*/
					$1.evalfull(); /*16713*/
					$1.score = $k[--$j]; /*16713*/
				} else { /*16715*/
					$k[$j++] = $1.masksym; /*16715*/
					$1.evalmicro(); /*16715*/
					$1.score = $k[--$j]; /*16715*/
				} /*16715*/
				if ($1.score < $1.bestscore) { /*16721*/
					$1.bestsym = $1.masksym; /*16718*/
					$1.bestmaskval = $1.m; /*16719*/
					$1.bestscore = $1.score; /*16720*/
				} /*16720*/
			} else { /*16723*/
				$1.bestsym = $1.masksym; /*16723*/
			} /*16723*/
		} /*16723*/
		$1.pixs = $1.bestsym; /*16726*/
		if ($eq($1.format, "full")) { /*16746*/
			$1.fmtvals = $a([21522, 20773, 24188, 23371, 17913, 16590, 20375, 19104, 30660, 29427, 32170, 30877, 26159, 25368, 27713, 26998, 5769, 5054, 7399, 6608, 1890, 597, 3340, 2107, 13663, 12392, 16177, 14854, 9396, 8579, 11994, 11245]); /*16735*/
			$k[$j++] = "ecid"; /*16736*/
			$search("MLHQ", $1.eclevel); /*16736*/
			$j--; /*16736*/
			var _UT = $k[--$j]; /*16736*/
			var _UU = $k[--$j]; /*16736*/
			var _UV = $k[--$j]; /*16736*/
			$1[$k[--$j]] = _UT.length; /*16736*/
			$1.fmtval = $get($1.fmtvals, ($1.ecid << 3) + $1.bestmaskval); /*16737*/
		} else { /*16746*/
			$1.fmtvals = $a([17477, 16754, 20011, 19228, 21934, 20633, 24512, 23287, 26515, 25252, 28157, 26826, 30328, 29519, 31766, 31009, 1758, 1001, 3248, 2439, 5941, 4610, 7515, 6252, 9480, 8255, 12134, 10833, 13539, 12756, 16013, 15290]); /*16744*/
			$1.symid = $get($get($a([$a([0]), $a([1, 2]), $a([3, 4]), $a([5, 6, 7])]), ~~(($1.size - 11) / 2)), $1.eclval); /*16745*/
			$1.fmtval = $get($1.fmtvals, ($1.symid << 2) + $1.bestmaskval); /*16746*/
		} /*16746*/
		for (var _Ur = 0, _Uq = $1.formatmap.length - 1; _Ur <= _Uq; _Ur += 1) { /*16753*/
			$1.i = _Ur; /*16749*/
			$forall($get($1.formatmap, $1.i), function() { /*16752*/
				var _Uw = $k[--$j]; /*16751*/
				$k[$j++] = $1.pixs; /*16751*/
				$forall(_Uw); /*16751*/
				$1.qmv(); /*16751*/
				var _Ux = $1.fmtval; /*16751*/
				var _Uz = -(14 - $1.i); /*16751*/
				var _V0 = $k[--$j]; /*16751*/
				$put($k[--$j], _V0, ((_Uz < 0 ? _Ux >>> -_Uz : _Ux << _Uz)) & 1); /*16751*/
			}) /*16751*/
		} /*16751*/
		if ($1.size >= 45) { /*16771*/
			$1.vervals = $a([31892, 34236, 39577, 42195, 48118, 51042, 55367, 58893, 63784, 68472, 70749, 76311, 79154, 84390, 87683, 92361, 96236, 102084, 102881, 110507, 110734, 117786, 119615, 126325, 127568, 133589, 136957, 141498, 145311, 150283, 152622, 158308, 161089, 167017]); /*16763*/
			$1.verval = $get($1.vervals, (~~(($1.size - 17) / 4)) - 7); /*16764*/
			for (var _V9 = 0, _V8 = $1.versionmap.length - 1; _V9 <= _V8; _V9 += 1) { /*16770*/
				$1.i = _V9; /*16766*/
				$forall($get($1.versionmap, $1.i), function() { /*16769*/
					var _VE = $k[--$j]; /*16768*/
					$k[$j++] = $1.pixs; /*16768*/
					$forall(_VE); /*16768*/
					$1.qmv(); /*16768*/
					var _VF = $1.verval; /*16768*/
					var _VH = -(17 - $1.i); /*16768*/
					var _VI = $k[--$j]; /*16768*/
					$put($k[--$j], _VI, ((_VH < 0 ? _VF >>> -_VH : _VF << _VH)) & 1); /*16768*/
				}) /*16768*/
			} /*16768*/
		} /*16768*/
		var _VQ = {
			ren: $0.renmatrix,
			pixs: $1.pixs,
			pixx: $1.size,
			pixy: $1.size,
			height: ($1.size * 2) / 72,
			width: ($1.size * 2) / 72,
			opt: $1.options
		}; /*16781*/
		$k[$j++] = _VQ; /*16784*/
		if (!$1.dontdraw) { /*16784*/
			$0.renmatrix(); /*16784*/
		} /*16784*/
	};
	$0.microqrcode = function() {
		var $1 = {}; /*16812*/
		$1.options = $k[--$j]; /*16814*/
		$1.barcode = $k[--$j]; /*16815*/
		$1.dontdraw = false; /*16817*/
		$forall($1.options, function() { /*16828*/
			var _3 = $k[--$j]; /*16828*/
			$1[$k[--$j]] = _3; /*16828*/
		}) /*16828*/
		$1.options.dontdraw = true; /*16831*/
		$1.options.format = "micro"; /*16832*/
		$k[$j++] = "args"; /*16834*/
		$k[$j++] = $1.barcode; /*16834*/
		$k[$j++] = $1.options; /*16834*/
		$0.qrcode(); /*16834*/
		var _9 = $k[--$j]; /*16834*/
		$1[$k[--$j]] = _9; /*16834*/
		$1.args.opt = $1.options; /*16836*/
		$k[$j++] = $1.args; /*16839*/
		if (!$1.dontdraw) { /*16839*/
			$0.renmatrix(); /*16839*/
		} /*16839*/
	};
	$0.maxicode = function() {
		var $1 = {}; /*16866*/
		$1.options = $k[--$j]; /*16868*/
		$1.barcode = $k[--$j]; /*16869*/
		$1.dontdraw = false; /*16871*/
		$1.mode = -1; /*16872*/
		$1.sam = -1; /*16873*/
		$1.parse = false; /*16874*/
		$forall($1.options, function() { /*16885*/
			var _3 = $k[--$j]; /*16885*/
			$1[$k[--$j]] = _3; /*16885*/
		}) /*16885*/
		$1.mode = ~~$1.mode; /*16887*/
		$1.sam = ~~$1.sam; /*16888*/
		$1.msg = $1.barcode; /*16911*/
		$1.msglen = $1.msg.length; /*16912*/
		if (($1.mode == 2) || ($1.mode == 3)) { /*16938*/
			if ($eq($geti($1.msg, 0, 7), "\x5b\x29\x3e\x1e\x30\x31\x1d")) { /*16922*/
				$1.fid = $geti($1.msg, 0, 9); /*16919*/
				$1.msg = $geti($1.msg, 9, $1.msglen - 9); /*16920*/
			} else { /*16922*/
				$1.fid = ""; /*16922*/
			} /*16922*/
			$search($1.msg, "\x1d"); /*16926*/
			$j--; /*16926*/
			$1.pcode = $k[--$j]; /*16926*/
			$j--; /*16927*/
			$search($k[--$j], "\x1d"); /*16927*/
			$j--; /*16927*/
			$1.ccode = $k[--$j]; /*16927*/
			$j--; /*16928*/
			$search($k[--$j], "\x1d"); /*16928*/
			$j--; /*16928*/
			$1.scode = $k[--$j]; /*16928*/
			$j--; /*16929*/
			$1.msg = $k[--$j]; /*16929*/
			var _R = $s($1.msg.length + $1.fid.length); /*16932*/
			$puti(_R, 0, $1.fid); /*16933*/
			$puti(_R, $1.fid.length, $1.msg); /*16934*/
			$1.msg = _R; /*16935*/
			$1.msglen = $1.msg.length; /*16936*/
		} /*16936*/
		$1.eci = -1; /*16941*/
		$1.pad = -2; /*16941*/
		$1.ns = -3; /*16941*/
		$1.la = -4; /*16942*/
		$1.lb = -5; /*16942*/
		$1.sa = -6; /*16943*/
		$1.sb = -7; /*16943*/
		$1.sc = -8; /*16943*/
		$1.sd = -9; /*16943*/
		$1.se = -10; /*16943*/
		$1.sa2 = -11; /*16944*/
		$1.sa3 = -12; /*16944*/
		$1.lkc = -13; /*16945*/
		$1.lkd = -14; /*16945*/
		$1.lke = -15; /*16945*/
		$1.pd2 = -16; /*16946*/
		$1.pd3 = -17; /*16946*/
		$1.charmaps = $a([$a([13, "`", 192, 224, 0]), $a(["A", "a", 193, 225, 1]), $a(["B", "b", 194, 226, 2]), $a(["C", "c", 195, 227, 3]), $a(["D", "d", 196, 228, 4]), $a(["E", "e", 197, 229, 5]), $a(["F", "f", 198, 230, 6]), $a(["G", "g", 199, 231, 7]), $a(["H", "h", 200, 232, 8]), $a(["I", "i", 201, 233, 9]), $a(["J", "j", 202, 234, 10]), $a(["K", "k", 203, 235, 11]), $a(["L", "l", 204, 236, 12]), $a(["M", "m", 205, 237, 13]), $a(["N", "n", 206, 238, 14]), $a(["O", "o", 207, 239, 15]), $a(["P", "p", 208, 240, 16]), $a(["Q", "q", 209, 241, 17]), $a(["R", "r", 210, 242, 18]), $a(["S", "s", 211, 243, 19]), $a(["T", "t", 212, 244, 20]), $a(["U", "u", 213, 245, 21]), $a(["V", "v", 214, 246, 22]), $a(["W", "w", 215, 247, 23]), $a(["X", "x", 216, 248, 24]), $a(["Y", "y", 217, 249, 25]), $a(["Z", "z", 218, 250, 26]), $a([$1.eci, $1.eci, $1.eci, $1.eci, $1.eci]), $a([28, 28, 28, 28, $1.pad]), $a([29, 29, 29, 29, $1.pad]), $a([30, 30, 30, 30, 27]), $a([$1.ns, $1.ns, $1.ns, $1.ns, $1.ns]), $a([" ", "{", 219, 251, 28]), $a([$1.pad, $1.pad, 220, 252, 29]), $a(["\"", "}", 221, 253, 30]), $a(["#", "~", 222, 254, 31]), $a(["$", 127, 223, 255, 159]), $a(["%", ";", 170, 161, 160]), $a(["&", "<", 172, 168, 162]), $a(["'", "=", 177, 171, 163]), $a([40, ">", 178, 175, 164]), $a([41, "?", 179, 176, 165]), $a(["*", "[", 181, 180, 166]), $a(["+", 92, 185, 183, 167]), $a([",", "]", 186, 184, 169]), $a(["-", "^", 188, 187, 173]), $a([".", "_", 189, 191, 174]), $a(["/", " ", 190, 138, 182]), $a(["0", ",", 128, 139, 149]), $a(["1", ".", 129, 140, 150]), $a(["2", "/", 130, 141, 151]), $a(["3", ":", 131, 142, 152]), $a(["4", "@", 132, 143, 153]), $a(["5", "!", 133, 144, 154]), $a(["6", "|", 134, 145, 155]), $a(["7", $1.pd2, 135, 146, 156]), $a(["8", $1.sa2, 136, 147, 157]), $a(["9", $1.sa3, 137, 148, 158]), $a([":", $1.pd3, $1.la, $1.la, $1.la]), $a([$1.sb, $1.sa, " ", " ", " "]), $a([$1.sc, $1.sc, $1.lkc, $1.sc, $1.sc]), $a([$1.sd, $1.sd, $1.sd, $1.lkd, $1.sd]), $a([$1.se, $1.se, $1.se, $1.se, $1.lke]), $a([$1.lb, $1.la, $1.lb, $1.lb, $1.lb])]); /*17015*/
		$1.charvals = $a([{}, {}, {}, {}, {}]); /*17018*/
		for (var _2J = 0, _2I = $1.charmaps.length - 1; _2J <= _2I; _2J += 1) { /*17027*/
			$1.i = _2J; /*17020*/
			$1.encs = $get($1.charmaps, $1.i); /*17021*/
			for (var _2N = 0; _2N <= 4; _2N += 1) { /*17026*/
				$1.j = _2N; /*17023*/
				var _2Q = $get($1.encs, $1.j); /*17024*/
				$k[$j++] = _2Q; /*17024*/
				if ($eq($type(_2Q), "stringtype")) { /*17024*/
					var _2T = $get($k[--$j], 0); /*17024*/
					$k[$j++] = _2T; /*17024*/
				} /*17024*/
				$put($get($1.charvals, $1.j), $k[--$j], $1.i); /*17025*/
			} /*17025*/
		} /*17025*/
		$1.seta = $get($1.charvals, 0); /*17028*/
		$1.setb = $get($1.charvals, 1); /*17029*/
		$1.setc = $get($1.charvals, 2); /*17030*/
		$1.setd = $get($1.charvals, 3); /*17031*/
		$1.sete = $get($1.charvals, 4); /*17032*/
		$k[$j++] = "nseq"; /*17035*/
		$k[$j++] = Infinity; /*17035*/
		for (var _2k = 0, _2l = $1.msglen + 1; _2k < _2l; _2k++) { /*17035*/
			$k[$j++] = 0; /*17035*/
		} /*17035*/
		var _2m = $a(); /*17035*/
		$1[$k[--$j]] = _2m; /*17035*/
		for (var _2p = $1.msglen - 1; _2p >= 0; _2p -= 1) { /*17043*/
			$1.i = _2p; /*17037*/
			var _2s = $get($1.msg, $1.i); /*17038*/
			if ((_2s >= 48) && (_2s <= 57)) { /*17041*/
				$put($1.nseq, $1.i, $get($1.nseq, $1.i + 1) + 1); /*17039*/
			} else { /*17041*/
				$put($1.nseq, $1.i, 0); /*17041*/
			} /*17041*/
		} /*17041*/
		$1.nseq = $geti($1.nseq, 0, $1.msglen); /*17044*/
		$1.prefixinset = function() {
			$k[$j++] = 0; /*17051*/
			for (;;) { /*17051*/
				var _33 = $k[--$j]; /*17049*/
				var _34 = $k[--$j]; /*17049*/
				$k[$j++] = _34; /*17049*/
				$k[$j++] = _33; /*17049*/
				if (_33 >= _34.length) { /*17049*/
					break; /*17049*/
				} /*17049*/
				var _35 = $k[--$j]; /*17050*/
				var _36 = $k[--$j]; /*17050*/
				var _38 = $k[--$j]; /*17050*/
				var _39 = $get(_38, $get(_36, _35)) !== undefined; /*17050*/
				$k[$j++] = _38; /*17050*/
				$k[$j++] = _36; /*17050*/
				$k[$j++] = _35; /*17050*/
				if (_39) { /*17050*/
					var _3A = $k[--$j]; /*17050*/
					$k[$j++] = _3A + 1; /*17050*/
				} else { /*17050*/
					break; /*17050*/
				} /*17050*/
			} /*17050*/
			var _3B = $k[--$j]; /*17052*/
			var _3C = $k[--$j]; /*17052*/
			var _3D = $k[--$j]; /*17052*/
			$k[$j++] = _3B; /*17052*/
		}; /*17053*/
		$1.enc = function() {
			var _3E = $k[--$j]; /*17056*/
			$put($1.out, $1.j, $get(_3E, $k[--$j])); /*17056*/
			$1.j = $1.j + 1; /*17057*/
		}; /*17058*/
		$1.out = $a(144); /*17060*/
		$1.i = 0; /*17061*/
		$1.j = 0; /*17061*/
		$1.cset = "seta"; /*17061*/
		for (;;) { /*17184*/
			if ($1.i == $1.msglen) { /*17070*/
				if ($ne($1.cset, "seta") && $ne($1.cset, "setb")) { /*17068*/
					$k[$j++] = $1.la; /*17066*/
					$k[$j++] = $1[$1.cset]; /*17066*/
					$1.enc(); /*17066*/
					$1.cset = "seta"; /*17067*/
				} /*17067*/
				break; /*17069*/
			} /*17069*/
			for (;;) { /*17183*/
				if ($get($1.nseq, $1.i) >= 9) { /*17081*/
					$k[$j++] = ~~$z($geti($1.msg, $1.i, 9)); /*17075*/
					for (var _3Y = 0, _3Z = 4; _3Y < _3Z; _3Y++) { /*17075*/
						var _3a = $k[--$j]; /*17075*/
						$k[$j++] = _3a & 63; /*17075*/
						$k[$j++] = _3a >>> 6; /*17075*/
					} /*17075*/
					$k[$j++] = $get($1[$1.cset], $1.ns); /*17076*/
					for (var _3f = 0; _3f <= 10; _3f += 2) { /*17076*/
						var _3g = $k[$j - 1 - _3f]; /*17076*/
						$k[$j++] = _3g; /*17076*/
					} /*17076*/
					$astore($a(6)); /*17076*/
					var _3i = $k[--$j]; /*17076*/
					var _3j = $k[--$j]; /*17076*/
					var _3k = $k[--$j]; /*17076*/
					var _3l = $k[--$j]; /*17076*/
					var _3m = $k[--$j]; /*17076*/
					var _3n = $k[--$j]; /*17076*/
					var _3o = $k[--$j]; /*17076*/
					$k[$j++] = _3i; /*17076*/
					$k[$j++] = _3o; /*17076*/
					$k[$j++] = _3n; /*17076*/
					$k[$j++] = _3m; /*17076*/
					$k[$j++] = _3l; /*17076*/
					$k[$j++] = _3k; /*17076*/
					$k[$j++] = _3j; /*17076*/
					for (var _3p = 0, _3q = 6; _3p < _3q; _3p++) { /*17076*/
						$j--; /*17076*/
					} /*17076*/
					$puti($1.out, $1.j, $k[--$j]); /*17077*/
					$1.i = $1.i + 9; /*17078*/
					$1.j = $1.j + 6; /*17079*/
					break; /*17080*/
				} /*17080*/
				$1.char1 = $get($1.msg, $1.i); /*17084*/
				$k[$j++] = "char2"; /*17085*/
				if (($1.i + 1) < $1.msglen) { /*17085*/
					$k[$j++] = $get($1.msg, $1.i + 1); /*17085*/
				} else { /*17085*/
					$k[$j++] = -99; /*17085*/
				} /*17085*/
				var _44 = $k[--$j]; /*17085*/
				$1[$k[--$j]] = _44; /*17085*/
				$k[$j++] = "char3"; /*17086*/
				if (($1.i + 2) < $1.msglen) { /*17086*/
					$k[$j++] = $get($1.msg, $1.i + 2); /*17086*/
				} else { /*17086*/
					$k[$j++] = -99; /*17086*/
				} /*17086*/
				var _4B = $k[--$j]; /*17086*/
				$1[$k[--$j]] = _4B; /*17086*/
				var _4G = $get($1[$1.cset], $1.char1) !== undefined; /*17089*/
				if (_4G) { /*17093*/
					$k[$j++] = $1.char1; /*17090*/
					$k[$j++] = $1[$1.cset]; /*17090*/
					$1.enc(); /*17090*/
					$1.i = $1.i + 1; /*17091*/
					break; /*17092*/
				} /*17092*/
				var _4O = $get($1.setb, $1.char1) !== undefined; /*17096*/
				if ($eq($1.cset, "seta") && _4O) { /*17106*/
					var _4R = $get($1.setb, $1.char2) !== undefined; /*17097*/
					if (_4R) { /*17103*/
						$k[$j++] = $1.lb; /*17098*/
						$k[$j++] = $1.seta; /*17098*/
						$1.enc(); /*17098*/
						$1.cset = "setb"; /*17099*/
					} else { /*17103*/
						$k[$j++] = $1.sb; /*17101*/
						$k[$j++] = $1.seta; /*17101*/
						$1.enc(); /*17101*/
						$k[$j++] = $1.char1; /*17102*/
						$k[$j++] = $1.setb; /*17102*/
						$1.enc(); /*17102*/
						$1.i = $1.i + 1; /*17103*/
					} /*17103*/
					break; /*17105*/
				} /*17105*/
				var _4c = $get($1.seta, $1.char1) !== undefined; /*17109*/
				if ($eq($1.cset, "setb") && _4c) { /*17134*/
					var _4d = $1.seta; /*17110*/
					var _4e = $1.msg; /*17110*/
					var _4f = $1.i; /*17110*/
					var _4g = $1.msglen; /*17110*/
					var _4h = $1.i; /*17110*/
					var _4i = _4g - _4h; /*17110*/
					var _4j = 4; /*17110*/
					if (4 > (_4g - _4h)) { /*17110*/
						var _ = _4i; /*17110*/
						_4i = _4j; /*17110*/
						_4j = _; /*17110*/
					} /*17110*/
					$k[$j++] = "p"; /*17110*/
					$k[$j++] = _4d; /*17110*/
					$k[$j++] = $geti(_4e, _4f, _4j); /*17110*/
					$1.prefixinset(); /*17110*/
					var _4l = $k[--$j]; /*17110*/
					$1[$k[--$j]] = _4l; /*17110*/
					if ($1.p == 1) { /*17115*/
						$k[$j++] = $1.sa; /*17112*/
						$k[$j++] = $1.setb; /*17112*/
						$1.enc(); /*17112*/
						$k[$j++] = $1.char1; /*17113*/
						$k[$j++] = $1.seta; /*17113*/
						$1.enc(); /*17113*/
						$1.i = $1.i + 1; /*17114*/
					} /*17114*/
					if ($1.p == 2) { /*17121*/
						$k[$j++] = $1.sa2; /*17117*/
						$k[$j++] = $1.setb; /*17117*/
						$1.enc(); /*17117*/
						$k[$j++] = $1.char1; /*17118*/
						$k[$j++] = $1.seta; /*17118*/
						$1.enc(); /*17118*/
						$k[$j++] = $1.char2; /*17119*/
						$k[$j++] = $1.seta; /*17119*/
						$1.enc(); /*17119*/
						$1.i = $1.i + 2; /*17120*/
					} /*17120*/
					if ($1.p == 3) { /*17128*/
						$k[$j++] = $1.sa3; /*17123*/
						$k[$j++] = $1.setb; /*17123*/
						$1.enc(); /*17123*/
						$k[$j++] = $1.char1; /*17124*/
						$k[$j++] = $1.seta; /*17124*/
						$1.enc(); /*17124*/
						$k[$j++] = $1.char2; /*17125*/
						$k[$j++] = $1.seta; /*17125*/
						$1.enc(); /*17125*/
						$k[$j++] = $1.char3; /*17126*/
						$k[$j++] = $1.seta; /*17126*/
						$1.enc(); /*17126*/
						$1.i = $1.i + 3; /*17127*/
					} /*17127*/
					if ($1.p >= 4) { /*17132*/
						$k[$j++] = $1.la; /*17130*/
						$k[$j++] = $1.setb; /*17130*/
						$1.enc(); /*17130*/
						$1.cset = "seta"; /*17131*/
					} /*17131*/
					break; /*17133*/
				} /*17133*/
				var _5G = $get($1.seta, $1.char1) !== undefined; /*17137*/
				if (_5G) { /*17141*/
					$k[$j++] = $1.la; /*17138*/
					$k[$j++] = $1[$1.cset]; /*17138*/
					$1.enc(); /*17138*/
					$1.cset = "seta"; /*17139*/
					break; /*17140*/
				} /*17140*/
				var _5M = $get($1.setb, $1.char1) !== undefined; /*17142*/
				if (_5M) { /*17146*/
					$k[$j++] = $1.lb; /*17143*/
					$k[$j++] = $1[$1.cset]; /*17143*/
					$1.enc(); /*17143*/
					$1.cset = "setb"; /*17144*/
					break; /*17145*/
				} /*17145*/
				var _5S = $get($1.setc, $1.char1) !== undefined; /*17149*/
				if (_5S) { /*17149*/
					$1.setx = "setc"; /*17149*/
					$1.sx = $1.sc; /*17149*/
					$1.lkx = $1.lkc; /*17149*/
				} /*17149*/
				var _5X = $get($1.setd, $1.char1) !== undefined; /*17150*/
				if (_5X) { /*17150*/
					$1.setx = "setd"; /*17150*/
					$1.sx = $1.sd; /*17150*/
					$1.lkx = $1.lkd; /*17150*/
				} /*17150*/
				var _5c = $get($1.sete, $1.char1) !== undefined; /*17151*/
				if (_5c) { /*17151*/
					$1.setx = "sete"; /*17151*/
					$1.sx = $1.se; /*17151*/
					$1.lkx = $1.lke; /*17151*/
				} /*17151*/
				var _5g = $1[$1.setx]; /*17154*/
				var _5h = $1.msg; /*17154*/
				var _5i = $1.i; /*17154*/
				var _5j = $1.msglen; /*17154*/
				var _5k = $1.i; /*17154*/
				var _5l = _5j - _5k; /*17154*/
				var _5m = 4; /*17154*/
				if (4 > (_5j - _5k)) { /*17154*/
					var _ = _5l; /*17154*/
					_5l = _5m; /*17154*/
					_5m = _; /*17154*/
				} /*17154*/
				$k[$j++] = "p"; /*17154*/
				$k[$j++] = _5g; /*17154*/
				$k[$j++] = $geti(_5h, _5i, _5m); /*17154*/
				$1.prefixinset(); /*17154*/
				var _5o = $k[--$j]; /*17154*/
				$1[$k[--$j]] = _5o; /*17154*/
				if ($1.p == 1) { /*17159*/
					$k[$j++] = $1.sx; /*17156*/
					$k[$j++] = $1[$1.cset]; /*17156*/
					$1.enc(); /*17156*/
					$k[$j++] = $1.char1; /*17157*/
					$k[$j++] = $1[$1.setx]; /*17157*/
					$1.enc(); /*17157*/
					$1.i = $1.i + 1; /*17158*/
				} /*17158*/
				if ($1.p == 2) { /*17166*/
					$k[$j++] = $1.sx; /*17161*/
					$k[$j++] = $1[$1.cset]; /*17161*/
					$1.enc(); /*17161*/
					$k[$j++] = $1.char1; /*17162*/
					$k[$j++] = $1[$1.setx]; /*17162*/
					$1.enc(); /*17162*/
					$k[$j++] = $1.sx; /*17163*/
					$k[$j++] = $1[$1.cset]; /*17163*/
					$1.enc(); /*17163*/
					$k[$j++] = $1.char2; /*17164*/
					$k[$j++] = $1[$1.setx]; /*17164*/
					$1.enc(); /*17164*/
					$1.i = $1.i + 2; /*17165*/
				} /*17165*/
				if ($1.p == 3) { /*17175*/
					$k[$j++] = $1.sx; /*17168*/
					$k[$j++] = $1[$1.cset]; /*17168*/
					$1.enc(); /*17168*/
					$k[$j++] = $1.char1; /*17169*/
					$k[$j++] = $1[$1.setx]; /*17169*/
					$1.enc(); /*17169*/
					$k[$j++] = $1.sx; /*17170*/
					$k[$j++] = $1[$1.cset]; /*17170*/
					$1.enc(); /*17170*/
					$k[$j++] = $1.char2; /*17171*/
					$k[$j++] = $1[$1.setx]; /*17171*/
					$1.enc(); /*17171*/
					$k[$j++] = $1.sx; /*17172*/
					$k[$j++] = $1[$1.cset]; /*17172*/
					$1.enc(); /*17172*/
					$k[$j++] = $1.char3; /*17173*/
					$k[$j++] = $1[$1.setx]; /*17173*/
					$1.enc(); /*17173*/
					$1.i = $1.i + 3; /*17174*/
				} /*17174*/
				if ($1.p >= 4) { /*17180*/
					$k[$j++] = $1.sx; /*17177*/
					$k[$j++] = $1[$1.cset]; /*17177*/
					$1.enc(); /*17177*/
					$k[$j++] = $1.lkx; /*17178*/
					$k[$j++] = $1[$1.setx]; /*17178*/
					$1.enc(); /*17178*/
					$1.cset = $1.setx; /*17179*/
				} /*17179*/
				break; /*17182*/
			} /*17182*/
		} /*17182*/
		$1.encmsg = $geti($1.out, 0, $1.j); /*17185*/
		$1.padval = $get($1[$1.cset], $1.pad); /*17186*/
		$1.sami = $a([]); /*17189*/
		if ($1.sam != -1) { /*17194*/
			$1.sami = $a(2); /*17191*/
			$put($1.sami, 0, $get($1.seta, $1.pad)); /*17192*/
			$put($1.sami, 1, (((~~($1.sam / 10)) - 1) * 8) + (($1.sam % 10) - 1)); /*17193*/
		} /*17193*/
		$k[$j++] = "encmsg"; /*17195*/
		$k[$j++] = Infinity; /*17195*/
		$aload($1.sami); /*17195*/
		$aload($1.encmsg); /*17195*/
		var _6x = $a(); /*17195*/
		$1[$k[--$j]] = _6x; /*17195*/
		if (($1.mode == 2) || ($1.mode == 3)) { /*17250*/
			var _72 = $strcpy($s(4), "0000"); /*17201*/
			var _75 = $cvrs($s(4), ~~$1.mode, 2); /*17201*/
			$puti(_72, 4 - _75.length, _75); /*17201*/
			$1.mdb = _72; /*17201*/
			var _77 = $strcpy($s(10), "0000000000"); /*17202*/
			var _7A = $cvrs($s(10), ~~$z($1.ccode), 2); /*17202*/
			$puti(_77, 10 - _7A.length, _7A); /*17202*/
			$1.ccb = _77; /*17202*/
			var _7C = $strcpy($s(10), "0000000000"); /*17203*/
			var _7F = $cvrs($s(10), ~~$z($1.scode), 2); /*17203*/
			$puti(_7C, 10 - _7F.length, _7F); /*17203*/
			$1.scb = _7C; /*17203*/
			$1.pcb = $strcpy($s(36), "000000000000000000000000000000000000"); /*17204*/
			if ($1.mode == 2) { /*17217*/
				var _7M = $cvrs($s(6), $1.pcode.length, 2); /*17207*/
				$puti($1.pcb, 6 - _7M.length, _7M); /*17207*/
				var _7Q = $cvrs($s(30), ~~$z($1.pcode), 2); /*17208*/
				$puti($1.pcb, 36 - _7Q.length, _7Q); /*17208*/
			} else { /*17217*/
				$k[$j++] = "pccw"; /*17213*/
				$k[$j++] = Infinity; /*17213*/
				var _7S = $strcpy($s(6), "      "); /*17212*/
				$k[$j++] = _7S; /*17212*/
				$k[$j++] = _7S; /*17212*/
				$k[$j++] = 0; /*17212*/
				if ($1.pcode.length > 6) { /*17212*/
					$k[$j++] = $geti($1.pcode, 0, 6); /*17212*/
				} else { /*17212*/
					$k[$j++] = $1.pcode; /*17212*/
				} /*17212*/
				var _7X = $k[--$j]; /*17212*/
				var _7Y = $k[--$j]; /*17212*/
				$puti($k[--$j], _7Y, _7X); /*17212*/
				$forall($k[--$j], function() { /*17213*/
					var _7d = $get($1.seta, $k[--$j]); /*17213*/
					$k[$j++] = _7d; /*17213*/
				}) /*17213*/
				var _7e = $a(); /*17213*/
				$1[$k[--$j]] = _7e; /*17214*/
				for (var _7g = 0; _7g <= 5; _7g += 1) { /*17218*/
					$1.i = _7g; /*17216*/
					var _7m = $cvrs($s(6), $get($1.pccw, $1.i), 2); /*17217*/
					$puti($1.pcb, ((6 * $1.i) + 6) - _7m.length, _7m); /*17217*/
				} /*17217*/
			} /*17217*/
			$1.scm = $s(60); /*17222*/
			$puti($1.scm, 2, $1.mdb); /*17223*/
			$puti($1.scm, 38, $geti($1.pcb, 0, 4)); /*17224*/
			$puti($1.scm, 30, $geti($1.pcb, 4, 6)); /*17225*/
			$puti($1.scm, 24, $geti($1.pcb, 10, 6)); /*17226*/
			$puti($1.scm, 18, $geti($1.pcb, 16, 6)); /*17227*/
			$puti($1.scm, 12, $geti($1.pcb, 22, 6)); /*17228*/
			$puti($1.scm, 6, $geti($1.pcb, 28, 6)); /*17229*/
			$puti($1.scm, 0, $geti($1.pcb, 34, 2)); /*17230*/
			$puti($1.scm, 52, $geti($1.ccb, 0, 2)); /*17231*/
			$puti($1.scm, 42, $geti($1.ccb, 2, 6)); /*17232*/
			$puti($1.scm, 36, $geti($1.ccb, 8, 2)); /*17233*/
			$puti($1.scm, 54, $geti($1.scb, 0, 6)); /*17234*/
			$puti($1.scm, 48, $geti($1.scb, 6, 4)); /*17235*/
			$1.pri = $a([0, 0, 0, 0, 0, 0, 0, 0, 0, 0]); /*17238*/
			for (var _8S = 0; _8S <= 59; _8S += 1) { /*17244*/
				$1.i = _8S; /*17240*/
				$1.ps = ~~($1.i / 6); /*17241*/
				$1.ep = (~~(Math.pow(2, 5 - ($1.i % 6)))) * ($get($1.scm, $1.i) - 48); /*17242*/
				$put($1.pri, $1.ps, $get($1.pri, $1.ps) + $1.ep); /*17243*/
			} /*17243*/
			$k[$j++] = "sec"; /*17247*/
			$k[$j++] = Infinity; /*17247*/
			for (var _8e = 0, _8f = 84; _8e < _8f; _8e++) { /*17247*/
				$k[$j++] = $1.padval; /*17247*/
			} /*17247*/
			var _8h = $a(); /*17247*/
			$1[$k[--$j]] = _8h; /*17247*/
			$puti($1.sec, 0, $1.encmsg); /*17248*/
		} /*17248*/
		if (((($1.mode == 4) || ($1.mode == 5)) || ($1.mode == 6)) || ($1.mode == -1)) { /*17269*/
			if ($1.mode == -1) { /*17258*/
				var _8r = ($1.encmsg.length <= 77) ? 5 : 4; /*17257*/
				$1.mode = _8r; /*17257*/
			} /*17257*/
			$k[$j++] = "cws"; /*17261*/
			$k[$j++] = Infinity; /*17261*/
			var _8t = ($1.mode == 5) ? 78 : 94; /*17261*/
			for (var _8u = 0, _8v = _8t; _8u < _8v; _8u++) { /*17261*/
				$k[$j++] = $1.padval; /*17261*/
			} /*17261*/
			var _8x = $a(); /*17261*/
			$1[$k[--$j]] = _8x; /*17261*/
			$put($1.cws, 0, $1.mode); /*17262*/
			$puti($1.cws, 1, $1.encmsg); /*17263*/
			$1.pri = $geti($1.cws, 0, 10); /*17266*/
			$1.sec = $geti($1.cws, 10, $1.cws.length - 10); /*17267*/
		} /*17267*/
		$k[$j++] = "rsalog"; /*17272*/
		$k[$j++] = Infinity; /*17272*/
		$k[$j++] = 1; /*17272*/
		for (var _98 = 0, _99 = 63; _98 < _99; _98++) { /*17272*/
			var _9A = $k[--$j]; /*17272*/
			var _9B = _9A * 2; /*17272*/
			$k[$j++] = _9A; /*17272*/
			$k[$j++] = _9B; /*17272*/
			if (_9B >= 64) { /*17272*/
				var _9C = $k[--$j]; /*17272*/
				$k[$j++] = _9C ^ 67; /*17272*/
			} /*17272*/
		} /*17272*/
		var _9D = $a(); /*17272*/
		$1[$k[--$j]] = _9D; /*17272*/
		$1.rslog = $a(64); /*17273*/
		for (var _9G = 1; _9G <= 63; _9G += 1) { /*17274*/
			$put($1.rslog, $get($1.rsalog, _9G), _9G); /*17274*/
		} /*17274*/
		$1.rsprod = function() {
			var _9K = $k[--$j]; /*17278*/
			var _9L = $k[--$j]; /*17278*/
			$k[$j++] = _9L; /*17282*/
			$k[$j++] = _9K; /*17282*/
			if ((_9K != 0) && (_9L != 0)) { /*17281*/
				var _9O = $get($1.rslog, $k[--$j]); /*17279*/
				var _9T = $get($1.rsalog, (_9O + $get($1.rslog, $k[--$j])) % 63); /*17279*/
				$k[$j++] = _9T; /*17279*/
			} else { /*17281*/
				$j -= 2; /*17281*/
				$k[$j++] = 0; /*17281*/
			} /*17281*/
		}; /*17283*/
		$1.rscodes = function() {
			$1.rsnum = $k[--$j]; /*17288*/
			$1.cwb = $k[--$j]; /*17289*/
			$k[$j++] = "coeffs"; /*17292*/
			$k[$j++] = Infinity; /*17292*/
			$k[$j++] = 1; /*17292*/
			for (var _9X = 0, _9Y = $1.rsnum; _9X < _9Y; _9X++) { /*17292*/
				$k[$j++] = 0; /*17292*/
			} /*17292*/
			var _9Z = $a(); /*17292*/
			$1[$k[--$j]] = _9Z; /*17292*/
			for (var _9d = 1, _9c = $1.rsnum; _9d <= _9c; _9d += 1) { /*17301*/
				$1.i = _9d; /*17294*/
				$put($1.coeffs, $1.i, $get($1.coeffs, $1.i - 1)); /*17295*/
				for (var _9k = $1.i - 1; _9k >= 1; _9k -= 1) { /*17299*/
					$1.j = _9k; /*17297*/
					$k[$j++] = $1.coeffs; /*17298*/
					$k[$j++] = $1.j; /*17298*/
					$k[$j++] = $get($1.coeffs, $1.j - 1); /*17298*/
					$k[$j++] = $get($1.coeffs, $1.j); /*17298*/
					$k[$j++] = $get($1.rsalog, $1.i); /*17298*/
					$1.rsprod(); /*17298*/
					var _9w = $k[--$j]; /*17298*/
					var _9x = $k[--$j]; /*17298*/
					var _9y = $k[--$j]; /*17298*/
					$put($k[--$j], _9y, $xo(_9x, _9w)); /*17298*/
				} /*17298*/
				$k[$j++] = $1.coeffs; /*17300*/
				$k[$j++] = 0; /*17300*/
				$k[$j++] = $get($1.coeffs, 0); /*17300*/
				$k[$j++] = $get($1.rsalog, $1.i); /*17300*/
				$1.rsprod(); /*17300*/
				var _A6 = $k[--$j]; /*17300*/
				var _A7 = $k[--$j]; /*17300*/
				$put($k[--$j], _A7, _A6); /*17300*/
			} /*17300*/
			$1.coeffs = $geti($1.coeffs, 0, $1.coeffs.length - 1); /*17302*/
			$k[$j++] = "ecb"; /*17305*/
			$k[$j++] = Infinity; /*17305*/
			for (var _AD = 0, _AE = $1.rsnum; _AD < _AE; _AD++) { /*17305*/
				$k[$j++] = 0; /*17305*/
			} /*17305*/
			var _AF = $a(); /*17305*/
			$1[$k[--$j]] = _AF; /*17305*/
			for (var _AJ = 0, _AI = $1.cwb.length - 1; _AJ <= _AI; _AJ += 1) { /*17314*/
				$1.t = $xo($get($1.cwb, _AJ), $get($1.ecb, 0)); /*17307*/
				for (var _AP = $1.ecb.length - 1; _AP >= 0; _AP -= 1) { /*17313*/
					$1.i = _AP; /*17309*/
					$1.p = ($1.ecb.length - $1.i) - 1; /*17310*/
					$k[$j++] = $1.ecb; /*17311*/
					$k[$j++] = $1.p; /*17311*/
					$k[$j++] = $1.t; /*17311*/
					$k[$j++] = $get($1.coeffs, $1.i); /*17311*/
					$1.rsprod(); /*17311*/
					var _AY = $k[--$j]; /*17311*/
					var _AZ = $k[--$j]; /*17311*/
					$put($k[--$j], _AZ, _AY); /*17311*/
					if ($1.i > 0) { /*17312*/
						$put($1.ecb, $1.p, $xo($get($1.ecb, $1.p + 1), $get($1.ecb, $1.p))); /*17312*/
					} /*17312*/
				} /*17312*/
			} /*17312*/
			$k[$j++] = $1.ecb; /*17316*/
		}; /*17318*/
		$k[$j++] = "seco"; /*17321*/
		$k[$j++] = Infinity; /*17321*/
		for (var _An = 0, _Am = $1.sec.length - 1; _An <= _Am; _An += 2) { /*17321*/
			$k[$j++] = $get($1.sec, _An); /*17321*/
		} /*17321*/
		var _Aq = $a(); /*17321*/
		$1[$k[--$j]] = _Aq; /*17321*/
		$k[$j++] = "sece"; /*17322*/
		$k[$j++] = Infinity; /*17322*/
		for (var _Au = 1, _At = $1.sec.length - 1; _Au <= _At; _Au += 2) { /*17322*/
			$k[$j++] = $get($1.sec, _Au); /*17322*/
		} /*17322*/
		var _Ax = $a(); /*17322*/
		$1[$k[--$j]] = _Ax; /*17322*/
		var _B0 = ($1.sec.length == 84) ? 20 : 28; /*17325*/
		$1.scodes = _B0; /*17325*/
		$k[$j++] = "secochk"; /*17326*/
		$k[$j++] = $1.seco; /*17326*/
		$k[$j++] = $1.scodes; /*17326*/
		$1.rscodes(); /*17326*/
		var _B3 = $k[--$j]; /*17326*/
		$1[$k[--$j]] = _B3; /*17326*/
		$k[$j++] = "secechk"; /*17327*/
		$k[$j++] = $1.sece; /*17327*/
		$k[$j++] = $1.scodes; /*17327*/
		$1.rscodes(); /*17327*/
		var _B7 = $k[--$j]; /*17327*/
		$1[$k[--$j]] = _B7; /*17327*/
		$k[$j++] = "secchk"; /*17330*/
		$k[$j++] = Infinity; /*17330*/
		for (var _BB = 0, _BA = $1.scodes - 1; _BB <= _BA; _BB += 1) { /*17330*/
			$k[$j++] = $get($1.secochk, _BB); /*17330*/
			$k[$j++] = $get($1.secechk, _BB); /*17330*/
		} /*17330*/
		var _BG = $a(); /*17330*/
		$1[$k[--$j]] = _BG; /*17330*/
		$k[$j++] = "codewords"; /*17337*/
		$k[$j++] = Infinity; /*17337*/
		$aload($1.pri); /*17334*/
		$k[$j++] = $1.pri; /*17335*/
		$k[$j++] = 10; /*17335*/
		$1.rscodes(); /*17335*/
		$aload($k[--$j]); /*17335*/
		$aload($1.sec); /*17336*/
		$aload($1.secchk); /*17337*/
		var _BN = $a(); /*17337*/
		$1[$k[--$j]] = _BN; /*17338*/
		$k[$j++] = "mods"; /*17341*/
		$k[$j++] = Infinity; /*17341*/
		for (var _BP = 0, _BQ = 864; _BP < _BQ; _BP++) { /*17341*/
			$k[$j++] = 0; /*17341*/
		} /*17341*/
		var _BR = $a(); /*17341*/
		$1[$k[--$j]] = _BR; /*17341*/
		for (var _BT = 0; _BT <= 143; _BT += 1) { /*17346*/
			$1.i = _BT; /*17343*/
			$k[$j++] = "cw"; /*17344*/
			$k[$j++] = Infinity; /*17344*/
			var _BY = $cvrs($s(6), $get($1.codewords, $1.i), 2); /*17344*/
			for (var _BZ = 0, _Ba = _BY.length; _BZ < _Ba; _BZ++) { /*17344*/
				$k[$j++] = $get(_BY, _BZ) - 48; /*17344*/
			} /*17344*/
			var _Bc = $a(); /*17344*/
			$1[$k[--$j]] = _Bc; /*17344*/
			$puti($1.mods, (6 * $1.i) + (6 - $1.cw.length), $1.cw); /*17345*/
		} /*17345*/
		$1.modmap = $a([469, 529, 286, 316, 347, 346, 673, 672, 703, 702, 647, 676, 283, 282, 313, 312, 370, 610, 618, 379, 378, 409, 408, 439, 705, 704, 559, 589, 588, 619, 458, 518, 640, 701, 675, 674, 285, 284, 315, 314, 310, 340, 531, 289, 288, 319, 349, 348, 456, 486, 517, 516, 471, 470, 369, 368, 399, 398, 429, 428, 549, 548, 579, 578, 609, 608, 649, 648, 679, 678, 709, 708, 639, 638, 669, 668, 699, 698, 279, 278, 309, 308, 339, 338, 381, 380, 411, 410, 441, 440, 561, 560, 591, 590, 621, 620, 547, 546, 577, 576, 607, 606, 367, 366, 397, 396, 427, 426, 291, 290, 321, 320, 351, 350, 651, 650, 681, 680, 711, 710, 1, 0, 31, 30, 61, 60, 3, 2, 33, 32, 63, 62, 5, 4, 35, 34, 65, 64, 7, 6, 37, 36, 67, 66, 9, 8, 39, 38, 69, 68, 11, 10, 41, 40, 71, 70, 13, 12, 43, 42, 73, 72, 15, 14, 45, 44, 75, 74, 17, 16, 47, 46, 77, 76, 19, 18, 49, 48, 79, 78, 21, 20, 51, 50, 81, 80, 23, 22, 53, 52, 83, 82, 25, 24, 55, 54, 85, 84, 27, 26, 57, 56, 87, 86, 117, 116, 147, 146, 177, 176, 115, 114, 145, 144, 175, 174, 113, 112, 143, 142, 173, 172, 111, 110, 141, 140, 171, 170, 109, 108, 139, 138, 169, 168, 107, 106, 137, 136, 167, 166, 105, 104, 135, 134, 165, 164, 103, 102, 133, 132, 163, 162, 101, 100, 131, 130, 161, 160, 99, 98, 129, 128, 159, 158, 97, 96, 127, 126, 157, 156, 95, 94, 125, 124, 155, 154, 93, 92, 123, 122, 153, 152, 91, 90, 121, 120, 151, 150, 181, 180, 211, 210, 241, 240, 183, 182, 213, 212, 243, 242, 185, 184, 215, 214, 245, 244, 187, 186, 217, 216, 247, 246, 189, 188, 219, 218, 249, 248, 191, 190, 221, 220, 251, 250, 193, 192, 223, 222, 253, 252, 195, 194, 225, 224, 255, 254, 197, 196, 227, 226, 257, 256, 199, 198, 229, 228, 259, 258, 201, 200, 231, 230, 261, 260, 203, 202, 233, 232, 263, 262, 205, 204, 235, 234, 265, 264, 207, 206, 237, 236, 267, 266, 297, 296, 327, 326, 357, 356, 295, 294, 325, 324, 355, 354, 293, 292, 323, 322, 353, 352, 277, 276, 307, 306, 337, 336, 275, 274, 305, 304, 335, 334, 273, 272, 303, 302, 333, 332, 271, 270, 301, 300, 331, 330, 361, 360, 391, 390, 421, 420, 363, 362, 393, 392, 423, 422, 365, 364, 395, 394, 425, 424, 383, 382, 413, 412, 443, 442, 385, 384, 415, 414, 445, 444, 387, 386, 417, 416, 447, 446, 477, 476, 507, 506, 537, 536, 475, 474, 505, 504, 535, 534, 473, 472, 503, 502, 533, 532, 455, 454, 485, 484, 515, 514, 453, 452, 483, 482, 513, 512, 451, 450, 481, 480, 511, 510, 541, 540, 571, 570, 601, 600, 543, 542, 573, 572, 603, 602, 545, 544, 575, 574, 605, 604, 563, 562, 593, 592, 623, 622, 565, 564, 595, 594, 625, 624, 567, 566, 597, 596, 627, 626, 657, 656, 687, 686, 717, 716, 655, 654, 685, 684, 715, 714, 653, 652, 683, 682, 713, 712, 637, 636, 667, 666, 697, 696, 635, 634, 665, 664, 695, 694, 633, 632, 663, 662, 693, 692, 631, 630, 661, 660, 691, 690, 721, 720, 751, 750, 781, 780, 723, 722, 753, 752, 783, 782, 725, 724, 755, 754, 785, 784, 727, 726, 757, 756, 787, 786, 729, 728, 759, 758, 789, 788, 731, 730, 761, 760, 791, 790, 733, 732, 763, 762, 793, 792, 735, 734, 765, 764, 795, 794, 737, 736, 767, 766, 797, 796, 739, 738, 769, 768, 799, 798, 741, 740, 771, 770, 801, 800, 743, 742, 773, 772, 803, 802, 745, 744, 775, 774, 805, 804, 747, 746, 777, 776, 807, 806, 837, 836, 867, 866, 897, 896, 835, 834, 865, 864, 895, 894, 833, 832, 863, 862, 893, 892, 831, 830, 861, 860, 891, 890, 829, 828, 859, 858, 889, 888, 827, 826, 857, 856, 887, 886, 825, 824, 855, 854, 885, 884, 823, 822, 853, 852, 883, 882, 821, 820, 851, 850, 881, 880, 819, 818, 849, 848, 879, 878, 817, 816, 847, 846, 877, 876, 815, 814, 845, 844, 875, 874, 813, 812, 843, 842, 873, 872, 811, 810, 841, 840, 871, 870, 901, 900, 931, 930, 961, 960, 903, 902, 933, 932, 963, 962, 905, 904, 935, 934, 965, 964, 907, 906, 937, 936, 967, 966, 909, 908, 939, 938, 969, 968, 911, 910, 941, 940, 971, 970, 913, 912, 943, 942, 973, 972, 915, 914, 945, 944, 975, 974, 917, 916, 947, 946, 977, 976, 919, 918, 949, 948, 979, 978, 921, 920, 951, 950, 981, 980, 923, 922, 953, 952, 983, 982, 925, 924, 955, 954, 985, 984, 927, 926, 957, 956, 987, 986, 58, 89, 88, 118, 149, 148, 178, 209, 208, 238, 269, 268, 298, 329, 328, 358, 389, 388, 418, 449, 448, 478, 509, 508, 538, 569, 568, 598, 629, 628, 658, 689, 688, 718, 749, 748, 778, 809, 808, 838, 869, 868, 898, 929, 928, 958, 989, 988]); /*17394*/
		$1.pixs = $a(864); /*17397*/
		$1.j = 0; /*17398*/
		for (var _Bm = 0, _Bl = $1.mods.length - 1; _Bm <= _Bl; _Bm += 1) { /*17405*/
			$1.i = _Bm; /*17400*/
			if ($get($1.mods, $1.i) == 1) { /*17404*/
				$put($1.pixs, $1.j, $get($1.modmap, $1.i)); /*17402*/
				$1.j = $1.j + 1; /*17403*/
			} /*17403*/
		} /*17403*/
		$k[$j++] = "pixs"; /*17406*/
		$k[$j++] = Infinity; /*17406*/
		$forall($geti($1.pixs, 0, $1.j)); /*17406*/
		$k[$j++] = 28; /*17406*/
		$k[$j++] = 29; /*17406*/
		$k[$j++] = 280; /*17406*/
		$k[$j++] = 281; /*17406*/
		$k[$j++] = 311; /*17406*/
		$k[$j++] = 457; /*17406*/
		$k[$j++] = 488; /*17406*/
		$k[$j++] = 500; /*17406*/
		$k[$j++] = 530; /*17406*/
		$k[$j++] = 670; /*17406*/
		$k[$j++] = 700; /*17406*/
		$k[$j++] = 677; /*17406*/
		$k[$j++] = 707; /*17406*/
		var _Bz = $a(); /*17406*/
		$1[$k[--$j]] = _Bz; /*17406*/
		var _C3 = {
			ren: $0.renmaximatrix,
			pixs: $1.pixs,
			opt: $1.options
		}; /*17412*/
		$k[$j++] = _C3; /*17415*/
		if (!$1.dontdraw) { /*17415*/
			$0.renmaximatrix(); /*17415*/
		} /*17415*/
	};
	$0.azteccode = function() {
		var $1 = {}; /*17442*/
		$1.options = $k[--$j]; /*17444*/
		$1.barcode = $k[--$j]; /*17445*/
		$1.dontdraw = false; /*17447*/
		$1.format = "unset"; /*17448*/
		$1.readerinit = false; /*17449*/
		$1.layers = -1; /*17450*/
		$1.eclevel = 23; /*17451*/
		$1.ecaddchars = 3; /*17452*/
		$1.raw = false; /*17453*/
		$1.parse = false; /*17454*/
		$forall($1.options, function() { /*17465*/
			var _3 = $k[--$j]; /*17465*/
			$1[$k[--$j]] = _3; /*17465*/
		}) /*17465*/
		$1.layers = ~~$1.layers; /*17467*/
		$1.eclevel = +$1.eclevel; /*17468*/
		$1.ecaddchars = ~~$1.ecaddchars; /*17469*/
		$1.msgbits = ""; /*17493*/
		if ($ne($1.format, "rune") && $1.raw) { /*17494*/
			$1.msgbits = $1.barcode; /*17494*/
		} /*17494*/
		if ($ne($1.format, "rune") && (!$1.raw)) { /*17791*/
			$1.U = 0; /*17498*/
			$1.L = 1; /*17498*/
			$1.M = 2; /*17498*/
			$1.P = 3; /*17498*/
			$1.D = 4; /*17498*/
			$1.B = 5; /*17498*/
			$1.lu = -1; /*17501*/
			$1.ll = -2; /*17501*/
			$1.lm = -3; /*17501*/
			$1.lp = -4; /*17502*/
			$1.ld = -5; /*17502*/
			$1.su = -6; /*17502*/
			$1.sp = -7; /*17503*/
			$1.sb = -8; /*17503*/
			$1.fl = -9; /*17503*/
			$1.p2 = -10; /*17504*/
			$1.p3 = -11; /*17504*/
			$1.p4 = -12; /*17504*/
			$1.p5 = -13; /*17504*/
			$1.charmaps = $a([$a([$1.sp, $1.sp, $1.sp, $1.fl, $1.sp]), $a([32, 32, 32, 13, 32]), $a(["A", "a", 1, $1.p2, "0"]), $a(["B", "b", 2, $1.p3, "1"]), $a(["C", "c", 3, $1.p4, "2"]), $a(["D", "d", 4, $1.p5, "3"]), $a(["E", "e", 5, "!", "4"]), $a(["F", "f", 6, "\"", "5"]), $a(["G", "g", 7, "#", "6"]), $a(["H", "h", 8, "$", "7"]), $a(["I", "i", 9, "%", "8"]), $a(["J", "j", 10, "&", "9"]), $a(["K", "k", 11, "'", ","]), $a(["L", "l", 12, 40, "."]), $a(["M", "m", 13, 41, $1.lu]), $a(["N", "n", 27, "*", $1.su]), $a(["O", "o", 28, "+", -99]), $a(["P", "p", 29, ",", -99]), $a(["Q", "q", 30, "-", -99]), $a(["R", "r", 31, ".", -99]), $a(["S", "s", "@", "/", -99]), $a(["T", "t", 92, ":", -99]), $a(["U", "u", "^", ";", -99]), $a(["V", "v", "_", "<", -99]), $a(["W", "w", "`", "=", -99]), $a(["X", "x", "|", ">", -99]), $a(["Y", "y", "~", "?", -99]), $a(["Z", "z", 127, "[", -99]), $a([$1.ll, $1.su, $1.ll, "]", -99]), $a([$1.lm, $1.lm, $1.lu, "{", -99]), $a([$1.ld, $1.ld, $1.lp, "}", -99]), $a([$1.sb, $1.sb, $1.sb, $1.lu, -99])]); /*17541*/
			$1.charvals = $a([{}, {}, {}, {}, {}]); /*17544*/
			for (var _1B = 0, _1A = $1.charmaps.length - 1; _1B <= _1A; _1B += 1) { /*17553*/
				$1.i = _1B; /*17546*/
				$1.encs = $get($1.charmaps, $1.i); /*17547*/
				for (var _1F = 0; _1F <= 4; _1F += 1) { /*17552*/
					$1.j = _1F; /*17549*/
					var _1I = $get($1.encs, $1.j); /*17550*/
					$k[$j++] = _1I; /*17550*/
					if ($eq($type(_1I), "stringtype")) { /*17550*/
						var _1L = $get($k[--$j], 0); /*17550*/
						$k[$j++] = _1L; /*17550*/
					} /*17550*/
					$put($get($1.charvals, $1.j), $k[--$j], $1.i); /*17551*/
				} /*17551*/
			} /*17551*/
			var _1V = {
				"\x0d\x0a": $1.p2,
				". ": $1.p3,
				", ": $1.p4,
				": ": $1.p5
			}; /*17560*/
			$1.pcomp = _1V; /*17561*/
			$1.e = 10000; /*17563*/
			$1.latlen = $a([$a([0, 5, 5, 10, 5, 10]), $a([9, 0, 5, 10, 5, 10]), $a([5, 5, 0, 5, 10, 10]), $a([5, 10, 10, 0, 10, 15]), $a([4, 9, 9, 14, 0, 14]), $a([0, 0, 0, 0, 0, 0])]); /*17573*/
			$1.latseq = $a([$a([$a([]), $a([$1.ll]), $a([$1.lm]), $a([$1.lm, $1.lp]), $a([$1.ld]), $a([$1.sb])]), $a([$a([$1.ld, $1.lu]), $a([]), $a([$1.lm]), $a([$1.lm, $1.lp]), $a([$1.ld]), $a([$1.sb])]), $a([$a([$1.lu]), $a([$1.ll]), $a([]), $a([$1.lp]), $a([$1.lu, $1.ld]), $a([$1.sb])]), $a([$a([$1.lu]), $a([$1.lu, $1.ll]), $a([$1.lu, $1.lm]), $a([]), $a([$1.lu, $1.ld]), $a([$1.lu, $1.sb])]), $a([$a([$1.lu]), $a([$1.lu, $1.ll]), $a([$1.lu, $1.lm]), $a([$1.lu, $1.lm, $1.lp]), $a([]), $a([$1.lu, $1.sb])]), $a([$a([$1.lu]), $a([$1.ll]), $a([$1.lm]), $a([]), $a([]), $a([])])]); /*17583*/
			$1.shftlen = $a([$a([$1.e, $1.e, $1.e, 5, $1.e]), $a([5, $1.e, $1.e, 5, $1.e]), $a([$1.e, $1.e, $1.e, 5, $1.e]), $a([$1.e, $1.e, $1.e, $1.e, $1.e]), $a([4, $1.e, $1.e, 4, $1.e])]); /*17592*/
			$1.charsize = $a([5, 5, 5, 5, 4, 8]); /*17595*/
			$1.curlen = $a([0, $1.e, $1.e, $1.e, $1.e, $1.e]); /*17598*/
			$1.curseq = $a([$a([]), $a([]), $a([]), $a([]), $a([]), $a([])]); /*17599*/
			$1.backto = $1.U; /*17601*/
			$1.lastchar = ""; /*17602*/
			$forall($1.barcode, function() { /*17698*/
				$1.char = $k[--$j]; /*17607*/
				for (;;) { /*17633*/
					$1.imp = false; /*17611*/
					var _3l = $a([$1.U, $1.L, $1.M, $1.P, $1.D, $1.B]); /*17612*/
					for (var _3m = 0, _3n = _3l.length; _3m < _3n; _3m++) { /*17631*/
						$1.x = $get(_3l, _3m); /*17613*/
						var _3v = $a([$1.U, $1.L, $1.M, $1.P, $1.D, $1.B]); /*17614*/
						for (var _3w = 0, _3x = _3v.length; _3w < _3x; _3w++) { /*17630*/
							$1.y = $get(_3v, _3w); /*17615*/
							if (($1.x != $1.B) || ($1.y == $1.backto)) { /*17629*/
								$1.cost = $get($1.curlen, $1.x) + $get($get($1.latlen, $1.x), $1.y); /*17617*/
								if ($1.cost < $get($1.curlen, $1.y)) { /*17628*/
									$put($1.curlen, $1.y, $1.cost); /*17619*/
									$k[$j++] = $1.curseq; /*17622*/
									$k[$j++] = $1.y; /*17622*/
									$k[$j++] = Infinity; /*17622*/
									$aload($get($1.curseq, $1.x)); /*17621*/
									$aload($get($get($1.latseq, $1.x), $1.y)); /*17622*/
									var _4S = $a(); /*17622*/
									var _4T = $k[--$j]; /*17623*/
									$put($k[--$j], _4T, _4S); /*17623*/
									if ($1.y == $1.B) { /*17626*/
										$k[$j++] = "backto"; /*17625*/
										if (($1.x == $1.P) || ($1.x == $1.D)) { /*17625*/
											$k[$j++] = $1.U; /*17625*/
										} else { /*17625*/
											$k[$j++] = $1.x; /*17625*/
										} /*17625*/
										var _4d = $k[--$j]; /*17625*/
										$1[$k[--$j]] = _4d; /*17625*/
									} /*17625*/
									$1.imp = true; /*17627*/
								} /*17627*/
							} /*17627*/
						} /*17627*/
					} /*17627*/
					if (!$1.imp) { /*17632*/
						break; /*17632*/
					} /*17632*/
				} /*17632*/
				$1.nxtlen = $a([$1.e, $1.e, $1.e, $1.e, $1.e, $1.e]); /*17636*/
				$1.nxtseq = $a(6); /*17637*/
				var _4u = $a([$1.U, $1.L, $1.M, $1.P, $1.D, $1.B]); /*17639*/
				for (var _4v = 0, _4w = _4u.length; _4v < _4w; _4v++) { /*17674*/
					$1.x = $get(_4u, _4v); /*17640*/
					for (;;) { /*17672*/
						if ($1.x != $1.B) { /*17645*/
							var _54 = $get($get($1.charvals, $1.x), $1.char) !== undefined; /*17645*/
							if (!_54) { /*17645*/
								break; /*17645*/
							} /*17645*/
						} /*17645*/
						$1.cost = $get($1.curlen, $1.x) + $get($1.charsize, $1.x); /*17648*/
						if ($1.cost < $get($1.nxtlen, $1.x)) { /*17652*/
							$put($1.nxtlen, $1.x, $1.cost); /*17650*/
							$k[$j++] = $1.nxtseq; /*17651*/
							$k[$j++] = $1.x; /*17651*/
							$k[$j++] = Infinity; /*17651*/
							$aload($get($1.curseq, $1.x)); /*17651*/
							$k[$j++] = $1.char; /*17651*/
							var _5O = $a(); /*17651*/
							var _5P = $k[--$j]; /*17651*/
							$put($k[--$j], _5P, _5O); /*17651*/
						} /*17651*/
						if ($1.x == $1.B) { /*17655*/
							break; /*17655*/
						} /*17655*/
						var _5Y = $a([$1.U, $1.L, $1.M, $1.P, $1.D]); /*17656*/
						for (var _5Z = 0, _5a = _5Y.length; _5Z < _5a; _5Z++) { /*17669*/
							$1.y = $get(_5Y, _5Z); /*17657*/
							if ($ne($1.x, $1.y)) { /*17668*/
								$1.cost = ($get($1.curlen, $1.y) + $get($get($1.shftlen, $1.y), $1.x)) + $get($1.charsize, $1.x); /*17659*/
								if ($1.cost < $get($1.nxtlen, $1.y)) { /*17667*/
									$put($1.nxtlen, $1.y, $1.cost); /*17661*/
									$k[$j++] = $1.nxtseq; /*17665*/
									$k[$j++] = $1.y; /*17665*/
									$k[$j++] = Infinity; /*17665*/
									$aload($get($1.curseq, $1.y)); /*17663*/
									if ($1.x == $1.U) { /*17664*/
										$k[$j++] = $1.su; /*17664*/
									} else { /*17664*/
										$k[$j++] = $1.sp; /*17664*/
									} /*17664*/
									$k[$j++] = $1.char; /*17665*/
									var _66 = $a(); /*17665*/
									var _67 = $k[--$j]; /*17666*/
									$put($k[--$j], _67, _66); /*17666*/
								} /*17666*/
							} /*17666*/
						} /*17666*/
						break; /*17671*/
					} /*17671*/
				} /*17671*/
				if ($ne($1.lastchar, "")) { /*17685*/
					var _6A = $s(2); /*17678*/
					$put(_6A, 0, $1.lastchar); /*17678*/
					$put(_6A, 1, $1.char); /*17678*/
					$1.pchars = _6A; /*17678*/
					var _6F = $get($1.pcomp, $1.pchars) !== undefined; /*17679*/
					if (_6F) { /*17684*/
						if ($lt($get($1.curlen, $1.P), $get($1.nxtlen, $1.P))) { /*17683*/
							$put($1.nxtlen, $1.P, $get($1.curlen, $1.P)); /*17681*/
							$k[$j++] = $1.nxtseq; /*17682*/
							$k[$j++] = $1.P; /*17682*/
							$k[$j++] = Infinity; /*17682*/
							$aload($get($1.curseq, $1.P)); /*17682*/
							$j--; /*17682*/
							$k[$j++] = $get($1.pcomp, $1.pchars); /*17682*/
							var _6Z = $a(); /*17682*/
							var _6a = $k[--$j]; /*17682*/
							$put($k[--$j], _6a, _6Z); /*17682*/
						} /*17682*/
					} /*17682*/
				} /*17682*/
				$1.numbytes = 0; /*17688*/
				$forall($get($1.nxtseq, $1.B), function() { /*17691*/
					if ($k[--$j] == $1.sb) { /*17690*/
						$k[$j++] = 0; /*17690*/
					} else { /*17690*/
						$k[$j++] = $1.numbytes + 1; /*17690*/
					} /*17690*/
					$1.numbytes = $k[--$j]; /*17690*/
				}) /*17690*/
				if ($1.numbytes == 32) { /*17692*/
					$put($1.nxtlen, $1.B, $get($1.nxtlen, $1.B) + 11); /*17692*/
				} /*17692*/
				$1.curlen = $1.nxtlen; /*17694*/
				$1.curseq = $1.nxtseq; /*17695*/
				$1.lastchar = $1.char; /*17696*/
			}) /*17696*/
			$1.minseq = $1.e; /*17701*/
			var _6z = $a([$1.U, $1.L, $1.M, $1.P, $1.D, $1.B]); /*17702*/
			for (var _70 = 0, _71 = _6z.length; _70 < _71; _70++) { /*17708*/
				$1.i = $get(_6z, _70); /*17703*/
				if ($get($1.curlen, $1.i) < $1.minseq) { /*17707*/
					$1.minseq = $get($1.curlen, $1.i); /*17705*/
					$1.seq = $get($1.curseq, $1.i); /*17706*/
				} /*17706*/
			} /*17706*/
			$1.tobin = function() {
				var _7E = $s($k[--$j]); /*17712*/
				$k[$j++] = _7E; /*17712*/
				for (var _7G = 0, _7F = _7E.length - 1; _7G <= _7F; _7G += 1) { /*17712*/
					var _7H = $k[--$j]; /*17712*/
					$put(_7H, _7G, 48); /*17712*/
					$k[$j++] = _7H; /*17712*/
				} /*17712*/
				var _7I = $k[--$j]; /*17713*/
				var _7L = $cvrs($s(_7I.length), $k[--$j], 2); /*17713*/
				$puti(_7I, _7I.length - _7L.length, _7L); /*17713*/
				$k[$j++] = _7I; /*17713*/
			}; /*17714*/
			$1.encu = function() {
				var _7Q = $get($get($1.charvals, $1.U), $k[--$j]); /*17715*/
				$k[$j++] = _7Q; /*17715*/
				$k[$j++] = 5; /*17715*/
				$1.tobin(); /*17715*/
			}; /*17715*/
			$1.encl = function() {
				var _7V = $get($get($1.charvals, $1.L), $k[--$j]); /*17716*/
				$k[$j++] = _7V; /*17716*/
				$k[$j++] = 5; /*17716*/
				$1.tobin(); /*17716*/
			}; /*17716*/
			$1.encm = function() {
				var _7a = $get($get($1.charvals, $1.M), $k[--$j]); /*17717*/
				$k[$j++] = _7a; /*17717*/
				$k[$j++] = 5; /*17717*/
				$1.tobin(); /*17717*/
			}; /*17717*/
			$1.encp = function() {
				var _7f = $get($get($1.charvals, $1.P), $k[--$j]); /*17718*/
				$k[$j++] = _7f; /*17718*/
				$k[$j++] = 5; /*17718*/
				$1.tobin(); /*17718*/
			}; /*17718*/
			$1.encd = function() {
				var _7k = $get($get($1.charvals, $1.D), $k[--$j]); /*17719*/
				$k[$j++] = _7k; /*17719*/
				$k[$j++] = 4; /*17719*/
				$1.tobin(); /*17719*/
			}; /*17719*/
			$1.encfuncs = $a(["encu", "encl", "encm", "encp", "encd"]); /*17720*/
			$1.addtomsgbits = function() {
				$1.v = $k[--$j]; /*17722*/
				$puti($1.msgbits, $1.j, $1.v); /*17723*/
				$1.j = $1.j + $1.v.length; /*17724*/
			}; /*17725*/
			$1.state = $1.U; /*17728*/
			$1.msgbits = $s($1.minseq); /*17729*/
			$1.i = 0; /*17730*/
			$1.j = 0; /*17730*/
			for (;;) { /*17789*/
				if ($1.i >= $1.seq.length) { /*17731*/
					break; /*17731*/
				} /*17731*/
				if ($1.state != $1.B) { /*17784*/
					$1.char = $get($1.seq, $1.i); /*17735*/
					$k[$j++] = $1.char; /*17738*/
					$1[$get($1.encfuncs, $1.state)](); /*17738*/
					$1.addtomsgbits(); /*17738*/
					$1.i = $1.i + 1; /*17739*/
					if (($1.char == $1.su) || ($1.char == $1.sp)) { /*17745*/
						$k[$j++] = $get($1.seq, $1.i); /*17743*/
						if ($1.char == $1.su) { /*17743*/
							$1.encu(); /*17743*/
						} else { /*17743*/
							$1.encp(); /*17743*/
						} /*17743*/
						$1.addtomsgbits(); /*17743*/
						$1.i = $1.i + 1; /*17744*/
					} /*17744*/
					if ($1.char == $1.lu) { /*17748*/
						$1.state = $1.U; /*17748*/
					} /*17748*/
					if ($1.char == $1.ll) { /*17749*/
						$1.state = $1.L; /*17749*/
					} /*17749*/
					if ($1.char == $1.lm) { /*17750*/
						$1.state = $1.M; /*17750*/
					} /*17750*/
					if ($1.char == $1.lp) { /*17751*/
						$1.state = $1.P; /*17751*/
					} /*17751*/
					if ($1.char == $1.ld) { /*17752*/
						$1.state = $1.D; /*17752*/
					} /*17752*/
					if ($1.char == $1.sb) { /*17753*/
						$1.state = $1.B; /*17753*/
					} /*17753*/
				} else { /*17784*/
					$1.numbytes = 0; /*17758*/
					for (;;) { /*17762*/
						if (($1.i + $1.numbytes) >= $1.seq.length) { /*17759*/
							break; /*17759*/
						} /*17759*/
						if ($get($1.seq, $1.i + $1.numbytes) < 0) { /*17760*/
							break; /*17760*/
						} /*17760*/
						$1.numbytes = $1.numbytes + 1; /*17761*/
					} /*17761*/
					if ($1.numbytes <= 31) { /*17769*/
						$k[$j++] = $1.numbytes; /*17766*/
						$k[$j++] = 5; /*17766*/
						$1.tobin(); /*17766*/
						$1.addtomsgbits(); /*17766*/
					} else { /*17769*/
						$k[$j++] = 0; /*17768*/
						$k[$j++] = 5; /*17768*/
						$1.tobin(); /*17768*/
						$1.addtomsgbits(); /*17768*/
						$k[$j++] = $1.numbytes - 31; /*17769*/
						$k[$j++] = 11; /*17769*/
						$1.tobin(); /*17769*/
						$1.addtomsgbits(); /*17769*/
					} /*17769*/
					for (var _8m = 0, _8n = $1.numbytes; _8m < _8n; _8m++) { /*17776*/
						$k[$j++] = $get($1.seq, $1.i); /*17774*/
						$k[$j++] = 8; /*17774*/
						$1.tobin(); /*17774*/
						$1.addtomsgbits(); /*17774*/
						$1.i = $1.i + 1; /*17775*/
					} /*17775*/
					if ($1.i < $1.seq.length) { /*17785*/
						$1.char = $get($1.seq, $1.i); /*17780*/
						$1.i = $1.i + 1; /*17781*/
						if ($1.char == $1.lu) { /*17782*/
							$1.state = $1.U; /*17782*/
						} /*17782*/
						if ($1.char == $1.ll) { /*17783*/
							$1.state = $1.L; /*17783*/
						} /*17783*/
						if ($1.char == $1.lm) { /*17784*/
							$1.state = $1.M; /*17784*/
						} /*17784*/
					} /*17784*/
				} /*17784*/
			} /*17784*/
		} /*17784*/
		$1.metrics = $a([$a(["rune", 0, 0, 0, 6]), $a(["compact", 1, 1, 17, 6]), $a(["full", 1, 1, 21, 6]), $a(["compact", 2, 0, 40, 6]), $a(["full", 2, 1, 48, 6]), $a(["compact", 3, 0, 51, 8]), $a(["full", 3, 1, 60, 8]), $a(["compact", 4, 0, 76, 8]), $a(["full", 4, 1, 88, 8]), $a(["full", 5, 1, 120, 8]), $a(["full", 6, 1, 156, 8]), $a(["full", 7, 1, 196, 8]), $a(["full", 8, 1, 240, 8]), $a(["full", 9, 1, 230, 10]), $a(["full", 10, 1, 272, 10]), $a(["full", 11, 1, 316, 10]), $a(["full", 12, 1, 364, 10]), $a(["full", 13, 1, 416, 10]), $a(["full", 14, 1, 470, 10]), $a(["full", 15, 1, 528, 10]), $a(["full", 16, 1, 588, 10]), $a(["full", 17, 1, 652, 10]), $a(["full", 18, 1, 720, 10]), $a(["full", 19, 1, 790, 10]), $a(["full", 20, 1, 864, 10]), $a(["full", 21, 1, 940, 10]), $a(["full", 22, 1, 1020, 10]), $a(["full", 23, 0, 920, 12]), $a(["full", 24, 0, 992, 12]), $a(["full", 25, 0, 1066, 12]), $a(["full", 26, 0, 1144, 12]), $a(["full", 27, 0, 1224, 12]), $a(["full", 28, 0, 1306, 12]), $a(["full", 29, 0, 1392, 12]), $a(["full", 30, 0, 1480, 12]), $a(["full", 31, 0, 1570, 12]), $a(["full", 32, 0, 1664, 12])]); /*17808*/
		$1.i = 0; /*17810*/
		for (;;) { /*17828*/
			$1.m = $get($1.metrics, $1.i); /*17812*/
			$1.frmt = $get($1.m, 0); /*17813*/
			$1.mlyr = $get($1.m, 1); /*17814*/
			$1.icap = $get($1.m, 2); /*17815*/
			$1.ncws = $get($1.m, 3); /*17816*/
			$1.bpcw = $get($1.m, 4); /*17817*/
			$1.numecw = ~~(Math.ceil((($1.ncws * $1.eclevel) / 100) + $1.ecaddchars)); /*17818*/
			if ($1.msgbits.length == 0) { /*17819*/
				$1.numecw = 0; /*17819*/
			} /*17819*/
			$1.numdcw = $1.ncws - $1.numecw; /*17820*/
			$1.okay = true; /*17821*/
			if ($ne($1.format, "unset") && $ne($1.format, $1.frmt)) { /*17822*/
				$1.okay = false; /*17822*/
			} /*17822*/
			if ($1.readerinit && ($1.icap != 1)) { /*17823*/
				$1.okay = false; /*17823*/
			} /*17823*/
			if (($1.layers != -1) && ($1.layers != $1.mlyr)) { /*17824*/
				$1.okay = false; /*17824*/
			} /*17824*/
			if ((~~Math.ceil($1.msgbits.length / $1.bpcw)) > $1.numdcw) { /*17825*/
				$1.okay = false; /*17825*/
			} /*17825*/
			if ($1.okay) { /*17826*/
				break; /*17826*/
			} /*17826*/
			$1.i = $1.i + 1; /*17827*/
		} /*17827*/
		$1.layers = $1.mlyr; /*17829*/
		$1.format = $1.frmt; /*17830*/
		$1.allzero = function() {
			var _AH = $k[--$j]; /*17833*/
			$k[$j++] = $eq(_AH, $geti("000000000000", 0, _AH.length)); /*17833*/
		}; /*17833*/
		$1.allones = function() {
			var _AJ = $k[--$j]; /*17834*/
			$k[$j++] = $eq(_AJ, $geti("111111111111", 0, _AJ.length)); /*17834*/
		}; /*17834*/
		$1.cws = $a($1.ncws); /*17835*/
		$1.m = 0; /*17836*/
		$1.c = 0; /*17836*/
		for (;;) { /*17863*/
			if ($1.msgbits.length <= $1.m) { /*17838*/
				break; /*17838*/
			} /*17838*/
			if (($1.msgbits.length - $1.m) >= $1.bpcw) { /*17852*/
				$1.cwb = $geti($1.msgbits, $1.m, $1.bpcw - 1); /*17840*/
				$1.cwf = $geti($1.msgbits, ($1.m + $1.bpcw) - 1, 1); /*17841*/
				$k[$j++] = $1.cwb; /*17842*/
				$1.allzero(); /*17842*/
				if ($k[--$j]) { /*17842*/
					$1.cwf = "1"; /*17842*/
					$1.m = $1.m - 1; /*17842*/
				} /*17842*/
				$k[$j++] = $1.cwb; /*17843*/
				$1.allones(); /*17843*/
				if ($k[--$j]) { /*17843*/
					$1.cwf = "0"; /*17843*/
					$1.m = $1.m - 1; /*17843*/
				} /*17843*/
				var _Ag = $s(12); /*17845*/
				$puti(_Ag, 0, $1.cwb); /*17845*/
				$puti(_Ag, $1.bpcw - 1, $1.cwf); /*17846*/
				$1.cwb = $geti(_Ag, 0, $1.bpcw); /*17848*/
			} else { /*17852*/
				$1.cwb = $geti($1.msgbits, $1.m, $1.msgbits.length - $1.m); /*17850*/
				var _As = $strcpy($s(12), "111111111111"); /*17851*/
				$puti(_As, 0, $1.cwb); /*17851*/
				$1.cwb = $geti(_As, 0, $1.bpcw); /*17851*/
				$k[$j++] = $1.cwb; /*17852*/
				$1.allones(); /*17852*/
				if ($k[--$j]) { /*17852*/
					$puti($1.cwb, $1.cwb.length - 1, "0"); /*17852*/
				} /*17852*/
			} /*17852*/
			$1.cw = 0; /*17855*/
			for (var _B2 = 0, _B1 = $1.bpcw - 1; _B2 <= _B1; _B2 += 1) { /*17859*/
				$1.i = _B2; /*17857*/
				$1.cw = $1.cw + ((~~(Math.pow(2, ($1.bpcw - $1.i) - 1))) * ($get($1.cwb, $1.i) - 48)); /*17858*/
			} /*17858*/
			$put($1.cws, $1.c, $1.cw); /*17860*/
			$1.m = $1.m + $1.bpcw; /*17861*/
			$1.c = $1.c + 1; /*17862*/
		} /*17862*/
		$1.cws = $geti($1.cws, 0, $1.c); /*17864*/
		$1.rscodes = function() {
			$1.rspm = $k[--$j]; /*17869*/
			$1.rsgf = $k[--$j]; /*17870*/
			$1.rsnc = $k[--$j]; /*17871*/
			$1.rscws = $k[--$j]; /*17872*/
			$k[$j++] = "rsalog"; /*17875*/
			$k[$j++] = Infinity; /*17875*/
			$k[$j++] = 1; /*17875*/
			for (var _BN = 0, _BO = $1.rsgf - 1; _BN < _BO; _BN++) { /*17875*/
				var _BP = $k[--$j]; /*17875*/
				var _BQ = _BP * 2; /*17875*/
				$k[$j++] = _BP; /*17875*/
				$k[$j++] = _BQ; /*17875*/
				if (_BQ >= $1.rsgf) { /*17875*/
					var _BT = $k[--$j]; /*17875*/
					$k[$j++] = $xo(_BT, $1.rspm); /*17875*/
				} /*17875*/
			} /*17875*/
			var _BU = $a(); /*17875*/
			$1[$k[--$j]] = _BU; /*17875*/
			$1.rslog = $a($1.rsgf); /*17876*/
			for (var _Ba = 1, _BZ = $1.rsgf - 1; _Ba <= _BZ; _Ba += 1) { /*17877*/
				$put($1.rslog, $get($1.rsalog, _Ba), _Ba); /*17877*/
			} /*17877*/
			$1.rsprod = function() {
				var _Be = $k[--$j]; /*17881*/
				var _Bf = $k[--$j]; /*17881*/
				$k[$j++] = _Bf; /*17885*/
				$k[$j++] = _Be; /*17885*/
				if ((_Be != 0) && (_Bf != 0)) { /*17884*/
					var _Bi = $get($1.rslog, $k[--$j]); /*17882*/
					var _Bo = $get($1.rsalog, (_Bi + $get($1.rslog, $k[--$j])) % ($1.rsgf - 1)); /*17882*/
					$k[$j++] = _Bo; /*17882*/
				} else { /*17884*/
					$j -= 2; /*17884*/
					$k[$j++] = 0; /*17884*/
				} /*17884*/
			}; /*17886*/
			$k[$j++] = "coeffs"; /*17889*/
			$k[$j++] = Infinity; /*17889*/
			$k[$j++] = 1; /*17889*/
			for (var _Bq = 0, _Br = $1.rsnc; _Bq < _Br; _Bq++) { /*17889*/
				$k[$j++] = 0; /*17889*/
			} /*17889*/
			var _Bs = $a(); /*17889*/
			$1[$k[--$j]] = _Bs; /*17889*/
			for (var _Bw = 1, _Bv = $1.rsnc; _Bw <= _Bv; _Bw += 1) { /*17898*/
				$1.i = _Bw; /*17891*/
				$put($1.coeffs, $1.i, $get($1.coeffs, $1.i - 1)); /*17892*/
				for (var _C3 = $1.i - 1; _C3 >= 1; _C3 -= 1) { /*17896*/
					$1.j = _C3; /*17894*/
					$k[$j++] = $1.coeffs; /*17895*/
					$k[$j++] = $1.j; /*17895*/
					$k[$j++] = $get($1.coeffs, $1.j - 1); /*17895*/
					$k[$j++] = $get($1.coeffs, $1.j); /*17895*/
					$k[$j++] = $get($1.rsalog, $1.i); /*17895*/
					$1.rsprod(); /*17895*/
					var _CF = $k[--$j]; /*17895*/
					var _CG = $k[--$j]; /*17895*/
					var _CH = $k[--$j]; /*17895*/
					$put($k[--$j], _CH, $xo(_CG, _CF)); /*17895*/
				} /*17895*/
				$k[$j++] = $1.coeffs; /*17897*/
				$k[$j++] = 0; /*17897*/
				$k[$j++] = $get($1.coeffs, 0); /*17897*/
				$k[$j++] = $get($1.rsalog, $1.i); /*17897*/
				$1.rsprod(); /*17897*/
				var _CP = $k[--$j]; /*17897*/
				var _CQ = $k[--$j]; /*17897*/
				$put($k[--$j], _CQ, _CP); /*17897*/
			} /*17897*/
			$1.nd = $1.rscws.length; /*17901*/
			$k[$j++] = "rscws"; /*17902*/
			$k[$j++] = Infinity; /*17902*/
			$forall($1.rscws); /*17902*/
			for (var _CV = 0, _CW = $1.rsnc; _CV < _CW; _CV++) { /*17902*/
				$k[$j++] = 0; /*17902*/
			} /*17902*/
			$k[$j++] = 0; /*17902*/
			var _CX = $a(); /*17902*/
			$1[$k[--$j]] = _CX; /*17902*/
			for (var _Cb = 0, _Ca = $1.nd - 1; _Cb <= _Ca; _Cb += 1) { /*17909*/
				$1.k = $xo($get($1.rscws, _Cb), $get($1.rscws, $1.nd)); /*17904*/
				for (var _Cj = 0, _Ci = $1.rsnc - 1; _Cj <= _Ci; _Cj += 1) { /*17908*/
					$1.j = _Cj; /*17906*/
					$k[$j++] = $1.rscws; /*17907*/
					$k[$j++] = $1.nd + $1.j; /*17907*/
					$k[$j++] = $get($1.rscws, ($1.nd + $1.j) + 1); /*17907*/
					$k[$j++] = $1.k; /*17907*/
					$k[$j++] = $get($1.coeffs, ($1.rsnc - $1.j) - 1); /*17907*/
					$1.rsprod(); /*17907*/
					var _Cw = $k[--$j]; /*17907*/
					var _Cx = $k[--$j]; /*17907*/
					var _Cy = $k[--$j]; /*17907*/
					$put($k[--$j], _Cy, $xo(_Cx, _Cw)); /*17907*/
				} /*17907*/
			} /*17907*/
			$k[$j++] = $geti($1.rscws, 0, $1.rscws.length - 1); /*17912*/
		}; /*17914*/
		if ($eq($1.format, "full")) { /*17927*/
			$1.mode = (($1.layers - 1) << 11) + ($1.cws.length - 1); /*17918*/
			if ($1.readerinit) { /*17919*/
				$1.mode = $1.mode | 1024; /*17919*/
			} /*17919*/
			$1.mode = $a([($1.mode & 61440) >>> 12, ($1.mode & 3840) >>> 8, ($1.mode & 240) >>> 4, $1.mode & 15]); /*17925*/
			$k[$j++] = "mode"; /*17926*/
			$k[$j++] = $1.mode; /*17926*/
			$k[$j++] = 6; /*17926*/
			$k[$j++] = 16; /*17926*/
			$k[$j++] = 19; /*17926*/
			$1.rscodes(); /*17926*/
			var _DE = $k[--$j]; /*17926*/
			$1[$k[--$j]] = _DE; /*17926*/
		} /*17926*/
		if ($eq($1.format, "compact")) { /*17936*/
			$1.mode = (($1.layers - 1) << 6) + ($1.cws.length - 1); /*17929*/
			if ($1.readerinit) { /*17930*/
				$1.mode = $1.mode | 32; /*17930*/
			} /*17930*/
			$1.mode = $a([($1.mode & 240) >>> 4, $1.mode & 15]); /*17934*/
			$k[$j++] = "mode"; /*17935*/
			$k[$j++] = $1.mode; /*17935*/
			$k[$j++] = 5; /*17935*/
			$k[$j++] = 16; /*17935*/
			$k[$j++] = 19; /*17935*/
			$1.rscodes(); /*17935*/
			var _DP = $k[--$j]; /*17935*/
			$1[$k[--$j]] = _DP; /*17935*/
		} /*17935*/
		if ($eq($1.format, "rune")) { /*17945*/
			$1.mode = ~~$z($1.barcode); /*17938*/
			$1.mode = $a([($1.mode & 240) >>> 4, $1.mode & 15]); /*17942*/
			$k[$j++] = "mode"; /*17943*/
			$k[$j++] = $1.mode; /*17943*/
			$k[$j++] = 5; /*17943*/
			$k[$j++] = 16; /*17943*/
			$k[$j++] = 19; /*17943*/
			$1.rscodes(); /*17943*/
			var _DX = $k[--$j]; /*17943*/
			$1[$k[--$j]] = _DX; /*17943*/
			$k[$j++] = "mode"; /*17944*/
			$k[$j++] = Infinity; /*17944*/
			var _DZ = $1.mode; /*17944*/
			for (var _Da = 0, _Db = _DZ.length; _Da < _Db; _Da++) { /*17944*/
				$k[$j++] = $get(_DZ, _Da) ^ 10; /*17944*/
			} /*17944*/
			var _Dd = $a(); /*17944*/
			$1[$k[--$j]] = _Dd; /*17944*/
		} /*17944*/
		$1.modebits = $s($1.mode.length * 4); /*17946*/
		for (var _Dj = 0, _Di = $1.modebits.length - 1; _Dj <= _Di; _Dj += 1) { /*17947*/
			$puti($1.modebits, _Dj, "0"); /*17947*/
		} /*17947*/
		for (var _Dn = 0, _Dm = $1.mode.length - 1; _Dn <= _Dm; _Dn += 1) { /*17951*/
			$1.i = _Dn; /*17949*/
			var _Dt = $cvrs($s(4), $get($1.mode, $1.i), 2); /*17950*/
			$puti($1.modebits, (4 - _Dt.length) + (4 * $1.i), _Dt); /*17950*/
		} /*17950*/
		$1.rsparams = $a([$a([]), $a([]), $a([]), $a([]), $a([]), $a([]), $a([64, 67]), $a([]), $a([256, 301]), $a([]), $a([1024, 1033]), $a([]), $a([4096, 4201])]); /*17963*/
		$k[$j++] = "cws"; /*17964*/
		$k[$j++] = $1.cws; /*17964*/
		$k[$j++] = $1.ncws - $1.cws.length; /*17964*/
		$forall($get($1.rsparams, $1.bpcw)); /*17964*/
		$1.rscodes(); /*17964*/
		var _EF = $k[--$j]; /*17964*/
		$1[$k[--$j]] = _EF; /*17964*/
		if ($eq($1.format, "full")) { /*17968*/
			$1.databits = $s((($1.layers * $1.layers) * 16) + ($1.layers * 112)); /*17966*/
		} else { /*17968*/
			$1.databits = $s((($1.layers * $1.layers) * 16) + ($1.layers * 88)); /*17968*/
		} /*17968*/
		for (var _ES = 0, _ER = $1.databits.length - 1; _ES <= _ER; _ES += 1) { /*17970*/
			$puti($1.databits, _ES, "0"); /*17970*/
		} /*17970*/
		for (var _EW = 0, _EV = $1.ncws - 1; _EW <= _EV; _EW += 1) { /*17976*/
			$1.i = _EW; /*17972*/
			var _Ed = $cvrs($s($1.bpcw), $get($1.cws, $1.i), 2); /*17973*/
			$puti($1.databits, (($1.bpcw - _Ed.length) + ($1.bpcw * $1.i)) + ($1.databits.length - ($1.ncws * $1.bpcw)), _Ed); /*17975*/
		} /*17975*/
		$1.cmv = function() {
			var _El = $k[--$j]; /*17979*/
			var _Em = $k[--$j]; /*17979*/
			$k[$j++] = (_Em - (_El * $1.size)) + $1.mid; /*17979*/
		}; /*17979*/
		$1.lmv = function() {
			$1.lbit = $k[--$j]; /*17983*/
			$1.llyr = $k[--$j]; /*17984*/
			$1.lwid = $1.fw + ($1.llyr * 4); /*17985*/
			$1.ldir = ~~((~~($1.lbit / 2)) / $1.lwid); /*17986*/
			if ($1.ldir == 0) { /*17991*/
				$k[$j++] = ((-(~~(($1.lwid - 1) / 2))) + 1) + ((~~($1.lbit / 2)) % $1.lwid); /*17990*/
				$k[$j++] = ((~~(($1.fw - 1) / 2)) + ($1.llyr * 2)) + ($1.lbit % 2); /*17990*/
				$1.cmv(); /*17990*/
			} /*17990*/
			if ($1.ldir == 1) { /*17996*/
				$k[$j++] = ((~~($1.fw / 2)) + ($1.llyr * 2)) + ($1.lbit % 2); /*17995*/
				$k[$j++] = ((~~(($1.lwid - 1) / 2)) - 1) - ((~~($1.lbit / 2)) % $1.lwid); /*17995*/
				$1.cmv(); /*17995*/
			} /*17995*/
			if ($1.ldir == 2) { /*18001*/
				$k[$j++] = -(((-(~~($1.lwid / 2))) + 1) + ((~~($1.lbit / 2)) % $1.lwid)); /*18000*/
				$k[$j++] = -(((~~($1.fw / 2)) + ($1.llyr * 2)) + ($1.lbit % 2)); /*18000*/
				$1.cmv(); /*18000*/
			} /*18000*/
			if ($1.ldir == 3) { /*18006*/
				$k[$j++] = -(((~~(($1.fw - 1) / 2)) + ($1.llyr * 2)) + ($1.lbit % 2)); /*18005*/
				$k[$j++] = -(((~~($1.lwid / 2)) - 1) - ((~~($1.lbit / 2)) % $1.lwid)); /*18005*/
				$1.cmv(); /*18005*/
			} /*18005*/
		}; /*18007*/
		if ($eq($1.format, "full")) { /*18011*/
			$1.fw = 12; /*18011*/
		} else { /*18011*/
			$1.fw = 9; /*18011*/
		} /*18011*/
		$1.size = ($1.fw + ($1.layers * 4)) + 2; /*18012*/
		$k[$j++] = "pixs"; /*18013*/
		$k[$j++] = Infinity; /*18013*/
		for (var _FR = 0, _FS = $1.size * $1.size; _FR < _FS; _FR++) { /*18013*/
			$k[$j++] = -1; /*18013*/
		} /*18013*/
		var _FT = $a(); /*18013*/
		$1[$k[--$j]] = _FT; /*18013*/
		$1.mid = ((~~(($1.size - 1) / 2)) * $1.size) + (~~(($1.size - 1) / 2)); /*18014*/
		$1.i = 0; /*18017*/
		for (var _Fa = 1, _FZ = $1.layers; _Fa <= _FZ; _Fa += 1) { /*18025*/
			$1.layer = _Fa; /*18019*/
			for (var _Fe = 0, _Fd = (($1.fw + ($1.layer * 4)) * 8) - 1; _Fe <= _Fd; _Fe += 1) { /*18024*/
				$1.pos = _Fe; /*18021*/
				$k[$j++] = $1.pixs; /*18022*/
				$k[$j++] = $1.layer; /*18022*/
				$k[$j++] = $1.pos; /*18022*/
				$1.lmv(); /*18022*/
				var _Fm = $k[--$j]; /*18022*/
				$put($k[--$j], _Fm, $get($1.databits, ($1.databits.length - $1.i) - 1) - 48); /*18022*/
				$1.i = $1.i + 1; /*18023*/
			} /*18023*/
		} /*18023*/
		if ($eq($1.format, "full")) { /*18052*/
			$1.fw = 13; /*18029*/
			$1.size = (($1.fw + ($1.layers * 4)) + 2) + ((~~((($1.layers + 10.5) / 7.5) - 1)) * 2); /*18030*/
			$1.mid = ~~(($1.size * $1.size) / 2); /*18031*/
			$k[$j++] = "npixs"; /*18032*/
			$k[$j++] = Infinity; /*18032*/
			for (var _Fx = 0, _Fy = $1.size * $1.size; _Fx < _Fy; _Fx++) { /*18032*/
				$k[$j++] = -2; /*18032*/
			} /*18032*/
			var _Fz = $a(); /*18032*/
			$1[$k[--$j]] = _Fz; /*18032*/
			for (var _G3 = 0, _G2 = ~~($1.size / 2); _G3 <= _G2; _G3 += 16) { /*18042*/
				$1.i = _G3; /*18034*/
				for (var _G6 = 0, _G5 = $1.size - 1; _G6 <= _G5; _G6 += 1) { /*18041*/
					$1.j = _G6; /*18036*/
					$k[$j++] = $1.npixs; /*18037*/
					$k[$j++] = (-(~~($1.size / 2))) + $1.j; /*18037*/
					$k[$j++] = $1.i; /*18037*/
					$1.cmv(); /*18037*/
					var _GF = $k[--$j]; /*18037*/
					$puti($k[--$j], _GF, $a([((((~~($1.size / 2)) + $1.j) + $1.i) + 1) % 2])); /*18037*/
					$k[$j++] = $1.npixs; /*18038*/
					$k[$j++] = (-(~~($1.size / 2))) + $1.j; /*18038*/
					$k[$j++] = -$1.i; /*18038*/
					$1.cmv(); /*18038*/
					var _GP = $k[--$j]; /*18038*/
					$puti($k[--$j], _GP, $a([((((~~($1.size / 2)) + $1.j) + $1.i) + 1) % 2])); /*18038*/
					$k[$j++] = $1.npixs; /*18039*/
					$k[$j++] = $1.i; /*18039*/
					$k[$j++] = (-(~~($1.size / 2))) + $1.j; /*18039*/
					$1.cmv(); /*18039*/
					var _GZ = $k[--$j]; /*18039*/
					$puti($k[--$j], _GZ, $a([((((~~($1.size / 2)) + $1.j) + $1.i) + 1) % 2])); /*18039*/
					$k[$j++] = $1.npixs; /*18040*/
					$k[$j++] = -$1.i; /*18040*/
					$k[$j++] = (-(~~($1.size / 2))) + $1.j; /*18040*/
					$1.cmv(); /*18040*/
					var _Gj = $k[--$j]; /*18040*/
					$puti($k[--$j], _Gj, $a([((((~~($1.size / 2)) + $1.j) + $1.i) + 1) % 2])); /*18040*/
				} /*18040*/
			} /*18040*/
			$1.j = 0; /*18043*/
			for (var _Gn = 0, _Gm = $1.npixs.length - 1; _Gn <= _Gm; _Gn += 1) { /*18050*/
				$1.i = _Gn; /*18045*/
				if ($get($1.npixs, $1.i) == -2) { /*18049*/
					$put($1.npixs, $1.i, $get($1.pixs, $1.j)); /*18047*/
					$1.j = $1.j + 1; /*18048*/
				} /*18048*/
			} /*18048*/
			$1.pixs = $1.npixs; /*18051*/
		} /*18051*/
		$1.fw = ~~($1.fw / 2); /*18055*/
		for (var _H2 = -$1.fw, _H1 = $1.fw; _H2 <= _H1; _H2 += 1) { /*18064*/
			$1.i = _H2; /*18057*/
			for (var _H6 = -$1.fw, _H5 = $1.fw; _H6 <= _H5; _H6 += 1) { /*18063*/
				$1.j = _H6; /*18059*/
				$k[$j++] = $1.pixs; /*18060*/
				$k[$j++] = $1.i; /*18060*/
				$k[$j++] = $1.j; /*18060*/
				$1.cmv(); /*18060*/
				if (Math.abs($1.i) > Math.abs($1.j)) { /*18061*/
					$k[$j++] = Math.abs($1.i); /*18061*/
				} else { /*18061*/
					$k[$j++] = Math.abs($1.j); /*18061*/
				} /*18061*/
				var _HE = $k[--$j]; /*18061*/
				var _HF = $k[--$j]; /*18062*/
				$put($k[--$j], _HF, (_HE + 1) % 2); /*18062*/
			} /*18062*/
		} /*18062*/
		var _Hr = $a([$a([-($1.fw + 1), $1.fw, 1]), $a([-($1.fw + 1), $1.fw + 1, 1]), $a([-$1.fw, $1.fw + 1, 1]), $a([$1.fw + 1, $1.fw + 1, 1]), $a([$1.fw + 1, $1.fw, 1]), $a([$1.fw + 1, -$1.fw, 1]), $a([$1.fw, $1.fw + 1, 0]), $a([$1.fw + 1, -($1.fw + 1), 0]), $a([$1.fw, -($1.fw + 1), 0]), $a([-$1.fw, -($1.fw + 1), 0]), $a([-($1.fw + 1), -($1.fw + 1), 0]), $a([-($1.fw + 1), -$1.fw, 0])]); /*18072*/
		for (var _Hs = 0, _Ht = _Hr.length; _Hs < _Ht; _Hs++) { /*18073*/
			$k[$j++] = $1.pixs; /*18073*/
			$forall($get(_Hr, _Hs)); /*18073*/
			var _Hw = $k[--$j]; /*18073*/
			var _Hx = $k[--$j]; /*18073*/
			var _Hy = $k[--$j]; /*18073*/
			$k[$j++] = _Hw; /*18073*/
			$k[$j++] = _Hy; /*18073*/
			$k[$j++] = _Hx; /*18073*/
			$1.cmv(); /*18073*/
			var _Hz = $k[--$j]; /*18073*/
			var _I0 = $k[--$j]; /*18073*/
			$put($k[--$j], _Hz, _I0); /*18073*/
		} /*18073*/
		if ($eq($1.format, "full")) { /*18089*/
			$1.modemap = $a([$a([-5, 7]), $a([-4, 7]), $a([-3, 7]), $a([-2, 7]), $a([-1, 7]), $a([1, 7]), $a([2, 7]), $a([3, 7]), $a([4, 7]), $a([5, 7]), $a([7, 5]), $a([7, 4]), $a([7, 3]), $a([7, 2]), $a([7, 1]), $a([7, -1]), $a([7, -2]), $a([7, -3]), $a([7, -4]), $a([7, -5]), $a([5, -7]), $a([4, -7]), $a([3, -7]), $a([2, -7]), $a([1, -7]), $a([-1, -7]), $a([-2, -7]), $a([-3, -7]), $a([-4, -7]), $a([-5, -7]), $a([-7, -5]), $a([-7, -4]), $a([-7, -3]), $a([-7, -2]), $a([-7, -1]), $a([-7, 1]), $a([-7, 2]), $a([-7, 3]), $a([-7, 4]), $a([-7, 5])]); /*18082*/
		} else { /*18089*/
			$1.modemap = $a([$a([-3, 5]), $a([-2, 5]), $a([-1, 5]), $a([0, 5]), $a([1, 5]), $a([2, 5]), $a([3, 5]), $a([5, 3]), $a([5, 2]), $a([5, 1]), $a([5, 0]), $a([5, -1]), $a([5, -2]), $a([5, -3]), $a([3, -5]), $a([2, -5]), $a([1, -5]), $a([0, -5]), $a([-1, -5]), $a([-2, -5]), $a([-3, -5]), $a([-5, -3]), $a([-5, -2]), $a([-5, -1]), $a([-5, 0]), $a([-5, 1]), $a([-5, 2]), $a([-5, 3])]); /*18089*/
		} /*18089*/
		for (var _JD = 0, _JC = $1.modemap.length - 1; _JD <= _JC; _JD += 1) { /*18094*/
			$1.i = _JD; /*18092*/
			$k[$j++] = $1.pixs; /*18093*/
			$forall($get($1.modemap, $1.i)); /*18093*/
			$1.cmv(); /*18093*/
			var _JL = $k[--$j]; /*18093*/
			$put($k[--$j], _JL, $get($1.modebits, $1.i) - 48); /*18093*/
		} /*18093*/
		var _JT = {
			ren: $0.renmatrix,
			pixs: $1.pixs,
			pixx: $1.size,
			pixy: $1.size,
			height: ($1.size * 2) / 72,
			width: ($1.size * 2) / 72,
			opt: $1.options
		}; /*18103*/
		$k[$j++] = _JT; /*18106*/
		if (!$1.dontdraw) { /*18106*/
			$0.renmatrix(); /*18106*/
		} /*18106*/
	};
	$0.azteccodecompact = function() {
		var $1 = {}; /*18134*/
		$1.options = $k[--$j]; /*18136*/
		$1.barcode = $k[--$j]; /*18137*/
		$1.dontdraw = false; /*18139*/
		$forall($1.options, function() { /*18150*/
			var _3 = $k[--$j]; /*18150*/
			$1[$k[--$j]] = _3; /*18150*/
		}) /*18150*/
		$1.options.dontdraw = true; /*18153*/
		$1.options.format = "compact"; /*18154*/
		$k[$j++] = "args"; /*18156*/
		$k[$j++] = $1.barcode; /*18156*/
		$k[$j++] = $1.options; /*18156*/
		$0.azteccode(); /*18156*/
		var _9 = $k[--$j]; /*18156*/
		$1[$k[--$j]] = _9; /*18156*/
		$1.args.opt = $1.options; /*18158*/
		$k[$j++] = $1.args; /*18161*/
		if (!$1.dontdraw) { /*18161*/
			$0.renmatrix(); /*18161*/
		} /*18161*/
	};
	$0.aztecrune = function() {
		var $1 = {}; /*18189*/
		$1.options = $k[--$j]; /*18191*/
		$1.barcode = $k[--$j]; /*18192*/
		$1.dontdraw = false; /*18194*/
		$forall($1.options, function() { /*18205*/
			var _3 = $k[--$j]; /*18205*/
			$1[$k[--$j]] = _3; /*18205*/
		}) /*18205*/
		$1.options.dontdraw = true; /*18208*/
		$1.options.format = "rune"; /*18209*/
		$k[$j++] = "args"; /*18211*/
		$k[$j++] = $1.barcode; /*18211*/
		$k[$j++] = $1.options; /*18211*/
		$0.azteccode(); /*18211*/
		var _9 = $k[--$j]; /*18211*/
		$1[$k[--$j]] = _9; /*18211*/
		$1.args.opt = $1.options; /*18213*/
		$k[$j++] = $1.args; /*18216*/
		if (!$1.dontdraw) { /*18216*/
			$0.renmatrix(); /*18216*/
		} /*18216*/
	};
	$0.codeone = function() {
		var $1 = {}; /*18243*/
		$1.options = $k[--$j]; /*18245*/
		$1.barcode = $k[--$j]; /*18246*/
		$1.dontdraw = false; /*18248*/
		$1.version = "unset"; /*18249*/
		$1.parse = false; /*18250*/
		$1.parsefnc = false; /*18251*/
		$forall($1.options, function() { /*18262*/
			var _3 = $k[--$j]; /*18262*/
			$1[$k[--$j]] = _3; /*18262*/
		}) /*18262*/
		$1.barlen = $1.barcode.length; /*18285*/
		$1.stype = $eq($geti($1.version, 0, 1), "S"); /*18287*/
		if ($1.stype) { /*18872*/
			$1.vals = $a(["1", "1010", "1100100", "1111101000", "10011100010000", "11000011010100000", "11110100001001000000", "100110001001011010000000", "101111101011110000100000000", "111011100110101100101000000000", "1001010100000010111110010000000000", "1011101001000011101101110100000000000", "1110100011010100101001010001000000000000", "10010001100001001110011100101010000000000000", "10110101111001100010000011110100100000000000000", "11100011010111111010100100110001101000000000000000", "100011100001101111001001101111110000010000000000000000", "101100011010001010111100001011101100010100000000000000000"]); /*18309*/
			$1.normalize = function() {
				$1.base = $k[--$j]; /*18312*/
				$1.num = $k[--$j]; /*18313*/
				for (var _D = $1.num.length - 1; _D >= 1; _D -= 1) { /*18318*/
					$1.i = _D; /*18315*/
					var _E = $1.num; /*18316*/
					var _F = $1.i; /*18316*/
					$put(_E, _F - 1, $get(_E, _F - 1) + (~~($get($1.num, $1.i) / $1.base))); /*18316*/
					$put($1.num, $1.i, $get($1.num, $1.i) % $1.base); /*18317*/
				} /*18317*/
				for (;;) { /*18324*/
					if ($lt($get($1.num, 0), $1.base)) { /*18320*/
						break; /*18320*/
					} /*18320*/
					$k[$j++] = "num"; /*18321*/
					$k[$j++] = Infinity; /*18321*/
					$k[$j++] = 0; /*18321*/
					$forall($1.num); /*18321*/
					var _V = $a(); /*18321*/
					$1[$k[--$j]] = _V; /*18321*/
					$put($1.num, 0, $get($1.num, 0) + (~~($get($1.num, 1) / $1.base))); /*18322*/
					$put($1.num, 1, $get($1.num, 1) % $1.base); /*18323*/
				} /*18323*/
				$k[$j++] = "num"; /*18326*/
				$k[$j++] = Infinity; /*18326*/
				$1.i = true; /*18326*/
				$forall($1.num, function() { /*18326*/
					var _i = $k[--$j]; /*18326*/
					$k[$j++] = _i; /*18326*/
					if ((_i == 0) && $1.i) { /*18326*/
						$j--; /*18326*/
					} else { /*18326*/
						$1.i = false; /*18326*/
					} /*18326*/
				}) /*18326*/
				var _k = $a(); /*18326*/
				$1[$k[--$j]] = _k; /*18326*/
				if ($1.num.length == 0) { /*18327*/
					$1.num = $a([0]); /*18327*/
				} /*18327*/
				$k[$j++] = $1.num; /*18328*/
			}; /*18329*/
			$1.bigadd = function() {
				var _p = $k[--$j]; /*18332*/
				var _q = $k[--$j]; /*18332*/
				$1.offset = Math.abs(_p.length - _q.length); /*18333*/
				if (_p.length < _q.length) { /*18334*/
					var _ = _p; /*18334*/
					_p = _q; /*18334*/
					_q = _; /*18334*/
				} /*18334*/
				$1.a = _p; /*18335*/
				$1.b = _q; /*18335*/
				for (var _t = 0, _s = $1.b.length - 1; _t <= _s; _t += 1) { /*18338*/
					var _u = $1.a; /*18337*/
					var _v = $1.offset; /*18337*/
					$put(_u, _t + _v, $get(_u, _t + _v) + $get($1.b, _t)); /*18337*/
				} /*18337*/
				$k[$j++] = $1.a; /*18339*/
			}; /*18340*/
			$1.v = $a([1]); /*18343*/
			for (var _13 = 0, _12 = $1.barlen - 1; _13 <= _12; _13 += 1) { /*18348*/
				$1.i = _13; /*18345*/
				$k[$j++] = Infinity; /*18346*/
				$forall($get($1.vals, $1.i), function() { /*18346*/
					var _17 = $k[--$j]; /*18346*/
					$k[$j++] = (_17 - 48) * ($get($1.barcode, ($1.barlen - $1.i) - 1) - 48); /*18346*/
				}) /*18346*/
				var _1C = $a(); /*18346*/
				$k[$j++] = _1C; /*18347*/
				$k[$j++] = $1.v; /*18347*/
				$1.bigadd(); /*18347*/
				$1.v = $k[--$j]; /*18347*/
			} /*18347*/
			$k[$j++] = "v"; /*18349*/
			$k[$j++] = $1.v; /*18349*/
			$k[$j++] = 2; /*18349*/
			$1.normalize(); /*18349*/
			var _1G = $k[--$j]; /*18349*/
			$1[$k[--$j]] = _1G; /*18349*/
			$k[$j++] = "v"; /*18352*/
			$k[$j++] = Infinity; /*18352*/
			for (var _1J = 0, _1K = (5 - ($1.v.length % 5)) % 5; _1J < _1K; _1J++) { /*18352*/
				$k[$j++] = 0; /*18352*/
			} /*18352*/
			$aload($1.v); /*18352*/
			var _1M = $a(); /*18352*/
			$1[$k[--$j]] = _1M; /*18352*/
			$1.cws = $a(~~($1.v.length / 5)); /*18353*/
			for (var _1S = 0, _1R = $1.cws.length - 1; _1S <= _1R; _1S += 1) { /*18359*/
				$1.i = _1S; /*18355*/
				$k[$j++] = 0; /*18357*/
				$forall($geti($1.v, $1.i * 5, 5), function() { /*18357*/
					var _1W = $k[--$j]; /*18357*/
					var _1X = $k[--$j]; /*18357*/
					$k[$j++] = (_1X + _1W) * 2; /*18357*/
				}) /*18357*/
				$put($1.cws, $1.i, ~~($k[--$j] / 2)); /*18358*/
			} /*18358*/
		} else { /*18872*/
			$1.fnc1 = -1; /*18364*/
			$1.fnc3 = -2; /*18364*/
			var _1d = {
				FNC1: $1.fnc1,
				FNC3: $1.fnc3
			}; /*18367*/
			$1.fncvals = _1d; /*18368*/
			$1.msg = $a($1.barlen); /*18369*/
			$1.i = 0; /*18370*/
			$1.j = 0; /*18370*/
			for (;;) { /*18384*/
				if ($1.i == $1.barlen) { /*18371*/
					break; /*18371*/
				} /*18371*/
				$1.char = $get($1.barcode, $1.i); /*18372*/
				if (($1.parsefnc && ($1.char == 94)) && ($1.i < ($1.barlen - 4))) { /*18380*/
					if ($get($1.barcode, $1.i + 1) != 94) { /*18378*/
						$1.char = $get($1.fncvals, $geti($1.barcode, $1.i + 1, 4)); /*18375*/
						$1.i = $1.i + 4; /*18376*/
					} else { /*18378*/
						$1.i = $1.i + 1; /*18378*/
					} /*18378*/
				} /*18378*/
				$put($1.msg, $1.j, $1.char); /*18381*/
				$1.i = $1.i + 1; /*18382*/
				$1.j = $1.j + 1; /*18383*/
			} /*18383*/
			$1.msg = $geti($1.msg, 0, $1.j); /*18385*/
			$1.msglen = $1.msg.length; /*18386*/
			$1.metrics = $a([$a(["A", 16, 18, 16, 10, 10, 1, 4, 99, 6]), $a(["B", 22, 22, 20, 19, 16, 1, 4, 99, 8]), $a(["C", 28, 32, 28, 44, 26, 1, 4, 22, 11]), $a(["D", 40, 42, 36, 91, 44, 1, 4, 16, 16]), $a(["E", 52, 54, 48, 182, 70, 1, 4, 22, 22]), $a(["F", 70, 76, 68, 370, 140, 2, 4, 22, 31]), $a(["G", 104, 98, 88, 732, 280, 4, 6, 21, 47]), $a(["H", 148, 134, 120, 1480, 560, 8, 6, 20, 69]), $a(["S-10", 8, 11, 10, 4, 4, 1, 99, 99, 99]), $a(["S-20", 8, 21, 20, 8, 8, 1, 99, 99, 99]), $a(["S-30", 8, 31, 30, 12, 12, 1, 99, 99, 99]), $a(["T-16", 16, 17, 16, 10, 10, 1, 99, 99, 99]), $a(["T-32", 16, 33, 32, 24, 16, 1, 99, 99, 99]), $a(["T-48", 16, 49, 48, 38, 22, 1, 99, 99, 99])]); /*18405*/
			$1.fullcws = $a([]); /*18408*/
			var _2O = $1.metrics; /*18409*/
			for (var _2P = 0, _2Q = _2O.length; _2P < _2Q; _2P++) { /*18420*/
				$1.m = $get(_2O, _2P); /*18410*/
				$1.vers = $get($1.m, 0); /*18411*/
				$1.dcws = $get($1.m, 4); /*18412*/
				$1.okay = true; /*18413*/
				if ($eq($1.version, "unset")) { /*18417*/
					if ($1.vers.length != 1) { /*18415*/
						$1.okay = false; /*18415*/
					} /*18415*/
				} else { /*18417*/
					if ($ne($1.version, $1.vers)) { /*18417*/
						$1.okay = false; /*18417*/
					} /*18417*/
				} /*18417*/
				if ($1.okay) { /*18419*/
					$k[$j++] = "fullcws"; /*18419*/
					$k[$j++] = Infinity; /*18419*/
					$aload($1.fullcws); /*18419*/
					$k[$j++] = $1.dcws; /*18419*/
					var _2d = $a(); /*18419*/
					$1[$k[--$j]] = _2d; /*18419*/
				} /*18419*/
			} /*18419*/
			$k[$j++] = "numremcws"; /*18421*/
			$k[$j++] = Infinity; /*18421*/
			for (var _2f = 0, _2g = 1480; _2f < _2g; _2f++) { /*18421*/
				$k[$j++] = 10000; /*18421*/
			} /*18421*/
			var _2h = $a(); /*18421*/
			$1[$k[--$j]] = _2h; /*18421*/
			var _2j = $1.fullcws; /*18422*/
			for (var _2k = 0, _2l = _2j.length; _2k < _2l; _2k++) { /*18422*/
				$put($1.numremcws, $get(_2j, _2k) - 1, 1); /*18422*/
			} /*18422*/
			for (var _2o = 1478; _2o >= 0; _2o -= 1) { /*18428*/
				$1.i = _2o; /*18424*/
				if ($get($1.numremcws, $1.i) != 1) { /*18427*/
					$put($1.numremcws, $1.i, $get($1.numremcws, $1.i + 1) + 1); /*18426*/
				} /*18426*/
			} /*18426*/
			$1.lC = -5; /*18431*/
			$1.lB = -6; /*18431*/
			$1.lX = -7; /*18431*/
			$1.lT = -8; /*18431*/
			$1.lD = -9; /*18431*/
			$1.unl = -10; /*18431*/
			$1.fnc2 = -11; /*18432*/
			$1.fnc4 = -12; /*18432*/
			$1.sft1 = -13; /*18432*/
			$1.sft2 = -14; /*18432*/
			$1.sft3 = -15; /*18432*/
			$1.eci = -16; /*18432*/
			$1.pad = -17; /*18432*/
			$1.fnc1lD = -18; /*18432*/
			$1.unlcw = 255; /*18433*/
			$k[$j++] = "Avals"; /*18444*/
			$k[$j++] = Infinity; /*18444*/
			for (var _2x = 0; _2x <= 128; _2x += 1) { /*18436*/
				$k[$j++] = _2x; /*18436*/
				$k[$j++] = _2x + 1; /*18436*/
			} /*18436*/
			$k[$j++] = $1.pad; /*18441*/
			$k[$j++] = 129; /*18441*/
			for (var _2z = 0; _2z <= 99; _2z += 1) { /*18441*/
				var _31 = $cvrs($s(2), _2z, 10); /*18439*/
				var _33 = $strcpy($s(2), "00"); /*18439*/
				$puti(_33, 2 - _31.length, _31); /*18439*/
				$k[$j++] = _33; /*18440*/
				$k[$j++] = _2z + 130; /*18440*/
			} /*18440*/
			var _3B = $a([$1.lC, $1.lB, $1.fnc1, $1.fnc2, $1.fnc3, $1.fnc4, $1.fnc1lD]); /*18442*/
			$k[$j++] = 229; /*18442*/
			for (var _3C = 0, _3D = _3B.length; _3C < _3D; _3C++) { /*18442*/
				var _3G = $k[--$j] + 1; /*18442*/
				$k[$j++] = $get(_3B, _3C); /*18442*/
				$k[$j++] = _3G; /*18442*/
				$k[$j++] = _3G; /*18442*/
			} /*18442*/
			$j--; /*18442*/
			$k[$j++] = $1.lX; /*18444*/
			$k[$j++] = 238; /*18444*/
			$k[$j++] = $1.lT; /*18444*/
			$k[$j++] = 239; /*18444*/
			var _3J = $d(); /*18444*/
			$1[$k[--$j]] = _3J; /*18446*/
			$k[$j++] = "Avals"; /*18448*/
			$k[$j++] = Infinity; /*18448*/
			$forall($1.Avals, function() { /*18448*/
				$k[$j++] = Infinity; /*18448*/
				var _3M = $k[--$j]; /*18448*/
				var _3N = $k[--$j]; /*18448*/
				$k[$j++] = _3M; /*18448*/
				$k[$j++] = _3N; /*18448*/
				var _3O = $a(); /*18448*/
				$k[$j++] = _3O; /*18448*/
			}) /*18448*/
			var _3P = $d(); /*18448*/
			$1[$k[--$j]] = _3P; /*18449*/
			$k[$j++] = "CNvals"; /*18457*/
			$k[$j++] = Infinity; /*18457*/
			$k[$j++] = $1.sft1; /*18456*/
			$k[$j++] = 0; /*18456*/
			$k[$j++] = $1.sft2; /*18456*/
			$k[$j++] = 1; /*18456*/
			$k[$j++] = $1.sft3; /*18456*/
			$k[$j++] = 2; /*18456*/
			$k[$j++] = 32; /*18456*/
			$k[$j++] = 3; /*18456*/
			for (var _3U = 48; _3U <= 57; _3U += 1) { /*18456*/
				$k[$j++] = _3U; /*18456*/
				$k[$j++] = _3U - 44; /*18456*/
			} /*18456*/
			for (var _3V = 65; _3V <= 90; _3V += 1) { /*18457*/
				$k[$j++] = _3V; /*18457*/
				$k[$j++] = _3V - 51; /*18457*/
			} /*18457*/
			var _3W = $d(); /*18457*/
			$1[$k[--$j]] = _3W; /*18458*/
			$k[$j++] = "C1vals"; /*18459*/
			$k[$j++] = Infinity; /*18459*/
			for (var _3Y = 0; _3Y <= 31; _3Y += 1) { /*18459*/
				$k[$j++] = _3Y; /*18459*/
				$k[$j++] = _3Y; /*18459*/
			} /*18459*/
			var _3Z = $d(); /*18459*/
			$1[$k[--$j]] = _3Z; /*18459*/
			$k[$j++] = "C2vals"; /*18468*/
			$k[$j++] = Infinity; /*18468*/
			for (var _3b = 33; _3b <= 47; _3b += 1) { /*18461*/
				$k[$j++] = _3b; /*18461*/
				$k[$j++] = _3b - 33; /*18461*/
			} /*18461*/
			for (var _3c = 58; _3c <= 64; _3c += 1) { /*18462*/
				$k[$j++] = _3c; /*18462*/
				$k[$j++] = _3c - 43; /*18462*/
			} /*18462*/
			for (var _3d = 91; _3d <= 95; _3d += 1) { /*18463*/
				$k[$j++] = _3d; /*18463*/
				$k[$j++] = _3d - 69; /*18463*/
			} /*18463*/
			$k[$j++] = $1.fnc1; /*18468*/
			$k[$j++] = 27; /*18468*/
			$k[$j++] = $1.fnc2; /*18468*/
			$k[$j++] = 28; /*18468*/
			$k[$j++] = $1.fnc3; /*18468*/
			$k[$j++] = 29; /*18468*/
			$k[$j++] = $1.fnc4; /*18468*/
			$k[$j++] = 30; /*18468*/
			$k[$j++] = $1.pad; /*18468*/
			$k[$j++] = 31; /*18468*/
			var _3j = $d(); /*18468*/
			$1[$k[--$j]] = _3j; /*18469*/
			$k[$j++] = "C3vals"; /*18470*/
			$k[$j++] = Infinity; /*18470*/
			for (var _3l = 96; _3l <= 127; _3l += 1) { /*18470*/
				$k[$j++] = _3l; /*18470*/
				$k[$j++] = _3l - 96; /*18470*/
			} /*18470*/
			var _3m = $d(); /*18470*/
			$1[$k[--$j]] = _3m; /*18470*/
			$k[$j++] = "Cvals"; /*18475*/
			$k[$j++] = Infinity; /*18475*/
			$forall($1.CNvals, function() { /*18472*/
				$k[$j++] = Infinity; /*18472*/
				var _3p = $k[--$j]; /*18472*/
				var _3q = $k[--$j]; /*18472*/
				$k[$j++] = _3p; /*18472*/
				$k[$j++] = _3q; /*18472*/
				var _3r = $a(); /*18472*/
				$k[$j++] = _3r; /*18472*/
			}) /*18472*/
			$forall($1.C1vals, function() { /*18473*/
				$k[$j++] = Infinity; /*18473*/
				var _3t = $k[--$j]; /*18473*/
				var _3u = $k[--$j]; /*18473*/
				$k[$j++] = _3t; /*18473*/
				$k[$j++] = $get($1.CNvals, $1.sft1); /*18473*/
				$k[$j++] = _3u; /*18473*/
				var _3y = $a(); /*18473*/
				$k[$j++] = _3y; /*18473*/
			}) /*18473*/
			$forall($1.C2vals, function() { /*18474*/
				$k[$j++] = Infinity; /*18474*/
				var _40 = $k[--$j]; /*18474*/
				var _41 = $k[--$j]; /*18474*/
				$k[$j++] = _40; /*18474*/
				$k[$j++] = $get($1.CNvals, $1.sft2); /*18474*/
				$k[$j++] = _41; /*18474*/
				var _45 = $a(); /*18474*/
				$k[$j++] = _45; /*18474*/
			}) /*18474*/
			$forall($1.C3vals, function() { /*18475*/
				$k[$j++] = Infinity; /*18475*/
				var _47 = $k[--$j]; /*18475*/
				var _48 = $k[--$j]; /*18475*/
				$k[$j++] = _47; /*18475*/
				$k[$j++] = $get($1.CNvals, $1.sft3); /*18475*/
				$k[$j++] = _48; /*18475*/
				var _4C = $a(); /*18475*/
				$k[$j++] = _4C; /*18475*/
			}) /*18475*/
			var _4D = $d(); /*18475*/
			$1[$k[--$j]] = _4D; /*18476*/
			$k[$j++] = "TNvals"; /*18484*/
			$k[$j++] = Infinity; /*18484*/
			$k[$j++] = $1.sft1; /*18483*/
			$k[$j++] = 0; /*18483*/
			$k[$j++] = $1.sft2; /*18483*/
			$k[$j++] = 1; /*18483*/
			$k[$j++] = $1.sft3; /*18483*/
			$k[$j++] = 2; /*18483*/
			$k[$j++] = 32; /*18483*/
			$k[$j++] = 3; /*18483*/
			for (var _4I = 48; _4I <= 57; _4I += 1) { /*18483*/
				$k[$j++] = _4I; /*18483*/
				$k[$j++] = _4I - 44; /*18483*/
			} /*18483*/
			for (var _4J = 97; _4J <= 122; _4J += 1) { /*18484*/
				$k[$j++] = _4J; /*18484*/
				$k[$j++] = _4J - 83; /*18484*/
			} /*18484*/
			var _4K = $d(); /*18484*/
			$1[$k[--$j]] = _4K; /*18485*/
			$k[$j++] = "T1vals"; /*18486*/
			$k[$j++] = Infinity; /*18486*/
			for (var _4M = 0; _4M <= 31; _4M += 1) { /*18486*/
				$k[$j++] = _4M; /*18486*/
				$k[$j++] = _4M; /*18486*/
			} /*18486*/
			var _4N = $d(); /*18486*/
			$1[$k[--$j]] = _4N; /*18486*/
			$k[$j++] = "T2vals"; /*18495*/
			$k[$j++] = Infinity; /*18495*/
			for (var _4P = 33; _4P <= 47; _4P += 1) { /*18488*/
				$k[$j++] = _4P; /*18488*/
				$k[$j++] = _4P - 33; /*18488*/
			} /*18488*/
			for (var _4Q = 58; _4Q <= 64; _4Q += 1) { /*18489*/
				$k[$j++] = _4Q; /*18489*/
				$k[$j++] = _4Q - 43; /*18489*/
			} /*18489*/
			for (var _4R = 91; _4R <= 95; _4R += 1) { /*18490*/
				$k[$j++] = _4R; /*18490*/
				$k[$j++] = _4R - 69; /*18490*/
			} /*18490*/
			$k[$j++] = $1.fnc1; /*18495*/
			$k[$j++] = 27; /*18495*/
			$k[$j++] = $1.fnc2; /*18495*/
			$k[$j++] = 28; /*18495*/
			$k[$j++] = $1.fnc3; /*18495*/
			$k[$j++] = 29; /*18495*/
			$k[$j++] = $1.fnc4; /*18495*/
			$k[$j++] = 30; /*18495*/
			$k[$j++] = $1.pad; /*18495*/
			$k[$j++] = 31; /*18495*/
			var _4X = $d(); /*18495*/
			$1[$k[--$j]] = _4X; /*18496*/
			$k[$j++] = "T3vals"; /*18500*/
			$k[$j++] = Infinity; /*18500*/
			$k[$j++] = 96; /*18499*/
			$k[$j++] = 0; /*18499*/
			for (var _4Z = 65; _4Z <= 90; _4Z += 1) { /*18499*/
				$k[$j++] = _4Z; /*18499*/
				$k[$j++] = _4Z - 64; /*18499*/
			} /*18499*/
			for (var _4a = 123; _4a <= 127; _4a += 1) { /*18500*/
				$k[$j++] = _4a; /*18500*/
				$k[$j++] = _4a - 96; /*18500*/
			} /*18500*/
			var _4b = $d(); /*18500*/
			$1[$k[--$j]] = _4b; /*18501*/
			$k[$j++] = "Tvals"; /*18506*/
			$k[$j++] = Infinity; /*18506*/
			$forall($1.TNvals, function() { /*18503*/
				$k[$j++] = Infinity; /*18503*/
				var _4e = $k[--$j]; /*18503*/
				var _4f = $k[--$j]; /*18503*/
				$k[$j++] = _4e; /*18503*/
				$k[$j++] = _4f; /*18503*/
				var _4g = $a(); /*18503*/
				$k[$j++] = _4g; /*18503*/
			}) /*18503*/
			$forall($1.T1vals, function() { /*18504*/
				$k[$j++] = Infinity; /*18504*/
				var _4i = $k[--$j]; /*18504*/
				var _4j = $k[--$j]; /*18504*/
				$k[$j++] = _4i; /*18504*/
				$k[$j++] = $get($1.TNvals, $1.sft1); /*18504*/
				$k[$j++] = _4j; /*18504*/
				var _4n = $a(); /*18504*/
				$k[$j++] = _4n; /*18504*/
			}) /*18504*/
			$forall($1.T2vals, function() { /*18505*/
				$k[$j++] = Infinity; /*18505*/
				var _4p = $k[--$j]; /*18505*/
				var _4q = $k[--$j]; /*18505*/
				$k[$j++] = _4p; /*18505*/
				$k[$j++] = $get($1.TNvals, $1.sft2); /*18505*/
				$k[$j++] = _4q; /*18505*/
				var _4u = $a(); /*18505*/
				$k[$j++] = _4u; /*18505*/
			}) /*18505*/
			$forall($1.T3vals, function() { /*18506*/
				$k[$j++] = Infinity; /*18506*/
				var _4w = $k[--$j]; /*18506*/
				var _4x = $k[--$j]; /*18506*/
				$k[$j++] = _4w; /*18506*/
				$k[$j++] = $get($1.TNvals, $1.sft3); /*18506*/
				$k[$j++] = _4x; /*18506*/
				var _51 = $a(); /*18506*/
				$k[$j++] = _51; /*18506*/
			}) /*18506*/
			var _52 = $d(); /*18506*/
			$1[$k[--$j]] = _52; /*18507*/
			for (var _54 = 128; _54 <= 255; _54 += 1) { /*18515*/
				$1.i = _54; /*18511*/
				$k[$j++] = $1.Avals; /*18512*/
				$k[$j++] = $1.i; /*18512*/
				$k[$j++] = Infinity; /*18512*/
				$aload($get($1.Avals, $1.fnc4)); /*18512*/
				$aload($get($1.Avals, $1.i - 128)); /*18512*/
				var _5D = $a(); /*18512*/
				var _5E = $k[--$j]; /*18512*/
				$put($k[--$j], _5E, _5D); /*18512*/
				$k[$j++] = $1.Cvals; /*18513*/
				$k[$j++] = $1.i; /*18513*/
				$k[$j++] = Infinity; /*18513*/
				$aload($get($1.Cvals, $1.fnc4)); /*18513*/
				$aload($get($1.Cvals, $1.i - 128)); /*18513*/
				var _5O = $a(); /*18513*/
				var _5P = $k[--$j]; /*18513*/
				$put($k[--$j], _5P, _5O); /*18513*/
				$k[$j++] = $1.Tvals; /*18514*/
				$k[$j++] = $1.i; /*18514*/
				$k[$j++] = Infinity; /*18514*/
				$aload($get($1.Tvals, $1.fnc4)); /*18514*/
				$aload($get($1.Tvals, $1.i - 128)); /*18514*/
				var _5Z = $a(); /*18514*/
				var _5a = $k[--$j]; /*18514*/
				$put($k[--$j], _5a, _5Z); /*18514*/
			} /*18514*/
			$k[$j++] = "Xvals"; /*18523*/
			$k[$j++] = Infinity; /*18523*/
			$k[$j++] = 13; /*18522*/
			$k[$j++] = 0; /*18522*/
			$k[$j++] = 42; /*18522*/
			$k[$j++] = 1; /*18522*/
			$k[$j++] = 62; /*18522*/
			$k[$j++] = 2; /*18522*/
			$k[$j++] = 32; /*18522*/
			$k[$j++] = 3; /*18522*/
			for (var _5c = 48; _5c <= 57; _5c += 1) { /*18522*/
				$k[$j++] = _5c; /*18522*/
				$k[$j++] = _5c - 44; /*18522*/
			} /*18522*/
			for (var _5d = 65; _5d <= 90; _5d += 1) { /*18523*/
				$k[$j++] = _5d; /*18523*/
				$k[$j++] = _5d - 51; /*18523*/
			} /*18523*/
			var _5e = $d(); /*18523*/
			$1[$k[--$j]] = _5e; /*18524*/
			$k[$j++] = "Xvals"; /*18526*/
			$k[$j++] = Infinity; /*18526*/
			$forall($1.Xvals, function() { /*18526*/
				$k[$j++] = Infinity; /*18526*/
				var _5h = $k[--$j]; /*18526*/
				var _5i = $k[--$j]; /*18526*/
				$k[$j++] = _5h; /*18526*/
				$k[$j++] = _5i; /*18526*/
				var _5j = $a(); /*18526*/
				$k[$j++] = _5j; /*18526*/
			}) /*18526*/
			var _5k = $d(); /*18526*/
			$1[$k[--$j]] = _5k; /*18527*/
			$k[$j++] = "Bvals"; /*18530*/
			$k[$j++] = Infinity; /*18530*/
			for (var _5m = 0; _5m <= 255; _5m += 1) { /*18530*/
				$k[$j++] = _5m; /*18530*/
				$k[$j++] = _5m; /*18530*/
			} /*18530*/
			var _5n = $d(); /*18530*/
			$1[$k[--$j]] = _5n; /*18531*/
			$k[$j++] = "Bvals"; /*18533*/
			$k[$j++] = Infinity; /*18533*/
			$forall($1.Bvals, function() { /*18533*/
				$k[$j++] = Infinity; /*18533*/
				var _5q = $k[--$j]; /*18533*/
				var _5r = $k[--$j]; /*18533*/
				$k[$j++] = _5q; /*18533*/
				$k[$j++] = _5r; /*18533*/
				var _5s = $a(); /*18533*/
				$k[$j++] = _5s; /*18533*/
			}) /*18533*/
			var _5t = $d(); /*18533*/
			$1[$k[--$j]] = _5t; /*18534*/
			$1.encvals = $a([$1.Avals, $1.Cvals, $1.Tvals, $1.Xvals, -1, $1.Bvals]); /*18536*/
			$k[$j++] = "numD"; /*18538*/
			$k[$j++] = Infinity; /*18538*/
			for (var _62 = 0, _63 = $1.msglen; _62 < _63; _62++) { /*18538*/
				$k[$j++] = 0; /*18538*/
			} /*18538*/
			$k[$j++] = 0; /*18538*/
			var _64 = $a(); /*18538*/
			$1[$k[--$j]] = _64; /*18538*/
			$k[$j++] = "nextXterm"; /*18539*/
			$k[$j++] = Infinity; /*18539*/
			for (var _67 = 0, _68 = $1.msglen; _67 < _68; _67++) { /*18539*/
				$k[$j++] = 0; /*18539*/
			} /*18539*/
			$k[$j++] = 9999; /*18539*/
			var _69 = $a(); /*18539*/
			$1[$k[--$j]] = _69; /*18539*/
			$k[$j++] = "nextNonX"; /*18540*/
			$k[$j++] = Infinity; /*18540*/
			for (var _6C = 0, _6D = $1.msglen; _6C < _6D; _6C++) { /*18540*/
				$k[$j++] = 0; /*18540*/
			} /*18540*/
			$k[$j++] = 9999; /*18540*/
			var _6E = $a(); /*18540*/
			$1[$k[--$j]] = _6E; /*18540*/
			for (var _6H = $1.msglen - 1; _6H >= 0; _6H -= 1) { /*18557*/
				$1.i = _6H; /*18542*/
				$1.barchar = $get($1.msg, $1.i); /*18543*/
				if (($1.barchar >= 48) && ($1.barchar <= 57)) { /*18546*/
					$put($1.numD, $1.i, $get($1.numD, $1.i + 1) + 1); /*18545*/
				} /*18545*/
				if ((($1.barchar == 13) || ($1.barchar == 42)) || ($1.barchar == 62)) { /*18550*/
					$put($1.nextXterm, $1.i, 0); /*18548*/
				} else { /*18550*/
					$put($1.nextXterm, $1.i, $get($1.nextXterm, $1.i + 1) + 1); /*18550*/
				} /*18550*/
				var _6e = $get($1.Xvals, $1.barchar) !== undefined; /*18552*/
				if (!_6e) { /*18555*/
					$put($1.nextNonX, $1.i, 0); /*18553*/
				} else { /*18555*/
					$put($1.nextNonX, $1.i, $get($1.nextNonX, $1.i + 1) + 1); /*18555*/
				} /*18555*/
			} /*18555*/
			$k[$j++] = "nextXterm"; /*18558*/
			$k[$j++] = Infinity; /*18558*/
			$forall($1.nextXterm, function() { /*18558*/
				var _6n = $k[--$j]; /*18558*/
				$k[$j++] = _6n; /*18558*/
				if (_6n > 10000) { /*18558*/
					$j--; /*18558*/
					$k[$j++] = 10000; /*18558*/
				} /*18558*/
			}) /*18558*/
			var _6o = $a(); /*18558*/
			$1[$k[--$j]] = _6o; /*18558*/
			$k[$j++] = "nextNonX"; /*18559*/
			$k[$j++] = Infinity; /*18559*/
			$forall($1.nextNonX, function() { /*18559*/
				var _6r = $k[--$j]; /*18559*/
				$k[$j++] = _6r; /*18559*/
				if (_6r > 10000) { /*18559*/
					$j--; /*18559*/
					$k[$j++] = 10000; /*18559*/
				} /*18559*/
			}) /*18559*/
			var _6s = $a(); /*18559*/
			$1[$k[--$j]] = _6s; /*18559*/
			$1.isD = function() {
				$k[$j++] = ($1.char >= 48) && ($1.char <= 57); /*18561*/
			}; /*18561*/
			$1.isC = function() {
				var _6y = $get($1.CNvals, $1.char) !== undefined; /*18562*/
				$k[$j++] = _6y; /*18562*/
			}; /*18562*/
			$1.isT = function() {
				var _71 = $get($1.TNvals, $1.char) !== undefined; /*18563*/
				$k[$j++] = _71; /*18563*/
			}; /*18563*/
			$1.isX = function() {
				var _74 = $get($1.Xvals, $1.char) !== undefined; /*18564*/
				$k[$j++] = _74; /*18564*/
			}; /*18564*/
			$1.isEA = function() {
				$k[$j++] = $1.char > 127; /*18565*/
			}; /*18565*/
			$1.isFN = function() {
				$k[$j++] = $1.char < 0; /*18566*/
			}; /*18566*/
			$1.XtermFirst = function() {
				var _77 = $k[--$j]; /*18567*/
				$k[$j++] = $lt($get($1.nextXterm, _77), $get($1.nextNonX, _77)); /*18567*/
			}; /*18567*/
			$1.A = 0; /*18569*/
			$1.C = 1; /*18569*/
			$1.T = 2; /*18569*/
			$1.X = 3; /*18569*/
			$1.D = 4; /*18569*/
			$1.B = 5; /*18569*/
			$1.lookup = function() {
				$1.ac = 1; /*18572*/
				$1.cc = 2; /*18572*/
				$1.tc = 2; /*18572*/
				$1.xc = 2; /*18572*/
				$1.bc = 3; /*18572*/
				if ($1.mode == $1.A) { /*18573*/
					$1.ac = 0; /*18573*/
					$1.cc = 1; /*18573*/
					$1.tc = 1; /*18573*/
					$1.xc = 1; /*18573*/
					$1.bc = 2; /*18573*/
				} /*18573*/
				if ($1.mode == $1.C) { /*18574*/
					$1.cc = 0; /*18574*/
				} /*18574*/
				if ($1.mode == $1.T) { /*18575*/
					$1.tc = 0; /*18575*/
				} /*18575*/
				if ($1.mode == $1.X) { /*18576*/
					$1.xc = 0; /*18576*/
				} /*18576*/
				if ($1.mode == $1.B) { /*18577*/
					$1.bc = 0; /*18577*/
				} /*18577*/
				for (var _7M = 0, _7N = 1; _7M < _7N; _7M++) { /*18605*/
					$1.k = 0; /*18579*/
					for (;;) { /*18604*/
						if (($1.i + $1.k) == $1.msglen) { /*18586*/
							var _7V = $a([$1.ac, $1.cc, $1.tc, $1.xc]); /*18581*/
							$k[$j++] = true; /*18581*/
							for (var _7W = 0, _7X = _7V.length; _7W < _7X; _7W++) { /*18581*/
								var _7a = $k[--$j]; /*18581*/
								$k[$j++] = _7a && ($1.bc <= Math.ceil($get(_7V, _7W))); /*18581*/
							} /*18581*/
							if ($k[--$j]) { /*18581*/
								$k[$j++] = $1.B; /*18581*/
								break; /*18581*/
							} /*18581*/
							var _7h = $a([$1.cc, $1.tc, $1.xc, $1.bc]); /*18582*/
							$k[$j++] = true; /*18582*/
							for (var _7i = 0, _7j = _7h.length; _7i < _7j; _7i++) { /*18582*/
								var _7m = $k[--$j]; /*18582*/
								$k[$j++] = _7m && ($1.ac <= Math.ceil($get(_7h, _7i))); /*18582*/
							} /*18582*/
							if ($k[--$j]) { /*18582*/
								$k[$j++] = $1.A; /*18582*/
								break; /*18582*/
							} /*18582*/
							var _7r = $a([$1.tc, $1.xc]); /*18583*/
							$k[$j++] = true; /*18583*/
							for (var _7s = 0, _7t = _7r.length; _7s < _7t; _7s++) { /*18583*/
								var _7w = $k[--$j]; /*18583*/
								$k[$j++] = _7w && (Math.ceil($1.cc) <= Math.ceil($get(_7r, _7s))); /*18583*/
							} /*18583*/
							if ($k[--$j]) { /*18583*/
								$k[$j++] = $1.C; /*18583*/
								break; /*18583*/
							} /*18583*/
							var _80 = $a([$1.xc]); /*18584*/
							$k[$j++] = true; /*18584*/
							for (var _81 = 0, _82 = _80.length; _81 < _82; _81++) { /*18584*/
								var _85 = $k[--$j]; /*18584*/
								$k[$j++] = _85 && (Math.ceil($1.tc) <= Math.ceil($get(_80, _81))); /*18584*/
							} /*18584*/
							if ($k[--$j]) { /*18584*/
								$k[$j++] = $1.T; /*18584*/
								break; /*18584*/
							} /*18584*/
							$k[$j++] = $1.X; /*18585*/
							break; /*18585*/
						} /*18585*/
						$1.char = $get($1.msg, $1.i + $1.k); /*18587*/
						$k[$j++] = "ac"; /*18588*/
						$k[$j++] = $1.ac; /*18588*/
						$1.isD(); /*18588*/
						if ($k[--$j]) { /*18588*/
							var _8F = $k[--$j]; /*18588*/
							$k[$j++] = _8F + (1 / 2); /*18588*/
						} else { /*18588*/
							$1.isEA(); /*18588*/
							if ($k[--$j]) { /*18588*/
								var _8H = $k[--$j]; /*18588*/
								$k[$j++] = Math.ceil(_8H) + 2; /*18588*/
							} else { /*18588*/
								var _8I = $k[--$j]; /*18588*/
								$k[$j++] = Math.ceil(_8I) + 1; /*18588*/
							} /*18588*/
						} /*18588*/
						var _8J = $k[--$j]; /*18588*/
						$1[$k[--$j]] = _8J; /*18588*/
						$k[$j++] = "cc"; /*18589*/
						$k[$j++] = $1.cc; /*18589*/
						$1.isC(); /*18589*/
						if ($k[--$j]) { /*18589*/
							var _8N = $k[--$j]; /*18589*/
							$k[$j++] = _8N + (2 / 3); /*18589*/
						} else { /*18589*/
							$1.isEA(); /*18589*/
							if ($k[--$j]) { /*18589*/
								var _8P = $k[--$j]; /*18589*/
								$k[$j++] = _8P + (8 / 3); /*18589*/
							} else { /*18589*/
								var _8Q = $k[--$j]; /*18589*/
								$k[$j++] = _8Q + (4 / 3); /*18589*/
							} /*18589*/
						} /*18589*/
						var _8R = $k[--$j]; /*18589*/
						$1[$k[--$j]] = _8R; /*18589*/
						$k[$j++] = "tc"; /*18590*/
						$k[$j++] = $1.tc; /*18590*/
						$1.isT(); /*18590*/
						if ($k[--$j]) { /*18590*/
							var _8V = $k[--$j]; /*18590*/
							$k[$j++] = _8V + (2 / 3); /*18590*/
						} else { /*18590*/
							$1.isEA(); /*18590*/
							if ($k[--$j]) { /*18590*/
								var _8X = $k[--$j]; /*18590*/
								$k[$j++] = _8X + (8 / 3); /*18590*/
							} else { /*18590*/
								var _8Y = $k[--$j]; /*18590*/
								$k[$j++] = _8Y + (4 / 3); /*18590*/
							} /*18590*/
						} /*18590*/
						var _8Z = $k[--$j]; /*18590*/
						$1[$k[--$j]] = _8Z; /*18590*/
						$k[$j++] = "xc"; /*18591*/
						$k[$j++] = $1.xc; /*18591*/
						$1.isX(); /*18591*/
						if ($k[--$j]) { /*18591*/
							var _8d = $k[--$j]; /*18591*/
							$k[$j++] = _8d + (2 / 3); /*18591*/
						} else { /*18591*/
							$1.isEA(); /*18591*/
							if ($k[--$j]) { /*18591*/
								var _8f = $k[--$j]; /*18591*/
								$k[$j++] = _8f + (13 / 3); /*18591*/
							} else { /*18591*/
								var _8g = $k[--$j]; /*18591*/
								$k[$j++] = _8g + (10 / 3); /*18591*/
							} /*18591*/
						} /*18591*/
						var _8h = $k[--$j]; /*18591*/
						$1[$k[--$j]] = _8h; /*18591*/
						$k[$j++] = "bc"; /*18592*/
						$k[$j++] = $1.bc; /*18592*/
						$1.isFN(); /*18592*/
						if ($k[--$j]) { /*18592*/
							var _8l = $k[--$j]; /*18592*/
							$k[$j++] = _8l + 3; /*18592*/
						} else { /*18592*/
							var _8m = $k[--$j]; /*18592*/
							$k[$j++] = _8m + 1; /*18592*/
						} /*18592*/
						var _8n = $k[--$j]; /*18592*/
						$1[$k[--$j]] = _8n; /*18592*/
						if ($1.k >= 3) { /*18602*/
							var _8u = $a([$1.ac, $1.cc, $1.tc, $1.xc]); /*18594*/
							$k[$j++] = true; /*18594*/
							for (var _8v = 0, _8w = _8u.length; _8v < _8w; _8v++) { /*18594*/
								var _8z = $k[--$j]; /*18594*/
								$k[$j++] = _8z && (($1.bc + 1) <= Math.ceil($get(_8u, _8v))); /*18594*/
							} /*18594*/
							if ($k[--$j]) { /*18594*/
								$k[$j++] = $1.B; /*18594*/
								break; /*18594*/
							} /*18594*/
							var _96 = $a([$1.cc, $1.tc, $1.xc, $1.bc]); /*18595*/
							$k[$j++] = true; /*18595*/
							for (var _97 = 0, _98 = _96.length; _97 < _98; _97++) { /*18595*/
								var _9B = $k[--$j]; /*18595*/
								$k[$j++] = _9B && (($1.ac + 1) <= Math.ceil($get(_96, _97))); /*18595*/
							} /*18595*/
							if ($k[--$j]) { /*18595*/
								$k[$j++] = $1.A; /*18595*/
								break; /*18595*/
							} /*18595*/
							var _9I = $a([$1.ac, $1.cc, $1.xc, $1.bc]); /*18596*/
							$k[$j++] = true; /*18596*/
							for (var _9J = 0, _9K = _9I.length; _9J < _9K; _9J++) { /*18596*/
								var _9N = $k[--$j]; /*18596*/
								$k[$j++] = _9N && (($1.tc + 1) <= Math.ceil($get(_9I, _9J))); /*18596*/
							} /*18596*/
							if ($k[--$j]) { /*18596*/
								$k[$j++] = $1.T; /*18596*/
								break; /*18596*/
							} /*18596*/
							var _9S = $a([$1.ac, $1.tc]); /*18597*/
							$k[$j++] = true; /*18597*/
							for (var _9T = 0, _9U = _9S.length; _9T < _9U; _9T++) { /*18597*/
								var _9X = $k[--$j]; /*18597*/
								$k[$j++] = _9X && (($1.cc + 1) <= Math.ceil($get(_9S, _9T))); /*18597*/
							} /*18597*/
							if ($k[--$j]) { /*18600*/
								if (Math.ceil($1.cc) < Math.ceil($1.xc)) { /*18598*/
									$k[$j++] = $1.C; /*18598*/
									break; /*18598*/
								} /*18598*/
								if ($1.cc == $1.xc) { /*18599*/
									$k[$j++] = ($1.i + $1.k) + 1; /*18599*/
									$1.XtermFirst(); /*18599*/
									if ($k[--$j]) { /*18599*/
										$k[$j++] = $1.X; /*18599*/
										break; /*18599*/
									} else { /*18599*/
										$k[$j++] = $1.C; /*18599*/
										break; /*18599*/
									} /*18599*/
								} /*18599*/
							} /*18599*/
							var _9n = $a([$1.ac, $1.cc, $1.tc, $1.bc]); /*18601*/
							$k[$j++] = true; /*18601*/
							for (var _9o = 0, _9p = _9n.length; _9o < _9p; _9o++) { /*18601*/
								var _9s = $k[--$j]; /*18601*/
								$k[$j++] = _9s && (($1.xc + 1) < $get(_9n, _9o)); /*18601*/
							} /*18601*/
							if ($k[--$j]) { /*18601*/
								$k[$j++] = $1.X; /*18601*/
								break; /*18601*/
							} /*18601*/
						} /*18601*/
						$1.k = $1.k + 1; /*18603*/
					} /*18603*/
				} /*18603*/
			}; /*18606*/
			$1.addtocws = function() {
				var _9w = $k[--$j]; /*18609*/
				$puti($1.cws, $1.j, _9w); /*18609*/
				$1.j = _9w.length + $1.j; /*18610*/
			}; /*18611*/
			$1.tobin = function() {
				var _A1 = $s($k[--$j]); /*18614*/
				$k[$j++] = _A1; /*18614*/
				for (var _A3 = 0, _A2 = _A1.length - 1; _A3 <= _A2; _A3 += 1) { /*18614*/
					var _A4 = $k[--$j]; /*18614*/
					$put(_A4, _A3, 48); /*18614*/
					$k[$j++] = _A4; /*18614*/
				} /*18614*/
				var _A5 = $k[--$j]; /*18615*/
				var _A8 = $cvrs($s(_A5.length), $k[--$j], 2); /*18615*/
				$puti(_A5, _A5.length - _A8.length, _A8); /*18615*/
				$k[$j++] = _A5; /*18616*/
				$k[$j++] = Infinity; /*18616*/
				var _A9 = $k[--$j]; /*18616*/
				var _AA = $k[--$j]; /*18616*/
				$k[$j++] = _A9; /*18616*/
				$forall(_AA, function() { /*18616*/
					var _AB = $k[--$j]; /*18616*/
					$k[$j++] = _AB - 48; /*18616*/
				}) /*18616*/
				var _AC = $a(); /*18616*/
				$k[$j++] = _AC; /*18616*/
			}; /*18617*/
			$1.encA = function() {
				for (var _AD = 0, _AE = 1; _AD < _AE; _AD++) { /*18661*/
					if ($get($1.numD, $1.i) >= 21) { /*18625*/
						$1.Dbits = $a([1, 1, 1, 1]); /*18622*/
						$1.mode = $1.D; /*18623*/
						break; /*18624*/
					} /*18624*/
					var _AM = $get($1.numD, $1.i); /*18626*/
					if ((_AM >= 13) && ((_AM + $1.i) == $1.msglen)) { /*18630*/
						$1.Dbits = $a([1, 1, 1, 1]); /*18627*/
						$1.mode = $1.D; /*18628*/
						break; /*18629*/
					} /*18629*/
					if ($get($1.numD, $1.i) >= 2) { /*18635*/
						var _AU = $s(2); /*18632*/
						$put(_AU, 0, $get($1.msg, $1.i)); /*18632*/
						$put(_AU, 1, $get($1.msg, $1.i + 1)); /*18632*/
						$k[$j++] = $get($1.Avals, _AU); /*18632*/
						$1.addtocws(); /*18632*/
						$1.i = $1.i + 2; /*18633*/
						break; /*18634*/
					} /*18634*/
					if ($get($1.msg, $1.i) == $1.fnc1) { /*18651*/
						if ($get($1.numD, $1.i + 1) >= 15) { /*18643*/
							$k[$j++] = $get($1.Avals, $1.fnc1lD); /*18638*/
							$1.addtocws(); /*18638*/
							$1.i = $1.i + 1; /*18639*/
							$1.Dbits = $a([]); /*18640*/
							$1.mode = $1.D; /*18641*/
							break; /*18642*/
						} /*18642*/
						var _At = $get($1.numD, $1.i + 1); /*18644*/
						if ((_At >= 7) && (((_At + $1.i) + 1) == $1.msglen)) { /*18650*/
							$k[$j++] = $get($1.Avals, $1.fnc1lD); /*18645*/
							$1.addtocws(); /*18645*/
							$1.i = $1.i + 1; /*18646*/
							$1.Dbits = $a([]); /*18647*/
							$1.mode = $1.D; /*18648*/
							break; /*18649*/
						} /*18649*/
					} /*18649*/
					$k[$j++] = "newmode"; /*18652*/
					$1.lookup(); /*18652*/
					var _B2 = $k[--$j]; /*18652*/
					$1[$k[--$j]] = _B2; /*18652*/
					if ($1.newmode != $1.mode) { /*18657*/
						$k[$j++] = $get($1.Avals, $get($a([-1, $1.lC, $1.lT, $1.lX, $1.lD, $1.lB]), $1.newmode)); /*18654*/
						$1.addtocws(); /*18654*/
						$1.mode = $1.newmode; /*18655*/
						break; /*18656*/
					} /*18656*/
					$k[$j++] = $get($1.Avals, $get($1.msg, $1.i)); /*18658*/
					$1.addtocws(); /*18658*/
					$1.i = $1.i + 1; /*18659*/
					break; /*18660*/
				} /*18660*/
			}; /*18662*/
			$1.CTXvalstocws = function() {
				$1.in = $k[--$j]; /*18665*/
				$k[$j++] = Infinity; /*18666*/
				for (var _BQ = 0, _BP = $1.in.length - 1; _BQ <= _BP; _BQ += 3) { /*18670*/
					$k[$j++] = 0; /*18668*/
					$forall($geti($1.in, _BQ, 3), function() { /*18668*/
						var _BT = $k[--$j]; /*18668*/
						var _BU = $k[--$j]; /*18668*/
						$k[$j++] = (_BU + _BT) * 40; /*18668*/
					}) /*18668*/
					var _BW = (~~($k[--$j] / 40)) + 1; /*18669*/
					$k[$j++] = ~~(_BW / 256); /*18669*/
					$k[$j++] = _BW % 256; /*18669*/
				} /*18669*/
				$astore($a($counttomark())); /*18671*/
				var _BZ = $k[--$j]; /*18671*/
				var _Ba = $k[--$j]; /*18671*/
				$k[$j++] = _BZ; /*18671*/
			}; /*18672*/
			$1.encCTX = function() {
				$1.p = 0; /*18675*/
				$1.ctxvals = $a(2220); /*18676*/
				for (;;) { /*18754*/
					if ($1.i == $1.msglen) { /*18680*/
						break; /*18680*/
					} /*18680*/
					var _Bk = $get($get($1.encvals, $1.mode), $get($1.msg, $1.i)) !== undefined; /*18681*/
					if (!_Bk) { /*18681*/
						break; /*18681*/
					} /*18681*/
					if (($1.p % 3) == 0) { /*18749*/
						if ($get($1.numD, $1.i) >= 12) { /*18687*/
							$k[$j++] = $a([$1.unlcw]); /*18684*/
							$1.addtocws(); /*18684*/
							$1.mode = $1.A; /*18685*/
							break; /*18686*/
						} /*18686*/
						var _Bu = $get($1.numD, $1.i); /*18688*/
						if ((_Bu >= 8) && ((_Bu + $1.i) == $1.msglen)) { /*18692*/
							$k[$j++] = $a([$1.unlcw]); /*18689*/
							$1.addtocws(); /*18689*/
							$1.mode = $1.A; /*18690*/
							break; /*18691*/
						} /*18691*/
						$1.lookup(); /*18693*/
						if ($k[--$j] != $1.mode) { /*18698*/
							$k[$j++] = $geti($1.ctxvals, 0, $1.p); /*18694*/
							$1.CTXvalstocws(); /*18694*/
							$1.addtocws(); /*18694*/
							$k[$j++] = $a([$1.unlcw]); /*18695*/
							$1.addtocws(); /*18695*/
							$1.mode = $1.A; /*18696*/
							break; /*18697*/
						} /*18697*/
						if (($1.msglen - $1.i) <= 3) { /*18748*/
							$1.remcws = $get($1.numremcws, $1.j + ((~~($1.p / 3)) * 2)); /*18700*/
							$k[$j++] = "remvals"; /*18706*/
							$k[$j++] = Infinity; /*18706*/
							$forall($geti($1.msg, $1.i, $1.msglen - $1.i), function() { /*18708*/
								var _CJ = $k[--$j]; /*18703*/
								var _CN = $get($get($1.encvals, $1.mode), _CJ) !== undefined; /*18703*/
								$k[$j++] = _CJ; /*18707*/
								if (_CN) { /*18706*/
									$aload($get($get($1.encvals, $1.mode), $k[--$j])); /*18704*/
								} else { /*18706*/
									$j--; /*18706*/
									$k[$j++] = -1; /*18706*/
									$k[$j++] = -1; /*18706*/
									$k[$j++] = -1; /*18706*/
									$k[$j++] = -1; /*18706*/
								} /*18706*/
							}) /*18706*/
							var _CT = $a(); /*18706*/
							$1[$k[--$j]] = _CT; /*18709*/
							if (($1.remcws == 2) && ($1.remvals.length == 3)) { /*18719*/
								$k[$j++] = Infinity; /*18714*/
								$aload($geti($1.ctxvals, 0, $1.p)); /*18713*/
								$aload($1.remvals); /*18714*/
								var _Cb = $a(); /*18714*/
								$k[$j++] = _Cb; /*18715*/
								$1.CTXvalstocws(); /*18715*/
								$1.addtocws(); /*18715*/
								$1.mode = $1.A; /*18716*/
								$1.i = $1.msglen; /*18717*/
								break; /*18718*/
							} /*18718*/
							if ((($1.remcws == 2) && ($1.remvals.length == 2)) && ($1.mode != $1.X)) { /*18730*/
								$k[$j++] = Infinity; /*18725*/
								$aload($geti($1.ctxvals, 0, $1.p)); /*18723*/
								$aload($1.remvals); /*18724*/
								$aload($get($get($1.encvals, $1.mode), $1.sft1)); /*18725*/
								var _Cr = $a(); /*18725*/
								$k[$j++] = _Cr; /*18726*/
								$1.CTXvalstocws(); /*18726*/
								$1.addtocws(); /*18726*/
								$1.mode = $1.A; /*18727*/
								$1.i = $1.msglen; /*18728*/
								break; /*18729*/
							} /*18729*/
							if (($1.remcws == 2) && ($1.remvals.length == 1)) { /*18739*/
								$k[$j++] = $geti($1.ctxvals, 0, $1.p); /*18733*/
								$1.CTXvalstocws(); /*18733*/
								$1.addtocws(); /*18733*/
								$k[$j++] = $a([$1.unlcw]); /*18734*/
								$1.addtocws(); /*18734*/
								$k[$j++] = $get($1.Avals, $get($1.msg, $1.i)); /*18735*/
								$1.addtocws(); /*18735*/
								$1.mode = $1.A; /*18736*/
								$1.i = $1.msglen; /*18737*/
								break; /*18738*/
							} /*18738*/
							if (($1.remcws == 1) && ($1.remvals.length == 1)) { /*18747*/
								$k[$j++] = $geti($1.ctxvals, 0, $1.p); /*18742*/
								$1.CTXvalstocws(); /*18742*/
								$1.addtocws(); /*18742*/
								$k[$j++] = $get($1.Avals, $get($1.msg, $1.i)); /*18743*/
								$1.addtocws(); /*18743*/
								$1.mode = $1.A; /*18744*/
								$1.i = $1.msglen; /*18745*/
								break; /*18746*/
							} /*18746*/
						} /*18746*/
					} /*18746*/
					var _DQ = $get($get($1.encvals, $1.mode), $get($1.msg, $1.i)); /*18750*/
					$puti($1.ctxvals, $1.p, _DQ); /*18751*/
					$1.p = _DQ.length + $1.p; /*18752*/
					$1.i = $1.i + 1; /*18753*/
				} /*18753*/
				if ($1.mode != $1.A) { /*18778*/
					for (;;) { /*18762*/
						if (($1.p % 3) == 0) { /*18759*/
							break; /*18759*/
						} /*18759*/
						$1.i = $1.i - 1; /*18760*/
						$1.p = $1.p - $get($get($1.encvals, $1.mode), $get($1.msg, $1.i)).length; /*18761*/
					} /*18761*/
					$k[$j++] = Infinity; /*18764*/
					$aload($geti($1.ctxvals, 0, $1.p)); /*18764*/
					var _Dk = $a(); /*18764*/
					$k[$j++] = _Dk; /*18765*/
					$1.CTXvalstocws(); /*18765*/
					$1.addtocws(); /*18765*/
					$k[$j++] = $a([$1.unlcw]); /*18766*/
					$1.addtocws(); /*18766*/
					$1.mode = $1.A; /*18767*/
					if ($1.i != $1.msglen) { /*18777*/
						if ($get($1.numD, $1.i) >= 2) { /*18775*/
							var _Dt = $s(2); /*18771*/
							$put(_Dt, 0, $get($1.msg, $1.i)); /*18771*/
							$put(_Dt, 1, $get($1.msg, $1.i + 1)); /*18771*/
							$k[$j++] = $get($1.Avals, _Dt); /*18771*/
							$1.addtocws(); /*18771*/
							$1.i = $1.i + 2; /*18772*/
						} else { /*18775*/
							$k[$j++] = $get($1.Avals, $get($1.msg, $1.i)); /*18774*/
							$1.addtocws(); /*18774*/
							$1.i = $1.i + 1; /*18775*/
						} /*18775*/
					} /*18775*/
				} /*18775*/
			}; /*18780*/
			$1.encD = function() {
				for (;;) { /*18833*/
					if ($get($1.numD, $1.i) < 3) { /*18823*/
						$1.Drem = (8 - ($1.Dbits.length % 8)) % 8; /*18788*/
						$1.remcws = $get($1.numremcws, $1.j + (~~($1.Dbits.length / 8))); /*18789*/
						if ((($get($1.numremcws, ($1.j + (~~($1.Dbits.length / 8))) - 1) - 1) == 0) && ($1.i == $1.msglen)) { /*18793*/
							break; /*18793*/
						} /*18793*/
						if (((($1.i == ($1.msglen - 1)) && ($get($1.numD, $1.i) == 1)) && ($1.remcws == 1)) && ($1.Drem == 0)) { /*18797*/
							break; /*18797*/
						} /*18797*/
						if (!(((($1.i == ($1.msglen - 1)) && ($get($1.numD, $1.i) == 1)) && ($1.remcws == 1)) && (($1.Drem == 4) || ($1.Drem == 6)))) { /*18804*/
							$k[$j++] = "Dbits"; /*18802*/
							$k[$j++] = Infinity; /*18802*/
							$aload($1.Dbits); /*18802*/
							$k[$j++] = 1; /*18802*/
							$k[$j++] = 1; /*18802*/
							$k[$j++] = 1; /*18802*/
							$k[$j++] = 1; /*18802*/
							$k[$j++] = 1; /*18802*/
							$k[$j++] = 1; /*18802*/
							var _Ed = $a(); /*18802*/
							$1[$k[--$j]] = _Ed; /*18802*/
							$1.Drem = (8 - ($1.Dbits.length % 8)) % 8; /*18803*/
						} /*18803*/
						if (($1.Drem == 4) || ($1.Drem == 6)) { /*18815*/
							if ($get($1.numD, $1.i) >= 1) { /*18812*/
								$k[$j++] = "Dbits"; /*18809*/
								$k[$j++] = Infinity; /*18809*/
								$aload($1.Dbits); /*18809*/
								$k[$j++] = ($get($1.msg, $1.i) - 48) + 1; /*18809*/
								$k[$j++] = 4; /*18809*/
								$1.tobin(); /*18809*/
								$aload($k[--$j]); /*18809*/
								var _Eq = $a(); /*18809*/
								$1[$k[--$j]] = _Eq; /*18809*/
								$1.i = $1.i + 1; /*18810*/
							} else { /*18812*/
								$k[$j++] = "Dbits"; /*18812*/
								$k[$j++] = Infinity; /*18812*/
								$aload($1.Dbits); /*18812*/
								$k[$j++] = 1; /*18812*/
								$k[$j++] = 1; /*18812*/
								$k[$j++] = 1; /*18812*/
								$k[$j++] = 1; /*18812*/
								var _Eu = $a(); /*18812*/
								$1[$k[--$j]] = _Eu; /*18812*/
							} /*18812*/
							$1.Drem = $1.Drem - 4; /*18814*/
						} /*18814*/
						if ($1.Drem == 2) { /*18819*/
							$k[$j++] = "Dbits"; /*18817*/
							$k[$j++] = Infinity; /*18817*/
							$aload($1.Dbits); /*18817*/
							$k[$j++] = 0; /*18817*/
							$k[$j++] = 1; /*18817*/
							var _Ez = $a(); /*18817*/
							$1[$k[--$j]] = _Ez; /*18817*/
							$1.Drem = 0; /*18818*/
						} /*18818*/
						break; /*18821*/
					} /*18821*/
					$k[$j++] = "Dbits"; /*18829*/
					$k[$j++] = Infinity; /*18829*/
					$aload($1.Dbits); /*18827*/
					$k[$j++] = 0; /*18828*/
					$forall($geti($1.msg, $1.i, 3), function() { /*18828*/
						var _F5 = $k[--$j]; /*18828*/
						var _F6 = $k[--$j]; /*18828*/
						$k[$j++] = (_F6 + (_F5 - 48)) * 10; /*18828*/
					}) /*18828*/
					var _F7 = $k[--$j]; /*18828*/
					$k[$j++] = (~~(_F7 / 10)) + 1; /*18829*/
					$k[$j++] = 10; /*18829*/
					$1.tobin(); /*18829*/
					$aload($k[--$j]); /*18829*/
					var _F9 = $a(); /*18829*/
					$1[$k[--$j]] = _F9; /*18830*/
					$1.i = $1.i + 3; /*18831*/
				} /*18831*/
				$k[$j++] = Infinity; /*18835*/
				for (var _FE = 0, _FD = $1.Dbits.length - 1; _FE <= _FD; _FE += 8) { /*18838*/
					$k[$j++] = 0; /*18837*/
					$forall($geti($1.Dbits, _FE, 8), function() { /*18837*/
						var _FH = $k[--$j]; /*18837*/
						var _FI = $k[--$j]; /*18837*/
						$k[$j++] = (_FI + _FH) * 2; /*18837*/
					}) /*18837*/
					var _FJ = $k[--$j]; /*18837*/
					$k[$j++] = ~~(_FJ / 2); /*18837*/
				} /*18837*/
				$astore($a($counttomark())); /*18839*/
				var _FM = $k[--$j]; /*18839*/
				var _FN = $k[--$j]; /*18839*/
				$k[$j++] = _FM; /*18839*/
				$1.addtocws(); /*18839*/
				$1.mode = $1.A; /*18840*/
			}; /*18842*/
			$1.encB = function() {
				$1.p = 0; /*18845*/
				$1.bvals = $a(1480); /*18845*/
				for (;;) { /*18852*/
					if ($1.i == $1.msglen) { /*18846*/
						break; /*18846*/
					} /*18846*/
					if ($get($1.msg, $1.i) < 0) { /*18847*/
						break; /*18847*/
					} /*18847*/
					$1.lookup(); /*18848*/
					if ($k[--$j] != $1.mode) { /*18848*/
						break; /*18848*/
					} /*18848*/
					$put($1.bvals, $1.p, $get($1.msg, $1.i)); /*18849*/
					$1.p = $1.p + 1; /*18850*/
					$1.i = $1.i + 1; /*18851*/
				} /*18851*/
				$1.remcws = $get($1.numremcws, $1.j + $1.p) - 1; /*18853*/
				$k[$j++] = "bvals"; /*18860*/
				$k[$j++] = Infinity; /*18860*/
				if (($1.remcws == 0) && ($1.i == $1.msglen)) { /*18858*/
					$k[$j++] = 0; /*18856*/
				} else { /*18858*/
					if ($1.p < 250) { /*18858*/
						$k[$j++] = $1.p; /*18858*/
					} else { /*18858*/
						$k[$j++] = (~~($1.p / 250)) + 249; /*18858*/
						$k[$j++] = $1.p % 250; /*18858*/
					} /*18858*/
				} /*18858*/
				$aload($geti($1.bvals, 0, $1.p)); /*18860*/
				var _Fs = $a(); /*18860*/
				$1[$k[--$j]] = _Fs; /*18861*/
				$k[$j++] = $1.bvals; /*18862*/
				$1.addtocws(); /*18862*/
				$1.mode = $1.A; /*18863*/
			}; /*18864*/
			$1.cws = $a(1480); /*18867*/
			$1.mode = $1.A; /*18868*/
			$1.i = 0; /*18868*/
			$1.j = 0; /*18868*/
			for (;;) { /*18871*/
				if ($1.i >= $1.msglen) { /*18869*/
					break; /*18869*/
				} /*18869*/
				$1[$get($a(["encA", "encCTX", "encCTX", "encCTX", "encD", "encB"]), $1.mode)](); /*18870*/
			} /*18870*/
			$1.cws = $geti($1.cws, 0, $1.j); /*18872*/
		} /*18872*/
		$1.i = 0; /*18877*/
		for (;;) { /*18897*/
			$1.m = $get($1.metrics, $1.i); /*18879*/
			$1.vers = $get($1.m, 0); /*18880*/
			$1.rows = $get($1.m, 1); /*18881*/
			$1.cols = $get($1.m, 2); /*18882*/
			$1.dcol = $get($1.m, 3); /*18883*/
			$1.dcws = $get($1.m, 4); /*18884*/
			$1.rscw = $get($1.m, 5); /*18885*/
			$1.rsbl = $get($1.m, 6); /*18886*/
			$1.riso = $get($1.m, 7); /*18887*/
			$1.risi = $get($1.m, 8); /*18888*/
			$1.risl = $get($1.m, 9); /*18889*/
			$1.dcpb = ~~($1.dcws / $1.rsbl); /*18890*/
			$1.ecpb = ~~($1.rscw / $1.rsbl); /*18891*/
			$1.okay = true; /*18892*/
			if ($ne($1.version, "unset") && $ne($1.version, $1.vers)) { /*18893*/
				$1.okay = false; /*18893*/
			} /*18893*/
			if ($1.cws.length > $1.dcws) { /*18894*/
				$1.okay = false; /*18894*/
			} /*18894*/
			if ($1.okay) { /*18895*/
				break; /*18895*/
			} /*18895*/
			$1.i = $1.i + 1; /*18896*/
		} /*18896*/
		if (!$1.stype) { /*18903*/
			$k[$j++] = "cws"; /*18901*/
			$k[$j++] = Infinity; /*18901*/
			$aload($1.cws); /*18901*/
			for (var _Gj = 0, _Gk = $1.dcws - $1.cws.length; _Gj < _Gk; _Gj++) { /*18901*/
				$k[$j++] = 129; /*18901*/
			} /*18901*/
			var _Gl = $a(); /*18901*/
			$1[$k[--$j]] = _Gl; /*18901*/
		} else { /*18903*/
			$k[$j++] = "cws"; /*18903*/
			$k[$j++] = Infinity; /*18903*/
			for (var _Gp = 0, _Gq = $1.dcws - $1.cws.length; _Gp < _Gq; _Gp++) { /*18903*/
				$k[$j++] = 0; /*18903*/
			} /*18903*/
			$aload($1.cws); /*18903*/
			var _Gs = $a(); /*18903*/
			$1[$k[--$j]] = _Gs; /*18903*/
		} /*18903*/
		$1.cwbs = $a($1.rsbl); /*18907*/
		$1.ecbs = $a($1.rsbl); /*18908*/
		for (var _H0 = 0, _Gz = $1.rsbl - 1; _H0 <= _Gz; _H0 += 1) { /*18917*/
			$1.i = _H0; /*18910*/
			$1.cwb = $a($1.dcpb); /*18911*/
			for (var _H5 = 0, _H4 = $1.dcpb - 1; _H5 <= _H4; _H5 += 1) { /*18915*/
				$1.j = _H5; /*18913*/
				$put($1.cwb, $1.j, $get($1.cws, ($1.j * $1.rsbl) + $1.i)); /*18914*/
			} /*18914*/
			$put($1.cwbs, $1.i, $1.cwb); /*18916*/
		} /*18916*/
		var _HH = $1.stype ? 32 : 256; /*18920*/
		$1.gf = _HH; /*18920*/
		$1["gf-1"] = $1.gf - 1; /*18921*/
		var _HK = $1.stype ? 37 : 301; /*18922*/
		$1.pm = _HK; /*18922*/
		$k[$j++] = "rsalog"; /*18923*/
		$k[$j++] = Infinity; /*18923*/
		$k[$j++] = 1; /*18923*/
		for (var _HM = 0, _HN = $1["gf-1"]; _HM < _HN; _HM++) { /*18923*/
			var _HO = $k[--$j]; /*18923*/
			var _HP = _HO * 2; /*18923*/
			$k[$j++] = _HO; /*18923*/
			$k[$j++] = _HP; /*18923*/
			if (_HP >= $1.gf) { /*18923*/
				var _HS = $k[--$j]; /*18923*/
				$k[$j++] = _HS ^ $1.pm; /*18923*/
			} /*18923*/
		} /*18923*/
		var _HT = $a(); /*18923*/
		$1[$k[--$j]] = _HT; /*18923*/
		$1.rslog = $a($1.gf); /*18924*/
		for (var _HZ = 1, _HY = $1["gf-1"]; _HZ <= _HY; _HZ += 1) { /*18925*/
			$put($1.rslog, $get($1.rsalog, _HZ), _HZ); /*18925*/
		} /*18925*/
		$1.rsprod = function() {
			var _Hd = $k[--$j]; /*18927*/
			var _He = $k[--$j]; /*18927*/
			$k[$j++] = _He; /*18931*/
			$k[$j++] = _Hd; /*18931*/
			if ((_Hd != 0) && (_He != 0)) { /*18930*/
				var _Hh = $get($1.rslog, $k[--$j]); /*18928*/
				var _Hn = $get($1.rsalog, (_Hh + $get($1.rslog, $k[--$j])) % $1["gf-1"]); /*18928*/
				$k[$j++] = _Hn; /*18928*/
			} else { /*18930*/
				$j -= 2; /*18930*/
				$k[$j++] = 0; /*18930*/
			} /*18930*/
		}; /*18932*/
		$k[$j++] = "coeffs"; /*18935*/
		$k[$j++] = Infinity; /*18935*/
		$k[$j++] = 1; /*18935*/
		for (var _Hp = 0, _Hq = $1.ecpb; _Hp < _Hq; _Hp++) { /*18935*/
			$k[$j++] = 0; /*18935*/
		} /*18935*/
		var _Hr = $a(); /*18935*/
		$1[$k[--$j]] = _Hr; /*18935*/
		for (var _Hv = 0, _Hu = $1.ecpb - 1; _Hv <= _Hu; _Hv += 1) { /*18944*/
			$1.i = _Hv; /*18937*/
			$put($1.coeffs, $1.i + 1, $get($1.coeffs, $1.i)); /*18938*/
			for (var _I2 = $1.i; _I2 >= 1; _I2 -= 1) { /*18942*/
				$1.j = _I2; /*18940*/
				$k[$j++] = $1.coeffs; /*18941*/
				$k[$j++] = $1.j; /*18941*/
				$k[$j++] = $get($1.coeffs, $1.j - 1); /*18941*/
				$k[$j++] = $get($1.coeffs, $1.j); /*18941*/
				$k[$j++] = $get($1.rsalog, $1.i); /*18941*/
				$1.rsprod(); /*18941*/
				var _IE = $k[--$j]; /*18941*/
				var _IF = $k[--$j]; /*18941*/
				var _IG = $k[--$j]; /*18941*/
				$put($k[--$j], _IG, $xo(_IF, _IE)); /*18941*/
			} /*18941*/
			$k[$j++] = $1.coeffs; /*18943*/
			$k[$j++] = 0; /*18943*/
			$k[$j++] = $get($1.coeffs, 0); /*18943*/
			$k[$j++] = $get($1.rsalog, $1.i); /*18943*/
			$1.rsprod(); /*18943*/
			var _IO = $k[--$j]; /*18943*/
			var _IP = $k[--$j]; /*18943*/
			$put($k[--$j], _IP, _IO); /*18943*/
		} /*18943*/
		$1.coeffs = $geti($1.coeffs, 0, $1.coeffs.length - 1); /*18945*/
		for (var _IW = 0, _IV = $1.cwbs.length - 1; _IW <= _IV; _IW += 1) { /*18960*/
			$1.i = _IW; /*18949*/
			$k[$j++] = "rscws"; /*18950*/
			$k[$j++] = Infinity; /*18950*/
			$aload($get($1.cwbs, $1.i)); /*18950*/
			for (var _Ib = 0, _Ic = $1.ecpb; _Ib < _Ic; _Ib++) { /*18950*/
				$k[$j++] = 0; /*18950*/
			} /*18950*/
			var _Id = $a(); /*18950*/
			$1[$k[--$j]] = _Id; /*18950*/
			for (var _Ih = 0, _Ig = $1.dcpb - 1; _Ih <= _Ig; _Ih += 1) { /*18958*/
				$1.m = _Ih; /*18952*/
				$1.k = $get($1.rscws, $1.m); /*18953*/
				for (var _In = 0, _Im = $1.ecpb - 1; _In <= _Im; _In += 1) { /*18957*/
					$1.j = _In; /*18955*/
					$k[$j++] = $1.rscws; /*18956*/
					$k[$j++] = ($1.m + $1.j) + 1; /*18956*/
					$k[$j++] = $get($1.coeffs, ($1.ecpb - $1.j) - 1); /*18956*/
					$k[$j++] = $1.k; /*18956*/
					$1.rsprod(); /*18956*/
					var _J0 = $k[--$j]; /*18956*/
					var _J1 = $k[--$j]; /*18956*/
					$put($k[--$j], _J1, $xo(_J0, $get($1.rscws, ($1.m + $1.j) + 1))); /*18956*/
				} /*18956*/
			} /*18956*/
			$put($1.ecbs, $1.i, $geti($1.rscws, $1.dcpb, $1.ecpb)); /*18959*/
		} /*18959*/
		$k[$j++] = "cws"; /*18963*/
		$k[$j++] = Infinity; /*18963*/
		$aload($1.cws); /*18963*/
		for (var _JB = 0, _JC = $1.rscw; _JB < _JC; _JB++) { /*18963*/
			$k[$j++] = 0; /*18963*/
		} /*18963*/
		var _JD = $a(); /*18963*/
		$1[$k[--$j]] = _JD; /*18963*/
		for (var _JH = 0, _JG = $1.rscw - 1; _JH <= _JG; _JH += 1) { /*18967*/
			$1.i = _JH; /*18965*/
			$put($1.cws, $1.dcws + $1.i, $get($get($1.ecbs, $1.i % $1.rsbl), ~~($1.i / $1.rsbl))); /*18966*/
		} /*18966*/
		var _JV = $1.stype ? 5 : 8; /*18970*/
		$1.mmat = $a(($1.dcws + $1.rscw) * _JV); /*18970*/
		$1.r = 0; /*18971*/
		$1.c = 0; /*18971*/
		var _JY = $1.stype ? 2 : 1; /*18972*/
		for (var _Jb = 0, _Jc = _JY, _Ja = $1.cws.length - 1; _Jc < 0 ? _Jb >= _Ja : _Jb <= _Ja; _Jb += _Jc) { /*18993*/
			$1.i = _Jb; /*18973*/
			if (!$1.stype) { /*18987*/
				var _Jf = $strcpy($s(8), "00000000"); /*18975*/
				var _Jk = $cvrs($s(8), $get($1.cws, $1.i), 2); /*18975*/
				$puti(_Jf, 8 - _Jk.length, _Jk); /*18976*/
				$k[$j++] = _Jf; /*18976*/
				$k[$j++] = Infinity; /*18976*/
				var _Jl = $k[--$j]; /*18976*/
				var _Jm = $k[--$j]; /*18976*/
				$k[$j++] = _Jl; /*18976*/
				$forall(_Jm, function() { /*18976*/
					var _Jn = $k[--$j]; /*18976*/
					$k[$j++] = _Jn - 48; /*18976*/
				}) /*18976*/
				var _Jo = $a(); /*18976*/
				$1.top = $geti(_Jo, 0, 4); /*18977*/
				$1.bot = $geti(_Jo, 4, 4); /*18978*/
			} else { /*18987*/
				var _Js = $strcpy($s(5), "00000"); /*18980*/
				var _Jx = $cvrs($s(5), $get($1.cws, $1.i), 2); /*18980*/
				$puti(_Js, 5 - _Jx.length, _Jx); /*18981*/
				$k[$j++] = _Js; /*18981*/
				$k[$j++] = Infinity; /*18981*/
				var _Jy = $k[--$j]; /*18981*/
				var _Jz = $k[--$j]; /*18981*/
				$k[$j++] = _Jy; /*18981*/
				$forall(_Jz, function() { /*18981*/
					var _K0 = $k[--$j]; /*18981*/
					$k[$j++] = _K0 - 48; /*18981*/
				}) /*18981*/
				$1.c1 = $a(); /*18982*/
				var _K3 = $strcpy($s(5), "00000"); /*18983*/
				var _K8 = $cvrs($s(5), $get($1.cws, $1.i + 1), 2); /*18983*/
				$puti(_K3, 5 - _K8.length, _K8); /*18984*/
				$k[$j++] = _K3; /*18984*/
				$k[$j++] = Infinity; /*18984*/
				var _K9 = $k[--$j]; /*18984*/
				var _KA = $k[--$j]; /*18984*/
				$k[$j++] = _K9; /*18984*/
				$forall(_KA, function() { /*18984*/
					var _KB = $k[--$j]; /*18984*/
					$k[$j++] = _KB - 48; /*18984*/
				}) /*18984*/
				$1.c2 = $a(); /*18985*/
				$k[$j++] = "top"; /*18986*/
				$k[$j++] = Infinity; /*18986*/
				$aload($geti($1.c1, 0, 3)); /*18986*/
				$aload($geti($1.c2, 0, 2)); /*18986*/
				var _KH = $a(); /*18986*/
				$1[$k[--$j]] = _KH; /*18986*/
				$k[$j++] = "bot"; /*18987*/
				$k[$j++] = Infinity; /*18987*/
				$aload($geti($1.c1, 3, 2)); /*18987*/
				$aload($geti($1.c2, 2, 3)); /*18987*/
				var _KN = $a(); /*18987*/
				$1[$k[--$j]] = _KN; /*18987*/
			} /*18987*/
			$puti($1.mmat, ($1.r * $1.dcol) + $1.c, $1.top); /*18989*/
			$puti($1.mmat, (($1.r + 1) * $1.dcol) + $1.c, $1.bot); /*18990*/
			$1.c = $1.c + $1.top.length; /*18991*/
			if ($1.c == $1.dcol) { /*18992*/
				$1.c = 0; /*18992*/
				$1.r = $1.r + 2; /*18992*/
			} /*18992*/
		} /*18992*/
		$1.mmv = function() {
			var _Kf = $k[--$j]; /*18996*/
			var _Kg = $k[--$j]; /*18996*/
			$k[$j++] = _Kg + (_Kf * $1.cols); /*18996*/
		}; /*18996*/
		$k[$j++] = "pixs"; /*18997*/
		$k[$j++] = Infinity; /*18997*/
		for (var _Kj = 0, _Kk = $1.rows * $1.cols; _Kj < _Kk; _Kj++) { /*18997*/
			$k[$j++] = -1; /*18997*/
		} /*18997*/
		var _Kl = $a(); /*18997*/
		$1[$k[--$j]] = _Kl; /*18997*/
		var _LH = $a([function() {
			for (var _Ko = 0, _Kp = $1.cols; _Ko < _Kp; _Ko++) { /*19001*/
				$k[$j++] = 0; /*19001*/
			} /*19001*/
		}, function() {
			for (var _Kr = 0, _Ks = $1.cols; _Kr < _Ks; _Kr++) { /*19002*/
				$k[$j++] = 1; /*19002*/
			} /*19002*/
		}, function() {
			$k[$j++] = 0; /*19003*/
			for (var _Ku = 0, _Kv = $1.cols - 2; _Ku < _Kv; _Ku++) { /*19003*/
				$k[$j++] = 1; /*19003*/
			} /*19003*/
			$k[$j++] = 0; /*19003*/
		}, function() {
			$k[$j++] = 0; /*19004*/
			$k[$j++] = 1; /*19004*/
			for (var _Kx = 0, _Ky = $1.cols - 4; _Kx < _Ky; _Kx++) { /*19004*/
				$k[$j++] = 0; /*19004*/
			} /*19004*/
			$k[$j++] = 1; /*19004*/
			$k[$j++] = 0; /*19004*/
		}, function() {
			for (var _L0 = 0, _L1 = ~~(($1.cols - 1) / 2); _L0 < _L1; _L0++) { /*19005*/
				$k[$j++] = -1; /*19005*/
			} /*19005*/
			$k[$j++] = 1; /*19005*/
			for (var _L3 = 0, _L4 = ~~(($1.cols - 1) / 2); _L3 < _L4; _L3++) { /*19005*/
				$k[$j++] = -1; /*19005*/
			} /*19005*/
		}, function() {
			for (var _L6 = 0, _L7 = ~~(($1.cols - 1) / 2); _L6 < _L7; _L6++) { /*19006*/
				$k[$j++] = -1; /*19006*/
			} /*19006*/
			$k[$j++] = 0; /*19006*/
			for (var _L9 = 0, _LA = ~~(($1.cols - 1) / 2); _L9 < _LA; _L9++) { /*19006*/
				$k[$j++] = -1; /*19006*/
			} /*19006*/
		}, function() {
			$k[$j++] = 1; /*19007*/
			for (var _LC = 0, _LD = $1.cols - 2; _LC < _LD; _LC++) { /*19007*/
				$k[$j++] = 0; /*19007*/
			} /*19007*/
			$k[$j++] = 1; /*19007*/
		}, function() {
			$k[$j++] = 1; /*19008*/
			$k[$j++] = 0; /*19008*/
			for (var _LF = 0, _LG = $1.cols - 4; _LF < _LG; _LF++) { /*19008*/
				$k[$j++] = 1; /*19008*/
			} /*19008*/
			$k[$j++] = 0; /*19008*/
			$k[$j++] = 1; /*19008*/
		}]); /*19008*/
		$1.artifact = _LH; /*19009*/
		var _LI = {
			A: "121343",
			B: "12134343",
			C: "12121343",
			D: "1213434343",
			E: "1212134343",
			F: "1212121343",
			G: "121213434343",
			H: "121212134343",
			S: "56661278",
			T: "5666666666127878"
		}; /*19020*/
		$1.cpat = $get(_LI, $geti($1.vers, 0, 1)); /*19021*/
		$k[$j++] = $1.pixs; /*19022*/
		$k[$j++] = 0; /*19022*/
		$k[$j++] = ~~(($1.rows - $1.cpat.length) / 2); /*19022*/
		$1.mmv(); /*19022*/
		$k[$j++] = Infinity; /*19023*/
		$forall($1.cpat, function() { /*19023*/
			$get($1.artifact, $k[--$j] - 49)(); /*19023*/
		}) /*19023*/
		var _LT = $a(); /*19023*/
		var _LU = $k[--$j]; /*19023*/
		$puti($k[--$j], _LU, _LT); /*19023*/
		for (var _LY = 0, _LX = $1.risl - 1; _LY <= _LX; _LY += 1) { /*19038*/
			$1.i = _LY; /*19027*/
			for (var _Ld = $1.riso, _Le = $1.risi, _Lc = $1.cols - 1; _Le < 0 ? _Ld >= _Lc : _Ld <= _Lc; _Ld += _Le) { /*19037*/
				$1.j = _Ld; /*19029*/
				var _Lg = (($1.i % 12) == 0) ? 1 : 0; /*19030*/
				var _Lh = $a([1, _Lg]); /*19030*/
				$k[$j++] = _Lh; /*19031*/
				$k[$j++] = _Lh; /*19031*/
				$k[$j++] = $1.pixs; /*19031*/
				$k[$j++] = $1.j; /*19031*/
				$k[$j++] = $1.i; /*19031*/
				$1.mmv(); /*19031*/
				var _Ll = $k[--$j]; /*19032*/
				var _Lm = $k[--$j]; /*19032*/
				$puti(_Lm, _Ll, $k[--$j]); /*19032*/
				if ($1.i != ($1.risl - 1)) { /*19036*/
					$k[$j++] = $1.pixs; /*19034*/
					$k[$j++] = ($1.cols - $1.j) - 2; /*19034*/
					$k[$j++] = ($1.rows - $1.i) - 1; /*19034*/
					$1.mmv(); /*19034*/
					var _Lv = $k[--$j]; /*19035*/
					var _Lw = $k[--$j]; /*19035*/
					$puti(_Lw, _Lv, $k[--$j]); /*19035*/
				} else { /*19036*/
					$j--; /*19036*/
				} /*19036*/
			} /*19036*/
		} /*19036*/
		var _Mb = {
			A: $a([$a([12, 5])]),
			B: $a([$a([16, 7])]),
			C: $a([$a([26, 12])]),
			D: $a([]),
			E: $a([$a([26, 23])]),
			F: $a([$a([26, 32]), $a([70, 32]), $a([26, 34]), $a([70, 34])]),
			G: $a([$a([27, 48]), $a([69, 48])]),
			H: $a([$a([26, 70]), $a([66, 70]), $a([106, 70]), $a([26, 72]), $a([66, 72]), $a([106, 72])]),
			"S-10": $a([]),
			"S-20": $a([$a([10, 4])]),
			"S-30": $a([$a([15, 4]), $a([15, 6])]),
			"T-16": $a([$a([8, 10])]),
			"T-32": $a([$a([16, 10]), $a([16, 12])]),
			"T-48": $a([$a([24, 10]), $a([24, 12]), $a([24, 14])])
		}; /*19055*/
		$forall($get(_Mb, $1.vers), function() { /*19056*/
			var _Mf = $k[--$j]; /*19056*/
			$k[$j++] = $1.pixs; /*19056*/
			$aload(_Mf); /*19056*/
			$1.mmv(); /*19056*/
			var _Mg = $k[--$j]; /*19056*/
			$put($k[--$j], _Mg, 1); /*19056*/
		}) /*19056*/
		$1.j = 0; /*19059*/
		for (var _Mk = 0, _Mj = $1.pixs.length - 1; _Mk <= _Mj; _Mk += 1) { /*19066*/
			$1.i = _Mk; /*19061*/
			if ($get($1.pixs, $1.i) == -1) { /*19065*/
				$put($1.pixs, $1.i, $get($1.mmat, $1.j)); /*19063*/
				$1.j = $1.j + 1; /*19064*/
			} /*19064*/
		} /*19064*/
		var _N0 = {
			ren: $0.renmatrix,
			pixs: $1.pixs,
			pixx: $1.cols,
			pixy: $1.rows,
			height: ($1.rows / 72) * 2,
			width: ($1.cols / 72) * 2,
			opt: $1.options
		}; /*19076*/
		$k[$j++] = _N0; /*19079*/
		if (!$1.dontdraw) { /*19079*/
			$0.renmatrix(); /*19079*/
		} /*19079*/
	};
	$0.hanxin = function() {
		var $1 = {}; /*19106*/
		$1.options = $k[--$j]; /*19108*/
		$1.barcode = $k[--$j]; /*19109*/
		$1.dontdraw = false; /*19111*/
		$1.version = "unset"; /*19112*/
		$1.eclevel = "unset"; /*19113*/
		$1.parse = false; /*19114*/
		$1.parsefnc = false; /*19115*/
		$1.mask = -1; /*19116*/
		$forall($1.options, function() { /*19127*/
			var _3 = $k[--$j]; /*19127*/
			$1[$k[--$j]] = _3; /*19127*/
		}) /*19127*/
		$1.mask = ~~$1.mask; /*19129*/
		$1.barlen = $1.barcode.length; /*19152*/
		var _7 = {

		}; /*19157*/
		$1.fncvals = _7; /*19157*/
		$1.msg = $a($1.barlen); /*19158*/
		$1.i = 0; /*19159*/
		$1.j = 0; /*19159*/
		for (;;) { /*19173*/
			if ($1.i == $1.barlen) { /*19160*/
				break; /*19160*/
			} /*19160*/
			$1.char = $get($1.barcode, $1.i); /*19161*/
			if (($1.parsefnc && ($1.char == 94)) && ($1.i < ($1.barlen - 4))) { /*19169*/
				if ($get($1.barcode, $1.i + 1) != 94) { /*19167*/
					$1.char = $get($1.fncvals, $geti($1.barcode, $1.i + 1, 4)); /*19164*/
					$1.i = $1.i + 4; /*19165*/
				} else { /*19167*/
					$1.i = $1.i + 1; /*19167*/
				} /*19167*/
			} /*19167*/
			$put($1.msg, $1.j, $1.char); /*19170*/
			$1.i = $1.i + 1; /*19171*/
			$1.j = $1.j + 1; /*19172*/
		} /*19172*/
		$1.msg = $geti($1.msg, 0, $1.j); /*19174*/
		$1.msglen = $1.msg.length; /*19175*/
		if ($eq($1.eclevel, "unset")) { /*19178*/
			$1.eclevel = "L2"; /*19178*/
		} /*19178*/
		$1.tobin = function() {
			var _e = $s($k[--$j]); /*19181*/
			$k[$j++] = _e; /*19181*/
			for (var _g = 0, _f = _e.length - 1; _g <= _f; _g += 1) { /*19181*/
				var _h = $k[--$j]; /*19181*/
				$put(_h, _g, 48); /*19181*/
				$k[$j++] = _h; /*19181*/
			} /*19181*/
			var _i = $k[--$j]; /*19182*/
			var _l = $cvrs($s(_i.length), $k[--$j], 2); /*19182*/
			$puti(_i, _i.length - _l.length, _l); /*19183*/
			$k[$j++] = _i; /*19183*/
		}; /*19184*/
		$1.bits = $s((4 + 13) + ($1.msglen * 8)); /*19187*/
		$puti($1.bits, 0, "0011"); /*19188*/
		$k[$j++] = $1.bits; /*19189*/
		$k[$j++] = 4; /*19189*/
		$k[$j++] = $1.msglen; /*19189*/
		$k[$j++] = 13; /*19189*/
		$1.tobin(); /*19189*/
		var _r = $k[--$j]; /*19189*/
		var _s = $k[--$j]; /*19189*/
		$puti($k[--$j], _s, _r); /*19189*/
		for (var _w = 0, _v = $1.msglen - 1; _w <= _v; _w += 1) { /*19193*/
			$1.i = _w; /*19191*/
			$k[$j++] = $1.bits; /*19192*/
			$k[$j++] = 17 + ($1.i * 8); /*19192*/
			$k[$j++] = $get($1.msg, $1.i); /*19192*/
			$k[$j++] = 8; /*19192*/
			$1.tobin(); /*19192*/
			var _12 = $k[--$j]; /*19192*/
			var _13 = $k[--$j]; /*19192*/
			$puti($k[--$j], _13, _12); /*19192*/
		} /*19192*/
		$1.metrics = $a([$a(["1", 23, -1, 0, 205, $a([1, 21, 4]), $a([0, -1, -1]), $a([0, -1, -1]), $a([1, 17, 8]), $a([0, -1, -1]), $a([0, -1, -1]), $a([1, 13, 12]), $a([0, -1, -1]), $a([0, -1, -1]), $a([1, 9, 16]), $a([0, -1, -1]), $a([0, -1, -1])]), $a(["2", 25, -1, 0, 301, $a([1, 31, 6]), $a([0, -1, -1]), $a([0, -1, -1]), $a([1, 25, 12]), $a([0, -1, -1]), $a([0, -1, -1]), $a([1, 19, 18]), $a([0, -1, -1]), $a([0, -1, -1]), $a([1, 15, 22]), $a([0, -1, -1]), $a([0, -1, -1])]), $a(["3", 27, -1, 0, 405, $a([1, 42, 8]), $a([0, -1, -1]), $a([0, -1, -1]), $a([1, 34, 16]), $a([0, -1, -1]), $a([0, -1, -1]), $a([1, 26, 24]), $a([0, -1, -1]), $a([0, -1, -1]), $a([1, 20, 30]), $a([0, -1, -1]), $a([0, -1, -1])]), $a(["4", 29, 14, 1, 439, $a([1, 46, 8]), $a([0, -1, -1]), $a([0, -1, -1]), $a([1, 38, 16]), $a([0, -1, -1]), $a([0, -1, -1]), $a([1, 30, 24]), $a([0, -1, -1]), $a([0, -1, -1]), $a([1, 22, 32]), $a([0, -1, -1]), $a([0, -1, -1])]), $a(["5", 31, 16, 1, 555, $a([1, 57, 12]), $a([0, -1, -1]), $a([0, -1, -1]), $a([1, 49, 20]), $a([0, -1, -1]), $a([0, -1, -1]), $a([1, 37, 32]), $a([0, -1, -1]), $a([0, -1, -1]), $a([1, 14, 20]), $a([1, 13, 22]), $a([0, -1, -1])]), $a(["6", 33, 16, 1, 675, $a([1, 70, 14]), $a([0, -1, -1]), $a([0, -1, -1]), $a([1, 58, 26]), $a([0, -1, -1]), $a([0, -1, -1]), $a([1, 24, 20]), $a([1, 22, 18]), $a([0, -1, -1]), $a([1, 16, 24]), $a([1, 18, 26]), $a([0, -1, -1])]), $a(["7", 35, 17, 1, 805, $a([1, 84, 16]), $a([0, -1, -1]), $a([0, -1, -1]), $a([1, 70, 30]), $a([0, -1, -1]), $a([0, -1, -1]), $a([1, 26, 22]), $a([1, 28, 24]), $a([0, -1, -1]), $a([2, 14, 20]), $a([1, 12, 20]), $a([0, -1, -1])]), $a(["8", 37, 18, 1, 943, $a([1, 99, 18]), $a([0, -1, -1]), $a([0, -1, -1]), $a([1, 40, 18]), $a([1, 41, 18]), $a([0, -1, -1]), $a([1, 31, 26]), $a([1, 32, 28]), $a([0, -1, -1]), $a([2, 16, 24]), $a([1, 15, 22]), $a([0, -1, -1])]), $a(["9", 39, 19, 1, 1089, $a([1, 114, 22]), $a([0, -1, -1]), $a([0, -1, -1]), $a([2, 48, 20]), $a([0, -1, -1]), $a([0, -1, -1]), $a([2, 24, 20]), $a([1, 26, 22]), $a([0, -1, -1]), $a([2, 18, 28]), $a([1, 18, 26]), $a([0, -1, -1])]), $a(["10", 41, 20, 1, 1243, $a([1, 131, 24]), $a([0, -1, -1]), $a([0, -1, -1]), $a([1, 52, 22]), $a([1, 57, 24]), $a([0, -1, -1]), $a([2, 27, 24]), $a([1, 29, 24]), $a([0, -1, -1]), $a([2, 21, 32]), $a([1, 19, 30]), $a([0, -1, -1])]), $a(["11", 43, 14, 2, 1289, $a([1, 135, 26]), $a([0, -1, -1]), $a([0, -1, -1]), $a([1, 56, 24]), $a([1, 57, 24]), $a([0, -1, -1]), $a([2, 28, 24]), $a([1, 31, 26]), $a([0, -1, -1]), $a([2, 22, 32]), $a([1, 21, 32]), $a([0, -1, -1])]), $a(["12", 45, 15, 2, 1455, $a([1, 153, 28]), $a([0, -1, -1]), $a([0, -1, -1]), $a([1, 62, 26]), $a([1, 65, 28]), $a([0, -1, -1]), $a([2, 32, 28]), $a([1, 33, 28]), $a([0, -1, -1]), $a([3, 17, 26]), $a([1, 22, 30]), $a([0, -1, -1])]), $a(["13", 47, 16, 2, 1629, $a([1, 86, 16]), $a([1, 85, 16]), $a([0, -1, -1]), $a([1, 71, 30]), $a([1, 72, 30]), $a([0, -1, -1]), $a([2, 37, 32]), $a([1, 35, 30]), $a([0, -1, -1]), $a([3, 20, 30]), $a([1, 21, 32]), $a([0, -1, -1])]), $a(["14", 49, 16, 2, 1805, $a([1, 94, 18]), $a([1, 95, 18]), $a([0, -1, -1]), $a([2, 51, 22]), $a([1, 55, 24]), $a([0, -1, -1]), $a([3, 30, 26]), $a([1, 31, 26]), $a([0, -1, -1]), $a([4, 18, 28]), $a([1, 17, 24]), $a([0, -1, -1])]), $a(["15", 51, 17, 2, 1995, $a([1, 104, 20]), $a([1, 105, 20]), $a([0, -1, -1]), $a([2, 57, 24]), $a([1, 61, 26]), $a([0, -1, -1]), $a([3, 33, 28]), $a([1, 36, 30]), $a([0, -1, -1]), $a([4, 20, 30]), $a([1, 19, 30]), $a([0, -1, -1])]), $a(["16", 53, 17, 2, 2187, $a([1, 115, 22]), $a([1, 114, 22]), $a([0, -1, -1]), $a([2, 65, 28]), $a([1, 61, 26]), $a([0, -1, -1]), $a([3, 38, 32]), $a([1, 33, 30]), $a([0, -1, -1]), $a([5, 19, 28]), $a([1, 14, 24]), $a([0, -1, -1])]), $a(["17", 55, 18, 2, 2393, $a([1, 126, 24]), $a([1, 125, 24]), $a([0, -1, -1]), $a([2, 70, 30]), $a([1, 69, 30]), $a([0, -1, -1]), $a([4, 33, 28]), $a([1, 29, 26]), $a([0, -1, -1]), $a([5, 20, 30]), $a([1, 19, 30]), $a([0, -1, -1])]), $a(["18", 57, 19, 2, 2607, $a([1, 136, 26]), $a([1, 137, 26]), $a([0, -1, -1]), $a([3, 56, 24]), $a([1, 59, 26]), $a([0, -1, -1]), $a([5, 35, 30]), $a([0, -1, -1]), $a([0, -1, -1]), $a([6, 18, 28]), $a([1, 21, 28]), $a([0, -1, -1])]), $a(["19", 59, 20, 2, 2829, $a([1, 148, 28]), $a([1, 149, 28]), $a([0, -1, -1]), $a([3, 61, 26]), $a([1, 64, 28]), $a([0, -1, -1]), $a([7, 24, 20]), $a([1, 23, 22]), $a([0, -1, -1]), $a([6, 20, 30]), $a([1, 21, 32]), $a([0, -1, -1])]), $a(["20", 61, 20, 2, 3053, $a([3, 107, 20]), $a([0, -1, -1]), $a([0, -1, -1]), $a([3, 65, 28]), $a([1, 72, 30]), $a([0, -1, -1]), $a([7, 26, 22]), $a([1, 23, 22]), $a([0, -1, -1]), $a([7, 19, 28]), $a([1, 20, 32]), $a([0, -1, -1])]), $a(["21", 63, 21, 2, 3291, $a([3, 115, 22]), $a([0, -1, -1]), $a([0, -1, -1]), $a([4, 56, 24]), $a([1, 63, 28]), $a([0, -1, -1]), $a([7, 28, 24]), $a([1, 25, 22]), $a([0, -1, -1]), $a([8, 18, 28]), $a([1, 21, 22]), $a([0, -1, -1])]), $a(["22", 65, 16, 3, 3383, $a([2, 116, 22]), $a([1, 122, 24]), $a([0, -1, -1]), $a([4, 56, 24]), $a([1, 72, 30]), $a([0, -1, -1]), $a([7, 28, 24]), $a([1, 32, 26]), $a([0, -1, -1]), $a([8, 18, 28]), $a([1, 24, 30]), $a([0, -1, -1])]), $a(["23", 67, 17, 3, 3631, $a([3, 127, 24]), $a([0, -1, -1]), $a([0, -1, -1]), $a([5, 51, 22]), $a([1, 62, 26]), $a([0, -1, -1]), $a([7, 30, 26]), $a([1, 35, 26]), $a([0, -1, -1]), $a([8, 20, 30]), $a([1, 21, 32]), $a([0, -1, -1])]), $a(["24", 69, 17, 3, 3887, $a([2, 135, 26]), $a([1, 137, 26]), $a([0, -1, -1]), $a([5, 56, 24]), $a([1, 59, 26]), $a([0, -1, -1]), $a([7, 33, 28]), $a([1, 30, 28]), $a([0, -1, -1]), $a([11, 16, 24]), $a([1, 19, 26]), $a([0, -1, -1])]), $a(["25", 71, 18, 3, 4151, $a([3, 105, 20]), $a([1, 121, 22]), $a([0, -1, -1]), $a([5, 61, 26]), $a([1, 57, 26]), $a([0, -1, -1]), $a([9, 28, 24]), $a([1, 28, 22]), $a([0, -1, -1]), $a([10, 19, 28]), $a([1, 18, 30]), $a([0, -1, -1])]), $a(["26", 73, 18, 3, 4423, $a([2, 157, 30]), $a([1, 150, 28]), $a([0, -1, -1]), $a([5, 65, 28]), $a([1, 61, 26]), $a([0, -1, -1]), $a([8, 33, 28]), $a([1, 34, 30]), $a([0, -1, -1]), $a([10, 19, 28]), $a([2, 15, 26]), $a([0, -1, -1])]), $a(["27", 75, 19, 3, 4703, $a([3, 126, 24]), $a([1, 115, 22]), $a([0, -1, -1]), $a([7, 51, 22]), $a([1, 54, 22]), $a([0, -1, -1]), $a([8, 35, 30]), $a([1, 37, 30]), $a([0, -1, -1]), $a([15, 15, 22]), $a([1, 10, 22]), $a([0, -1, -1])]), $a(["28", 77, 19, 3, 4991, $a([4, 105, 20]), $a([1, 103, 20]), $a([0, -1, -1]), $a([7, 56, 24]), $a([1, 45, 18]), $a([0, -1, -1]), $a([10, 31, 26]), $a([1, 27, 26]), $a([0, -1, -1]), $a([10, 17, 26]), $a([3, 20, 28]), $a([1, 21, 28])]), $a(["29", 79, 20, 3, 5287, $a([3, 139, 26]), $a([1, 137, 28]), $a([0, -1, -1]), $a([6, 66, 28]), $a([1, 66, 30]), $a([0, -1, -1]), $a([9, 36, 30]), $a([1, 34, 32]), $a([0, -1, -1]), $a([13, 19, 28]), $a([1, 17, 32]), $a([0, -1, -1])]), $a(["30", 81, 20, 3, 5591, $a([6, 84, 16]), $a([1, 82, 16]), $a([0, -1, -1]), $a([6, 70, 30]), $a([1, 68, 30]), $a([0, -1, -1]), $a([7, 35, 30]), $a([3, 33, 28]), $a([1, 32, 28]), $a([13, 20, 30]), $a([1, 20, 28]), $a([0, -1, -1])]), $a(["31", 83, 21, 3, 5903, $a([5, 105, 20]), $a([1, 94, 18]), $a([0, -1, -1]), $a([6, 74, 32]), $a([1, 71, 30]), $a([0, -1, -1]), $a([11, 33, 28]), $a([1, 34, 32]), $a([0, -1, -1]), $a([13, 19, 28]), $a([3, 16, 26]), $a([0, -1, -1])]), $a(["32", 85, 17, 4, 6033, $a([4, 127, 24]), $a([1, 126, 24]), $a([0, -1, -1]), $a([7, 66, 28]), $a([1, 66, 30]), $a([0, -1, -1]), $a([12, 30, 24]), $a([1, 24, 28]), $a([1, 24, 30]), $a([15, 19, 28]), $a([1, 17, 32]), $a([0, -1, -1])]), $a(["33", 87, 17, 4, 6353, $a([7, 84, 16]), $a([1, 78, 16]), $a([0, -1, -1]), $a([7, 70, 30]), $a([1, 66, 28]), $a([0, -1, -1]), $a([12, 33, 28]), $a([1, 32, 30]), $a([0, -1, -1]), $a([14, 21, 32]), $a([1, 24, 28]), $a([0, -1, -1])]), $a(["34", 89, 18, 4, 6689, $a([5, 117, 22]), $a([1, 117, 24]), $a([0, -1, -1]), $a([8, 66, 28]), $a([1, 58, 26]), $a([0, -1, -1]), $a([11, 38, 32]), $a([1, 34, 32]), $a([0, -1, -1]), $a([15, 20, 30]), $a([2, 17, 26]), $a([0, -1, -1])]), $a(["35", 91, 18, 4, 7025, $a([4, 148, 28]), $a([1, 146, 28]), $a([0, -1, -1]), $a([8, 68, 30]), $a([1, 70, 24]), $a([0, -1, -1]), $a([10, 36, 32]), $a([3, 38, 28]), $a([0, -1, -1]), $a([16, 19, 28]), $a([3, 16, 26]), $a([0, -1, -1])]), $a(["36", 93, 19, 4, 7377, $a([4, 126, 24]), $a([2, 135, 26]), $a([0, -1, -1]), $a([8, 70, 28]), $a([2, 43, 26]), $a([0, -1, -1]), $a([13, 32, 28]), $a([2, 41, 30]), $a([0, -1, -1]), $a([17, 19, 28]), $a([3, 15, 26]), $a([0, -1, -1])]), $a(["37", 95, 19, 4, 7729, $a([5, 136, 26]), $a([1, 132, 24]), $a([0, -1, -1]), $a([5, 67, 30]), $a([4, 68, 28]), $a([1, 69, 28]), $a([14, 35, 30]), $a([1, 32, 24]), $a([0, -1, -1]), $a([18, 18, 26]), $a([3, 16, 28]), $a([1, 14, 28])]), $a(["38", 97, 19, 4, 8089, $a([3, 142, 26]), $a([3, 141, 28]), $a([0, -1, -1]), $a([8, 70, 30]), $a([1, 73, 32]), $a([1, 74, 32]), $a([12, 34, 30]), $a([3, 34, 26]), $a([1, 35, 28]), $a([18, 21, 32]), $a([1, 27, 30]), $a([0, -1, -1])]), $a(["39", 99, 20, 4, 8465, $a([5, 116, 22]), $a([2, 103, 20]), $a([1, 102, 20]), $a([9, 74, 32]), $a([1, 74, 30]), $a([0, -1, -1]), $a([14, 34, 28]), $a([2, 32, 32]), $a([1, 32, 30]), $a([19, 21, 32]), $a([1, 25, 26]), $a([0, -1, -1])]), $a(["40", 101, 20, 4, 8841, $a([7, 116, 22]), $a([1, 117, 22]), $a([0, -1, -1]), $a([11, 65, 28]), $a([1, 58, 24]), $a([0, -1, -1]), $a([15, 38, 32]), $a([1, 27, 28]), $a([0, -1, -1]), $a([20, 20, 30]), $a([1, 20, 32]), $a([1, 21, 32])]), $a(["41", 103, 17, 5, 9009, $a([6, 136, 26]), $a([1, 130, 24]), $a([0, -1, -1]), $a([11, 66, 28]), $a([1, 62, 30]), $a([0, -1, -1]), $a([14, 34, 28]), $a([3, 34, 32]), $a([1, 30, 30]), $a([18, 20, 30]), $a([3, 20, 28]), $a([2, 15, 26])]), $a(["42", 105, 17, 5, 9401, $a([5, 105, 20]), $a([2, 115, 22]), $a([2, 116, 22]), $a([10, 75, 32]), $a([1, 73, 32]), $a([0, -1, -1]), $a([16, 38, 32]), $a([1, 27, 28]), $a([0, -1, -1]), $a([22, 19, 28]), $a([2, 16, 30]), $a([1, 19, 30])]), $a(["43", 107, 18, 5, 9799, $a([6, 147, 28]), $a([1, 146, 28]), $a([0, -1, -1]), $a([11, 66, 28]), $a([2, 65, 30]), $a([0, -1, -1]), $a([18, 33, 28]), $a([2, 33, 30]), $a([0, -1, -1]), $a([22, 21, 32]), $a([1, 28, 30]), $a([0, -1, -1])]), $a(["44", 109, 18, 5, 10207, $a([6, 116, 22]), $a([3, 125, 24]), $a([0, -1, -1]), $a([11, 75, 32]), $a([1, 68, 30]), $a([0, -1, -1]), $a([13, 35, 28]), $a([6, 34, 32]), $a([1, 30, 30]), $a([23, 21, 32]), $a([1, 26, 30]), $a([0, -1, -1])]), $a(["45", 111, 18, 5, 10623, $a([7, 105, 20]), $a([4, 95, 18]), $a([0, -1, -1]), $a([12, 67, 28]), $a([1, 63, 30]), $a([1, 62, 32]), $a([21, 31, 26]), $a([2, 33, 32]), $a([0, -1, -1]), $a([23, 21, 32]), $a([2, 24, 30]), $a([0, -1, -1])]), $a(["46", 113, 19, 5, 11045, $a([10, 116, 22]), $a([0, -1, -1]), $a([0, -1, -1]), $a([12, 74, 32]), $a([1, 78, 30]), $a([0, -1, -1]), $a([18, 37, 32]), $a([1, 39, 30]), $a([1, 41, 28]), $a([25, 21, 32]), $a([1, 27, 28]), $a([0, -1, -1])]), $a(["47", 115, 19, 5, 11477, $a([5, 126, 24]), $a([4, 115, 22]), $a([1, 114, 22]), $a([12, 67, 28]), $a([2, 66, 32]), $a([1, 68, 30]), $a([21, 35, 30]), $a([1, 39, 30]), $a([0, -1, -1]), $a([26, 21, 32]), $a([1, 28, 28]), $a([0, -1, -1])]), $a(["48", 117, 19, 5, 11917, $a([9, 126, 24]), $a([1, 117, 22]), $a([0, -1, -1]), $a([13, 75, 32]), $a([1, 68, 30]), $a([0, -1, -1]), $a([20, 35, 30]), $a([3, 35, 28]), $a([0, -1, -1]), $a([27, 21, 32]), $a([1, 28, 30]), $a([0, -1, -1])]), $a(["49", 119, 17, 6, 12111, $a([9, 126, 24]), $a([1, 137, 26]), $a([0, -1, -1]), $a([13, 71, 30]), $a([2, 68, 32]), $a([0, -1, -1]), $a([20, 37, 32]), $a([1, 39, 28]), $a([1, 38, 28]), $a([24, 20, 32]), $a([5, 25, 28]), $a([0, -1, -1])]), $a(["50", 121, 17, 6, 12559, $a([8, 147, 28]), $a([1, 141, 28]), $a([0, -1, -1]), $a([10, 73, 32]), $a([4, 74, 30]), $a([1, 73, 30]), $a([16, 36, 32]), $a([6, 39, 30]), $a([1, 37, 30]), $a([27, 21, 32]), $a([3, 20, 26]), $a([0, -1, -1])]), $a(["51", 123, 18, 6, 13025, $a([9, 137, 26]), $a([1, 135, 26]), $a([0, -1, -1]), $a([12, 70, 30]), $a([4, 75, 32]), $a([0, -1, -1]), $a([24, 35, 30]), $a([1, 40, 28]), $a([0, -1, -1]), $a([23, 20, 32]), $a([8, 24, 30]), $a([0, -1, -1])]), $a(["52", 125, 18, 6, 13489, $a([14, 95, 18]), $a([1, 86, 18]), $a([0, -1, -1]), $a([13, 73, 32]), $a([3, 77, 30]), $a([0, -1, -1]), $a([24, 35, 30]), $a([2, 35, 28]), $a([0, -1, -1]), $a([26, 21, 32]), $a([5, 21, 30]), $a([1, 23, 30])]), $a(["53", 127, 18, 6, 13961, $a([9, 147, 28]), $a([1, 142, 28]), $a([0, -1, -1]), $a([10, 73, 30]), $a([6, 70, 32]), $a([1, 71, 32]), $a([25, 35, 30]), $a([2, 34, 26]), $a([0, -1, -1]), $a([29, 21, 32]), $a([4, 22, 30]), $a([0, -1, -1])]), $a(["54", 129, 18, 6, 14441, $a([11, 126, 24]), $a([1, 131, 24]), $a([0, -1, -1]), $a([16, 74, 32]), $a([1, 79, 30]), $a([0, -1, -1]), $a([25, 38, 32]), $a([1, 25, 30]), $a([0, -1, -1]), $a([33, 21, 32]), $a([1, 28, 28]), $a([0, -1, -1])]), $a(["55", 131, 19, 6, 14939, $a([14, 105, 20]), $a([1, 99, 18]), $a([0, -1, -1]), $a([19, 65, 28]), $a([1, 72, 28]), $a([0, -1, -1]), $a([24, 37, 32]), $a([2, 40, 30]), $a([1, 41, 30]), $a([31, 21, 32]), $a([4, 24, 32]), $a([0, -1, -1])]), $a(["56", 133, 19, 6, 15435, $a([10, 147, 28]), $a([1, 151, 28]), $a([0, -1, -1]), $a([15, 71, 30]), $a([3, 71, 32]), $a([1, 73, 32]), $a([24, 37, 32]), $a([3, 38, 30]), $a([1, 39, 30]), $a([36, 19, 30]), $a([3, 29, 26]), $a([0, -1, -1])]), $a(["57", 135, 19, 6, 15939, $a([15, 105, 20]), $a([1, 99, 18]), $a([0, -1, -1]), $a([19, 70, 30]), $a([1, 64, 28]), $a([0, -1, -1]), $a([27, 38, 32]), $a([2, 25, 26]), $a([0, -1, -1]), $a([38, 20, 30]), $a([2, 18, 28]), $a([0, -1, -1])]), $a(["58", 137, 17, 7, 16171, $a([14, 105, 20]), $a([1, 113, 22]), $a([1, 114, 22]), $a([17, 67, 30]), $a([3, 92, 32]), $a([0, -1, -1]), $a([30, 35, 30]), $a([1, 41, 30]), $a([0, -1, -1]), $a([36, 21, 32]), $a([1, 26, 30]), $a([1, 27, 30])]), $a(["59", 139, 17, 7, 16691, $a([11, 146, 28]), $a([1, 146, 26]), $a([0, -1, -1]), $a([20, 70, 30]), $a([1, 60, 26]), $a([0, -1, -1]), $a([29, 38, 32]), $a([1, 24, 32]), $a([0, -1, -1]), $a([40, 20, 30]), $a([2, 17, 26]), $a([0, -1, -1])]), $a(["60", 141, 18, 7, 17215, $a([3, 137, 26]), $a([1, 136, 26]), $a([10, 126, 24]), $a([22, 65, 28]), $a([1, 75, 30]), $a([0, -1, -1]), $a([30, 37, 32]), $a([1, 51, 30]), $a([0, -1, -1]), $a([42, 20, 30]), $a([1, 21, 30]), $a([0, -1, -1])]), $a(["61", 143, 18, 7, 17751, $a([12, 126, 24]), $a([2, 118, 22]), $a([1, 116, 22]), $a([19, 74, 32]), $a([1, 74, 30]), $a([1, 72, 28]), $a([30, 38, 32]), $a([2, 29, 30]), $a([0, -1, -1]), $a([39, 20, 32]), $a([2, 37, 26]), $a([1, 38, 26])]), $a(["62", 145, 18, 7, 18295, $a([12, 126, 24]), $a([3, 136, 26]), $a([0, -1, -1]), $a([21, 70, 30]), $a([2, 65, 28]), $a([0, -1, -1]), $a([34, 35, 30]), $a([1, 44, 32]), $a([0, -1, -1]), $a([42, 20, 30]), $a([2, 19, 28]), $a([2, 18, 28])]), $a(["63", 147, 18, 7, 18847, $a([12, 126, 24]), $a([3, 117, 22]), $a([1, 116, 22]), $a([25, 61, 26]), $a([2, 62, 28]), $a([0, -1, -1]), $a([34, 35, 30]), $a([1, 40, 32]), $a([1, 41, 32]), $a([45, 20, 30]), $a([1, 20, 32]), $a([1, 21, 32])]), $a(["64", 149, 19, 7, 19403, $a([15, 105, 20]), $a([2, 115, 22]), $a([2, 116, 22]), $a([25, 65, 28]), $a([1, 72, 28]), $a([0, -1, -1]), $a([18, 35, 30]), $a([17, 37, 32]), $a([1, 50, 32]), $a([42, 20, 30]), $a([6, 19, 28]), $a([1, 15, 28])]), $a(["65", 151, 19, 7, 19971, $a([19, 105, 20]), $a([1, 101, 20]), $a([0, -1, -1]), $a([33, 51, 22]), $a([1, 65, 22]), $a([0, -1, -1]), $a([40, 33, 28]), $a([1, 28, 28]), $a([0, -1, -1]), $a([49, 20, 30]), $a([1, 18, 28]), $a([0, -1, -1])]), $a(["66", 153, 17, 8, 20229, $a([18, 105, 20]), $a([2, 117, 22]), $a([0, -1, -1]), $a([26, 65, 28]), $a([1, 80, 30]), $a([0, -1, -1]), $a([35, 35, 30]), $a([3, 35, 28]), $a([1, 36, 28]), $a([52, 18, 28]), $a([2, 38, 30]), $a([0, -1, -1])]), $a(["67", 155, 17, 8, 20805, $a([26, 84, 16]), $a([0, -1, -1]), $a([0, -1, -1]), $a([26, 70, 30]), $a([0, -1, -1]), $a([0, -1, -1]), $a([45, 31, 26]), $a([1, 9, 26]), $a([0, -1, -1]), $a([52, 20, 30]), $a([0, -1, -1]), $a([0, -1, -1])]), $a(["68", 157, 17, 8, 21389, $a([16, 126, 24]), $a([1, 114, 22]), $a([1, 115, 22]), $a([23, 70, 30]), $a([3, 65, 28]), $a([1, 66, 28]), $a([40, 35, 30]), $a([1, 43, 30]), $a([0, -1, -1]), $a([46, 20, 30]), $a([7, 19, 28]), $a([1, 16, 28])]), $a(["69", 159, 18, 8, 21993, $a([19, 116, 22]), $a([1, 105, 22]), $a([0, -1, -1]), $a([20, 70, 30]), $a([7, 66, 28]), $a([1, 63, 28]), $a([40, 35, 30]), $a([1, 42, 32]), $a([1, 43, 32]), $a([54, 20, 30]), $a([1, 19, 30]), $a([0, -1, -1])]), $a(["70", 161, 18, 8, 22593, $a([17, 126, 24]), $a([2, 115, 22]), $a([0, -1, -1]), $a([24, 70, 30]), $a([4, 74, 32]), $a([0, -1, -1]), $a([48, 31, 26]), $a([2, 18, 26]), $a([0, -1, -1]), $a([54, 19, 28]), $a([6, 15, 26]), $a([1, 14, 26])]), $a(["71", 163, 18, 8, 23201, $a([29, 84, 16]), $a([0, -1, -1]), $a([0, -1, -1]), $a([29, 70, 30]), $a([0, -1, -1]), $a([0, -1, -1]), $a([6, 34, 30]), $a([3, 36, 30]), $a([38, 33, 28]), $a([58, 20, 30]), $a([0, -1, -1]), $a([0, -1, -1])]), $a(["72", 165, 18, 8, 23817, $a([16, 147, 28]), $a([1, 149, 28]), $a([0, -1, -1]), $a([31, 66, 28]), $a([1, 37, 26]), $a([0, -1, -1]), $a([48, 33, 28]), $a([1, 23, 26]), $a([0, -1, -1]), $a([53, 20, 30]), $a([6, 19, 28]), $a([1, 17, 28])]), $a(["73", 167, 19, 8, 24453, $a([20, 115, 22]), $a([2, 134, 24]), $a([0, -1, -1]), $a([29, 66, 28]), $a([2, 56, 26]), $a([2, 57, 26]), $a([45, 36, 30]), $a([2, 15, 28]), $a([0, -1, -1]), $a([59, 20, 30]), $a([2, 21, 32]), $a([0, -1, -1])]), $a(["74", 169, 19, 8, 25085, $a([17, 147, 28]), $a([1, 134, 26]), $a([0, -1, -1]), $a([26, 70, 30]), $a([5, 75, 32]), $a([0, -1, -1]), $a([47, 35, 30]), $a([1, 48, 32]), $a([0, -1, -1]), $a([64, 18, 28]), $a([2, 33, 30]), $a([1, 35, 30])]), $a(["75", 171, 17, 9, 25373, $a([22, 115, 22]), $a([1, 133, 24]), $a([0, -1, -1]), $a([33, 65, 28]), $a([1, 74, 28]), $a([0, -1, -1]), $a([43, 36, 30]), $a([5, 27, 28]), $a([1, 30, 28]), $a([57, 20, 30]), $a([5, 21, 32]), $a([1, 24, 32])]), $a(["76", 173, 17, 9, 26021, $a([18, 136, 26]), $a([2, 142, 26]), $a([0, -1, -1]), $a([33, 66, 28]), $a([2, 49, 26]), $a([0, -1, -1]), $a([48, 35, 30]), $a([2, 38, 28]), $a([0, -1, -1]), $a([64, 20, 30]), $a([1, 20, 32]), $a([0, -1, -1])]), $a(["77", 175, 17, 9, 26677, $a([19, 126, 24]), $a([2, 135, 26]), $a([1, 136, 26]), $a([32, 66, 28]), $a([2, 55, 26]), $a([2, 56, 26]), $a([49, 36, 30]), $a([2, 18, 32]), $a([0, -1, -1]), $a([65, 18, 28]), $a([5, 27, 30]), $a([1, 29, 30])]), $a(["78", 177, 18, 9, 27335, $a([20, 137, 26]), $a([1, 130, 26]), $a([0, -1, -1]), $a([30, 75, 32]), $a([2, 71, 32]), $a([0, -1, -1]), $a([46, 35, 30]), $a([6, 39, 32]), $a([0, -1, -1]), $a([3, 12, 30]), $a([70, 19, 28]), $a([0, -1, -1])]), $a(["79", 179, 18, 9, 28007, $a([20, 147, 28]), $a([0, -1, -1]), $a([0, -1, -1]), $a([35, 70, 30]), $a([0, -1, -1]), $a([0, -1, -1]), $a([49, 35, 30]), $a([5, 35, 28]), $a([0, -1, -1]), $a([70, 20, 30]), $a([0, -1, -1]), $a([0, -1, -1])]), $a(["80", 181, 18, 9, 28687, $a([21, 136, 26]), $a([1, 155, 28]), $a([0, -1, -1]), $a([34, 70, 30]), $a([1, 64, 28]), $a([1, 65, 28]), $a([54, 35, 30]), $a([1, 45, 30]), $a([0, -1, -1]), $a([68, 20, 30]), $a([3, 18, 28]), $a([1, 19, 28])]), $a(["81", 183, 18, 9, 29375, $a([19, 126, 24]), $a([5, 115, 22]), $a([1, 114, 22]), $a([33, 70, 30]), $a([3, 65, 28]), $a([1, 64, 28]), $a([52, 35, 30]), $a([3, 41, 32]), $a([1, 40, 32]), $a([67, 20, 30]), $a([5, 21, 32]), $a([1, 24, 32])]), $a(["82", 185, 18, 9, 30071, $a([2, 150, 28]), $a([21, 136, 26]), $a([0, -1, -1]), $a([32, 70, 30]), $a([6, 65, 28]), $a([0, -1, -1]), $a([52, 38, 32]), $a([2, 27, 32]), $a([0, -1, -1]), $a([73, 20, 30]), $a([2, 22, 32]), $a([0, -1, -1])]), $a(["83", 187, 17, 10, 30387, $a([21, 126, 24]), $a([4, 136, 26]), $a([0, -1, -1]), $a([30, 74, 32]), $a([6, 73, 30]), $a([0, -1, -1]), $a([54, 35, 30]), $a([4, 40, 32]), $a([0, -1, -1]), $a([75, 20, 30]), $a([1, 20, 28]), $a([0, -1, -1])]), $a(["84", 189, 17, 10, 31091, $a([30, 105, 20]), $a([1, 114, 22]), $a([0, -1, -1]), $a([3, 45, 22]), $a([55, 47, 20]), $a([0, -1, -1]), $a([2, 26, 26]), $a([62, 33, 28]), $a([0, -1, -1]), $a([79, 18, 28]), $a([4, 33, 30]), $a([0, -1, -1])])]); /*19534*/
		$1.eclval = $get($1.eclevel, 1) - 49; /*19536*/
		for (var _Ik = 0; _Ik <= 83; _Ik += 1) { /*19556*/
			$1.i = _Ik; /*19538*/
			$1.m = $get($1.metrics, $1.i); /*19539*/
			$1.vers = $get($1.m, 0); /*19540*/
			$1.size = $get($1.m, 1); /*19541*/
			$1.alnk = $get($1.m, 2); /*19542*/
			$1.alnn = $get($1.m, 3); /*19543*/
			$1.alnr = $1.size - ($1.alnk * $1.alnn); /*19544*/
			$1.nmod = $get($1.m, 4); /*19545*/
			$1.ncws = ~~($1.nmod / 8); /*19546*/
			$1.rbit = $1.nmod % 8; /*19547*/
			$1.ecbs = $geti($1.m, 5 + ($1.eclval * 3), 3); /*19548*/
			$k[$j++] = "ecws"; /*19549*/
			$k[$j++] = 0; /*19549*/
			$forall($1.ecbs, function() { /*19549*/
				var _J7 = $k[--$j]; /*19549*/
				var _JA = $k[--$j]; /*19549*/
				$k[$j++] = _JA + ($get(_J7, 0) * $get(_J7, 2)); /*19549*/
			}) /*19549*/
			var _JB = $k[--$j]; /*19549*/
			$1[$k[--$j]] = _JB; /*19549*/
			$1.dcws = $1.ncws - $1.ecws; /*19550*/
			$1.dmod = $1.dcws * 8; /*19551*/
			$1.okay = true; /*19552*/
			if ($ne($1.version, "unset") && $ne($1.version, $1.vers)) { /*19553*/
				$1.okay = false; /*19553*/
			} /*19553*/
			if ($1.bits.length > $1.dmod) { /*19554*/
				$1.okay = false; /*19554*/
			} /*19554*/
			if ($1.okay) { /*19555*/
				break; /*19555*/
			} /*19555*/
		} /*19555*/
		if (!$1.okay) { /*19560*/
			$k[$j++] = "bwipp.hanxinNoValidSymbol"; /*19559*/
			$k[$j++] = "No valid symbol available"; /*19559*/
			$0.raiseerror(); /*19559*/
		} /*19559*/
		$1.version = $1.vers; /*19562*/
		$1.msgbits = $1.bits; /*19563*/
		$1.e1nb = $get($get($1.ecbs, 0), 0); /*19564*/
		$1.e2nb = $get($get($1.ecbs, 1), 0); /*19564*/
		$1.e3nb = $get($get($1.ecbs, 2), 0); /*19564*/
		$1.e1dcws = $get($get($1.ecbs, 0), 1); /*19565*/
		$1.e2dcws = $get($get($1.ecbs, 1), 1); /*19565*/
		$1.e3dcws = $get($get($1.ecbs, 2), 1); /*19565*/
		$1.e1ecws = $get($get($1.ecbs, 0), 2); /*19566*/
		$1.e2ecws = $get($get($1.ecbs, 1), 2); /*19566*/
		$1.e3ecws = $get($get($1.ecbs, 2), 2); /*19566*/
		$1.pad = $s($1.dmod); /*19569*/
		for (var _Ju = 0, _Jt = $1.pad.length - 1; _Ju <= _Jt; _Ju += 1) { /*19570*/
			$put($1.pad, _Ju, 48); /*19570*/
		} /*19570*/
		$puti($1.pad, 0, $1.msgbits); /*19571*/
		$1.cws = $a($1.dcws); /*19574*/
		for (var _K2 = 0, _K1 = $1.cws.length - 1; _K2 <= _K1; _K2 += 1) { /*19584*/
			$1.c = _K2; /*19576*/
			$1.cwb = $geti($1.pad, $1.c * 8, 8); /*19577*/
			$1.cw = 0; /*19578*/
			for (var _K6 = 0; _K6 <= 7; _K6 += 1) { /*19582*/
				$1.i = _K6; /*19580*/
				$1.cw = $1.cw + ((~~(Math.pow(2, (8 - $1.i) - 1))) * ($get($1.cwb, $1.i) - 48)); /*19581*/
			} /*19581*/
			$put($1.cws, $1.c, $1.cw); /*19583*/
		} /*19583*/
		$1.rscodes = function() {
			$1.rspm = $k[--$j]; /*19588*/
			$1.rsgf = $k[--$j]; /*19589*/
			$1.rsnc = $k[--$j]; /*19590*/
			$1.rscws = $k[--$j]; /*19591*/
			$k[$j++] = "rsalog"; /*19594*/
			$k[$j++] = Infinity; /*19594*/
			$k[$j++] = 1; /*19594*/
			for (var _KK = 0, _KL = $1.rsgf - 1; _KK < _KL; _KK++) { /*19594*/
				var _KM = $k[--$j]; /*19594*/
				var _KN = _KM * 2; /*19594*/
				$k[$j++] = _KM; /*19594*/
				$k[$j++] = _KN; /*19594*/
				if (_KN >= $1.rsgf) { /*19594*/
					var _KQ = $k[--$j]; /*19594*/
					$k[$j++] = $xo(_KQ, $1.rspm); /*19594*/
				} /*19594*/
			} /*19594*/
			var _KR = $a(); /*19594*/
			$1[$k[--$j]] = _KR; /*19594*/
			$1.rslog = $a($1.rsgf); /*19595*/
			for (var _KX = 1, _KW = $1.rsgf - 1; _KX <= _KW; _KX += 1) { /*19596*/
				$put($1.rslog, $get($1.rsalog, _KX), _KX); /*19596*/
			} /*19596*/
			$1.rsprod = function() {
				var _Kb = $k[--$j]; /*19600*/
				var _Kc = $k[--$j]; /*19600*/
				$k[$j++] = _Kc; /*19604*/
				$k[$j++] = _Kb; /*19604*/
				if ((_Kb != 0) && (_Kc != 0)) { /*19603*/
					var _Kf = $get($1.rslog, $k[--$j]); /*19601*/
					var _Kl = $get($1.rsalog, (_Kf + $get($1.rslog, $k[--$j])) % ($1.rsgf - 1)); /*19601*/
					$k[$j++] = _Kl; /*19601*/
				} else { /*19603*/
					$j -= 2; /*19603*/
					$k[$j++] = 0; /*19603*/
				} /*19603*/
			}; /*19605*/
			$k[$j++] = "coeffs"; /*19608*/
			$k[$j++] = Infinity; /*19608*/
			$k[$j++] = 1; /*19608*/
			for (var _Kn = 0, _Ko = $1.rsnc; _Kn < _Ko; _Kn++) { /*19608*/
				$k[$j++] = 0; /*19608*/
			} /*19608*/
			var _Kp = $a(); /*19608*/
			$1[$k[--$j]] = _Kp; /*19608*/
			for (var _Kt = 1, _Ks = $1.rsnc; _Kt <= _Ks; _Kt += 1) { /*19617*/
				$1.i = _Kt; /*19610*/
				$put($1.coeffs, $1.i, $get($1.coeffs, $1.i - 1)); /*19611*/
				for (var _L0 = $1.i - 1; _L0 >= 1; _L0 -= 1) { /*19615*/
					$1.j = _L0; /*19613*/
					$k[$j++] = $1.coeffs; /*19614*/
					$k[$j++] = $1.j; /*19614*/
					$k[$j++] = $get($1.coeffs, $1.j - 1); /*19614*/
					$k[$j++] = $get($1.coeffs, $1.j); /*19614*/
					$k[$j++] = $get($1.rsalog, $1.i); /*19614*/
					$1.rsprod(); /*19614*/
					var _LC = $k[--$j]; /*19614*/
					var _LD = $k[--$j]; /*19614*/
					var _LE = $k[--$j]; /*19614*/
					$put($k[--$j], _LE, $xo(_LD, _LC)); /*19614*/
				} /*19614*/
				$k[$j++] = $1.coeffs; /*19616*/
				$k[$j++] = 0; /*19616*/
				$k[$j++] = $get($1.coeffs, 0); /*19616*/
				$k[$j++] = $get($1.rsalog, $1.i); /*19616*/
				$1.rsprod(); /*19616*/
				var _LM = $k[--$j]; /*19616*/
				var _LN = $k[--$j]; /*19616*/
				$put($k[--$j], _LN, _LM); /*19616*/
			} /*19616*/
			$1.nd = $1.rscws.length; /*19620*/
			$k[$j++] = "rscws"; /*19621*/
			$k[$j++] = Infinity; /*19621*/
			$forall($1.rscws); /*19621*/
			for (var _LS = 0, _LT = $1.rsnc; _LS < _LT; _LS++) { /*19621*/
				$k[$j++] = 0; /*19621*/
			} /*19621*/
			$k[$j++] = 0; /*19621*/
			var _LU = $a(); /*19621*/
			$1[$k[--$j]] = _LU; /*19621*/
			for (var _LY = 0, _LX = $1.nd - 1; _LY <= _LX; _LY += 1) { /*19628*/
				$1.k = $xo($get($1.rscws, _LY), $get($1.rscws, $1.nd)); /*19623*/
				for (var _Lg = 0, _Lf = $1.rsnc - 1; _Lg <= _Lf; _Lg += 1) { /*19627*/
					$1.j = _Lg; /*19625*/
					$k[$j++] = $1.rscws; /*19626*/
					$k[$j++] = $1.nd + $1.j; /*19626*/
					$k[$j++] = $get($1.rscws, ($1.nd + $1.j) + 1); /*19626*/
					$k[$j++] = $1.k; /*19626*/
					$k[$j++] = $get($1.coeffs, ($1.rsnc - $1.j) - 1); /*19626*/
					$1.rsprod(); /*19626*/
					var _Lt = $k[--$j]; /*19626*/
					var _Lu = $k[--$j]; /*19626*/
					var _Lv = $k[--$j]; /*19626*/
					$put($k[--$j], _Lv, $xo(_Lu, _Lt)); /*19626*/
				} /*19626*/
			} /*19626*/
			$k[$j++] = $geti($1.rscws, 0, $1.rscws.length - 1); /*19631*/
		}; /*19633*/
		$1.dcwsb = $a(($1.e1nb + $1.e2nb) + $1.e3nb); /*19636*/
		$1.ecwsb = $a($1.dcwsb.length); /*19637*/
		$1.in = 0; /*19638*/
		$1.out = 0; /*19638*/
		for (var _M7 = 0, _M8 = $1.e1nb; _M7 < _M8; _M7++) { /*19644*/
			$k[$j++] = $geti($1.cws, $1.in, $1.e1dcws); /*19640*/
			$k[$j++] = $1.e1ecws; /*19640*/
			$k[$j++] = 256; /*19640*/
			$k[$j++] = 355; /*19640*/
			$1.rscodes(); /*19640*/
			var _ME = $k[--$j]; /*19641*/
			$put($1.dcwsb, $1.out, $geti(_ME, 0, $1.e1dcws)); /*19641*/
			$put($1.ecwsb, $1.out, $geti(_ME, $1.e1dcws, $1.e1ecws)); /*19642*/
			$1.in = $1.in + $1.e1dcws; /*19643*/
			$1.out = $1.out + 1; /*19643*/
		} /*19643*/
		for (var _MS = 0, _MT = $1.e2nb; _MS < _MT; _MS++) { /*19650*/
			$k[$j++] = $geti($1.cws, $1.in, $1.e2dcws); /*19646*/
			$k[$j++] = $1.e2ecws; /*19646*/
			$k[$j++] = 256; /*19646*/
			$k[$j++] = 355; /*19646*/
			$1.rscodes(); /*19646*/
			var _MZ = $k[--$j]; /*19647*/
			$put($1.dcwsb, $1.out, $geti(_MZ, 0, $1.e2dcws)); /*19647*/
			$put($1.ecwsb, $1.out, $geti(_MZ, $1.e2dcws, $1.e2ecws)); /*19648*/
			$1.in = $1.in + $1.e2dcws; /*19649*/
			$1.out = $1.out + 1; /*19649*/
		} /*19649*/
		for (var _Mn = 0, _Mo = $1.e3nb; _Mn < _Mo; _Mn++) { /*19656*/
			$k[$j++] = $geti($1.cws, $1.in, $1.e3dcws); /*19652*/
			$k[$j++] = $1.e3ecws; /*19652*/
			$k[$j++] = 256; /*19652*/
			$k[$j++] = 355; /*19652*/
			$1.rscodes(); /*19652*/
			var _Mu = $k[--$j]; /*19653*/
			$put($1.dcwsb, $1.out, $geti(_Mu, 0, $1.e3dcws)); /*19653*/
			$put($1.ecwsb, $1.out, $geti(_Mu, $1.e3dcws, $1.e3ecws)); /*19654*/
			$1.in = $1.in + $1.e3dcws; /*19655*/
			$1.out = $1.out + 1; /*19655*/
		} /*19655*/
		$1.cws = $a($1.ncws); /*19659*/
		$1.cw = 0; /*19660*/
		for (var _NB = 0, _NA = $1.dcwsb.length - 1; _NB <= _NA; _NB += 1) { /*19665*/
			$1.i = _NB; /*19662*/
			var _NE = $get($1.dcwsb, $1.i); /*19663*/
			$puti($1.cws, $1.cw, _NE); /*19663*/
			$1.cw = _NE.length + $1.cw; /*19663*/
			var _NK = $get($1.ecwsb, $1.i); /*19664*/
			$puti($1.cws, $1.cw, _NK); /*19664*/
			$1.cw = _NK.length + $1.cw; /*19664*/
		} /*19664*/
		$k[$j++] = "cws"; /*19670*/
		$k[$j++] = Infinity; /*19670*/
		var _NO = $1.ncws; /*19669*/
		var _NP = 12; /*19669*/
		var _NQ = _NO - 1; /*19669*/
		if ((_NO - 1) > 12) { /*19669*/
			var _ = _NP; /*19669*/
			_NP = _NQ; /*19669*/
			_NQ = _; /*19669*/
		} /*19669*/
		for (var _NS = 0, _NR = _NQ; _NS <= _NR; _NS += 1) { /*19671*/
			for (var _NV = _NS, _NU = $1.ncws - 1; _NV <= _NU; _NV += 13) { /*19670*/
				$k[$j++] = _NV; /*19670*/
				if (_NV < $1.ncws) { /*19670*/
					var _NZ = $get($1.cws, $k[--$j]); /*19670*/
					$k[$j++] = _NZ; /*19670*/
				} else { /*19670*/
					$j--; /*19670*/
				} /*19670*/
			} /*19670*/
		} /*19670*/
		var _Na = $a(); /*19670*/
		$1[$k[--$j]] = _Na; /*19672*/
		if ($1.rbit > 0) { /*19680*/
			$1.pad = $a($1.cws.length + 1); /*19676*/
			$puti($1.pad, 0, $1.cws); /*19677*/
			$put($1.pad, $1.pad.length - 1, 0); /*19678*/
			$1.cws = $1.pad; /*19679*/
		} /*19679*/
		$k[$j++] = "pixs"; /*19683*/
		$k[$j++] = Infinity; /*19683*/
		for (var _Nm = 0, _Nn = $1.size * $1.size; _Nm < _Nn; _Nm++) { /*19683*/
			$k[$j++] = -1; /*19683*/
		} /*19683*/
		var _No = $a(); /*19683*/
		$1[$k[--$j]] = _No; /*19683*/
		$1.qmv = function() {
			var _Nr = $k[--$j]; /*19684*/
			var _Ns = $k[--$j]; /*19684*/
			$k[$j++] = _Ns + (_Nr * $1.size); /*19684*/
		}; /*19684*/
		if ($1.alnn != 0) { /*19743*/
			$1.trmv = function() {
				var _Nv = $k[--$j]; /*19688*/
				var _Nx = $k[--$j]; /*19688*/
				$k[$j++] = (((_Nv * $1.size) + $1.size) - 1) - _Nx; /*19688*/
			}; /*19688*/
			$1.aplot = function() {
				var _Ny = $k[--$j]; /*19690*/
				var _Nz = $k[--$j]; /*19690*/
				var _O0 = $k[--$j]; /*19690*/
				$k[$j++] = _Ny; /*19690*/
				$k[$j++] = _O0; /*19690*/
				$k[$j++] = _Nz; /*19690*/
				$k[$j++] = _Ny; /*19690*/
				$k[$j++] = _Nz; /*19690*/
				$k[$j++] = _O0; /*19690*/
				$1.trmv(); /*19690*/
				var _O2 = $k[--$j]; /*19690*/
				$put($1.pixs, _O2, $k[--$j]); /*19690*/
				$1.trmv(); /*19691*/
				var _O5 = $k[--$j]; /*19691*/
				$put($1.pixs, _O5, $k[--$j]); /*19691*/
			}; /*19692*/
			$1.i = 0; /*19693*/
			$1.stag = 0; /*19693*/
			for (;;) { /*19715*/
				if ($1.i >= $1.size) { /*19694*/
					break; /*19694*/
				} /*19694*/
				for (var _OB = 0, _OA = $1.size - 1; _OB <= _OA; _OB += 1) { /*19708*/
					$1.j = _OB; /*19696*/
					if (($1.j + $1.alnr) < $1.size) { /*19702*/
						$k[$j++] = (((((~~($1.j / $1.alnk)) + $1.stag) % 2) == 0) && (!(($1.i == 0) && ($1.j < $1.alnk)))) || (($1.j % $1.alnk) == 0); /*19700*/
					} else { /*19702*/
						$k[$j++] = (($1.alnn + $1.stag) % 2) == 0; /*19702*/
					} /*19702*/
					if ($k[--$j]) { /*19707*/
						$k[$j++] = $1.j; /*19705*/
						$k[$j++] = $1.i; /*19705*/
						$k[$j++] = 1; /*19705*/
						$1.aplot(); /*19705*/
						var _OS = $1.j; /*19706*/
						var _OT = $1.i; /*19706*/
						$k[$j++] = _OS + 1; /*19706*/
						$k[$j++] = _OT + 1; /*19706*/
						if (((_OT + 1) < $1.size) && ((_OS + 1) < $1.size)) { /*19706*/
							$k[$j++] = 0; /*19706*/
							$1.aplot(); /*19706*/
						} else { /*19706*/
							$j -= 2; /*19706*/
						} /*19706*/
					} /*19706*/
				} /*19706*/
				if (($1.i + $1.alnr) == $1.size) { /*19712*/
					$1.i = ($1.i + $1.alnr) - 1; /*19710*/
				} else { /*19712*/
					$1.i = $1.i + $1.alnk; /*19712*/
				} /*19712*/
				$1.stag = 1 - $1.stag; /*19714*/
			} /*19714*/
			for (var _Oi = $1.alnk, _Oj = $1.alnk, _Oh = $1.size - 2; _Oj < 0 ? _Oi >= _Oh : _Oi <= _Oh; _Oi += _Oj) { /*19742*/
				$1.i = _Oi; /*19717*/
				if (((~~($1.i / $1.alnk)) % 2) != 0) { /*19729*/
					$k[$j++] = $1.pixs; /*19719*/
					$k[$j++] = 0; /*19719*/
					$k[$j++] = $1.i - 1; /*19719*/
					$1.trmv(); /*19719*/
					var _Oo = $k[--$j]; /*19719*/
					$put($k[--$j], _Oo, 0); /*19719*/
					$k[$j++] = $1.pixs; /*19720*/
					$k[$j++] = 0; /*19720*/
					$k[$j++] = $1.i + 1; /*19720*/
					$1.trmv(); /*19720*/
					var _Os = $k[--$j]; /*19720*/
					$put($k[--$j], _Os, 0); /*19720*/
					$k[$j++] = $1.pixs; /*19721*/
					$k[$j++] = 1; /*19721*/
					$k[$j++] = $1.i - 1; /*19721*/
					$1.trmv(); /*19721*/
					var _Ow = $k[--$j]; /*19721*/
					$put($k[--$j], _Ow, 0); /*19721*/
					$k[$j++] = $1.pixs; /*19722*/
					$k[$j++] = 1; /*19722*/
					$k[$j++] = $1.i; /*19722*/
					$1.trmv(); /*19722*/
					var _P0 = $k[--$j]; /*19722*/
					$put($k[--$j], _P0, 0); /*19722*/
					$k[$j++] = $1.pixs; /*19723*/
					$k[$j++] = 1; /*19723*/
					$k[$j++] = $1.i + 1; /*19723*/
					$1.trmv(); /*19723*/
					var _P4 = $k[--$j]; /*19723*/
					$put($k[--$j], _P4, 0); /*19723*/
					$k[$j++] = $1.pixs; /*19724*/
					$k[$j++] = $1.i - 1; /*19724*/
					$k[$j++] = 0; /*19724*/
					$1.trmv(); /*19724*/
					var _P8 = $k[--$j]; /*19724*/
					$put($k[--$j], _P8, 0); /*19724*/
					$k[$j++] = $1.pixs; /*19725*/
					$k[$j++] = $1.i + 1; /*19725*/
					$k[$j++] = 0; /*19725*/
					$1.trmv(); /*19725*/
					var _PC = $k[--$j]; /*19725*/
					$put($k[--$j], _PC, 0); /*19725*/
					$k[$j++] = $1.pixs; /*19726*/
					$k[$j++] = $1.i - 1; /*19726*/
					$k[$j++] = 1; /*19726*/
					$1.trmv(); /*19726*/
					var _PG = $k[--$j]; /*19726*/
					$put($k[--$j], _PG, 0); /*19726*/
					$k[$j++] = $1.pixs; /*19727*/
					$k[$j++] = $1.i; /*19727*/
					$k[$j++] = 1; /*19727*/
					$1.trmv(); /*19727*/
					var _PK = $k[--$j]; /*19727*/
					$put($k[--$j], _PK, 0); /*19727*/
					$k[$j++] = $1.pixs; /*19728*/
					$k[$j++] = $1.i + 1; /*19728*/
					$k[$j++] = 1; /*19728*/
					$1.trmv(); /*19728*/
					var _PO = $k[--$j]; /*19728*/
					$put($k[--$j], _PO, 0); /*19728*/
				} /*19728*/
				$k[$j++] = $1.pixs; /*19730*/
				$k[$j++] = $1.size - 1; /*19730*/
				$k[$j++] = $1.i - 1; /*19730*/
				$1.trmv(); /*19730*/
				var _PT = $k[--$j]; /*19730*/
				if ($get($k[--$j], _PT) != 1) { /*19741*/
					$k[$j++] = $1.pixs; /*19731*/
					$k[$j++] = $1.size - 1; /*19731*/
					$k[$j++] = $1.i - 1; /*19731*/
					$1.trmv(); /*19731*/
					var _PZ = $k[--$j]; /*19731*/
					$put($k[--$j], _PZ, 0); /*19731*/
					$k[$j++] = $1.pixs; /*19732*/
					$k[$j++] = $1.size - 2; /*19732*/
					$k[$j++] = $1.i - 1; /*19732*/
					$1.trmv(); /*19732*/
					var _Pe = $k[--$j]; /*19732*/
					$put($k[--$j], _Pe, 0); /*19732*/
					$k[$j++] = $1.pixs; /*19733*/
					$k[$j++] = $1.size - 2; /*19733*/
					$k[$j++] = $1.i; /*19733*/
					$1.trmv(); /*19733*/
					var _Pj = $k[--$j]; /*19733*/
					$put($k[--$j], _Pj, 0); /*19733*/
					$k[$j++] = $1.pixs; /*19734*/
					$k[$j++] = $1.size - 2; /*19734*/
					$k[$j++] = $1.i + 1; /*19734*/
					$1.trmv(); /*19734*/
					var _Po = $k[--$j]; /*19734*/
					$put($k[--$j], _Po, 0); /*19734*/
					$k[$j++] = $1.pixs; /*19735*/
					$k[$j++] = $1.size - 1; /*19735*/
					$k[$j++] = $1.i + 1; /*19735*/
					$1.trmv(); /*19735*/
					var _Pt = $k[--$j]; /*19735*/
					$put($k[--$j], _Pt, 0); /*19735*/
					$k[$j++] = $1.pixs; /*19736*/
					$k[$j++] = $1.i - 1; /*19736*/
					$k[$j++] = $1.size - 1; /*19736*/
					$1.trmv(); /*19736*/
					var _Py = $k[--$j]; /*19736*/
					$put($k[--$j], _Py, 0); /*19736*/
					$k[$j++] = $1.pixs; /*19737*/
					$k[$j++] = $1.i - 1; /*19737*/
					$k[$j++] = $1.size - 2; /*19737*/
					$1.trmv(); /*19737*/
					var _Q3 = $k[--$j]; /*19737*/
					$put($k[--$j], _Q3, 0); /*19737*/
					$k[$j++] = $1.pixs; /*19738*/
					$k[$j++] = $1.i; /*19738*/
					$k[$j++] = $1.size - 2; /*19738*/
					$1.trmv(); /*19738*/
					var _Q8 = $k[--$j]; /*19738*/
					$put($k[--$j], _Q8, 0); /*19738*/
					$k[$j++] = $1.pixs; /*19739*/
					$k[$j++] = $1.i + 1; /*19739*/
					$k[$j++] = $1.size - 2; /*19739*/
					$1.trmv(); /*19739*/
					var _QD = $k[--$j]; /*19739*/
					$put($k[--$j], _QD, 0); /*19739*/
					$k[$j++] = $1.pixs; /*19740*/
					$k[$j++] = $1.i + 1; /*19740*/
					$k[$j++] = $1.size - 1; /*19740*/
					$1.trmv(); /*19740*/
					var _QI = $k[--$j]; /*19740*/
					$put($k[--$j], _QI, 0); /*19740*/
				} /*19740*/
			} /*19740*/
		} /*19740*/
		$1.fpat = $a([$a([1, 1, 1, 1, 1, 1, 1, 0]), $a([1, 0, 0, 0, 0, 0, 0, 0]), $a([1, 0, 1, 1, 1, 1, 1, 0]), $a([1, 0, 1, 0, 0, 0, 0, 0]), $a([1, 0, 1, 0, 1, 1, 1, 0]), $a([1, 0, 1, 0, 1, 1, 1, 0]), $a([1, 0, 1, 0, 1, 1, 1, 0]), $a([0, 0, 0, 0, 0, 0, 0, 0])]); /*19755*/
		$1.fpat2 = $a([$a([1, 1, 1, 0, 1, 0, 1, 0]), $a([1, 1, 1, 0, 1, 0, 1, 0]), $a([1, 1, 1, 0, 1, 0, 1, 0]), $a([0, 0, 0, 0, 1, 0, 1, 0]), $a([1, 1, 1, 1, 1, 0, 1, 0]), $a([0, 0, 0, 0, 0, 0, 1, 0]), $a([1, 1, 1, 1, 1, 1, 1, 0]), $a([0, 0, 0, 0, 0, 0, 0, 0])]); /*19765*/
		for (var _Qe = 0, _Qd = $1.fpat.length - 1; _Qe <= _Qd; _Qe += 1) { /*19777*/
			$1.y = _Qe; /*19767*/
			for (var _Qi = 0, _Qh = $get($1.fpat, 0).length - 1; _Qi <= _Qh; _Qi += 1) { /*19776*/
				$1.x = _Qi; /*19769*/
				$1.fpb = $get($get($1.fpat, $1.y), $1.x); /*19770*/
				$1.fpb2 = $get($get($1.fpat2, $1.y), $1.x); /*19771*/
				$k[$j++] = $1.pixs; /*19772*/
				$k[$j++] = $1.x; /*19772*/
				$k[$j++] = $1.y; /*19772*/
				$1.qmv(); /*19772*/
				var _Qx = $k[--$j]; /*19772*/
				$put($k[--$j], _Qx, $1.fpb); /*19772*/
				$k[$j++] = $1.pixs; /*19773*/
				$k[$j++] = ($1.size - $1.x) - 1; /*19773*/
				$k[$j++] = $1.y; /*19773*/
				$1.qmv(); /*19773*/
				var _R4 = $k[--$j]; /*19773*/
				$put($k[--$j], _R4, $1.fpb); /*19773*/
				$k[$j++] = $1.pixs; /*19774*/
				$k[$j++] = ($1.size - $1.x) - 1; /*19774*/
				$k[$j++] = ($1.size - $1.y) - 1; /*19774*/
				$1.qmv(); /*19774*/
				var _RC = $k[--$j]; /*19774*/
				$put($k[--$j], _RC, $1.fpb); /*19774*/
				$k[$j++] = $1.pixs; /*19775*/
				$k[$j++] = $1.x; /*19775*/
				$k[$j++] = ($1.size - $1.y) - 1; /*19775*/
				$1.qmv(); /*19775*/
				var _RJ = $k[--$j]; /*19775*/
				$put($k[--$j], _RJ, $1.fpb2); /*19775*/
			} /*19775*/
		} /*19775*/
		$1.functionmap = $a([$a([$a([0, 8]), $a([$1.size - 1, $1.size - 9])]), $a([$a([1, 8]), $a([$1.size - 2, $1.size - 9])]), $a([$a([2, 8]), $a([$1.size - 3, $1.size - 9])]), $a([$a([3, 8]), $a([$1.size - 4, $1.size - 9])]), $a([$a([4, 8]), $a([$1.size - 5, $1.size - 9])]), $a([$a([5, 8]), $a([$1.size - 6, $1.size - 9])]), $a([$a([6, 8]), $a([$1.size - 7, $1.size - 9])]), $a([$a([7, 8]), $a([$1.size - 8, $1.size - 9])]), $a([$a([8, 8]), $a([$1.size - 9, $1.size - 9])]), $a([$a([8, 7]), $a([$1.size - 9, $1.size - 8])]), $a([$a([8, 6]), $a([$1.size - 9, $1.size - 7])]), $a([$a([8, 5]), $a([$1.size - 9, $1.size - 6])]), $a([$a([8, 4]), $a([$1.size - 9, $1.size - 5])]), $a([$a([8, 3]), $a([$1.size - 9, $1.size - 4])]), $a([$a([8, 2]), $a([$1.size - 9, $1.size - 3])]), $a([$a([8, 1]), $a([$1.size - 9, $1.size - 2])]), $a([$a([8, 0]), $a([$1.size - 9, $1.size - 1])]), $a([$a([$1.size - 9, 0]), $a([8, $1.size - 1])]), $a([$a([$1.size - 9, 1]), $a([8, $1.size - 2])]), $a([$a([$1.size - 9, 2]), $a([8, $1.size - 3])]), $a([$a([$1.size - 9, 3]), $a([8, $1.size - 4])]), $a([$a([$1.size - 9, 4]), $a([8, $1.size - 5])]), $a([$a([$1.size - 9, 5]), $a([8, $1.size - 6])]), $a([$a([$1.size - 9, 6]), $a([8, $1.size - 7])]), $a([$a([$1.size - 9, 7]), $a([8, $1.size - 8])]), $a([$a([$1.size - 9, 8]), $a([8, $1.size - 9])]), $a([$a([$1.size - 8, 8]), $a([7, $1.size - 9])]), $a([$a([$1.size - 7, 8]), $a([6, $1.size - 9])]), $a([$a([$1.size - 6, 8]), $a([5, $1.size - 9])]), $a([$a([$1.size - 5, 8]), $a([4, $1.size - 9])]), $a([$a([$1.size - 4, 8]), $a([3, $1.size - 9])]), $a([$a([$1.size - 3, 8]), $a([2, $1.size - 9])]), $a([$a([$1.size - 2, 8]), $a([1, $1.size - 9])]), $a([$a([$1.size - 1, 8]), $a([0, $1.size - 9])])]); /*19799*/
		var _U6 = $1.functionmap; /*19800*/
		for (var _U7 = 0, _U8 = _U6.length; _U7 < _U8; _U7++) { /*19802*/
			$forall($get(_U6, _U7), function() { /*19801*/
				$forall($k[--$j]); /*19801*/
				$1.qmv(); /*19801*/
				$put($1.pixs, $k[--$j], 0); /*19801*/
			}) /*19801*/
		} /*19801*/
		var _UJ = $a([function() {
			$j -= 2; /*19805*/
			$k[$j++] = 1; /*19805*/
		}, function() {
			var _UD = $k[--$j]; /*19806*/
			var _UE = $k[--$j]; /*19806*/
			$k[$j++] = (_UE + _UD) % 2; /*19806*/
		}, function() {
			var _UF = $k[--$j]; /*19807*/
			var _UG = $k[--$j]; /*19807*/
			$k[$j++] = (((_UF + _UG) % 3) + (_UG % 3)) % 2; /*19807*/
		}, function() {
			var _UH = $k[--$j]; /*19808*/
			var _UI = $k[--$j]; /*19808*/
			$k[$j++] = ((_UI % _UH) + ((_UH % _UI) + ((_UH % 3) + (_UI % 3)))) % 2; /*19809*/
		}]); /*19809*/
		$1.maskfuncs = _UJ; /*19810*/
		if ($1.mask != -1) { /*19814*/
			$1.maskfuncs = $a([$get($1.maskfuncs, $1.mask - 1)]); /*19812*/
			$1.bestmaskval = $1.mask - 1; /*19813*/
		} /*19813*/
		$1.masks = $a($1.maskfuncs.length); /*19815*/
		for (var _UU = 0, _UT = $1.masks.length - 1; _UU <= _UT; _UU += 1) { /*19829*/
			$1.m = _UU; /*19817*/
			$1.mask = $a($1.size * $1.size); /*19818*/
			for (var _Ua = 0, _UZ = $1.size - 1; _Ua <= _UZ; _Ua += 1) { /*19827*/
				$1.j = _Ua; /*19820*/
				for (var _Ud = 0, _Uc = $1.size - 1; _Ud <= _Uc; _Ud += 1) { /*19826*/
					$1.i = _Ud; /*19822*/
					$k[$j++] = $1.i + 1; /*19823*/
					$k[$j++] = $1.j + 1; /*19823*/
					$get($1.maskfuncs, $1.m)(); /*19823*/
					var _Uj = $k[--$j]; /*19823*/
					$k[$j++] = _Uj == 0; /*19824*/
					$k[$j++] = $1.pixs; /*19824*/
					$k[$j++] = $1.i; /*19824*/
					$k[$j++] = $1.j; /*19824*/
					$1.qmv(); /*19824*/
					var _Un = $k[--$j]; /*19824*/
					var _Up = $get($k[--$j], _Un); /*19824*/
					var _Ur = ($k[--$j] && (_Up == -1)) ? 1 : 0; /*19824*/
					$k[$j++] = _Ur; /*19825*/
					$k[$j++] = $1.mask; /*19825*/
					$k[$j++] = $1.i; /*19825*/
					$k[$j++] = $1.j; /*19825*/
					$1.qmv(); /*19825*/
					var _Uv = $k[--$j]; /*19825*/
					var _Uw = $k[--$j]; /*19825*/
					$put(_Uw, _Uv, $k[--$j]); /*19825*/
				} /*19825*/
			} /*19825*/
			$put($1.masks, $1.m, $1.mask); /*19828*/
		} /*19828*/
		$1.posx = 0; /*19832*/
		$1.posy = 0; /*19833*/
		$1.num = 0; /*19834*/
		for (;;) { /*19844*/
			if ($1.posy == $1.size) { /*19836*/
				break; /*19836*/
			} /*19836*/
			$k[$j++] = $1.pixs; /*19837*/
			$k[$j++] = $1.posx; /*19837*/
			$k[$j++] = $1.posy; /*19837*/
			$1.qmv(); /*19837*/
			var _V6 = $k[--$j]; /*19837*/
			if ($get($k[--$j], _V6) == -1) { /*19841*/
				var _VB = $get($1.cws, ~~($1.num / 8)); /*19838*/
				var _VD = -(7 - ($1.num % 8)); /*19838*/
				$k[$j++] = ((_VD < 0 ? _VB >>> -_VD : _VB << _VD)) & 1; /*19839*/
				$k[$j++] = $1.pixs; /*19839*/
				$k[$j++] = $1.posx; /*19839*/
				$k[$j++] = $1.posy; /*19839*/
				$1.qmv(); /*19839*/
				var _VH = $k[--$j]; /*19839*/
				var _VI = $k[--$j]; /*19839*/
				$put(_VI, _VH, $k[--$j]); /*19839*/
				$1.num = $1.num + 1; /*19840*/
			} /*19840*/
			$1.posx = $1.posx + 1; /*19842*/
			if ($1.posx == $1.size) { /*19843*/
				$1.posx = 0; /*19843*/
				$1.posy = $1.posy + 1; /*19843*/
			} /*19843*/
		} /*19843*/
		$1.evalfulln1n3 = function() {
			$1.scrle = $k[--$j]; /*19848*/
			$k[$j++] = "scr1"; /*19850*/
			$k[$j++] = 0; /*19850*/
			$forall($1.scrle, function() { /*19850*/
				var _VR = $k[--$j]; /*19850*/
				$k[$j++] = _VR; /*19850*/
				if (_VR >= 3) { /*19850*/
					var _VS = $k[--$j]; /*19850*/
					var _VU = $k[--$j] + (_VS * 4); /*19850*/
					$k[$j++] = _VU; /*19850*/
					$k[$j++] = _VU; /*19850*/
				} /*19850*/
				$j--; /*19850*/
			}) /*19850*/
			var _VV = $k[--$j]; /*19850*/
			$1[$k[--$j]] = _VV; /*19850*/
			$1.scr3 = 0; /*19851*/
			for (var _VZ = 5, _VY = $1.scrle.length - 1; _VZ <= _VY; _VZ += 2) { /*19867*/
				$1.j = _VZ; /*19854*/
				if (($get($1.scrle, $1.j) % 3) == 0) { /*19866*/
					$1.fact = ~~($get($1.scrle, $1.j) / 3); /*19856*/
					$forall($geti($1.scrle, $1.j - 4, 4), function() { /*19857*/
						var _Vk = $k[--$j]; /*19857*/
						$k[$j++] = _Vk == $1.fact; /*19857*/
					}) /*19857*/
					var _Vl = $k[--$j]; /*19857*/
					var _Vm = $k[--$j]; /*19857*/
					var _Vn = $k[--$j]; /*19857*/
					if ($k[--$j] && (_Vn && (_Vm && _Vl))) { /*19865*/
						if (($1.j == 5) || (($1.j + 2) >= $1.scrle.length)) { /*19862*/
							$1.scr3 = $1.scr3 + 50; /*19859*/
						} else { /*19862*/
							if (($get($1.scrle, $1.j - 5) >= 3) || ($get($1.scrle, $1.j + 1) >= 3)) { /*19863*/
								$1.scr3 = $1.scr3 + 50; /*19862*/
							} /*19862*/
						} /*19862*/
					} /*19862*/
				} /*19862*/
			} /*19862*/
			for (var _W2 = 1, _W1 = $1.scrle.length - 5; _W2 <= _W1; _W2 += 2) { /*19883*/
				$1.j = _W2; /*19870*/
				if (($get($1.scrle, $1.j) % 3) == 0) { /*19882*/
					$1.fact = ~~($get($1.scrle, $1.j) / 3); /*19872*/
					$forall($geti($1.scrle, $1.j + 1, 4), function() { /*19873*/
						var _WD = $k[--$j]; /*19873*/
						$k[$j++] = _WD == $1.fact; /*19873*/
					}) /*19873*/
					var _WE = $k[--$j]; /*19873*/
					var _WF = $k[--$j]; /*19873*/
					var _WG = $k[--$j]; /*19873*/
					if ($k[--$j] && (_WG && (_WF && _WE))) { /*19881*/
						if (($1.j == 1) || (($1.j + 6) >= $1.scrle.length)) { /*19878*/
							$1.scr3 = $1.scr3 + 50; /*19875*/
						} else { /*19878*/
							if (($get($1.scrle, $1.j - 1) >= 3) || ($get($1.scrle, $1.j + 5) >= 3)) { /*19879*/
								$1.scr3 = $1.scr3 + 50; /*19878*/
							} /*19878*/
						} /*19878*/
					} /*19878*/
				} /*19878*/
			} /*19878*/
			$k[$j++] = $1.scr1; /*19884*/
			$k[$j++] = $1.scr3; /*19884*/
		}; /*19885*/
		$1.evalfull = function() {
			$1.sym = $k[--$j]; /*19889*/
			$1.n1 = 0; /*19891*/
			$1.n3 = 0; /*19891*/
			$1.rle = $a($1.size + 1); /*19892*/
			$1.lastpairs = $a($1.size); /*19893*/
			$1.thispairs = $a($1.size); /*19894*/
			$1.sizeadd1 = $1.size + 1; /*19895*/
			for (var _Wf = 0, _We = $1.size - 1; _Wf <= _We; _Wf += 1) { /*19920*/
				$1.i = _Wf; /*19897*/
				$k[$j++] = Infinity; /*19900*/
				var _Wh = $1.size; /*19901*/
				$k[$j++] = 0; /*19903*/
				$k[$j++] = 0; /*19903*/
				for (var _Wj = $1.i, _Wk = _Wh, _Wi = (_Wh * _Wh) - 1; _Wk < 0 ? _Wj >= _Wi : _Wj <= _Wi; _Wj += _Wk) { /*19903*/
					var _Wm = $get($1.sym, _Wj); /*19902*/
					var _Wn = $k[--$j]; /*19902*/
					$k[$j++] = _Wm; /*19902*/
					if ($eq(_Wn, _Wm)) { /*19902*/
						var _Wo = $k[--$j]; /*19902*/
						var _Wp = $k[--$j]; /*19902*/
						$k[$j++] = _Wp + 1; /*19902*/
						$k[$j++] = _Wo; /*19902*/
					} else { /*19902*/
						var _Wq = $k[--$j]; /*19902*/
						$k[$j++] = 1; /*19902*/
						$k[$j++] = _Wq; /*19902*/
					} /*19902*/
				} /*19902*/
				$j--; /*19904*/
				var _Ws = $counttomark() + 2; /*19905*/
				$astore($geti($1.rle, 0, _Ws - 2)); /*19905*/
				$1.evalfulln1n3(); /*19906*/
				$1.n3 = $k[--$j] + $1.n3; /*19906*/
				$1.n1 = $k[--$j] + $1.n1; /*19906*/
				$j--; /*19907*/
				$1.symrow = $geti($1.sym, $1.i * $1.size, $1.size); /*19910*/
				$k[$j++] = Infinity; /*19911*/
				$k[$j++] = 0; /*19914*/
				$k[$j++] = 0; /*19914*/
				$forall($1.symrow, function() { /*19914*/
					var _X4 = $k[--$j]; /*19913*/
					var _X5 = $k[--$j]; /*19913*/
					$k[$j++] = _X4; /*19913*/
					if ($eq(_X5, _X4)) { /*19913*/
						var _X6 = $k[--$j]; /*19913*/
						var _X7 = $k[--$j]; /*19913*/
						$k[$j++] = _X7 + 1; /*19913*/
						$k[$j++] = _X6; /*19913*/
					} else { /*19913*/
						var _X8 = $k[--$j]; /*19913*/
						$k[$j++] = 1; /*19913*/
						$k[$j++] = _X8; /*19913*/
					} /*19913*/
				}) /*19913*/
				$j--; /*19915*/
				var _XA = $counttomark() + 2; /*19916*/
				$astore($geti($1.rle, 0, _XA - 2)); /*19916*/
				$1.evalfulln1n3(); /*19917*/
				$1.n3 = $k[--$j] + $1.n3; /*19917*/
				$1.n1 = $k[--$j] + $1.n1; /*19917*/
				$j--; /*19918*/
			} /*19918*/
			$k[$j++] = $1.n1 + $1.n3; /*19922*/
		}; /*19923*/
		$1.bestscore = 999999999; /*19926*/
		for (var _XK = 0, _XJ = $1.masks.length - 1; _XK <= _XJ; _XK += 1) { /*19944*/
			$1.m = _XK; /*19928*/
			$1.masksym = $a($1.size * $1.size); /*19929*/
			for (var _XR = 0, _XQ = ($1.size * $1.size) - 1; _XR <= _XQ; _XR += 1) { /*19933*/
				$1.i = _XR; /*19931*/
				$put($1.masksym, $1.i, $xo($get($1.pixs, $1.i), $get($get($1.masks, $1.m), $1.i))); /*19932*/
			} /*19932*/
			if ($1.masks.length != 1) { /*19942*/
				$k[$j++] = $1.masksym; /*19935*/
				$1.evalfull(); /*19935*/
				$1.score = $k[--$j]; /*19935*/
				if ($1.score < $1.bestscore) { /*19940*/
					$1.bestsym = $1.masksym; /*19937*/
					$1.bestmaskval = $1.m; /*19938*/
					$1.bestscore = $1.score; /*19939*/
				} /*19939*/
			} else { /*19942*/
				$1.bestsym = $1.masksym; /*19942*/
			} /*19942*/
		} /*19942*/
		$1.pixs = $1.bestsym; /*19945*/
		$1.funval = (((((~~(($1.size - 21) / 2)) + 20) * 4) + $1.eclval) * 4) + $1.bestmaskval; /*19948*/
		$k[$j++] = $a([($1.funval & 3840) >>> 8, ($1.funval & 240) >>> 4, $1.funval & 15]); /*19952*/
		$k[$j++] = 4; /*19952*/
		$k[$j++] = 16; /*19952*/
		$k[$j++] = 19; /*19952*/
		$1.rscodes(); /*19952*/
		$1.funvals = $k[--$j]; /*19952*/
		$k[$j++] = "funbits"; /*19957*/
		$k[$j++] = Infinity; /*19957*/
		$forall($1.funvals, function() { /*19956*/
			$k[$j++] = 4; /*19955*/
			$1.tobin(); /*19955*/
			$forall($k[--$j], function() { /*19955*/
				var _Xw = $k[--$j]; /*19955*/
				$k[$j++] = _Xw - 48; /*19955*/
			}) /*19955*/
		}) /*19955*/
		$k[$j++] = 0; /*19957*/
		$k[$j++] = 1; /*19957*/
		$k[$j++] = 0; /*19957*/
		$k[$j++] = 1; /*19957*/
		$k[$j++] = 0; /*19957*/
		$k[$j++] = 1; /*19957*/
		var _Xx = $a(); /*19957*/
		$1[$k[--$j]] = _Xx; /*19958*/
		for (var _Y1 = 0, _Y0 = $1.functionmap.length - 1; _Y1 <= _Y0; _Y1 += 1) { /*19964*/
			$1.i = _Y1; /*19960*/
			$forall($get($1.functionmap, $1.i), function() { /*19963*/
				var _Y6 = $k[--$j]; /*19962*/
				$k[$j++] = $1.pixs; /*19962*/
				$aload(_Y6); /*19962*/
				$1.qmv(); /*19962*/
				var _YA = $k[--$j]; /*19962*/
				$put($k[--$j], _YA, $get($1.funbits, $1.i)); /*19962*/
			}) /*19962*/
		} /*19962*/
		var _YI = {
			ren: $0.renmatrix,
			pixs: $1.pixs,
			pixx: $1.size,
			pixy: $1.size,
			height: ($1.size * 2) / 72,
			width: ($1.size * 2) / 72,
			opt: $1.options
		}; /*19974*/
		$k[$j++] = _YI; /*19977*/
		if (!$1.dontdraw) { /*19977*/
			$0.renmatrix(); /*19977*/
		} /*19977*/
	};
	$0["gs1-cc"] = function() {
		var $1 = {}; /*20006*/
		$1.options = $k[--$j]; /*20008*/
		$1.barcode = $k[--$j]; /*20009*/
		$1.dontdraw = false; /*20011*/
		$1.ccversion = "a"; /*20012*/
		$1.cccolumns = -1; /*20013*/
		$1.lintype = ""; /*20014*/
		$1.linwidth = -1; /*20015*/
		$forall($1.options, function() { /*20026*/
			var _3 = $k[--$j]; /*20026*/
			$1[$k[--$j]] = _3; /*20026*/
		}) /*20026*/
		$1.cccolumns = ~~$1.cccolumns; /*20028*/
		$1.linwidth = ~~$1.linwidth; /*20029*/
		if ($1.cccolumns == -1) { /*20048*/
			$k[$j++] = Infinity; /*20046*/
			$k[$j++] = "ean13"; /*20039*/
			$k[$j++] = 4; /*20039*/
			$k[$j++] = "upca"; /*20039*/
			$k[$j++] = 4; /*20039*/
			$k[$j++] = "ean8"; /*20039*/
			$k[$j++] = 3; /*20039*/
			$k[$j++] = "upce"; /*20039*/
			$k[$j++] = 2; /*20039*/
			$k[$j++] = "gs1-128"; /*20039*/
			if ($ne($1.ccversion, "c")) { /*20039*/
				$k[$j++] = 4; /*20039*/
			} else { /*20039*/
				$k[$j++] = ~~(($1.linwidth - 52) / 17); /*20039*/
			} /*20039*/
			$k[$j++] = "databaromni"; /*20046*/
			$k[$j++] = 4; /*20046*/
			$k[$j++] = "databarstacked"; /*20046*/
			$k[$j++] = 2; /*20046*/
			$k[$j++] = "databarstackedomni"; /*20046*/
			$k[$j++] = 2; /*20046*/
			$k[$j++] = "databartruncated"; /*20046*/
			$k[$j++] = 4; /*20046*/
			$k[$j++] = "databarlimited"; /*20046*/
			$k[$j++] = 3; /*20046*/
			$k[$j++] = "databarexpanded"; /*20046*/
			$k[$j++] = 4; /*20046*/
			$k[$j++] = "databarexpandedstacked"; /*20046*/
			$k[$j++] = 4; /*20046*/
			$1.cccolumns = $get($d(), $1.lintype); /*20047*/
		} /*20047*/
		$1.expand = function() {
			$1.in = $k[--$j]; /*20052*/
			$1.out = $s($1.in.length); /*20053*/
			$1.j = 0; /*20054*/
			$k[$j++] = $1.in; /*20068*/
			for (;;) { /*20068*/
				$search($k[--$j], "^"); /*20057*/
				if ($k[--$j]) { /*20066*/
					var _J = $k[--$j]; /*20058*/
					$puti($1.out, $1.j, _J); /*20058*/
					$1.j = (_J.length + $1.j) + 1; /*20059*/
					$j--; /*20060*/
					var _N = $k[--$j]; /*20061*/
					$put($1.out, $1.j - 1, ~~$z($geti(_N, 0, 3))); /*20061*/
					$k[$j++] = $geti(_N, 3, _N.length - 3); /*20062*/
				} else { /*20066*/
					var _S = $k[--$j]; /*20064*/
					$puti($1.out, $1.j, _S); /*20064*/
					$1.j = _S.length + $1.j; /*20065*/
					$k[$j++] = $geti($1.out, 0, $1.j); /*20066*/
					break; /*20066*/
				} /*20066*/
			} /*20066*/
		}; /*20069*/
		$1.ais = $a([]); /*20072*/
		$1.aival = {}; /*20073*/
		var _a = $1.barcode; /*20074*/
		$k[$j++] = $geti(_a, 1, _a.length - 1); /*20086*/
		for (;;) { /*20086*/
			var _c = $k[--$j]; /*20076*/
			$k[$j++] = _c; /*20076*/
			if ($eq(_c, "")) { /*20076*/
				break; /*20076*/
			} /*20076*/
			$search($k[--$j], ")"); /*20077*/
			$j--; /*20077*/
			var _e = $k[--$j]; /*20078*/
			var _f = $k[--$j]; /*20078*/
			var _g = $k[--$j]; /*20079*/
			$k[$j++] = _e; /*20079*/
			$search(_g, "("); /*20079*/
			if ($k[--$j]) { /*20082*/
				var _i = $k[--$j]; /*20080*/
				var _j = $k[--$j]; /*20080*/
				var _k = $k[--$j]; /*20080*/
				var _l = $k[--$j]; /*20080*/
				$k[$j++] = _k; /*20080*/
				$k[$j++] = _l; /*20080*/
				$k[$j++] = _i; /*20080*/
			} else { /*20082*/
				var _m = $k[--$j]; /*20082*/
				var _n = $k[--$j]; /*20082*/
				$k[$j++] = ""; /*20082*/
				$k[$j++] = _n; /*20082*/
				$k[$j++] = _m; /*20082*/
			} /*20082*/
			$k[$j++] = Infinity; /*20084*/
			$aload($1.ais); /*20084*/
			var _q = $k[$j - 1 - ($counttomark() + 2)]; /*20084*/
			$k[$j++] = _q; /*20084*/
			$1.ais = $a(); /*20084*/
			var _t = $k[--$j]; /*20085*/
			var _u = $k[--$j]; /*20085*/
			$k[$j++] = $1.aival; /*20085*/
			$k[$j++] = _u; /*20085*/
			$k[$j++] = _t; /*20085*/
			$1.expand(); /*20085*/
			var _v = $k[--$j]; /*20085*/
			var _w = $k[--$j]; /*20085*/
			$put($k[--$j], _w, _v); /*20085*/
		} /*20085*/
		$j--; /*20087*/
		$1.isupper = function() {
			var _y = $k[--$j]; /*20090*/
			$k[$j++] = (_y >= 65) && (_y <= 90); /*20090*/
		}; /*20090*/
		$1.isnum0 = function() {
			var _z = $k[--$j]; /*20091*/
			$k[$j++] = (_z >= 48) && (_z <= 57); /*20091*/
		}; /*20091*/
		$1.isnum1 = function() {
			var _10 = $k[--$j]; /*20092*/
			$k[$j++] = (_10 >= 49) && (_10 <= 57); /*20092*/
		}; /*20092*/
		for (;;) { /*20138*/
			if ($1.ais.length >= 1) { /*20100*/
				if (($eq($get($1.ais, 0), "10") || $eq($get($1.ais, 0), "11")) || $eq($get($1.ais, 0), "17")) { /*20099*/
					$k[$j++] = -1; /*20098*/
					$k[$j++] = "10"; /*20098*/
					break; /*20098*/
				} /*20098*/
			} /*20098*/
			if ($1.ais.length >= 1) { /*20133*/
				if ($eq($get($1.ais, 0), "90")) { /*20132*/
					$1.v = $1.aival["90"]; /*20105*/
					if ($1.v.length >= 1) { /*20110*/
						$k[$j++] = $get($1.v, 0); /*20107*/
						$1.isupper(); /*20107*/
						if ($k[--$j]) { /*20109*/
							$k[$j++] = 0; /*20108*/
							$k[$j++] = "11"; /*20108*/
							break; /*20108*/
						} /*20108*/
					} /*20108*/
					if ($1.v.length >= 2) { /*20116*/
						$k[$j++] = $get($1.v, 0); /*20112*/
						$1.isnum1(); /*20112*/
						$k[$j++] = $get($1.v, 1); /*20113*/
						$1.isupper(); /*20113*/
						var _1M = $k[--$j]; /*20113*/
						if (($k[--$j] && _1M)) { /*20115*/
							$k[$j++] = 1; /*20114*/
							$k[$j++] = "11"; /*20114*/
							break; /*20114*/
						} /*20114*/
					} /*20114*/
					if ($1.v.length >= 3) { /*20123*/
						$k[$j++] = $get($1.v, 0); /*20118*/
						$1.isnum1(); /*20118*/
						$k[$j++] = $get($1.v, 1); /*20119*/
						$1.isnum0(); /*20119*/
						var _1T = $k[--$j]; /*20119*/
						var _1U = $k[--$j]; /*20119*/
						$k[$j++] = $an(_1U, _1T); /*20120*/
						$k[$j++] = $get($1.v, 2); /*20120*/
						$1.isupper(); /*20120*/
						var _1X = $k[--$j]; /*20120*/
						if (($k[--$j] && _1X)) { /*20122*/
							$k[$j++] = 2; /*20121*/
							$k[$j++] = "11"; /*20121*/
							break; /*20121*/
						} /*20121*/
					} /*20121*/
					if ($1.v.length >= 4) { /*20131*/
						$k[$j++] = $get($1.v, 0); /*20125*/
						$1.isnum1(); /*20125*/
						$k[$j++] = $get($1.v, 1); /*20126*/
						$1.isnum0(); /*20126*/
						var _1e = $k[--$j]; /*20126*/
						var _1f = $k[--$j]; /*20126*/
						$k[$j++] = $an(_1f, _1e); /*20127*/
						$k[$j++] = $get($1.v, 2); /*20127*/
						$1.isnum0(); /*20127*/
						var _1i = $k[--$j]; /*20127*/
						var _1j = $k[--$j]; /*20127*/
						$k[$j++] = $an(_1j, _1i); /*20128*/
						$k[$j++] = $get($1.v, 3); /*20128*/
						$1.isupper(); /*20128*/
						var _1m = $k[--$j]; /*20128*/
						if (($k[--$j] && _1m)) { /*20130*/
							$k[$j++] = 3; /*20129*/
							$k[$j++] = "11"; /*20129*/
							break; /*20129*/
						} /*20129*/
					} /*20129*/
				} /*20129*/
			} /*20129*/
			$k[$j++] = -1; /*20136*/
			$k[$j++] = "0"; /*20136*/
			break; /*20136*/
		} /*20136*/
		$1.method = $k[--$j]; /*20139*/
		$1.npre = $k[--$j]; /*20140*/
		$1.fnc1 = -1; /*20142*/
		$1.lnumeric = -2; /*20142*/
		$1.lalphanumeric = -3; /*20142*/
		$1.liso646 = -4; /*20142*/
		$1.tobin = function() {
			var _1r = $s($k[--$j]); /*20145*/
			$k[$j++] = _1r; /*20145*/
			for (var _1t = 0, _1s = _1r.length - 1; _1t <= _1s; _1t += 1) { /*20145*/
				var _1u = $k[--$j]; /*20145*/
				$put(_1u, _1t, 48); /*20145*/
				$k[$j++] = _1u; /*20145*/
			} /*20145*/
			var _1v = $k[--$j]; /*20146*/
			var _1y = $cvrs($s(_1v.length), $k[--$j], 2); /*20146*/
			$puti(_1v, _1v.length - _1y.length, _1y); /*20146*/
			$k[$j++] = _1v; /*20146*/
		}; /*20147*/
		$k[$j++] = "alpha"; /*20152*/
		$k[$j++] = Infinity; /*20152*/
		for (var _1z = 65; _1z <= 90; _1z += 1) { /*20150*/
			$k[$j++] = _1z; /*20150*/
			$k[$j++] = _1z - 65; /*20150*/
			$k[$j++] = 5; /*20150*/
			$1.tobin(); /*20150*/
		} /*20150*/
		for (var _20 = 48; _20 <= 57; _20 += 1) { /*20151*/
			$k[$j++] = _20; /*20151*/
			$k[$j++] = _20 + 4; /*20151*/
			$k[$j++] = 6; /*20151*/
			$1.tobin(); /*20151*/
		} /*20151*/
		$k[$j++] = $1.fnc1; /*20152*/
		$k[$j++] = "11111"; /*20152*/
		var _22 = $d(); /*20152*/
		$1[$k[--$j]] = _22; /*20153*/
		$k[$j++] = "numeric"; /*20165*/
		$k[$j++] = Infinity; /*20165*/
		for (var _24 = 0; _24 <= 119; _24 += 1) { /*20164*/
			var _26 = $strcpy($s(2), "00"); /*20157*/
			var _28 = $cvrs($s(2), _24, 11); /*20157*/
			$puti(_26, 2 - _28.length, _28); /*20158*/
			$k[$j++] = _24; /*20159*/
			$k[$j++] = _26; /*20159*/
			if ($get(_26, 0) == 65) { /*20159*/
				var _2A = $k[--$j]; /*20159*/
				$put(_2A, 0, 94); /*20159*/
				$k[$j++] = _2A; /*20159*/
			} /*20159*/
			var _2B = $k[--$j]; /*20160*/
			$k[$j++] = _2B; /*20160*/
			if ($get(_2B, 1) == 65) { /*20160*/
				var _2D = $k[--$j]; /*20160*/
				$put(_2D, 1, 94); /*20160*/
				$k[$j++] = _2D; /*20160*/
			} /*20160*/
			var _2E = $k[--$j]; /*20161*/
			var _2H = $strcpy($s(7), "0000000"); /*20162*/
			var _2J = $cvrs($s(7), $k[--$j] + 8, 2); /*20162*/
			$puti(_2H, 7 - _2J.length, _2J); /*20163*/
			$k[$j++] = _2E; /*20163*/
			$k[$j++] = _2H; /*20163*/
		} /*20163*/
		$k[$j++] = $1.lalphanumeric; /*20165*/
		$k[$j++] = "0000"; /*20165*/
		var _2L = $d(); /*20165*/
		$1[$k[--$j]] = _2L; /*20166*/
		$k[$j++] = "alphanumeric"; /*20175*/
		$k[$j++] = Infinity; /*20175*/
		for (var _2N = 48; _2N <= 57; _2N += 1) { /*20169*/
			$k[$j++] = _2N; /*20169*/
			$k[$j++] = _2N - 43; /*20169*/
			$k[$j++] = 5; /*20169*/
			$1.tobin(); /*20169*/
		} /*20169*/
		$k[$j++] = $1.fnc1; /*20171*/
		$k[$j++] = "01111"; /*20171*/
		for (var _2P = 65; _2P <= 90; _2P += 1) { /*20171*/
			$k[$j++] = _2P; /*20171*/
			$k[$j++] = _2P - 33; /*20171*/
			$k[$j++] = 6; /*20171*/
			$1.tobin(); /*20171*/
		} /*20171*/
		$k[$j++] = 42; /*20173*/
		$k[$j++] = "111010"; /*20173*/
		for (var _2Q = 44; _2Q <= 47; _2Q += 1) { /*20173*/
			$k[$j++] = _2Q; /*20173*/
			$k[$j++] = _2Q + 15; /*20173*/
			$k[$j++] = 6; /*20173*/
			$1.tobin(); /*20173*/
		} /*20173*/
		$k[$j++] = $1.lnumeric; /*20175*/
		$k[$j++] = "000"; /*20175*/
		$k[$j++] = $1.liso646; /*20175*/
		$k[$j++] = "00100"; /*20175*/
		var _2T = $d(); /*20175*/
		$1[$k[--$j]] = _2T; /*20176*/
		$k[$j++] = "iso646"; /*20190*/
		$k[$j++] = Infinity; /*20190*/
		for (var _2V = 48; _2V <= 57; _2V += 1) { /*20179*/
			$k[$j++] = _2V; /*20179*/
			$k[$j++] = _2V - 43; /*20179*/
			$k[$j++] = 5; /*20179*/
			$1.tobin(); /*20179*/
		} /*20179*/
		$k[$j++] = $1.fnc1; /*20181*/
		$k[$j++] = "01111"; /*20181*/
		for (var _2X = 65; _2X <= 90; _2X += 1) { /*20181*/
			$k[$j++] = _2X; /*20181*/
			$k[$j++] = _2X - 1; /*20181*/
			$k[$j++] = 7; /*20181*/
			$1.tobin(); /*20181*/
		} /*20181*/
		for (var _2Y = 97; _2Y <= 122; _2Y += 1) { /*20182*/
			$k[$j++] = _2Y; /*20182*/
			$k[$j++] = _2Y - 7; /*20182*/
			$k[$j++] = 7; /*20182*/
			$1.tobin(); /*20182*/
		} /*20182*/
		$k[$j++] = 33; /*20185*/
		$k[$j++] = "11101000"; /*20185*/
		$k[$j++] = 34; /*20185*/
		$k[$j++] = "11101001"; /*20185*/
		for (var _2Z = 37; _2Z <= 47; _2Z += 1) { /*20185*/
			$k[$j++] = _2Z; /*20185*/
			$k[$j++] = _2Z + 197; /*20185*/
			$k[$j++] = 8; /*20185*/
			$1.tobin(); /*20185*/
		} /*20185*/
		for (var _2a = 58; _2a <= 63; _2a += 1) { /*20186*/
			$k[$j++] = _2a; /*20186*/
			$k[$j++] = _2a + 187; /*20186*/
			$k[$j++] = 8; /*20186*/
			$1.tobin(); /*20186*/
		} /*20186*/
		$k[$j++] = 95; /*20190*/
		$k[$j++] = "11111011"; /*20190*/
		$k[$j++] = 32; /*20190*/
		$k[$j++] = "11111100"; /*20190*/
		$k[$j++] = $1.lnumeric; /*20190*/
		$k[$j++] = "000"; /*20190*/
		$k[$j++] = $1.lalphanumeric; /*20190*/
		$k[$j++] = "00100"; /*20190*/
		var _2d = $d(); /*20190*/
		$1[$k[--$j]] = _2d; /*20191*/
		if ($eq($1.method, "10")) { /*20222*/
			if ($eq($get($1.ais, 0), "11") || $eq($get($1.ais, 0), "17")) { /*20207*/
				var _2n = $get($1.aival, $get($1.ais, 0)); /*20195*/
				var _2s = $strcpy($s(16), "0000000000000000"); /*20199*/
				var _2u = $cvrs($s(16), ((~~$z($geti(_2n, 0, 2))) * 384) + ((((~~$z($geti(_2n, 2, 2))) - 1) * 32) + (~~$z($geti(_2n, 4, 2)))), 2); /*20199*/
				$puti(_2s, 16 - _2u.length, _2u); /*20200*/
				$k[$j++] = _2s; /*20203*/
				$k[$j++] = Infinity; /*20203*/
				var _2v = $k[--$j]; /*20202*/
				var _2w = $k[--$j]; /*20202*/
				$k[$j++] = _2v; /*20202*/
				$k[$j++] = 1; /*20202*/
				$k[$j++] = 0; /*20202*/
				$forall(_2w, function() { /*20202*/
					var _2x = $k[--$j]; /*20202*/
					$k[$j++] = _2x - 48; /*20202*/
				}) /*20202*/
				var _30 = $eq($get($1.ais, 0), "11") ? 0 : 1; /*20203*/
				$k[$j++] = _30; /*20203*/
				$1.cdf = $a(); /*20204*/
				$1.ais = $geti($1.ais, 1, $1.ais.length - 1); /*20205*/
			} else { /*20207*/
				$1.cdf = $a([1, 0, 1, 1]); /*20207*/
			} /*20207*/
			if ($1.ais.length != 0) { /*20219*/
				if ($eq($get($1.ais, 0), "10")) { /*20215*/
					$k[$j++] = "gpf"; /*20211*/
					$k[$j++] = Infinity; /*20211*/
					$forall($1.aival["10"]); /*20211*/
					var _3B = $a(); /*20211*/
					$1[$k[--$j]] = _3B; /*20211*/
					if ($1.ais.length > 1) { /*20212*/
						$k[$j++] = "gpf"; /*20212*/
						$k[$j++] = Infinity; /*20212*/
						$aload($1.gpf); /*20212*/
						$k[$j++] = $1.fnc1; /*20212*/
						var _3G = $a(); /*20212*/
						$1[$k[--$j]] = _3G; /*20212*/
					} /*20212*/
					$1.ais = $geti($1.ais, 1, $1.ais.length - 1); /*20213*/
				} else { /*20215*/
					$1.gpf = $a([$1.fnc1]); /*20215*/
				} /*20215*/
			} else { /*20219*/
				$k[$j++] = "cdf"; /*20218*/
				$k[$j++] = Infinity; /*20218*/
				$aload($1.cdf); /*20218*/
				$k[$j++] = 0; /*20218*/
				$k[$j++] = 0; /*20218*/
				$k[$j++] = 0; /*20218*/
				$k[$j++] = 0; /*20218*/
				$k[$j++] = 0; /*20218*/
				$k[$j++] = 1; /*20218*/
				$k[$j++] = 1; /*20218*/
				$k[$j++] = 1; /*20218*/
				$k[$j++] = 1; /*20218*/
				var _3O = $a(); /*20218*/
				$1[$k[--$j]] = _3O; /*20218*/
				$1.gpf = $a([]); /*20219*/
			} /*20219*/
			$1.mode = "numeric"; /*20221*/
		} /*20221*/
		if ($eq($1.method, "11")) { /*20312*/
			$1.cdf = $a([1, 1]); /*20225*/
			$1.ai90 = $1.aival["90"]; /*20226*/
			if (($1.npre + 1) != $1.ai90.length) { /*20230*/
				$k[$j++] = $geti($1.ai90, $1.npre + 1, ($1.ai90.length - $1.npre) - 1); /*20228*/
			} else { /*20230*/
				$k[$j++] = ""; /*20230*/
			} /*20230*/
			$1.ai90rem = $k[--$j]; /*20232*/
			$k[$j++] = "nalpha"; /*20233*/
			$k[$j++] = 0; /*20233*/
			$forall($1.ai90rem, function() { /*20233*/
				var _3e = $k[--$j]; /*20233*/
				if ((_3e >= 65) && (_3e <= 90)) { /*20233*/
					var _3f = $k[--$j]; /*20233*/
					$k[$j++] = _3f + 1; /*20233*/
				} /*20233*/
			}) /*20233*/
			var _3g = $k[--$j]; /*20233*/
			$1[$k[--$j]] = _3g; /*20233*/
			$k[$j++] = "nnums"; /*20234*/
			$k[$j++] = 0; /*20234*/
			$forall($1.ai90rem, function() { /*20234*/
				var _3j = $k[--$j]; /*20234*/
				if ((_3j >= 48) && (_3j <= 57)) { /*20234*/
					var _3k = $k[--$j]; /*20234*/
					$k[$j++] = _3k + 1; /*20234*/
				} /*20234*/
			}) /*20234*/
			var _3l = $k[--$j]; /*20234*/
			$1[$k[--$j]] = _3l; /*20234*/
			$k[$j++] = "mode"; /*20235*/
			if ($gt($1.nalpha, $1.nnums)) { /*20235*/
				$k[$j++] = "alpha"; /*20235*/
			} else { /*20235*/
				$k[$j++] = "numeric"; /*20235*/
			} /*20235*/
			var _3p = $k[--$j]; /*20235*/
			$1[$k[--$j]] = _3p; /*20235*/
			if (($1.nalpha + $1.nnums) != $1.ai90rem.length) { /*20236*/
				$1.mode = "alphanumeric"; /*20236*/
			} /*20236*/
			$k[$j++] = "cdf"; /*20241*/
			$k[$j++] = Infinity; /*20241*/
			$aload($1.cdf); /*20238*/
			if ($eq($1.mode, "alphanumeric")) { /*20239*/
				$k[$j++] = 0; /*20239*/
			} /*20239*/
			if ($eq($1.mode, "numeric")) { /*20240*/
				$k[$j++] = 1; /*20240*/
				$k[$j++] = 0; /*20240*/
			} /*20240*/
			if ($eq($1.mode, "alpha")) { /*20241*/
				$k[$j++] = 1; /*20241*/
				$k[$j++] = 1; /*20241*/
			} /*20241*/
			var _3y = $a(); /*20241*/
			$1[$k[--$j]] = _3y; /*20242*/
			$k[$j++] = "ais1"; /*20243*/
			if ($1.ais.length > 1) { /*20243*/
				$k[$j++] = $get($1.ais, 1); /*20243*/
			} else { /*20243*/
				$k[$j++] = -1; /*20243*/
			} /*20243*/
			var _43 = $k[--$j]; /*20243*/
			$1[$k[--$j]] = _43; /*20243*/
			if ($eq($1.ais1, "21") || $eq($1.ais1, "8004")) { /*20247*/
				$k[$j++] = "cdf"; /*20245*/
				$k[$j++] = Infinity; /*20245*/
				$aload($1.cdf); /*20245*/
				if ($eq($1.ais1, "21")) { /*20245*/
					$k[$j++] = 1; /*20245*/
					$k[$j++] = 0; /*20245*/
				} else { /*20245*/
					$k[$j++] = 1; /*20245*/
					$k[$j++] = 1; /*20245*/
				} /*20245*/
				var _49 = $a(); /*20245*/
				$1[$k[--$j]] = _49; /*20245*/
			} else { /*20247*/
				$k[$j++] = "cdf"; /*20247*/
				$k[$j++] = Infinity; /*20247*/
				$aload($1.cdf); /*20247*/
				$k[$j++] = 0; /*20247*/
				var _4C = $a(); /*20247*/
				$1[$k[--$j]] = _4C; /*20247*/
			} /*20247*/
			$k[$j++] = "nval"; /*20249*/
			if ($1.npre != 0) { /*20249*/
				$k[$j++] = ~~$z($geti($1.ai90, 0, $1.npre)); /*20249*/
			} else { /*20249*/
				$k[$j++] = 0; /*20249*/
			} /*20249*/
			var _4I = $k[--$j]; /*20249*/
			$1[$k[--$j]] = _4I; /*20249*/
			$search("BDHIJKLNPQRSTVXZ", $geti($1.ai90, $1.npre, 1)); /*20250*/
			if ($k[--$j]) { /*20254*/
				var _4O = $k[--$j]; /*20251*/
				var _4P = $k[--$j]; /*20251*/
				var _4Q = $k[--$j]; /*20251*/
				$1.aval = _4O.length; /*20252*/
			} else { /*20254*/
				$j--; /*20254*/
				$1.aval = -1; /*20254*/
			} /*20254*/
			if (($1.nval < 31) && ($1.aval != -1)) { /*20280*/
				var _4U = $strcpy($s(5), "00000"); /*20257*/
				var _4X = $cvrs($s(5), $1.nval, 2); /*20257*/
				$puti(_4U, 5 - _4X.length, _4X); /*20258*/
				$k[$j++] = _4U; /*20259*/
				$k[$j++] = Infinity; /*20259*/
				var _4Y = $k[--$j]; /*20259*/
				var _4Z = $k[--$j]; /*20259*/
				$k[$j++] = _4Y; /*20259*/
				$forall(_4Z, function() { /*20259*/
					var _4a = $k[--$j]; /*20259*/
					$k[$j++] = _4a - 48; /*20259*/
				}) /*20259*/
				$1.nbits = $a(); /*20259*/
				var _4d = $strcpy($s(4), "0000"); /*20260*/
				var _4g = $cvrs($s(4), $1.aval, 2); /*20260*/
				$puti(_4d, 4 - _4g.length, _4g); /*20261*/
				$k[$j++] = _4d; /*20262*/
				$k[$j++] = Infinity; /*20262*/
				var _4h = $k[--$j]; /*20262*/
				var _4i = $k[--$j]; /*20262*/
				$k[$j++] = _4h; /*20262*/
				$forall(_4i, function() { /*20262*/
					var _4j = $k[--$j]; /*20262*/
					$k[$j++] = _4j - 48; /*20262*/
				}) /*20262*/
				$1.abits = $a(); /*20262*/
				$k[$j++] = "cdf"; /*20266*/
				$k[$j++] = Infinity; /*20266*/
				$aload($1.cdf); /*20264*/
				$aload($1.nbits); /*20265*/
				$aload($1.abits); /*20266*/
				var _4o = $a(); /*20266*/
				$1[$k[--$j]] = _4o; /*20267*/
			} else { /*20280*/
				var _4r = $strcpy($s(10), "0000000000"); /*20269*/
				var _4u = $cvrs($s(10), $1.nval, 2); /*20269*/
				$puti(_4r, 10 - _4u.length, _4u); /*20270*/
				$k[$j++] = _4r; /*20271*/
				$k[$j++] = Infinity; /*20271*/
				var _4v = $k[--$j]; /*20271*/
				var _4w = $k[--$j]; /*20271*/
				$k[$j++] = _4v; /*20271*/
				$forall(_4w, function() { /*20271*/
					var _4x = $k[--$j]; /*20271*/
					$k[$j++] = _4x - 48; /*20271*/
				}) /*20271*/
				$1.nbits = $a(); /*20271*/
				var _50 = $strcpy($s(5), "00000"); /*20272*/
				var _55 = $cvrs($s(5), $get($1.ai90, $1.npre) - 65, 2); /*20272*/
				$puti(_50, 5 - _55.length, _55); /*20273*/
				$k[$j++] = _50; /*20274*/
				$k[$j++] = Infinity; /*20274*/
				var _56 = $k[--$j]; /*20274*/
				var _57 = $k[--$j]; /*20274*/
				$k[$j++] = _56; /*20274*/
				$forall(_57, function() { /*20274*/
					var _58 = $k[--$j]; /*20274*/
					$k[$j++] = _58 - 48; /*20274*/
				}) /*20274*/
				$1.abits = $a(); /*20274*/
				$k[$j++] = "cdf"; /*20279*/
				$k[$j++] = Infinity; /*20279*/
				$aload($1.cdf); /*20276*/
				$k[$j++] = 1; /*20278*/
				$k[$j++] = 1; /*20278*/
				$k[$j++] = 1; /*20278*/
				$k[$j++] = 1; /*20278*/
				$k[$j++] = 1; /*20278*/
				$aload($1.nbits); /*20278*/
				$aload($1.abits); /*20279*/
				var _5D = $a(); /*20279*/
				$1[$k[--$j]] = _5D; /*20280*/
			} /*20280*/
			if ($eq($1.mode, "numeric")) { /*20299*/
				$k[$j++] = "gpf"; /*20283*/
				$k[$j++] = Infinity; /*20283*/
				$forall($1.ai90rem); /*20283*/
				if ($1.ais.length > 1) { /*20283*/
					$k[$j++] = $1.fnc1; /*20283*/
				} /*20283*/
				var _5J = $a(); /*20283*/
				$1[$k[--$j]] = _5J; /*20283*/
			} else { /*20299*/
				$k[$j++] = "encs"; /*20285*/
				if ($eq($1.mode, "alpha")) { /*20285*/
					$k[$j++] = $1.alpha; /*20285*/
				} else { /*20285*/
					$k[$j++] = $1.alphanumeric; /*20285*/
				} /*20285*/
				var _5O = $k[--$j]; /*20285*/
				$1[$k[--$j]] = _5O; /*20285*/
				$k[$j++] = "in"; /*20286*/
				$k[$j++] = Infinity; /*20286*/
				$forall($1.ai90rem); /*20286*/
				if ($1.ais.length > 1) { /*20286*/
					$k[$j++] = $1.fnc1; /*20286*/
				} /*20286*/
				var _5T = $a(); /*20286*/
				$1[$k[--$j]] = _5T; /*20286*/
				$1.out = $a($1.in.length * 6); /*20287*/
				$1.j = 0; /*20288*/
				for (var _5Z = 0, _5Y = $1.in.length - 1; _5Z <= _5Y; _5Z += 1) { /*20293*/
					var _5d = $get($1.encs, $get($1.in, _5Z)); /*20290*/
					$k[$j++] = _5d; /*20291*/
					$k[$j++] = _5d; /*20291*/
					$k[$j++] = Infinity; /*20291*/
					var _5e = $k[--$j]; /*20291*/
					var _5f = $k[--$j]; /*20291*/
					$k[$j++] = _5e; /*20291*/
					$forall(_5f, function() { /*20291*/
						var _5g = $k[--$j]; /*20291*/
						$k[$j++] = _5g - 48; /*20291*/
					}) /*20291*/
					$puti($1.out, $1.j, $a()); /*20291*/
					$1.j = $k[--$j].length + $1.j; /*20292*/
				} /*20292*/
				$k[$j++] = "cdf"; /*20296*/
				$k[$j++] = Infinity; /*20296*/
				$aload($1.cdf); /*20295*/
				$aload($geti($1.out, 0, $1.j)); /*20296*/
				var _5q = $a(); /*20296*/
				$1[$k[--$j]] = _5q; /*20297*/
				$1.gpf = $a([]); /*20298*/
				if (($1.ais.length > 1) || $ne($1.mode, "alpha")) { /*20299*/
					$1.mode = "numeric"; /*20299*/
				} /*20299*/
			} /*20299*/
			$1.ais = $geti($1.ais, 1, $1.ais.length - 1); /*20301*/
			if ($1.ais.length != 0) { /*20311*/
				if ($eq($1.ais1, "21") || $eq($1.ais1, "8004")) { /*20310*/
					$k[$j++] = "gpf"; /*20306*/
					$k[$j++] = Infinity; /*20306*/
					$aload($1.gpf); /*20305*/
					$forall($get($1.aival, $1.ais1)); /*20306*/
					var _65 = $a(); /*20306*/
					$1[$k[--$j]] = _65; /*20307*/
					$1.ais = $geti($1.ais, 1, $1.ais.length - 1); /*20308*/
					if ($1.ais.length != 0) { /*20309*/
						$k[$j++] = "gpf"; /*20309*/
						$k[$j++] = Infinity; /*20309*/
						$aload($1.gpf); /*20309*/
						$k[$j++] = $1.fnc1; /*20309*/
						var _6D = $a(); /*20309*/
						$1[$k[--$j]] = _6D; /*20309*/
					} /*20309*/
				} /*20309*/
			} /*20309*/
		} /*20309*/
		if ($eq($1.method, "0")) { /*20318*/
			$1.cdf = $a([0]); /*20315*/
			$1.gpf = $a([]); /*20316*/
			$1.mode = "numeric"; /*20317*/
		} /*20317*/
		$1.aifixed = {}; /*20323*/
		$k[$j++] = Infinity; /*20325*/
		for (var _6I = 0; _6I <= 4; _6I += 1) { /*20325*/
			$k[$j++] = _6I; /*20325*/
		} /*20325*/
		var _6J = $a(); /*20325*/
		for (var _6K = 0, _6L = _6J.length; _6K < _6L; _6K++) { /*20328*/
			var _6O = $strcpy($s(2), "00"); /*20327*/
			$put(_6O, 1, $get(_6J, _6K) + 48); /*20327*/
			$put($1.aifixed, _6O, _6O); /*20327*/
		} /*20327*/
		$k[$j++] = Infinity; /*20333*/
		for (var _6Q = 11; _6Q <= 20; _6Q += 1) { /*20330*/
			$k[$j++] = _6Q; /*20330*/
		} /*20330*/
		$k[$j++] = 23; /*20332*/
		for (var _6R = 31; _6R <= 36; _6R += 1) { /*20332*/
			$k[$j++] = _6R; /*20332*/
		} /*20332*/
		$k[$j++] = 41; /*20333*/
		var _6S = $a(); /*20333*/
		for (var _6T = 0, _6U = _6S.length; _6T < _6U; _6T++) { /*20336*/
			var _6X = $cvrs($s(2), $get(_6S, _6T), 10); /*20335*/
			$put($1.aifixed, _6X, _6X); /*20335*/
		} /*20335*/
		for (var _6b = 0, _6a = $1.ais.length - 1; _6b <= _6a; _6b += 1) { /*20354*/
			$1.i = _6b; /*20340*/
			$1.ai = $get($1.ais, $1.i); /*20341*/
			$1.val = $get($1.aival, $1.ai); /*20342*/
			var _6l = $a(($1.gpf.length + $1.ai.length) + $1.val.length); /*20343*/
			$puti(_6l, 0, $1.gpf); /*20344*/
			$k[$j++] = _6l; /*20345*/
			$k[$j++] = _6l; /*20345*/
			$k[$j++] = $1.gpf.length; /*20345*/
			$k[$j++] = $1.ai; /*20345*/
			$k[$j++] = Infinity; /*20345*/
			var _6p = $k[--$j]; /*20345*/
			var _6q = $k[--$j]; /*20345*/
			$k[$j++] = _6p; /*20345*/
			$forall(_6q); /*20345*/
			var _6r = $a(); /*20345*/
			var _6s = $k[--$j]; /*20345*/
			$puti($k[--$j], _6s, _6r); /*20345*/
			var _6u = $k[--$j]; /*20346*/
			$k[$j++] = _6u; /*20346*/
			$k[$j++] = _6u; /*20346*/
			$k[$j++] = $1.gpf.length + $1.ai.length; /*20346*/
			$k[$j++] = $1.val; /*20346*/
			$k[$j++] = Infinity; /*20346*/
			var _6y = $k[--$j]; /*20346*/
			var _6z = $k[--$j]; /*20346*/
			$k[$j++] = _6y; /*20346*/
			$forall(_6z); /*20346*/
			var _70 = $a(); /*20346*/
			var _71 = $k[--$j]; /*20346*/
			$puti($k[--$j], _71, _70); /*20346*/
			$1.gpf = $k[--$j]; /*20347*/
			var _79 = $get($1.aifixed, $geti($1.ai, 0, 2)) !== undefined; /*20348*/
			if (($1.i != ($1.ais.length - 1)) && (!_79)) { /*20353*/
				var _7B = $a($1.gpf.length + 1); /*20349*/
				$puti(_7B, 0, $1.gpf); /*20350*/
				$put(_7B, $1.gpf.length, $1.fnc1); /*20351*/
				$1.gpf = _7B; /*20352*/
			} /*20352*/
		} /*20352*/
		$1.rembits = function() {
			$1.used = $k[--$j]; /*20358*/
			if ($ne($1.ccversion, "c")) { /*20387*/
				var _7P = {
					a: $a([$a([167, 138, 118, 108, 88, 78, 59]), $a([167, 138, 118, 98, 78]), $a([197, 167, 138, 108, 78])]),
					b: $a([$a([336, 296, 256, 208, 160, 104, 56]), $a([768, 648, 536, 416, 304, 208, 152, 112, 72, 32]), $a([1184, 1016, 840, 672, 496, 352, 264, 208, 152, 96, 56])])
				}; /*20369*/
				$1.bitcaps = $get($get(_7P, $1.ccversion), $1.cccolumns - 2); /*20371*/
				$k[$j++] = -1; /*20372*/
				$forall($1.bitcaps, function() { /*20372*/
					var _7V = $k[--$j]; /*20372*/
					$k[$j++] = _7V; /*20372*/
					if ($ge(_7V, $1.used)) { /*20372*/
						var _7X = $k[--$j]; /*20372*/
						var _7Y = $k[--$j]; /*20372*/
						$k[$j++] = _7X; /*20372*/
						$k[$j++] = _7Y; /*20372*/
					} /*20372*/
					$j--; /*20372*/
				}) /*20372*/
				var _7Z = $k[--$j]; /*20373*/
				$k[$j++] = _7Z; /*20373*/
				if (_7Z != -1) { /*20373*/
					var _7b = $k[--$j]; /*20373*/
					$k[$j++] = _7b - $1.used; /*20373*/
				} /*20373*/
			} else { /*20387*/
				var _7c = {
					c: -1
				}; /*20375*/
				var _7e = $get(_7c, $1.ccversion); /*20375*/
				var _7g = ~~Math.ceil($1.used / 8); /*20376*/
				$1.m = ((~~(_7g / 6)) * 5) + (_7g % 6); /*20376*/
				if ($1.m <= 40) { /*20377*/
					$k[$j++] = 8; /*20377*/
				} /*20377*/
				if (($1.m >= 41) && ($1.m <= 160)) { /*20378*/
					$k[$j++] = 16; /*20378*/
				} /*20378*/
				if (($1.m >= 161) && ($1.m <= 320)) { /*20379*/
					$k[$j++] = 32; /*20379*/
				} /*20379*/
				if ($1.m >= 321) { /*20380*/
					$k[$j++] = 64; /*20380*/
				} /*20380*/
				$1.eccws = $k[--$j]; /*20381*/
				$1.m = ($1.m + $1.eccws) + 3; /*20382*/
				$1.c = ~~(($1.linwidth - 52) / 17); /*20383*/
				if ((~~($1.m / $1.c)) > 90) { /*20384*/
					$1.c = $1.c + 1; /*20384*/
				} /*20384*/
				$1.r = ~~Math.ceil($1.m / $1.c); /*20385*/
				var _7z = (($1.c * $1.r) - $1.eccws) - 3; /*20386*/
				$1.tgt = (((~~(_7z / 5)) * 6) + (_7z % 5)) * 8; /*20386*/
				if ($1.used <= 8296) { /*20387*/
					$k[$j++] = $1.tgt - $1.used; /*20387*/
				} else { /*20387*/
					$k[$j++] = -1; /*20387*/
				} /*20387*/
			} /*20387*/
			var _83 = $k[--$j]; /*20389*/
			$k[$j++] = _83; /*20402*/
			if (_83 == -1) { /*20402*/
				$j--; /*20390*/
				if ($eq($1.ccversion, "a")) { /*20398*/
					$1.ccversion = "b"; /*20392*/
				} else { /*20398*/
					if ($eq($1.ccversion, "b") && $eq($1.lintype, "gs1-128")) { /*20398*/
						$1.ccversion = "c"; /*20395*/
						$1.cccolumns = ~~(($1.linwidth - 52) / 17); /*20396*/
					} else { /*20398*/
						$1.ccversion = -1; /*20398*/
					} /*20398*/
				} /*20398*/
				$k[$j++] = $1.used; /*20401*/
				$1.rembits(); /*20401*/
			} /*20401*/
		}; /*20403*/
		$1.encode = function() {
			var _89 = $k[--$j]; /*20406*/
			$k[$j++] = _89; /*20406*/
			if ($ne(_89, "raw")) { /*20406*/
				var _8A = $k[--$j]; /*20406*/
				var _8C = $get(_8A, $k[--$j]); /*20406*/
				$k[$j++] = _8C; /*20406*/
			} else { /*20406*/
				$j--; /*20406*/
			} /*20406*/
			$k[$j++] = Infinity; /*20407*/
			var _8D = $k[--$j]; /*20407*/
			var _8E = $k[--$j]; /*20407*/
			$k[$j++] = _8D; /*20407*/
			$forall(_8E, function() { /*20407*/
				var _8F = $k[--$j]; /*20407*/
				$k[$j++] = _8F - 48; /*20407*/
			}) /*20407*/
			var _8G = $a(); /*20407*/
			$puti($1.gpfenc, $1.j, _8G); /*20409*/
			$1.j = _8G.length + $1.j; /*20410*/
		}; /*20411*/
		$k[$j++] = "numericruns"; /*20414*/
		$k[$j++] = Infinity; /*20414*/
		for (var _8L = 0, _8M = $1.gpf.length; _8L < _8M; _8L++) { /*20414*/
			$k[$j++] = 0; /*20414*/
		} /*20414*/
		$k[$j++] = 0; /*20414*/
		$k[$j++] = -1; /*20414*/
		var _8N = $a(); /*20414*/
		$1[$k[--$j]] = _8N; /*20414*/
		$k[$j++] = "alphanumericruns"; /*20415*/
		$k[$j++] = Infinity; /*20415*/
		for (var _8Q = 0, _8R = $1.gpf.length; _8Q < _8R; _8Q++) { /*20415*/
			$k[$j++] = 0; /*20415*/
		} /*20415*/
		$k[$j++] = 0; /*20415*/
		var _8S = $a(); /*20415*/
		$1[$k[--$j]] = _8S; /*20415*/
		$k[$j++] = "nextiso646only"; /*20416*/
		$k[$j++] = Infinity; /*20416*/
		for (var _8V = 0, _8W = $1.gpf.length; _8V < _8W; _8V++) { /*20416*/
			$k[$j++] = 0; /*20416*/
		} /*20416*/
		$k[$j++] = 9999; /*20416*/
		var _8X = $a(); /*20416*/
		$1[$k[--$j]] = _8X; /*20416*/
		for (var _8a = $1.gpf.length - 1; _8a >= 0; _8a -= 1) { /*20438*/
			$1.i = _8a; /*20418*/
			var _8f = $strcpy($s(2), "00"); /*20420*/
			var _8i = $get($1.gpf, $1.i); /*20421*/
			$k[$j++] = $get($1.gpf, $1.i); /*20421*/
			$k[$j++] = _8f; /*20421*/
			$k[$j++] = _8f; /*20421*/
			$k[$j++] = 0; /*20421*/
			$k[$j++] = _8i; /*20421*/
			if (_8i == $1.fnc1) { /*20421*/
				$j--; /*20421*/
				$k[$j++] = 94; /*20421*/
			} /*20421*/
			var _8k = $k[--$j]; /*20421*/
			var _8l = $k[--$j]; /*20421*/
			$put($k[--$j], _8l, _8k); /*20421*/
			if ($1.i < ($1.gpf.length - 1)) { /*20422*/
				var _8p = $k[--$j]; /*20422*/
				var _8s = $get($1.gpf, $1.i + 1); /*20422*/
				$k[$j++] = _8p; /*20422*/
				$k[$j++] = _8p; /*20422*/
				$k[$j++] = 1; /*20422*/
				$k[$j++] = _8s; /*20422*/
				if (_8s == $1.fnc1) { /*20422*/
					$j--; /*20422*/
					$k[$j++] = 94; /*20422*/
				} /*20422*/
				var _8u = $k[--$j]; /*20422*/
				var _8v = $k[--$j]; /*20422*/
				$put($k[--$j], _8v, _8u); /*20422*/
			} /*20422*/
			var _8z = $get($1.numeric, $k[--$j]) !== undefined; /*20423*/
			if (_8z) { /*20426*/
				$put($1.numericruns, $1.i, $get($1.numericruns, $1.i + 2) + 2); /*20424*/
			} else { /*20426*/
				$put($1.numericruns, $1.i, 0); /*20426*/
			} /*20426*/
			var _97 = $k[--$j]; /*20428*/
			var _99 = $get($1.alphanumeric, _97) !== undefined; /*20428*/
			$k[$j++] = _97; /*20432*/
			if (_99) { /*20431*/
				$put($1.alphanumericruns, $1.i, $get($1.alphanumericruns, $1.i + 1) + 1); /*20429*/
			} else { /*20431*/
				$put($1.alphanumericruns, $1.i, 0); /*20431*/
			} /*20431*/
			var _9H = $k[--$j]; /*20433*/
			var _9J = $get($1.iso646, _9H) !== undefined; /*20433*/
			var _9L = $get($1.alphanumeric, _9H) !== undefined; /*20433*/
			if (_9J && (!_9L)) { /*20436*/
				$put($1.nextiso646only, $1.i, 0); /*20434*/
			} else { /*20436*/
				$put($1.nextiso646only, $1.i, $get($1.nextiso646only, $1.i + 1) + 1); /*20436*/
			} /*20436*/
		} /*20436*/
		$1.gpfenc = $a(8296); /*20441*/
		$1.i = 0; /*20442*/
		$1.j = 0; /*20442*/
		for (;;) { /*20532*/
			if ($1.i == $1.gpf.length) { /*20444*/
				break; /*20444*/
			} /*20444*/
			for (;;) { /*20531*/
				if ($eq($1.mode, "numeric")) { /*20480*/
					if ($1.i <= ($1.gpf.length - 2)) { /*20477*/
						var _9Z = $s(2); /*20449*/
						var _9c = $get($1.gpf, $1.i); /*20450*/
						$k[$j++] = _9Z; /*20450*/
						$k[$j++] = _9Z; /*20450*/
						$k[$j++] = 0; /*20450*/
						$k[$j++] = _9c; /*20450*/
						if (_9c == $1.fnc1) { /*20450*/
							$j--; /*20450*/
							$k[$j++] = 94; /*20450*/
						} /*20450*/
						var _9e = $k[--$j]; /*20450*/
						var _9f = $k[--$j]; /*20450*/
						$put($k[--$j], _9f, _9e); /*20450*/
						var _9h = $k[--$j]; /*20451*/
						var _9k = $get($1.gpf, $1.i + 1); /*20451*/
						$k[$j++] = _9h; /*20451*/
						$k[$j++] = _9h; /*20451*/
						$k[$j++] = 1; /*20451*/
						$k[$j++] = _9k; /*20451*/
						if (_9k == $1.fnc1) { /*20451*/
							$j--; /*20451*/
							$k[$j++] = 94; /*20451*/
						} /*20451*/
						var _9m = $k[--$j]; /*20451*/
						var _9n = $k[--$j]; /*20451*/
						$put($k[--$j], _9n, _9m); /*20451*/
						var _9p = $k[--$j]; /*20452*/
						var _9r = $get($1.numeric, _9p) !== undefined; /*20452*/
						$k[$j++] = _9p; /*20456*/
						if (_9r) { /*20456*/
							$k[$j++] = $1.numeric; /*20453*/
							$1.encode(); /*20453*/
							$1.i = $1.i + 2; /*20454*/
							break; /*20455*/
						} /*20455*/
						$j--; /*20457*/
						$k[$j++] = $1.lalphanumeric; /*20458*/
						$k[$j++] = $1.numeric; /*20458*/
						$1.encode(); /*20458*/
						$1.mode = "alphanumeric"; /*20459*/
						break; /*20460*/
					} else { /*20477*/
						var _9y = $get($1.gpf, $1.i); /*20462*/
						if ((_9y < 48) || (_9y > 57)) { /*20466*/
							$k[$j++] = $1.lalphanumeric; /*20463*/
							$k[$j++] = $1.numeric; /*20463*/
							$1.encode(); /*20463*/
							$1.mode = "alphanumeric"; /*20464*/
							break; /*20465*/
						} /*20465*/
						$k[$j++] = "rem"; /*20467*/
						$k[$j++] = $1.cdf.length + $1.j; /*20467*/
						$1.rembits(); /*20467*/
						var _A3 = $k[--$j]; /*20467*/
						$1[$k[--$j]] = _A3; /*20467*/
						if (($1.rem >= 4) && ($1.rem <= 6)) { /*20477*/
							var _AA = $geti($strcpy($s(6), "000000"), 0, $1.rem); /*20469*/
							var _AF = $cvrs($s(4), $get($1.gpf, $1.i) - 47, 2); /*20470*/
							$puti(_AA, 4 - _AF.length, _AF); /*20471*/
							$k[$j++] = _AA; /*20471*/
							$k[$j++] = "raw"; /*20471*/
							$1.encode(); /*20471*/
							$1.i = $1.i + 1; /*20472*/
							break; /*20473*/
						} else { /*20477*/
							var _AH = $s(2); /*20475*/
							$put(_AH, 0, $get($1.gpf, $1.i)); /*20475*/
							$put(_AH, 1, 94); /*20475*/
							$k[$j++] = _AH; /*20475*/
							$k[$j++] = $1.numeric; /*20475*/
							$1.encode(); /*20475*/
							$1.i = $1.i + 1; /*20476*/
							break; /*20477*/
						} /*20477*/
					} /*20477*/
				} /*20477*/
				if ($eq($1.mode, "alphanumeric")) { /*20507*/
					if ($get($1.gpf, $1.i) == $1.fnc1) { /*20488*/
						$k[$j++] = $1.fnc1; /*20484*/
						$k[$j++] = $1.alphanumeric; /*20484*/
						$1.encode(); /*20484*/
						$1.mode = "numeric"; /*20485*/
						$1.i = $1.i + 1; /*20486*/
						break; /*20487*/
					} /*20487*/
					var _AX = $get($1.gpf, $1.i); /*20489*/
					var _AZ = $get($1.iso646, _AX) !== undefined; /*20489*/
					var _Ab = $get($1.alphanumeric, _AX) !== undefined; /*20489*/
					if (_AZ && (!_Ab)) { /*20493*/
						$k[$j++] = $1.liso646; /*20490*/
						$k[$j++] = $1.alphanumeric; /*20490*/
						$1.encode(); /*20490*/
						$1.mode = "iso646"; /*20491*/
						break; /*20492*/
					} /*20492*/
					if ($get($1.numericruns, $1.i) >= 6) { /*20498*/
						$k[$j++] = $1.lnumeric; /*20495*/
						$k[$j++] = $1.alphanumeric; /*20495*/
						$1.encode(); /*20495*/
						$1.mode = "numeric"; /*20496*/
						break; /*20497*/
					} /*20497*/
					var _Al = $get($1.numericruns, $1.i); /*20499*/
					if ((_Al >= 4) && ((_Al + $1.i) == $1.gpf.length)) { /*20503*/
						$k[$j++] = $1.lnumeric; /*20500*/
						$k[$j++] = $1.alphanumeric; /*20500*/
						$1.encode(); /*20500*/
						$1.mode = "numeric"; /*20501*/
						break; /*20502*/
					} /*20502*/
					$k[$j++] = $get($1.gpf, $1.i); /*20504*/
					$k[$j++] = $1.alphanumeric; /*20504*/
					$1.encode(); /*20504*/
					$1.i = $1.i + 1; /*20505*/
					break; /*20506*/
				} /*20506*/
				if ($eq($1.mode, "iso646")) { /*20529*/
					if ($get($1.gpf, $1.i) == $1.fnc1) { /*20515*/
						$k[$j++] = $1.fnc1; /*20511*/
						$k[$j++] = $1.iso646; /*20511*/
						$1.encode(); /*20511*/
						$1.mode = "numeric"; /*20512*/
						$1.i = $1.i + 1; /*20513*/
						break; /*20514*/
					} /*20514*/
					if (($get($1.numericruns, $1.i) >= 4) && ($get($1.nextiso646only, $1.i) >= 10)) { /*20520*/
						$k[$j++] = $1.lnumeric; /*20517*/
						$k[$j++] = $1.iso646; /*20517*/
						$1.encode(); /*20517*/
						$1.mode = "numeric"; /*20518*/
						break; /*20519*/
					} /*20519*/
					if (($get($1.alphanumericruns, $1.i) >= 5) && ($get($1.nextiso646only, $1.i) >= 10)) { /*20525*/
						$k[$j++] = $1.lalphanumeric; /*20522*/
						$k[$j++] = $1.iso646; /*20522*/
						$1.encode(); /*20522*/
						$1.mode = "alphanumeric"; /*20523*/
						break; /*20524*/
					} /*20524*/
					$k[$j++] = $get($1.gpf, $1.i); /*20526*/
					$k[$j++] = $1.iso646; /*20526*/
					$1.encode(); /*20526*/
					$1.i = $1.i + 1; /*20527*/
					break; /*20528*/
				} /*20528*/
			} /*20528*/
		} /*20528*/
		$1.gpf = $geti($1.gpfenc, 0, $1.j); /*20533*/
		$k[$j++] = "pad"; /*20536*/
		$k[$j++] = $1.cdf.length + $1.gpf.length; /*20536*/
		$1.rembits(); /*20536*/
		var _BU = $a($k[--$j]); /*20536*/
		$1[$k[--$j]] = _BU; /*20536*/
		if ($1.pad.length > 0) { /*20548*/
			for (var _BZ = 0, _BY = $1.pad.length - 1; _BZ <= _BY; _BZ += 5) { /*20541*/
				$1.i = _BZ; /*20539*/
				var _Ba = $1.pad; /*20540*/
				var _Bb = $1.i; /*20540*/
				var _Bc = $a([0, 0, 1, 0, 0]); /*20540*/
				var _Bd = $1.pad; /*20540*/
				var _Be = $1.i; /*20540*/
				var _Bf = 5; /*20540*/
				var _Bg = _Bd.length - _Be; /*20540*/
				if ((_Bd.length - _Be) > 5) { /*20540*/
					var _ = _Bf; /*20540*/
					_Bf = _Bg; /*20540*/
					_Bg = _; /*20540*/
				} /*20540*/
				$puti(_Ba, _Bb, $geti(_Bc, 0, _Bg)); /*20540*/
			} /*20540*/
			if ($eq($1.mode, "numeric")) { /*20544*/
				$k[$j++] = "pad"; /*20