﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Script.Serialization;
using WebForms.Models;

namespace WebForms
{
    /// <summary>
    /// Summary description for ServiceHandler
    /// </summary>
    public class ServiceHandler : IHttpHandler
    {
        public static List<Employee> employees = new List<Employee>() { 
            new Employee(){  EmployeeCode = "E004", EmployeeName="Ron"  },
            new Employee(){  EmployeeCode = "E001", EmployeeName="Robert"  }
        };

        public void ProcessRequest(HttpContext context)
        {
            string empcode = context.Request["code"];
            Employee e = employees.Where(s => s.EmployeeCode == empcode).SingleOrDefault();

            JavaScriptSerializer serializer = new JavaScriptSerializer();
            string JsonEmployeeString = serializer.Serialize(e);

            context.Response.ContentType = "text/json";

            context.Response.Write(JsonEmployeeString);
        }

        public bool IsReusable
        {
            get
            {
                return false;
            }
        }
    }
}