﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="EmployeeForm.aspx.cs" Inherits="WebForms.EmployeeForm" %>

<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>Web Service Call</title>
    <link href="Content/Site.css" rel="stylesheet" />
    <script src="Scripts/jquery-1.10.2.min.js"></script>
</head>
<body>
    <form id="form1" runat="server">
        <div class="maindiv">
            <input type="text" id="txtEmpCode" class="" />
            <input type="button" value="Search Employee" id="btnEmployee" />
            <br />
            <div id="divresult" class="divresult">
                <h5>Search Result: </h5>
                <br />
                <b>Employee Code: </b><span id="empCode"></span>
                <br />
                <b>Employee Name: </b><span id="empName"></span>
            </div>
        </div>

        <script type="text/javascript">

            $(document).ready(function () {

                $('#btnEmployee').click(function () {
                    var empCode = $('#txtEmpCode').val();
                    $.ajax({
                        type: "GET",
                        url: "ServiceHandler.ashx",
                        contentType: "application/json; charset=utf-8",
                        data: { 'code': empCode },
                        success: function (result) {
                            if (result != null) {
                                var data = result;
                                $('#empCode').text(data.EmployeeCode);
                                $('#empName').text(data.EmployeeName);
                            }
                        },
                        error: function (err) {
                            alert(err.statusText);
                        }
                    });
                });
            });

        </script>
    </form>
</body>
</html>

