﻿Imports System
Imports System.Collections
Imports System.Data
Imports System.Web
Imports System.Web.UI
Imports Util

Partial Public Class Project_Edit
	Inherits Page

	Protected Sub Page_Load(ByVal sender As Object, ByVal e As EventArgs)
		Response.Cache.SetCacheability(HttpCacheability.NoCache)
		Response.Cache.SetNoStore()

		If Not IsPostBack Then
			Dim dr As DataRow = (New DataManager()).GetAssignment(Convert.ToInt32(Request.QueryString("id")))

			TextBoxStart.Text = Convert.ToDateTime(dr("AssignmentStart")).ToShortDateString()
			DropDownListDuration.SelectedValue = Convert.ToString(dr("AssignmentDuration"))
			TextBoxNote.Text = Convert.ToString(dr("AssignmentNote"))

		End If
	End Sub


	Protected Sub ButtonOK_Click(ByVal sender As Object, ByVal e As EventArgs)
		Dim note As String = TextBoxNote.Text
'INSTANT VB NOTE: The variable id was renamed since Visual Basic does not handle local variables named the same as class members well:
		Dim id_Renamed As Integer = Convert.ToInt32(Request.QueryString("id"))
		Dim duration As Integer = Convert.ToInt32(DropDownListDuration.SelectedValue)
		Dim start As Date = Convert.ToDateTime(TextBoxStart.Text)

		CType(New DataManager(), DataManager).UpdateAssignment(id_Renamed, note, duration, start)

		Dim ht As New Hashtable()
		ht("refresh") = "yes"
		ht("message") = "Event updated."

		Modal.Close(Me, ht)
	End Sub

	Protected Sub ButtonCancel_Click(ByVal sender As Object, ByVal e As EventArgs)
		Modal.Close(Me)
	End Sub

	Protected Sub ButtonDelete_Click(ByVal sender As Object, ByVal e As EventArgs)
		CType(New DataManager(), DataManager).DeleteAssignment(Convert.ToInt32(Request.QueryString("id")))
		Dim ht As New Hashtable()
		ht("refresh") = "yes"
		ht("message") = "Event deleted."
		Modal.Close(Me, ht)
		'ScriptManager.RegisterStartupScript(this, this.GetType(), "modal", "<script type='text/javascript'>setTimeout(function() { modal.close({refresh:'yes',message:'Event deleted'); }, 0);</script>", false);
	End Sub

	Protected Sub UpdatePanel_Load(ByVal sender As Object, ByVal e As EventArgs)
		'ScriptManager.RegisterStartupScript(this, this.GetType(), "modal", "<script type='text/javascript'>setTimeout(function() { modal.stretch(); }, 0);</script>", false);
	End Sub


End Class