using System;
using System.Collections.Generic;
using System.Data;
using System.Text;
using System.Web.UI;
using DayPilot.Web.Ui;
using DayPilot.Web.Ui.Data;
using DayPilot.Web.Ui.Events;
using DayPilot.Web.Ui.Events.Scheduler;

public partial class Project_Default : Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            DayPilotScheduler1.Days = DateTime.DaysInMonth(2013, 2);
            DayPilotScheduler1.StartDate = new DateTime(2013, 02, 01);
            LoadEvents();
        }

        string cols = new DataManager().GetUserConfig(User.Identity.Name, "project.cols");
        if (cols != null)
        {
            DayPilotScheduler1.RowHeaderColumnWidths = cols;
        }

    }

    private string TaskLink(string name, int id)
    {
        StringBuilder sb = new StringBuilder();
        sb.Append("<div style=' padding: 0px 2px 0px 2px'>");
        sb.Append("<div class='task_status ");
        sb.Append("' data-taskid='" + id + "'></div>");

        sb.Append("<a title='");
        sb.Append(name);
        sb.Append("' ");
        sb.Append("href='javascript:edit(\"");
        sb.Append(id);
        sb.Append("\")'>");
        sb.Append(name);
        sb.Append("</a>");
        sb.Append("</div>");

        return sb.ToString();
    }

    protected void UpdatePanelScheduler_Load(object sender, EventArgs e)
    {
    }

    protected void DayPilotScheduler1_BeforeEventRender(object sender, BeforeEventRenderEventArgs e)
    {
        /*
        Task t = (Task)e.DataItem.Source;
        e.DurationBarColor = Helper.StatusToColor(t["AssignmentStatus"]);
         * */
    }


    protected void DayPilotScheduler1_HeaderColumnWidthChanged(object sender, HeaderColumnWidthChangedEventArgs e)
    {
        new DataManager().SetUserConfig(User.Identity.Name, "project.cols", DayPilotScheduler1.RowHeaderColumnWidths);
        LoadEvents();
    }

    protected void RadioButtonListZoom_SelectedIndexChanged(object sender, EventArgs e)
    {
        LoadEvents();
    }


    private void LoadEvents()
    {
        DayPilotScheduler1.DataStartField = "AssignmentStart";
        DayPilotScheduler1.DataEndField = "AssignmentEnd";
        DayPilotScheduler1.DataTextField = "AssignmentNote";
        DayPilotScheduler1.DataValueField = "AssignmentId";

        DayPilotScheduler1.DataSource = new DataManager().GetAssignments();
        DataBind();
    }

    protected void ButtonRefresh_Click(object sender, EventArgs e)
    {
        LoadEvents();
    }

    protected void DayPilotScheduler1_BeforeResHeaderRender(object sender, BeforeHeaderRenderEventArgs e)
    {
        DataItemWrapper task = e.DataItem;

        string name = (string)task["AssignmentNote"];
        int id = Convert.ToInt32(task["AssignmentId"]);

        //TimeSpan duration = TimeSpan.FromDays(Convert.ToInt32(task["AssignmentDuration"]));
        int duration = Convert.ToInt32(task["AssignmentDuration"]);
        string days = duration == 1 ? "day" : "days";

        e.InnerHTML = TaskLink(name, id);
        e.Columns[0].InnerHTML = "<div style='text-align:right; padding: 0px 6px 0px 2px;'>" + duration + " " + days + "</div>";

    }
}