﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using ReadXml;

public partial class _Default : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            Read.Get.XmlFile(AppDomain.CurrentDomain.BaseDirectory + @"xmlfiles\book_catalog.config");
            Read.Get.XmlFile(AppDomain.CurrentDomain.BaseDirectory + @"xmlfiles\complex_catalog.config");
            Read.Get.XmlFile(AppDomain.CurrentDomain.BaseDirectory + @"xmlfiles\models.xml");
            Read.Get.XmlFile(AppDomain.CurrentDomain.BaseDirectory + @"xmlfiles\sample.config");
                        

            //Get Value By Attribute Name
            string _value = ReadXml.Values.Search.Get.GetValueByAttributeName("description");

            //Get Inner Xml by XmlElementName and FileName
            string _innerXml = ReadXml.Values.Search.Get.GetInnerXmlByXmlElementName("catalog_item", "complex_catalog.config");

            //Get Inner Text by XmlElementName and FileName
            string _innerText = ReadXml.Values.Search.Get.GetInnerTextByXmlElementName("Model:ModelElement.annotation", "Models.xml");

            //Complex search
            //Get All xmlnodes for books having xmlnode="genre" & xmlnode's value="Fantasy" with file name
            List<xmlvalue> _list = ReadXml.Values.Search.Get.GetAllNodesWithFiles()["book_catalog.config"].Where(qr => qr.Childs.Any(ch => ch.Value == "Fantasy")).ToList();

            //Get All xmlnodes for datapool having xmlnode="DataGroup" with Attribute="UserCanSelectHost" and AttributeValue="yessure"
            _list = ReadXml.Values.Search.Get.GetAllNodes().Where(qr => qr.Name == "DataGroup" & qr.Attributes.Any(at => at.Key.Contains("UserCanSelectHost") & at.Value.Contains("yessure"))).ToList();

        }
    }
}