﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Xml;

public partial class _Default : System.Web.UI.Page
{
    xmlvalue _xml = new xmlvalue();
    List<xmlvalue> _xmls = new List<xmlvalue>();

    protected void Page_Load(object sender, EventArgs e)
    {
    }

    protected void uploader_click(object sender, EventArgs e) {
        uploadmessage.Visible = false;
        if (xmlfiles.HasFile) {
            try
            {
                string _filepath = AppDomain.CurrentDomain.BaseDirectory + @"tempfiles\" + xmlfiles.FileName;
                xmlfiles.SaveAs(_filepath);
                uploadmessage.Text = string.Format("File: {0} uploaded successfully.", xmlfiles.FileName);
                uploadmessage.Visible = true;
                Session.Add("xmlfile", _filepath);
                panel.Visible = true;
            }
            catch (Exception ex) {
                uploadmessage.Text = string.Format("File: {0} failed to upload. <br />Please review error <br />{1}", xmlfiles.FileName, ex.Message);
                uploadmessage.ForeColor = System.Drawing.Color.Red;
                uploadmessage.Visible = true;
            }
        }    
    }

    protected void btnvalid_click(object sender, EventArgs e) {
        validxml.Visible = false;
        string _fileName = Session["xmlfile"].ToString().Split('\\')[Session["xmlfile"].ToString().Split('\\').Length - 1];
        try
        {            
            XmlDocument dom = new XmlDocument();
            dom.Load(Session["xmlfile"].ToString());
            validxml.Text = string.Format("File {0} is a valid xml file.", _fileName);
            validxml.Visible = true;
        }
        catch (Exception ex)
        {
            validxml.Text = string.Format("File: {0} is not a valid file. <br />Please review error <br />{1}", _fileName, ex.Message);
            validxml.ForeColor = System.Drawing.Color.Red;
            validxml.Visible = true;
        }
    }

    protected void btnshow_click(object sender, EventArgs e) {
        XmlDocument dom = new XmlDocument();
        dom.Load(Session["xmlfile"].ToString());

        _xml.Name = dom.DocumentElement.Name;
        _xml.Value = dom.DocumentElement.Value;
        _xml.innerText = dom.InnerText;
        _xml.innerXml = dom.InnerXml;

        if (dom.DocumentElement.HasAttributes)
        {
            foreach (XmlAttribute _attr in dom.DocumentElement.Attributes)
            {
                _xml.AddAttribute(_attr.Name, _attr.Value);
            }
        }

        if (dom.DocumentElement.HasChildNodes)
        {
            foreach (XmlNode _node in dom.DocumentElement.ChildNodes)
            {
                _xml.AddChild(AddNodes(_node));
            }
        }

        MakeXmlList();

        System.Text.StringBuilder sb = new System.Text.StringBuilder();

        _xmls.ForEach(qr => {
            sb.Append("====================================================================================<br />");
            sb.AppendFormat("Name: {0}{1}", qr.Name , "<br />");
            sb.AppendFormat("Value: {0}{1}", qr.Value, "<br />");
            sb.AppendFormat("innerText: {0}{1}", qr.innerText, "<br />");
            sb.AppendFormat("innerXml: {0}{1}", qr.innerXml, "<br />");
            foreach (KeyValuePair<string, string> _kvp in qr.Attributes) {
                sb.AppendFormat("Attribute Name: <b>{0}</b>, Value: <b>{1}</b>{2}", _kvp.Key, _kvp.Value, "<br />");
            }
            sb.Append("====================================================================================<br />");
        });

        display.Text = sb.ToString();
    }

    private void MakeXmlList()
    {
        _xmls.Add(_xml);

        foreach (xmlvalue xmlv in _xml.Childs)
        {
            MakeXmlList(xmlv);
        }
    }

    private void MakeXmlList(xmlvalue xml)
    {
        _xmls.Add(xml);

        foreach (xmlvalue xmlv in xml.Childs)
        {
            MakeXmlList(xmlv);
        }
    }

    private xmlvalue AddNodes(XmlNode xmlnode)
    {
        xmlvalue _xv = new xmlvalue();
        _xv.Name = xmlnode.Name;
        _xv.Value = xmlnode.Value;
        _xv.innerText = xmlnode.InnerText;
        _xv.innerXml = xmlnode.InnerXml;

        if (xmlnode.Attributes != null)
        {
            foreach (XmlAttribute _attr in xmlnode.Attributes)
            {
                _xv.AddAttribute(_attr.Name, _attr.Value);
            }
        }

        if (xmlnode.HasChildNodes)
        {
            foreach (XmlNode _node in xmlnode.ChildNodes)
            {
                _xv.AddChild(AddNodes(_node));
            }
        }

        return _xv;
    }
}