﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Web;

namespace ReadXML.Logger
{
    /// <summary>
    /// Summary description for StartLogConfig
    /// </summary>
    public static class StartLogConfig
    {
        public static string configname = "logger";
        public static string logfolder = "log";
        public static string logFile = "log.txt";
        public static int filesize = 1;
        public static bool rolldaily = false;
        public static string logfilepath;

        static StartLogConfig()
        {
            configname = Logger.Configuration.XmlLoggerConfiguration.Settings.Name;
            logfolder = Logger.Configuration.XmlLoggerConfiguration.Settings.LogConfig.Folder;
            logFile = Logger.Configuration.XmlLoggerConfiguration.Settings.LogConfig.File;
            filesize = Logger.Configuration.XmlLoggerConfiguration.Settings.LogConfig.FileSize;
            rolldaily = Logger.Configuration.XmlLoggerConfiguration.Settings.LogConfig.RollDaily;

            if (!Directory.Exists(System.AppDomain.CurrentDomain.BaseDirectory + logfolder))
            {
                Directory.CreateDirectory(System.AppDomain.CurrentDomain.BaseDirectory + logfolder);
            }

            logfilepath = System.AppDomain.CurrentDomain.BaseDirectory + logfolder + "\\";
        }
    }
}