﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Web;

namespace ReadXML.Logger
{
    /// <summary>
    /// Summary description for LogError
    /// </summary>
    public class LogError
    {
        private static LogError instance;
        private static readonly object lockPad = new object();
        private static string configname;

        private LogError() { }

        public static LogError Get
        {
            get
            {
                lock (lockPad)
                {
                    if (instance == null)
                    {
                        instance = new LogError();
                        configname = StartLogConfig.configname;
                    }

                    return instance;
                }
            }
        }

        public void Log(Exception ex, string customMessage)
        {
            StringBuilder sb = new StringBuilder();
            sb.AppendFormat("===================== DateTime : " + DateTime.Now.ToString() + " ========================{0}", Environment.NewLine);
            while (ex != null)
            {
                sb.AppendFormat(CreateLogException(ex));
                ex = ex.InnerException;
            }

            if (!string.IsNullOrEmpty(customMessage))
            {
                sb.AppendFormat("{0}Custom Message :  {1}{2}", Environment.NewLine, customMessage, Environment.NewLine);
            }

            sb.Append("=================================================================================================");

            string logFile = GetFileName();

            using (FileStream fs = new FileStream(StartLogConfig.logfilepath + "\\" + logFile, FileMode.OpenOrCreate, FileAccess.ReadWrite))
            {
                fs.Close();
            }

            using (StreamWriter sw = new StreamWriter(StartLogConfig.logfilepath + "\\" + logFile, true))
            {
                sw.WriteLine(sb.ToString());
                sw.Flush();
                sw.Close();
            }
        }

        private string CreateLogException(Exception ex)
        {
            StringBuilder sb = new StringBuilder();

            sb.AppendFormat("HelpLink: {0}{1}", ex.HelpLink, Environment.NewLine);
            sb.AppendFormat("Message: {0}{1}", ex.Message, Environment.NewLine);
            sb.AppendFormat("Source: {0}{1}", ex.Source, Environment.NewLine);
            sb.AppendFormat("StackTrace: {0}{1}", ex.StackTrace, Environment.NewLine);
            sb.AppendFormat("{0}", Environment.NewLine);

            return sb.ToString();
        }

        private string GetFileName()
        {
            string logFile = StartLogConfig.logFile;

            bool isDateBase = StartLogConfig.rolldaily;

            if (isDateBase)
            {
                System.Globalization.DateTimeFormatInfo mfi = new System.Globalization.DateTimeFormatInfo();
                logFile = logFile.Split('.')[0] + "_" + DateTime.Now.Day.ToString() + "_" + mfi.GetAbbreviatedMonthName(DateTime.Now.Month) + "_" + DateTime.Now.Year.ToString() + "." + logFile.Split('.')[1];
            }

            if (StartLogConfig.rolldaily)
            {
                logFile = "1_" + logFile;
                try
                {
                    FileInfo fileInfo = new FileInfo(StartLogConfig.logfilepath + "\\" + logFile);
                    long _size = fileInfo.Length;

                    if (((_size / 1024) / 1024) > StartLogConfig.filesize)
                    {
                        int _alpha = Convert.ToInt16(logFile.Split('_')[0]);
                        _alpha = _alpha + 1;
                        List<string> _fileList = logFile.Split('_').ToList<string>();
                        _fileList[0] = _alpha.ToString();
                        StringBuilder sb = new StringBuilder();
                        foreach (string _fl in _fileList)
                        {
                            sb.Append(_fl + "_");
                        }
                        logFile = sb.ToString().TrimEnd('_');
                    }
                }
                catch { }
            }

            return logFile;
        }
    }
}