﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using ReadXML;

namespace ReadXML.Values
{
    public class Search
    {
        private static Search instance = null;
        private static readonly object _lockPad = new object();

        private Search() { }

        public static Search Get
        {
            get
            {
                lock (_lockPad)
                {
                    if (instance == null)
                        instance = new Search();

                    return instance;
                }
            }
        }

        private xmlvalue GetXmlElement(string name, string filename)
        {
            xmlvalue _xml = null;

            try
            {
                if (!string.IsNullOrEmpty(filename))
                {
                    filename = filename.ToLower();
                    _xml = Read.Get.XmlFiles[filename].Where(qr => qr.Name == name).FirstOrDefault();
                }
                else
                    _xml = Read.Get.Xmls.Where(qr => qr.Name == name).FirstOrDefault();
            }
            catch (Exception ex)
            {
                Logger.LogError.Get.Log(ex, "Error in searching Xml Element.");
            }

            return _xml;
        }

        public string GetValueByXmlElementName(string name)
        {
            return GetValueByXmlElementName(name, "");
        }

        public string GetValueByXmlElementName(string name, string filename)
        {
            string _value = "";            
            xmlvalue _xml = GetXmlElement(name, filename);

            if (_xml != null)
                _value = _xml.Value;

            return _value;
        }

        public string GetInnerXmlByXmlElementName(string name)
        {
            return GetInnerXmlByXmlElementName(name, "");
        }

        public string GetInnerXmlByXmlElementName(string name, string filename)
        {
            string _value = "";
            xmlvalue _xml = GetXmlElement(name, filename);

            if (_xml != null)
                _value = _xml.innerXml;

            return _value;
        }

        public string GetInnerTextByXmlElementName(string name)
        {
            return GetInnerTextByXmlElementName(name, "");
        }

        public string GetInnerTextByXmlElementName(string name, string filename)
        {
            string _value = "";
            xmlvalue _xml = GetXmlElement(name, filename);

            if (_xml != null)
                _value = _xml.innerText;

            return _value;
        }

        public xmlvalue GetNodeByXmlElementName(string name)
        {
            return GetNodeByXmlElementName(name, "");
        }

        public xmlvalue GetNodeByXmlElementName(string name, string filename)
        {
            xmlvalue _xml = GetXmlElement(name, filename);
            xmlvalue _xml_ = null;
            if (_xml != null)
            {
                _xml_ = new xmlvalue();
                _xml_.innerText = _xml.innerText;
                _xml_.innerXml = _xml.innerXml;
                _xml_.Name = _xml.Name;
                _xml_.Value = _xml.Value;
            }

            return _xml_;
        }

        public xmlvalue GetNodeByXmlElementNameWithChild(string name)
        {
            return GetNodeByXmlElementNameWithChild(name, "");
        }

        public xmlvalue GetNodeByXmlElementNameWithChild(string name, string filename)
        {
            return GetXmlElement(name, filename);
        }

        public string GetValueByAttributeName(string name)
        {
            return GetValueByAttributeName(name, "");
        }

        public string GetValueByAttributeName(string name, string filename)
        {
            string _value = "";
            xmlvalue _xml = null;

            if (!string.IsNullOrEmpty(filename))
                _xml = Read.Get.XmlFiles[filename].Where(xl => xl.Attributes.ContainsKey(name)).FirstOrDefault();
            else
                _xml = Read.Get.Xmls.Where(xl => xl.Attributes.ContainsKey(name)).FirstOrDefault();

            if (_xml != null)
                _value = _xml.Attributes[name];

            return _value;
        }

        public xmlvalue GetNodeByAttributeName(string name)
        {
            return GetNodeByAttributeName(name, "");
        }

        public xmlvalue GetNodeByAttributeName(string name, string filename)
        {
            xmlvalue _xml = null;

            if (!string.IsNullOrEmpty(filename))
                _xml = Read.Get.XmlFiles[filename].Where(xl => xl.Attributes.ContainsKey(name)).FirstOrDefault();
            else
                _xml = Read.Get.Xmls.Where(xl => xl.Attributes.ContainsKey(name)).FirstOrDefault();

            return _xml;
        }

        public List<xmlvalue> GetAllNodes()
        {
            return Read.Get.Xmls;
        }

        public Dictionary<string, List<xmlvalue>> GetAllNodesWithFiles()
        {
            return Read.Get.XmlFiles;
        }


    }
}
