﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Xml;
using System.Text;
using System.Threading.Tasks;

namespace ReadXML
{
    public class Read
    {        
        private static Read instance = null;
        private static readonly object _lockPad = new object();
        private Dictionary<string,List<xmlvalue>> _xmlfiles = new  Dictionary<string,List<xmlvalue>>();
        private List<xmlvalue> _xmls = new List<xmlvalue>();
        private List<Exception> _exceptions = new List<Exception>();
        private xmlvalue _xml = new xmlvalue();
        private static string startconfig;
        
        private Read(){}

        public static Read Get
        {
            get
            {
                lock(_lockPad)
                {
                    if(instance == null)
                        instance = new Read ();

                    startconfig = Configuration.StartReadXmlConfig.configname;

                    return instance;
                }
            }
        }

        internal Dictionary<string, List<xmlvalue>> XmlFiles
        {
            get
            {
                return _xmlfiles;
            }
        }

        internal List<xmlvalue> Xmls
        {
            get
            {
                List<xmlvalue> _list = new List<xmlvalue>();
                foreach (KeyValuePair<string, List<xmlvalue>> _kvp in _xmlfiles)
                {
                    _list.AddRange(_kvp.Value);
                }
                return _list;
            }
        }

        public List<Exception> GetAllExceptions
        {
            get
            {
                return _exceptions;
            }
        }

        public void XmlFile(string xmlfile)
        {
            string _filename = xmlfile;
            string _xmlfile = AppDomain.CurrentDomain.BaseDirectory + Configuration.StartReadXmlConfig.readfolder + "\\" + xmlfile;

            try
            {
                bool _isAvaliable = System.IO.File.Exists(_xmlfile);

                if (!_isAvaliable) {
                    Exception _ex = new Exception(string.Format("File: {0} does not exists.", _filename));
                    _exceptions.Add(_ex);
                    Logger.LogError.Get.Log(_ex, "File: " + xmlfile + " does not exist.");
                }
            }
            catch (Exception ex)
            {
                _exceptions.Add(ex);
            }

            XmlDocument dom = new XmlDocument();
            try
            {
                dom.Load(_xmlfile);
            }
            catch (Exception ex)
            {
                _exceptions.Add(ex);
                Logger.LogError.Get.Log(ex, "File: " + xmlfile + " is not a valid xml/configration file.");
            }

            bool _isNewConfig = true;

            if (_xmlfiles.ContainsKey(_filename))
            {
                _isNewConfig = false;
            }

            if (!_isNewConfig) {
                Exception _ex = new Exception(string.Format("File: {0} had already in xml values."));
                _exceptions.Add(_ex);
                Logger.LogError.Get.Log(_ex, "File: " + xmlfile + " had already in xml values.");
            }

            try
            {
                _xml = new xmlvalue();
                _xml.Name = dom.DocumentElement.Name;
                _xml.Value = dom.DocumentElement.Value;
                _xml.innerText = dom.InnerText;
                _xml.innerXml = dom.InnerXml;

                if (dom.DocumentElement.HasAttributes)
                {
                    foreach (XmlAttribute _attr in dom.DocumentElement.Attributes)
                    {
                        _xml.AddAttribute(_attr.Name, _attr.Value);
                    }
                }

                if (dom.DocumentElement.HasChildNodes)
                {
                    foreach (XmlNode _node in dom.DocumentElement.ChildNodes)
                    {
                        _xml.AddChild(AddNodes(_node));
                    }
                }

                _xmls = new List<xmlvalue>();

                MakeXmlList();

                _xmlfiles.Add(_filename, _xmls);
            }
            catch (Exception ex)
            {
                _exceptions.Add(ex);
                Logger.LogError.Get.Log(ex, "File: " + xmlfile + " error. Please review stacktrace.");
            }
        }

        private void MakeXmlList()
        {
            _xmls.Add(_xml);

            foreach (xmlvalue xmlv in _xml.Childs)
            {
                MakeXmlList(xmlv);
            }
        }

        private void MakeXmlList(xmlvalue xml)
        {
            _xmls.Add(xml);

            foreach (xmlvalue xmlv in xml.Childs)
            {
                MakeXmlList(xmlv);
            }
        }

        private xmlvalue AddNodes(XmlNode xmlnode)
        {
            xmlvalue _xv = new xmlvalue();

            _xv.Name = xmlnode.Name;
            _xv.Value = xmlnode.Value;
            _xv.innerText = xmlnode.InnerText;
            _xv.innerXml = xmlnode.InnerXml;

            if (xmlnode.Attributes != null)
            {
                foreach (XmlAttribute _attr in xmlnode.Attributes)
                {
                    _xv.AddAttribute(_attr.Name, _attr.Value);
                }
            }

            if (xmlnode.HasChildNodes)
            {
                foreach (XmlNode _node in xmlnode.ChildNodes)
                {
                    _xv.AddChild(AddNodes(_node));
                }
            }

            return _xv;
        }
        
    }
}
