﻿using System;
using System.Collections.Generic;
using System.Configuration;
using System.Linq;
using System.Web;


namespace ReadXML.Logger.Configuration
{
    /// <summary>
    /// Summary description for LoggerConfiguration
    /// </summary>
    public class XmlLoggerConfiguration : ConfigurationSection
    {
        private static XmlLoggerConfiguration _loggerConfig = (XmlLoggerConfiguration)ConfigurationManager.GetSection("xmllogger");
        public static XmlLoggerConfiguration Settings { get { return _loggerConfig; } }

        [ConfigurationProperty("name")]
        public string Name { get { return (string)base["name"]; } }

        [ConfigurationProperty("logconfig")]
        public LoggerElement LogConfig { get { return (LoggerElement)base["logconfig"]; } }
    }

    public class LoggerElement : ConfigurationElement
    {
        [ConfigurationProperty("folder", DefaultValue = "Logger", IsRequired = true)]
        public string Folder { get { return (string)base["folder"]; } }

        [ConfigurationProperty("file", DefaultValue = "logs.txt", IsRequired = true)]
        public string File { get { return (string)base["file"]; } }

        [ConfigurationProperty("filesize", DefaultValue = 1024, IsRequired = true)]
        public int FileSize { get { return (int)base["filesize"]; } }

        [ConfigurationProperty("rollday", DefaultValue = true, IsRequired = true)]
        public bool RollDaily { get { return (bool)base["rollday"]; } }
    }
}