﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace ReadXml
{
    public class ReadingException
    {
        // Summary:
        //     Gets a collection of key/value pairs that provide additional user-defined
        //     information about the exception.
        //
        // Returns:
        //     An object that implements the System.Collections.IDictionary interface and
        //     contains a collection of user-defined key/value pairs. The default is an
        //     empty collection.
        public virtual IDictionary Data { get; set; }
        //
        // Summary:
        //     Gets or sets a link to the help file associated with this exception.
        //
        // Returns:
        //     The Uniform Resource Name (URN) or Uniform Resource Locator (URL).
        public virtual string HelpLink { get; set; }
        //
        // Summary:
        //     Gets or sets HRESULT, a coded numerical value that is assigned to a specific
        //     exception.
        //
        // Returns:
        //     The HRESULT value.
        public int HResult { get; set; }
        //
        // Summary:
        //     Gets the System.Exception instance that caused the current exception.
        //
        // Returns:
        //     An instance of Exception that describes the error that caused the current
        //     exception. The InnerException property returns the same value as was passed
        //     into the constructor, or a null reference (Nothing in Visual Basic) if the
        //     inner exception value was not supplied to the constructor. This property
        //     is read-only.
        public Exception InnerException { get; set; }
        //
        // Summary:
        //     Gets a message that describes the current exception.
        //
        // Returns:
        //     The error message that explains the reason for the exception, or an empty
        //     string ("").
        public virtual string Message { get; set; }
        //
        // Summary:
        //     Gets or sets the name of the application or the object that causes the error.
        //
        // Returns:
        //     The name of the application or the object that causes the error.
        //
        // Exceptions:
        //   System.ArgumentException:
        //     The object must be a runtime System.Reflection object
        public virtual string Source { get; set; }
        //
        // Summary:
        //     Gets a string representation of the immediate frames on the call stack.
        //
        // Returns:
        //     A string that describes the immediate frames of the call stack.
        public virtual string StackTrace { get; set; }
    }
}
