<?php

/**
* Ciudades y Regiones de Chile
* Weight: Porcentaje de Población de la Región respecto al total nacional * 100, segun Censo 2012
* Source: http://datos.gob.cl/datasets/ver/29596
* @package Countries
* @author Gonzalo "NioZero" Hidalgo <ghidalgo@frostdisk.com>
*/
class Country_Chile extends CountryPlugin {
	protected $countryName = "Chile";
	protected $countrySlug = "chile";
	protected $regionNames = "Chilean Regions";
	protected $continent = "south_america";

	protected $extendedData = array(
		"zipFormat" => "xxxxxx"
	);

	protected $countryData = array(
		array(
			"regionName" => "Arica y Parinacota",
			"regionShort" => "XV",
			"regionSlug" => "arica_y_parinacota",
			"weight" => 132,
			"cities" => array(
				"Arica",
				"Camarones",
				"Putre",
				"General Lagos"
			)
		),
		array(
			"regionName" => "Tarapacá",
			"regionShort" => "I",
			"regionSlug" => "tarapaca",
			"weight" => 185,
			"cities" => array(
				"Iquique",
				"Alto Hospicio",
				"Pozo Almonte",
				"Camiña",
				"Colchane",
				"Huara",
				"Pica"
			)
		),
		array(
			"regionName" => "Antofagasta",
			"regionShort" => "II",
			"regionSlug" => "antofagasta",
			"weight" => 344,
			"cities" => array(
				"Antofagasta",
				"Mejillones",
				"Sierra Gorda",
				"Taltal",
				"Calama",
				"Ollagüe",
				"San Pedro de Atacama",
				"Tocopilla",
				"María Elena"
			)
		),
		array(
			"regionName" => "Atacama",
			"regionShort" => "III",
			"regionSlug" => "atacama",
			"weight" => 173,
			"cities" => array(
				"Copiapó",
				"Caldera",
				"Tierra Amarilla",
				"Chañaral",
				"Diego de Almagro",
				"Vallenar",
				"Alto del Carmen",
				"Freirina",
				"Huasco"
			)
		),
		array(
			"regionName" => "Coquimbo",
			"regionShort" => "IV",
			"regionSlug" => "coquimbo",
			"weight" => 426,
			"cities" => array(
				"La Serena",
				"Coquimbo",
				"Andacollo",
				"La Higuera",
				"Paiguano",
				"Vicuña",
				"Illapel",
				"Canela",
				"Los Vilos",
				"Salamanca",
				"Ovalle",
				"Combarbalá",
				"Monte Patria",
				"Punitaqui",
				"Río Hurtado"
			)
		),
		array(
			"regionName" => "Valparaíso",
			"regionShort" => "V",
			"regionSlug" => "valparaiso",
			"weight" => 1015,
			"cities" => array(
				"Valparaíso",
				"Casablanca",
				"Concón",
				"Juan Fernández",
				"Puchuncaví",
				"Quintero",
				"Viña del Mar",
				"Isla de Pascua",
				"Los Andes",
				"Calle Larga",
				"Rinconada",
				"San Esteban",
				"La Ligua",
				"Cabildo",
				"Papudo",
				"Petorca",
				"Zapallar",
				"Quillota",
				"Calera",
				"Hijuelas",
				"La Cruz",
				"Nogales",
				"San Antonio",
				"Algarrobo",
				"Cartagena",
				"El Quisco",
				"El Tabo",
				"Santo Domingo",
				"San Felipe",
				"Catemu",
				"Llaillay",
				"Panquehue",
				"Putaendo",
				"Santa María",
				"Quilpué",
				"Limache",
				"Olmué",
				"Villa Alemana"
			)
		),
		array(
			"regionName" => "O'Higgins",
			"regionShort" => "VI",
			"regionSlug" => "ohiggins",
			"weight" => 511,
			"cities" => array(
				"Rancagua",
				"Codegua",
				"Coinco",
				"Coltauco",
				"Doñihue",
				"Graneros",
				"Las Cabras",
				"Machalí",
				"Malloa",
				"Mostazal",
				"Olivar",
				"Peumo",
				"Pichidegua",
				"Quinta de Tilcoco",
				"Rengo",
				"Requínoa",
				"San Vicente",
				"Pichilemu",
				"La Estrella",
				"Litueche",
				"Marchihue",
				"Navidad",
				"Paredones",
				"San Fernando",
				"Chépica",
				"Chimbarongo",
				"Lolol",
				"Nancagua",
				"Palmilla",
				"Peralillo",
				"Placilla",
				"Pumanque",
				"Santa Cruz"
			)
		),
		array(
			"regionName" => "Maule",
			"regionShort" => "VII",
			"regionSlug" => "maule",
			"weight" => 581,
			"cities" => array(
				"Talca",
				"Constitución",
				"Curepto",
				"Empedrado",
				"Maule",
				"Pelarco",
				"Pencahue",
				"Río Claro",
				"San Clemente",
				"San Rafael",
				"Cauquenes",
				"Chanco",
				"Pelluhue",
				"Curicó",
				"Hualañé",
				"Licantén",
				"Molina",
				"Rauco",
				"Romeral",
				"Sagrada Familia",
				"Teno",
				"Vichuquén",
				"Linares",
				"Colbún",
				"Longaví",
				"Parral",
				"Retiro",
				"San Javier",
				"Villa Alegre",
				"Yerbas Buenas"
			)
		),
		array(
			"regionName" => "Biobío",
			"regionShort" => "VII",
			"regionSlug" => "biobio",
			"weight" => 1179,
			"cities" => array(
				"Concepción",
				"Coronel",
				"Chiguayante",
				"Florida",
				"Hualqui",
				"Lota",
				"Penco",
				"San Pedro de la Paz",
				"Santa Juana",
				"Talcahuano",
				"Tomé",
				"Hualpén",
				"Lebu",
				"Arauco",
				"Cañete",
				"Contulmo",
				"Curanilahue",
				"Los Álamos",
				"Tirúa",
				"Los Ángeles",
				"Antuco",
				"Cabrero",
				"Laja",
				"Mulchén",
				"Nacimiento",
				"Negrete",
				"Quilaco",
				"Quilleco",
				"San Rosendo",
				"Santa Bárbara",
				"Tucapel",
				"Yumbel",
				"Alto Biobío",
				"Chillán",
				"Bulnes",
				"Cobquecura",
				"Coelemu",
				"Coihueco",
				"Chillán Viejo",
				"El Carmen",
				"Ninhue",
				"Ñiquén",
				"Pemuco",
				"Pinto",
				"Portezuelo",
				"Quillón",
				"Quirihue",
				"Ránquil",
				"San Carlos",
				"San Fabián",
				"San Ignacio",
				"San Nicolás",
				"Treguaco",
				"Yungay"
			)
		),
		array(
			"regionName" => "Araucanía",
			"regionShort" => "IX",
			"regionSlug" => "araucania",
			"weight" => 552,
			"cities" => array(
				"Temuco",
				"Carahue",
				"Cunco",
				"Curarrehue",
				"Freire",
				"Galvarino",
				"Gorbea",
				"Lautaro",
				"Loncoche",
				"Melipeuco",
				"Nueva Imperial",
				"Padre las Casas",
				"Perquenco",
				"Pitrufquén",
				"Pucón",
				"Saavedra",
				"Teodoro Schmidt",
				"Toltén",
				"Vilcún",
				"Villarrica",
				"Cholchol",
				"Angol",
				"Collipulli",
				"Curacautín",
				"Ercilla",
				"Lonquimay",
				"Los Sauces",
				"Lumaco",
				"Purén",
				"Renaico",
				"Traiguén",
				"Victoria"
			)
		),
		array(
			"regionName" => "Los Ríos",
			"regionShort" => "XIV",
			"regionSlug" => "los_rios",
			"weight" => 225,
			"cities" => array(
				"Valdivia",
				"Corral",
				"Lanco",
				"Los Lagos",
				"Máfil",
				"Mariquina",
				"Paillaco",
				"Panguipulli",
				"La Unión",
				"Futrono",
				"Lago Ranco",
				"Río Bueno"
			)
		),
		array(
			"regionName" => "Los Lagos",
			"regionShort" => "X",
			"regionSlug" => "los_lagos",
			"weight" => 468,
			"cities" => array(
				"Puerto Montt",
				"Calbuco",
				"Cochamó",
				"Fresia",
				"Frutillar",
				"Los Muermos",
				"Llanquihue",
				"Maullín",
				"Puerto Varas",
				"Castro",
				"Ancud",
				"Chonchi",
				"Curaco de Vélez",
				"Dalcahue",
				"Puqueldón",
				"Queilén",
				"Quellón",
				"Quemchi",
				"Quinchao",
				"Osorno",
				"Puerto Octay",
				"Purranque",
				"Puyehue",
				"Río Negro",
				"San Juan de la Costa",
				"San Pablo",
				"Chaitén",
				"Futaleufú",
				"Hualaihué",
				"Palena"
			)
		),
		array(
			"regionName" => "Aisén",
			"regionShort" => "XIV",
			"regionSlug" => "aisen",
			"weight" => 60,
			"cities" => array(
				"Coihaique",
				"Lago Verde",
				"Aisén",
				"Cisnes",
				"Guaitecas",
				"Cochrane",
				"O'Higgins",
				"Tortel",
				"Chile Chico",
				"Río Ibáñez"
			)
		),
		array(
			"regionName" => "Magallanes y Antártica Chilena",
			"regionShort" => "XII",
			"regionSlug" => "magallanes_y_antartica_chilena",
			"weight" => 92,
			"cities" => array(
				"Punta Arenas",
				"Laguna Blanca",
				"Río Verde",
				"San Gregorio",
				"Cabo de Hornos",
				"Antártica",
				"Porvenir",
				"Primavera",
				"Timaukel",
				"Natales",
				"Torres del Paine"
			)
		),
		array(
			"regionName" => "Metropolitana de Santiago",
			"regionShort" => "RM",
			"regionSlug" => "metropolitana_de_santiago",
			"weight" => 4057,
			"cities" => array(
				"Santiago",
				"Cerrillos",
				"Cerro Navia",
				"Conchalí",
				"El Bosque",
				"Estación Central",
				"Huechuraba",
				"Independencia",
				"La Cisterna",
				"La Florida",
				"La Granja",
				"La Pintana",
				"La Reina",
				"Las Condes",
				"Lo Barnechea",
				"Lo Espejo",
				"Lo Prado",
				"Macul",
				"Maipú",
				"Ñuñoa",
				"Pedro Aguirre Cerda",
				"Peñalolén",
				"Providencia",
				"Pudahuel",
				"Quilicura",
				"Quinta Normal",
				"Recoleta",
				"Renca",
				"San Joaquín",
				"San Miguel",
				"San Ramón",
				"Vitacura",
				"Puente Alto",
				"Pirque",
				"San José de Maipo",
				"Colina",
				"Lampa",
				"Tiltil",
				"San Bernardo",
				"Buin",
				"Calera de Tango",
				"Paine",
				"Melipilla",
				"Alhué",
				"Curacaví",
				"María Pinto",
				"San Pedro",
				"Talagante",
				"El Monte",
				"Isla de Maipo",
				"Padre Hurtado",
				"Peñaflor"
			)
		)
	);

	public function install() {
		return CountryPluginHelper::populateDB($this->countryName, $this->countrySlug, $this->countryData);
	}
}