﻿@*********************************************************************************
** This file is part of the "Arebis.AspNet.WebApi.ClientsLib.cs" nuget package. **
** To install: Install-package "Arebis.AspNet.WebApi.JsClients.cs"              **
** To upgrade: Upgrade-package "Arebis.AspNet.WebApi.JsClients.cs"              **
** Copyright Rudi Breedenraedt (http://www.arebis.be)                           **
*********************************************************************************@
@using $rootnamespace$.Areas.HelpPage
@{
    var AppName = (String)ViewBag.AppName;
    var Configuration = (System.Web.Http.HttpConfiguration)ViewBag.Configuration;
    var ApiExplorer = (System.Web.Http.Description.IApiExplorer)ViewBag.ApiExplorer;
    var DocumentationProvider = (System.Web.Http.Description.IDocumentationProvider)ViewBag.DocumentationProvider;
    var RootUrl = (String)ViewBag.ApiRootUrl;

    Layout = null;

    if (!ViewBag.IsChildAction)
    {
        Response.ContentType = "application/javascript";
        Response.Headers.Add("Content-Disposition", "attachment; filename=\"nodejs." + AppName.Replace(" ", "").ToLowerInvariant() + "-services.js\"");
    }
}/* Node.js client for @(ViewBag.AppName) */
/* Generated from "@(Request.Url)" on @(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss", System.Globalization.CultureInfo.InvariantCulture)) */

// Declares the @AppName Services object:
var @(ToCamelCase(AppName.Replace(" ", "")))Services = { };
@(ToCamelCase(AppName.Replace(" ", "")))Services._requestor = require('@(new Uri(RootUrl).Scheme.ToLowerInvariant())');
@(ToCamelCase(AppName.Replace(" ", "")))Services._encoding = 'UTF-8';
@(ToCamelCase(AppName.Replace(" ", "")))Services._getOptions = function() { return { hostname: '@(new Uri(RootUrl).Host)', port: '@(new Uri(RootUrl).Port)' } };
@(ToCamelCase(AppName.Replace(" ", "")))Services._getHeader = function() { return { }; };
@(ToCamelCase(AppName.Replace(" ", "")))Services._postContentType = 'application/json';
@(ToCamelCase(AppName.Replace(" ", "")))Services._postContentTransform = function(data) { return JSON.stringify(data); };
@(ToCamelCase(AppName.Replace(" ", "")))Services._resultContentTransform = function(str) { return JSON.parse(str); };

@foreach (var controllerGroup in ApiExplorer.ApiDescriptions.GroupBy(d => d.ActionDescriptor.ControllerDescriptor).OrderBy(g => g.Key.ControllerName))
{
    var actions = controllerGroup.ToList();
<text>// <b><u>Declares the @(controllerGroup.Key.ControllerName) service:</u></b>
@(ToCamelCase(AppName.Replace(" ", "")))Services.@(ToCamelCase(controllerGroup.Key.ControllerName)) = { };
</text>
    for (int i = 0; i < actions.Count; i++)
    {
        var action = actions.Skip(i).First();
        var uniqueActionName = ToCamelCase(action.ActionDescriptor.ActionName);
        var method = Convert.ToString(action.GetType().GetProperty("HttpMethod").GetValue(action));
        if (actions.Take(i).Any(a => a.ActionDescriptor.ActionName == action.ActionDescriptor.ActionName))
        {
            uniqueActionName += (2 + actions.Take(0).Count(a => a.ActionDescriptor.ActionName == action.ActionDescriptor.ActionName));
        }
        var relativePathWithParams = action.RelativePath;
        foreach (var par in action.ParameterDescriptions)
        {
            relativePathWithParams = relativePathWithParams.Replace("{" + par.Name + "}", "'+encodeURIComponent(" + par.Name + ")+'");
        }
        var fromBodyParam = action.ParameterDescriptions.FirstOrDefault(p => p.Source.ToString() == "FromBody");
<text>// Declares the @(ToCamelCase(action.ActionDescriptor.ActionName)) service method:
// <a href="@(RootUrl)/@(Url.Action("Api", "Help", new { id = action.GetFriendlyId() }))">Help for @(uniqueActionName)</a>
@(ToCamelCase(AppName.Replace(" ", "")))Services.@(ToCamelCase(controllerGroup.Key.ControllerName)).@(uniqueActionName) = function (@(String.Join("", action.ParameterDescriptions.Select(p => p.Name + ", ").ToArray()))onSuccess, onError) {
@if (fromBodyParam != null)
{<text>    var _data = @(ToCamelCase(AppName.Replace(" ", "")))Services._postContentTransform(@(fromBodyParam.Name));
</text>}
    var _options = @(ToCamelCase(AppName.Replace(" ", "")))Services._getOptions();
    _options.method = '@(method)';
    _options.path = '/@Html.Raw(relativePathWithParams)';
@if (fromBodyParam != null)
{<text>    _options.headers = @(ToCamelCase(AppName.Replace(" ", "")))Services._getHeader();
    _options.headers['Content-Type'] = @(ToCamelCase(AppName.Replace(" ", "")))Services._postContentType;
    _options.headers['Content-Length'] = Buffer.byteLength(_data);
</text>}
    var _req = @(ToCamelCase(AppName.Replace(" ", "")))Services._requestor.request(_options, function(_res) {
        var _responseData = '';
        _res.setEncoding(@(ToCamelCase(AppName.Replace(" ", "")))Services._encoding);
        _res.on('data', function (_chunk) {
            _responseData += _chunk;
        });
        _res.on('end', function () {
            if (!(typeof onSuccess === 'undefined')) onSuccess(@(ToCamelCase(AppName.Replace(" ", "")))Services._resultContentTransform(_responseData), _res);
        });
        _res.on('error', function (_err) {
            if (!(typeof onError === 'undefined')) onError(_err, _res);
        });
    });
@if (fromBodyParam != null)
{<text>    _req.write(_data);
</text>}
    _req.end();
};
</text>
    }
}
// Export as module:
module.exports = @(ToCamelCase(AppName.Replace(" ", "")))Services;

@functions{

    string ToCamelCase(string str)
    {
        if (String.IsNullOrEmpty(str))
            return str;
        else if (str.Length == 1)
            return str.ToLowerInvariant();
        else
            return str.Substring(0, 1).ToLowerInvariant() + str.Substring(1);
    }

}