﻿$(document).ready(function () {
    selectEmployee($("#employeeId").val());
});

function selectEmployee(id) {
    $.ajax("/../api/values/select", {
        data: { ID: id },
        type: "GET",
        ifModified: true,  // Remember to turn this option on.
        statusCode: {
            304: function () {
                $("#statusCode").val(304);
                $("#cacheMessage").text("The content is rendered from cache.");
            },
            200: function () {
                $("#statusCode").val(200);
                $("#cacheMessage").text("The content is rendered from server.");
            }
        },
        success: function (data, textStatus, jqXHR) {
            // Parameter 'data' is null if status is 304. 
            if (jqXHR.status == 304) {
                // Render data from cache.
                data = jQuery.data(mainForm, id);
            } else {
                // Save data into cache.
                jQuery.data(mainForm, data["ID"], data);
            }
            $("#firstName").val(data["FirstName"]);
            $("#lastName").val(data["LastName"]);
            $("#alias").val(data["Alias"]);
            $("#steamId").val(data["SteamID"]);
            $("#sex").val(data["Sex"]);
            $("#description").val(data["Description"]);

            // Show response headers. 
            $("#lastModified").val(jqXHR.getResponseHeader("Last-Modified"));
            $("#expires").val(jqXHR.getResponseHeader("Expires"));
            $("#eTag").val(jqXHR.getResponseHeader("ETag"));
        }
    });
}

function updateEmployee() {
    $.ajax($("#mainForm").attr("action"), {
        data: $("#mainForm").serialize(),
        type: "PUT",
        success: function (data, textStatus, jqXHR) {
            $("#cacheMessage").text("Item saved.");
        }
    });
}

