﻿using System;
using System.Collections.Generic;
using System.ComponentModel;

namespace HttpCaching.Models
{
    public class Employee : INotifyPropertyChanged
    {
        #region Fields

        private Guid id;
        private string firstName;
        private string lastName;
        private string description;
        private string steamId;
        private string alias;
        private int sex;

        #endregion

        #region Properties

        public Guid ID
        {
            get { return this.id; }
            set { this.ChangeProperty(ref this.id, value, "ID"); }
        }

        public string FirstName
        {
            get { return this.firstName; }
            set { this.ChangeProperty(ref this.firstName, value, "FirstName"); }
        }

        public string LastName
        {
            get { return this.lastName; }
            set { this.ChangeProperty(ref this.lastName, value, "LastName"); }
        }

        public string Description
        {
            get { return this.description; }
            set { this.ChangeProperty(ref this.description, value, "Description"); }
        }

        public string SteamID
        {
            get { return this.steamId; }
            set { this.ChangeProperty(ref this.steamId, value, "SteamID"); }
        }

        public string Alias
        {
            get { return this.alias; }
            set { this.ChangeProperty(ref this.alias, value, "Alias"); }
        }

        public int Sex
        {
            get { return this.sex; }
            set { this.ChangeProperty(ref this.sex, value, "Sex"); }
        }

        #endregion

        #region Event

        public event PropertyChangedEventHandler PropertyChanged;

        #endregion

        #region Constructor

        public Employee()
        {
        }

        #endregion

        #region Event Raiser

        protected virtual void OnPropertyChanged(PropertyChangedEventArgs e)
        {
            if (this.PropertyChanged != null)
                this.PropertyChanged(this, e);
        }

        #endregion

        #region Others

        protected void ChangeProperty<T>(ref T currentValue, T newValue, string propertyName)
        {
            if (!EqualityComparer<T>.Default.Equals(currentValue, newValue))
            {
                currentValue = newValue;
                this.OnPropertyChanged(new PropertyChangedEventArgs(propertyName));
            }
        }

        #endregion
    }
}