﻿
function WebBinding_ApplyAngularDedicateImplementation(wbObj) {
    var angInjector = angular.injector(["ng"]);
    var angParser = angInjector.get("$parse");

    var rootObjectWrappers = [];

    var isDOMContentLoaded = false;
    var isApplyBindingsCalled = false;
    var isBeginServerChangesRequestsCalled = false;

    var bindingMappingsRegistrations = [];

    function isSimpleType(val) {
        return typeof val === 'string' || typeof val === 'number' || typeof val === 'boolean';
    }

    function isScope(obj) {
        if (obj && obj.$apply && obj.$watch && obj.$watchCollection) {
            return true;
        }

        return false;
    }

    function BindingMappingRegistration(bindingId, scopeGetter, bindingMappingObj) {
        this.bindingId = bindingId;
        this.scopeGetter = scopeGetter;
        this.bindingMappingObj = bindingMappingObj;
    }

    function onDOMContentLoaded() {
        isDOMContentLoaded = true;

        if (isBeginServerChangesRequestsCalled) { 
            /*--- The 'beginServerChangesRequests' function was called before the 'DOMContentLoaded' event... ---*/
            wbObj.beginServerChangesRequests();
        }

        if (isApplyBindingsCalled) {
            /*--- The 'applyBindings' function was called before the 'DOMContentLoaded' event... ---*/
            wbObj.applyBindings();
        }
    }

    window.addEventListener('DOMContentLoaded', onDOMContentLoaded);

    function validateRootObjectWrappers() {
        for (var objWrapInx = 0; objWrapInx < rootObjectWrappers.length; objWrapInx++) {
            var objWrapper = rootObjectWrappers[objWrapInx];
            if (objWrapper instanceof RootObjectWrapper) {
                objWrapper.validateProperties();
            }
        }
    }

    function RootObjectWrapper(rootObj) {
        this.orgRootObj = rootObj;
        this.wrapperRootObj = {};
    }

    RootObjectWrapper.prototype.validateProperties = function () {
        for (var prop in this.wrapperRootObj) {
            var objHolder = this.wrapperRootObj[prop];
            if (objHolder instanceof PropertyObjectHolder) {
                objHolder.validateProperties(this.orgRootObj, prop);
            }
        }
    };

    RootObjectWrapper.prototype.retrieveBoundObjectForPropertyPath = function (_propPath_) {
        var resObj = this.wrapperRootObj;

        var currPropPath = "";
        var propPathExt = _propPath_;

        while (propPathExt.length > 0) {
            var currPropName;

            var firstDotIndex = propPathExt.indexOf(".");
            var firstBracketIndex = propPathExt.indexOf("[");

            var isArrayElement = false;

            if (firstBracketIndex >= 0 && (firstDotIndex < 0 || firstBracketIndex < firstDotIndex)) {
                /*--- There is a bracket before the dot. - This is an array property. ---*/
                if (firstBracketIndex == 0) {
                    /*--- This is an array's element... ---*/
                    var firstCloseBracketIndex = propPathExt.indexOf("]");
                    currPropName = propPathExt.substr(1, firstCloseBracketIndex - firstBracketIndex - 1);

                    /*--- If there is a dot directly after the closing bracket, we should skip it. ---*/
                    propPathExt = propPathExt.substr(firstCloseBracketIndex + (((firstDotIndex - firstCloseBracketIndex) == 1) ? 2 : 1));

                    isArrayElement = true;
                } else {
                    currPropName = propPathExt.substr(0, firstBracketIndex);
                    propPathExt = propPathExt.substr(firstBracketIndex);
                }
            } else {
                if (firstDotIndex >= 0) {
                    currPropName = propPathExt.substr(0, firstDotIndex);
                    propPathExt = propPathExt.substr(firstDotIndex + 1);
                } else {
                    currPropName = propPathExt;
                    propPathExt = "";
                }
            }

            if (isArrayElement) {
                currPropPath += '[' + currPropName + ']';

                /*--- For and array element the property's name is an element's index... ---*/
                currPropName = parseInt(currPropName);
            } else {
                if (currPropPath.length > 0) {
                    currPropPath += '.';
                }

                currPropPath += currPropName;
            }

            if (!resObj[currPropName] || !(resObj[currPropName] instanceof PropertyObjectHolder)) {
                resObj[currPropName] = wbObj.angImp_orgCreateBoundObjectForPropertyPath(this.wrapperRootObj, currPropPath);
 
                /*--- The WebBinding's property-path's syntax is same as the AngularJS expression's syntax.
                      So, we can use it as the property-expression too. ---*/
                resObj[currPropName].validateProperties(this.orgRootObj, currPropPath);
            }

            resObj = resObj[currPropName].getValue();
        }

        return resObj;
    };

    function PropertyObjectHolder() {
		this.pathExp = "";
		this.rootObj = {};
		this.isArray = false;

		this.innerValue = null;

		this.getterFn = null;
		this.setterFn = null;

		this.pendingNotificationFunc = null;
		this.watchDeregistrationFunc = null;

		this.innerValueElementsShadow = null;
        
    }

    PropertyObjectHolder.prototype.validateProperties = function (rootObj, pathExpression) {
        var shouldIntialize = !this.isValid();

        this.rootObj = rootObj;
        this.pathExp = pathExpression;

        this.getterFn = this.getGetterFunction();
        this.setterFn = this.getSetterFunction();

        if (this.isArray) {
            if (shouldIntialize) {
                this.setterFn(this.rootObj, []);
            }

            if (this.innerValue instanceof Array) {
                for (var elemInx = 0; elemInx < this.innerValue.length; elemInx++) {
                    var objHolder = this.innerValue[elemInx];
                    if (objHolder instanceof PropertyObjectHolder) {
                        var subPropExp = pathExpression + '[' + elemInx + ']';
                        objHolder.validateProperties(rootObj, subPropExp);
                    }
                }
            }

            if (this.pendingNotificationFunc) {
                /*--- There is a notifications function that is pending for registration. ---*/
                if (this.subscribeForArrayChange(this.pendingNotificationFunc)) {
                    this.pendingNotificationFunc = null;
                }
            }
        } else {
            if (shouldIntialize) {
                if (this.hasPropertyObjectHolderProperties()) {
                    this.setterFn(this.rootObj, {});
                } else {
                    this.setterFn(this.rootObj, "");
                    this.innerValue = "";
                }
            }

            if (this.innerValue) {
                for (var prop in this.innerValue) {
                    var objHolder = this.innerValue[prop];
                    if (objHolder instanceof PropertyObjectHolder) {
                        var subPropExp = pathExpression + '.' + prop;
                        objHolder.validateProperties(rootObj, subPropExp);
                    }
                }
            }

            if (this.pendingNotificationFunc) {
                /*--- There is a notifications function that is pending for registration. ---*/
                if (this.subscribeForPropertyChange(this.pendingNotificationFunc)) {
                    this.pendingNotificationFunc = null;
                }
            }
        }
    };

    PropertyObjectHolder.prototype.validate = function () {
        if (!this.isValid()) {
            validateRootObjectWrappers();

            if (!this.isValid()) {
                /*--- The object is still invalid, after the validation... ---*/
                return false;
            }
        }

        return true;
    };

    PropertyObjectHolder.prototype.isValid = function () {
        if (!this.rootObj || !this.pathExp || this.pathExp.length == 0 || !this.getterFn || !this.setterFn) {
            return false;
        }

        return true;
    };

	PropertyObjectHolder.prototype.getGetterFunction = function() {
	    var ret = angParser(this.pathExp);
		return ret;
	};

	PropertyObjectHolder.prototype.getSetterFunction = function () {
	    var getter = angParser(this.pathExp);
	    return getter.assign;
	};

	PropertyObjectHolder.prototype.getValue = function () {
	    var res = "";

	    if (this.isOfSimpleType()) {
	        if (this.validate()) {
	            res = this.getterFn(this.rootObj);
	        }
	    } else {
	        res = this.innerValue;
	    }

	    return res;
	};

	PropertyObjectHolder.prototype.setValue = function (val) {

	    this.innerValue = val;
	    this.applyInnerValueChanges();

	    if (this.isOfSimpleType()) {
	        if (this.validate()) {
	            var self = this;

	            if (isScope(self.rootObj)) {
	                /*--- Sometimes we should check the AngularJS scope's $$phase to ensure that we aren't already in middle of an $apply or a $digest process. 
	                      But, since our script runs outside of AngularJS, we don't have to be bothered on that issue. ---*/
	                self.rootObj.$apply(function () {
	                    self.setterFn(self.rootObj, val);
	                });
	            } else {
	                self.setterFn(self.rootObj, val);
	            }
	        }
	    }

	    if (this.isArray && val instanceof Array) {
	        if (this.validate()) {
	            var self = this;
	            var realArr = self.getterFn(self.rootObj);
	            if (realArr instanceof Array) {
	                var realArrOldLength = realArr.length;

	                if (val.length < realArrOldLength) {
	                    /*--- The new array's length is smaller than the old one... ---*/
	                    var lengthDiff = realArrOldLength - val.length;

	                    if (isScope(self.rootObj)) {
	                        self.rootObj.$apply(function () {
	                            realArr.splice(val.length, lengthDiff);
	                        });
	                    } else {
	                        realArr.splice(val.length, lengthDiff);
	                    }
	                } else if (val.length > realArrOldLength) {
	                    /*--- The new array's length is greater than the old one... ---*/

	                    /*--- Validate the new array's elements. ---*/
	                    var lengthDiff = val.length - realArrOldLength;
	                    for (var elemInx = lengthDiff; elemInx < val.length; elemInx++) {
	                        if (val[elemInx] instanceof PropertyObjectHolder) {
	                            val[elemInx].validateProperties(self.rootObj, self.pathExp + '[' + elemInx + ']');
	                        }
	                    }

	                    /*--- Apply Angular's changes. ---*/
	                    if (isScope(self.rootObj)) {
	                        self.rootObj.$apply();
	                    }
	                }
	            }
	        }

	    }

	};

	PropertyObjectHolder.prototype.subscribeForPropertyChange = function (propNotificationFunc) {

	    if (isScope(this.rootObj) && this.isValid()) {
	        if (this.watchDeregistrationFunc) {
	            /*--- De-register old watch. ---*/
	            this.watchDeregistrationFunc();
	        }

	        this.watchDeregistrationFunc = this.rootObj.$watch(this.pathExp, function (newValue, oldValue) {
	            propNotificationFunc();
	        });

	        return true;
	    } else {
	        this.pendingNotificationFunc = propNotificationFunc;
	    }

	    return false;
	};

	PropertyObjectHolder.prototype.subscribeForArrayChange = function (arrNotificationFunc) {

	    if (isScope(this.rootObj) && this.isValid()) {
	        if (this.watchDeregistrationFunc) {
	            /*--- De-register old watch. ---*/
	            this.watchDeregistrationFunc();
	        }

	        var self = this;
	        this.watchDeregistrationFunc = this.rootObj.$watchCollection(this.pathExp, function (newValue, oldValue) {
	            if (newValue instanceof Array && oldValue instanceof Array && newValue.length < oldValue.length) {
	                var lengthDiff = oldValue.length - newValue.length;
	                if (self.innerValue instanceof Array) {
	                    self.innerValue.splice(newValue.length, lengthDiff);
	                    self.applyInnerValueChanges();
	                }
	            }

	            arrNotificationFunc();
	        });

	        return true;
	    } else {
	        this.pendingNotificationFunc = arrNotificationFunc;
	    }

	    return false;
	};

	PropertyObjectHolder.prototype.hasPropertyObjectHolderProperties = function () {
	    if (!this.innerValue) {
	        return false;
	    }

	    for (var prop in this.innerValue) {
	        if (this.innerValue[prop] instanceof PropertyObjectHolder) {
	            return true;
	        }
	    }

	    return false;
	};

	PropertyObjectHolder.prototype.isOfSimpleType = function () {
	    if (this.isArray || this.hasPropertyObjectHolderProperties()) {
	        return false;
	    }

	    if (this.innerValue) {
	        return isSimpleType(this.innerValue);
	    }

	    return true;
	};

	PropertyObjectHolder.prototype.dispose = function () {
	    if (this.watchDeregistrationFunc) {
	        this.watchDeregistrationFunc();
	        this.watchDeregistrationFunc = null;
	    }

	    if (this.isArray) { 
	        /*--- Dispose PropertyObjectHolder elements of innerValue. ---*/
	        if (this.innerValue instanceof Array) {
	            for (var elemInx = 0; elemInx < this.innerValue.length; elemInx++) {
	                if (this.innerValue[elemInx] instanceof PropertyObjectHolder) {
	                    this.innerValue[elemInx].dispose();
	                }
	            }
	        }
	    } else {
	        /*--- Dispose PropertyObjectHolder properties of innerValue. ---*/
	        if (this.innerValue) {
	            for (var prop in this.innerValue) {
	                if (this.innerValue[prop] instanceof PropertyObjectHolder) {
	                    this.innerValue[prop].dispose();
	                }
	            }
	        }
	    }

	    this.innerValue = null;

	    this.pathExp = "";
	    this.rootObj = {};
	    this.getterFn = null;
	    this.setterFn = null;
	    this.pendingNotificationFunc = null;
	    this.watchDeregistrationFunc = null;
	};

	PropertyObjectHolder.prototype.applyInnerValueChanges = function () {
	    if (this.isArray && this.innerValue instanceof Array) {
	        if (!this.innerValueElementsShadow) {
	            this.innerValueElementsShadow = [];
	        }

	        var oldLength = this.innerValueElementsShadow.length;
	        var newLength = this.innerValue.length;

	        if (newLength > oldLength) {
	            /*--- New elements have been added - Add them to the shadow. ---*/
	            for (var elemInx = oldLength; elemInx < newLength; elemInx++) {
	                this.innerValueElementsShadow.push(this.innerValue[elemInx]);
	            }
	        } else if (newLength < oldLength) {
	            /*--- Elements have been removed - Dispose them. ---*/
	            var removedElements = this.innerValueElementsShadow.splice(newLength, oldLength - newLength);

	            for (var elemInx = 0; elemInx < removedElements.length; elemInx++) {
	                if (removedElements[elemInx] instanceof PropertyObjectHolder) {
	                    removedElements[elemInx].dispose();
	                } 
	            }
	        }
	    }
	};

	/*--- Original public functions ---*/
	wbObj.angImp_orgBeginServerChangesRequests = wbObj.beginServerChangesRequests;
	wbObj.angImp_orgAddBindingMapping = wbObj.addBindingMapping;
	wbObj.angImp_orgApplyBindings = wbObj.applyBindings;
	wbObj.angImp_orgCreateBoundObjectForPropertyPath = wbObj.createBoundObjectForPropertyPath;

	/*--- Overrided public functions ---*/
	wbObj.beginServerChangesRequests = function () {
	    isBeginServerChangesRequestsCalled = true;

	    if (!isDOMContentLoaded) {
	        /*--- The 'DOMContentLoaded' event hasn't been fired (and, AngularJS hasn't been loaded)... ---*/
	        return;
	    }

	    wbObj.angImp_orgBeginServerChangesRequests();
	};

	wbObj.addBindingMapping = function (bindingId, scopeGetter, bindingMappingObj) {
	    var reg = new BindingMappingRegistration(bindingId, scopeGetter, bindingMappingObj);
	    bindingMappingsRegistrations.push(reg);
	};

	wbObj.applyBindings = function () {
	    isApplyBindingsCalled = true;

	    if (!isDOMContentLoaded) {
	        /*--- The 'DOMContentLoaded' event hasn't been fired (and, AngularJS hasn't been loaded)... ---*/
	        return;
	    }

	    var bindingMappingsRegistrationsCount = bindingMappingsRegistrations.length;

	    for (var regInx = 0; regInx < bindingMappingsRegistrationsCount; regInx++) {
	        var reg = bindingMappingsRegistrations[regInx];

	        var scope = reg.scopeGetter();
	        if (scope) {
	            var rootObjWrapper = new RootObjectWrapper(scope);
	            rootObjectWrappers.push(rootObjWrapper);

	            wbObj.angImp_orgAddBindingMapping(reg.bindingId, rootObjWrapper.wrapperRootObj, reg.bindingMappingObj);
	        }
	    }

	    /*--- Clear binding-mappings registrations. ---*/
	    bindingMappingsRegistrations.splice(0, bindingMappingsRegistrationsCount);

	    wbObj.angImp_orgApplyBindings();
	};

	wbObj.createBoundObjectForPropertyPath = function (rootObj, _propPath_) {
	    var res = null;

	    for (var wrapperInx = 0; wrapperInx < rootObjectWrappers.length; wrapperInx++) {
	        var objWrapper = rootObjectWrappers[wrapperInx];
	        if (objWrapper instanceof RootObjectWrapper && objWrapper.orgRootObj === rootObj) {
	            objWrapper.retrieveBoundObjectForPropertyPath(_propPath_);
	        }
	    }

	    if (rootObj) {
	        var getter = angParser(_propPath_);
	        res = getter(rootObj);
	    }

	    return res;
	};

	/*--- Dedicate functions implementation ---*/
	wbObj.getObjectValue = function (objHolder) {
	    return objHolder.getValue();
	};

	wbObj.getArrayValue = function (arrHolder) {
	    return arrHolder.getValue();
	};

	wbObj.setObjectValue = function (objHolder, val) {
	    objHolder.setValue(val);
	};

	wbObj.setArrayValue = function (arrHolder, val) {
	    arrHolder.setValue(val);
	};

	wbObj.createObjectHolder = function () {
	    var res = new PropertyObjectHolder();
	    return res;
	};

	wbObj.createArrayHolder = function () {
	    var res = new PropertyObjectHolder();
	    res.isArray = true;
	    res.setValue([]);
	    return res;
	};

	wbObj.registerForPropertyChanges = function (objHolder, propNotificationFunc) {
	    objHolder.subscribeForPropertyChange(propNotificationFunc);
	};

	wbObj.registerForArrayChanges = function (arrHolder, arrNotificationFunc) {
	    arrHolder.subscribeForArrayChange(arrNotificationFunc);
	};
}
