﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using WebBinding;
using System.Text;
using System.Windows;
using System.Windows.Resources;
using System.IO;
using System.Text.RegularExpressions;

namespace WebBinding.Angular
{
    public class AngularBinderDefinitions : BinderDefinitions
    {
        private const string _originalApplyDedicateImplementationFunctionName = "WebBinding_ApplyAngularDedicateImplementation";

        public AngularBinderDefinitions()
        {
            ApplyDedicateImplementationFunctionName = "WebBinding_ApplyAngularDedicateImplementation";
        }

        #region Properties
        public string ApplyDedicateImplementationFunctionName { get; set; }
        #endregion

        #region BinderDefinitions implementation

        protected override string GetApplyDedicateImplementationScript()
        {
            StringBuilder sb = new StringBuilder();

            sb.AppendLine(GetDedicateImplementationScript());
            sb.AppendFormat("{0}({1});", ApplyDedicateImplementationFunctionName, BinderClientObjectName);

            return sb.ToString();
        }

        #endregion

        private string GetDedicateImplementationScript()
        {
            string res = string.Empty;

            Uri resUri = new Uri("/WebBinding.Angular;component/Scripts/AngularDedicateImplementation.js", UriKind.Relative);

            lock (ResourcesLocker)
            {
                StreamResourceInfo resInfo = Application.GetResourceStream(resUri);
                if (resInfo != null)
                {
                    using (StreamReader sr = new StreamReader(resInfo.Stream))
                    {
                        res = sr.ReadToEnd();
                    }
                }
            }

            res = Regex.Replace(res, _originalApplyDedicateImplementationFunctionName, ApplyDedicateImplementationFunctionName);

            if (MinimizeClientScript)
            {
                // Remove comments.
                res = Regex.Replace(res, "/\\*-{3}([\\r\\n]|.)*?-{3}\\*/", string.Empty);

                // Remove lines' spaces
                res = Regex.Replace(res, "[\\r\\n][\\r\\n \\t]*", string.Empty);

                // Remove additional spaces
                res = Regex.Replace(res, " ?([=\\+\\{\\},\\(\\)!\\?:\\>\\<\\|&\\]\\[-]) ?", "$1");
            }

            return res;
        }
    }
}