﻿<%@ Page Language="C#" Inherits="Demo.Classes.BaseErrorPage" MasterPageFile="~/Default.master" Theme="Omega" ValidateRequest="false" %>

<asp:Content ID="HtmlHeadContent" runat="server" ContentPlaceHolderID="HeadContent">
    
</asp:Content>

<asp:Content ID="HtmlTitleContent" runat="server" ContentPlaceHolderID="TitleContent">
    <div runat="server" id="BannerTitle" class="title">Exception Notice</div>
    <div class="blurb">Oops... an unexpected event has just occurred</div>
</asp:Content>

<asp:Content ID="HtmlBodyContent" runat="server" ContentPlaceHolderID="BodyContent">

    <asp:HiddenField runat="server" ID="StatusCode" Value="500" />
    <asp:HiddenField runat="server" ID="ReportTitle" />
    <asp:HiddenField runat="server" ID="ReportBody" />
    
    <h1><asp:Literal runat="server" ID="CrashReportTitle" /></h1>

    <p>
        <asp:Literal runat="server" ID="BrokenUrl" />
    </p>
	
    <p>
    Sorry, but the event that has just occurred was not expected by this system.
    </p>
            
    <p>
    An email message has already been sent to our Technical Services and Support team, notifying them of the issue.
    If this problem is not solved within the next two hours, please contact your system administrator to escalate its priority.
    </p>

    <h2>
    Next Steps
    </h2>
    
    <demo:NextStepsLinkList runat="server" ID="NextSteps" />

    <asp:Panel runat="server" ID="ErrorReportPanel">
	
    <h2>
    Quick Error Report
    </h2>

    <p>
    You can quickly report this exception notice by clicking the button below. After
    you click this button the page will reload and send us an email message with 
    the relevant details.
    </p>

    <asp:LinkButton runat="server" ID="SubmitQuickErrorReportButton" Text="Submit Quick Error Report" CssClass="button blue" />

    </asp:Panel>
		
    <script language='javascript'>
    function ToggleTechnicalInformationDisplay() 
    {
        var t = document.getElementById('TechnicalInformation');
        if (t.style.display == 'block') t.style.display = 'none';
        else t.style.display = 'block';
    }
    </script>

    <div id="TechnicalInformation" style="display:none; margin-top: 40px;">
        <h1>Technical Information</h1>
        <asp:Literal runat="server" ID="CrashReportBody" />
    </div>

</asp:Content>