﻿using System;
using System.Text;
using System.Web.Security;
using System.Web.UI;

namespace Demo.Classes
{
    public class NextStepsLinkList : Control
    {
        public Boolean EnableTechnicalInformation { get; set; }

        protected override void Render(HtmlTextWriter writer)
        {
            base.Render(writer);

            StringBuilder sb = new StringBuilder();

            sb.Append("<ul>");

            String url = AppSettingsHelper.GetValue("Application.HelpUrl",false);
            if (!String.IsNullOrEmpty(url))
                AppendLink( sb, "Submit a help request", url );

            AppendLink(sb, "Go to the home page", "/");

            url = AppSettingsHelper.GetValue("Application.SitemapUrl",false);
            if (!String.IsNullOrEmpty(url))
                AppendLink(sb, "Go to the sitemap page", url);

            AppendLink(sb, "Go to the login page", FormsAuthentication.LoginUrl);
            
            if (EnableTechnicalInformation)
                sb.Append("<li><a href=\"#\" onclick=\"ToggleTechnicalInformationDisplay();return false;\">View technical information</a></li>");

            sb.Append("</ul>");

            writer.Write(sb.ToString());
        }

        private void AppendLink(StringBuilder sb, String text, String url)
        {
            if (String.IsNullOrEmpty(text))
                return;

            sb.AppendFormat("<li><a href=\"{0}\">{1}</a></li>", url, text);
        }
    }
}