// version 0.1.2
// visit: http://oliver-j.github.io/jcolumn/
;(function ($, win, doc) { 'use strict';
    $.fn.jcolumn = function (options) { 
                
    var elements = this,
    
    defaults = {
        delay: 500,
        maxWidth: 767,
        callback: function (elemH) {}, // noop
        resize: true
    }, 
    
    settings = $.extend( {}, defaults, options),
    
    // otherwise the event would trigger the function to fast
    delay = (function () {
		var timer = 0;
	  	return function(callback, ms){
	    	clearTimeout(timer);
	    	timer = setTimeout(callback, ms);
	  	};
	})(), 

	resizeColumnHeight = function (columns) { 
		var elemH = 0,
            $this = null,
            $thisHeight = 0;
            
		if ($(doc).width() >= settings.maxWidth) {
            columns.each(function () {
			    $this = $(this);
			    $this.height('auto');
                $thisHeight = $this.height();
                
			    if ($thisHeight > elemH) {
				    elemH = $thisHeight;
			    }
		    });
            
			columns.each(function () {
				$(this).height(elemH);
			});
            
            settings.callback(elemH);   
		}
	},
    
    // wrapper function for init and event
    magic = function () { 
        delay(resizeColumnHeight(elements), settings.delay); 
    };
    
    if (settings.resize) {
	    win.addEventListener('resize', magic);
    }
    
    magic();
return this; };}(jQuery, window, document));