// version 0.1.2
// visit: http://oliver-j.github.io/jcolumn/
(function (window, document) { 'use strict';
    var jcolumn = function (options) {
        var defaults = {
            delay: 500,
            maxWidth: 767,
            callback: function (elemH) {}, // noop
            resize: true
        },
        
        settings = null,
        
        delay = (function () {
    		var timer = 0;
    	  	return function(callback, ms){
    	    	clearTimeout(timer);
    	    	timer = setTimeout(callback, ms);
    	  	};
        })(),
        
        // jquery height is still a bit small e.g.: jQuery width = 293.7
        getElemHeight = function (elem) {
            return parseFloat(window.getComputedStyle(elem).height);
        },
        
        resizeColumnHeight = function (columns) {
    		var elemH = 0,
                that = null,
                thatHeight = 0;
   
            // http://www.howtocreate.co.uk/tutorials/javascript/browserwindow
    		if (document.body.clientWidth >= settings.maxWidth) {
                for (var i = 0, len = columns.length; i < len; i++) {
                    that = columns[i];
    			    that.style.height = 'auto';
                    thatHeight = getElemHeight(that);

    			    if (thatHeight > elemH) {
    				    elemH = thatHeight;
    			    } 
    		    }

                for (i = 0; i < len; i++) {
                    that = columns[i];
    				that.style.height = elemH + 'px';
                }
            
                settings.callback(elemH);   
    		}
        },
        
        // support for this extend function ie8+
        extend = function (defaults, options) {
            var extended = {},
                prop = null;
        
            for (prop in defaults) {
                if (Object.prototype.hasOwnProperty.call(defaults, prop)) {
                    extended[prop] = defaults[prop];
                }
            }
            for (prop in options) {
                if (Object.prototype.hasOwnProperty.call(options, prop)) {
                    extended[prop] = options[prop];
                }
            }
            return extended;
        };
        
        settings = extend(defaults, options);
        
        this.jcolumn = function (cssClass) {
            var elements = document.getElementsByClassName(cssClass), 
            
            magic = function () {
                delay(resizeColumnHeight(elements), settings.delay); 
            };
            
            if (settings.resize) { 
	            window.addEventListener('resize', magic);
            }
            
            magic();
        };
    };
    
    window.jColumn = jcolumn;
}) (window, document);