# jColumn
jColumn is a lightweight JavaScript library to make selected html elements the same height.
It can be used as standalone JavaScript library or jQuery plugin.
Size: 556 Bytes 

### Without jColumn

![without jcolumn screenshot](http://oliverj.net/img/jqueryplugins/without-jcolumn.png)

### With jColumn
![with jcolumn screenshot](http://oliverj.net/img/jqueryplugins/with-jcolumn.png)

## Install
### Bower
```html
bower install jcolumn
```

### npm
```html
npm install jcolumn
```

### The oldschool way
#### Vanilla.js
```html
<script src="build/jcolumn-0.2.0.min.js" type="text/javascript" charset="utf-8"></script>
```

#### jQuery
Include the jcolumn-0.2.0.jquery.min.js script directly after [jQuery](http://jquery.com):

```html
<script src="build/jcolumn-0.2.0.jquery.min.js" type="text/javascript" charset="utf-8"></script>
```

## Usage
### Vanilla.js
Just create an instance of jColumn and invoke the method jcolumn.
The method takes a class name (without a point) as parameter.

```javascript
var col = new jColumn();
col.jcolumn('col');
```

#### Options

option   | default  | type      | Description
-------- | -------- | --------  | -------- 
delay    | 500      | number    | (optional) The delayed time after the resize happens
maxWidth | 767      | number    | (optional) Every document width smaller than maxWidth will not use jcolumn
resize   | true     | boolean   | (optional) Disable resize event with false
callback | null     | function  | (optional) A callback function which gets triggered after resize


```javascript
var col = new jColumn({
    delay: 500,
    maxWidth: 767,
    callback: function (height) {
        console.log('New max height is: ' + height);
    }
});
col.jcolumn('col');
```

### jQuery
Initialize the plugin by calling the jcolumn function on a class of columns.

```javascript
$('.col').jcolumn();
```

#### Options

option   | default  | type      | Description
-------- | -------- | --------  | -------- 
delay    | 500      | number    | (optional) The delayed time after the resize happens
maxWidth | 767      | number    | (optional) Every document width smaller than maxWidth will not use jcolumn
resize   | true     | boolean   | (optional) Disable resize event with false
callback | null     | function  | (optional) A callback function which gets triggered after resize


```javascript
$('.col').jcolumn({
    delay: 500,
    maxWidth: 767,
    callback: function (height) {
        console.log('New max height is: ' + height);
    }
});
```

## How to build your own version

If you would like to build your own version of jColumn, the only thing you need to do is to follow the steps below.

```javascript
$ cd jcolumn
$ npm install
$ grunt
```

### Author

Oliver Jessner [@oliverj_net](https://twitter.com/oliverj_net), [Website](http://oliverj.net) 

Copyright © 2015
