module.exports = function (grunt) {
  var jQuery = 'src/<%= pkg.name %>.jquery.dev.js', 
      vanilla = 'src/<%= pkg.name %>.dev.js',
      jQueryMin = 'build/<%= pkg.name %>-<%= pkg.version %>.jquery.min.js',
      vanillaMin = 'build/<%= pkg.name %>-<%= pkg.version %>.min.js';
    
    grunt.initConfig({
        pkg: grunt.file.readJSON('package.json'),

        jshint: {
            jquery: {
                src: [jQuery],
                options: { globals: { jQuery: true } }
             },
         
             vanilla: {
                 src: [vanilla],
                 options: { /* ... */ }
             }
        },
      
        uglify: {
            build: {
                options: {
                    banner: '/* <%= pkg.name %> <%= pkg.version %> license:<%= pkg.license %> */te',
                },
                files: [{
                    src: jQuery,
                    dest: jQueryMin
                },{
                    src: vanilla,
                    dest: vanillaMin
                }]
            }
        }
    });

    grunt.loadNpmTasks('grunt-contrib-jshint');
    grunt.loadNpmTasks('grunt-contrib-uglify');

    grunt.registerTask('default', [
        'jshint:jquery', 'jshint:vanilla', 
        'uglify'
    ]);
};