﻿using System.Security.Claims;
using System.Threading.Tasks;
using Microsoft.Owin.Security.Facebook;

namespace PersistentFacebookAuth
{
    public class MyFacebookAuthenticationProvider : FacebookAuthenticationProvider
    {
        public const string MyTokenClaimName = "my:FacebookToken";

        public override Task Authenticated(FacebookAuthenticatedContext context)
        {
            context.Identity.AddClaim(new Claim(MyTokenClaimName, context.AccessToken));
            return base.Authenticated(context);
        }
    }
}