﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Net;
using System.Threading.Tasks;
using System.Web;
using System.Web.Mvc;
using Facebook;
using Microsoft.AspNet.Identity.Owin;

namespace PersistentFacebookAuth.Controllers
{
    public class HomeController : Controller
    {
        public ActionResult Index()
        {
            var users = HttpContext.GetOwinContext().GetUserManager<ApplicationUserManager>().Users.Where(u => u.FacebookToken != null).ToList();
            if (users != null && users.Count > 0) ViewBag.Users = users;
            
            return View();
        }

        [HttpPost]
        public async Task<ActionResult> Upload(string userID)
        {
            if (Request.Files.Count > 0)
            {
                var selectedUser = await HttpContext.GetOwinContext().GetUserManager<ApplicationUserManager>().FindByIdAsync(userID);
                var facebookUserID = selectedUser.Logins.Where(u => u.LoginProvider == "Facebook").Select(u => u.ProviderKey).FirstOrDefault();
                var facebookUserToken = selectedUser.FacebookToken;

                var imgFile = Request.Files[0];

                if (imgFile != null && imgFile.ContentLength > 0)
                {
                    var pictureBytes = new byte[imgFile.ContentLength];
                    imgFile.InputStream.Read(pictureBytes, 0, imgFile.ContentLength);

                    await uploadToFacebook(facebookUserID, facebookUserToken, pictureBytes, Path.GetFileName(imgFile.FileName));

                    return Redirect("https://www.facebook.com/" + facebookUserID);
                }
            }

            return RedirectToAction("Index");
        }

        private async Task<bool> uploadToFacebook(string facebookUserID, string token, byte[] pictureBytes, string fileName)
        {
            ServicePointManager.SecurityProtocol = SecurityProtocolType.Tls;

            var mediaObj = new FacebookMediaObject
            {
                FileName = fileName,
                ContentType = "image/" + Path.GetExtension(fileName).Substring(1),
            };
            mediaObj.SetValue(pictureBytes);

            var args = new Dictionary<string, object>();
            args.Add("source", mediaObj);

            var client = new FacebookClient(token);
            await client.PostTaskAsync(string.Format("/{0}/photos", facebookUserID), args);

            return true;
        }

        public ActionResult About()
        {
            ViewBag.Message = "Your application description page.";

            return View();
        }

        public ActionResult Contact()
        {
            ViewBag.Message = "Your contact page.";

            return View();
        }
    }
}