﻿$(function () {

    var stockBroadcaster = $.connection.stockBroadcaster; // the generated client-side hub proxy, use the same name as that used in the StockBroadCasterHub HubName attribute

    function init() {

    }

    // Add a client-side hub method that the server will call to deliver the client updates on a given stock
    stockBroadcaster.client.updateStockPrice = function (stock) {
        //If you want to update a single stock, write your code here
    }

    // Add a client-side hub method that the server will call to deliver the client all the updated stocks
    stockBroadcaster.client.updateAllStocksPrices = function (stocks) {
        //clear all the tds with updated background
        $("td.updatedStockP").removeClass("updatedStockP");
        $("td.updatedStockN").removeClass("updatedStockN");

        $.each(stocks, function (index, stock) {//Loop through the stocks recieved from the server
            var stockSymbol = stock.Symbol; //Get the stock Symbol, we will assume it is unique, you can use other properties to get the uninque value, like an auto generated ID
            $('td').filter(function () {
                return $(this).text() === stockSymbol;//Use this to get only the td with a text equal to the stock symbol, then update its value and background color accordingly.
            }).next().html(stock.LastValue.toFixed(2)).addClass(stock.Change > 0 ? "updatedStockP" : "updatedStockN").next().html(stock.Change.toFixed(2)).addClass(stock.Change > 0 ? "updatedStockP" : "updatedStockN");

        });

    }

    // Start the connection
    $.connection.hub.start().done(init);

});