﻿using DataLayer;
using Microsoft.AspNet.SignalR;
using Microsoft.AspNet.SignalR.Hubs;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace WebParallelProgramming
{
    //The Hub class provides methods that allow clients to communicate with the server using SignalR connections connected to a Hub.
    [HubName("stockBroadcaster")]
    public class StockBroadcasterHub : Hub//Don't forget to inherit from the Hub class
    {
        private readonly StockBroadcaster _stockBroadcaster;

        public StockBroadcasterHub() : this(StockBroadcaster.Instance) { }

        public StockBroadcasterHub(StockBroadcaster stockBroadcaster)
        {
            _stockBroadcaster = stockBroadcaster;
        }

        public IEnumerable<Stock> GetAllStocks()
        {
            return _stockBroadcaster.GetAllStocks();
        }
    }
}