﻿using DataLayer;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace WebParallelProgramming
{
    public partial class _Default : Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            DateTime startDate = DateTime.Now;

            List<Stock> stocks = new List<Stock>();
            List<Stock> metals = new List<Stock>();
            List<Stock> money = new List<Stock>();

            Task t1 = new Task
(

    () =>
    {
        stocks = Stock.GetStocks();
    }
);

            Task t2 = new Task
(

    () =>
    {
        metals = Stock.GetPreciousMetals();
    }
);

            Task t3 = new Task
(

    () =>
    {
        money = Stock.GetMoneyStocks();
    }
);

            t1.Start();
            t2.Start();
            t3.Start();
            Task.WaitAll(t1, t2, t3);

            gvStocks.DataSource = stocks;
            gvStocks.DataBind();

            gvMetals.DataSource = metals;
            gvMetals.DataBind();

            gvMoney.DataSource = money;
            gvMoney.DataBind();

            TimeSpan span = (DateTime.Now - startDate);
            lblServerResponseTime.Text = string.Format("Server reponser time was: {0} seconds", span.Seconds);

        }
    }
}